-- MySQL dump 10.7
--
-- Host: localhost    Database: novo_db
-- ------------------------------------------------------
-- Server version	5.0.45-community-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT, CHARACTER_SET_CLIENT=latin1 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE="NO_AUTO_VALUE_ON_ZERO" */;

--
-- Table structure for table `acessorio`
--

DROP TABLE IF EXISTS `acessorio`;
CREATE TABLE `acessorio` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(35) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Acessorio_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Acessorio` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `acessorio`
--


/*!40000 ALTER TABLE `acessorio` DISABLE KEYS */;
LOCK TABLES `acessorio` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `acessorio` ENABLE KEYS */;

--
-- Table structure for table `ajuste`
--

DROP TABLE IF EXISTS `ajuste`;
CREATE TABLE `ajuste` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `TipoAjuste` enum('Dare Antecipado','Credito Presumido','Fundo PROLEITE') NOT NULL,
  `CodigoAjuste` varchar(10) NOT NULL,
  `Descricao` varchar(100) default NULL,
  `DescricaoComplementar` text,
  `Usar` tinyint(1) default '0',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ajuste`
--


/*!40000 ALTER TABLE `ajuste` DISABLE KEYS */;
LOCK TABLES `ajuste` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `ajuste` ENABLE KEYS */;

--
-- Table structure for table `apartamento`
--

DROP TABLE IF EXISTS `apartamento`;
CREATE TABLE `apartamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Venda_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaSolicitante_Id` int(11) NOT NULL,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Apartamento_Codigo` varchar(10) NOT NULL,
  `Quantidade` float(7,3) NOT NULL,
  `ValorVenda` float(12,2) NOT NULL,
  `Emissao` date NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `LojaSaidaEstoque_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Apartamento_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  KEY `Apartamento_FK_PessoaSolicitante` (`PessoaSolicitante_Id`),
  KEY `Apartamento_FK_Loja` (`Loja_Id`),
  KEY `Apartamento_FK_Venda` (`Venda_Id`),
  CONSTRAINT `FK_Loja_Apartamento` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaSolicitante_Apartamento` FOREIGN KEY (`PessoaSolicitante_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_Apartamento` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Venda_Apartamento` FOREIGN KEY (`Venda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `apartamento`
--


/*!40000 ALTER TABLE `apartamento` DISABLE KEYS */;
LOCK TABLES `apartamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `apartamento` ENABLE KEYS */;

--
-- Table structure for table `autorizacaousuario`
--

DROP TABLE IF EXISTS `autorizacaousuario`;
CREATE TABLE `autorizacaousuario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Autorizacao_Id` int(10) unsigned NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `Obs` varchar(30) default NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `autorizacaousuario`
--


/*!40000 ALTER TABLE `autorizacaousuario` DISABLE KEYS */;
LOCK TABLES `autorizacaousuario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `autorizacaousuario` ENABLE KEYS */;

--
-- Table structure for table `autorizados`
--

DROP TABLE IF EXISTS `autorizados`;
CREATE TABLE `autorizados` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Pessoa_Id` int(11) NOT NULL,
  `Nome` varchar(35) NOT NULL,
  `Validade` date default NULL,
  `Obs` varchar(50) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Autorizados_FK_Pessoa` (`Pessoa_Id`),
  CONSTRAINT `FK_Pessoa_Autorizados` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `autorizados`
--


/*!40000 ALTER TABLE `autorizados` DISABLE KEYS */;
LOCK TABLES `autorizados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `autorizados` ENABLE KEYS */;

--
-- Table structure for table `backuphistorico`
--

DROP TABLE IF EXISTS `backuphistorico`;
CREATE TABLE `backuphistorico` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `Obs` text NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `backuphistorico`
--


/*!40000 ALTER TABLE `backuphistorico` DISABLE KEYS */;
LOCK TABLES `backuphistorico` WRITE;
INSERT INTO `backuphistorico` (`Id`, `DataHoraGrav`, `Usuario_Id`, `Obs`) VALUES (1,'2009-08-19 01:20:32',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20090819012027.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(2,'2010-02-23 00:31:25',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100223003116.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(3,'2010-03-10 23:26:55',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100310232652.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(4,'2010-03-29 23:38:55',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100329233842.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(5,'2010-04-15 01:31:40',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100415013137.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(6,'2010-04-24 10:04:49',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100424100446.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(7,'2010-08-16 20:37:48',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100816203738.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(8,'2010-08-18 22:38:23',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: E:\\SGE\\Source\\Backup\\bkp_001_20100818223817.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(9,'2014-05-26 00:23:51',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: B:\\2013\\Flex\\Delphi7\\Apps\\SGE\\trunk\\Source\\Backup\\bkp_001_20140526002345.zip\r\nO arquivo foi copiado para a pasta a:\\bkp_001_20140526002345.zip\r\nNome do volume (Label): Arquivos\r\nNmero Serial: 56280816\r\nSistema de Arquivos: NTFS'),(10,'2016-05-10 17:55:22',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: B:\\2016\\Flex\\Delphi7\\Apps\\SGE\\Source\\Backup\\bkp_001_20160510175519.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(11,'2016-05-11 16:17:45',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: B:\\2016\\Flex\\Delphi7\\Apps\\SGE\\Source\\Backup\\bkp_001_20160511151108.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.'),(12,'2016-05-12 14:34:55',1,'Loja: Loja 1Usurio: root\r\nBackup Realizado!\r\nNome do arquivo: B:\\2016\\Flex\\Delphi7\\Apps\\SGE\\Source\\Backup\\bkp_001_20160512143453.zip\r\nO arquivo no foi copiado para outra pasta. Isto , o usurio efetuou somente uma cpia no prprio computador.');
UNLOCK TABLES;
/*!40000 ALTER TABLE `backuphistorico` ENABLE KEYS */;

--
-- Table structure for table `bairro`
--

DROP TABLE IF EXISTS `bairro`;
CREATE TABLE `bairro` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(35) NOT NULL,
  `Pontos` int(11) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `bai_nu_sequencial` int(10) unsigned default NULL,
  `loc_nu_sequencial` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Bairro_Unico` (`Nome`),
  KEY `Bairro_FKIndex1` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Bairro` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bairro`
--


/*!40000 ALTER TABLE `bairro` DISABLE KEYS */;
LOCK TABLES `bairro` WRITE;
INSERT INTO `bairro` (`Id`, `Loja_Id`, `Nome`, `Pontos`, `Usuario_Id`, `DataHoraGrav`, `bai_nu_sequencial`, `loc_nu_sequencial`) VALUES (1,1,'DESCONHECIDO',NULL,1,'2009-08-19 00:58:49',NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `bairro` ENABLE KEYS */;

--
-- Table structure for table `balanco`
--

DROP TABLE IF EXISTS `balanco`;
CREATE TABLE `balanco` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Produto_Id` int(11) NOT NULL,
  `Emissao` date NOT NULL,
  `Quantidade` float NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Balanco_FKIndex1` (`Produto_Id`),
  KEY `Balanco_FKIndex2` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Balanco` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Produto_Balanco` FOREIGN KEY (`Produto_Id`) REFERENCES `produto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `balanco`
--


/*!40000 ALTER TABLE `balanco` DISABLE KEYS */;
LOCK TABLES `balanco` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `balanco` ENABLE KEYS */;

--
-- Table structure for table `banco`
--

DROP TABLE IF EXISTS `banco`;
CREATE TABLE `banco` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Codigo` varchar(10) default NULL,
  `Nome` varchar(60) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Banco_Unico` (`Nome`),
  KEY `Banco_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Banco` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `banco`
--


/*!40000 ALTER TABLE `banco` DISABLE KEYS */;
LOCK TABLES `banco` WRITE;
INSERT INTO `banco` (`Id`, `Loja_Id`, `Codigo`, `Nome`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,'1','Banco Citicard S.A. ',1,'2009-08-19 00:31:57'),(2,1,'246','Banco ABC Brasil S.A. ',1,'2009-08-19 00:31:57'),(3,1,'356','Banco ABN AMRO Real S.A. ',1,'2009-08-19 00:31:57'),(4,1,'25','Banco Alfa S.A. ',1,'2009-08-19 00:31:57'),(5,1,'641','Banco Alvorada S.A. ',1,'2009-08-19 00:31:58'),(6,1,'29','Banco Banerj S.A. ',1,'2009-08-19 00:31:58'),(7,1,'38','Banco Banestado S.A. ',1,'2009-08-19 00:31:58'),(8,1,'','Banco Bankpar S.A. ',1,'2009-08-19 00:31:58'),(9,1,'740','Banco Barclays S.A. ',1,'2009-08-19 00:31:58'),(10,1,'107','Banco BBM S.A. ',1,'2009-08-19 00:31:58'),(11,1,'31','Banco Beg S.A. ',1,'2009-08-19 00:31:58'),(12,1,'36','Banco Bem S.A. ',1,'2009-08-19 00:31:58'),(13,1,'394','Banco BMC S.A. ',1,'2009-08-19 00:31:58'),(14,1,'318','Banco BMG S.A. ',1,'2009-08-19 00:31:58'),(15,1,'752','Banco BNP Paribas Brasil S.A. ',1,'2009-08-19 00:31:58'),(16,1,'248','Banco Boavista Interatlntico S.A. ',1,'2009-08-19 00:31:58'),(17,1,'237','Banco Bradesco S.A. ',1,'2009-08-19 00:31:58'),(18,1,'225','Banco Brascan S.A. ',1,'2009-08-19 00:31:58'),(19,1,'263','Banco Cacique S.A. ',1,'2009-08-19 00:31:58'),(20,1,'222','Banco Calyon Brasil S.A. ',1,'2009-08-19 00:31:58'),(21,1,'40','Banco Cargill S.A. ',1,'2009-08-19 00:31:58'),(22,1,'745','Banco Citibank S.A. ',1,'2009-08-19 00:31:58'),(23,1,'215','Banco Comercial e de Investimento Sudameris S.A. ',1,'2009-08-19 00:31:59'),(24,1,'756','Banco Cooperativo do Brasil S.A. - BancoOB ',1,'2009-08-19 00:31:59'),(25,1,'748','Banco Cooperativo Sicredi S.A. - BANSICREDI ',1,'2009-08-19 00:31:59'),(26,1,'505','Banco Credit Suisse (Brasil) S.A. ',1,'2009-08-19 00:31:59'),(27,1,'229','Banco Cruzeiro do Sul S.A. ',1,'2009-08-19 00:31:59'),(28,1,'3','Banco da Amaznia S.A. ',1,'2009-08-19 00:31:59'),(29,1,'707','Banco Daycoval S.A. ',1,'2009-08-19 00:31:59'),(30,1,'','Banco de Lage Landen Brasil S.A. ',1,'2009-08-19 00:32:00'),(31,1,'24','Banco de Pernambuco S.A. - BANDEPE ',1,'2009-08-19 00:32:00'),(32,1,'456','Banco de Tokyo-Mitsubishi UFJ Brasil S.A. ',1,'2009-08-19 00:32:00'),(33,1,'214','Banco Dibens S.A. ',1,'2009-08-19 00:32:00'),(34,1,'1','Banco do Brasil S.A. ',1,'2009-08-19 00:32:00'),(35,1,'27','Banco do Estado de Santa Catarina S.A. ',1,'2009-08-19 00:32:00'),(36,1,'33','Banco do Estado de So Paulo S.A. - Banespa ',1,'2009-08-19 00:32:00'),(37,1,'47','Banco do Estado de Sergipe S.A. ',1,'2009-08-19 00:32:00'),(38,1,'37','Banco do Estado do Par S.A. ',1,'2009-08-19 00:32:00'),(39,1,'41','Banco do Estado do Rio Grande do Sul S.A. ',1,'2009-08-19 00:32:00'),(40,1,'4','Banco do Nordeste do Brasil S.A. ',1,'2009-08-19 00:32:00'),(41,1,'265','Banco Fator S.A. ',1,'2009-08-19 00:32:00'),(42,1,'','Banco Fiat S.A. ',1,'2009-08-19 00:32:00'),(43,1,'224','Banco Fibra S.A. ',1,'2009-08-19 00:32:00'),(44,1,'175','Banco Finasa S.A. ',1,'2009-08-19 00:32:00'),(45,1,'252','Banco Fininvest S.A. ',1,'2009-08-19 00:32:01'),(46,1,'233','Banco GE Capital S.A. ',1,'2009-08-19 00:32:01'),(47,1,'734','Banco Gerdau S.A. ',1,'2009-08-19 00:32:01'),(48,1,'','Banco GMAC S.A. ',1,'2009-08-19 00:32:01'),(49,1,'612','Banco Guanabara S.A. ',1,'2009-08-19 00:32:01'),(50,1,'63','Banco Ibi S.A. Banco Mltiplo ',1,'2009-08-19 00:32:01'),(51,1,'604','Banco Industrial do Brasil S.A. ',1,'2009-08-19 00:32:01'),(52,1,'320','Banco Industrial e Comercial S.A. ',1,'2009-08-19 00:32:01'),(53,1,'653','Banco Indusval S.A. ',1,'2009-08-19 00:32:01'),(54,1,'630','Banco Intercap S.A. ',1,'2009-08-19 00:32:01'),(55,1,'249','Banco Investcred UniBanco S.A. ',1,'2009-08-19 00:32:01'),(56,1,'184-8','Banco Ita BBA S.A. ',1,'2009-08-19 00:32:01'),(57,1,'652','Banco Ita Holding Financeira S.A. ',1,'2009-08-19 00:32:01'),(58,1,'341','Banco Ita S.A. ',1,'2009-08-19 00:32:01'),(59,1,'479','Banco ItaBank S.A ',1,'2009-08-19 00:32:01'),(60,1,'','Banco Itaucred Financiamentos S.A. ',1,'2009-08-19 00:32:01'),(61,1,'','Banco Itausaga S.A. ',1,'2009-08-19 00:32:01'),(62,1,'376','Banco J. P. Morgan S.A. ',1,'2009-08-19 00:32:01'),(63,1,'74','Banco J. Safra S.A. ',1,'2009-08-19 00:32:01'),(64,1,'757','Banco KEB do Brasil S.A. ',1,'2009-08-19 00:32:01'),(65,1,'600','Banco Luso Brasileiro S.A. ',1,'2009-08-19 00:32:01'),(66,1,'392','Banco Mercantil de So Paulo S.A. ',1,'2009-08-19 00:32:01'),(67,1,'389','Banco Mercantil do Brasil S.A. ',1,'2009-08-19 00:32:01'),(68,1,'755','Banco Merrill Lynch de Investimentos S.A. ',1,'2009-08-19 00:32:01'),(69,1,'151','Banco Nossa Caixa S.A. ',1,'2009-08-19 00:32:01'),(70,1,'45','Banco Opportunity S.A. ',1,'2009-08-19 00:32:01'),(71,1,'208','Banco Pactual S.A. ',1,'2009-08-19 00:32:01'),(72,1,'623','Banco Panamericano S.A. ',1,'2009-08-19 00:32:01'),(73,1,'611','Banco Paulista S.A. ',1,'2009-08-19 00:32:01'),(74,1,'643','Banco Pine S.A. ',1,'2009-08-19 00:32:01'),(75,1,'638','Banco Prosper S.A. ',1,'2009-08-19 00:32:01'),(76,1,'747','Banco Rabobank International Brasil S.A. ',1,'2009-08-19 00:32:01'),(77,1,'633','Banco Rendimento S.A. ',1,'2009-08-19 00:32:02'),(78,1,'72','Banco Rural Mais S.A. ',1,'2009-08-19 00:32:02'),(79,1,'453','Banco Rural S.A. ',1,'2009-08-19 00:32:02'),(80,1,'422','Banco Safra S.A. ',1,'2009-08-19 00:32:02'),(81,1,'8','Banco Santander Banespa S.A. ',1,'2009-08-19 00:32:02'),(82,1,'353','Banco Santander Brasil S.A. ',1,'2009-08-19 00:32:02'),(83,1,'351','Banco Santander S.A. ',1,'2009-08-19 00:32:02'),(84,1,'250','Banco Schahin S.A. ',1,'2009-08-19 00:32:02'),(85,1,'749','Banco Simples S.A. ',1,'2009-08-19 00:32:02'),(86,1,'366','Banco Socit Gnrale Brasil S.A. ',1,'2009-08-19 00:32:02'),(87,1,'637','Banco Sofisa S.A. ',1,'2009-08-19 00:32:02'),(88,1,'347','Banco Sudameris Brasil S.A. ',1,'2009-08-19 00:32:02'),(89,1,'464','Banco Sumitomo Mitsui Brasileiro S.A. ',1,'2009-08-19 00:32:02'),(90,1,'634','Banco Tringulo S.A. ',1,'2009-08-19 00:32:02'),(91,1,'247','Banco UBS S.A. ',1,'2009-08-19 00:32:02'),(92,1,'116','Banco nico S.A. ',1,'2009-08-19 00:32:02'),(93,1,'655','Banco Votorantim S.A. ',1,'2009-08-19 00:32:02'),(94,1,'610','Banco VR S.A. ',1,'2009-08-19 00:32:02'),(95,1,'370','Banco WestLB do Brasil S.A. ',1,'2009-08-19 00:32:02'),(96,1,'21','BANESTES S.A. Banco do Estado do Esprito Santo ',1,'2009-08-19 00:32:02'),(97,1,'719','Banif-Banco Internacional do Funchal (Brasil)S.A. ',1,'2009-08-19 00:32:02'),(98,1,'744','BankBoston N.A. ',1,'2009-08-19 00:32:02'),(99,1,'204','Bankpar Banco Multiplo S.A.. ',1,'2009-08-19 00:32:02'),(100,1,'073-6','BB Banco Popular do Brasil S.A. ',1,'2009-08-19 00:32:02'),(101,1,'','BES Investimento do Brasil S.A.-Banco de Investimento',1,'2009-08-19 00:32:02'),(102,1,'069-8','BPN Brasil Banco Mtiplo S.A. ',1,'2009-08-19 00:32:02'),(103,1,'70','BRB - Banco de Braslia S.A. ',1,'2009-08-19 00:32:02'),(104,1,'104','Caixa Econmica Federal ',1,'2009-08-19 00:32:02'),(105,1,'477','Citibank N.A. ',1,'2009-08-19 00:32:02'),(106,1,'487','Deutsche Bank S.A. - Banco Alemo ',1,'2009-08-19 00:32:02'),(107,1,'751','Dresdner Bank Brasil S.A. - Banco Mltiplo ',1,'2009-08-19 00:32:02'),(108,1,'210','Dresdner Bank Lateinamerika Aktiengesellschaft ',1,'2009-08-19 00:32:02'),(109,1,'62','Hipercard Banco Mltiplo S.A. ',1,'2009-08-19 00:32:02'),(110,1,'399','HSBC Bank Brasil S.A. - Banco Mltiplo ',1,'2009-08-19 00:32:03'),(111,1,'492','ING Bank N.V. ',1,'2009-08-19 00:32:03'),(112,1,'488','JPMorgan Chase Bank ',1,'2009-08-19 00:32:03'),(113,1,'65','Lemon Bank Banco Mltiplo S.A. ',1,'2009-08-19 00:32:03'),(114,1,'409','UNIBanco - Unio de Bancos Brasileiros S.A. ',1,'2009-08-19 00:32:03'),(115,1,'230','Unicard Banco Mltiplo S.A. ',1,'2009-08-19 00:32:03');
UNLOCK TABLES;
/*!40000 ALTER TABLE `banco` ENABLE KEYS */;

--
-- Table structure for table `beneficiamentocafe`
--

DROP TABLE IF EXISTS `beneficiamentocafe`;
CREATE TABLE `beneficiamentocafe` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaProdutor_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Codigo` varchar(5) default NULL,
  `Classificacao` enum('Beneficiamento','Transferncia') default NULL,
  `TotalSacas` float(10,2) default NULL,
  `KilosAdicionais` float(10,2) default NULL,
  `Renda` float(10,2) default NULL,
  `Sacaria` float(10,2) default NULL,
  `Secagem` float(10,2) default NULL,
  `Mensalidade` float(10,2) default NULL,
  `QtdSecador` int(10) unsigned default NULL,
  `ValorVenda` float(12,2) default NULL,
  `Obs` text,
  `Confirmado` tinyint(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `BeneficiamentoCafe_UN_Codigo` (`Codigo`),
  KEY `BeneficiamentoCafe_FK_Produtor` (`PessoaProdutor_Id`),
  KEY `BeneficiamentoCafe_FK_Loja` (`Loja_Id`),
  KEY `BeneficiamentoCafe_FKIndex3` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_Loja_BeneficiamentoCafe` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_BeneficiamentoCafe` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_BeneficiamentoCafe` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `beneficiamentocafe`
--


/*!40000 ALTER TABLE `beneficiamentocafe` DISABLE KEYS */;
LOCK TABLES `beneficiamentocafe` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `beneficiamentocafe` ENABLE KEYS */;

--
-- Table structure for table `beneficiamentocafebaixa`
--

DROP TABLE IF EXISTS `beneficiamentocafebaixa`;
CREATE TABLE `beneficiamentocafebaixa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `BeneficiamentoCafe_Id` int(10) unsigned NOT NULL,
  `DataBaixa` date default NULL,
  `Quantidade` float(12,3) default NULL,
  `Valor` float(12,2) default NULL,
  `Tipo` enum('Venda','Transferencia','Retirada') default NULL,
  `Obs` varchar(30) default NULL,
  `Confirmado` tinyint(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BeneficiamentoCafeBaixa_FKIndex1` (`BeneficiamentoCafe_Id`),
  CONSTRAINT `Rel_525` FOREIGN KEY (`BeneficiamentoCafe_Id`) REFERENCES `beneficiamentocafe` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `beneficiamentocafebaixa`
--


/*!40000 ALTER TABLE `beneficiamentocafebaixa` DISABLE KEYS */;
LOCK TABLES `beneficiamentocafebaixa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `beneficiamentocafebaixa` ENABLE KEYS */;

--
-- Table structure for table `bk100apuracao`
--

DROP TABLE IF EXISTS `bk100apuracao`;
CREATE TABLE `bk100apuracao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DataInicial` date NOT NULL,
  `DataFinal` date NOT NULL,
  `DataHoraFechamento` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk100apuracao`
--


/*!40000 ALTER TABLE `bk100apuracao` DISABLE KEYS */;
LOCK TABLES `bk100apuracao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk100apuracao` ENABLE KEYS */;

--
-- Table structure for table `bk200estoqueescriturado`
--

DROP TABLE IF EXISTS `bk200estoqueescriturado`;
CREATE TABLE `bk200estoqueescriturado` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_EST` date NOT NULL,
  `COD_ITEM` int(10) unsigned NOT NULL,
  `QTD` float(12,3) NOT NULL,
  `IND_EST` char(1) default NULL,
  `COD_PART` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK200EstoqueEscriturado_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_K200` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk200estoqueescriturado`
--


/*!40000 ALTER TABLE `bk200estoqueescriturado` DISABLE KEYS */;
LOCK TABLES `bk200estoqueescriturado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk200estoqueescriturado` ENABLE KEYS */;

--
-- Table structure for table `bk210desmitemorigem`
--

DROP TABLE IF EXISTS `bk210desmitemorigem`;
CREATE TABLE `bk210desmitemorigem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_INI_OS` date default NULL,
  `DT_FIM_OS` date default NULL,
  `COD_DOC_OS` varchar(10) default NULL,
  `COD_ITEM_ORI` int(10) unsigned default NULL,
  `QTD_ORI` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK210DesmItemOrigem_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_DesmItemOrigem` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk210desmitemorigem`
--


/*!40000 ALTER TABLE `bk210desmitemorigem` DISABLE KEYS */;
LOCK TABLES `bk210desmitemorigem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk210desmitemorigem` ENABLE KEYS */;

--
-- Table structure for table `bk215desmitemdestino`
--

DROP TABLE IF EXISTS `bk215desmitemdestino`;
CREATE TABLE `bk215desmitemdestino` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DesmItemOrigem_Id` int(10) unsigned NOT NULL,
  `COD_ITEM_DES` varchar(10) default NULL,
  `QTD_DES` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK215DesmItemDestino_FK_DesmItemOrigem` (`DesmItemOrigem_Id`),
  CONSTRAINT `FK_DesmItemOrigem_DesmItemDestino` FOREIGN KEY (`DesmItemOrigem_Id`) REFERENCES `bk210desmitemorigem` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk215desmitemdestino`
--


/*!40000 ALTER TABLE `bk215desmitemdestino` DISABLE KEYS */;
LOCK TABLES `bk215desmitemdestino` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk215desmitemdestino` ENABLE KEYS */;

--
-- Table structure for table `bk220outrasmovimentacoes`
--

DROP TABLE IF EXISTS `bk220outrasmovimentacoes`;
CREATE TABLE `bk220outrasmovimentacoes` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_MOV` date default NULL,
  `COD_ITEM_ORI` int(10) unsigned default NULL,
  `COD_ITEM_DEST` int(10) unsigned default NULL,
  `QTD` float(12,3) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BKOutrasMovimentacoes_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_K220` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk220outrasmovimentacoes`
--


/*!40000 ALTER TABLE `bk220outrasmovimentacoes` DISABLE KEYS */;
LOCK TABLES `bk220outrasmovimentacoes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk220outrasmovimentacoes` ENABLE KEYS */;

--
-- Table structure for table `bk230itemproduzido`
--

DROP TABLE IF EXISTS `bk230itemproduzido`;
CREATE TABLE `bk230itemproduzido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_INI_OP` date default NULL,
  `DT_FIN_OP` date default NULL,
  `COD_DOC_OP` int(10) unsigned default NULL,
  `COD_ITEM` int(10) unsigned default NULL,
  `QTD_ENC` float(12,3) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BKItemProduzido_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_K230` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk230itemproduzido`
--


/*!40000 ALTER TABLE `bk230itemproduzido` DISABLE KEYS */;
LOCK TABLES `bk230itemproduzido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk230itemproduzido` ENABLE KEYS */;

--
-- Table structure for table `bk235insumoconsumido`
--

DROP TABLE IF EXISTS `bk235insumoconsumido`;
CREATE TABLE `bk235insumoconsumido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ItemProduzido_Id` int(10) unsigned NOT NULL,
  `DT_SAIDA` date default NULL,
  `COD_ITEM` int(10) unsigned default NULL,
  `QTD` float(12,3) default NULL,
  `COD_INS_SUBST` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BKInsumoConsumido_FK_ItemProduzido` (`ItemProduzido_Id`),
  CONSTRAINT `FK_K230_K235` FOREIGN KEY (`ItemProduzido_Id`) REFERENCES `bk230itemproduzido` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk235insumoconsumido`
--


/*!40000 ALTER TABLE `bk235insumoconsumido` DISABLE KEYS */;
LOCK TABLES `bk235insumoconsumido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk235insumoconsumido` ENABLE KEYS */;

--
-- Table structure for table `bk250indterceiro`
--

DROP TABLE IF EXISTS `bk250indterceiro`;
CREATE TABLE `bk250indterceiro` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_PROD` date default NULL,
  `COD_ITEM` int(10) unsigned default NULL,
  `QTD` float(12,3) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK250IndTerceiro_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_K250` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk250indterceiro`
--


/*!40000 ALTER TABLE `bk250indterceiro` DISABLE KEYS */;
LOCK TABLES `bk250indterceiro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk250indterceiro` ENABLE KEYS */;

--
-- Table structure for table `bk255indtercinsumoconsumido`
--

DROP TABLE IF EXISTS `bk255indtercinsumoconsumido`;
CREATE TABLE `bk255indtercinsumoconsumido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `IndTerceiro_Id` int(10) unsigned NOT NULL,
  `DT_CONS` date NOT NULL,
  `COD_ITEM` int(10) unsigned NOT NULL,
  `QTD` float(12,3) NOT NULL,
  `COD_INS_SUBST` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK255IndTercInsumoConsumido_FK_IndTerceiro` (`IndTerceiro_Id`),
  CONSTRAINT `FK_K250_K255` FOREIGN KEY (`IndTerceiro_Id`) REFERENCES `bk250indterceiro` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk255indtercinsumoconsumido`
--


/*!40000 ALTER TABLE `bk255indtercinsumoconsumido` DISABLE KEYS */;
LOCK TABLES `bk255indtercinsumoconsumido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk255indtercinsumoconsumido` ENABLE KEYS */;

--
-- Table structure for table `bk260reprocess`
--

DROP TABLE IF EXISTS `bk260reprocess`;
CREATE TABLE `bk260reprocess` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `COD_OP_OS` varchar(10) default NULL,
  `COD_ITEM` varchar(10) default NULL,
  `DT_SAIDA` date default NULL,
  `QTD_SAIDA` decimal(12,6) default NULL,
  `DT_RET` date default NULL,
  `QTD_RET` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK260Reprocess_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Reprocess` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk260reprocess`
--


/*!40000 ALTER TABLE `bk260reprocess` DISABLE KEYS */;
LOCK TABLES `bk260reprocess` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk260reprocess` ENABLE KEYS */;

--
-- Table structure for table `bk265reprocessretorno`
--

DROP TABLE IF EXISTS `bk265reprocessretorno`;
CREATE TABLE `bk265reprocessretorno` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Reprocess_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD_CONS` decimal(12,6) default NULL,
  `QTD_RET` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK265ReprocessRetorno_FK_Reprocess` (`Reprocess_Id`),
  CONSTRAINT `FK_Reprocess_Retorno` FOREIGN KEY (`Reprocess_Id`) REFERENCES `bk260reprocess` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk265reprocessretorno`
--


/*!40000 ALTER TABLE `bk265reprocessretorno` DISABLE KEYS */;
LOCK TABLES `bk265reprocessretorno` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk265reprocessretorno` ENABLE KEYS */;

--
-- Table structure for table `bk270correcaoapontamento`
--

DROP TABLE IF EXISTS `bk270correcaoapontamento`;
CREATE TABLE `bk270correcaoapontamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_INI_AP` date default NULL,
  `DT_FIM_AP` date default NULL,
  `COD_OP_OS` varchar(10) default NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD_COR_POS` decimal(12,6) default NULL,
  `QTD_COR_NEG` decimal(12,6) default NULL,
  `ORIGEM` varchar(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK270CorrecaoApontamento_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_CorrecaoApontamento` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk270correcaoapontamento`
--


/*!40000 ALTER TABLE `bk270correcaoapontamento` DISABLE KEYS */;
LOCK TABLES `bk270correcaoapontamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk270correcaoapontamento` ENABLE KEYS */;

--
-- Table structure for table `bk275correcaoretorno`
--

DROP TABLE IF EXISTS `bk275correcaoretorno`;
CREATE TABLE `bk275correcaoretorno` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CorrecaoApontamento_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD_COR_POS` decimal(12,6) default NULL,
  `QTD_COR_NEG` decimal(12,6) default NULL,
  `COD_INS_SUBST` varchar(10) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK275CorrecaoRetorno_FK_CorrecaoApontamento` (`CorrecaoApontamento_Id`),
  CONSTRAINT `CorrecaoApontamento_Retorno` FOREIGN KEY (`CorrecaoApontamento_Id`) REFERENCES `bk270correcaoapontamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk275correcaoretorno`
--


/*!40000 ALTER TABLE `bk275correcaoretorno` DISABLE KEYS */;
LOCK TABLES `bk275correcaoretorno` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk275correcaoretorno` ENABLE KEYS */;

--
-- Table structure for table `bk280correcaoapontestoque`
--

DROP TABLE IF EXISTS `bk280correcaoapontestoque`;
CREATE TABLE `bk280correcaoapontestoque` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_EST` date default NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD_COD_POS` decimal(12,6) default NULL,
  `QTD_COR_NEG` decimal(12,6) default NULL,
  `IND_EST` varchar(1) default NULL,
  `COD_PART` varchar(10) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK280CorrecaoApontEstoque_FK_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_CorrecaoApontEstoque` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk280correcaoapontestoque`
--


/*!40000 ALTER TABLE `bk280correcaoapontestoque` DISABLE KEYS */;
LOCK TABLES `bk280correcaoapontestoque` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk280correcaoapontestoque` ENABLE KEYS */;

--
-- Table structure for table `bk290prodconjordemproducao`
--

DROP TABLE IF EXISTS `bk290prodconjordemproducao`;
CREATE TABLE `bk290prodconjordemproducao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_INI_OP` date default NULL,
  `DT_FIM_OP` date default NULL,
  `COD_DOC_OP` varchar(10) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK290ProdConjOrdemProducao_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_ProdConjOrdemProducao` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk290prodconjordemproducao`
--


/*!40000 ALTER TABLE `bk290prodconjordemproducao` DISABLE KEYS */;
LOCK TABLES `bk290prodconjordemproducao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk290prodconjordemproducao` ENABLE KEYS */;

--
-- Table structure for table `bk291prodconjitemproduzido`
--

DROP TABLE IF EXISTS `bk291prodconjitemproduzido`;
CREATE TABLE `bk291prodconjitemproduzido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdConjOrdemProducao_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK291ProdConjItemProduzido_FK_ProdConjOrdemProducao` (`ProdConjOrdemProducao_Id`),
  CONSTRAINT `FK_ProdConjOP_ItemProduzido` FOREIGN KEY (`ProdConjOrdemProducao_Id`) REFERENCES `bk290prodconjordemproducao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk291prodconjitemproduzido`
--


/*!40000 ALTER TABLE `bk291prodconjitemproduzido` DISABLE KEYS */;
LOCK TABLES `bk291prodconjitemproduzido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk291prodconjitemproduzido` ENABLE KEYS */;

--
-- Table structure for table `bk292prodconjinsumos`
--

DROP TABLE IF EXISTS `bk292prodconjinsumos`;
CREATE TABLE `bk292prodconjinsumos` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdConjOrdemProducao_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK292ProdConjInsumos_FK_ProdConjOrdemProducao` (`ProdConjOrdemProducao_Id`),
  CONSTRAINT `Rel_724` FOREIGN KEY (`ProdConjOrdemProducao_Id`) REFERENCES `bk290prodconjordemproducao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk292prodconjinsumos`
--


/*!40000 ALTER TABLE `bk292prodconjinsumos` DISABLE KEYS */;
LOCK TABLES `bk292prodconjinsumos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk292prodconjinsumos` ENABLE KEYS */;

--
-- Table structure for table `bk300prodconjterceiro`
--

DROP TABLE IF EXISTS `bk300prodconjterceiro`;
CREATE TABLE `bk300prodconjterceiro` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Apuracao_Id` int(10) unsigned NOT NULL,
  `DT_PROD` date default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK300ProdConjTerceiro_Apuracao` (`Apuracao_Id`),
  CONSTRAINT `FK_Apuracao_ProdConjTerceiro` FOREIGN KEY (`Apuracao_Id`) REFERENCES `bk100apuracao` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk300prodconjterceiro`
--


/*!40000 ALTER TABLE `bk300prodconjterceiro` DISABLE KEYS */;
LOCK TABLES `bk300prodconjterceiro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk300prodconjterceiro` ENABLE KEYS */;

--
-- Table structure for table `bk301prodconjterceiroitem`
--

DROP TABLE IF EXISTS `bk301prodconjterceiroitem`;
CREATE TABLE `bk301prodconjterceiroitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdConjTerceiro_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD` decimal(12,6) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK301ProdConjTerceiroItem_FK_ProdConjTerceiro` (`ProdConjTerceiro_Id`),
  CONSTRAINT `FK_ProdConjTerceiro_Item` FOREIGN KEY (`ProdConjTerceiro_Id`) REFERENCES `bk300prodconjterceiro` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk301prodconjterceiroitem`
--


/*!40000 ALTER TABLE `bk301prodconjterceiroitem` DISABLE KEYS */;
LOCK TABLES `bk301prodconjterceiroitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk301prodconjterceiroitem` ENABLE KEYS */;

--
-- Table structure for table `bk302prodconjterceiroinsumo`
--

DROP TABLE IF EXISTS `bk302prodconjterceiroinsumo`;
CREATE TABLE `bk302prodconjterceiroinsumo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdConjTerceiro_Id` int(10) unsigned NOT NULL,
  `COD_ITEM` varchar(10) default NULL,
  `QTD` decimal(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `BK302ProdConjTerceiroInsumo_FK_ProdConjTerceiro` (`ProdConjTerceiro_Id`),
  CONSTRAINT `FK_ProdConjTerceiro_Insumo` FOREIGN KEY (`ProdConjTerceiro_Id`) REFERENCES `bk300prodconjterceiro` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `bk302prodconjterceiroinsumo`
--


/*!40000 ALTER TABLE `bk302prodconjterceiroinsumo` DISABLE KEYS */;
LOCK TABLES `bk302prodconjterceiroinsumo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `bk302prodconjterceiroinsumo` ENABLE KEYS */;

--
-- Table structure for table `caixa`
--

DROP TABLE IF EXISTS `caixa`;
CREATE TABLE `caixa` (
  `Id` int(11) NOT NULL auto_increment,
  `CaixaGeral_Id` int(10) unsigned default NULL COMMENT 'Depois que este campo estiver preenchido o caixa estar fechado.',
  `Conta_Id` int(11) NOT NULL COMMENT 'Conta Caixa',
  `Loja_Id` int(11) NOT NULL,
  `Codigo` varchar(10) default NULL,
  `TipoCaixa` enum('Carteira','Banco') default NULL,
  `Abertura` date NOT NULL,
  `PrevisaoFechamento` date default NULL,
  `Fechamento` datetime default NULL,
  `Saldo` double(15,3) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Obs` text,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Caixa_DataUnica` (`Loja_Id`,`Conta_Id`,`Abertura`),
  KEY `Caixa_FK_Loja` (`Loja_Id`),
  KEY `Caixa_FK_Conta` (`Conta_Id`),
  KEY `Caixa_FK_CaixaGeral` (`CaixaGeral_Id`),
  CONSTRAINT `FK_CaixaGeral_CaixaComum` FOREIGN KEY (`CaixaGeral_Id`) REFERENCES `caixageral` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta_Caixa` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Caixa` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COMMENT='Ao fechar o caixa, o sistema buscar o mes e ano atual do ca';

--
-- Dumping data for table `caixa`
--


/*!40000 ALTER TABLE `caixa` DISABLE KEYS */;
LOCK TABLES `caixa` WRITE;
INSERT INTO `caixa` (`Id`, `CaixaGeral_Id`, `Conta_Id`, `Loja_Id`, `Codigo`, `TipoCaixa`, `Abertura`, `PrevisaoFechamento`, `Fechamento`, `Saldo`, `Usuario_Id`, `DataHoraGrav`, `Obs`) VALUES (1,NULL,1,1,'1-1',NULL,'2010-08-18',NULL,NULL,NULL,1,'2010-08-18 22:36:25',NULL),(2,NULL,1,1,'2-1',NULL,'2014-11-19',NULL,NULL,NULL,1,'2014-11-19 10:26:43',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixa` ENABLE KEYS */;

--
-- Table structure for table `caixacontagem`
--

DROP TABLE IF EXISTS `caixacontagem`;
CREATE TABLE `caixacontagem` (
  `Caixa_Id` int(11) NOT NULL,
  `CedulaUm` int(10) unsigned default NULL,
  `CedulaDois` int(10) unsigned default NULL,
  `CedulaCinco` int(10) unsigned default NULL,
  `CedulaDez` int(10) unsigned default NULL,
  `CedulaVinte` int(10) unsigned default NULL,
  `CedulaCinquenta` int(10) unsigned default NULL,
  `CedulaCem` int(10) unsigned default NULL,
  `MoedaUmCentavo` int(10) unsigned default NULL,
  `MoedaCincoCentavos` int(10) unsigned default NULL,
  `MoedaDezCentavos` int(10) unsigned default NULL,
  `MoedaVinteCincoCentavos` int(10) unsigned default NULL,
  `MoedaCinquentaCentavos` int(10) unsigned default NULL,
  `MoedaCemCentavos` int(10) unsigned default NULL,
  `TotalRedeCard` float(12,2) default NULL,
  `TotalVisaNet` float(12,2) default NULL,
  `TotalCheques` float(12,2) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Caixa_Id`),
  KEY `CaixaContagem_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_Contagem` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixacontagem`
--


/*!40000 ALTER TABLE `caixacontagem` DISABLE KEYS */;
LOCK TABLES `caixacontagem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixacontagem` ENABLE KEYS */;

--
-- Table structure for table `caixageral`
--

DROP TABLE IF EXISTS `caixageral`;
CREATE TABLE `caixageral` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Mes` enum('01','02','03','04','05','06','07','08','09','10','11','12') default NULL,
  `Ano` year(4) default NULL,
  `Saldo` float(12,2) default NULL,
  `Fechado` date default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixageral`
--


/*!40000 ALTER TABLE `caixageral` DISABLE KEYS */;
LOCK TABLES `caixageral` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixageral` ENABLE KEYS */;

--
-- Table structure for table `caixamovimento`
--

DROP TABLE IF EXISTS `caixamovimento`;
CREATE TABLE `caixamovimento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CentroCusto_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `TipoGasto_Id` int(10) unsigned default NULL,
  `Emissao` date default NULL,
  `Historico` varchar(50) default NULL,
  `Documento` varchar(10) default NULL,
  `Valor` float(12,2) default NULL,
  `Operacao` char(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Saldo` float(12,2) default NULL,
  `SomenteLeitura` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CaixaMovimento_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `CaixaMovimento_FK_Loja` (`Loja_Id`),
  KEY `CaixaMovimento_FK_CentroCusto` (`CentroCusto_Id`),
  CONSTRAINT `FK_CentroCusto_CaixaMovimento` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_CaixaMovimento` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_CaixaMovimento` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixamovimento`
--


/*!40000 ALTER TABLE `caixamovimento` DISABLE KEYS */;
LOCK TABLES `caixamovimento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixamovimento` ENABLE KEYS */;

--
-- Table structure for table `caixasangria`
--

DROP TABLE IF EXISTS `caixasangria`;
CREATE TABLE `caixasangria` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Obs` varchar(255) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CaixaSangria_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_Sangria` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixasangria`
--


/*!40000 ALTER TABLE `caixasangria` DISABLE KEYS */;
LOCK TABLES `caixasangria` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixasangria` ENABLE KEYS */;

--
-- Table structure for table `caixasuprimento`
--

DROP TABLE IF EXISTS `caixasuprimento`;
CREATE TABLE `caixasuprimento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Obs` varchar(255) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CaixaSuprimento_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_Suprimento` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixasuprimento`
--


/*!40000 ALTER TABLE `caixasuprimento` DISABLE KEYS */;
LOCK TABLES `caixasuprimento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixasuprimento` ENABLE KEYS */;

--
-- Table structure for table `caixatransfer`
--

DROP TABLE IF EXISTS `caixatransfer`;
CREATE TABLE `caixatransfer` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `CaixaDestino_Id` int(11) NOT NULL,
  `CaixaOrigem_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Obs` varchar(255) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Entidade` varchar(30) default NULL,
  `Entidade_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CaixaTransfer_FK_CaixaOrigem` (`CaixaOrigem_Id`),
  KEY `CaixaTransfer_FK_CaixaDestino` (`CaixaDestino_Id`),
  KEY `CaixaTransfer_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Caixa_TransferDestino` FOREIGN KEY (`CaixaDestino_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Caixa_TransferOrigem` FOREIGN KEY (`CaixaOrigem_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_CaixaTransfer` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixatransfer`
--


/*!40000 ALTER TABLE `caixatransfer` DISABLE KEYS */;
LOCK TABLES `caixatransfer` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixatransfer` ENABLE KEYS */;

--
-- Table structure for table `caixavigencia`
--

DROP TABLE IF EXISTS `caixavigencia`;
CREATE TABLE `caixavigencia` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Vigencia` date default NULL,
  `EmAtividade` tinyint(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `CaixaVigencia_DataUnica` (`Vigencia`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `caixavigencia`
--


/*!40000 ALTER TABLE `caixavigencia` DISABLE KEYS */;
LOCK TABLES `caixavigencia` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `caixavigencia` ENABLE KEYS */;

--
-- Table structure for table `cartacobranca`
--

DROP TABLE IF EXISTS `cartacobranca`;
CREATE TABLE `cartacobranca` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `PessoaCliente_Id` int(11) NOT NULL,
  `CartaCobrancaModelo_Id` int(10) unsigned NOT NULL,
  `Emissao` date NOT NULL,
  `DadosCartaCobranca` text NOT NULL,
  `Confirmado` tinyint(1) NOT NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CartaCobranca_FK_Modelo` (`CartaCobrancaModelo_Id`),
  KEY `CartaCobranca_FK_Cliente` (`PessoaCliente_Id`),
  KEY `CartaCobranca_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_CartaCobranca` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Modelo_CartaCobranca` FOREIGN KEY (`CartaCobrancaModelo_Id`) REFERENCES `cartacobrancamodelo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_CartaCobranca` FOREIGN KEY (`PessoaCliente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cartacobranca`
--


/*!40000 ALTER TABLE `cartacobranca` DISABLE KEYS */;
LOCK TABLES `cartacobranca` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cartacobranca` ENABLE KEYS */;

--
-- Table structure for table `cartacobrancamodelo`
--

DROP TABLE IF EXISTS `cartacobrancamodelo`;
CREATE TABLE `cartacobrancamodelo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Descricao` varchar(50) NOT NULL,
  `Texto` text NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CartaCobrancaModelo_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_CartaCobrancaModelo` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cartacobrancamodelo`
--


/*!40000 ALTER TABLE `cartacobrancamodelo` DISABLE KEYS */;
LOCK TABLES `cartacobrancamodelo` WRITE;
INSERT INTO `cartacobrancamodelo` (`Id`, `Loja_Id`, `Descricao`, `Texto`, `DataHoraGrav`, `Usuario_Id`) VALUES (1,1,'Modelo da Implemaq','{\\rtf1\\ansi\\ansicpg1252\\deff0{\\fonttbl{\\f0\\fnil\\fcharset0 Times New Roman;}{\\f1\\fnil Times New Roman;}}\r\n\\viewkind4\\uc1\\pard\\lang1033\\f0\\fs24 Ji-Paran\\\'e1 - RO, <<<1.2.CartaEmissao>>>\\par\r\n\\par\r\n\\par\r\n\\par\r\n\\b <<<1.3.4.7.Tratamento>>> <<<1.3.2.NomeCompleto>>>\\b0\\par\r\n<<<1.3.9.CidadeUF>>>\\par\r\n\\par\r\nNosso controle de pagamento acusa, em seu cadastro, presta\\\'e7\\\'e3o vencida h\\\'e1 mais de 30 dias, motivo pelo qual pedimos a V. Sa. sua imediata regulariza\\\'e7\\\'e3o.\\par\r\n\\par\r\nTendo em vista que a emiss\\\'e3o deste aviso \\\'e9 autom\\\'e1tica, por computador, caso V. Sa. j\\\'e1 tenha pago at\\\'e9 a data da entrega do mesmo, solicitamos inutiliz\\\'e1-lo.\\par\r\n\\par\r\n\\par\r\n\\ul\\b Obs.: Sujeito a envio para SERASA e SPC\\ulnone\\b0\\par\r\n\\par\r\n\\par\r\nAtenciosamente,\\par\r\n\\par\r\n\\par\r\nFulano de Tal\\par\r\nDepto Cobran\\\'e7a.\\par\r\n\\lang1046\\f1\\par\r\n}\r\n\0','2009-03-14 22:19:27',1),(2,1,'Modelo SEBRAE','{\\rtf1\\ansi\\ansicpg1252\\deff0{\\fonttbl{\\f0\\froman\\fcharset0 Times New Roman;}{\\f1\\fnil Times New Roman;}}\r\n\\viewkind4\\uc1\\pard\\sb100\\sa100\\lang1046\\i\\f0\\fs24 Ji-Paran\\\'e1 - RO, <<<3.1.CartaEmissaoExtenso>>>\\i0\\par\r\n<<<1.3.4.7.Tratamento>>><<<1.3.2.NomeCompleto>>>\\line <<<1.3.6.Logradouro>>>, <<<1.3.7.LogradouroNumero>>> - <<<1.3.8.Bairro>>>, <<<1.3.9.CidadeUF>>>\\line\\par\r\nPrezado(a) Senhor(a)\\par\r\nVimos pela presente informar a V.sa. que se encontra em aberto, junto \\\'e0 nossa empresa, um d\\\'e9bito n\\\'e3o quitado representado por:\\line <<<2.1.ListaContasReceber>>>\\line Tendo em vista que at\\\'e9 o presente momento n\\\'e3o acusamos o recebimento de referida presta\\\'e7\\\'e3o, solicitamos a V.sa. a quita\\\'e7\\\'e3o desta ou seu comparecimento em nosso estabelecimento a fim de regularizar tal pend\\\'eancia no prazo m\\\'e1ximo de ............ dias.\\par\r\nInformamos ainda que a n\\\'e3o regulariza\\\'e7\\\'e3o de referida pend\\\'eancia no prazo acima estabelecido ensejar\\\'e1 a tomada das seguintes provid\\\'eancias legais:\\par\r\n- encaminhamento de vosso nome ao servi\\\'e7o de prote\\\'e7\\\'e3o ao cr\\\'e9dito;\\line - protesto do t\\\'edtulo;\\line - propositura da competente a\\\'e7\\\'e3o judicial para o recebimento do valor principal, acrescido de juros legais, mora al\\\'e9m dos honor\\\'e1rios advocat\\\'edcios, fixados neste ato em 20% do valor da causa.\\par\r\nDesta forma, a fim de evitar-se tal situa\\\'e7\\\'e3o, reiteramos o pedido no sentido promover a quita\\\'e7\\\'e3o da referida d\\\'edvida ou ent\\\'e3o o seu comparecimento em nosso estabelecimento no prazo m\\\'e1ximo de .... dias a fim de resolvermos tal pend\\\'eancia.\\par\r\nInformamos ainda que V. Sa. encontra-se constitu\\\'eddo em mora para todos os efeitos legais a partir do recebimento da presente notifica\\\'e7\\\'e3o, conforme os termos do artigo 397 da Lei 10.406/02.\\par\r\nSolicitamos a V.sa. desconsiderar a presente caso o referido d\\\'e9bito j\\\'e1 tenha sido quitado.\\par\r\nRespeitosamente,\\par\r\n_________________\\line NOME DA EMPRESA<<<4.1.RazaoSocial>>><<<4.2.NomeFantasia>>>\\par\r\nBoris Hermanson\\line Consultor Sebrae-SP\\line Outubro/2008\\par\r\n\\pard\\f1\\par\r\n}\r\n\0','2009-03-14 22:53:33',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `cartacobrancamodelo` ENABLE KEYS */;

--
-- Table structure for table `cartao`
--

DROP TABLE IF EXISTS `cartao`;
CREATE TABLE `cartao` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `ContaRecebida_Id` int(11) NOT NULL,
  `ContaPaga_Id` int(11) NOT NULL,
  `CartaoBandeira_Id` int(11) NOT NULL,
  `Numero` varchar(15) default NULL,
  `Operacao` enum('Credito','Debito') default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Cartao_FK_CartaoBandeira` (`CartaoBandeira_Id`),
  KEY `Cartao_FK_ContaPaga` (`ContaPaga_Id`),
  KEY `Cartao_FK_ContaRecebida` (`ContaRecebida_Id`),
  KEY `Cartao_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_CartaoBandeira_Cartao` FOREIGN KEY (`CartaoBandeira_Id`) REFERENCES `cartaobandeira` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaPaga_Cartao` FOREIGN KEY (`ContaPaga_Id`) REFERENCES `contapaga` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaRecebida_Cartao` FOREIGN KEY (`ContaRecebida_Id`) REFERENCES `contarecebida` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Cartao` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cartao`
--


/*!40000 ALTER TABLE `cartao` DISABLE KEYS */;
LOCK TABLES `cartao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cartao` ENABLE KEYS */;

--
-- Table structure for table `cartaobandeira`
--

DROP TABLE IF EXISTS `cartaobandeira`;
CREATE TABLE `cartaobandeira` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(25) NOT NULL,
  `Imagem` blob,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `CartaoBandeira_Unico` (`Nome`),
  KEY `CartaoBandeira_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_CartaoBandeira` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cartaobandeira`
--


/*!40000 ALTER TABLE `cartaobandeira` DISABLE KEYS */;
LOCK TABLES `cartaobandeira` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cartaobandeira` ENABLE KEYS */;

--
-- Table structure for table `centrocusto`
--

DROP TABLE IF EXISTS `centrocusto`;
CREATE TABLE `centrocusto` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Descricao` varchar(30) NOT NULL,
  `Inativo` tinyint(1) default '0' COMMENT 'No aparecer na consulta',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CentroCusto_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_CentroCusto` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `centrocusto`
--


/*!40000 ALTER TABLE `centrocusto` DISABLE KEYS */;
LOCK TABLES `centrocusto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `centrocusto` ENABLE KEYS */;

--
-- Table structure for table `certificadosanitario`
--

DROP TABLE IF EXISTS `certificadosanitario`;
CREATE TABLE `certificadosanitario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `NFe_Id` int(10) unsigned NOT NULL,
  `NumeroFormulario` varchar(10) default NULL,
  `TipoFormulario` enum('Certificado Sanitrio','Guia de Trnsito') default NULL,
  `DataAssinatura` date NOT NULL,
  `Confirmado` tinyint(1) default '0',
  `Usuario` varchar(25) NOT NULL,
  `PontoEmbarque` varchar(35) NOT NULL,
  `MarcaLetreiro` varchar(35) default NULL,
  `EstabelecimentoOrigem` varchar(35) default NULL,
  `MeioTransporte` varchar(35) default NULL,
  `HoraLacracaoVeiculo` time default NULL,
  `Remetente` varchar(35) default NULL,
  `Consignatario` varchar(35) default NULL,
  `Embarcador` varchar(35) default NULL,
  `Destino` varchar(35) default NULL,
  `NumeroLacre` varchar(10) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `CertificadoSanitario_NumeroFormulario` (`TipoFormulario`,`NumeroFormulario`),
  KEY `CertificadoSanitario_FK_NFe` (`NFe_Id`),
  CONSTRAINT `FK_NFe_CertificadoSanitario` FOREIGN KEY (`NFe_Id`) REFERENCES `nfe` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `certificadosanitario`
--


/*!40000 ALTER TABLE `certificadosanitario` DISABLE KEYS */;
LOCK TABLES `certificadosanitario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `certificadosanitario` ENABLE KEYS */;

--
-- Table structure for table `certificadosanitarioitem`
--

DROP TABLE IF EXISTS `certificadosanitarioitem`;
CREATE TABLE `certificadosanitarioitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CertificadoSanitario_Id` int(10) unsigned NOT NULL,
  `VendaItem_Id` int(10) unsigned default NULL,
  `NumeroVolumes` float(12,2) default NULL,
  `NaturezaVolumes` varchar(20) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CertificadoSanitarioItem_FK_CertificadoSanitario` (`CertificadoSanitario_Id`),
  CONSTRAINT `FK_CertificadoSanitario_Item` FOREIGN KEY (`CertificadoSanitario_Id`) REFERENCES `certificadosanitario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `certificadosanitarioitem`
--


/*!40000 ALTER TABLE `certificadosanitarioitem` DISABLE KEYS */;
LOCK TABLES `certificadosanitarioitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `certificadosanitarioitem` ENABLE KEYS */;

--
-- Table structure for table `cest`
--

DROP TABLE IF EXISTS `cest`;
CREATE TABLE `cest` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CEST` varchar(7) default NULL,
  `NCM` varchar(8) default NULL,
  `Descricao` varchar(255) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1117 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cest`
--


/*!40000 ALTER TABLE `cest` DISABLE KEYS */;
LOCK TABLES `cest` WRITE;
INSERT INTO `cest` (`Id`, `CEST`, `NCM`, `Descricao`) VALUES (98,'0104300','84254200','Macacos'),(99,'0104400','84311010','Partes para macacos do item 43.0'),(100,'0104500','8431492','Partes reconhecveis como exclusiva ou principalmente destinadas s mquinas agrcolas ou rodovirias'),(101,'0104500','84339090','Partes reconhecveis como exclusiva ou principalmente destinadas s mquinas agrcolas ou rodovirias'),(102,'0104600','84811000','Vlvulas redutoras de presso'),(103,'0104700','84812','Vlvulas para transmisso leo-hidrulicas ou pneumticas'),(104,'0104800','84818092','Vlvulas solenides'),(105,'0104900','8482','Rolamentos'),(106,'0105000','8483','rvores de transmisso (includas as rvores de \"cames\"e virabrequins) e manivelas; mancais e \"bronzes\"; engrenagens e rodas de frico; eixos de esferas ou de roletes; redutores, multiplicadores, caixas de transmisso e variadores de velocidade, includo'),(107,'0105100','8484','Juntas metaloplsticas; jogos ou sortidos de juntas de composies diferentes, apresentados em bolsas, envelopes ou embalagens semelhantes; juntas de vedao mecnicas (selos mecnicos)'),(108,'0105200','850520','Acoplamentos, embreagens, variadores de velocidade e freios, eletromagnticos'),(109,'0105300','85071000','Acumuladores eltricos de chumbo, do tipo utilizado para o arranque dos motores de pisto'),(110,'0105400','8511','Aparelhos e dispositivos eltricos de ignio ou de arranque para motores de ignio por centelha ou por compresso (por exemplo, magnetos, dnamos-magnetos, bobinas de ignio, velas de ignio ou de aquecimento, motores de arranque); geradores (dnamos'),(111,'0105500','851220','Aparelhos eltricos de iluminao ou de sinalizao (exceto os da posio 8539), limpadores de para-brisas, degeladores e desembaadores (desembaciadores) eltricos'),(112,'0105500','851240','Aparelhos eltricos de iluminao ou de sinalizao (exceto os da posio 8539), limpadores de para-brisas, degeladores e desembaadores (desembaciadores) eltricos'),(113,'0105500','85129000','Aparelhos eltricos de iluminao ou de sinalizao (exceto os da posio 8539), limpadores de para-brisas, degeladores e desembaadores (desembaciadores) eltricos'),(114,'0105600','85171213','Telefones mveis'),(115,'0105700','8518','Alto-falantes, amplificadores eltricos de audiofrequncia e partes'),(116,'0105800','85185000','Aparelhos eltricos de amplificao de som para veculos automotores'),(117,'0105900','851981','Aparelhos de reproduo de som'),(118,'0106000','8525501','Aparelhos transmissores (emissores) de radiotelefonia ou radiotelegrafia (rdio receptor/transmissor)'),(119,'0106000','85256010','Aparelhos transmissores (emissores) de radiotelefonia ou radiotelegrafia (rdio receptor/transmissor)'),(120,'0106100','85272','Aparelhos receptores de radiodifuso que s funcionam com fonte externa de energia, exceto os classificados na posio 8527.21.90'),(121,'0106200','85272190','Outros aparelhos receptores de radiodifuso que funcionem com fonte externa de energia; outros aparelhos videofnicos de gravao ou de reproduo, mesmo incorporando um receptor de sinais videofnicos, dos tipos utilizados exclusivamente em veculos auto'),(122,'0106200','85219090','Outros aparelhos receptores de radiodifuso que funcionem com fonte externa de energia; outros aparelhos videofnicos de gravao ou de reproduo, mesmo incorporando um receptor de sinais videofnicos, dos tipos utilizados exclusivamente em veculos auto'),(123,'0106300','85291090','Antenas'),(124,'0106400','85340000','Circuitos impressos'),(125,'0106500','853530','Interruptores e seccionadores e comutadores'),(126,'0106500','853650','Interruptores e seccionadores e comutadores'),(127,'0106600','85361000','Fusveis e corta-circuitos de fusveis'),(128,'0106700','85362000','Disjuntores'),(129,'0106800','85364','Rels'),(130,'0106900','8538','Partes reconhecveis como exclusivas ou principalmente destinados aos aparelhos dos itens 65.0, 66.0, 67.0 e 68.0'),(131,'0107000','85365090','Interruptores, seccionadores e comutadores'),(132,'0107100','853910','Faris e projetores, em unidades seladas'),(133,'0107200','85392','Lmpadas e tubos de incandescncia, exceto de raios ultravioleta ou infravermelhos'),(134,'0107300','85442000','Cabos coaxiais e outros condutores eltricos coaxiais'),(135,'0107400','85443000','Jogos de fios para velas de ignio e outros jogos de fios'),(136,'0107500','8707','Carroarias para os veculos automveis das posies 8701 a 8705, includas as cabinas'),(137,'0107600','8708','Partes e acessrios dos veculos automveis das posies 8701 a 8705'),(138,'0107700','87141','Parte e acessrios de motocicletas (includos os ciclomotores)'),(139,'0107800','87169090','Engates para reboques e semi-reboques'),(140,'0107900','902610','Medidores de nvel; Medidores de vazo'),(141,'0108000','902620','Aparelhos para medida ou controle da presso'),(142,'0108100','9029','Contadores, indicadores de velocidade e tacmetros, suas partes e acessrios'),(143,'0108200','90303321','Ampermetros'),(144,'0108300','90318040','Aparelhos digitais, de uso em veculos automveis, para medida e indicao de mltiplas grandezas tais como: velocidade mdia, consumos instantneo e mdio e autonomia (computador de bordo)'),(145,'0108400','9032892','Controladores eletrnicos'),(146,'0108500','91040000','Relgios para painis de instrumentos e relgios semelhantes'),(147,'0108600','94012000','Assentos e partes de assentos'),(148,'0108600','94019090','Assentos e partes de assentos'),(149,'0108700','96138000','Acendedores'),(150,'0108800','4009','Tubos de borracha vulcanizada no endurecida, mesmo providos de seus acessrios'),(151,'0108900','45049000','Juntas de vedao de cortia natural e de amianto'),(152,'0108900','68129910','Juntas de vedao de cortia natural e de amianto'),(153,'0109000','48234000','Papel-diagrama para tacgrafo, em disco'),(154,'0109100','39191000','Fitas, tiras, adesivos, auto-colantes, de plstico, refletores, mesmo em rolos; placas metlicas com pelcula de plstico refletora, prprias para colocao em carrocerias, para-choques de veculos de carga, motocicletas, ciclomotores, capacetes, bons de'),(155,'0109100','39199000','Fitas, tiras, adesivos, auto-colantes, de plstico, refletores, mesmo em rolos; placas metlicas com pelcula de plstico refletora, prprias para colocao em carrocerias, para-choques de veculos de carga, motocicletas, ciclomotores, capacetes, bons de'),(156,'0109100','87082999','Fitas, tiras, adesivos, auto-colantes, de plstico, refletores, mesmo em rolos; placas metlicas com pelcula de plstico refletora, prprias para colocao em carrocerias, para-choques de veculos de carga, motocicletas, ciclomotores, capacetes, bons de'),(157,'0109200','84123110','Cilindros pneumticos'),(158,'0109300','84131900','Bomba eltrica de lavador de para-brisa'),(159,'0109300','84135090','Bomba eltrica de lavador de para-brisa'),(160,'0109300','84138100','Bomba eltrica de lavador de para-brisa'),(161,'0109400','84136019','Bomba de assistncia de direo hidrulica'),(162,'0109400','84137010','Bomba de assistncia de direo hidrulica'),(163,'0109500','84145910','Motoventiladores'),(164,'0109500','84145990','Motoventiladores'),(165,'0109600','84213990','Filtros de plen do ar-condicionado'),(166,'0109700','85011019','\"Mquina\" de vidro eltrico de porta'),(167,'0109800','85013110','Motor de limpador de para-brisa'),(168,'0109900','85045000','Bobinas de reatncia e de auto-induo'),(169,'0110000','850720','Baterias de chumbo e de nquel-cdmio'),(170,'0110000','850730','Baterias de chumbo e de nquel-cdmio'),(171,'0110100','85123000','Aparelhos de sinalizao acstica (buzina)'),(172,'0110200','9032898','Instrumentos para regulao de grandezas no eltricas'),(173,'0110200','9032899','Instrumentos para regulao de grandezas no eltricas'),(174,'0110300','90271000','Analisadores de gases ou de fumaa (sonda lambda)'),(175,'0110400','40081100','Perfilados de borracha vulcanizada no endurecida'),(176,'0110500','56012219','Artefatos de pasta de fibra de uso automotivo'),(177,'0110600','57032000','Tapetes/carpetes - nailn'),(178,'0110700','57033000','Tapetes de matrias txteis sintticas'),(179,'0110800','59119000','Forrao interior capacete'),(180,'0110900','69039099','Outros para-brisas'),(181,'0111000','70072900','Moldura com espelho'),(182,'0111100','73145000','Corrente de transmisso'),(183,'0111200','73151100','Corrente transmisso'),(184,'0111300','73151210','Outras correntes de transmisso'),(185,'0111400','84189900','Condensador tubular metlico'),(186,'0111500','841950','Trocadores de calor'),(187,'0111600','84249090','Partes de aparelhos mecnicos de pulverizar ou dispersar'),(188,'0111700','84254910','Macacos manuais para veculos'),(189,'0111800','84314100','Caambas, ps, ganchos e tenazes para mquinas rodovirias'),(190,'0111900','85016100','Geradores de corrente alternada de potncia no superior a 75 kva'),(191,'0112000','85311090','Aparelhos eltricos para alarme de uso automotivo'),(192,'0112100','90141000','Bssolas'),(193,'0112200','90251990','Indicadores de temperatura'),(194,'0112300','90259010','Partes de indicadores de temperatura'),(195,'0200400','22084000','Cachaa e aguardentes'),(196,'0200500','2205','Catuaba e similares'),(197,'0200500','22060090','Catuaba e similares'),(198,'0200500','22089000','Catuaba e similares'),(199,'0200600','22082000','Conhaque, brandy e similares'),(200,'0200700','22060090','Cooler'),(201,'0200700','22089000','Cooler'),(202,'0200800','22085000','Gim (gin) e genebra'),(203,'0200900','2205','Jurubeba e similares'),(204,'0200900','22060090','Jurubeba e similares'),(205,'0200900','22089000','Jurubeba e similares'),(206,'0201000','22087000','Licores e similares'),(207,'0201100','22082000','Pisco'),(208,'0201200','22084000','Rum'),(209,'0201300','22060090','Saque'),(210,'0201400','22089000','Steinhaeger'),(211,'0201500','22089000','Tequila'),(212,'0201600','220830','Usque'),(213,'0201700','2205','Vermute e similares'),(214,'0201800','22086000','Vodka'),(215,'0201900','22089000','Derivados de vodka'),(216,'0202000','22089000','Arak'),(217,'0202100','22082000','Aguardente vnica / grappa'),(218,'0202200','22060010','Sidra e similares'),(219,'0202300','2205','Sangrias e coquetis'),(220,'0202300','22060090','Sangrias e coquetis'),(221,'0202300','22089000','Sangrias e coquetis'),(222,'0202400','2204','Vinhos e similares'),(223,'0202500','2204','Outras bebidas alcolicas no especificadas nos itens anteriores'),(224,'0202500','2205','Outras bebidas alcolicas no especificadas nos itens anteriores'),(225,'0202500','2206','Outras bebidas alcolicas no especificadas nos itens anteriores'),(226,'0202500','2207','Outras bebidas alcolicas no especificadas nos itens anteriores'),(227,'0202500','2208','Outras bebidas alcolicas no especificadas nos itens anteriores'),(228,'0300100','2201','gua mineral, gasosa ou no, ou potvel, naturais, em garrafa de vidro, retornvel ou no, com capacidade de at 500 ml'),(229,'0300200','2201','gua mineral, gasosa ou no, ou potvel, naturais, em embalagem com capacidade igual ou superior a 5.000 ml'),(230,'0300300','2201','gua mineral, gasosa ou no, ou potvel, naturais, em embalagem de vidro, no retornvel, com capacidade de at 300 ml'),(231,'0300400','2201','gua mineral, gasosa ou no, ou potvel, naturais, em garrafa plstica de 1.500 ml'),(232,'0300500','2201','gua mineral, gasosa ou no, ou potvel, naturais, em copos plsticos e embalagem plstica com capacidade de at 500 ml'),(233,'0300600','2201','Outras guas minerais, gasosa ou no, ou potvel, naturais, inclusive gaseificada ou aromatizada artificialmente'),(234,'0300600','2202','Outras guas minerais, gasosa ou no, ou potvel, naturais, inclusive gaseificada ou aromatizada artificialmente'),(235,'0300700','2202','Refrigerante em garrafa com capacidade igual ou superior a 600 ml'),(236,'0300800','2202','Demais refrigerantes'),(237,'0300900','21069010','Xarope ou extrato concentrado destinados ao preparo de refrigerante em mquina \"pr-mix\"ou \"post-mix\"'),(238,'0301000','22029000','Bebidas energticas'),(239,'0301100','210690','Bebidas hidroeletrolticas (isotnicas)'),(240,'0301200','22030000','Cerveja'),(241,'0301300','22029000','Cerveja sem lcool'),(242,'0301400','22030000','Chope'),(243,'0400100','2402','Charutos, cigarrilhas e cigarros, de tabaco ou dos seus sucedneos'),(244,'0400200','24031','Tabaco para fumar, mesmo contendo sucedneos de tabaco em qualquer proporo'),(245,'0500100','2523','Cimento'),(246,'0600100','220710','lcool etlico no desnaturado, com um teor alcolico em volume igual ou superior a 80% vol (lcool etlico anidro combustvel e lcool etlico hidratado combustvel)'),(247,'0600200','2710125','Gasolinas'),(248,'0600300','2710191','Querosenes'),(249,'0600400','2710192','leos combustveis'),(250,'0600500','2710193','leos lubrificantes'),(251,'0600600','2710199','Outros leos de petrleo ou de minerais betuminosos (exceto leos brutos) e preparaes no especificadas nem compreendidas noutras posies, que contenham, como constituintes bsicos, 70% ou mais, em peso, de leos de petrleo ou de inerais betuminosos,'),(252,'0600700','27109','Resduos de leos'),(253,'0600800','2711','Gs de petrleo e outros hidrocarbonetos gasosos'),(254,'0600900','2713','Coque de petrleo e outros resduos de leo de petrleo ou de minerais betuminosos'),(255,'0601000','38260000','Biodiesel e suas misturas, que no contenham ou que contenham menos de 70%, em peso, de leos de petrleo ou de leos minerais betuminosos'),(256,'0601100','3403','Preparaes lubrificantes, exceto as contendo, como constituintes de base, 70% ou mais, em peso, de leos de petrleo ou de minerais betuminosos'),(257,'0601200','27102000','leos de petrleo ou de minerais betuminosos (exceto leos brutos) e preparaes no especificadas nem compreendidas noutras posies, que contenham, como constituintes bsicos, 70% ou mais, em peso, de leos de petrleo ou de minerais betuminosos, que co'),(258,'0700100','27160000','Energia eltrica'),(259,'0800100','40169990','Ferramentas de borracha vulcanizada no endurecida'),(260,'0800200','44170010','Ferramentas, armaes e cabos de ferramentas, de madeira'),(261,'0800200','44170090','Ferramentas, armaes e cabos de ferramentas, de madeira'),(262,'0800300','6804','Ms e artefatos semelhantes, sem armao, para moer, desfibrar, triturar, amolar, polir, retificar ou cortar; pedras para amolar ou para polir, manualmente, e suas partes, de pedras naturais, de abrasivos naturais ou artificiais aglomerados ou de cermica'),(263,'0800400','8201','Ps, alvies, picaretas, enxadas, sachos, forcados e forquilhas, ancinhos e raspadeiras; machados, podes e ferramentas semelhantes com gume; tesouras de podarde todos os tipos; foices e foicinhas, facas para feno ou para palha, tesouras para sebes, cunha'),(264,'0800500','82022000','Folhas de serras de fita'),(265,'0800600','82029100','Lminas de serras mquinas'),(266,'0800700','8202','Serras manuais e outras folhas de serras (includas as fresas-serras e as folhas no dentadas para serrar), exceto as classificadas nas posies 8202.20.00 e 8202.91.00'),(267,'0800800','8203','Limas, grosas, alicates (mesmo cortantes), tenazes, pinas, cisalhas para metais, corta-tubos, corta-pinos, saca-bocados e ferramentas semelhantes, manuais, exceto as pinas para sobrancelhas classificadas na posio 8203.20.90'),(268,'0800900','8204','Chaves de porcas, manuais (includas as chaves dinamomtricas); chaves de caixa intercambiveis, mesmo com cabos'),(269,'0801000','8205','Ferramentas manuais (includos os diamantes de vidraceiro) no especificadas nem compreendidas em outras posies, lamparinas ou lmpadas de soldar (maaricos) e semelhantes; tornos de apertar, sargentos e semelhantes, exceto os acessrios ou partes de m'),(270,'0801100','8206','Ferramentas de pelo menos duas das posies 8202 a 8205, acondicionadas em sortidos para venda a retalho'),(271,'0801200','820740','Ferramentas de roscar interior ou exteriormente; de mandrilar ou de brochar; e de fresar'),(272,'0801200','820760','Ferramentas de roscar interior ou exteriormente; de mandrilar ou de brochar; e de fresar'),(273,'0801200','820770','Ferramentas de roscar interior ou exteriormente; de mandrilar ou de brochar; e de fresar'),(274,'0801300','8207','Outras ferramentas intercambiveis para ferramentas manuais, mesmo mecnicas, ou para mquinas-ferramentas (por exemplo, de embutir, estampar, puncionar, furar, tornear, aparafusar), includas as fieiras de estiragem ou de extruso, para metais, e as ferr'),(275,'0801400','8208','Facas e lminas cortantes, para mquinas ou para aparelhos mecnicos'),(276,'0801500','82090011','Plaquetas ou pastilhas intercambiveis'),(277,'0801600','8209','Outras plaquetas, varetas, pontas e objetos semelhantes para ferramentas, no montados, de ceramais (\"cermets\"), exceto as classificadas na posio 8209.00.11'),(278,'0801700','8211','Facas (exceto as da posio 8208) de lmina cortante ou serrilhada, includas as podadeiras de lmina mvel, e suas lminas, exceto as de uso domstico'),(279,'0801800','8213','Tesouras e suas lminas'),(280,'0801900','8467','Ferramentas pneumticas, hidrulicas ou com motor (eltrico ou no eltrico) incorporado, de uso manual'),(281,'0802000','9015','Instrumentos e aparelhos de geodsia, topografia, agrimensura, nivelamento, fotogrametria, hidrografia, oceanografia, hidrologia, meteorologia ou de geofsica, exceto bussolas; telmetros'),(282,'0802100','90172000','Instrumentos de desenho, de traado ou de clculo; metros, micrmetros, paqumetros, calibres e semelhantes; partes e acessrios'),(283,'0802100','901730','Instrumentos de desenho, de traado ou de clculo; metros, micrmetros, paqumetros, calibres e semelhantes; partes e acessrios'),(284,'0802100','901780','Instrumentos de desenho, de traado ou de clculo; metros, micrmetros, paqumetros, calibres e semelhantes; partes e acessrios'),(285,'0802100','90179090','Instrumentos de desenho, de traado ou de clculo; metros, micrmetros, paqumetros, calibres e semelhantes; partes e acessrios'),(286,'0802200','90251190','Termmetros, suas partes e acessrios'),(287,'0802200','90259010','Termmetros, suas partes e acessrios'),(288,'0802300','902519','Pirmetros, suas partes e acessrios'),(289,'0802300','90259090','Pirmetros, suas partes e acessrios'),(290,'0900100','8539','Lmpadas eltricas'),(291,'0900200','8540','Lmpadas eletrnicas'),(292,'0900300','85041000','Reatores para lmpadas ou tubos de descargas'),(293,'0900400','853650','Starter'),(294,'0900500','85437099','Lmpadas de LED (Diodos Emissores de Luz)'),(295,'1000100','2522','Cal'),(296,'1000200','3816001','Argamassas'),(297,'1000200','38245000','Argamassas'),(298,'1000300','32149000','Outras argamassas'),(299,'1000400','391000','Silicones em formas primrias, para uso na construo'),(300,'1000500','3916','Revestimentos de PVC e outros plsticos; forro, sancas e afins de PVC, para uso na construo'),(301,'1000600','3917','Tubos, e seus acessrios (por exemplo, juntas, cotovelos, flanges, unies), de plsticos, para uso na construo'),(302,'1000700','3918','Revestimento de pavimento de PVC e outros plsticos'),(303,'1000800','3919','Chapas, folhas, tiras, fitas, pelculas e outras formas planas, auto- adesivas, de plsticos, mesmo em rolos, para uso na construo'),(304,'1000900','3919','Veda rosca, lona plstica para uso na construo, fitas isolantes e afins'),(305,'1000900','3920','Veda rosca, lona plstica para uso na construo, fitas isolantes e afins'),(306,'1000900','3921','Veda rosca, lona plstica para uso na construo, fitas isolantes e afins'),(307,'1001000','3921','Telha de plstico, mesmo reforada com fibra de vidro'),(308,'1001100','3921','Cumeeira de plstico, mesmo reforada com fibra de vidro'),(309,'1001200','3921','Chapas, laminados plsticos em bobina, para uso na construo, exceto os descritos nos itens 10.0 e 11.0'),(310,'1001300','3922','Banheiras, boxes para chuveiros, pias, lavatrios, bids, sanitrios e seus assentos e tampas, caixas de descarga e artigos semelhantes para usos sanitrios ou higinicos, de plsticos'),(311,'1001400','3924','Artefatos de higiene/toucador de plstico, para uso na construo'),(312,'1001500','39251000','Caixa dgua, inclusive sua tampa, de plstico, mesmo reforadas com fibra de vidro'),(313,'1001600','392590','Outras telhas, cumeeira e caixa dgua, inclusive sua tampa, de plstico, mesmo reforadas com fibra de vidro'),(314,'1001700','39251000','Artefatos para apetrechamento de construes, de plsticos, no especificados nem compreendidos em outras posies, incluindo persianas, sancas, molduras, apliques e rosetas, caixilhos de polietileno e outros plsticos, exceto os descritos nos itens 15.0'),(315,'1001700','392590','Artefatos para apetrechamento de construes, de plsticos, no especificados nem compreendidos em outras posies, incluindo persianas, sancas, molduras, apliques e rosetas, caixilhos de polietileno e outros plsticos, exceto os descritos nos itens 15.0'),(316,'1001800','39252000','Portas, janelas e seus caixilhos, alizares e soleiras'),(317,'1001900','39253000','Postigos, estores (includas as venezianas) e artefatos semelhantes e suas partes'),(318,'1002000','392690','Outras obras de plstico, para uso na construo'),(319,'1002100','4814','Papel de parede e revestimentos de parede semelhantes; papel para vitrais'),(320,'1002200','68101900','Telhas de concreto'),(321,'1002300','6811','Telha, cumeeira e caixa dgua, inclusive sua tampa, de fibrocimento, cimento-celulose'),(322,'1002400','6811','Caixas d\'gua, tanques e reservatrios e suas tampas, telhas, calhas, cumeeiras e afins, de fibrocimento, cimento-celulose ou semelhantes, contendo ou no amianto, exceto os descritos no item 23.0'),(323,'1002500','69010000','Tijolos, placas (lajes), ladrilhos e outras peas cermicas de farinhas siliciosas fsseis (\"kieselghur\", tripolita, diatomita, por exemplo) ou de terras siliciosas semelhantes'),(324,'1002600','6902','Tijolos, placas (lajes), ladrilhos e peas cermicas semelhantes, para uso na construo, refratrios, que no sejam de farinhas siliciosas fsseis nem de terras siliciosas semelhantes'),(325,'1002700','6904','Tijolos para construo, tijoleiras, tapa-vigas e produtos semelhantes, de cermica'),(326,'1002800','6905','Telhas, elementos de chamins, condutores de fumaa, ornamentos arquitetnicos, de cermica, e outros produtos cermicos para uso na construo'),(327,'1002900','69060000','Tubos, calhas ou algerozes e acessrios para canalizaes, de cermica'),(328,'1003000','6907','Ladrilhos e placas de cermica, exclusivamente para pavimentao ou revestimento'),(329,'1003000','6908','Ladrilhos e placas de cermica, exclusivamente para pavimentao ou revestimento'),(330,'1003001','6907','Cubos, pastilhas e artigos semelhantes de cermica, mesmo com suporte.'),(331,'1003001','6908','Cubos, pastilhas e artigos semelhantes de cermica, mesmo com suporte.'),(332,'1003100','6910','Pias, lavatrios, colunas para lavatrios, banheiras, bids, sanitrios, caixas de descarga, mictrios e aparelhos fixos semelhantes para usos sanitrios, de cermica'),(333,'1003200','69120000','Artefatos de higiene/toucador de cermica'),(334,'1003300','7003','Vidro vazado ou laminado, em chapas, folhas ou perfis, mesmo com camada absorvente, refletora ou no, mas sem qualquer outro trabalho'),(335,'1003400','7004','Vidro estirado ou soprado, em folhas, mesmo com camada absorvente, refletora ou no, mas sem qualquer outro trabalho'),(336,'1003500','7005','Vidro flotado e vidro desbastado ou polido em uma ou em ambas as faces, em chapas ou em folhas, mesmo com camada absorvente, refletora ou no, mas sem qualquer outro trabalho'),(337,'1003600','70071900','Vidros temperados'),(338,'1003700','70072900','Vidros laminados'),(339,'1003800','7008','Vidros isolantes de paredes mltiplas'),(340,'1003900','7016','Blocos, placas, tijolos, ladrilhos, telhas e outros artefatos, de vidro prensado ou moldado, mesmo armado, para uso na construo; cubos, pastilhas e outros artigos semelhantes'),(341,'1004000','72142000','Barras prprias para construes, exceto vergalhes'),(342,'1004100','73089010','Outras barras prprias para construes, exceto vergalhes'),(343,'1004200','72142000','Vergalhes'),(344,'1004300','7213','Outros vergalhes'),(345,'1004300','73089010','Outros vergalhes'),(346,'1004400','72171090','Fios de ferro ou ao no ligados, no revestidos, mesmo polidos; cordas, cabos, tranas (entranados), lingas e artefatos semelhantes, de ferro ou ao, no isolados para usos eltricos'),(347,'1004400','7312','Fios de ferro ou ao no ligados, no revestidos, mesmo polidos; cordas, cabos, tranas (entranados), lingas e artefatos semelhantes, de ferro ou ao, no isolados para usos eltricos'),(348,'1004500','721720','Outros fios de ferro ou ao, no ligados, galvanizados'),(349,'1004600','7307','Acessrios para tubos (inclusive unies, cotovelos, luvas ou mangas), de ferro fundido, ferro ou ao'),(350,'1004700','73083000','Portas e janelas, e seus caixilhos, alizares e soleiras de ferro fundido, ferro ou ao'),(351,'1004800','73084000','Material para andaimes, para armaes (cofragens) e para escoramentos, (inclusive armaes prontas, para estruturas de concreto armado ou argamassa armada), eletrocalhas e perfilados de ferro fundido, ferro ou ao, prprios para construo, exceto trelia'),(352,'1004800','730890','Material para andaimes, para armaes (cofragens) e para escoramentos, (inclusive armaes prontas, para estruturas de concreto armado ou argamassa armada), eletrocalhas e perfilados de ferro fundido, ferro ou ao, prprios para construo, exceto trelia'),(353,'1004900','73084000','Trelias de ao'),(354,'1005000','73089090','Telhas metlicas'),(355,'1005100','7310','Caixas diversas (tais como caixa de correio, de entrada de gua, de energia, de instalao) de ferro, ferro fundido ou ao; prprias para a construo'),(356,'1005200','73130000','Arame farpado, de ferro ou ao arames ou tiras, retorcidos, mesmo farpados, de ferro ou ao, dos tipos utilizados em cercas'),(357,'1005300','7314','Telas metlicas, grades e redes, de fios de ferro ou ao'),(358,'1005400','73151100','Correntes de rolos, de ferro fundido, ferro ou ao'),(359,'1005500','73151290','Outras correntes de elos articulados, de ferro fundido, ferro ou ao'),(360,'1005600','73158200','Correntes de elos soldados, de ferro fundido, de ferro ou ao'),(361,'1005700','731700','Tachas, pregos, percevejos, escpulas, grampos ondulados ou biselados e artefatos semelhantes, de ferro fundido, ferro ou ao, mesmo com a cabea de outra matria, exceto cobre'),(362,'1005800','7318','Parafusos, pinos ou pernos, roscados, porcas, tira-fundos, ganchos roscados, rebites, chavetas, cavilhas, contrapinos, arruelas (includas as de presso) e artefatos semelhantes, de ferro fundido, ferro ou ao'),(363,'1005900','7323','Palha de ferro ou ao; esponjas, esfreges, luvas e artefatos semelhantes para limpeza, polimento e usos semelhantes, de ferro ou ao, exceto os classificados na posio 7323.10.00 de uso domstico'),(364,'1006000','7324','Artefatos de higiene ou de toucador, e suas partes, de ferro fundido, ferro ou ao, includas as pias, banheiras, lavatrios, cubas, mictrios, tanques e afins de ferro fundido, ferro ou ao, para uso na construo'),(365,'1006100','7325','Outras obras moldadas, de ferro fundido, ferro ou ao, para uso na construo'),(366,'1006200','7326','Abraadeiras'),(367,'1006300','7407','Barras de cobre'),(368,'1006400','74111010','Tubos de cobre e suas ligas, para instalaes de gua quente e gs, para uso na construo'),(369,'1006500','7412','Acessrios para tubos (por exemplo, unies, cotovelos, luvas ou mangas) de cobre e suas ligas, para uso na construo'),(370,'1006600','7415','Tachas, pregos, percevejos, escpulas e artefatos semelhantes, de cobre, ou de ferro ou ao com cabea de cobre, parafusos, pinos ou pernos, roscados, porcas, ganchos roscados, rebites, chavetas, cavilhas, contrapinos, arruelas (includas as de presso),'),(371,'1006700','74182000','Artefatos de higiene/toucador de cobre, para uso na construo'),(372,'1006800','76071990','Manta de subcobertura aluminizada'),(373,'1006900','7608','Tubos de alumnio e suas ligas, para refrigerao e ar condicionado, para uso na construo'),(374,'1007000','76090000','Acessrios para tubos (por exemplo, unies, cotovelos, luvas ou mangas), de alumnio, para uso na construo'),(375,'1007100','7610','Construes e suas partes (por exemplo, pontes e elementos de pontes, torres, prticos ou pilones, pilares, colunas, armaes, estruturas para telhados, portas e janelas, e seus caixilhos, alizares e soleiras, balaustradas), de alumnio, exceto as constru'),(376,'1007200','76152000','Artefatos de higiene/toucador de alumnio, para uso na construo'),(377,'1007300','7616','Outras obras de alumnio, prprias para construes, includas as persianas'),(378,'1007400','83024100','Outras guarnies, ferragens e artigos semelhantes de metais comuns, para construes, inclusive puxadores.'),(379,'1007500','8301','Fechaduras e ferrolhos (de chave, de segredo ou eltricos), de metais comuns, includas as suas partes fechos e armaes com fecho, com fechadura, de metais comuns chaves para estes artigos, de metais comuns, exceto os de uso automotivo'),(380,'1007600','83021000','Dobradias de metais comuns, de qualquer tipo'),(381,'1007700','8307','Tubos flexveis de metais comuns, mesmo com acessrios, para uso na construo'),(382,'1007800','8311','Fios, varetas, tubos, chapas, eletrodos e artefatos semelhantes, de metais comuns ou de carbonetos metlicos, revestidos exterior ou interiormente de decapantes ou de fundentes, para soldagem (soldadura) ou depsito de metal ou de carbonetos metlicos fio'),(383,'1007900','8481','Torneiras, vlvulas (includas as redutoras de presso e as termostticas) e dispositivos semelhantes, para canalizaes, caldeiras, reservatrios, cubas e outros recipientes'),(384,'1100100','28289011','gua sanitria, branqueador e outros alvejantes'),(385,'1100100','28289019','gua sanitria, branqueador e outros alvejantes'),(386,'1100100','32064100','gua sanitria, branqueador e outros alvejantes'),(387,'1100100','38089419','gua sanitria, branqueador e outros alvejantes'),(388,'1100200','34012090','Sabes em p, flocos, palhetas, grnulos ou outras formas semelhantes, para lavar roupas'),(389,'1100300','34012090','Sabes lquidos para lavar roupas'),(390,'1100400','34022000','Detergentes em p, flocos, palhetas, grnulos ou outras formas semelhantes'),(391,'1100500','34022000','Detergentes lquidos, exceto para lavar roupa'),(392,'1100600','34022000','Detergente lquido para lavar roupa'),(393,'1100700','3402','Outros agentes orgnicos de superfcie (exceto sabes); preparaes tensoativas, preparaes para lavagem (includas as preparaes auxiliares para lavagem) e preparaes para limpeza (inclusive multiuso e limpadores), mesmo contendo sabo, exceto as da p'),(394,'1100800','38099190','Amaciante/suavizante'),(395,'1100900','39241000','Esponjas para limpeza'),(396,'1100900','39249000','Esponjas para limpeza'),(397,'1100900','68053010','Esponjas para limpeza'),(398,'1100900','68053090','Esponjas para limpeza'),(399,'1101000','2207','lcool etlico para limpeza'),(400,'1101100','73231000','Palhas de ferro ou ao; esponjas, esfreges, luvas e artefatos semelhantes para limpeza, polimento ou uso semelhantes; todos de uso domstico'),(401,'1200100','8504','Transformadores, bobinas de reatncia e de auto induo, inclusive os transformadores de potncia superior a 16 KVA, classificados nas posies 8504.33.00 e 8504.34.00; exceto os demais transformadores da subposio 8504.3, os reatores para lmpadas eltr'),(402,'1200200','8516','Aquecedores eltricos de gua, includos os de imerso, chuveiros ou duchas eltricos, torneiras eltricas, resistncias de aquecimento, inclusive as de duchas e chuveiros eltricos e suas partes; exceto outros fornos, fogareiros (includas as chapas de c'),(403,'1200300','8535','Aparelhos para interrupo, seccionamento, proteo, derivao, ligao ou conexo de circuitos eltricos (por exemplo, interruptores, comutadores, corta-circuitos, para-raios, limitadores de tenso, eliminadores de onda, tomadas de corrente e outros cone'),(404,'1200400','8536','Aparelhos para interrupo, seccionamento, proteo, derivao, ligao ou conexo de circuitos eltricos (por exemplo, interruptores, comutadores, rels, corta-circuitos, eliminadores de onda, plugues e tomadas de corrente, suportes para lmpadas e outro'),(405,'1200500','8538','Partes reconhecveis como exclusiva ou principalmente destinadas aos aparelhos das posies 8535 e 8536'),(406,'1200600','74130000','Cabos, tranas e semelhantes, de cobre, no isolados para usos eltricos, exceto os de uso automotivo'),(407,'1200700','8544','Fios, cabos (includos os cabos coaxiais) e outros condutores, isolados ou no, para usos eltricos (includos os de cobre ou alumnio, envernizados ou oxidados anodicamente), mesmo com peas de conexo, inclusive fios e cabos eltricos, para tenso no s'),(408,'1200700','7605','Fios, cabos (includos os cabos coaxiais) e outros condutores, isolados ou no, para usos eltricos (includos os de cobre ou alumnio, envernizados ou oxidados anodicamente), mesmo com peas de conexo, inclusive fios e cabos eltricos, para tenso no s'),(409,'1200700','7614','Fios, cabos (includos os cabos coaxiais) e outros condutores, isolados ou no, para usos eltricos (includos os de cobre ou alumnio, envernizados ou oxidados anodicamente), mesmo com peas de conexo, inclusive fios e cabos eltricos, para tenso no s'),(410,'1200800','8546','Isoladores de qualquer matria, para usos eltricos'),(411,'1200900','8547','Peas isolantes inteiramente de matrias isolantes, ou com simples peas metlicas de montagem (suportes roscados, por exemplo) incorporadas na massa, para mquinas, aparelhos e instalaes eltricas; tubos isoladores e suas peas de ligao, de metais co'),(412,'1300100','3003','Medicamentos de referncia  positiva'),(413,'1300100','3004','Medicamentos de referncia  positiva'),(414,'1300101','3003','Medicamentos de referncia  negativa'),(415,'1300101','3004','Medicamentos de referncia  negativa'),(416,'1300102','3003','Medicamentos de referncia  neutra'),(417,'1300102','3004','Medicamentos de referncia  neutra'),(418,'1300200','3003','Medicamentos genrico  positiva'),(419,'1300200','3004','Medicamentos genrico  positiva'),(420,'1300201','3003','Medicamentos genrico  negativa'),(421,'1300201','3004','Medicamentos genrico  negativa'),(422,'1300202','3003','Medicamentos genrico  neutra'),(423,'1300202','3004','Medicamentos genrico  neutra'),(424,'1300300','3003','Medicamentos similar  positiva'),(425,'1300300','3004','Medicamentos similar  positiva'),(426,'1300301','3003','Medicamentos similar  negativa'),(427,'1300301','3004','Medicamentos similar  negativa'),(428,'1300302','3003','Medicamentos similar  neutra'),(429,'1300302','3004','Medicamentos similar  neutra'),(430,'1300400','3003','Outros tipos de medicamentos  positiva'),(431,'1300400','3004','Outros tipos de medicamentos  positiva'),(432,'1300401','3003','Outros tipos de medicamentos - negativa'),(433,'1300401','3004','Outros tipos de medicamentos - negativa'),(434,'1300402','3003','Outros tipos de medicamentos  neutra'),(435,'1300402','3004','Outros tipos de medicamentos  neutra'),(436,'1300500','300660','Preparaes qumicas contraceptivas  base de hormnios, de outros produtos da posio 29.37 ou de espermicidas'),(437,'1300600','2936','Provitaminas e vitaminas, naturais ou reproduzidas por sntese (includos os concentrados naturais), bem como os seus derivados utilizados principalmente como vitaminas, misturados ou no entre si, mesmo em quaisquer solues'),(438,'1300700','300630','Preparaes opacificantes (contrastantes) para exames radiogrficos e reagentes de diagnstico concebidos para serem administrados ao paciente'),(439,'1300800','3002','Antissoro, outras fraes do sangue, produtos imunolgicos modificados, mesmo obtidos por via biotecnolgica; vacinas para medicina humana; e produtos semelhantes'),(440,'1300900','3005','Algodo, atadura, esparadrapo, haste flexvel ou no, com uma ou ambas extremidades de algodo, gazes, pensos, sinapismos, e outros, impregnados ou recobertos de substncias farmacuticas ou acondicionados para venda a retalho para usos medicinais, cirrg'),(441,'1301000','40151100','Luvas cirrgicas e luvas de procedimento'),(442,'1301000','40151900','Luvas cirrgicas e luvas de procedimento'),(443,'1301100','40141000','Preservativo'),(444,'1301200','901831','Seringas, mesmo com agulhas'),(445,'1301300','9018321','Agulhas para seringas'),(446,'1301400','39269090','Contraceptivos (dispositivos intra-uterinos - DIU)'),(447,'1301400','90189099','Contraceptivos (dispositivos intra-uterinos - DIU)'),(448,'1400100','4823209','Filtros descartveis para coar caf ou ch'),(449,'1400200','48236','Bandejas, travessas, pratos, xcaras ou chvenas, taas, copos e artigos semelhantes, de papel ou carto'),(450,'1400300','48131000','Papel para cigarro'),(451,'1500100','3919','Lonas plsticas, exceto as para uso na construo'),(452,'1500100','3920','Lonas plsticas, exceto as para uso na construo'),(453,'1500100','3921','Lonas plsticas, exceto as para uso na construo'),(454,'1500200','3924','Artefatos de higiene/toucador de plstico, exceto os para uso na construo'),(455,'1500300','39241000','Servios de mesa e outros utenslios de mesa ou de cozinha, de'),(456,'1600100','4011','Pneus novos, dos tipos utilizados em automveis de passageiros (includos os veculos de uso misto - camionetas e os automveis de corrida)'),(457,'1600200','4011','Pneus novos, dos tipos utilizados em caminhes (inclusive para os fora-de-estrada), nibus, avies, mquinas de terraplenagem, de construo e conservao de estradas, mquinas e tratores agrcolas, p-carregadeira'),(458,'1600300','4011','Pneus novos para motocicletas'),(459,'1600400','4011','Outros tipos de pneus novos, exceto para bicicletas'),(460,'1600500','40115000','Pneus novos de borracha dos tipos utilizados em bicicletas'),(461,'1600600','40121','Pneus recauchutados'),(462,'1600700','401290','Protetores de borracha, exceto para bicicletas'),(463,'1600701','401290','Protetores de borracha para bicicletas'),(464,'1600800','4013','Cmaras de ar de borracha, exceto para bicicletas'),(465,'1600900','40132000','Cmaras de ar de borracha dos tipos utilizados em bicicletas'),(466,'1700100','17049010','Chocolate branco, em embalagens de contedo inferior ou igual a 1 kg'),(467,'1700200','18063110','Chocolates contendo cacau, em embalagens de contedo inferior ou igual a 1 kg'),(468,'1700200','18063120','Chocolates contendo cacau, em embalagens de contedo inferior ou igual a 1 kg'),(469,'1700300','18063210','Chocolate em barras, tabletes ou blocos ou no estado lquido, em pasta, em p, grnulos ou formas semelhantes, em recipientes ou embalagens imediatas de contedo inferior ou igual a 2 kg'),(470,'1700300','18063220','Chocolate em barras, tabletes ou blocos ou no estado lquido, em pasta, em p, grnulos ou formas semelhantes, em recipientes ou embalagens imediatas de contedo inferior ou igual a 2 kg'),(471,'1700400','18069000','Chocolates e outras preparaes alimentcias contendo cacau, em embalagens de contedo inferior ou igual a 1 kg, excludos os achocolatados em p'),(472,'1700500','18069000','Achocolatados em p, em embalagens de contedo inferior ou igual a 1 kg'),(473,'1700600','18069000','Caixas de bombons contendo cacau, em embalagens de contedo inferior ou igual a 1 kg'),(474,'1700700','17049090','Bombons, inclusive  base de chocolate branco sem cacau'),(475,'1700800','18069000','Bombons, balas, caramelos, confeitos, pastilhas e outros produtos de confeitaria, contendo cacau'),(476,'1700900','210120','Bebidas prontas  base de mate ou ch'),(477,'1700900','22029000','Bebidas prontas  base de mate ou ch'),(478,'1701000','22021000','Refrescos e outras bebidas no alcolicas, exceto os refrigerantes e as demais bebidas de que trata o Anexo IV'),(479,'1701100','22029000','Bebidas prontas  base de caf'),(480,'1701200','2009','Sucos de frutas ou de produtos hortcolas; mistura de sucos'),(481,'1701300','20098','gua de coco'),(482,'1701400','22029000','Nctares de frutas e outras bebidas no alcolicas prontas para beber, exceto isotnicos e energticos'),(483,'1701500','22029000','Bebidas alimentares prontas  base de soja, leite ou cacau, inclusive os produtos denominados bebidas lcteas'),(484,'1701600','22021000','Refrescos e outras bebidas prontas para beber  base de ch e mate'),(485,'1701700','4021','Leite em p, blocos ou grnulos, exceto creme de leite'),(486,'1701700','4022','Leite em p, blocos ou grnulos, exceto creme de leite'),(487,'1701700','4029','Leite em p, blocos ou grnulos, exceto creme de leite'),(488,'1701800','19011020','Farinha lctea'),(489,'1701900','19011010','Leite modificado para alimentao de crianas.'),(490,'1702000','19011090','Preparaes para alimentao infantil  base de farinhas, grumos, smolas ou amidos e outros'),(491,'1702000','19011030','Preparaes para alimentao infantil  base de farinhas, grumos, smolas ou amidos e outros'),(492,'1702100','4011010','Leite longa vida (UHT - Ultra High Temperature), em recipiente de contedo inferior ou igual a 2 litros'),(493,'1702100','4012010','Leite longa vida (UHT - Ultra High Temperature), em recipiente de contedo inferior ou igual a 2 litros'),(494,'1702101','4011010','Leite longa vida (UHT - Ultra High Temperature), em recipiente de contedo superior a 2 litros'),(495,'1702101','4012010','Leite longa vida (UHT - Ultra High Temperature), em recipiente de contedo superior a 2 litros'),(496,'1702200','4014010','Leite em recipiente de contedo inferior ou igual a 1 litro'),(497,'1702200','4015010','Leite em recipiente de contedo inferior ou igual a 1 litro'),(498,'1702201','4014010','Leite em recipiente de contedo superior a 1 litro'),(499,'1702201','4015010','Leite em recipiente de contedo superior a 1 litro'),(500,'1702300','4011090','Leite do tipo pasteurizado em recipiente de contedo inferior ou igual a 1 litro'),(501,'1702300','4012090','Leite do tipo pasteurizado em recipiente de contedo inferior ou igual a 1 litro'),(502,'1702301','4011090','Leite do tipo pasteurizado em recipiente de contedo superior a 1 litro'),(503,'1702301','4012090','Leite do tipo pasteurizado em recipiente de contedo superior a 1 litro'),(504,'1702400','401402','Creme de leite, em recipiente de contedo inferior ou igual a 1 kg'),(505,'1702400','4022130','Creme de leite, em recipiente de contedo inferior ou igual a 1 kg'),(506,'1702400','4022930','Creme de leite, em recipiente de contedo inferior ou igual a 1 kg'),(507,'1702400','4029','Creme de leite, em recipiente de contedo inferior ou igual a 1 kg'),(508,'1702401','401402','Creme de leite, em recipiente de contedo superior a 1 kg'),(509,'1702401','4022130','Creme de leite, em recipiente de contedo superior a 1 kg'),(510,'1702401','4022930','Creme de leite, em recipiente de contedo superior a 1 kg'),(511,'1702401','4029','Creme de leite, em recipiente de contedo superior a 1 kg'),(512,'1702402','40110','Outros cremes de leite, em recipiente de contedo inferior ou igual a 1kg'),(513,'1702402','40120','Outros cremes de leite, em recipiente de contedo inferior ou igual a 1kg'),(514,'1702402','40150','Outros cremes de leite, em recipiente de contedo inferior ou igual a 1kg'),(515,'1702402','40210','Outros cremes de leite, em recipiente de contedo inferior ou igual a 1kg'),(516,'1702402','4022920','Outros cremes de leite, em recipiente de contedo inferior ou igual a 1kg'),(517,'1702500','4029','Leite condensado, em recipiente de contedo inferior ou igual a 1 kg'),(518,'1702501','4029','Leite condensado, em recipiente de contedo superior a 1 kg'),(519,'1702600','403','Iogurte e leite fermentado em recipiente de contedo inferior ou igual a 2 litros'),(520,'1702601','403','Iogurte e leite fermentado em recipiente de contedo superior a 2 litros'),(521,'1702700','4039000','Coalhada'),(522,'1702800','406','Requeijo e similares, em recipiente de contedo inferior ou igual a 1 kg, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(523,'1702801','406','Requeijo e similares, em recipiente de contedo superior a 1 kg'),(524,'1702900','406','Queijos'),(525,'1703000','4051000','Manteiga, em embalagem de contedo inferior ou igual a 1 kg, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(526,'1703001','4051000','Manteiga, em embalagem de contedo superior a 1 kg'),(527,'1703100','15171000','Margarina em recipiente de contedo inferior ou igual a 500 g, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(528,'1703200','15171000','Margarina, em recipiente de contedo superior a 500 g e inferior a 1 kg, creme vegetal em recipiente de contedo inferior a 1 kg, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(529,'1703201','15171000','Margarina e creme vegetal, em recipiente de contedo de 1 kg.'),(530,'1703202','151790','Outras margarinas e cremes vegetais em recipiente de contedo inferior a 1 kg, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(531,'1703300','15162000','Gorduras e leos vegetais e respectivas fraes, parcial ou totalmente hidrogenados, interesterificados, reesterificados ou elaidinizados, mesmo refinados, mas no preparados de outro modo, em recipiente de contedo inferior ou igual a 1 kg, exceto as emb'),(532,'1703301','15162000','Gorduras e leos vegetais e respectivas fraes, parcial ou totalmente hidrogenados, interesterificados, reesterificados ou elaidinizados, mesmo refinados, mas no preparados de outro modo, em recipiente de contedo superior a 1 kg, exceto as embalagens i'),(533,'1703400','19019020','Doces de leite'),(534,'1703500','19041000','Produtos  base de cereais, obtidos por expanso ou torrefao'),(535,'1703500','19049000','Produtos  base de cereais, obtidos por expanso ou torrefao'),(536,'1703600','19059090','Salgadinhos diversos'),(537,'1703700','20052000','Batata frita, inhame e mandioca fritos'),(538,'1703700','20059','Batata frita, inhame e mandioca fritos'),(539,'1703800','20081','Amendoim e castanhas tipo aperitivo, em embalagem de contedo inferior ou igual a 1 kg'),(540,'1703801','20081','Amendoim e castanhas tipo aperitivo, em embalagem de contedo superior a 1 kg'),(541,'1703900','21032010','Catchup em embalagens imediatas de contedo inferior ou igual a 650 g, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(542,'1704000','21039021','Condimentos e temperos compostos, incluindo molho de pimenta e outros molhos, em embalagens imediatas de contedo inferior ou igual a 1 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 3 g'),(543,'1704000','21039091','Condimentos e temperos compostos, incluindo molho de pimenta e outros molhos, em embalagens imediatas de contedo inferior ou igual a 1 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 3 g'),(544,'1704100','21031010','Molhos de soja preparados em embalagens imediatas de contedo inferior ou igual a 650 g, exceto as embalagens contendo envelopes individualizados (saches) de contedo inferior ou igual a 10 g'),(545,'1704200','21033010','Farinha de mostarda em embalagens de contedo inferior ou igual a 1 kg'),(546,'1704300','21033021','Mostarda preparada em embalagens imediatas de contedo inferior ou igual a 650 g, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(547,'1704400','21039011','Maionese em embalagens imediatas de contedo inferior ou igual a 650 g, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(548,'1704500','2002','Tomates preparados ou conservados, exceto em vinagre ou em cido actico, em embalagens de contedo inferior ou igual a 1 kg'),(549,'1704600','21032010','Molhos de tomate em embalagens imediatas de contedo inferior ou igual a 1 kg'),(550,'1704700','17049090','Barra de cereais'),(551,'1704700','19042000','Barra de cereais'),(552,'1704700','19049000','Barra de cereais'),(553,'1704800','18063120','Barra de cereais contendo cacau'),(554,'1704800','18063220','Barra de cereais contendo cacau'),(555,'1704800','18069000','Barra de cereais contendo cacau'),(556,'1704900','11010010','Farinha de trigo, em embalagem inferior ou igual a 5 kg'),(557,'1704901','11010010','Farinha de trigo, em embalagem superior a 5 kg'),(558,'1705000','11010020','Mistura de farinha de trigo'),(559,'1705100','19012000','Misturas e preparaes para bolos'),(560,'1705100','19019090','Misturas e preparaes para bolos'),(561,'1705200','19023000','Massas alimentcias tipo instantnea'),(562,'1705300','1902','Massas alimentcias, cozidas ou recheadas (de carne ou de outras substncias) ou preparadas de outro modo, exceto as massas alimentcias tipo instantnea'),(563,'1705301','19024000','Cuscuz'),(564,'1705400','19021','Massas alimentcias no cozidas, nem recheadas, nem preparadas de outro modo:'),(565,'1705500','190520','Pes industrializados, inclusive de especiarias, exceto panetones e bolo de forma'),(566,'1705600','19052090','Bolo de forma, inclusive de especiarias'),(567,'1705700','19052010','Panetones'),(568,'1705800','190531','Biscoitos e bolachas derivados de farinha de trigo; exceto dos tipos \"cream cracker\", \"gua e sal\", \"maisena\", \"maria\" e outros de consumo popular, no adicionados de cacau, nem recheados, cobertos ou amanteigados, independentemente de sua denominao com'),(569,'1705900','190531','Biscoitos e bolachas no derivados de farinha de trigo; exceto dos tipos \"cream cracker\", \"gua e sal\", \"maisena\" e \"maria\" e outros de consumo popular, no adicionados de cacau, nem recheados, cobertos ou amanteigados, independentemente de sua denomina'),(570,'1706000','190531','Biscoitos e bolachas dos tipos \"cream cracker\", \"gua e sal\", \"maisena\" e \"maria\" e outros de consumo popular, adicionados de edulcorantes e no adicionados de cacau, nem recheados, cobertos ou amanteigados, independentemente de sua denominao comercial'),(571,'1706100','19059020','Biscoitos e bolachas dos tipos \"cream cracker\", \"gua e sal\", \"maisena\" e \"maria\" e outros de consumo popular, no adicionados de cacau, nem recheados, cobertos ou amanteigados, independentemente de sua denominao comercial'),(572,'1706200','190532','Waffles e wafers - sem cobertura'),(573,'1706300','190532','Waffles e wafers- com cobertura'),(574,'1706400','190540','Torradas, po torrado e produtos semelhantes torrados'),(575,'1706500','19059010','Outros pes de forma'),(576,'1706600','19059020','Outras bolachas, exceto casquinhas para sorvete'),(577,'1706700','19059090','Outros pes e bolos industrializados e produtos de panificao no especificados anteriormente; exceto casquinhas para sorvete e po francs de at 200 g'),(578,'1706800','19051000','Po denominado knackebrot'),(579,'1706900','19059090','Po francs de at 200 g'),(580,'1707000','190590','Demais pes industrializados'),(581,'1707100','15079011','leo de soja refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(582,'1707200','1508','leo de amendoim refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(583,'1707300','1509','Azeites de oliva, em recipientes com capacidade inferior ou igual a 2 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(584,'1707301','1509','Azeites de oliva, em recipientes com capacidade superior a 2 litros e inferior ou igual a 5 litros'),(585,'1707302','1509','Azeites de oliva, em recipientes com capacidade superior a 5 litros'),(586,'1707400','15100000','Outros leos e respectivas fraes, obtidos exclusivamente a partir de azeitonas, mesmo refinados, mas no quimicamente modificados, e misturas desses leos ou fraes com leos ou fraes da posio 15.09, em recipientes com capacidade inferior ou igual'),(587,'1707500','15121911','leo de girassol ou de algodo refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(588,'1707500','15122910','leo de girassol ou de algodo refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(589,'1707600','15141','leo de canola, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(590,'1707700','','leo de linhaa refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(591,'1707700','15151900','leo de linhaa refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(592,'1707800','15152910','leo de milho refinado, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(593,'1707900','15122990','Outros leos refinados, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(594,'1708000','15179010','Misturas de leos refinados, para consumo humano, em recipientes com capacidade inferior ou igual a 5 litros, exceto as embalagens individuais de contedo inferior ou igual a 15 mililitros'),(595,'1708100','1511','Outros leos vegetais comestveis no especificados anteriormente'),(596,'1708100','1513','Outros leos vegetais comestveis no especificados anteriormente'),(597,'1708100','1514','Outros leos vegetais comestveis no especificados anteriormente'),(598,'1708100','1515','Outros leos vegetais comestveis no especificados anteriormente'),(599,'1708100','1516','Outros leos vegetais comestveis no especificados anteriormente'),(600,'1708100','1518','Outros leos vegetais comestveis no especificados anteriormente'),(601,'1708200','16010000','Enchidos (embutidos) e produtos semelhantes, de carne, miudezas ou sangue; exceto salsicha, linguia e mortadela'),(602,'1708300','16010000','Salsicha e linguia'),(603,'1708400','16010000','Mortadela'),(604,'1708500','1602','Outras preparaes e conservas de carne, miudezas ou de sangue'),(605,'1708600','1604','Preparaes e conservas de peixes; caviar e seus sucedneos preparados a partir de ovas de peixe; exceto sardinha em conserva'),(606,'1708700','1604','Sardinha em conserva'),(607,'1708800','1605','Crustceos, moluscos e outros invertebrados aquticos, preparados ou em conservas'),(608,'1708900','0201','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(609,'1708900','202','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(610,'1708900','204','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(611,'1708900','206','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(612,'1708900','2102000','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(613,'1708900','2109900','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(614,'1708900','1502','Carne de gado bovino, ovino e bufalino e produtos comestveis resultantes da matana desse gado submetidos  salga, secagem ou desidratao'),(615,'1709000','204','Carnes de animais das espcies caprina, frescas, refrigeradas ou congeladas'),(616,'1709100','0203','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(617,'1709100','206','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(618,'1709100','207','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(619,'1709100','209','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(620,'1709100','2101','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(621,'1709100','2109900','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(622,'1709100','1501','Carnes e demais produtos comestveis frescos, resfriados, congelados, salgados, em salmoura, simplesmente temperados, secos ou defumados, resultantes do abate de aves e de sunos'),(623,'1709200','710','Produtos hortcolas, cozidos em gua ou vapor, congelados, em embalagens de contedo inferior ou igual a 1 kg'),(624,'1709201','710','Produtos hortcolas, cozidos em gua ou vapor, congelados, em embalagens de contedo superior a 1 kg'),(625,'1709300','811','Frutas, no cozidas ou cozidas em gua ou vapor, congeladas, mesmo adicionadas de acar ou de outros edulcorantes, em embalagens de contedo inferior ou igual a 1 kg'),(626,'1709301','811','Frutas, no cozidas ou cozidas em gua ou vapor, congeladas, mesmo adicionadas de acar ou de outros edulcorantes, em embalagens de contedo superior a 1 kg'),(627,'1709400','2001','Produtos hortcolas, frutas e outras partes comestveis de plantas, preparados ou conservados em vinagre ou em cido actico, em embalagens de contedo inferior ou igual a 1 kg'),(628,'1709401','2001','Produtos hortcolas, frutas e outras partes comestveis de plantas, preparados ou conservados em vinagre ou em cido actico, em embalagens de contedo superior a 1 kg'),(629,'1709500','2004','Outros produtos hortcolas preparados ou conservados, exceto em vinagre ou em cido actico, congelados, com exceo dos produtos da posio 20.06, em embalagens de contedo inferior ou igual a 1 kg'),(630,'1709501','2004','Outros produtos hortcolas preparados ou conservados, exceto em vinagre ou em cido actico, congelados, com exceo dos produtos da posio 20.06, em embalagens de contedo superior a 1 kg'),(631,'1709600','2005','Outros produtos hortcolas preparados ou conservados, exceto em vinagre ou em cido actico, no congelados, com exceo dos produtos da posio 20.06, excludos batata, inhame e mandioca fritos, em embalagens de contedo inferior ou igual a 1 kg'),(632,'1709601','2005','Outros produtos hortcolas preparados ou conservados, exceto em vinagre ou em cido actico, no congelados, com exceo dos produtos da posio 20.06, excludos batata, inhame e mandioca fritos, em embalagens de contedo superior a 1 kg'),(633,'1709700','20060000','Produtos hortcolas, frutas, cascas de frutas e outras partes de plantas, conservados com acar (passados por calda, glaceados ou cristalizados), em embalagens de contedo inferior ou igual a 1 kg'),(634,'1709701','20060000','Produtos hortcolas, frutas, cascas de frutas e outras partes de plantas, conservados com acar (passados por calda, glaceados ou cristalizados), em embalagens de contedo superior a 1 kg'),(635,'1709800','2007','Doces, gelias, marmelades, purs e pastas de frutas, obtidos por cozimento, com ou sem adio de acar ou de outros edulcorantes, em embalagens de contedo inferior ou igual a 1 kg, exceto as embalagens individuais de contedo inferior ou igual a 10 g'),(636,'1709801','2007','Doces, gelias, marmelades, purs e pastas de frutas, obtidos por cozimento, com ou sem adio de acar ou de outros edulcorantes, em embalagens de contedo superior a 1 kg'),(637,'1709900','2008','Frutas e outras partes comestveis de plantas, preparadas ou conservadas de outro modo, com ou sem adio de acar ou de outros edulcorantes ou de lcool, no especificadas nem compreendidas em outras posies, excludos os amendoins e castanhas tipo ape'),(638,'1709901','2008','Frutas e outras partes comestveis de plantas, preparadas ou conservadas de outro modo, com ou sem adio de acar ou de outros edulcorantes ou de lcool, no especificadas nem compreendidas em outras posies, excludos os amendoins e castanhas tipo ape'),(639,'1710000','901','Caf torrado e modo, em embalagens de contedo inferior ou igual a 2 kg'),(640,'1710001','901','Caf torrado e modo, em embalagens de contedo superior a 2 kg'),(641,'1710100','0902','Ch, mesmo aromatizado'),(642,'1710100','12119090','Ch, mesmo aromatizado'),(643,'1710100','21069090','Ch, mesmo aromatizado'),(644,'1710200','90300','Mate'),(645,'1710300','17011','Acar refinado, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(646,'1710300','17019900','Acar refinado, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(647,'1710301','17011','Acar refinado, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(648,'1710301','17019900','Acar refinado, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(649,'1710302','17011','Acar refinado, em embalagens de contedo superior a 5 kg'),(650,'1710302','17019900','Acar refinado, em embalagens de contedo superior a 5 kg'),(651,'1710400','17019100','Acar refinado adicionado de aromatizante ou de corante em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(652,'1710401','17019100','Acar refinado adicionado de aromatizante ou de corante em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(653,'1710402','17019100','Acar refinado adicionado de aromatizante ou de corante em embalagens de contedo superior a 5 kg'),(654,'1710500','17011','Acar cristal, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(655,'1710500','17019900','Acar cristal, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(656,'1710501','17011','Acar cristal, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(657,'1710501','17019900','Acar cristal, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(658,'1710502','17011','Acar cristal, em embalagens de contedo superior a 5 kg'),(659,'1710502','17019900','Acar cristal, em embalagens de contedo superior a 5 kg'),(660,'1710600','17019100','Acar cristal adicionado de aromatizante ou de corante, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(661,'1710601','17019100','Acar cristal adicionado de aromatizante ou de corante, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(662,'1710602','170191','Acar cristal adicionado de aromatizante ou de corante, em embalagens de contedo superior a 5 kg'),(663,'1710700','17011','Outros tipos de acar, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(664,'1710700','17019900','Outros tipos de acar, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(665,'1710701','17011','Outros tipos de acar, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(666,'1710701','17019900','Outros tipos de acar, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(667,'1710702','17011','Outros tipos de acar, em embalagens de contedo superior a 5 kg'),(668,'1710702','17019900','Outros tipos de acar, em embalagens de contedo superior a 5 kg'),(669,'1710800','17019100','Outros tipos de acar adicionado de aromatizante ou de corante, em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(670,'1710801','17019100','Outros tipos de acar adicionado de aromatizante ou de corante, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(671,'1710802','17019100','Outros tipos de acar adicionado de aromatizante ou de corante, em embalagens de contedo superior a 5 kg'),(672,'1710900','1702','Outros acares em embalagens de contedo inferior ou igual a 2 kg, exceto as embalagens contendo envelopes individualizados (sachs) de contedo inferior ou igual a 10 g'),(673,'1710901','1702','Outros acares, em embalagens de contedo superior a 2 kg e inferior ou igual a 5 kg'),(674,'1710902','1702','Outros acares, em embalagens de contedo superior a 5 kg'),(675,'1711000','20081900','Milho para pipoca (micro-ondas)'),(676,'1711100','21011','Extratos, essncias e concentrados de caf e preparaes  base destes extratos, essncias ou concentrados ou  base de caf, em embalagens de contedo inferior ou igual a 500 g, exceto as preparaes indicadas no item 112.0'),(677,'1711200','210120','Extratos, essncias e concentrados de ch ou de mate e preparaes  base destes extratos, essncias ou concentrados ou  base de ch ou de mate, em embalagens de contedo inferior ou igual a 500 g, exceto as bebidas prontas  base de mate ou ch'),(678,'1711300','19019090','Preparaes em p para cappuccino e similares, em embalagens de contedo inferior ou igual a 500 g'),(679,'1711300','21011190','Preparaes em p para cappuccino e similares, em embalagens de contedo inferior ou igual a 500 g'),(680,'1711300','21011200','Preparaes em p para cappuccino e similares, em embalagens de contedo inferior ou igual a 500 g'),(681,'1800100','69111010','Artigos para servio de mesa ou de cozinha, de porcelana, inclusive os descartveis  estojos'),(682,'1800200','69111090','Artigos para servio de mesa ou de cozinha, de porcelana, inclusive os descartveis  avulsos'),(683,'1800300','69120000','Artigos para servio de mesa ou de cozinha, de cermica'),(684,'1800400','69120000','Velas para filtros'),(685,'1900100','32131000','Tinta guache'),(686,'1900200','39162000','Espiral - perfil para encadernao, de plstico e outros materiais classificados nas posies 3901 a 3914'),(687,'1900300','39261000','Artigos de escritrio e artigos escolares de plstico e outros materiais classificados nas posies 3901 a 3914, exceto estojos'),(688,'1900400','42021','Maletas e pastas para documentos e de estudante, e artefatos semelhantes'),(689,'1900400','42029','Maletas e pastas para documentos e de estudante, e artefatos semelhantes'),(690,'1900500','39269090','Prancheta de plstico'),(691,'1900600','48022090','Bobina para fax'),(692,'1900600','48119090','Bobina para fax'),(693,'1900700','4802549','Papel seda'),(694,'1900800','48025499','Bobina branca para mquina de calcular ou PDV'),(695,'1900800','48025799','Bobina branca para mquina de calcular ou PDV'),(696,'1900800','48162000','Bobina branca para mquina de calcular ou PDV'),(697,'1900900','4802569','Cartolina escolar e papel carto, brancos e coloridos; recados auto adesivos (LP note); papis de presente, todos cortados em tamanho pronto para uso escolar e domstico'),(698,'1900900','4802579','Cartolina escolar e papel carto, brancos e coloridos; recados auto adesivos (LP note); papis de presente, todos cortados em tamanho pronto para uso escolar e domstico'),(699,'1900900','4802589','Cartolina escolar e papel carto, brancos e coloridos; recados auto adesivos (LP note); papis de presente, todos cortados em tamanho pronto para uso escolar e domstico'),(700,'1901000','37031010','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(701,'1901000','37031029','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(702,'1901000','37032000','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(703,'1901000','37039010','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(704,'1901000','37040000','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(705,'1901000','48022000','Papel fotogrfico, exceto: (i) os papis fotogrficos emulsionados com haleto de prata tipo brilhante, matte ou lustre, em rolo e, com largura igual ou superior a 102 mm e comprimento inferior ou igual a 350 m, (ii) os papis fotogrficos emulsionados com'),(706,'1901100','48101390','Papel almao'),(707,'1901200','48161000','Papel hectogrfico'),(708,'1901300','39202019','Papel celofane e tipo celofane'),(709,'1901400','48062000','Papel impermevel'),(710,'1901500','48081000','Papel crepon'),(711,'1901600','48102290','Papel fantasia'),(712,'1901700','4809','Papel-carbono, papel autocopiativo (exceto os vendidos em rolos de dimetro igual ou superior a 60 cm e os vendidos em folhas de formato igual ou superior a 60 cm de altura e igual ou superior a 90 cm de largura) e outros papis para cpia ou duplicao ('),(713,'1901700','4816','Papel-carbono, papel autocopiativo (exceto os vendidos em rolos de dimetro igual ou superior a 60 cm e os vendidos em folhas de formato igual ou superior a 60 cm de altura e igual ou superior a 90 cm de largura) e outros papis para cpia ou duplicao ('),(714,'1901800','4817','Envelopes, aerogramas, bilhetes-postais no ilustrados e cartes para correspondncia, de papel ou carto, caixas, sacos e semelhantes, de papel ou carto, contendo um sortido de artigos para correspondncia'),(715,'1901900','48201000','Livros de registro e de contabilidade, blocos de notas,de encomendas, de recibos, de apontamentos, de papel para cartas, agendas e artigos semelhantes'),(716,'1902000','48202000','Cadernos'),(717,'1902100','48203000','Classificadores, capas para encadernao (exceto as capas para livros) e capas de processos'),(718,'1902200','48204000','Formulrios em blocos tipo \"manifold\", mesmo com folhas intercaladas de papel-carbono'),(719,'1902300','48205000','lbuns para amostras ou para colees'),(720,'1902400','48209000','Pastas para documentos, outros artigos escolares, de escritrio ou de papelaria, de papel ou carto e capas para livros, de papel ou carto'),(721,'1902500','49090000','Cartes postais impressos ou ilustrados, cartes impressos com votos ou mensagens pessoais, mesmo ilustrados, com ou sem envelopes, guarnies ou aplicaes (conhecidos como cartes de expresso social - de poca/sentimento)'),(722,'1902600','96081000','Canetas esferogrficas'),(723,'1902700','96082000','Canetas e marcadores, com ponta de feltro ou com outras pontas porosas'),(724,'1902800','96083000','Canetas tinteiro'),(725,'1902900','9608','Outras canetas; sortidos de canetas'),(726,'1903000','480256','Papel cortado \"cutsize\" (tipo A3, A4, ofcio I e II, carta e outros)'),(727,'2000100','12119090','Henna (embalagens de contedo inferior ou igual a 200 g)'),(728,'2000101','12119090','Henna (embalagens de contedo superior a 200 g)'),(729,'2000200','27121000','Vaselina'),(730,'2000300','28142000','Amonaco em soluo aquosa (amnia)'),(731,'2000400','28470000','Perxido de hidrognio, em embalagens de contedo inferior ou igual a 500 ml'),(732,'2000500','30067000','Lubrificao ntima'),(733,'2000600','3301','leos essenciais (desterpenados ou no), includos os chamados \"concretos\" ou \"absolutos\"; resinides; oleorresinas de extrao; solues concentradas de leos essenciais em gorduras, em leos fixos, em ceras ou em matrias anlogas, obtidas portratamento'),(734,'2000700','33030010','Perfumes (extratos)'),(735,'2000800','33030020','guas-de-colnia'),(736,'2000900','33041000','Produtos de maquilagem para os lbios'),(737,'2001000','33042010','Sombra, delineador, lpis para sobrancelhas e rmel'),(738,'2001100','33042090','Outros produtos de maquilagem para os olhos'),(739,'2001200','33043000','Preparaes para manicuros e pedicuros, incluindo removedores de esmalte  base de acetona'),(740,'2001300','33049100','Ps, includos os compactos, para maquilagem'),(741,'2001400','33049910','Cremes de beleza, cremes nutritivos e loes tnicas'),(742,'2001500','33049990','Outros produtos de beleza ou de maquilagem preparados e preparaes para conservao ou cuidados da pele, exceto as preparaes solares e antisolares.'),(743,'2001600','33049990','Preparaes solares e antisolares'),(744,'2001700','33051000','Xampus para o cabelo'),(745,'2001800','33052000','Preparaes para ondulao ou alisamento, permanentes, dos cabelos'),(746,'2001900','33053000','Laqus para o cabelo'),(747,'2002000','33059000','Outras preparaes capilares, incluindo mscaras e finalizadores'),(748,'2002100','33059000','Condicionadores'),(749,'2002200','33059000','Tintura para o cabelo'),(750,'2002300','33061000','Dentifrcios'),(751,'2002400','33062000','Fios utilizados para limpar os espaos interdentais (fios dentais)'),(752,'2002500','33069000','Outras preparaes para higiene bucal ou dentria'),(753,'2002600','33071000','Preparaes para barbear (antes, durante ou aps)'),(754,'2002700','33072010','Desodorantes (desodorizantes) corporais lquidos'),(755,'2002800','33072010','Antiperspirantes lquidos'),(756,'2002900','33072090','Outros desodorantes (desodorizantes) corporais'),(757,'2003000','33072090','Outros antiperspirantes'),(758,'2003100','33073000','Sais perfumados e outras preparaes para banhos'),(759,'2003200','33079000','Outros produtos de perfumaria ou de toucador preparados'),(760,'2003300','33079000','Solues para lentes de contato ou para olhos artificiais'),(761,'2003400','34011190','Sabes de toucador em barras, pedaos ou figuras moldados'),(762,'2003500','34011900','Outros sabes, produtos e preparaes, em barras, pedaos ou figuras moldados, inclusive lenos umedecidos'),(763,'2003600','34012010','Sabes de toucador sob outras formas'),(764,'2003700','34013000','Produtos e preparaes orgnicos tensoativos para lavagem da pele, na forma de lquido ou de creme, acondicionados para venda a retalho, mesmo contendo sabo'),(765,'2003800','40149010','Bolsa para gelo ou para gua quente'),(766,'2003900','40149090','Chupetas e bicos para mamadeiras e para chupetas, de borracha'),(767,'2003901','39269040','Chupetas e bicos para mamadeiras e para chupetas, de silicone'),(768,'2004000','42021','Malas e maletas de toucador'),(769,'2004100','48181000','Papel higinico - folha simples'),(770,'2004200','48181000','Papel higinico - folha dupla e tripla'),(771,'2004300','48182000','Lenos (includos os de maquilagem) e toalhas de mo'),(772,'2004400','48182000','Papel toalha de uso institucional do tipo comercializado em rolos igual ou superior a 80 metros e do tipo comercializado em folhas intercaladas'),(773,'2004500','48183000','Toalhas e guardanapos de mesa'),(774,'2004600','48189090','Toalhas de cozinha (papel toalha de uso domstico)'),(775,'2004700','96190000','Fraldas'),(776,'2004800','96190000','Tampes higinicos'),(777,'2004900','96190000','Absorventes higinicos externos'),(778,'2005000','56012190','Hastes flexveis (uso no medicinal)'),(779,'2005100','56039290','Suti descartvel, assemelhados e papel para depilao'),(780,'2005200','82032090','Pinas para sobrancelhas'),(781,'2005300','82141000','Esptulas (artigos de cutelaria)'),(782,'2005400','82142000','Utenslios e sortidos de utenslios de manicuros ou de pedicuros (includas as limas para unhas)'),(783,'2005500','90251110','Termmetros, inclusive o digital'),(784,'2005500','90251990','Termmetros, inclusive o digital'),(785,'2005600','96032','Escovas e pincis de barba, escovas para cabelos, para clios ou para unhas e outras escovas de toucador de pessoas, includas as que sejam partes de aparelhos, exceto escovas de dentes'),(786,'2005700','96032100','Escovas de dentes, includas as escovas para dentaduras'),(787,'2005800','96033000','Pincis para aplicao de produtos cosmticos'),(788,'2005900','96050000','Sortidos de viagem, para toucador de pessoas para costura ou para limpeza de calado ou de roupas'),(789,'2006000','9615','Pentes, travessas para cabelo e artigos semelhantes; grampos (alfinetes) para cabelo; pinas (pinceguiches), onduladores, bobes (rolos) e artefatos semelhantes para penteados, e suas partes, exceto os classificados na posio 8516 e suas partes'),(790,'2006100','96162000','Borlas ou esponjas para ps ou para aplicao de outros cosmticos ou de produtos de toucador'),(791,'2006200','39233000','Mamadeiras'),(792,'2006200','39249000','Mamadeiras'),(793,'2006200','39241000','Mamadeiras'),(794,'2006200','40149090','Mamadeiras'),(795,'2006200','70102000','Mamadeiras'),(796,'2006300','82121020','Aparelhos e lminas de barbear'),(797,'2006300','82122010','Aparelhos e lminas de barbear'),(798,'2100100','73211100','Foges de cozinha de uso domstico e suas partes'),(799,'2100100','73218100','Foges de cozinha de uso domstico e suas partes'),(800,'2100100','73219000','Foges de cozinha de uso domstico e suas partes'),(801,'2100200','84181000','Combinaes de refrigeradores e congeladores (\"freezers\"), munidos de portas exteriores separadas'),(802,'2100300','84182100','Refrigeradores do tipo domstico, de compresso'),(803,'2100400','84182900','Outros refrigeradores do tipo domstico'),(804,'2100500','84183000','Congeladores (\"freezers\") horizontais tipo arca, de capacidade no superior a 800 litros'),(805,'2100600','84184000','Congeladores (\"freezers\") verticais tipo armrio, de capacidade no superior a 900 litros'),(806,'2100700','841850','Outros mveis (arcas, armrios, vitrines, balces e mveis semelhantes) para a conservao e exposio de produtos, que incorporem um equipamento para a produo de frio'),(807,'2100800','8418699','Mini adega e similares'),(808,'2100900','84186999','Mquinas para produo de gelo'),(809,'2101000','84189900','Partes dos refrigeradores, congeladores, mini adegas e similares, mquinas para produo de gelo e bebedouros descritos nos itens 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0 e 13.0.'),(810,'2101100','842112','Secadoras de roupa de uso domstico'),(811,'2101200','84211990','Outras secadoras de roupas e centrfugas de uso domstico'),(812,'2101300','84186931','Bebedouros refrigerados para gua'),(813,'2101400','84219','Partes das secadoras de roupas e centrfugas de uso domstico e dos aparelhos para filtrar ou depurar gua, descritos nos itens 11.0 e 12.0'),(814,'2101500','84221100','Mquinas de lavar loua do tipo domstico e suas partes'),(815,'2101500','84229010','Mquinas de lavar loua do tipo domstico e suas partes'),(816,'2101600','844331','Mquinas que executem pelo menos duas das seguintes funes: impresso, cpia ou transmisso de telecpia (fax), capazes de ser conectadas a uma mquina'),(817,'2101700','844332','Outras impressoras, mquinas copiadoras e telecopiadores (fax), mesmo combinados entre si, capazes de ser conectados a uma mquina automtica para processamento de dados ou a uma rede'),(818,'2101800','844399','Partes e acessrios de mquinas e aparelhos de impresso por meio de blocos, cilindros e outros elementos de impresso da posio 8442; e de outras impressoras, mquinas copiadoras e telecopiadores (fax), mesmo combinados entre si'),(819,'2101900','84501100','Mquinas de lavar roupa, mesmo com dispositivos de secagem, de uso domstico, de capacidade no superior a 10 kg, em peso de roupa seca, inteiramente automticas'),(820,'2102000','84501200','Outras mquinas de lavar roupa, mesmo com dispositivos de secagem, de uso domstico, com secador centrfugo incorporado'),(821,'2102100','84501900','Outras mquinas de lavar roupa, mesmo com dispositivos de secagem, de uso domstico'),(822,'2102200','845020','Mquinas de lavar roupa, mesmo com dispositivos de secagem, de uso domstico, de capacidade superior a 10 kg, em peso de roupa seca'),(823,'2102300','845090','Partes de mquinas de lavar roupa, mesmo com dispositivos de secagem, de uso domstico'),(824,'2102400','84512100','Mquinas de secar de uso domstico de capacidade no superior a 10 kg, em peso de roupa seca'),(825,'2102500','84512990','Outras mquinas de secar de uso domstico'),(826,'2102600','845190','Partes de mquinas de secar de uso domstico'),(827,'2102700','84521000','Mquinas de costura de uso domstico'),(828,'2102800','847130','Mquinas automticas para processamento de dados, portteis, de peso no superior a 10 kg, contendo pelo menos uma unidade central de processamento, um teclado e uma tela'),(829,'2102900','84714','Outras mquinas automticas para processamento de dados'),(830,'2103000','84715010','Unidades de processamento, de pequena capacidade, exceto as das subposies 8471.41 ou 8471.49, podendo conter, no mesmo corpo, um ou dois dos seguintes tipos de unidades: unidade de memria, unidade de entrada e unidade de sada;baseadas em microprocessa'),(831,'2103100','8471605','Unidades de entrada, exceto as classificadas na posio 8471.60.54'),(832,'2103200','84716090','Outras unidades de entrada ou de sada, podendo conter, no mesmo corpo, unidades de memria'),(833,'2103300','847170','Unidades de memria'),(834,'2103400','847190','Outras mquinas automticas para processamento de dados e suas unidades; leitores magnticos ou pticos, mquinas para registrar dados em suporte sob forma codificada, e mquinas para processamento desses dados, no especificadas nem compreendidas em outr'),(835,'2103500','847330','Partes e acessrios das mquinas da posio 84.71'),(836,'2103600','85043','Outros transformadores, exceto os classificados nas posies 8504.33.00 e 8504.34.00'),(837,'2103700','85044010','Carregadores de acumuladores'),(838,'2103800','85044040','Equipamentos de alimentao ininterrupta de energia (UPS ou \"no break\")'),(839,'2103900','85078000','Outros acumuladores'),(840,'2104000','8508','Aspiradores'),(841,'2104100','8509','Aparelhos eletromecnicos de motor eltrico incorporado, de uso domstico e suas partes'),(842,'2104200','85098010','Enceradeiras'),(843,'2104300','85161000','Chaleiras eltricas'),(844,'2104400','85164000','Ferros eltricos de passar'),(845,'2104500','85165000','Fornos de microondas'),(846,'2104600','85166000','Outros fornos; fogareiros (includas as chapas de coco), grelhas e assadeiras, exceto os portteis'),(847,'2104700','85166000','Outros fornos; fogareiros (includas as chapas de coco), grelhas e assadeiras, portteis'),(848,'2104800','85167100','Outros aparelhos eletrotrmicos de uso domstico  Cafeteiras'),(849,'2104900','85167200','Outros aparelhos eletrotrmicos de uso domstico - Torradeiras'),(850,'2105000','851679','Outros aparelhos eletrotrmicos de uso domstico'),(851,'2105100','85169000','Partes das chaleiras, ferros, fornos e outros aparelhos eletrotrmicos da posio 85.16, descritos nos itens 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0 e 50.0'),(852,'2105200','85171100','Aparelhos telefnicos por fio com unidade auscultador- microfone sem fio'),(853,'2105300','851712','Telefones para redes celulares e para outras redes sem fio, exceto os de uso automotivo'),(854,'2105400','8517189','Outros aparelhos telefnicos'),(855,'2105500','8517625','Aparelhos para transmisso ou recepo de voz, imagem ou outros dados em rede com fio, exceto os classificados nas posies 8517.62.51, 8517.62.52 e 8517.62.53'),(856,'2105600','8518','Microfones e seus suportes; altofalantes, mesmo montados nos seus receptculos, fones de ouvido (auscultadores), mesmo combinados com microfone e conj untos ou sortidos constitudos por um microfone e um ou mais alto-falantes, amplificadores eltricos de'),(857,'2105700','8519','Aparelhos de radiodifuso suscetveis de funcionarem sem fonte externa de energia. Aparelhos de gravao de som; aparelhos de reproduo de som; aparelhos de gravao e de reproduo de som; partes e acessrios; exceto os de uso automotivo'),(858,'2105700','8522','Aparelhos de radiodifuso suscetveis de funcionarem sem fonte externa de energia. Aparelhos de gravao de som; aparelhos de reproduo de som; aparelhos de gravao e de reproduo de som; partes e acessrios; exceto os de uso automotivo'),(859,'2105700','85271','Aparelhos de radiodifuso suscetveis de funcionarem sem fonte externa de energia. Aparelhos de gravao de som; aparelhos de reproduo de som; aparelhos de gravao e de reproduo de som; partes e acessrios; exceto os de uso automotivo'),(860,'2105800','85198190','Outros aparelhos de gravao de som; aparelhos de reproduo de som; aparelhos de gravao e de reproduo de som; partes e acessrios; exceto os de uso automotivo'),(861,'2105900','85219010','Gravador-reprodutor e editor de imagem e som, em discos, por meio magntico, ptico ou optomagntico, exceto de uso automotivo'),(862,'2106000','85219090','Outros aparelhos videofnicos de gravao ou reproduo, mesmo incorporando um receptor de sinais videofnicos, exceto os de uso automotivo'),(863,'2106100','85235110','Cartes de memria (\"memory cards\")'),(864,'2106200','85235200','Cartes inteligentes (\"smart cards\")'),(865,'2106300','8525802','Cmeras fotogrficas digitais e cmeras de vdeo e suas partes'),(866,'2106400','85279','Outros aparelhos receptores para radiodifuso, mesmo combinados num invlucro, com um aparelho de gravao ou de reproduo de som, ou com um relgio, inclusive caixa acstica para Home Theaters classificados na posio 8518'),(867,'2106500','85284929','Monitores e projetores que no incorporem aparelhos receptores de televiso, policromticos'),(868,'2106500','85285920','Monitores e projetores que no incorporem aparelhos receptores de televiso, policromticos'),(869,'2106500','852869','Monitores e projetores que no incorporem aparelhos receptores de televiso, policromticos'),(870,'2106600','85285120','Outros monitores dos tipos utilizados exclusiva ou principalmente com uma mquina automtica para processamento de dados da posio 84.71, policromticos'),(871,'2106700','85287','Aparelhos receptores de televiso, mesmo que incorporem um aparelho receptor de radiodifuso ou um aparelho de gravao ou reproduo de som ou de imagens - Televisores de CRT (tubo de raios catdicos).'),(872,'2106800','85287','Aparelhos receptores de televiso, mesmo que incorporem um aparelho receptor de radiodifuso ou um aparelho de gravao ou reproduo de som ou de imagens - Televisores de LCD (Display de Cristal Lquido)'),(873,'2106900','85287','Aparelhos receptores de televiso, mesmo que incorporem um aparelho receptor de radiodifuso ou um aparelho de gravao ou reproduo de som ou de imagens - Televisores de Plasma'),(874,'2107000','85287','Outros aparelhos receptores de televiso no dotados de monitores ou display de vdeo'),(875,'2107100','85287','Outros aparelhos receptores de televiso no relacionados em outros itens deste anexo'),(876,'2107200','900610','Cmeras fotogrficas dos tipos utilizadas para preparao de clichs ou cilindros de impresso'),(877,'2107300','90064000','Cmeras fotogrficas para filmes de revelao e copiagem instantneas'),(878,'2107400','90189050','Aparelhos de diatermia'),(879,'2107500','90191000','Aparelhos de massagem'),(880,'2107600','90328911','Reguladores de voltagem eletrnicos'),(881,'2107700','95045000','Consoles e mquinas de jogos de vdeo, exceto os classificados na subposio 9504.30'),(882,'2107800','8517621','Multiplexadores e concentradores'),(883,'2107900','85176222','Centrais automticas privadas, de capacidade inferior ou igual a 25 ramais'),(884,'2108000','85176239','Outros aparelhos para comutao'),(885,'2108100','8517624','Roteadores digitais, em redes com ou sem fio'),(886,'2108200','85176262','Aparelhos emissores com receptor incorporado de sistema troncalizado (\"trunking\"), de tecnologia celular'),(887,'2108300','8517629','Outros aparelhos de recepo, converso e transmisso ou regenerao de voz, imagens ou outros dados, incluindo os aparelhos de comutao e roteamento'),(888,'2108400','85177021','Antenas prprias para telefones celulares portteis, exceto as telescpicas'),(889,'2108500','821490','Aparelhos ou mquinas de barbear, mquinas de cortar o cabelo ou de tosquiar e aparelhos de depilar, e suas partes'),(890,'2108500','8510','Aparelhos ou mquinas de barbear, mquinas de cortar o cabelo ou de tosquiar e aparelhos de depilar, e suas partes'),(891,'2108600','84145','Ventiladores, exceto os de uso agrcola'),(892,'2108700','84145990','Ventiladores de uso agrcola'),(893,'2108800','84146000','Coifas com dimenso horizontal mxima no superior a 120 cm'),(894,'2108900','84149020','Partes de ventiladores ou coifas aspirantes'),(895,'2109000','841510','Mquinas e aparelhos de ar condicionado contendo um ventilador motorizado e dispositivos prprios para modificar a temperatura e a umidade, includos as mquinas e aparelhos em que a umidade no seja regulvel separadamente e suas partes e peas'),(896,'2109000','84158','Mquinas e aparelhos de ar condicionado contendo um ventilador motorizado e dispositivos prprios para modificar a temperatura e a umidade, includos as mquinas e aparelhos em que a umidade no seja regulvel separadamente e suas partes e peas'),(897,'2109100','84151011','Aparelhos de ar-condicionado tipo Split System (sistema com elementos separados) com unidade externa e interna'),(898,'2109200','84151019','Aparelhos de ar-condicionado com capacidade inferior ou igual a 30.000 frigorias/hora'),(899,'2109300','84151090','Aparelhos de ar-condicionado com capacidade acima de 30.000 frigorias/hora'),(900,'2109400','84159010','Unidades evaporadoras (internas) de aparelho de ar-condicionado do tipo Split System (sistema com elementos separados), com capacidade inferior ou igual a 30.000 frigorias/hora'),(901,'2109500','84159020','Unidades condensadoras (externas) de aparelho de ar-condicionado do tipo Split System (sistema com elementos separados), com capacidade inferior ou igual a 30.000 frigorias/hora'),(902,'2109600','84212100','Aparelhos eltricos para filtrar ou depurar gua (purificadores de gua refrigerados)'),(903,'2109700','84243010','Lavadora de alta presso e suas partes'),(904,'2109700','84243090','Lavadora de alta presso e suas partes'),(905,'2109700','84249090','Lavadora de alta presso e suas partes'),(906,'2109800','84672100','Furadeiras eltricas'),(907,'2109900','85162','Aparelhos eltricos para aquecimento de ambientes'),(908,'2110000','85163100','Secadores de cabelo'),(909,'2110100','85163200','Outros aparelhos para arranjos do cabelo'),(910,'2110200','8518','Microfones e seus suportes; alto-falantes, mesmo montados nos seus receptculos, fones de ouvido (auscultadores), mesmo combinados com microfone e conjuntos ou sortidos constitudos por um microfone e um ou mais alto-falantes, amplificadores eltricos de'),(911,'2110300','8527','Aparelhos receptores para radiodifuso, mesmo combinados num mesmo invlucro, com um aparelho de gravao ou de reproduo de som, ou com um relgio, exceto os classificados na posio 8527.2 que sejam de uso automotivo'),(912,'2110400','85219090','Outros aparelhos videofnicos de gravao ou de reproduo, mesmo incorporando um receptor de sinais videofnicos'),(913,'2110500','84796000','Climatizadores de ar'),(914,'2110600','84159090','Outras partes para mquinas e aparelhos de arcondicionado que contenham um ventilador motorizado e dispositivos prprios para modificar a temperatura e a umidade, incluindo as mquinas e aparelhos em que a umidade no seja regulvel separadamente'),(915,'2110700','85258019','Cmeras de televiso e suas partes'),(916,'2110800','84231000','Balanas de uso domstico'),(917,'2110900','8540','Tubos e vlvulas, eletrnicos, de ctodo quente, ctodo frio ou fotoctodo (por exemplo, tubos e vlvulas, de vcuo, de vapor ou de gs, ampolas retificadoras de vapor de mercrio, tubos catdicos, tubos e vlvulas para cmeras de televiso)'),(918,'2111000','8517','Aparelhos eltricos para telefonia; outros aparelhos para transmisso ou recepo de voz, imagens ou outros dados, includos os aparelhos para comunicao em redes por fio ou redes sem fio (tal como uma rede local (LAN) ou uma rede de rea estendida (WAN)'),(919,'2111100','8517','Interfones, seus acessrios, tomadas e \"plugs\"'),(920,'2111200','8529','Partes reconhecveis como exclusiva ou principalmente destinadas aos aparelhos das posies 8525 a 8528; exceto as de uso automotivo'),(921,'2111300','8531','Aparelhos eltricos de sinalizao acstica ou visual (por exemplo, campainhas, sirenes, quadros indicadores, aparelhos de alarme para proteo contra roubo ou incndio); exceto os de uso automotivo e os classificados nas posies 8531.10 e 8531.80.00.'),(922,'2111400','853110','Aparelhos eltricos de alarme, para proteo contra roubo ou incndio e aparelhos semelhantes, exceto os de uso automotivo'),(923,'2111500','85318000','Outros aparelhos de sinalizao acstica ou visual, exceto os de uso automotivo'),(924,'2111600','853400','Circuitos impressos, exceto os de uso automotivo'),(925,'2111700','85414011','Diodos emissores de luz (LED), exceto diodos \"laser\"'),(926,'2111700','85414021','Diodos emissores de luz (LED), exceto diodos \"laser\"'),(927,'2111700','85414022','Diodos emissores de luz (LED), exceto diodos \"laser\"'),(928,'2111800','85437092','Eletrificadores de cercas eletrnicos'),(929,'2111900','90303','Aparelhos e instrumentos para medida ou controle da tenso, intensidade, resistncia ou da potncia, sem dispositivo registrador; exceto os de uso automotivo'),(930,'2112000','903089','Analisadores lgicos de circuitos digitais, de espectro de frequncia, frequencmetros, fasmetros, e outros instrumentos e aparelhos de controle de grandezas eltricas e deteco'),(931,'2112100','910700','Interruptores horrios e outros aparelhos que permitam acionar um mecanismo em tempo determinado, munidos de maquinismo de aparelhos de relojoaria ou de motor sncrono'),(932,'2112200','9405','Aparelhos de iluminao (includos os projetores) e suas partes, no especificados nem compreendidos em outras posies; anncios, cartazes ou tabuletas e placas indicadoras luminosos, e artigos semelhantes, contendo uma fonte luminosa fixa permanente, e'),(933,'2200100','2309','Rao tipo pet para animais domsticos'),(934,'2300100','210500','Sorvetes de qualquer espcie'),(935,'2300200','1806','Preparados para fabricao de sorvete em mquina'),(936,'2300200','1901','Preparados para fabricao de sorvete em mquina'),(937,'2300200','2106','Preparados para fabricao de sorvete em mquina'),(938,'2400100','3208','Tintas, vernizes'),(939,'2400100','3209','Tintas, vernizes'),(940,'2400100','3210','Tintas, vernizes'),(941,'2400200','2821','Xadrez e ps assemelhados, exceto pigmentos  base de dixido de titnio classificados na posio 3206.11.19'),(942,'2400200','32041700','Xadrez e ps assemelhados, exceto pigmentos  base de dixido de titnio classificados na posio 3206.11.19'),(943,'2400200','3206','Xadrez e ps assemelhados, exceto pigmentos  base de dixido de titnio classificados na posio 3206.11.19'),(944,'2500100','87021000','Veculos automveis para transporte de 10 pessoas ou mais, incluindo o motorista, com motor de pisto, de ignio por compresso (diesel ou semidiesel), com volume interno de habitculo, destinado a passageiros e motorista, superior a 6 m, mas inferior a'),(945,'2500200','87029090','Outros veculos automveis para transporte de 10 pessoas ou mais, incluindo o motorista, com volume interno de habitculo, destinado a passageiros e motorista, superior a 6 m, mas inferior a 9 m'),(946,'2500300','87032100','Automveis com motor exploso, de cilindrada no superior a 1000 cm'),(947,'2500400','87032210','Automveis com motor exploso, de cilindrada superior a 1000 cm, mas no superior a 1500 cm, com capacidade de transporte de pessoas sentadas inferior ou igual a 6, includo o condutor, exceto carro celular'),(948,'2500500','87032290','Outros automveis com motor exploso, de cilindrada superior a 1000 cm, mas no superior a 1500 cm, exceto carro celular'),(949,'2500600','87032310','Automveis com motor exploso, de cilindrada superior a 1500 cm, mas no superior a 3000 cm, com capacidade de transporte de pessoas sentadas inferior ou igual a 6, includo o condutor, exceto carro celular, carro funerrio e automveis de corrida'),(950,'2500700','87032390','Outros automveis com motor exploso, de cilindrada superior a 1500 cm, mas no superior a 3000 cm, exceto carro celular, carro funerrio e automveis de corrida'),(951,'2500800','87032410','Automveis com motor exploso, de cilindrada superior a 3000 cm, com capacidade de transporte de pessoas sentadas inferior ou igual a 6, includo o condutor, exceto carro celular, carro funerrio e automveis de corrida'),(952,'2500900','87032490','Outros automveis com motor exploso, de cilindrada superior a 3000 cm, exceto carro celular, carro funerrio e automveis de corrida'),(953,'2501000','87033210','Automveis com motor diesel ou semidiesel, de cilindrada superior a 1500 cm, mas no superior a 2500 cm, com capacidade de transporte de pessoas sentadas inferior ou igual a 6, includo o condutor, exceto ambulncia, carro celular e carro funerrio'),(954,'2501100','87033290','Outros automveis com motor diesel ou semidiesel, de cilindrada superior a 1500 cm, mas no superior a 2500 cm, exceto ambulncia, carro celular e carro funerrio'),(955,'2501200','87033310','Automveis com motor diesel ou semidiesel, de cilindrada superior a 2500 cm, com capacidade de transporte de pessoas sentadas inferior ou igual a 6, includo o condutor, exceto carro celular e carro funerrio'),(956,'2501300','87033390','Outros automveis com motor diesel ou semidiesel, de cilindrada superior a 2500 cm, exceto carro celular e carro funerrio'),(957,'2501400','87042110','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, chassis com motor diesel ou semidiesel e cabina, exceto caminho de peso em carga mxima superior a 3,9 toneladas'),(958,'2501500','87042120','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, com motor diesel ou semidiesel, com caixa basculante, exceto caminho de peso em carga mxima superior a 3,9 toneladas'),(959,'2501600','87042130','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, frigorficos ou isotrmicos, com motor diesel ou semidiesel, exceto caminho de peso em carga mxima superior a 3,9 toneladas'),(960,'2501700','87042190','Outros veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, com motor diesel ou semidiesel, exceto carro-forte para transporte de valores e caminho de peso em carga mxima superior a 3,9 toneladas'),(961,'2501800','87043110','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, com motor a exploso, chassis e cabina, exceto caminho de peso em carga mxima superior a 3,9 toneladas'),(962,'2501900','87043120','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5, exceto caminho de peso em carga toneladas, com motor exploso, caixa basculante'),(963,'2502000','87043130','Veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, frigorficos ou isotrmicos com motor exploso, exceto caminho de peso em carga mxima superior a 3,9 toneladas'),(964,'2502100','87043190','Outros veculos automveis para transporte de mercadorias, de peso em carga mxima no superior a 5 toneladas, com motor a exploso, exceto carro-forte para transporte de valores e caminho de peso em carga mxima superior a 3,9 toneladas'),(965,'2600100','8711','Motocicletas (includos os ciclomotores) e outros ciclos equipados com motor auxiliar, mesmo com carro lateral; carros laterais'),(966,'2700100','7009','Espelhos de vidro, mesmo emoldurados, exceto os de uso automotivo'),(967,'2700200','7013','Objetos de vidro para servio de mesa ou de cozinha'),(968,'2700300','70133700','Outros copos, exceto de vitrocermica'),(969,'2700400','70134290','Objetos para servio de mesa (exceto copos) ou de cozinha, exceto de vitrocermica'),(970,'2800100','33030010','Perfumes (extratos)'),(971,'2800200','33030020','guas-de-colnia'),(972,'2800300','33041000','Produtos de maquiagem para os lbios'),(973,'2800400','33042010','Sombra, delineador, lpis para sobrancelhas e rmel'),(974,'2800500','33042090','Outros produtos de maquiagem para os olhos'),(975,'2800600','33043000','Preparaes para manicuros e pedicuros'),(976,'2800700','33049100','Ps para maquiagem, incluindo os compactos'),(977,'2800800','33049910','Cremes de beleza, cremes nutritivos e loes tnicas'),(978,'2800900','33049990','Outros produtos de beleza ou de maquiagem preparados e preparaes para conservao ou cuidados da pele, exceto as preparaes antisolares e os bronzeadores'),(979,'2801000','33049990','Preparaes antisolares e os bronzeadores'),(980,'2801100','33051000','Xampus para o cabelo'),(981,'2801200','33052000','Preparaes para ondulao ou alisamento, permanentes, dos cabelos'),(982,'2801300','33059000','Outras preparaes capilares'),(983,'2801400','33059000','Tintura para o cabelo'),(984,'2801500','33071000','Preparaes para barbear (antes, durante ou aps)'),(985,'2801600','33072010','Desodorantes corporais e antiperspirantes, lquidos'),(986,'2801700','33072090','Outros desodorantes corporais e antiperspirantes'),(987,'2801800','33079000','Outros produtos de perfumaria ou de toucador preparados'),(988,'2801900','33079000','Outras preparaes cosmticas'),(989,'2802000','34011190','Sabes de toucador, em barras, pedaos ou figuras moldadas'),(990,'2802100','34011900','Outros sabes, produtos e preparaes orgnicos tensoativos, inclusive papel, pastas (ouates), feltros e falsos tecidos, impregnados, revestidos ou recobertos de sabo ou de detergentes'),(991,'2802200','34012010','Sabes de toucador sob outras formas'),(992,'2802300','34013000','Produtos e preparaes orgnicos tensoativos para lavagem da pele, em forma de lquido ou de creme, acondicionados para venda a retalho, mesmo contendo sabo'),(993,'2802400','48182000','Lenos de papel, incluindo os de desmaquiar'),(994,'2802500','82141000','Apontadores de lpis para maquiagem'),(995,'2802600','82142000','Utenslios e sortidos de utenslios de manicuros ou de pedicuros (incluindo as limas para unhas)'),(996,'2802700','96032900','Escovas e pincis de barba, escovas para cabelos, para clios ou para unhas e outras escovas de toucador de pessoas'),(997,'2802800','96033000','Pincis para aplicao de produtos cosmticos'),(998,'2802900','96161000','Vaporizadores de toucador, suas armaes e cabeas de armaes'),(999,'2803000','96162000','Borlas ou esponjas para ps ou para aplicao de outros cosmticos ou de produtos de toucador'),(1000,'2803100','42021','Malas e maletas de toucador'),(1001,'2803200','9615','Pentes, travessas para cabelo e artigos semelhantes; grampos (alfinetes) para cabelo; pinas (pinceguiches), onduladores, bobs (rolos) e artefatos semelhantes para penteados, e suas partes'),(1002,'2803300','39241000','Mamadeiras'),(1003,'2803300','39249000','Mamadeiras'),(1004,'2803300','40149090','Mamadeiras'),(1005,'2803400','40149090','Chupetas e bicos para mamadeiras e para chupetas'),(1006,'2803500','33','Outros produtos cosmticos e de higiene pessoal no relacionados em outros itens deste anexo'),(1007,'2803500','34','Outros produtos cosmticos e de higiene pessoal no relacionados em outros itens deste anexo'),(1008,'2803600','44','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1009,'2803600','64','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1010,'2803600','65','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1011,'2803600','82','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1012,'2803600','90','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1013,'2803600','96','Outros artigos destinados a cuidados pessoais no relacionados em outros itens deste anexo'),(1014,'2803700','39','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1015,'2803700','48','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1016,'2803700','91','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1017,'2803700','42','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1018,'2803700','71','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1019,'2803700','83','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1020,'2803700','90','Acessrios (por exemplo, bijuterias, relgios, culos de sol, bolsas, mochilas, frasqueiras, carteiras, porta-cartes, porta-documentos, porta-celulares e embalagens presenteveis (por exemplo, caixinhas de papel), entre outros itens assemelhados)'),(1021,'2803800','61','Vesturio e seus acessrios; calados, polainas e artefatos semelhantes, e suas partes'),(1022,'2803800','62','Vesturio e seus acessrios; calados, polainas e artefatos semelhantes, e suas partes'),(1023,'2803800','64','Vesturio e seus acessrios; calados, polainas e artefatos semelhantes, e suas partes'),(1024,'2803900','42','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1025,'2803900','52','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1026,'2803900','55','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1027,'2803900','58','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1028,'2803900','63','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1029,'2803900','65','Outros artigos de vesturio em geral, exceto os relacionados no item anterior'),(1030,'2804000','39','Artigos de casa'),(1031,'2804000','40','Artigos de casa'),(1032,'2804000','56','Artigos de casa'),(1033,'2804000','63','Artigos de casa'),(1034,'2804000','66','Artigos de casa'),(1035,'2804000','69','Artigos de casa'),(1036,'2804000','70','Artigos de casa'),(1037,'2804000','73','Artigos de casa'),(1038,'2804000','82','Artigos de casa'),(1039,'2804000','83','Artigos de casa'),(1040,'2804000','84','Artigos de casa'),(1041,'2804000','91','Artigos de casa'),(1042,'2804000','94','Artigos de casa'),(1043,'2804000','96','Artigos de casa'),(1044,'2804100','13','Produtos das indstrias alimentares e bebidas'),(1045,'2804100','15','Produtos das indstrias alimentares e bebidas'),(1046,'2804100','23','Produtos das indstrias alimentares e bebidas'),(1047,'2804200','33','Produtos destinados  higiene bucal'),(1048,'2804300','22','Produtos de limpeza e conservao domstica'),(1049,'2804300','27','Produtos de limpeza e conservao domstica'),(1050,'2804300','28','Produtos de limpeza e conservao domstica'),(1051,'2804300','29','Produtos de limpeza e conservao domstica'),(1052,'2804300','33','Produtos de limpeza e conservao domstica'),(1053,'2804300','34','Produtos de limpeza e conservao domstica'),(1054,'2804300','35','Produtos de limpeza e conservao domstica'),(1055,'2804300','38','Produtos de limpeza e conservao domstica'),(1056,'2804300','39','Produtos de limpeza e conservao domstica'),(1057,'2804300','63','Produtos de limpeza e conservao domstica'),(1058,'2804300','68','Produtos de limpeza e conservao domstica'),(1059,'2804300','73','Produtos de limpeza e conservao domstica'),(1060,'2804300','84','Produtos de limpeza e conservao domstica'),(1061,'2804300','85','Produtos de limpeza e conservao domstica'),(1062,'2804300','86','Produtos de limpeza e conservao domstica'),(1063,'2804400','','Outros produtos comercializados pelo sistema de marketing direto porta-a-porta a consumidor final no relacionados em outros itens deste anexo'),(1064,'0100100','38151210','Catalisadores em colmeia cermica ou metlica para converso cataltica de gases de escape de veculos e outros catalizadores'),(1065,'0100100','38151290','Catalisadores em colmeia cermica ou metlica para converso cataltica de gases de escape de veculos e outros catalizadores'),(1066,'0100200','3917','Tubos e seus acessrios (por exemplo, juntas, cotovelos, flanges, unies), de plsticos'),(1067,'0100300','39181000','Protetores de caamba'),(1068,'0100400','39233000','Reservatrios de leo'),(1069,'0100500','39263000','Frisos, decalques, molduras e acabamentos'),(1070,'0100600','40103','Correias de transmisso de borracha vulcanizada, de matrias txteis, mesmo impregnadas, revestidas ou recobertas, de plstico, ou estratificadas com plstico ou reforadas com metal ou com outras matrias'),(1071,'0100600','59100000','Correias de transmisso de borracha vulcanizada, de matrias txteis, mesmo impregnadas, revestidas ou recobertas, de plstico, ou estratificadas com plstico ou reforadas com metal ou com outras matrias'),(1072,'0100700','40169300','Juntas, gaxetas e outros elementos com funo semelhante de vedao'),(1073,'0100700','4823909','Juntas, gaxetas e outros elementos com funo semelhante de vedao'),(1074,'0100800','40161010','Partes de veculos automveis, tratores e mquinas autopropulsadas'),(1075,'0100900','40169990','Tapetes, revestimentos, mesmo confeccionados, batentes, buchas e coxins'),(1076,'0100900','57050000','Tapetes, revestimentos, mesmo confeccionados, batentes, buchas e coxins'),(1077,'0101000','59039000','Tecidos impregnados, revestidos, recobertos ou estratificados, com plstico'),(1078,'0101100','59090000','Mangueiras e tubos semelhantes, de matrias txteis, mesmo com reforo ou acessrios de outras matrias'),(1079,'0101200','63061','Encerados e toldos'),(1080,'0101300','65061000','Capacetes e artefatos de uso semelhante, de proteo, para uso em motocicletas, includos ciclomotores'),(1081,'0101400','6813','Guarnies de frico (por exemplo, placas, rolos, tiras, segmentos, discos, anis, pastilhas), no montadas, para freios, embreagens ou qualquer outro mecanismo de frico,  base de amianto, de outras substncias minerais ou de celulose, mesmo combinada'),(1082,'0101500','70071100','Vidros de dimenses e formatos que permitam aplicao automotiva'),(1083,'0101500','70072100','Vidros de dimenses e formatos que permitam aplicao automotiva'),(1084,'0101600','70091000','Espelhos retrovisores'),(1085,'0101700','70140000','Lentes de faris, lanternas e outros utenslios'),(1086,'0101800','73110000','Cilindro de ao para GNV (gs natural veicular)'),(1087,'0101900','73110000','Recipientes para gases comprimidos ou liquefeitos, de ferro fundido, ferro ou ao, exceto o descrito no item 18.0'),(1088,'0102000','7320','Molas e folhas de molas, de ferro ou ao'),(1089,'0102100','7325','Obras moldadas, de ferro fundido, ferro ou ao, exceto as do cdigo 7325.91.00'),(1090,'0102200','780600','Peso de chumbo para balanceamento de roda'),(1091,'0102300','80070090','Peso para balanceamento de roda e outros utenslios de estanho'),(1092,'0102400','830120','Fechaduras e partes de fechaduras'),(1093,'0102400','830160','Fechaduras e partes de fechaduras'),(1094,'0102500','830170','Chaves apresentadas isoladamente'),(1095,'0102600','83021000','Dobradias, guarnies, ferragens e artigos semelhantes de metais comuns'),(1096,'0102600','83023000','Dobradias, guarnies, ferragens e artigos semelhantes de metais comuns'),(1097,'0102700','831000','Tringulo de segurana'),(1098,'0102800','84073','Motores de pisto alternativo dos tipos utilizados para propulso de veculos do Captulo 87'),(1099,'0102900','840820','Motores dos tipos utilizados para propulso de veculos automotores'),(1100,'0103000','84099','Partes reconhecveis como exclusiva ou principalmente destinadas aos motores das posies 8407 ou 8408'),(1101,'0103100','84122','Motores hidrulicos'),(1102,'0103200','841330','Bombas para combustveis, lubrificantes ou lquidos de arrefecimento, prprias para motores de ignio por centelha ou por compresso'),(1103,'0103300','84141000','Bombas de vcuo'),(1104,'0103400','8414801','Compressores e turbocompressores de ar'),(1105,'0103400','8414802','Compressores e turbocompressores de ar'),(1106,'0103500','84139190','Partes das bombas, compressores e turbocompressores dos itens 32.0, 33.0 e 34.0'),(1107,'0103500','84149010','Partes das bombas, compressores e turbocompressores dos itens 32.0, 33.0 e 34.0'),(1108,'0103500','8414903','Partes das bombas, compressores e turbocompressores dos itens 32.0, 33.0 e 34.0'),(1109,'0103500','84149039','Partes das bombas, compressores e turbocompressores dos itens 32.0, 33.0 e 34.0'),(1110,'0103600','841520','Mquinas e aparelhos de ar condicionado'),(1111,'0103700','84212300','Aparelhos para filtrar leos minerais nos motores de ignio por centelha ou por compresso'),(1112,'0103800','84212990','Filtros a vcuo'),(1113,'0103900','84219','Partes dos aparelhos para filtrar ou depurar lquidos ou gases'),(1114,'0104000','84241000','Extintores, mesmo carregados'),(1115,'0104100','84213100','Filtros de entrada de ar para motores de ignio por centelha ou por compresso'),(1116,'0104200','84213920','Depuradores por converso cataltica de gases de escape');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cest` ENABLE KEYS */;

--
-- Table structure for table `cfop`
--

DROP TABLE IF EXISTS `cfop`;
CREATE TABLE `cfop` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` int(10) unsigned default NULL,
  `Descricao` varchar(75) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=540 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cfop`
--


/*!40000 ALTER TABLE `cfop` DISABLE KEYS */;
LOCK TABLES `cfop` WRITE;
INSERT INTO `cfop` (`Id`, `Codigo`, `Descricao`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1101,'COMPRA P/ INDUSTRIALIZACAO OU PRODUCAO RURAL',1,'2009-08-19 00:32:03'),(2,1102,'COMPRA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:03'),(3,1111,'COMPRA P/ INDUSTRIALIZACAO, MERC. RECEBIDA EM CONSIG. INDUSTRIAL',1,'2009-08-19 00:32:03'),(4,1113,'COMPRA P/ COMERCIALIZACAO, MERC. RECEBIDA EM CONSIGNACAO MERCANTIL',1,'2009-08-19 00:32:03'),(5,1116,'COMPRA P/INDUSTRIAL OU PROD RURAL ORIG. DE ENCOMENDA P/ RECEB. FUTURO',1,'2009-08-19 00:32:03'),(6,1117,'COMPRA P/ COMERCIALIZACAO, ORIGEM ENCOMENDA P/ RECEBIMENTO FUTURO',1,'2009-08-19 00:32:03'),(7,1118,'COMPRA P/ COMERC. PELO ORIGINARIO, ENTREGUE DESTINAT, VENDA A ORDEM',1,'2009-08-19 00:32:03'),(8,1120,'COMPRA P/ INDUST., VENDA A ORDEM, RECEBIDA DO VENDEDOR REMETENTE',1,'2009-08-19 00:32:03'),(9,1121,'COMPRA P/ COMERC., VENDA A ORDEM, JA RECEBIDA DO VENDEDOR REMETENTE',1,'2009-08-19 00:32:03'),(10,1122,'COMPRA P/ INDUST., MERC. P/ INDUSTRIALIZADOR, NAO TRANSITA ESTAB.',1,'2009-08-19 00:32:03'),(11,1124,'INDUSTRIALIZACAO EFETUADA POR OUTRA EMPRESA',1,'2009-08-19 00:32:03'),(12,1125,'INDUST. OUTRA EMPRESA, MERC REMETIDA P/ INDUST, NAO TRANSITA ESTAB.',1,'2009-08-19 00:32:03'),(13,1126,'COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:03'),(14,1151,'TRANSFERENCIA P/ INDUSTRIALIZACAO',1,'2009-08-19 00:32:03'),(15,1152,'TRANSFERENCIA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:03'),(16,1153,'TRANSFERENCIA DE ENERGIA ELETRICA P/ DISTRIBUICAO',1,'2009-08-19 00:32:03'),(17,1154,'TRANSFERENCIA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:03'),(18,1201,'DEVOLUCAO VENDA DE PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:03'),(19,1202,'DEVOLUCAO VENDA DE MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:03'),(20,1203,'DEVOLUCAO VENDA PRODUCAO ESTAB. P/ ZONA FRANCA OU ALC',1,'2009-08-19 00:32:03'),(21,1204,'DEVOLUCAO VENDA MERC. ADQUIRIDA-REC. 3, DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:03'),(22,1205,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:03'),(23,1206,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:03'),(24,1207,'ANULACAO VALOR RELATIVO A VENDA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:04'),(25,1208,'DEVOLUCAO PRODUCAO DO ESTABELECIMENTO, REMETIDA EM TRANSFERENCIA',1,'2009-08-19 00:32:04'),(26,1209,'DEVOLUCAO MERCADORIA ADQUIRIDA OU RECEBIDA 3, REMETIDA EM TRANSF.',1,'2009-08-19 00:32:04'),(27,1251,'COMPRA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:04'),(28,1252,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:04'),(29,1253,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:04'),(30,1254,'COMPRA ENERGIA ELETR. POR ESTAB. PRESTADOR SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:04'),(31,1255,'COMPRA ENERGIA ELETR. POR ESTAB. PRESTADOR SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:04'),(32,1256,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO DE PRODUTOR RURAL',1,'2009-08-19 00:32:04'),(33,1257,'COMPRA ENERGIA ELETRICA P/ CONSUMO POR DEMANDA CONTRATADA',1,'2009-08-19 00:32:04'),(34,1301,'AQUISICAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:04'),(35,1302,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:04'),(36,1303,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:04'),(37,1304,'AQUISICAO SERVICO COMUNICACAO, ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:04'),(38,1305,'AQUISICAO SERVICO COMUNICACAO, ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:04'),(39,1306,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO PRODUTOR RURAL',1,'2009-08-19 00:32:04'),(40,1351,'AQUISICAO SERVICO TRANSPORTE P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:04'),(41,1352,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:04'),(42,1353,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:04'),(43,1354,'AQUISICAO SERVICO TRANSPORTE, ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:04'),(44,1355,'AQUISICAO SERVICO TRANSPORTE, ESTAB. GERADOR-DISTRIB ENERGIA ELET',1,'2009-08-19 00:32:04'),(45,1356,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO PRODUTOR RURAL',1,'2009-08-19 00:32:04'),(46,1401,'COMPRA P/ INDUST.OU PROD RURAL, MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:04'),(47,1403,'COMPRA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:04'),(48,1406,'COMPRA BEM P/ ATIVO IMOBILIZADO, MERC. REGIME SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:04'),(49,1407,'COMPRA MERC. P/ USO-CONSUMO, MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:04'),(50,1408,'TRANSFERENCIA P/INDUST. OU PROD RURAL , MERC. REGIME SUBST TRIBUT',1,'2009-08-19 00:32:04'),(51,1409,'TRANSFERENCIA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:04'),(52,1410,'DEVOLUCAO VENDA PRODUCAO ESTAB, PRODUTO REGIME SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:04'),(53,1411,'DEVOLUCAO VENDA MERCADORIA ADQUIRIDA-RECEBIDA TERCEIROS, MERC. ST',1,'2009-08-19 00:32:04'),(54,1414,'RETORNO PRODUCAO ESTAB., REMETIDA P/ VENDA FORA ESTAB., PRODUTO ST',1,'2009-08-19 00:32:04'),(55,1415,'RETORNO MERC. ADQUIRIDA-REC. 3, REMETIDA P/ VENDA FORA ESTAB., ST',1,'2009-08-19 00:32:04'),(56,1451,'RETORNO DE ANIMAL DO ESTABELECIMENTO PRODUTOR',1,'2009-08-19 00:32:04'),(57,1452,'RETORNO DE INSUMO NAO UTILIZADO NA PRODUCAO',1,'2009-08-19 00:32:05'),(58,1501,'ENTRADA MERCADORIA RECEBIDA COM FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:05'),(59,1503,'ENTRADA DEVOLUCAO PRODUTO REMETIDO P/ EXPORTACAO, PRODUCAO ESTAB.',1,'2009-08-19 00:32:05'),(60,1504,'ENTRADA DEVOLUCAO MERC. REMETIDA P/ EXPORTACAO, ADQUIRIDA-REC. 3',1,'2009-08-19 00:32:05'),(61,1505,'ENTRADA DECOR DE DEV SIMBOL MERC REMET P FORMACAO LOTE EXPORT PROD IND',1,'2009-08-19 00:32:05'),(62,1506,'ENTRADA DECOR DEV SIMB MERC ADQ OU RECEB TERC, REMET P FORMACAO LOT EX',1,'2009-08-19 00:32:05'),(63,1551,'COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:05'),(64,1552,'TRANSFERENCIA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:05'),(65,1553,'DEVOLUCAO VENDA DE BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:05'),(66,1554,'RETORNO BEM DO ATIVO IMOBILIZADO REMETIDO P/ USO FORA DO ESTAB.',1,'2009-08-19 00:32:05'),(67,1555,'ENTRADA BEM ATIVO IMOBILIZADO DE TERCEIRO, REMETIDO P/ USO ESTAB.',1,'2009-08-19 00:32:05'),(68,1556,'COMPRA MATERIAL P/ USO OU CONSUMO',1,'2009-08-19 00:32:05'),(69,1557,'TRANSFERENCIA MATERIAL P/ USO OU CONSUMO',1,'2009-08-19 00:32:05'),(70,1601,'RECEBIMENTO POR TRANSFERENCIA, DE CREDITO DE ICMS',1,'2009-08-19 00:32:05'),(71,1602,'RECEBIMENTO TRANSF. SALDO CREDOR, OUTRO ESTAB. MESMA EMPRESA, COMPENSA',1,'2009-08-19 00:32:05'),(72,1603,'RESSARCIMENTO ICMS RETIDO POR SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:05'),(73,1604,'LANCAMENTO CREDITO DE COMPRA DE BEM P/ O ATIVO IMOBILIZADO (1)',1,'2009-08-19 00:32:05'),(74,1605,'RECEBIMENTO,POR TRANSFERENCIA,DE SALDO DEVEDOR DE ICMS DE OUTRO ESTABE',1,'2009-08-19 00:32:05'),(75,1651,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA INDUSTRIALIZAAO SUBSEQUENT',1,'2009-08-19 00:32:05'),(76,1652,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA COMERCIALIZAAO',1,'2009-08-19 00:32:05'),(77,1653,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE POR CONSUMIDOR OU USUARIO FINAL',1,'2009-08-19 00:32:05'),(78,1658,'TRANSFERENCIA DE COMBUSTIVEL E LUBRIFICANTE PARA INDUSTRIALIZAAO',1,'2009-08-19 00:32:05'),(79,1659,'TRANSFERENCIA DE COMBUSTIVEL E LUBRIFICANTE PARA COMERCIALIZAAO',1,'2009-08-19 00:32:05'),(80,1660,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A INDUSTRI',1,'2009-08-19 00:32:05'),(81,1661,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A COMERCIO',1,'2009-08-19 00:32:05'),(82,1662,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A CONSUMID',1,'2009-08-19 00:32:05'),(83,1663,'ENTRADA DE COMBUSTIVEL OU LUBRIFICANTE PARA ARMAZENAMENTO',1,'2009-08-19 00:32:05'),(84,1664,'RETORNO DE COMBUSTIVEL OU LUBRIFICANTE REMETIDO PARA ARMAZENAMENTO',1,'2009-08-19 00:32:05'),(85,1901,'ENTRADA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:05'),(86,1902,'RETORNO MERCADORIA REMETIDA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:05'),(87,1903,'ENTRADA MERC. REMETIDA P/ INDUST., NAO APLICADA NO PROCESSO',1,'2009-08-19 00:32:05'),(88,1904,'RETORNO REMESSA P/ VENDA FORA ESTABELECIMENTO',1,'2009-08-19 00:32:05'),(89,1905,'ENTRADA MERC. RECEBIDA P/ DEPOSITO, DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:05'),(90,1906,'RETORNO MERCADORIA REMETIDA P/ DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:05'),(91,1907,'RETORNO SIMBOLICO MERC. REMETIDA P/ DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:06'),(92,1908,'ENTRADA BEM POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:06'),(93,1909,'RETORNO BEM REMETIDO POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:06'),(94,1910,'ENTRADA BONIFICACAO, DOACAO OU BRINDE',1,'2009-08-19 00:32:06'),(95,1911,'ENTRADA AMOSTRA GRATIS',1,'2009-08-19 00:32:06'),(96,1912,'ENTRADA MERCADORIA OU BEM RECEBIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:06'),(97,1913,'RETORNO MERCADORIA OU BEM REMETIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:06'),(98,1914,'RETORNO MERCADORIA OU BEM REMETIDO P/ EXPOSICAO OU FEIRA',1,'2009-08-19 00:32:06'),(99,1915,'ENTRADA MERCADORIA OU BEM RECEBIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:06'),(100,1916,'RETORNO MERCADORIA OU BEM REMETIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:06'),(101,1917,'ENTRADA MERCADORIA RECEBIDA EM CONSIG. MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:06'),(102,1918,'DEVOLUCAO MERCADORIA REMETIDA EM CONSIG. MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:06'),(103,1919,'DEVOLUCAO SIMB. MERC. VENDIDA-UTILIZ. PROC. INDUST, ANTES CONSIG.',1,'2009-08-19 00:32:06'),(104,1920,'ENTRADA VASILHAME OU SACARIA',1,'2009-08-19 00:32:06'),(105,1921,'RETORNO VASILHAME OU SACARIA',1,'2009-08-19 00:32:06'),(106,1922,'LANCAMENTO SIMPLES FATURAMENTO, COMPRA P/ RECEBIMENTO FUTURO',1,'2009-08-19 00:32:06'),(107,1923,'ENTRADA MERCADORIA RECEBIDA DO VENDEDOR REMETENTE, VENDA A ORDEM',1,'2009-08-19 00:32:06'),(108,1924,'ENTRADA P/ INDUST, CONTA-ORDEM ADQUIRENTE, NAO TRANSITA ESTAB. ADQ.',1,'2009-08-19 00:32:06'),(109,1925,'RETORNO MERC. REMETIDA INDUST., CONTA-ORDEM ADQ., NAO TRANSITA ADQ.',1,'2009-08-19 00:32:06'),(110,1926,'LANCAMENTO RECLASS. MERC DE FORMACAO DE KIT OU DE DESAGREGACAO',1,'2009-08-19 00:32:06'),(111,1931,'LANCAMENTO EFETUADO PELO TOMADOR DO SERVIO DE TRANSPORTE QUANDO A RES',1,'2009-08-19 00:32:06'),(112,1932,'AQUISIO DE SERVIO DE TRANSPORTE INICIADO EM UNIDADE DA FEDERAO DI',1,'2009-08-19 00:32:06'),(113,1933,'AQUISIO DE SERVIO TRIBUTADO PELO ISSQN',1,'2009-08-19 00:32:06'),(114,1949,'OUTRA ENTRADA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADA',1,'2009-08-19 00:32:06'),(115,2101,'COMPRA P/ INDUSTRIALIZACAO',1,'2009-08-19 00:32:06'),(116,2102,'COMPRA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:06'),(117,2111,'COMPRA P/ INDUSTRIALIZACAO, MERC. RECEBIDA EM CONSIG. INDUSTRIAL',1,'2009-08-19 00:32:06'),(118,2113,'COMPRA P/ COMERCIALIZACAO, MERC. RECEBIDA EM CONSIGNACAO MERCANTIL',1,'2009-08-19 00:32:06'),(119,2116,'COMPRA P/ INDUST OU PROD RURA ORIG ENCOMENDA P/ RECEB FUTURO',1,'2009-08-19 00:32:06'),(120,2117,'COMPRA P/ COMERCIALIZACAO, ORIGEM ENCOMENDA P/ RECEBIMENTO FUTURO',1,'2009-08-19 00:32:06'),(121,2118,'COMPRA P/ COMERC. PELO ORIGINARIO, ENTREGUE DESTINAT, VENDA A ORDEM',1,'2009-08-19 00:32:06'),(122,2120,'COMPRA P/ INDUST., VENDA A ORDEM, RECEBIDA DO VENDEDOR REMETENTE',1,'2009-08-19 00:32:06'),(123,2121,'COMPRA P/ COMERC., VENDA A ORDEM, JA RECEBIDA DO VENDEDOR REMETENTE',1,'2009-08-19 00:32:06'),(124,2122,'COMPRA P/ INDUST., MERC. P/ INDUSTRIALIZADOR, NAO TRANSITA ESTAB.',1,'2009-08-19 00:32:07'),(125,2124,'INDUSTRIALIZACAO EFETUADA POR OUTRA EMPRESA',1,'2009-08-19 00:32:07'),(126,2125,'INDUST. OUTRA EMPRESA, MERC REMETIDA P/ INDUST, NAO TRANSITA ESTAB.',1,'2009-08-19 00:32:07'),(127,2126,'COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:07'),(128,2151,'TRANSFERENCIA P/ INDUSTRIALIZACAO OU PRODUCAO RURAL',1,'2009-08-19 00:32:07'),(129,2152,'TRANSFERENCIA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:07'),(130,2153,'TRANSFERENCIA DE ENERGIA ELETRICA P/ DISTRIBUICAO',1,'2009-08-19 00:32:07'),(131,2154,'TRANSFERENCIA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:07'),(132,2201,'DEVOLUCAO VENDA DE PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:07'),(133,2202,'DEVOLUCAO VENDA DE MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:07'),(134,2203,'DEVOLUCAO VENDA PRODUCAO ESTAB. P/ ZONA FRANCA OU ALC',1,'2009-08-19 00:32:07'),(135,2204,'DEVOLUCAO VENDA MERC. ADQUIRIDA-REC. 3, DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:07'),(136,2205,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:07'),(137,2206,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:07'),(138,2207,'ANULACAO VALOR RELATIVO A VENDA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:07'),(139,2208,'DEVOLUCAO PRODUCAO DO ESTABELECIMENTO, REMETIDA EM TRANSFERENCIA',1,'2009-08-19 00:32:07'),(140,2209,'DEVOLUCAO MERCADORIA ADQUIRIDA OU RECEBIDA 3, REMETIDA EM TRANSF.',1,'2009-08-19 00:32:07'),(141,2251,'COMPRA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:07'),(142,2252,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:07'),(143,2253,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:07'),(144,2254,'COMPRA ENERGIA ELETR. POR ESTAB. PRESTADOR SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:07'),(145,2255,'COMPRA ENERGIA ELETR. POR ESTAB. PRESTADOR SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:07'),(146,2256,'COMPRA ENERGIA ELETRICA POR ESTABELECIMENTO DE PRODUTOR RURAL',1,'2009-08-19 00:32:07'),(147,2257,'COMPRA ENERGIA ELETRICA P/ CONSUMO POR DEMANDA CONTRATADA',1,'2009-08-19 00:32:07'),(148,2301,'AQUISICAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:07'),(149,2302,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:07'),(150,2303,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:07'),(151,2304,'AQUISICAO SERVICO COMUNICACAO, ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:07'),(152,2305,'AQUISICAO SERVICO COMUNICACAO, ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:07'),(153,2306,'AQUISICAO SERVICO COMUNICACAO, ESTABELECIMENTO PRODUTOR RURAL',1,'2009-08-19 00:32:07'),(154,2351,'AQUISICAO SERVICO TRANSPORTE P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:07'),(155,2352,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:07'),(156,2353,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:07'),(157,2354,'AQUISICAO SERVICO TRANSPORTE, ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:08'),(158,2355,'AQUISICAO SERVICO TRANSPORTE, ESTAB. GERADOR-DISTRIB ENERGIA ELET',1,'2009-08-19 00:32:08'),(159,2356,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO PRODUTOR RURAL',1,'2009-08-19 00:32:08'),(160,2401,'COMPRA P/ INDUST.OU PROD RURAL MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:08'),(161,2403,'COMPRA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:08'),(162,2406,'COMPRA BEM P/ ATIVO IMOBILIZADO, MERC. REGIME SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:08'),(163,2407,'COMPRA MERC. P/ USO-CONSUMO, MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:08'),(164,2408,'TRANSFERENCIA P/ INDUST.OO PROD RURAL MERC. REGIME SUBSTIT TRIBUT',1,'2009-08-19 00:32:08'),(165,2409,'TRANSFERENCIA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:08'),(166,2410,'DEVOLUCAO VENDA PRODUCAO ESTAB, PRODUTO REGIME SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:08'),(167,2411,'DEVOLUCAO VENDA MERCADORIA ADQUIRIDA-RECEBIDA TERCEIROS, MERC. ST',1,'2009-08-19 00:32:08'),(168,2414,'RETORNO PRODUCAO ESTAB., REMETIDA P/ VENDA FORA ESTAB., PRODUTO ST',1,'2009-08-19 00:32:08'),(169,2415,'RETORNO MERC. ADQUIRIDA-REC. 3, REMETIDA P/ VENDA FORA ESTAB., ST',1,'2009-08-19 00:32:08'),(170,2501,'ENTRADA MERCADORIA RECEBIDA COM FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:08'),(171,2503,'ENTRADA DEVOLUCAO PRODUTO REMETIDO P/ EXPORTACAO, PRODUCAO ESTAB.',1,'2009-08-19 00:32:08'),(172,2504,'ENTRADA DEVOLUCAO MERC. REMETIDA P/ EXPORTACAO, ADQUIRIDA-REC. 3',1,'2009-08-19 00:32:08'),(173,2505,'ENTRADA DECOR DEV SIMB MERC REMET P FORMAC LOTE EXP PROD INDUST OU PRO',1,'2009-08-19 00:32:08'),(174,2506,'ENTRADA DECOR DEV SIMB MERC ADQ OU RECEB TERC REMET P FORM LOTE EXPORT',1,'2009-08-19 00:32:08'),(175,2551,'COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:08'),(176,2552,'TRANSFERENCIA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:08'),(177,2553,'DEVOLUCAO VENDA DE BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:08'),(178,2554,'RETORNO BEM DO ATIVO IMOBILIZADO REMETIDO P/ USO FORA DO ESTAB.',1,'2009-08-19 00:32:08'),(179,2555,'ENTRADA BEM ATIVO IMOBILIZADO DE TERCEIRO, REMETIDO P/ USO ESTAB.',1,'2009-08-19 00:32:08'),(180,2556,'COMPRA MATERIAL P/ USO OU CONSUMO',1,'2009-08-19 00:32:08'),(181,2557,'TRANSFERENCIA MATERIAL P/ USO OU CONSUMO',1,'2009-08-19 00:32:08'),(182,2603,'RESSARCIMENTO ICMS RETIDO POR SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:08'),(183,2651,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA INDUSTRIALIZAAO',1,'2009-08-19 00:32:08'),(184,2652,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA COMERCIALIZAAO',1,'2009-08-19 00:32:08'),(185,2653,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE POR CONSUMIDOR USUARIO FINAL',1,'2009-08-19 00:32:08'),(186,2658,'TRANSFERENCIA DE COMBUSTIVEL PARA INDUSTRIALIZAAO',1,'2009-08-19 00:32:08'),(187,2659,'TRANSFERENCIA DE COMBUSTIVEL PARA COMERCIALIZAAO',1,'2009-08-19 00:32:08'),(188,2660,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A INDUS',1,'2009-08-19 00:32:08'),(189,2661,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A COMER',1,'2009-08-19 00:32:08'),(190,2662,'DEVOLUAO DE VENDA DE COMBUSTIVEL OU LUBRIFICANTE DESTINADO A CONSU',1,'2009-08-19 00:32:08'),(191,2663,'ENTRADA DE COMBUSTIVEL OU LUBRIFICANTE PARA ARMAZENAGEM',1,'2009-08-19 00:32:09'),(192,2664,'RETORNO DE COMBUSTIVEL OU LUBRIFICANTE REMETIDO PARA ARMAZENAGEM',1,'2009-08-19 00:32:09'),(193,2901,'ENTRADA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:09'),(194,2902,'RETORNO MERCADORIA REMETIDA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:09'),(195,2903,'ENTRADA MERC. REMETIDA P/ INDUST., NAO APLICADA NO PROCESSO',1,'2009-08-19 00:32:09'),(196,2904,'RETORNO REMESSA P/ VENDA FORA ESTABELECIMENTO',1,'2009-08-19 00:32:09'),(197,2905,'ENTRADA MERC. RECEBIDA P/ DEPOSITO, DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:09'),(198,2906,'RETORNO MERCADORIA REMETIDA P/ DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:09'),(199,2907,'RETORNO SIMBOLICO MERC. REMETIDA P/ DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:09'),(200,2908,'ENTRADA BEM POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:09'),(201,2909,'RETORNO BEM REMETIDO POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:09'),(202,2910,'ENTRADA BONIFICACAO, DOACAO OU BRINDE',1,'2009-08-19 00:32:09'),(203,2911,'ENTRADA AMOSTRA GRATIS',1,'2009-08-19 00:32:09'),(204,2912,'ENTRADA MERCADORIA OU BEM RECEBIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:09'),(205,2913,'RETORNO MERCADORIA OU BEM REMETIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:09'),(206,2914,'RETORNO MERCADORIA OU BEM REMETIDO P/ EXPOSICAO OU FEIRA',1,'2009-08-19 00:32:09'),(207,2915,'ENTRADA MERCADORIA OU BEM RECEBIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:09'),(208,2916,'RETORNO MERCADORIA OU BEM REMETIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:09'),(209,2917,'ENTRADA MERCADORIA RECEBIDA EM CONSIG. MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:09'),(210,2918,'DEVOLUCAO MERCADORIA REMETIDA EM CONSIG. MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:09'),(211,2919,'DEVOLUCAO SIMB. MERC. VENDIDA-UTILIZ. PROC. INDUST, ANTES CONSIG.',1,'2009-08-19 00:32:09'),(212,2920,'ENTRADA VASILHAME OU SACARIA',1,'2009-08-19 00:32:09'),(213,2921,'RETORNO VASILHAME OU SACARIA',1,'2009-08-19 00:32:09'),(214,2922,'LANCAMENTO SIMPLES FATURAMENTO, COMPRA P/ RECEBIMENTO FUTURO',1,'2009-08-19 00:32:09'),(215,2923,'ENTRADA MERCADORIA RECEBIDA DO VENDEDOR REMETENTE, VENDA A ORDEM',1,'2009-08-19 00:32:09'),(216,2924,'ENTRADA P/ INDUST, CONTA-ORDEM ADQUIRENTE, NAO TRANSITA ESTAB. ADQ.',1,'2009-08-19 00:32:09'),(217,2925,'RETORNO MERC. REMETIDA INDUST., CONTA-ORDEM ADQ., NAO TRANSITA ADQ.',1,'2009-08-19 00:32:10'),(218,2931,'LANCAMENTO EFETUADO PELO TOMADOR DO SERVIO DE TRANSPORTE QUANDO A RES',1,'2009-08-19 00:32:10'),(219,2932,'AQUISIO DE SERVIO DE TRANSPORTE INICIADO EM UNIDADE DA FEDERAO DI',1,'2009-08-19 00:32:10'),(220,2933,'AQUISIO DE SERVIO TRIBUTADO PELO ISSQN',1,'2009-08-19 00:32:10'),(221,2949,'OUTRA ENTRADA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADA',1,'2009-08-19 00:32:10'),(222,3101,'COMPRA P/ INDUSTRIALIZACAO',1,'2009-08-19 00:32:10'),(223,3102,'COMPRA P/ COMERIALIZACAO',1,'2009-08-19 00:32:10'),(224,3126,'COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:10'),(225,3127,'COMPRA P/ INDUSTRIALIZACAO, REGIME DRAWBACK',1,'2009-08-19 00:32:10'),(226,3201,'DEVOLUCAO VENDA DE PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:10'),(227,3202,'DEVOLUCAO VENDA DE MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:10'),(228,3205,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:10'),(229,3206,'ANULACAO VALOR RELATIVO A PRESTACAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:10'),(230,3207,'ANULACAO VALOR RELATIVO A VENDA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:10'),(231,3211,'DEVOLUCAO VENDA PRODUCAO DO ESTAB., REGIME DRAWBACK',1,'2009-08-19 00:32:10'),(232,3251,'COMPRA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:10'),(233,3301,'AQUISICAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:10'),(234,3351,'AQUISICAO SERVICO TRANSPORTE P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:10'),(235,3352,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:10'),(236,3353,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:10'),(237,3354,'AQUISICAO SERVICO TRANSPORTE, ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:10'),(238,3355,'AQUISICAO SERVICO TRANSPORTE, ESTAB. GERADOR-DISTRIB ENERGIA ELET',1,'2009-08-19 00:32:10'),(239,3356,'AQUISICAO SERVICO TRANSPORTE, ESTABELECIMENTO PRODUTOR RURAL',1,'2009-08-19 00:32:10'),(240,3503,'ENTRADA DEVOLUCAO PRODUTO REMETIDO P/ EXPORTACAO, PRODUCAO ESTAB.',1,'2009-08-19 00:32:10'),(241,3551,'COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:10'),(242,3553,'DEVOLUCAO VENDA DE BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:10'),(243,3556,'COMPRA MATERIAL P/ USO OU CONSUMO',1,'2009-08-19 00:32:10'),(244,3651,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA INDUSTRIALIZAAO SUBSE',1,'2009-08-19 00:32:10'),(245,3652,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE PARA COMERCIALIZAAO',1,'2009-08-19 00:32:10'),(246,3653,'COMPRA DE COMBUSTIVEL OU LUBRIFICANTE POR COMSUMIDOR OU USUARIO FI',1,'2009-08-19 00:32:10'),(247,3930,'LANCAMENTO ENTRADA BEM, REGIME ESPECIAL ADUANEIRO, ADMISSAO TEMPORARIA',1,'2009-08-19 00:32:10'),(248,3949,'OUTRA ENTRADA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADA',1,'2009-08-19 00:32:10'),(249,5101,'VENDA PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:10'),(250,5102,'VENDA MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:10'),(251,5103,'VENDA PRODUCAO DO ESTABELECIMENTO, EFETUADA FORA DO ESTABELECIMENTO',1,'2009-08-19 00:32:11'),(252,5104,'VENDA MERCADORIA ADQUIRIDA-RECEBIDA TERCEIROS, FORA DO ESTAB.',1,'2009-08-19 00:32:11'),(253,5105,'VENDA PRODUCAO DO ESTABELECIMENTO QUE NAO DEVA POR ELE TRANSITAR',1,'2009-08-19 00:32:11'),(254,5106,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIROS, QUE NAO DEVA TRANSITAR',1,'2009-08-19 00:32:11'),(255,5109,'VENDA PRODUCAO DO ESTAB., DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:11'),(256,5110,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIRO, DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:11'),(257,5111,'VENDA PRODUCAO DO ESTAB. REMETIDA ANTES EM CONSIG. INDUSTRIAL',1,'2009-08-19 00:32:11'),(258,5112,'VENDA MERC. ADQUIRIDA-REC. TERC, REMETIDA ANTES EM CONSIG. INDUST.',1,'2009-08-19 00:32:11'),(259,5113,'VENDA PRODUCAO DO ESTAB. REMETIDA ANTES EM CONSIGNACAO MERCANTIL',1,'2009-08-19 00:32:11'),(260,5114,'VENDA MERC. ADQUIRIDA-REC 3, REMETIDA ANTES EM CONSIG. MERCANTIL',1,'2009-08-19 00:32:11'),(261,5115,'VENDA MERC. ADQUIRIDA-REC 3, RECEBIDA ANTES EM CONSIG. MERCANTIL',1,'2009-08-19 00:32:11'),(262,5116,'VENDA PRODUCAO DO ESTAB. ORIGEM DE ENCOMENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:11'),(263,5117,'VENDA MERC. ADQUIRIDA-REC 3, ORIGEM ENCOMENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:11'),(264,5118,'VENDA PRODUCAO, ENTREGA DEST CONTA-ORDEM ADQUIR ORIG, VENDA A ORDEM',1,'2009-08-19 00:32:11'),(265,5119,'VENDA MERC ADQUIRIDA-REC 3, ENTREGA DEST, CONTA-ORDEM ORIG, A ORDEM',1,'2009-08-19 00:32:11'),(266,5120,'VENDA MERC. ADQUIRIDA-REC 3, ENTREGA DEST, VENDEDOR REMETE, A ORDEM',1,'2009-08-19 00:32:11'),(267,5122,'VENDA PRODUCAO, REMETIDA INDUST, CONTA-ORDEM ADQUIRE, SEM TRANSITAR',1,'2009-08-19 00:32:11'),(268,5123,'VENDA MERC. ADQUIR-REC. 3, REMETIDA INDUST, CONTA-ORDEM,SEM TRANSIT',1,'2009-08-19 00:32:11'),(269,5124,'INDUSTRIALIZACAO P/ OUTRA EMPRESA',1,'2009-08-19 00:32:11'),(270,5125,'INDUST. P/ OUTRA EMPRESA, MERC. RECEBIDA P/ INDUST., NAO TRANSITA',1,'2009-08-19 00:32:11'),(271,5151,'TRANSFERENCIA PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:11'),(272,5152,'TRANSFERENCIA MERCADORIA ADQUIRIDA-RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:11'),(273,5153,'TRANSFERENCIA ENERGIA ELETRICA',1,'2009-08-19 00:32:11'),(274,5155,'TRANSFERENCIA PRODUCAO DO ESTAB, QUE NAO DEVA POR ELE TRANSITAR',1,'2009-08-19 00:32:11'),(275,5156,'TRANSFERENCIA MERC. ADQUIRIDA-REC. 3, QUE NAO DEVA TRANSITAR',1,'2009-08-19 00:32:11'),(276,5201,'DEVOLUCAO COMPRA P/ INDUSTRIALIZACAO OU PRODUCAO RURAL',1,'2009-08-19 00:32:11'),(277,5202,'DEVOLUCAO COMPRA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:11'),(278,5205,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:11'),(279,5206,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:11'),(280,5207,'ANULACAO VALOR RELATIVO A COMPRA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:11'),(281,5208,'DEVOLUCAO MERC. RECEBIDA EM TRANSFERENCIA P/ INDUSTR OU PRODUCAO RURAL',1,'2009-08-19 00:32:11'),(282,5209,'DEVOLUCAO MERC. RECEBIDA EM TRANSFERENCIA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:11'),(283,5210,'DEVOLUCAO COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:11'),(284,5251,'VENDA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:11'),(285,5252,'VENDA ENERGIA ELETRICA P/ ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:12'),(286,5253,'VENDA ENERGIA ELETRICA P/ ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:12'),(287,5254,'VENDA ENERGIA ELETRICA P/ ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:12'),(288,5255,'VENDA ENERGIA ELETRICA P/ ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:12'),(289,5256,'VENDA ENERGIA ELETRICA P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:12'),(290,5257,'VENDA ENERGIA ELETRICA P/ CONSUMO POR DEMANDA CONTRATADA',1,'2009-08-19 00:32:12'),(291,5258,'VENDA ENERGIA ELETRICA A NAO-CONTRIBUINTE',1,'2009-08-19 00:32:12'),(292,5301,'PRESTACAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:12'),(293,5302,'PRESTACAO SERVICO COMUNICACAO P/ ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:12'),(294,5303,'PRESTACAO SERVICO COMUNICACAO P/ ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:12'),(295,5304,'PRESTACAO SERV. COMUNICACAO P/ ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:12'),(296,5305,'PRESTACAO SERV. COMUNICACAO P/ ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:12'),(297,5306,'PRESTACAO SERVICO COMUNICACAO P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:12'),(298,5307,'PRESTACAO SERVICO COMUNICACAO P/ NAO-CONTRIBUINTE',1,'2009-08-19 00:32:12'),(299,5351,'PRESTACAO SERVICO TRANSPORTE P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:12'),(300,5352,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. INDUSTRIAL',1,'2009-08-19 00:32:12'),(301,5353,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. COMERCIAL',1,'2009-08-19 00:32:12'),(302,5354,'PRESTACAO SERV. TRANSPORTE P/ ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:12'),(303,5355,'PRESTACAO SERV. TRANSPORTE P/ ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:12'),(304,5356,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:12'),(305,5357,'PRESTACAO DE SERVICO DE TRANSPORTE A NAO-CONTRIBUINTE',1,'2009-08-19 00:32:12'),(306,5359,'PRESTAO DE SERVIO DE TRANSPORTE A CONTRIBUINTE OU A NO CONTRIBUINT',1,'2009-08-19 00:32:12'),(307,5401,'VENDA PRODUCAO, PRODUTO REGIME SUBST. TRIB, CONTRIBUINTE SUBSTITUTO',1,'2009-08-19 00:32:12'),(308,5402,'VENDA PRODUCAO, PRODUTO SUBST. TRIB, SUBSTITUTOS MESMO PRODUTO',1,'2009-08-19 00:32:12'),(309,5403,'VENDA MERC. ADQUIRIDA-REC 3, MERC. SUBST. TRIB, CONTRIB SUBSTITUTO',1,'2009-08-19 00:32:12'),(310,5405,'VENDA MERC. ADQUIRIDA-REC 3, MERC. SUBST. TRIB, CONTRIB SUBSTITUIDO',1,'2009-08-19 00:32:12'),(311,5408,'TRANSFERENCIA PRODUCAO, PRODUTO REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:12'),(312,5409,'TRANSFERENCIA MERC. ADQUIRIDA-REC 3, MERC. REGIME SUBST. TRIBUTARIA',1,'2009-08-19 00:32:12'),(313,5410,'DEVOLUCAO COMPRA P/ INDUST. OU PROD RURAL, MERC. REG.SUBST.TRIBUTARIA',1,'2009-08-19 00:32:12'),(314,5411,'DEVOLUCAO COMPRA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:12'),(315,5412,'DEVOLUCAO BEM ATIVO IMOBILIZADO, MERC. SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:12'),(316,5413,'DEVOLUCAO MERC. DESTINADA USO-CONSUMO, MERC. REGIME SUBST. TRIB.',1,'2009-08-19 00:32:12'),(317,5414,'REMESSA PRODUCAO P/ VENDA FORA ESTAB., PRODUTO REGIME SUBST. TRIB.',1,'2009-08-19 00:32:13'),(318,5415,'REMESSA MERC. ADQUIRIDA-REC 3, VENDA FORA ESTAB, SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:13'),(319,5451,'REMESSA DE ANIMAL E DE INSUMO P/ ESTABELECIMENTO PRODUTOR',1,'2009-08-19 00:32:13'),(320,5501,'REMESSA PRODUCAO, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:13'),(321,5502,'REMESSA MERC. ADQUIRIDA-REC 3, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:13'),(322,5503,'DEVOLUCAO MERCADORIA RECEBIDA, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:13'),(323,5504,'REMESSA MERC P FORMAAO LOTE EXPORT PROD INDUST OU PROD P PROPRIO ESTAB',1,'2009-08-19 00:32:13'),(324,5505,'REMESSA MERCADORIAS ADQ OU RECEB DE TERCEIROS PARA FORMACAO LOTE EXPOR',1,'2009-08-19 00:32:13'),(325,5551,'VENDA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:13'),(326,5552,'TRANSFERENCIA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:13'),(327,5553,'DEVOLUCAO COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:13'),(328,5554,'REMESSA BEM DO ATIVO IMOBILIZADO P/ USO FORA ESTABELECIMENTO',1,'2009-08-19 00:32:13'),(329,5555,'DEVOLUCAO BEM ATIVO IMOBILIZADO DE TERCEIRO, RECEBIDO P/ USO ESTAB.',1,'2009-08-19 00:32:13'),(330,5556,'DEVOLUCAO COMPRA DE MATERIAL DE USO OU CONSUMO',1,'2009-08-19 00:32:13'),(331,5557,'TRANSFERENCIA MATERIAL DE USO OU CONSUMO',1,'2009-08-19 00:32:13'),(332,5601,'TRANSFERENCIA CREDITO DE ICMS ACUMULADO',1,'2009-08-19 00:32:13'),(333,5602,'TRANSFERENCIA SALDO CREDOR, OUTRO ESTAB MESMA EMPRESA, P/ COMPENSACAO',1,'2009-08-19 00:32:13'),(334,5603,'RESSARCIMENTO ICMS RETIDO POR SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:13'),(335,5605,'TRANSFERENCIA DE SALDO DEVEDOR DE ICMS DE OUTRO ESTABELECIMENTO DA MES',1,'2009-08-19 00:32:13'),(336,5606,'UTILIZAO DE SALDO CREDOR DE ICMS PARA EXTINO POR COMPENSAO DE D',1,'2009-08-19 00:32:13'),(337,5651,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELICIMENTO',1,'2009-08-19 00:32:13'),(338,5652,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:13'),(339,5653,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELICIMENTO',1,'2009-08-19 00:32:13'),(340,5654,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCEIRO',1,'2009-08-19 00:32:13'),(341,5655,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCEIRO',1,'2009-08-19 00:32:13'),(342,5656,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCEIRO',1,'2009-08-19 00:32:13'),(343,5657,'REMESSA DE COMBUSTIVEL OPU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCE',1,'2009-08-19 00:32:13'),(344,5658,'TRANSFERENCIA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECI',1,'2009-08-19 00:32:13'),(345,5659,'TRANSFERENCIA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO',1,'2009-08-19 00:32:13'),(346,5660,'DEVOLUAO DE COMPRA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO PARA INDU',1,'2009-08-19 00:32:13'),(347,5661,'DEVOLUAO DE COMPRA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO PARA COME',1,'2009-08-19 00:32:13'),(348,5662,'DEVOLUAO DE COMPRA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO POR CONSU',1,'2009-08-19 00:32:13'),(349,5663,'REMESSA DE ARMAZENAGEM DE COMBUSTIVEL OU LUBRIFICANTE',1,'2009-08-19 00:32:14'),(350,5664,'RETORNO DE COMBUSTIVEL OU LUBRIFICANTE RECEBIDO PARA ARMAZENAGEM',1,'2009-08-19 00:32:14'),(351,5665,'RETORNO SIMBOLICO DE COMBUSTIVEL OU LUBRIFICANTE RECEBIDO PARA ARMAZEN',1,'2009-08-19 00:32:14'),(352,5666,'REMESSA POR CONTA E ORDEM DE TERCEIROS DE COMBUSTIVEL OU LUBRIFICANTE',1,'2009-08-19 00:32:14'),(353,5901,'REMESSA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:14'),(354,5902,'RETORNO MERCADORIA UTILIZADA NA INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:14'),(355,5903,'RETORNO MERCADORIA RECEBIDA P/ INDUST., NAO APLICADA NO PROCESSO',1,'2009-08-19 00:32:14'),(356,5904,'REMESSA P/ VENDA FORA DO ESTABELECIMENTO',1,'2009-08-19 00:32:14'),(357,5905,'REMESSA P/ DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:14'),(358,5906,'RETORNO MERCADORIA DEPOSITADA EM DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:14'),(359,5907,'RETORNO SIMBOLICO MERC. DEPOSITADA DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:14'),(360,5908,'REMESSA DE BEM POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:14'),(361,5909,'RETORNO DE BEM RECEBIDO POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:14'),(362,5910,'REMESSA EM BONIFICACAO, DOACAO OU BRINDE',1,'2009-08-19 00:32:14'),(363,5911,'REMESSA AMOSTRA GRATIS',1,'2009-08-19 00:32:14'),(364,5912,'REMESSA MERCADORIA OU BEM P/ DEMONSTRACAO',1,'2009-08-19 00:32:14'),(365,5913,'RETORNO MERCADORIA OU BEM RECEBIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:14'),(366,5914,'REMESSA MERCADORIA OU BEM P/ EXPOSICAO OU FEIRA',1,'2009-08-19 00:32:14'),(367,5915,'REMESSA MERCADORIA OU BEM P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:14'),(368,5916,'RETORNO MERCADORIA OU BEM RECEBIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:14'),(369,5917,'REMESSA MERCADORIA EM CONSIGNACAO MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:14'),(370,5918,'DEVOLUCAO MERCADORIA RECEBIDA EM CONSIGNACAO MERCANTIL-INDUSTRIAL',1,'2009-08-19 00:32:14'),(371,5919,'DEVOLUCAO SIMBOLICA MERC. VENDIDA-UTIL. PROC INDUST, ANTES CONSIG.',1,'2009-08-19 00:32:14'),(372,5920,'REMESSA VASILHAME OU SACARIA',1,'2009-08-19 00:32:14'),(373,5921,'DEVOLUCAO VASILHAME OU SACARIA',1,'2009-08-19 00:32:14'),(374,5922,'LANCAMENTO SIMPLES FATURAMENTO DE VENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:14'),(375,5923,'REMESSA MERCADORIA POR CONTA-ORDEM DE TERCEIROS, VENDA A ORDEM',1,'2009-08-19 00:32:14'),(376,5924,'REMESSA P/ INDUST., CONTA-ORDEM ADQUIRENTE, NAO TRANSITA ADQUIRENTE',1,'2009-08-19 00:32:14'),(377,5925,'RETORNO MERC. REC. P/ INDUST, CONTA-ORDEM ADQUIRENTE, NAO TRANSITA',1,'2009-08-19 00:32:14'),(378,5926,'LANCAMENTO RECLASSIF. MERC. FORMACAO KIT OU DE SUA DESAGREGACAO',1,'2009-08-19 00:32:14'),(379,5927,'LANCAMENTO BAIXA ESTOQUE, PERDA, ROUBO OU DETERIORACAO',1,'2009-08-19 00:32:14'),(380,5928,'LANCAMENTO BAIXA ESTOQUE, ENCERRAMENTO ATIVIDADE DA EMPRESA',1,'2009-08-19 00:32:14'),(381,5929,'LANCAMENTO EMISSAO DOCUMENTO FISCAL, TAMBEM ECF',1,'2009-08-19 00:32:14'),(382,5931,'LANCAMENTO RESPONSABILIDADE RETENCAO IMPOSTO ST, SERVICO TRANSPORTE',1,'2009-08-19 00:32:15'),(383,5932,'PRESTACAO SERVICO TRANSPORTE INICIO OUTRA UF',1,'2009-08-19 00:32:15'),(384,5933,'PRESTAO DE SERVIO TRIBUTADO PELO ISSQN',1,'2009-08-19 00:32:15'),(385,5949,'OUTRA SAIDA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADO',1,'2009-08-19 00:32:15'),(386,6101,'VENDA PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:15'),(387,6102,'VENDA MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:15'),(388,6103,'VENDA PRODUCAO DO ESTABELECIMENTO, EFETUADA FORA DO ESTABELECIMENTO',1,'2009-08-19 00:32:15'),(389,6104,'VENDA MERCADORIA ADQUIRIDA-RECEBIDA TERCEIROS, FORA DO ESTAB.',1,'2009-08-19 00:32:15'),(390,6105,'VENDA PRODUCAO DO ESTABELECIMENTO QUE NAO DEVA POR ELE TRANSITAR',1,'2009-08-19 00:32:15'),(391,6106,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIROS, QUE NAO DEVA TRANSITAR',1,'2009-08-19 00:32:15'),(392,6107,'VENDA PRODUCAO P/ NAO CONTRIBUINTE',1,'2009-08-19 00:32:15'),(393,6108,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIROS, P/ NAO CONTRIBUINTE',1,'2009-08-19 00:32:15'),(394,6109,'VENDA PRODUCAO DO ESTAB., DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:15'),(395,6110,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIRO, DESTINO ZONA FRANCA OU ALC',1,'2009-08-19 00:32:15'),(396,6111,'VENDA PRODUCAO DO ESTAB. REMETIDA ANTES EM CONSIG. INDUSTRIAL',1,'2009-08-19 00:32:15'),(397,6112,'VENDA MERC. ADQUIRIDA-REC. TERC, REMETIDA ANTES EM CONSIG. INDUST.',1,'2009-08-19 00:32:15'),(398,6113,'VENDA PRODUCAO DO ESTAB. REMETIDA ANTES EM CONSIGNACAO MERCANTIL',1,'2009-08-19 00:32:15'),(399,6114,'VENDA MERC. ADQUIRIDA-REC 3, REMETIDA ANTES EM CONSIG. MERCANTIL',1,'2009-08-19 00:32:15'),(400,6115,'VENDA MERC. ADQUIRIDA-REC 3, RECEBIDA ANTES EM CONSIG. MERCANTIL',1,'2009-08-19 00:32:15'),(401,6116,'VENDA PRODUCAO DO ESTAB. ORIGEM DE ENCOMENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:15'),(402,6117,'VENDA MERC. ADQUIRIDA-REC 3, ORIGEM ENCOMENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:15'),(403,6118,'VENDA PRODUCAO, ENTREGA DEST CONTA-ORDEM ADQUIR ORIG, VENDA A ORDEM',1,'2009-08-19 00:32:15'),(404,6119,'VENDA MERC ADQUIRIDA-REC 3, ENTREGA DEST, CONTA-ORDEM ORIG, A ORDEM',1,'2009-08-19 00:32:15'),(405,6120,'VENDA MERC. ADQUIRIDA-REC 3, ENTREGA DEST, VENDEDOR REMETE, A ORDEM',1,'2009-08-19 00:32:15'),(406,6122,'VENDA PRODUCAO, REMETIDA INDUST, CONTA-ORDEM ADQUIRE, SEM TRANSITAR',1,'2009-08-19 00:32:15'),(407,6123,'VENDA MERC. ADQUIR-REC. 3, REMETIDA INDUST, CONTA-ORDEM,SEM TRANSIT',1,'2009-08-19 00:32:15'),(408,6124,'INDUSTRIALIZACAO P/ OUTRA EMPRESA',1,'2009-08-19 00:32:15'),(409,6125,'INDUST. P/ OUTRA EMPRESA, MERC. RECEBIDA P/ INDUST., NAO TRANSITA',1,'2009-08-19 00:32:15'),(410,6151,'TRANSFERENCIA PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:15'),(411,6152,'TRANSFERENCIA MERCADORIA ADQUIRIDA-RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:15'),(412,6153,'TRANSFERENCIA ENERGIA ELETRICA',1,'2009-08-19 00:32:15'),(413,6155,'TRANSFERENCIA PRODUCAO DO ESTAB, QUE NAO DEVA POR ELE TRANSITAR',1,'2009-08-19 00:32:15'),(414,6156,'TRANSFERENCIA MERC. ADQUIRIDA-REC. 3, QUE NAO DEVA TRANSITAR',1,'2009-08-19 00:32:15'),(415,6201,'DEVOLUCAO COMPRA P/ INDUSTRIALIZACAO OU PRODUCAO RURAL',1,'2009-08-19 00:32:15'),(416,6202,'DEVOLUCAO COMPRA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:16'),(417,6205,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:16'),(418,6206,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:16'),(419,6207,'ANULACAO VALOR RELATIVO A COMPRA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:16'),(420,6208,'DEVOLUCAO MERC. RECEBIDA EM TRANSFER P/ INDUSTR.OU PROD RURAL',1,'2009-08-19 00:32:16'),(421,6209,'DEVOLUCAO MERC. RECEBIDA EM TRANSFERENCIA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:16'),(422,6210,'DEVOLUCAO COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:16'),(423,6251,'VENDA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:16'),(424,6252,'VENDA ENERGIA ELETRICA P/ ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:16'),(425,6253,'VENDA ENERGIA ELETRICA P/ ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:16'),(426,6254,'VENDA ENERGIA ELETRICA P/ ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:16'),(427,6255,'VENDA ENERGIA ELETRICA P/ ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:16'),(428,6256,'VENDA ENERGIA ELETRICA P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:16'),(429,6257,'VENDA ENERGIA ELETRICA P/ CONSUMO POR DEMANDA CONTRATADA',1,'2009-08-19 00:32:16'),(430,6258,'VENDA ENERGIA ELETRICA A NAO-CONTRIBUINTE',1,'2009-08-19 00:32:16'),(431,6301,'PRESTACAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:16'),(432,6302,'PRESTACAO SERVICO COMUNICACAO P/ ESTABELECIMENTO INDUSTRIAL',1,'2009-08-19 00:32:16'),(433,6303,'PRESTACAO SERVICO COMUNICACAO P/ ESTABELECIMENTO COMERCIAL',1,'2009-08-19 00:32:16'),(434,6304,'PRESTACAO SERV. COMUNICACAO P/ ESTAB. PRESTADOR SERVICO TRANSPORTE',1,'2009-08-19 00:32:16'),(435,6305,'PRESTACAO SERV. COMUNICACAO P/ ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:16'),(436,6306,'PRESTACAO SERVICO COMUNICACAO P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:16'),(437,6307,'PRESTACAO SERVICO COMUNICACAO P/ NAO-CONTRIBUINTE',1,'2009-08-19 00:32:16'),(438,6351,'PRESTACAO SERVICO TRANSPORTE P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:16'),(439,6352,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. INDUSTRIAL',1,'2009-08-19 00:32:16'),(440,6353,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. COMERCIAL',1,'2009-08-19 00:32:16'),(441,6354,'PRESTACAO SERV. TRANSPORTE P/ ESTAB. PRESTADOR SERVICO COMUNICACAO',1,'2009-08-19 00:32:16'),(442,6355,'PRESTACAO SERV. TRANSPORTE P/ ESTAB. GERADOR-DISTRIB. ENERGIA ELET',1,'2009-08-19 00:32:16'),(443,6356,'PRESTACAO SERVICO TRANSPORTE P/ ESTAB. PRODUTOR RURAL',1,'2009-08-19 00:32:16'),(444,6357,'PRESTACAO DE SERVICO DE TRANSPORTE A NAO-CONTRIBUINTE',1,'2009-08-19 00:32:16'),(445,6359,'PESTAO DE SERVIO DE TRANSPORTE A CONTRIBUINTE OU A NO CONTRIBUINT',1,'2009-08-19 00:32:16'),(446,6401,'VENDA PRODUCAO, PRODUTO REGIME SUBST. TRIB, CONTRIBUINTE SUBSTITUTO',1,'2009-08-19 00:32:16'),(447,6402,'VENDA PRODUCAO, PRODUTO SUBST. TRIB, SUBSTITUTOS MESMO PRODUTO',1,'2009-08-19 00:32:16'),(448,6403,'VENDA MERC. ADQUIRIDA-REC 3, MERC. SUBST. TRIB, CONTRIB SUBSTITUTO',1,'2009-08-19 00:32:16'),(449,6404,'VENDA MERC. REGIME SUBST. TRIB, IMPOSTO JA RETIDO',1,'2009-08-19 00:32:16'),(450,6408,'TRANSFERENCIA PRODUCAO, PRODUTO REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:16'),(451,6409,'TRANSFEENCIA MERC. ADQUIRIDA-REC 3, MERC. REGIME SUBST. TRIBUTARIA',1,'2009-08-19 00:32:17'),(452,6410,'DEVOLUCAO COMPRA P/ INDUST.OU PROD RURAL MERC. REG.SUBSTIT.TRIBUT.',1,'2009-08-19 00:32:17'),(453,6411,'DEVOLUCAO COMPRA P/ COMERC., MERC. REGIME SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:17'),(454,6412,'DEVOLUCAO BEM ATIVO IMOBILIZADO, MERC. SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:17'),(455,6413,'DEVOLUCAO MERC. DESTINADA USO-CONSUMO, MERC. REGIME SUBST. TRIB.',1,'2009-08-19 00:32:17'),(456,6414,'REMESSA PRODUCAO P/ VENDA FORA ESTAB., PRODUTO REGIME SUBST. TRIB.',1,'2009-08-19 00:32:17'),(457,6415,'REMESSA MERC. ADQUIRIDA-REC 3, VENDA FORA ESTAB, SUBSTITUICAO TRIB.',1,'2009-08-19 00:32:17'),(458,6501,'REMESSA PRODUCAO, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:17'),(459,6502,'REMESSA MERC. ADQUIRIDA-REC 3, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:17'),(460,6503,'DEVOLUCAO MERCADORIA RECEBIDA, FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:17'),(461,6504,'REMESSA MERC P FORMACAO LOTE EXPORT PROD INDUSTR OU PROD P PROPRIO EST',1,'2009-08-19 00:32:17'),(462,6505,'REMESSA MERCADORIAS ADQ OU RECEB TERCEIROS PARA FORMACAO LOTE EXPORTAC',1,'2009-08-19 00:32:17'),(463,6551,'VENDA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:17'),(464,6552,'TRANSFERENCIA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:17'),(465,6553,'DEVOLUCAO COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:17'),(466,6554,'REMESSA BEM DO ATIVO IMOBILIZADO P/ USO FORA ESTABELECIMENTO',1,'2009-08-19 00:32:17'),(467,6555,'DEVOLUCAO BEM ATIVO IMOBILIZADO DE TERCEIRO, RECEBIDO P/ USO ESTAB.',1,'2009-08-19 00:32:17'),(468,6556,'DEVOLUCAO COMPRA DE MATERIAL DE USO OU CONSUMO',1,'2009-08-19 00:32:17'),(469,6557,'TRANSFERENCIA MATERIAL DE USO OU CONSUMO',1,'2009-08-19 00:32:17'),(470,6603,'RESSARCIMENTO ICMS RETIDO POR SUBSTITUICAO TRIBUTARIA',1,'2009-08-19 00:32:17'),(471,6651,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:17'),(472,6652,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:17'),(473,6653,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:17'),(474,6654,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCE',1,'2009-08-19 00:32:17'),(475,6655,'VENDA DE COMBUSTIVEL OU KUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCE',1,'2009-08-19 00:32:17'),(476,6656,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERCE',1,'2009-08-19 00:32:17'),(477,6657,'REMESSA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TER',1,'2009-08-19 00:32:17'),(478,6658,'TRANSFERENCIA DE COMBUSTIVEL OU LUBRIFICANTE PRODUAO DO ESTABELECI',1,'2009-08-19 00:32:17'),(479,6659,'TRANSFERENCIA DE COMBUSTIVEL OU LUBRIFICANTE  ADQUIRIDO OU RECEBIDO',1,'2009-08-19 00:32:17'),(480,6660,'DEVOLUAO DE COMPRA  DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO PARA',1,'2009-08-19 00:32:17'),(481,6661,'DEVOLUAO DE COMPRA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO PARA C',1,'2009-08-19 00:32:17'),(482,6662,'DEVOLUAO DE COMPRA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO POR CO',1,'2009-08-19 00:32:18'),(483,6663,'REMESSA PARA ARMAZENAGEM DE COMBUSTIVEL OU LUBRIFICANTE',1,'2009-08-19 00:32:18'),(484,6664,'RETORNO DE COMBUSTIVEL OU LUBRIFICANTE RECEBIDO PARA ARMAZENAGEM',1,'2009-08-19 00:32:18'),(485,6665,'RETORNO SIMBOLICO DE COMBUSTIVEL OU LUBRIFICANTE RECEBIDO PARA ARMA',1,'2009-08-19 00:32:18'),(486,6666,'REMESSA POR CONTA E ORDEM DE TERCEIRO DE COMBUSTIVEL OU LUBRIFICANT',1,'2009-08-19 00:32:18'),(487,6901,'REMESSA P/ INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:18'),(488,6902,'RETORNO MERCADORIA UTILIZADA NA INDUSTRIALIZACAO POR ENCOMENDA',1,'2009-08-19 00:32:18'),(489,6903,'RETORNO MERCADORIA RECEBIDA P/ INDUST., NAO APLICADA NO PROCESSO',1,'2009-08-19 00:32:18'),(490,6904,'REMESSA P/ VENDA FORA DO ESTABELECIMENTO',1,'2009-08-19 00:32:18'),(491,6905,'REMESSA P/ DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:18'),(492,6906,'RETORNO MERCADORIA DEPOSITADA EM DEPOSITO FECHADO OU ARMAZEM GERAL',1,'2009-08-19 00:32:18'),(493,6907,'RETORNO SIMBOLICO MERC. DEPOSITADA DEPOSITO FECHADO-ARMAZEM GERAL',1,'2009-08-19 00:32:18'),(494,6908,'REMESSA DE BEM POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:18'),(495,6909,'RETORNO DE BEM RECEBIDO POR CONTA DE CONTRATO DE COMODATO',1,'2009-08-19 00:32:18'),(496,6910,'REMESSA EM BONIFICACAO, DOACAO OU BRINDE',1,'2009-08-19 00:32:18'),(497,6911,'REMESSA AMOSTRA GRATIS',1,'2009-08-19 00:32:18'),(498,6912,'REMESSA MERCADORIA OU BEM P/ DEMONSTRACAO',1,'2009-08-19 00:32:18'),(499,6913,'RETORNO MERCADORIA OU BEM RECEBIDO P/ DEMONSTRACAO',1,'2009-08-19 00:32:18'),(500,6914,'REMESSA MERCADORIA OU BEM P/ EXPOSICAO OU FEIRA',1,'2009-08-19 00:32:18'),(501,6915,'REMESSA MERCADORIA OU BEM P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:18'),(502,6916,'RETORNO MERCADORIA OU BEM RECEBIDO P/ CONSERTO OU REPARO',1,'2009-08-19 00:32:18'),(503,6917,'REMESSA MERCADORIA EM CONSIGNACAO MERCANTIL OU INDUSTRIAL',1,'2009-08-19 00:32:18'),(504,6918,'DEVOLUCAO MERCADORIA RECEBIDA EM CONSIGNACAO MERCANTIL-INDUSTRIAL',1,'2009-08-19 00:32:18'),(505,6919,'DEVOLUCAO SIMBOLICA MERC. VENDIDA-UTIL. PROC INDUST, ANTES CONSIG.',1,'2009-08-19 00:32:18'),(506,6920,'REMESSA VASILHAME OU SACARIA',1,'2009-08-19 00:32:18'),(507,6921,'DEVOLUCAO VASILHAME OU SACARIA',1,'2009-08-19 00:32:18'),(508,6922,'LANCAMENTO SIMPLES FATURAMENTO DE VENDA P/ ENTREGA FUTURA',1,'2009-08-19 00:32:18'),(509,6923,'REMESSA MERCADORIA POR CONTA-ORDEM DE TERCEIROS, VENDA A ORDEM',1,'2009-08-19 00:32:18'),(510,6924,'REMESSA P/ INDUST., CONTA-ORDEM ADQUIRENTE, NAO TRANSITA ADQUIRENTE',1,'2009-08-19 00:32:18'),(511,6925,'RETORNO MERC. REC. P/ INDUST, CONTA-ORDEM ADQUIRENTE, NAO TRANSITA',1,'2009-08-19 00:32:18'),(512,6929,'LANCAMENTO EMISSAO DOCUMENTO FISCAL, TAMBEM ECF',1,'2009-08-19 00:32:18'),(513,6931,'LANCAMENTO RESPONSABILIDADE RETENCAO IMPOSTO ST, SERVICO TRANSPORTE',1,'2009-08-19 00:32:18'),(514,6932,'PRESTACAO SERVICO TRANSPORTE INICIO OUTRA UF',1,'2009-08-19 00:32:18'),(515,6933,'PRESTAO DE SERVIO TRIBUTADO PELO ISSQN.',1,'2009-08-19 00:32:18'),(516,6949,'OUTRA SAIDA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADO',1,'2009-08-19 00:32:19'),(517,7101,'VENDA PRODUCAO DO ESTABELECIMENTO',1,'2009-08-19 00:32:19'),(518,7102,'VENDA MERCADORIA ADQUIRIDA OU RECEBIDA DE TERCEIROS',1,'2009-08-19 00:32:19'),(519,7105,'VENDA PRODUCAO DO ESTABELECIMENTO QUE NAO DEVA POR ELE TRANSITAR',1,'2009-08-19 00:32:19'),(520,7106,'VENDA MERC. ADQUIRIDA-RECEBIDA TERCEIROS, QUE NAO DEVA TRANSITAR',1,'2009-08-19 00:32:19'),(521,7127,'VENDA PRODUCAO, REGIME DRAWBACK',1,'2009-08-19 00:32:19'),(522,7201,'DEVOLUCAO COMPRA P/ INDUSTRIALIZACAO',1,'2009-08-19 00:32:19'),(523,7202,'DEVOLUCAO COMPRA P/ COMERCIALIZACAO',1,'2009-08-19 00:32:19'),(524,7205,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE COMUNICACAO',1,'2009-08-19 00:32:19'),(525,7206,'ANULACAO VALOR RELATIVO A AQUISICAO DE SERVICO DE TRANSPORTE',1,'2009-08-19 00:32:19'),(526,7207,'ANULACAO VALOR RELATIVO A COMPRA DE ENERGIA ELETRICA',1,'2009-08-19 00:32:19'),(527,7210,'DEVOLUCAO COMPRA P/ UTILIZACAO NA PRESTACAO DE SERVICO',1,'2009-08-19 00:32:19'),(528,7211,'DEVOLVUCAO COMPRA P/ INDUSTRIALIZACAO, REGIME DRAWBACK',1,'2009-08-19 00:32:19'),(529,7251,'VENDA ENERGIA ELETRICA P/ DISTRIBUICAO OU COMERCIALIZACAO',1,'2009-08-19 00:32:19'),(530,7301,'PRESTACAO SERVICO COMUNICACAO P/ EXECUCAO SERVICO MESMA NATUREZA',1,'2009-08-19 00:32:19'),(531,7358,'PRESTACAO SERVICO TRANSPORTE',1,'2009-08-19 00:32:19'),(532,7501,'EXPORTAAO MERC RECEB COM FIM ESPECIFICO DE EXPORTACAO',1,'2009-08-19 00:32:19'),(533,7551,'VENDA BEM DO ATIVO IMOBILIZADO',1,'2009-08-19 00:32:19'),(534,7553,'DEVOLUCAO COMPRA BEM P/ O ATIVO IMOBILIZADO',1,'2009-08-19 00:32:19'),(535,7556,'DEVOLUCAO COMPRA DE MATERIAL DE USO OU CONSUMO',1,'2009-08-19 00:32:19'),(536,7651,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE DE PRODUAO DO ESTABELECIMENT',1,'2009-08-19 00:32:19'),(537,7654,'VENDA DE COMBUSTIVEL OU LUBRIFICANTE ADQUIRIDO OU RECEBIDO DE TERC',1,'2009-08-19 00:32:19'),(538,7930,'LANCAMENTO DEVOLUCAO BEM, ENTRADA REGIME ESPECIAL ADUANEIRO',1,'2009-08-19 00:32:19'),(539,7949,'OUTRA SAIDA MERCADORIA OU PRESTACAO DE SERVICO NAO ESPECIFICADO',1,'2009-08-19 00:32:19');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cfop` ENABLE KEYS */;

--
-- Table structure for table `cfop_grupo`
--

DROP TABLE IF EXISTS `cfop_grupo`;
CREATE TABLE `cfop_grupo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `VendaNFCeForaUF_CFOP_Id` int(10) unsigned NOT NULL,
  `VendaNFCeDentroUF_CFOP_Id` int(10) unsigned NOT NULL,
  `RetornoConsertoDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `RetornoConsertoForaUF_CFOP_Id` int(10) unsigned default NULL,
  `BonificacaoDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `BonificacaoForaUF_CFOP_Id` int(10) unsigned default NULL,
  `RetornoDepositoForaUF_CFOP_Id` int(10) unsigned default NULL,
  `RetornoDepositoDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `RemessaConsertoForaUF_CFOP_Id` int(10) unsigned default NULL,
  `RemessaConsertoDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `DevolveVendaForaUF_CFOP_Id` int(10) unsigned default NULL,
  `DevolveVendaDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `DevolveCompraDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `DevolveCompraForaUF_CFOP_Id` int(10) unsigned default NULL,
  `VendaForaUF_CFOP_Id` int(10) unsigned default NULL,
  `VendaDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `CompraForaUF_CFOP_Id` int(10) unsigned default NULL,
  `CompraDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `RemessaIndustriaDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `RemessaIndustriaForaUF_CFOP_Id` int(10) unsigned default NULL,
  `RetornoIndustriaDentroUF_CFOP_Id` int(10) unsigned default NULL,
  `RetornoIndustriaForaUF_CFOP_Id` int(10) unsigned default NULL,
  `Descricao` varchar(50) NOT NULL,
  `CSOSN_VendaForaUF` varchar(3) default NULL,
  `CST_VendaForaUF` varchar(3) default NULL,
  `EntradaTransferDentroUF_Id` int(10) unsigned default NULL,
  `TransferSaidaDentroUF_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CFOP_Grupo_FK_CompraDentroUF` (`CompraDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_CompraForaUF` (`CompraForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_VendaDentroUF` (`VendaDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_VendaForaUF` (`VendaForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_DevolveCompraDentroUF` (`DevolveCompraDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_DevolveCompraForaUF` (`DevolveCompraForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_DevolveVendaDentroUF` (`DevolveVendaDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_DevolveVendaForaUF` (`DevolveVendaForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_RemessaConsertoDentroUF` (`RemessaConsertoDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_RemessaConsertoForaUF` (`RemessaConsertoForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FKIndex11` (`RetornoDepositoDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FKIndex12` (`RetornoDepositoForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_BonificacaoDentroUF` (`BonificacaoDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_BonificacaoForaUF` (`BonificacaoForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_RetornoConsertoDentroUF` (`RetornoConsertoDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_RetornoConsertoForaUF` (`RetornoConsertoForaUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_VendaNFCeDentroUF` (`VendaNFCeDentroUF_CFOP_Id`),
  KEY `CFOP_Grupo_FK_VendaNFCeForaUF` (`VendaNFCeForaUF_CFOP_Id`),
  CONSTRAINT `FK_CFOP_BonificacaoDentroUF` FOREIGN KEY (`BonificacaoDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_BonificacaoForaUF` FOREIGN KEY (`BonificacaoForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_CompraDentroEstado` FOREIGN KEY (`CompraDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_CompraForaUF` FOREIGN KEY (`CompraForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_DevolveCompraDentroUF` FOREIGN KEY (`DevolveCompraDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_DevolveCompraForaUF` FOREIGN KEY (`DevolveCompraForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_DevolveVendaDentroUF` FOREIGN KEY (`DevolveVendaDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_GrupoCFOPRetornoDeposito` FOREIGN KEY (`RetornoDepositoDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_GrupoCFOP_RetornoDeposito` FOREIGN KEY (`RetornoDepositoForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_RemessaConsertoDentroUF` FOREIGN KEY (`RemessaConsertoDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_RemessaConsertoForaUF` FOREIGN KEY (`RemessaConsertoForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_RetornoConsertoDentroUF` FOREIGN KEY (`RetornoConsertoDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_RetornoConsertoForaUF` FOREIGN KEY (`RetornoConsertoForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_VendaDentroUF` FOREIGN KEY (`VendaDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_VendaForaUF` FOREIGN KEY (`VendaForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_VendaNFCeDentroUF` FOREIGN KEY (`VendaNFCeDentroUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_VendaNFCeForaUF` FOREIGN KEY (`VendaNFCeForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_DevolveVendaForaUF` FOREIGN KEY (`DevolveVendaForaUF_CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cfop_grupo`
--


/*!40000 ALTER TABLE `cfop_grupo` DISABLE KEYS */;
LOCK TABLES `cfop_grupo` WRITE;
INSERT INTO `cfop_grupo` (`Id`, `VendaNFCeForaUF_CFOP_Id`, `VendaNFCeDentroUF_CFOP_Id`, `RetornoConsertoDentroUF_CFOP_Id`, `RetornoConsertoForaUF_CFOP_Id`, `BonificacaoDentroUF_CFOP_Id`, `BonificacaoForaUF_CFOP_Id`, `RetornoDepositoForaUF_CFOP_Id`, `RetornoDepositoDentroUF_CFOP_Id`, `RemessaConsertoForaUF_CFOP_Id`, `RemessaConsertoDentroUF_CFOP_Id`, `DevolveVendaForaUF_CFOP_Id`, `DevolveVendaDentroUF_CFOP_Id`, `DevolveCompraDentroUF_CFOP_Id`, `DevolveCompraForaUF_CFOP_Id`, `VendaForaUF_CFOP_Id`, `VendaDentroUF_CFOP_Id`, `CompraForaUF_CFOP_Id`, `CompraDentroUF_CFOP_Id`, `RemessaIndustriaDentroUF_CFOP_Id`, `RemessaIndustriaForaUF_CFOP_Id`, `RetornoIndustriaDentroUF_CFOP_Id`, `RetornoIndustriaForaUF_CFOP_Id`, `Descricao`, `CSOSN_VendaForaUF`, `CST_VendaForaUF`, `EntradaTransferDentroUF_Id`, `TransferSaidaDentroUF_Id`) VALUES (1,0,0,NULL,NULL,NULL,NULL,0,0,NULL,NULL,133,19,277,416,387,250,116,2,NULL,NULL,NULL,NULL,'CFOPs COMPRA E VENDA COMUM',NULL,NULL,NULL,NULL),(2,0,0,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,330,468,NULL,NULL,180,68,NULL,NULL,NULL,NULL,'CFOPs COMPRA E VENDA MATERIAL DE USO E CONSUMO',NULL,NULL,NULL,NULL),(3,0,0,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,327,465,463,325,175,63,NULL,NULL,NULL,NULL,'CFOPs COMPRA E VENDA DE IMOBILIZADO',NULL,NULL,NULL,NULL),(4,0,0,NULL,NULL,NULL,NULL,0,0,NULL,NULL,167,53,314,453,448,309,161,47,NULL,NULL,NULL,NULL,'CFOPs COMPRA E VENDA COM SUBSTITUICAO TRIBUTRIA',NULL,NULL,NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `cfop_grupo` ENABLE KEYS */;

--
-- Table structure for table `cfopgrupoitem`
--

DROP TABLE IF EXISTS `cfopgrupoitem`;
CREATE TABLE `cfopgrupoitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CFOP_Id` int(10) unsigned NOT NULL,
  `CFOPGrupo_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CFOPGrupoItem_FK_Grupo` (`CFOPGrupo_Id`),
  KEY `CFOPGrupoItem_FK_CFOP` (`CFOP_Id`),
  CONSTRAINT `FK_CFOPGrupo_Item` FOREIGN KEY (`CFOPGrupo_Id`) REFERENCES `cfop_grupo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_GrupoItem` FOREIGN KEY (`CFOP_Id`) REFERENCES `fisccfop` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cfopgrupoitem`
--


/*!40000 ALTER TABLE `cfopgrupoitem` DISABLE KEYS */;
LOCK TABLES `cfopgrupoitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cfopgrupoitem` ENABLE KEYS */;

--
-- Table structure for table `cheque`
--

DROP TABLE IF EXISTS `cheque`;
CREATE TABLE `cheque` (
  `Id` int(11) NOT NULL auto_increment,
  `ContasReceberChqDevolvido_Id` int(11) default NULL,
  `CaixaEntrada2_Id` int(11) default NULL,
  `CaixaEntrada_Id` int(11) default NULL,
  `CaixaSaida2_Id` int(11) default NULL,
  `CaixaSaida_Id` int(11) default NULL,
  `ChequeResgate_Id` int(10) unsigned default NULL,
  `Caixa_Id` int(11) default NULL COMMENT 'Caixa Cofre',
  `CaixaResgate_Id` int(11) default NULL,
  `ValeAdiantamento_Id` int(10) unsigned default NULL,
  `Cidade_Id` int(11) default NULL,
  `ContaBancaria_Id` int(11) default NULL,
  `ContaBancaria2_Id` int(11) default NULL,
  `ContaRecebida_Id` int(11) default NULL,
  `Banco_Id` int(11) NOT NULL,
  `PagamentoAvulso_Id` int(10) unsigned default NULL,
  `Loja_Id` int(11) NOT NULL,
  `ContaPaga_Id` int(11) default NULL,
  `Tipo` tinyint(3) unsigned default NULL COMMENT '0 Proprio/1 Cliente/ 2 Terceiro',
  `Agencia` varchar(8) NOT NULL,
  `ContaBancaria` varchar(10) default NULL,
  `Numero` int(11) NOT NULL,
  `NomeTitular` varchar(35) default NULL,
  `CPFTitular` varchar(18) default NULL,
  `Valor` float(12,2) default NULL,
  `Vencimento` date default NULL,
  `Alinea` enum('Compensado','Sustado','Sem Fundo','Roubado','Outros','Em Acordo') default NULL,
  `DataAlinea1` date default NULL,
  `Alinea2` enum('Compensado','Sem Fundo','Outros','Em Acordo') default NULL,
  `DataAlinea2` date default NULL,
  `NominalA` varchar(35) default NULL,
  `Obs` text,
  `DataEnvio` date default NULL,
  `DataEnvio2` date default NULL,
  `DataBaixa` date default NULL,
  `DataBaixa2` date default NULL,
  `ImpressaoDefinida` tinyint(1) default NULL,
  `DataHoraImpressao` datetime default NULL,
  `CanceladoRazurado` date default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `AdiantamentoSalarial_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Cheque_FK_ContaPaga` (`ContaPaga_Id`),
  KEY `Cheque_FK_Loja` (`Loja_Id`),
  KEY `Cheque_FK_PagamentoAvulso` (`PagamentoAvulso_Id`),
  KEY `Cheque_FK_Banco` (`Banco_Id`),
  KEY `Cheque_FK_ContaRecebida` (`ContaRecebida_Id`),
  KEY `Cheque_FK_ContaBancaria` (`ContaBancaria_Id`),
  KEY `Cheque_FK_Cidade` (`Cidade_Id`),
  KEY `Cheque_FK_ValeAdiantamento` (`ValeAdiantamento_Id`),
  KEY `Cheque_FK_CaixaResgate` (`CaixaResgate_Id`),
  KEY `Cheque_FK_Caixa` (`Caixa_Id`),
  KEY `Cheque_FK_Resgate` (`ChequeResgate_Id`),
  KEY `Cheque_FKIndex12` (`ContaBancaria2_Id`),
  KEY `Cheque_FK_CaixaSaida` (`CaixaSaida_Id`),
  KEY `Cheque_FKIndex14` (`CaixaSaida2_Id`),
  KEY `Cheque_FKIndex15` (`CaixaEntrada_Id`),
  KEY `Cheque_FKIndex16` (`CaixaEntrada2_Id`),
  KEY `Cheque_FKIndex17` (`ContasReceberChqDevolvido_Id`),
  CONSTRAINT `ChequeResgate_Cheque` FOREIGN KEY (`ChequeResgate_Id`) REFERENCES `chequeresgate` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Banco_Cheque` FOREIGN KEY (`Banco_Id`) REFERENCES `banco` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CaixaEntrada2_Cheque` FOREIGN KEY (`CaixaEntrada2_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CaixaEntrada_Cheque` FOREIGN KEY (`CaixaEntrada_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CaixaResgate_Cheque` FOREIGN KEY (`CaixaResgate_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CaixaSaida2_Cheque` FOREIGN KEY (`CaixaSaida2_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CaixaSaida_Cheque` FOREIGN KEY (`CaixaSaida_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Caixa_Cheque` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Cidade_Cheque` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta2_Cheque` FOREIGN KEY (`ContaBancaria2_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaPaga_Cheque` FOREIGN KEY (`ContaPaga_Id`) REFERENCES `contapaga` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaRecebida_Cheque` FOREIGN KEY (`ContaRecebida_Id`) REFERENCES `contarecebida` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContasReceberChqDevolvido_Cheque` FOREIGN KEY (`ContasReceberChqDevolvido_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta_Cheque` FOREIGN KEY (`ContaBancaria_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Cheque` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PagamentoAvulso_Cheque` FOREIGN KEY (`PagamentoAvulso_Id`) REFERENCES `pagamentoavulso` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ValeAdiantamento_Cheque` FOREIGN KEY (`ValeAdiantamento_Id`) REFERENCES `valeadiantamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cheque`
--


/*!40000 ALTER TABLE `cheque` DISABLE KEYS */;
LOCK TABLES `cheque` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cheque` ENABLE KEYS */;

--
-- Table structure for table `chequeproprioemitido`
--

DROP TABLE IF EXISTS `chequeproprioemitido`;
CREATE TABLE `chequeproprioemitido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancMovimentoBancario_Id` int(10) unsigned default NULL,
  `Historico` varchar(30) default NULL,
  `Numero` int(10) unsigned default NULL,
  `Valor` float(12,2) default NULL,
  `Emissao` date default NULL,
  `Compensado` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ChequeProprio_FK_MovimentoBancario` (`FinancMovimentoBancario_Id`),
  CONSTRAINT `Rel_379` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `chequeproprioemitido`
--


/*!40000 ALTER TABLE `chequeproprioemitido` DISABLE KEYS */;
LOCK TABLES `chequeproprioemitido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `chequeproprioemitido` ENABLE KEYS */;

--
-- Table structure for table `chequeresgate`
--

DROP TABLE IF EXISTS `chequeresgate`;
CREATE TABLE `chequeresgate` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Caixa_Id` int(11) NOT NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `ChequeResgatado_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ChequeResgate_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `ChequeResgate_FK_Caixa` (`Caixa_Id`),
  KEY `ChequeResgate_FK_Loja` (`Loja_Id`),
  CONSTRAINT `Caixa_ChequeResgate` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FormaPagamento_ChequeResgate` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Loja_ChequeResgate` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `chequeresgate`
--


/*!40000 ALTER TABLE `chequeresgate` DISABLE KEYS */;
LOCK TABLES `chequeresgate` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `chequeresgate` ENABLE KEYS */;

--
-- Table structure for table `chequevinculado`
--

DROP TABLE IF EXISTS `chequevinculado`;
CREATE TABLE `chequevinculado` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Cheque_Id` int(11) NOT NULL,
  `Tabela` varchar(50) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ChequeVinculado_FK_Cheque` (`Cheque_Id`),
  CONSTRAINT `FK_Cheque_Vinculo` FOREIGN KEY (`Cheque_Id`) REFERENCES `cheque` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `chequevinculado`
--


/*!40000 ALTER TABLE `chequevinculado` DISABLE KEYS */;
LOCK TABLES `chequevinculado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `chequevinculado` ENABLE KEYS */;

--
-- Table structure for table `cidade`
--

DROP TABLE IF EXISTS `cidade`;
CREATE TABLE `cidade` (
  `Id` int(11) NOT NULL auto_increment,
  `Municipio_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `UF_Id` int(11) NOT NULL,
  `Nome` varchar(35) NOT NULL,
  `Pontos` int(11) default NULL,
  `loc_nu_sequencial` int(10) unsigned default NULL,
  `cep` int(10) unsigned default NULL,
  `ufe_sg` varchar(2) default NULL,
  `CodigoMunicipio` varchar(7) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Cidades_FKIndex1` (`UF_Id`),
  KEY `Cidade_FKIndex3` (`Loja_Id`),
  KEY `Cidade_FKIndex4` (`Municipio_Id`),
  KEY `Cidade_Nome` (`Nome`),
  CONSTRAINT `FK_Loja_Cidade` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Municipio_Cidade` FOREIGN KEY (`Municipio_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_UF_Cidade` FOREIGN KEY (`UF_Id`) REFERENCES `uf` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5562 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cidade`
--


/*!40000 ALTER TABLE `cidade` DISABLE KEYS */;
LOCK TABLES `cidade` WRITE;
INSERT INTO `cidade` (`Id`, `Municipio_Id`, `Loja_Id`, `UF_Id`, `Nome`, `Pontos`, `loc_nu_sequencial`, `cep`, `ufe_sg`, `CodigoMunicipio`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,NULL,1,2,'ACRELNDIA',NULL,1,69945000,'AC','1200013',1,'2006-11-12 16:53:07'),(2,NULL,1,2,'ASSIS BRASIL',NULL,2,69935000,'AC','1200054',1,'2006-11-12 16:53:09'),(3,NULL,1,2,'BRASILIA',NULL,3,69932000,'AC','1200104',1,'2006-11-12 16:53:09'),(4,NULL,1,2,'BUJARI',NULL,4,69923000,'AC','1200138',1,'2006-11-12 16:53:09'),(5,NULL,1,2,'CAPIXABA',NULL,5,69922000,'AC','1200179',1,'2006-11-12 16:53:10'),(6,NULL,1,2,'CRUZEIRO DO SUL',NULL,6,69980000,'AC','1200203',1,'2006-11-12 16:53:10'),(7,NULL,1,2,'EPITACIOLNDIA',NULL,7,69934000,'AC','1200252',1,'2006-11-12 16:53:10'),(8,NULL,1,2,'FEIJ',NULL,8,69960000,'AC','1200302',1,'2006-11-12 16:53:10'),(9,NULL,1,2,'JORDO',NULL,9,69975000,'AC','1200328',1,'2006-11-12 16:53:10'),(10,NULL,1,2,'MNCIO LIMA',NULL,10,69990000,'AC','1200336',1,'2006-11-12 16:53:10'),(11,NULL,1,2,'MANOEL URBANO',NULL,11,69950000,'AC','1200344',1,'2006-11-12 16:53:10'),(12,NULL,1,2,'MARECHAL THAUMATURGO',NULL,12,69983000,'AC','1200351',1,'2006-11-12 16:53:10'),(13,NULL,1,2,'PLCIDO DE CASTRO',NULL,13,69928000,'AC','1200385',1,'2006-11-12 16:53:10'),(14,NULL,1,2,'PORTO ACRE',NULL,14,69921000,'AC','1200807',1,'2006-11-12 16:53:10'),(15,NULL,1,2,'PORTO WALTER',NULL,15,69982000,'AC','1200393',1,'2006-11-12 16:53:10'),(16,NULL,1,2,'RIO BRANCO',NULL,16,NULL,'AC','1200401',1,'2006-11-12 16:53:10'),(17,NULL,1,2,'RODRIGUES ALVES',NULL,17,69985000,'AC','1200427',1,'2006-11-12 16:53:10'),(18,NULL,1,2,'SANTA ROSA',NULL,18,69955000,'AC',NULL,1,'2006-11-12 16:53:10'),(19,NULL,1,2,'SENA MADUREIRA',NULL,19,69940000,'AC','1200500',1,'2006-11-12 16:53:10'),(20,NULL,1,2,'SENADOR GUIOMARD',NULL,20,69925000,'AC','1200450',1,'2006-11-12 16:53:10'),(21,NULL,1,2,'TARAUAC',NULL,21,69970000,'AC','1200609',1,'2006-11-12 16:53:10'),(22,NULL,1,2,'XAPURI',NULL,22,69930000,'AC','1200708',1,'2006-11-12 16:53:10'),(23,NULL,1,16,'GUA BRANCA',NULL,23,57490000,'AL','2700102',1,'2006-11-12 16:53:10'),(24,NULL,1,16,'ANADIA',NULL,26,57660000,'AL','2700201',1,'2006-11-12 16:53:10'),(25,NULL,1,16,'ARAPIRACA',NULL,30,NULL,'AL','2700300',1,'2006-11-12 16:53:10'),(26,NULL,1,16,'ATALAIA',NULL,31,57690000,'AL','2700409',1,'2006-11-12 16:53:10'),(27,NULL,1,16,'BARRA DE SANTO ANTNIO',NULL,36,57925000,'AL','2700508',1,'2006-11-12 16:53:10'),(28,NULL,1,16,'BARRA DE SO MIGUEL',NULL,37,57180000,'AL','2700607',1,'2006-11-12 16:53:10'),(29,NULL,1,16,'BATALHA',NULL,40,57420000,'AL','2700706',1,'2006-11-12 16:53:10'),(30,NULL,1,16,'BELM',NULL,42,57630000,'AL','2700805',1,'2006-11-12 16:53:10'),(31,NULL,1,16,'BELO MONTE',NULL,43,57435000,'AL','2700904',1,'2006-11-12 16:53:10'),(32,NULL,1,16,'BOCA DA MATA',NULL,47,57680000,'AL','2701001',1,'2006-11-12 16:53:11'),(33,NULL,1,16,'BRANQUINHA',NULL,50,57830000,'AL','2701100',1,'2006-11-12 16:53:11'),(34,NULL,1,16,'CACIMBINHAS',NULL,51,57570000,'AL','2701209',1,'2006-11-12 16:53:11'),(35,NULL,1,16,'CAJUEIRO',NULL,53,57770000,'AL','2701308',1,'2006-11-12 16:53:11'),(36,NULL,1,16,'CAMPESTRE',NULL,56,57968000,'AL','2701357',1,'2006-11-12 16:53:11'),(37,NULL,1,16,'CAMPO ALEGRE',NULL,57,57250000,'AL','2701407',1,'2006-11-12 16:53:11'),(38,NULL,1,16,'CAMPO GRANDE',NULL,58,57350000,'AL','2701506',1,'2006-11-12 16:53:11'),(39,NULL,1,16,'CANAPI',NULL,61,57530000,'AL','2701605',1,'2006-11-12 16:53:11'),(40,NULL,1,16,'CAPELA',NULL,64,57780000,'AL','2701704',1,'2006-11-12 16:53:11'),(41,NULL,1,16,'CARNEIROS',NULL,65,57535000,'AL','2701803',1,'2006-11-12 16:53:11'),(42,NULL,1,16,'CH PRETA',NULL,67,57760000,'AL','2701902',1,'2006-11-12 16:53:11'),(43,NULL,1,16,'COIT DO NIA',NULL,68,57325000,'AL','2702009',1,'2006-11-12 16:53:11'),(44,NULL,1,16,'COLNIA LEOPOLDINA',NULL,69,57975000,'AL','2702108',1,'2006-11-12 16:53:11'),(45,NULL,1,16,'COQUEIRO SECO',NULL,70,57140000,'AL','2702207',1,'2006-11-12 16:53:11'),(46,NULL,1,16,'CORURIPE',NULL,71,57230000,'AL','2702306',1,'2006-11-12 16:53:11'),(47,NULL,1,16,'CRABAS',NULL,73,57320000,'AL','2702355',1,'2006-11-12 16:53:11'),(48,NULL,1,16,'DELMIRO GOUVEIA',NULL,74,57480000,'AL','2702405',1,'2006-11-12 16:53:11'),(49,NULL,1,16,'DOIS RIACHOS',NULL,75,57560000,'AL','2702504',1,'2006-11-12 16:53:11'),(50,NULL,1,16,'ESTRELA DE ALAGOAS',NULL,77,57625000,'AL','2702553',1,'2006-11-12 16:53:11'),(51,NULL,1,16,'FEIRA GRANDE',NULL,78,57340000,'AL','2702603',1,'2006-11-12 16:53:11'),(52,NULL,1,16,'FELIZ DESERTO',NULL,79,57220000,'AL','2702702',1,'2006-11-12 16:53:11'),(53,NULL,1,16,'FLEXEIRAS',NULL,81,57995000,'AL','2702801',1,'2006-11-12 16:53:11'),(54,NULL,1,16,'GIRAU DO PONCIANO',NULL,84,57360000,'AL','2702900',1,'2006-11-12 16:53:11'),(55,NULL,1,16,'IBATEGUARA',NULL,85,57890000,'AL','2703007',1,'2006-11-12 16:53:12'),(56,NULL,1,16,'IGACI',NULL,86,57620000,'AL','2703106',1,'2006-11-12 16:53:12'),(57,NULL,1,16,'IGREJA NOVA',NULL,87,57280000,'AL','2703205',1,'2006-11-12 16:53:12'),(58,NULL,1,16,'INHAPI',NULL,88,57545000,'AL','2703304',1,'2006-11-12 16:53:12'),(59,NULL,1,16,'JACAR DOS HOMENS',NULL,89,57430000,'AL','2703403',1,'2006-11-12 16:53:12'),(60,NULL,1,16,'JACUPE',NULL,90,57960000,'AL','2703502',1,'2006-11-12 16:53:12'),(61,NULL,1,16,'JAPARATINGA',NULL,91,57950000,'AL','2703601',1,'2006-11-12 16:53:12'),(62,NULL,1,16,'JARAMATAIA',NULL,92,57425000,'AL','2703700',1,'2006-11-12 16:53:12'),(63,NULL,1,16,'JOAQUIM GOMES',NULL,94,57980000,'AL','2703809',1,'2006-11-12 16:53:12'),(64,NULL,1,16,'JUNDI',NULL,95,57965000,'AL','2703908',1,'2006-11-12 16:53:12'),(65,NULL,1,16,'JUNQUEIRO',NULL,96,57270000,'AL','2704005',1,'2006-11-12 16:53:12'),(66,NULL,1,16,'LAGOA DA CANOA',NULL,98,57330000,'AL','2704104',1,'2006-11-12 16:53:12'),(67,NULL,1,16,'LIMOEIRO DE ANADIA',NULL,108,57260000,'AL','2704203',1,'2006-11-12 16:53:12'),(68,NULL,1,16,'MACEI',NULL,109,NULL,'AL','2704302',1,'2006-11-12 16:53:12'),(69,NULL,1,16,'MAJOR ISIDORO',NULL,110,57580000,'AL','2704401',1,'2006-11-12 16:53:12'),(70,NULL,1,16,'MAR VERMELHO',NULL,111,57730000,'AL','2704906',1,'2006-11-12 16:53:12'),(71,NULL,1,16,'MARAGOGI',NULL,112,57955000,'AL','2704500',1,'2006-11-12 16:53:12'),(72,NULL,1,16,'MARAVILHA',NULL,113,57520000,'AL','2704609',1,'2006-11-12 16:53:12'),(73,NULL,1,16,'MARECHAL DEODORO',NULL,114,57160000,'AL','2704708',1,'2006-11-12 16:53:12'),(74,NULL,1,16,'MARIBONDO',NULL,115,57670000,'AL','2704807',1,'2006-11-12 16:53:12'),(75,NULL,1,16,'MATA GRANDE',NULL,117,57540000,'AL','2705002',1,'2006-11-12 16:53:12'),(76,NULL,1,16,'MATRIZ DE CAMARAGIBE',NULL,118,57910000,'AL','2705101',1,'2006-11-12 16:53:12'),(77,NULL,1,16,'MESSIAS',NULL,119,57990000,'AL','2705200',1,'2006-11-12 16:53:12'),(78,NULL,1,16,'MINADOR DO NEGRO',NULL,120,57615000,'AL','2705309',1,'2006-11-12 16:53:13'),(79,NULL,1,16,'MONTEIRPOLIS',NULL,121,57440000,'AL','2705408',1,'2006-11-12 16:53:13'),(80,NULL,1,16,'MURICI',NULL,124,57820000,'AL','2705507',1,'2006-11-12 16:53:13'),(81,NULL,1,16,'NOVO LINO',NULL,125,57970000,'AL','2705606',1,'2006-11-12 16:53:13'),(82,NULL,1,16,'OLHO D\'GUA GRANDE',NULL,126,57390000,'AL',NULL,1,'2006-11-12 16:53:13'),(83,NULL,1,16,'OLHO D\'GUA DAS FLORES',NULL,127,57442000,'AL',NULL,1,'2006-11-12 16:53:13'),(84,NULL,1,16,'OLHO D\'GUA DO CASADO',NULL,129,57470000,'AL',NULL,1,'2006-11-12 16:53:13'),(85,NULL,1,16,'OLIVENA',NULL,131,57550000,'AL','2706000',1,'2006-11-12 16:53:13'),(86,NULL,1,16,'OURO BRANCO',NULL,132,57525000,'AL','2706109',1,'2006-11-12 16:53:13'),(87,NULL,1,16,'PALESTINA',NULL,133,57410000,'AL','2706208',1,'2006-11-12 16:53:13'),(88,NULL,1,16,'PALMEIRA DOS NDIOS',NULL,135,NULL,'AL','2706307',1,'2006-11-12 16:53:13'),(89,NULL,1,16,'PO DE ACAR',NULL,136,57400000,'AL','2706406',1,'2006-11-12 16:53:13'),(90,NULL,1,16,'PARICONHA',NULL,137,57475000,'AL','2706422',1,'2006-11-12 16:53:13'),(91,NULL,1,16,'PARIPUEIRA',NULL,138,57935000,'AL','2706448',1,'2006-11-12 16:53:13'),(92,NULL,1,16,'PASSO DE CAMARAGIBE',NULL,139,57930000,'AL','2706505',1,'2006-11-12 16:53:13'),(93,NULL,1,16,'PAULO JACINTO',NULL,142,57740000,'AL','2706604',1,'2006-11-12 16:53:13'),(94,NULL,1,16,'PENEDO',NULL,143,57200000,'AL','2706703',1,'2006-11-12 16:53:13'),(95,NULL,1,16,'PIACABUU',NULL,144,57210000,'AL','2706802',1,'2006-11-12 16:53:13'),(96,NULL,1,16,'PILAR',NULL,145,57150000,'AL','2706901',1,'2006-11-12 16:53:13'),(97,NULL,1,16,'PINDOBA',NULL,146,57720000,'AL','2707008',1,'2006-11-12 16:53:13'),(98,NULL,1,16,'PIRANHAS',NULL,147,57460000,'AL','2707107',1,'2006-11-12 16:53:13'),(99,NULL,1,16,'POO DAS TRINCHEIRAS',NULL,150,57510000,'AL','2707206',1,'2006-11-12 16:53:13'),(100,NULL,1,16,'PORTO CALVO',NULL,151,57900000,'AL','2707305',1,'2006-11-12 16:53:14'),(101,NULL,1,16,'PORTO DE PEDRAS',NULL,152,57945000,'AL','2707404',1,'2006-11-12 16:53:14'),(102,NULL,1,16,'PORTO REAL DO COLGIO',NULL,153,57290000,'AL','2707503',1,'2006-11-12 16:53:14'),(103,NULL,1,16,'QUEBRNGULO',NULL,155,57750000,'AL','2707602',1,'2006-11-12 16:53:14'),(104,NULL,1,16,'RIO LARGO',NULL,158,57100000,'AL','2707701',1,'2006-11-12 16:53:14'),(105,NULL,1,16,'ROTEIRO',NULL,160,57246000,'AL','2707800',1,'2006-11-12 16:53:14'),(106,NULL,1,16,'SANTA LUZIA DO NORTE',NULL,162,57130000,'AL','2707909',1,'2006-11-12 16:53:14'),(107,NULL,1,16,'SANTANA DO IPANEMA',NULL,163,57500000,'AL','2708006',1,'2006-11-12 16:53:14'),(108,NULL,1,16,'SANTANA DO MUNDA',NULL,164,57840000,'AL','2708105',1,'2006-11-12 16:53:14'),(109,NULL,1,16,'SO BRS',NULL,166,57380000,'AL','2708204',1,'2006-11-12 16:53:14'),(110,NULL,1,16,'SO JOS DA LAJE',NULL,167,57860000,'AL','2708303',1,'2006-11-12 16:53:14'),(111,NULL,1,16,'SO JOS DA TAPERA',NULL,168,57445000,'AL','2708402',1,'2006-11-12 16:53:14'),(112,NULL,1,16,'SO LUS DO QUITUND',NULL,169,57920000,'AL','2708501',1,'2006-11-12 16:53:14'),(113,NULL,1,16,'SO MIGUEL DOS CAMPOS',NULL,170,57240000,'AL','2708600',1,'2006-11-12 16:53:14'),(114,NULL,1,16,'SO MIGUEL DOS MILAGRES',NULL,171,57940000,'AL','2708709',1,'2006-11-12 16:53:14'),(115,NULL,1,16,'SO SEBASTIO',NULL,172,57275000,'AL','2708808',1,'2006-11-12 16:53:14'),(116,NULL,1,16,'SATUBA',NULL,175,57120000,'AL','2708907',1,'2006-11-12 16:53:14'),(117,NULL,1,16,'SENADOR RUI PALMEIRA',NULL,176,57515000,'AL','2708956',1,'2006-11-12 16:53:14'),(118,NULL,1,16,'TANQUE D\'ARCA',NULL,181,57635000,'AL',NULL,1,'2006-11-12 16:53:14'),(119,NULL,1,16,'TAQUARANA',NULL,182,57640000,'AL','2709103',1,'2006-11-12 16:53:14'),(120,NULL,1,16,'TEOTNIO VILELA',NULL,184,57265000,'AL','2709152',1,'2006-11-12 16:53:14'),(121,NULL,1,16,'TRAIPU',NULL,185,57370000,'AL','2709202',1,'2006-11-12 16:53:15'),(122,NULL,1,16,'UNIO DOS PALMARES',NULL,186,57800000,'AL','2709301',1,'2006-11-12 16:53:15'),(123,NULL,1,16,'VIOSA',NULL,188,57700000,'AL','2709400',1,'2006-11-12 16:53:15'),(124,NULL,1,3,'ALVARES',NULL,191,69475000,'AM','1300029',1,'2006-11-12 16:53:15'),(125,NULL,1,3,'AMATUR',NULL,193,69620000,'AM','1300060',1,'2006-11-12 16:53:15'),(126,NULL,1,3,'ANAM',NULL,194,69445000,'AM','1300086',1,'2006-11-12 16:53:15'),(127,NULL,1,3,'ANORI',NULL,195,69440000,'AM','1300102',1,'2006-11-12 16:53:15'),(128,NULL,1,3,'APU',NULL,196,69265000,'AM','1300144',1,'2006-11-12 16:53:15'),(129,NULL,1,3,'ATALAIA DO NORTE',NULL,198,69650000,'AM','1300201',1,'2006-11-12 16:53:15'),(130,NULL,1,3,'AUTAZES',NULL,200,69240000,'AM','1300300',1,'2006-11-12 16:53:15'),(131,NULL,1,3,'BARCELOS',NULL,204,69700000,'AM','1300409',1,'2006-11-12 16:53:15'),(132,NULL,1,3,'BARREIRINHA',NULL,205,69160000,'AM','1300508',1,'2006-11-12 16:53:15'),(133,NULL,1,3,'BENJAMIN CONSTANT',NULL,206,69630000,'AM','1300607',1,'2006-11-12 16:53:15'),(134,NULL,1,3,'BERURI',NULL,207,69430000,'AM','1300631',1,'2006-11-12 16:53:15'),(135,NULL,1,3,'BOA VISTA DO RAMOS',NULL,208,69195000,'AM','1300680',1,'2006-11-12 16:53:15'),(136,NULL,1,3,'BOCA DO ACRE',NULL,209,69850000,'AM','1300706',1,'2006-11-12 16:53:15'),(137,NULL,1,3,'BORBA',NULL,210,69200000,'AM','1300805',1,'2006-11-12 16:53:15'),(138,NULL,1,3,'CAAPIRANGA',NULL,211,69410000,'AM','1300839',1,'2006-11-12 16:53:15'),(139,NULL,1,3,'CANUTAMA',NULL,214,69820000,'AM','1300904',1,'2006-11-12 16:53:15'),(140,NULL,1,3,'CARAUARI',NULL,215,69500000,'AM','1301001',1,'2006-11-12 16:53:15'),(141,NULL,1,3,'CAREIRO',NULL,216,69250000,'AM','1301100',1,'2006-11-12 16:53:15'),(142,NULL,1,3,'CAREIRO DA VRZEA',NULL,217,69255000,'AM','1301159',1,'2006-11-12 16:53:16'),(143,NULL,1,3,'COARI',NULL,219,69460000,'AM','1301209',1,'2006-11-12 16:53:16'),(144,NULL,1,3,'CODAJS',NULL,220,69450000,'AM','1301308',1,'2006-11-12 16:53:16'),(145,NULL,1,3,'EIRUNEP',NULL,222,69880000,'AM','1301407',1,'2006-11-12 16:53:16'),(146,NULL,1,3,'ENVIRA',NULL,223,69870000,'AM','1301506',1,'2006-11-12 16:53:16'),(147,NULL,1,3,'FONTE BOA',NULL,225,69670000,'AM','1301605',1,'2006-11-12 16:53:16'),(148,NULL,1,3,'GUAJAR',NULL,227,69895000,'AM','1301654',1,'2006-11-12 16:53:16'),(149,NULL,1,3,'HUMAIT',NULL,228,69800000,'AM','1301704',1,'2006-11-12 16:53:16'),(150,NULL,1,3,'IPIXUNA',NULL,231,69890000,'AM','1301803',1,'2006-11-12 16:53:16'),(151,NULL,1,3,'IRANDUBA',NULL,232,69405000,'AM','1301852',1,'2006-11-12 16:53:16'),(152,NULL,1,3,'ITACOATIARA',NULL,233,69100000,'AM','1301902',1,'2006-11-12 16:53:16'),(153,NULL,1,3,'ITAMARATI',NULL,234,69510000,'AM','1301951',1,'2006-11-12 16:53:16'),(154,NULL,1,3,'ITAPIRANGA',NULL,235,69120000,'AM','1302009',1,'2006-11-12 16:53:16'),(155,NULL,1,3,'JAPUR',NULL,236,69495000,'AM','1302108',1,'2006-11-12 16:53:16'),(156,NULL,1,3,'JURU',NULL,237,69520000,'AM','1302207',1,'2006-11-12 16:53:16'),(157,NULL,1,3,'JUTA',NULL,238,69660000,'AM','1302306',1,'2006-11-12 16:53:16'),(158,NULL,1,3,'LBREA',NULL,239,69830000,'AM','1302405',1,'2006-11-12 16:53:16'),(159,NULL,1,3,'MANACAPURU',NULL,241,69400000,'AM','1302504',1,'2006-11-12 16:53:16'),(160,NULL,1,3,'MANAQUIRI',NULL,242,69435000,'AM','1302553',1,'2006-11-12 16:53:16'),(161,NULL,1,3,'MANAUS',NULL,243,NULL,'AM','1302603',1,'2006-11-12 16:53:16'),(162,NULL,1,3,'MANICOR',NULL,244,69280000,'AM','1302702',1,'2006-11-12 16:53:16'),(163,NULL,1,3,'MARA',NULL,245,69490000,'AM','1302801',1,'2006-11-12 16:53:17'),(164,NULL,1,3,'MAUS',NULL,247,69190000,'AM','1302900',1,'2006-11-12 16:53:17'),(165,NULL,1,3,'NHAMUND',NULL,251,69140000,'AM','1303007',1,'2006-11-12 16:53:17'),(166,NULL,1,3,'NOVA OLINDA DO NORTE',NULL,252,69230000,'AM','1303106',1,'2006-11-12 16:53:17'),(167,NULL,1,3,'NOVO AIRO',NULL,253,69730000,'AM','1303205',1,'2006-11-12 16:53:17'),(168,NULL,1,3,'NOVO ARIPUAN',NULL,254,69260000,'AM','1303304',1,'2006-11-12 16:53:17'),(169,NULL,1,3,'PARINTINS',NULL,256,NULL,'AM','1303403',1,'2006-11-12 16:53:17'),(170,NULL,1,3,'PAUINI',NULL,257,69860000,'AM','1303502',1,'2006-11-12 16:53:17'),(171,NULL,1,3,'PRESIDENTE FIGUEIREDO',NULL,259,69735000,'AM','1303536',1,'2006-11-12 16:53:17'),(172,NULL,1,3,'RIO PRETO DA EVA',NULL,261,69115000,'AM','1303569',1,'2006-11-12 16:53:17'),(173,NULL,1,3,'SANTA ISABEL DO RIO NEGRO',NULL,262,69740000,'AM','1303601',1,'2006-11-12 16:53:17'),(174,NULL,1,3,'SANTO ANTNIO DO I',NULL,264,69680000,'AM','1303700',1,'2006-11-12 16:53:17'),(175,NULL,1,3,'SO GABRIEL DA CACHOEIRA',NULL,266,69750000,'AM','1303809',1,'2006-11-12 16:53:17'),(176,NULL,1,3,'SO PAULO DE OLIVENA',NULL,267,69600000,'AM','1303908',1,'2006-11-12 16:53:17'),(177,NULL,1,3,'SO SEBASTIO DO UATUM',NULL,268,69135000,'AM','1303957',1,'2006-11-12 16:53:17'),(178,NULL,1,3,'SILVES',NULL,269,69110000,'AM','1304005',1,'2006-11-12 16:53:17'),(179,NULL,1,3,'TABATINGA',NULL,270,69640000,'AM','1304062',1,'2006-11-12 16:53:17'),(180,NULL,1,3,'TAPAU',NULL,271,69480000,'AM','1304104',1,'2006-11-12 16:53:17'),(181,NULL,1,3,'TEF',NULL,272,69470000,'AM','1304203',1,'2006-11-12 16:53:17'),(182,NULL,1,3,'TONANTINS',NULL,273,69685000,'AM','1304237',1,'2006-11-12 16:53:17'),(183,NULL,1,3,'UARINI',NULL,274,69485000,'AM','1304260',1,'2006-11-12 16:53:17'),(184,NULL,1,3,'URUCAR',NULL,275,69130000,'AM','1304302',1,'2006-11-12 16:53:17'),(185,NULL,1,3,'URUCURITUBA',NULL,276,69180000,'AM','1304401',1,'2006-11-12 16:53:18'),(186,NULL,1,6,'GUA BRANCA DO AMAPARI',NULL,279,68948000,'AP',NULL,1,'2006-11-12 16:53:18'),(187,NULL,1,6,'AMAP',NULL,280,68950000,'AP','1600105',1,'2006-11-12 16:53:18'),(188,NULL,1,6,'AMAPARI',NULL,281,68945000,'AP',NULL,1,'2006-11-12 16:53:18'),(189,NULL,1,6,'CALOENE',NULL,287,68960000,'AP','1600204',1,'2006-11-12 16:53:18'),(190,NULL,1,6,'CUTIAS',NULL,294,68973000,'AP','1600212',1,'2006-11-12 16:53:18'),(191,NULL,1,6,'FERREIRA GOMES',NULL,296,68915000,'AP','1600238',1,'2006-11-12 16:53:18'),(192,NULL,1,6,'ITAUBAL',NULL,303,68976000,'AP','1600253',1,'2006-11-12 16:53:18'),(193,NULL,1,6,'LARANJAL DO JARI',NULL,304,68920000,'AP','1600279',1,'2006-11-12 16:53:18'),(194,NULL,1,6,'MACAP',NULL,307,NULL,'AP','1600303',1,'2006-11-12 16:53:18'),(195,NULL,1,6,'MAZAGO',NULL,308,68940000,'AP','1600402',1,'2006-11-12 16:53:18'),(196,NULL,1,6,'OIAPOQUE',NULL,310,68980000,'AP','1600501',1,'2006-11-12 16:53:18'),(197,NULL,1,6,'PORTO GRANDE',NULL,312,68997000,'AP','1600535',1,'2006-11-12 16:53:18'),(198,NULL,1,6,'PRACUBA',NULL,313,68918000,'AP','1600550',1,'2006-11-12 16:53:18'),(199,NULL,1,6,'SANTANA',NULL,316,68925000,'AP','1600600',1,'2006-11-12 16:53:18'),(200,NULL,1,6,'TARTARUGALZINHO',NULL,322,68990000,'AP','1600709',1,'2006-11-12 16:53:18'),(201,NULL,1,6,'VITRIA DO JARI',NULL,324,68924000,'AP','1600808',1,'2006-11-12 16:53:18'),(202,NULL,1,19,'ABARA',NULL,326,46690000,'BA','2900108',1,'2006-11-12 16:53:18'),(203,NULL,1,19,'ABAR',NULL,327,48680000,'BA','2900207',1,'2006-11-12 16:53:18'),(204,NULL,1,19,'ACAJUTIBA',NULL,331,48360000,'BA','2900306',1,'2006-11-12 16:53:18'),(205,NULL,1,19,'ADUSTINA',NULL,335,48435000,'BA','2900355',1,'2006-11-12 16:53:18'),(206,NULL,1,19,'GUA FRIA',NULL,339,48170000,'BA','2900405',1,'2006-11-12 16:53:18'),(207,NULL,1,19,'AIQUARA',NULL,341,45220000,'BA','2900603',1,'2006-11-12 16:53:19'),(208,NULL,1,19,'ALAGOINHAS',NULL,342,NULL,'BA','2900702',1,'2006-11-12 16:53:19'),(209,NULL,1,19,'ALCOBAA',NULL,343,45990000,'BA','2900801',1,'2006-11-12 16:53:19'),(210,NULL,1,19,'ALMADINA',NULL,347,45640000,'BA','2900900',1,'2006-11-12 16:53:19'),(211,NULL,1,19,'AMARGOSA',NULL,351,45300000,'BA','2901007',1,'2006-11-12 16:53:19'),(212,NULL,1,19,'AMLIA RODRIGUES',NULL,352,44230000,'BA','2901106',1,'2006-11-12 16:53:19'),(213,NULL,1,19,'AMRICA DOURADA',NULL,353,44910000,'BA','2901155',1,'2006-11-12 16:53:19'),(214,NULL,1,19,'ANAG',NULL,355,45180000,'BA','2901205',1,'2006-11-12 16:53:19'),(215,NULL,1,19,'ANDARA',NULL,356,46830000,'BA','2901304',1,'2006-11-12 16:53:19'),(216,NULL,1,19,'ANDORINHA',NULL,357,48990000,'BA','2901353',1,'2006-11-12 16:53:19'),(217,NULL,1,19,'ANGICAL',NULL,358,47960000,'BA','2901403',1,'2006-11-12 16:53:19'),(218,NULL,1,19,'ANGUERA',NULL,360,44670000,'BA','2901502',1,'2006-11-12 16:53:19'),(219,NULL,1,19,'ANTAS',NULL,361,48420000,'BA','2901601',1,'2006-11-12 16:53:19'),(220,NULL,1,19,'ANTNIO CARDOSO',NULL,362,44180000,'BA','2901700',1,'2006-11-12 16:53:19'),(221,NULL,1,19,'ANTNIO GONALVES',NULL,363,44780000,'BA','2901809',1,'2006-11-12 16:53:20'),(222,NULL,1,19,'APOR',NULL,364,48350000,'BA','2901908',1,'2006-11-12 16:53:20'),(223,NULL,1,19,'APUAREMA',NULL,365,45355000,'BA','2901957',1,'2006-11-12 16:53:20'),(224,NULL,1,19,'ARAS',NULL,366,48108000,'BA','2902054',1,'2006-11-12 16:53:20'),(225,NULL,1,19,'ARACATU',NULL,367,46130000,'BA','2902005',1,'2006-11-12 16:53:20'),(226,NULL,1,19,'ARACI',NULL,368,48760000,'BA','2902104',1,'2006-11-12 16:53:20'),(227,NULL,1,19,'ARAMARI',NULL,369,48130000,'BA','2902203',1,'2006-11-12 16:53:20'),(228,NULL,1,19,'ARATACA',NULL,371,45695000,'BA','2902252',1,'2006-11-12 16:53:20'),(229,NULL,1,19,'ARATUPE',NULL,372,44490000,'BA','2902302',1,'2006-11-12 16:53:20'),(230,NULL,1,19,'AURELINO LEAL',NULL,379,45675000,'BA','2902401',1,'2006-11-12 16:53:20'),(231,NULL,1,19,'BAIANPOLIS',NULL,380,47830000,'BA','2902500',1,'2006-11-12 16:53:20'),(232,NULL,1,19,'BAIXA GRANDE',NULL,382,44620000,'BA','2902609',1,'2006-11-12 16:53:20'),(233,NULL,1,19,'BANZA',NULL,391,48405000,'BA','2902658',1,'2006-11-12 16:53:20'),(234,NULL,1,19,'BARRA',NULL,394,47100000,'BA','2902708',1,'2006-11-12 16:53:20'),(235,NULL,1,19,'BARRA DA ESTIVA',NULL,395,46650000,'BA','2902807',1,'2006-11-12 16:53:20'),(236,NULL,1,19,'BARRA DO CHOA',NULL,396,45120000,'BA','2902906',1,'2006-11-12 16:53:20'),(237,NULL,1,19,'BARRA DO MENDES',NULL,398,44990000,'BA','2903003',1,'2006-11-12 16:53:20'),(238,NULL,1,19,'BARRA DO ROCHA',NULL,400,45560000,'BA','2903102',1,'2006-11-12 16:53:21'),(239,NULL,1,19,'BARREIRAS',NULL,403,NULL,'BA','2903201',1,'2006-11-12 16:53:21'),(240,NULL,1,19,'BARRO ALTO',NULL,404,44895000,'BA','2903235',1,'2006-11-12 16:53:21'),(241,NULL,1,19,'GOVERNADOR LOMANTO JUNIOR',NULL,405,45625000,'BA',NULL,1,'2006-11-12 16:53:21'),(242,NULL,1,19,'BARROCAS',NULL,407,48705000,'BA','2903276',1,'2006-11-12 16:53:21'),(243,NULL,1,19,'BELMONTE',NULL,413,45800000,'BA','2903409',1,'2006-11-12 16:53:21'),(244,NULL,1,19,'BELO CAMPO',NULL,414,45160000,'BA','2903508',1,'2006-11-12 16:53:21'),(245,NULL,1,19,'BIRITINGA',NULL,419,48780000,'BA','2903607',1,'2006-11-12 16:53:21'),(246,NULL,1,19,'BOA NOVA',NULL,421,45250000,'BA','2903706',1,'2006-11-12 16:53:21'),(247,NULL,1,19,'BOA VISTA DO TUPIM',NULL,424,46850000,'BA','2903805',1,'2006-11-12 16:53:21'),(248,NULL,1,19,'BOM JESUS DA LAPA',NULL,427,47600000,'BA','2903904',1,'2006-11-12 16:53:21'),(249,NULL,1,19,'BOM JESUS DA SERRA',NULL,428,45263000,'BA','2903953',1,'2006-11-12 16:53:21'),(250,NULL,1,19,'BONINAL',NULL,431,46740000,'BA','2904001',1,'2006-11-12 16:53:21'),(251,NULL,1,19,'BONITO',NULL,432,46820000,'BA','2904050',1,'2006-11-12 16:53:21'),(252,NULL,1,19,'BOQUIRA',NULL,433,46530000,'BA','2904100',1,'2006-11-12 16:53:21'),(253,NULL,1,19,'BOTUPOR',NULL,434,46570000,'BA','2904209',1,'2006-11-12 16:53:21'),(254,NULL,1,19,'BREJES',NULL,440,45325000,'BA','2904308',1,'2006-11-12 16:53:21'),(255,NULL,1,19,'BREJOLNDIA',NULL,441,47750000,'BA','2904407',1,'2006-11-12 16:53:21'),(256,NULL,1,19,'BROTAS DE MACABAS',NULL,442,47560000,'BA','2904506',1,'2006-11-12 16:53:21'),(257,NULL,1,19,'BRUMADO',NULL,443,46100000,'BA','2904605',1,'2006-11-12 16:53:22'),(258,NULL,1,19,'BUERAREMA',NULL,445,45615000,'BA','2904704',1,'2006-11-12 16:53:22'),(259,NULL,1,19,'BURITIRAMA',NULL,450,47120000,'BA','2904753',1,'2006-11-12 16:53:22'),(260,NULL,1,19,'CAATIBA',NULL,451,45130000,'BA','2904803',1,'2006-11-12 16:53:22'),(261,NULL,1,19,'CABACEIRAS DO PARAGUAU',NULL,452,44345000,'BA','2904852',1,'2006-11-12 16:53:22'),(262,NULL,1,19,'CACHOEIRA',NULL,455,44300000,'BA','2904902',1,'2006-11-12 16:53:22'),(263,NULL,1,19,'CACUL',NULL,457,46300000,'BA','2905008',1,'2006-11-12 16:53:22'),(264,NULL,1,19,'CAM',NULL,458,44730000,'BA','2905107',1,'2006-11-12 16:53:22'),(265,NULL,1,19,'CAETANOS',NULL,459,45265000,'BA','2905156',1,'2006-11-12 16:53:22'),(266,NULL,1,19,'CAETIT',NULL,461,46400000,'BA','2905206',1,'2006-11-12 16:53:22'),(267,NULL,1,19,'CAFARNAUM',NULL,462,44880000,'BA','2905305',1,'2006-11-12 16:53:22'),(268,NULL,1,19,'CAIRU',NULL,465,45420000,'BA','2905404',1,'2006-11-12 16:53:22'),(269,NULL,1,19,'CALDEIRO GRANDE',NULL,470,44750000,'BA','2905503',1,'2006-11-12 16:53:22'),(270,NULL,1,19,'CAMACAN',NULL,472,45880000,'BA','2905602',1,'2006-11-12 16:53:22'),(271,NULL,1,19,'CAMAARI',NULL,473,NULL,'BA','2905701',1,'2006-11-12 16:53:22'),(272,NULL,1,19,'CAMAMU',NULL,474,45445000,'BA','2905800',1,'2006-11-12 16:53:22'),(273,NULL,1,19,'CAMPO ALEGRE DE LOURDES',NULL,478,47220000,'BA','2905909',1,'2006-11-12 16:53:22'),(274,NULL,1,19,'CAMPO FORMOSO',NULL,479,44790000,'BA','2906006',1,'2006-11-12 16:53:22'),(275,NULL,1,19,'CANPOLIS',NULL,483,47730000,'BA','2906105',1,'2006-11-12 16:53:22'),(276,NULL,1,19,'CANARANA',NULL,484,44890000,'BA','2906204',1,'2006-11-12 16:53:22'),(277,NULL,1,19,'CANAVIEIRAS',NULL,486,45860000,'BA','2906303',1,'2006-11-12 16:53:22'),(278,NULL,1,19,'CANDEAL',NULL,488,48710000,'BA','2906402',1,'2006-11-12 16:53:23'),(279,NULL,1,19,'CANDEIAS',NULL,489,NULL,'BA','2906501',1,'2006-11-12 16:53:23'),(280,NULL,1,19,'CANDIBA',NULL,490,46380000,'BA','2906600',1,'2006-11-12 16:53:23'),(281,NULL,1,19,'CNDIDO SALES',NULL,491,45157000,'BA','2906709',1,'2006-11-12 16:53:23'),(282,NULL,1,19,'CANSANO',NULL,493,48840000,'BA','2906808',1,'2006-11-12 16:53:23'),(283,NULL,1,19,'CANUDOS',NULL,495,48520000,'BA','2906824',1,'2006-11-12 16:53:23'),(284,NULL,1,19,'CAPELA DO ALTO ALEGRE',NULL,498,44645000,'BA','2906857',1,'2006-11-12 16:53:23'),(285,NULL,1,19,'CAPIM GROSSO',NULL,499,44695000,'BA','2906873',1,'2006-11-12 16:53:23'),(286,NULL,1,19,'CARABAS',NULL,501,45177000,'BA','2906899',1,'2006-11-12 16:53:23'),(287,NULL,1,19,'CARAVELAS',NULL,505,45900000,'BA','2906907',1,'2006-11-12 16:53:23'),(288,NULL,1,19,'CARDEAL DA SILVA',NULL,506,48390000,'BA','2907004',1,'2006-11-12 16:53:23'),(289,NULL,1,19,'CARINHANHA',NULL,507,46445000,'BA','2907103',1,'2006-11-12 16:53:23'),(290,NULL,1,19,'CASA NOVA',NULL,511,47300000,'BA','2907202',1,'2006-11-12 16:53:23'),(291,NULL,1,19,'CASTRO ALVES',NULL,513,44500000,'BA','2907301',1,'2006-11-12 16:53:23'),(292,NULL,1,19,'CATOLNDIA',NULL,516,47815000,'BA','2907400',1,'2006-11-12 16:53:23'),(293,NULL,1,19,'CATU',NULL,519,48110000,'BA','2907509',1,'2006-11-12 16:53:23'),(294,NULL,1,19,'CATURAMA',NULL,521,46575000,'BA','2907558',1,'2006-11-12 16:53:23'),(295,NULL,1,19,'CENTRAL',NULL,523,44940000,'BA','2907608',1,'2006-11-12 16:53:23'),(296,NULL,1,19,'CHORROCH',NULL,525,48660000,'BA','2907707',1,'2006-11-12 16:53:23'),(297,NULL,1,19,'CCERO DANTAS',NULL,526,48410000,'BA','2907806',1,'2006-11-12 16:53:23'),(298,NULL,1,19,'CIP',NULL,528,48450000,'BA','2907905',1,'2006-11-12 16:53:23'),(299,NULL,1,19,'COARACI',NULL,529,45638000,'BA','2908002',1,'2006-11-12 16:53:24'),(300,NULL,1,19,'COCOS',NULL,530,47680000,'BA','2908101',1,'2006-11-12 16:53:24'),(301,NULL,1,19,'CONCEIO DA FEIRA',NULL,533,44320000,'BA','2908200',1,'2006-11-12 16:53:24'),(302,NULL,1,19,'CONCEIO DO ALMEIDA',NULL,534,44540000,'BA','2908309',1,'2006-11-12 16:53:24'),(303,NULL,1,19,'CONCEIO DO COIT',NULL,535,48730000,'BA','2908408',1,'2006-11-12 16:53:24'),(304,NULL,1,19,'CONCEIO DO JACUPE',NULL,536,44245000,'BA','2908507',1,'2006-11-12 16:53:24'),(305,NULL,1,19,'CONDE',NULL,537,48300000,'BA','2908606',1,'2006-11-12 16:53:24'),(306,NULL,1,19,'CONDEBA',NULL,538,46200000,'BA','2908705',1,'2006-11-12 16:53:24'),(307,NULL,1,19,'CONTENDAS DO SINCOR',NULL,539,46620000,'BA','2908804',1,'2006-11-12 16:53:24'),(308,NULL,1,19,'CORAO DE MARIA',NULL,543,44250000,'BA','2908903',1,'2006-11-12 16:53:24'),(309,NULL,1,19,'CORDEIROS',NULL,544,46280000,'BA','2909000',1,'2006-11-12 16:53:24'),(310,NULL,1,19,'CORIBE',NULL,545,47690000,'BA','2909109',1,'2006-11-12 16:53:24'),(311,NULL,1,19,'CORONEL JOO S',NULL,546,48590000,'BA','2909208',1,'2006-11-12 16:53:24'),(312,NULL,1,19,'CORRENTINA',NULL,547,47650000,'BA','2909307',1,'2006-11-12 16:53:24'),(313,NULL,1,19,'COTEGIPE',NULL,549,47900000,'BA','2909406',1,'2006-11-12 16:53:24'),(314,NULL,1,19,'CRAVOLNDIA',NULL,551,45330000,'BA','2909505',1,'2006-11-12 16:53:24'),(315,NULL,1,19,'CRISPOLIS',NULL,552,48480000,'BA','2909604',1,'2006-11-12 16:53:24'),(316,NULL,1,19,'CRISTPOLIS',NULL,554,47950000,'BA','2909703',1,'2006-11-12 16:53:24'),(317,NULL,1,19,'CRUZ DAS ALMAS',NULL,556,44380000,'BA','2909802',1,'2006-11-12 16:53:24'),(318,NULL,1,19,'CURA',NULL,559,48930000,'BA','2909901',1,'2006-11-12 16:53:24'),(319,NULL,1,19,'DRIO MEIRA',NULL,561,45590000,'BA','2910008',1,'2006-11-12 16:53:25'),(320,NULL,1,19,'DIAS D\'VILA',NULL,565,42850000,'BA',NULL,1,'2006-11-12 16:53:25'),(321,NULL,1,19,'DOM BASLIO',NULL,567,46165000,'BA','2910107',1,'2006-11-12 16:53:25'),(322,NULL,1,19,'DOM MACEDO COSTA',NULL,568,44560000,'BA','2910206',1,'2006-11-12 16:53:25'),(323,NULL,1,19,'ELSIO MEDRADO',NULL,571,45305000,'BA','2910305',1,'2006-11-12 16:53:25'),(324,NULL,1,19,'ENCRUZILHADA',NULL,572,45150000,'BA','2910404',1,'2006-11-12 16:53:25'),(325,NULL,1,19,'ENTRE RIOS',NULL,575,48180000,'BA','2910503',1,'2006-11-12 16:53:25'),(326,NULL,1,19,'RICO CARDOSO',NULL,576,46180000,'BA','2900504',1,'2006-11-12 16:53:25'),(327,NULL,1,19,'ESPLANADA',NULL,577,48370000,'BA','2910602',1,'2006-11-12 16:53:25'),(328,NULL,1,19,'EUCLIDES DA CUNHA',NULL,578,48500000,'BA','2910701',1,'2006-11-12 16:53:25'),(329,NULL,1,19,'EUNPOLIS',NULL,579,NULL,'BA','2910727',1,'2006-11-12 16:53:25'),(330,NULL,1,19,'FTIMA',NULL,580,48415000,'BA','2910750',1,'2006-11-12 16:53:25'),(331,NULL,1,19,'FEIRA DA MATA',NULL,581,46446000,'BA','2910776',1,'2006-11-12 16:53:25'),(332,NULL,1,19,'FEIRA DE SANTANA',NULL,582,NULL,'BA','2910800',1,'2006-11-12 16:53:25'),(333,NULL,1,19,'FILADLFIA',NULL,584,44775000,'BA','2910859',1,'2006-11-12 16:53:25'),(334,NULL,1,19,'FIRMINO ALVES',NULL,586,45720000,'BA','2910909',1,'2006-11-12 16:53:25'),(335,NULL,1,19,'FLORESTA AZUL',NULL,587,45740000,'BA','2911006',1,'2006-11-12 16:53:25'),(336,NULL,1,19,'FORMOSA DO RIO PRETO',NULL,588,47990000,'BA','2911105',1,'2006-11-12 16:53:25'),(337,NULL,1,19,'GANDU',NULL,595,45450000,'BA','2911204',1,'2006-11-12 16:53:25'),(338,NULL,1,19,'GAVIO',NULL,596,44650000,'BA','2911253',1,'2006-11-12 16:53:25'),(339,NULL,1,19,'GENTIO DO OURO',NULL,597,47450000,'BA','2911303',1,'2006-11-12 16:53:26'),(340,NULL,1,19,'GLRIA',NULL,599,48610000,'BA','2911402',1,'2006-11-12 16:53:26'),(341,NULL,1,19,'GONGOGI',NULL,600,45540000,'BA','2911501',1,'2006-11-12 16:53:26'),(342,NULL,1,19,'GOVERNADOR MANGABEIRA',NULL,602,44350000,'BA','2911600',1,'2006-11-12 16:53:26'),(343,NULL,1,19,'GUAJERU',NULL,605,46205000,'BA','2911659',1,'2006-11-12 16:53:26'),(344,NULL,1,19,'GUANAMBI',NULL,606,46430000,'BA','2911709',1,'2006-11-12 16:53:26'),(345,NULL,1,19,'GUARATINGA',NULL,609,45840000,'BA','2911808',1,'2006-11-12 16:53:26'),(346,NULL,1,19,'HELIPOLIS',NULL,614,48445000,'BA','2911857',1,'2006-11-12 16:53:26'),(347,NULL,1,19,'IAU',NULL,618,46860000,'BA','2911907',1,'2006-11-12 16:53:26'),(348,NULL,1,19,'IBIASSUC',NULL,623,46390000,'BA','2912004',1,'2006-11-12 16:53:26'),(349,NULL,1,19,'IBICARA',NULL,624,45745000,'BA','2912103',1,'2006-11-12 16:53:26'),(350,NULL,1,19,'IBICOARA',NULL,625,46760000,'BA','2912202',1,'2006-11-12 16:53:26'),(351,NULL,1,19,'IBICU',NULL,626,45290000,'BA','2912301',1,'2006-11-12 16:53:26'),(352,NULL,1,19,'IBIPEBA',NULL,627,44970000,'BA','2912400',1,'2006-11-12 16:53:26'),(353,NULL,1,19,'IBIPITANGA',NULL,629,46540000,'BA','2912509',1,'2006-11-12 16:53:26'),(354,NULL,1,19,'IBIQUERA',NULL,630,46840000,'BA','2912608',1,'2006-11-12 16:53:26'),(355,NULL,1,19,'IBIRAPITANGA',NULL,634,45500000,'BA','2912707',1,'2006-11-12 16:53:26'),(356,NULL,1,19,'IBIRAPU',NULL,635,45940000,'BA','2912806',1,'2006-11-12 16:53:26'),(357,NULL,1,19,'IBIRATAIA',NULL,636,45580000,'BA','2912905',1,'2006-11-12 16:53:26'),(358,NULL,1,19,'IBITIARA',NULL,637,46700000,'BA','2913002',1,'2006-11-12 16:53:26'),(359,NULL,1,19,'IBITIT',NULL,640,44960000,'BA','2913101',1,'2006-11-12 16:53:27'),(360,NULL,1,19,'IBOTIRAMA',NULL,644,47520000,'BA','2913200',1,'2006-11-12 16:53:27'),(361,NULL,1,19,'ICHU',NULL,645,48725000,'BA','2913309',1,'2006-11-12 16:53:27'),(362,NULL,1,19,'IGAPOR',NULL,647,46490000,'BA','2913408',1,'2006-11-12 16:53:27'),(363,NULL,1,19,'IGRAPINA',NULL,651,45443000,'BA','2913457',1,'2006-11-12 16:53:27'),(364,NULL,1,19,'IGUA',NULL,653,45280000,'BA','2913507',1,'2006-11-12 16:53:27'),(365,NULL,1,19,'ILHUS',NULL,659,NULL,'BA','2913606',1,'2006-11-12 16:53:27'),(366,NULL,1,19,'INHAMBUPE',NULL,662,48490000,'BA','2913705',1,'2006-11-12 16:53:27'),(367,NULL,1,19,'IPECAET',NULL,667,44680000,'BA','2913804',1,'2006-11-12 16:53:27'),(368,NULL,1,19,'IPIA',NULL,668,45570000,'BA','2913903',1,'2006-11-12 16:53:27'),(369,NULL,1,19,'IPIR',NULL,669,44600000,'BA','2914000',1,'2006-11-12 16:53:27'),(370,NULL,1,19,'IPUPIARA',NULL,672,47590000,'BA','2914109',1,'2006-11-12 16:53:27'),(371,NULL,1,19,'IRAJUBA',NULL,673,45370000,'BA','2914208',1,'2006-11-12 16:53:27'),(372,NULL,1,19,'IRAMAIA',NULL,674,46770000,'BA','2914307',1,'2006-11-12 16:53:27'),(373,NULL,1,19,'IRAQUARA',NULL,676,46980000,'BA','2914406',1,'2006-11-12 16:53:27'),(374,NULL,1,19,'IRAR',NULL,677,44255000,'BA','2914505',1,'2006-11-12 16:53:27'),(375,NULL,1,19,'IREC',NULL,678,44900000,'BA','2914604',1,'2006-11-12 16:53:27'),(376,NULL,1,19,'ITABELA',NULL,681,45848000,'BA','2914653',1,'2006-11-12 16:53:27'),(377,NULL,1,19,'ITABERABA',NULL,682,46880000,'BA','2914703',1,'2006-11-12 16:53:27'),(378,NULL,1,19,'ITABUNA',NULL,683,NULL,'BA','2914802',1,'2006-11-12 16:53:27'),(379,NULL,1,19,'ITACAR',NULL,684,45530000,'BA','2914901',1,'2006-11-12 16:53:27'),(380,NULL,1,19,'ITAET',NULL,688,46790000,'BA','2915007',1,'2006-11-12 16:53:27'),(381,NULL,1,19,'ITAGI',NULL,689,45230000,'BA','2915106',1,'2006-11-12 16:53:28'),(382,NULL,1,19,'ITAGIB',NULL,690,45585000,'BA','2915205',1,'2006-11-12 16:53:28'),(383,NULL,1,19,'ITAGIMIRIM',NULL,691,45850000,'BA','2915304',1,'2006-11-12 16:53:28'),(384,NULL,1,19,'ITAGUAU DA BAHIA',NULL,692,47440000,'BA','2915353',1,'2006-11-12 16:53:28'),(385,NULL,1,19,'ITAJU DO COLNIA',NULL,698,45730000,'BA','2915403',1,'2006-11-12 16:53:28'),(386,NULL,1,19,'ITAJUPE',NULL,700,45630000,'BA','2915502',1,'2006-11-12 16:53:28'),(387,NULL,1,19,'ITAMARAJU',NULL,702,45836000,'BA','2915601',1,'2006-11-12 16:53:28'),(388,NULL,1,19,'ITAMARI',NULL,703,45455000,'BA','2915700',1,'2006-11-12 16:53:28'),(389,NULL,1,19,'ITAMB',NULL,704,45140000,'BA','2915809',1,'2006-11-12 16:53:28'),(390,NULL,1,19,'ITANAGRA',NULL,708,48290000,'BA','2915908',1,'2006-11-12 16:53:28'),(391,NULL,1,19,'ITANHM',NULL,709,45970000,'BA','2916005',1,'2006-11-12 16:53:28'),(392,NULL,1,19,'ITAPARICA',NULL,711,44460000,'BA','2916104',1,'2006-11-12 16:53:28'),(393,NULL,1,19,'ITAP',NULL,712,45750000,'BA','2916203',1,'2006-11-12 16:53:28'),(394,NULL,1,19,'ITAPEBI',NULL,713,45855000,'BA','2916302',1,'2006-11-12 16:53:28'),(395,NULL,1,19,'ITAPETINGA',NULL,715,45700000,'BA','2916401',1,'2006-11-12 16:53:28'),(396,NULL,1,19,'ITAPICURU',NULL,716,48475000,'BA','2916500',1,'2006-11-12 16:53:28'),(397,NULL,1,19,'ITAPITANGA',NULL,718,45645000,'BA','2916609',1,'2006-11-12 16:53:28'),(398,NULL,1,19,'ITAQUARA',NULL,721,45340000,'BA','2916708',1,'2006-11-12 16:53:28'),(399,NULL,1,19,'ITARANTIM',NULL,723,45780000,'BA','2916807',1,'2006-11-12 16:53:28'),(400,NULL,1,19,'ITATIM',NULL,725,46875000,'BA','2916856',1,'2006-11-12 16:53:28'),(401,NULL,1,19,'ITIRUU',NULL,727,45350000,'BA','2916906',1,'2006-11-12 16:53:28'),(402,NULL,1,19,'ITIBA',NULL,728,48850000,'BA','2917003',1,'2006-11-12 16:53:28'),(403,NULL,1,19,'ITOROR',NULL,729,45710000,'BA','2917102',1,'2006-11-12 16:53:29'),(404,NULL,1,19,'ITUAU',NULL,730,46640000,'BA','2917201',1,'2006-11-12 16:53:29'),(405,NULL,1,19,'ITUBER',NULL,731,45435000,'BA','2917300',1,'2006-11-12 16:53:29'),(406,NULL,1,19,'IUIU',NULL,733,46438000,'BA','2917334',1,'2006-11-12 16:53:29'),(407,NULL,1,19,'JABORANDI',NULL,734,47655000,'BA','2917359',1,'2006-11-12 16:53:29'),(408,NULL,1,19,'JACARACI',NULL,735,46310000,'BA','2917409',1,'2006-11-12 16:53:29'),(409,NULL,1,19,'JACOBINA',NULL,736,44700000,'BA','2917508',1,'2006-11-12 16:53:29'),(410,NULL,1,19,'JAGUAQUARA',NULL,740,45345000,'BA','2917607',1,'2006-11-12 16:53:29'),(411,NULL,1,19,'JAGUARARI',NULL,742,48960000,'BA','2917706',1,'2006-11-12 16:53:29'),(412,NULL,1,19,'JAGUARIPE',NULL,743,44480000,'BA','2917805',1,'2006-11-12 16:53:29'),(413,NULL,1,19,'JANDARA',NULL,745,48310000,'BA','2917904',1,'2006-11-12 16:53:29'),(414,NULL,1,19,'JEQUI',NULL,749,NULL,'BA','2918001',1,'2006-11-12 16:53:29'),(415,NULL,1,19,'JEQUIRI',NULL,750,45470000,'BA',NULL,1,'2006-11-12 16:53:29'),(416,NULL,1,19,'JEREMOABO',NULL,751,48540000,'BA','2918100',1,'2006-11-12 16:53:29'),(417,NULL,1,19,'JITANA',NULL,753,45225000,'BA','2918308',1,'2006-11-12 16:53:29'),(418,NULL,1,19,'JOO DOURADO',NULL,756,44920000,'BA','2918357',1,'2006-11-12 16:53:29'),(419,NULL,1,19,'JUAZEIRO',NULL,759,NULL,'BA','2918407',1,'2006-11-12 16:53:29'),(420,NULL,1,19,'JUCURUU',NULL,760,45834000,'BA','2918456',1,'2006-11-12 16:53:29'),(421,NULL,1,19,'JUSSARA',NULL,766,44925000,'BA','2918506',1,'2006-11-12 16:53:29'),(422,NULL,1,19,'JUSSARI',NULL,767,45610000,'BA','2918555',1,'2006-11-12 16:53:29'),(423,NULL,1,19,'JUSSIAPE',NULL,768,46670000,'BA','2918605',1,'2006-11-12 16:53:29'),(424,NULL,1,19,'LAFAIETE COUTINHO',NULL,770,45215000,'BA','2918704',1,'2006-11-12 16:53:29'),(425,NULL,1,19,'LAGOA REAL',NULL,778,46425000,'BA','2918753',1,'2006-11-12 16:53:30'),(426,NULL,1,19,'LAJE',NULL,779,45490000,'BA','2918803',1,'2006-11-12 16:53:30'),(427,NULL,1,19,'LAJEDO',NULL,781,45950000,'BA','2918902',1,'2006-11-12 16:53:30'),(428,NULL,1,19,'LAJEDINHO',NULL,782,46825000,'BA','2919009',1,'2006-11-12 16:53:30'),(429,NULL,1,19,'LAJEDO DO TABOCAL',NULL,784,45365000,'BA','2919058',1,'2006-11-12 16:53:30'),(430,NULL,1,19,'LAMARO',NULL,785,48720000,'BA','2919108',1,'2006-11-12 16:53:30'),(431,NULL,1,19,'LAPO',NULL,787,44905000,'BA','2919157',1,'2006-11-12 16:53:30'),(432,NULL,1,19,'LAURO DE FREITAS',NULL,789,42700000,'BA','2919207',1,'2006-11-12 16:53:30'),(433,NULL,1,19,'LENIS',NULL,790,46960000,'BA','2919306',1,'2006-11-12 16:53:30'),(434,NULL,1,19,'LICNIO DE ALMEIDA',NULL,791,46330000,'BA','2919405',1,'2006-11-12 16:53:30'),(435,NULL,1,19,'LIVRAMENTO DE NOSSA SENHORA',NULL,793,46140000,'BA','2919504',1,'2006-11-12 16:53:30'),(436,NULL,1,19,'MACAJUBA',NULL,797,46805000,'BA','2919603',1,'2006-11-12 16:53:30'),(437,NULL,1,19,'MACARANI',NULL,798,45760000,'BA','2919702',1,'2006-11-12 16:53:30'),(438,NULL,1,19,'MACABAS',NULL,799,46500000,'BA','2919801',1,'2006-11-12 16:53:30'),(439,NULL,1,19,'MACURUR',NULL,800,48650000,'BA','2919900',1,'2006-11-12 16:53:30'),(440,NULL,1,19,'MADRE DE DEUS',NULL,801,42600000,'BA','2919926',1,'2006-11-12 16:53:30'),(441,NULL,1,19,'MAETINGA',NULL,802,46255000,'BA','2919959',1,'2006-11-12 16:53:30'),(442,NULL,1,19,'MAIQUINIQUE',NULL,803,45770000,'BA','2920007',1,'2006-11-12 16:53:30'),(443,NULL,1,19,'MAIRI',NULL,804,44630000,'BA','2920106',1,'2006-11-12 16:53:30'),(444,NULL,1,19,'MALHADA',NULL,805,46440000,'BA','2920205',1,'2006-11-12 16:53:31'),(445,NULL,1,19,'MALHADA DE PEDRAS',NULL,806,46110000,'BA','2920304',1,'2006-11-12 16:53:31'),(446,NULL,1,19,'MANOEL VITORINO',NULL,810,45240000,'BA','2920403',1,'2006-11-12 16:53:31'),(447,NULL,1,19,'MANSIDO',NULL,811,47160000,'BA','2920452',1,'2006-11-12 16:53:31'),(448,NULL,1,19,'MARACS',NULL,814,45360000,'BA','2920502',1,'2006-11-12 16:53:31'),(449,NULL,1,19,'MARAGOGIPE',NULL,815,44420000,'BA','2920601',1,'2006-11-12 16:53:31'),(450,NULL,1,19,'MARA',NULL,817,45520000,'BA','2920700',1,'2006-11-12 16:53:31'),(451,NULL,1,19,'MARCIONLIO SOUZA',NULL,818,46780000,'BA','2920809',1,'2006-11-12 16:53:31'),(452,NULL,1,19,'MASCOTE',NULL,823,45870000,'BA','2920908',1,'2006-11-12 16:53:31'),(453,NULL,1,19,'MATA DE SO JOO',NULL,827,48280000,'BA','2921005',1,'2006-11-12 16:53:31'),(454,NULL,1,19,'MATINA',NULL,829,46480000,'BA','2921054',1,'2006-11-12 16:53:31'),(455,NULL,1,19,'MEDEIROS NETO',NULL,831,45960000,'BA','2921104',1,'2006-11-12 16:53:31'),(456,NULL,1,19,'MIGUEL CALMON',NULL,832,44720000,'BA','2921203',1,'2006-11-12 16:53:31'),(457,NULL,1,19,'MILAGRES',NULL,833,45315000,'BA','2921302',1,'2006-11-12 16:53:31'),(458,NULL,1,19,'LUS EDUARDO MAGALHES',NULL,834,47850000,'BA','2919553',1,'2006-11-12 16:53:31'),(459,NULL,1,19,'MIRANGABA',NULL,839,44745000,'BA','2921401',1,'2006-11-12 16:53:31'),(460,NULL,1,19,'MIRANTE',NULL,840,45255000,'BA','2921450',1,'2006-11-12 16:53:31'),(461,NULL,1,19,'MONTE SANTO',NULL,846,48800000,'BA','2921500',1,'2006-11-12 16:53:31'),(462,NULL,1,19,'MORPAR',NULL,847,47580000,'BA','2921609',1,'2006-11-12 16:53:31'),(463,NULL,1,19,'MORRO DO CHAPU',NULL,851,44850000,'BA','2921708',1,'2006-11-12 16:53:31'),(464,NULL,1,19,'MORTUGABA',NULL,852,46290000,'BA','2921807',1,'2006-11-12 16:53:31'),(465,NULL,1,19,'MUCUG',NULL,853,46750000,'BA','2921906',1,'2006-11-12 16:53:32'),(466,NULL,1,19,'MUCURI',NULL,854,45930000,'BA','2922003',1,'2006-11-12 16:53:32'),(467,NULL,1,19,'MULUNGU DO MORRO',NULL,855,44885000,'BA','2922052',1,'2006-11-12 16:53:32'),(468,NULL,1,19,'MUNDO NOVO',NULL,856,44800000,'BA','2922102',1,'2006-11-12 16:53:32'),(469,NULL,1,19,'MUNIZ FERREIRA',NULL,857,44575000,'BA','2922201',1,'2006-11-12 16:53:32'),(470,NULL,1,19,'MUQUM DE SO FRANCISCO',NULL,858,47115000,'BA','2922250',1,'2006-11-12 16:53:32'),(471,NULL,1,19,'MURITIBA',NULL,859,44340000,'BA','2922300',1,'2006-11-12 16:53:32'),(472,NULL,1,19,'MUTUPE',NULL,861,45480000,'BA','2922409',1,'2006-11-12 16:53:32'),(473,NULL,1,19,'NAZAR',NULL,864,44400000,'BA','2922508',1,'2006-11-12 16:53:32'),(474,NULL,1,19,'NILO PEANHA',NULL,865,45440000,'BA','2922607',1,'2006-11-12 16:53:32'),(475,NULL,1,19,'NORDESTINA',NULL,866,48870000,'BA','2922656',1,'2006-11-12 16:53:32'),(476,NULL,1,19,'NOVA CANA',NULL,869,45270000,'BA','2922706',1,'2006-11-12 16:53:32'),(477,NULL,1,19,'NOVA FTIMA',NULL,870,44642000,'BA','2922730',1,'2006-11-12 16:53:32'),(478,NULL,1,19,'NOVA IBI',NULL,871,45452000,'BA','2922755',1,'2006-11-12 16:53:32'),(479,NULL,1,19,'NOVA ITARAN',NULL,873,45390000,'BA','2922805',1,'2006-11-12 16:53:32'),(480,NULL,1,19,'NOVA REDENO',NULL,875,46835000,'BA','2922854',1,'2006-11-12 16:53:32'),(481,NULL,1,19,'NOVA SOURE',NULL,876,48460000,'BA','2922904',1,'2006-11-12 16:53:32'),(482,NULL,1,19,'NOVA VIOSA',NULL,877,45920000,'BA','2923001',1,'2006-11-12 16:53:32'),(483,NULL,1,19,'NOVO HORIZONTE',NULL,879,46730000,'BA','2923035',1,'2006-11-12 16:53:32'),(484,NULL,1,19,'NOVO TRIUNFO',NULL,880,48455000,'BA','2923050',1,'2006-11-12 16:53:32'),(485,NULL,1,19,'OLINDINA',NULL,885,48470000,'BA','2923100',1,'2006-11-12 16:53:32'),(486,NULL,1,19,'OLIVEIRA DOS BREJINHOS',NULL,886,47530000,'BA','2923209',1,'2006-11-12 16:53:32'),(487,NULL,1,19,'OURIANGAS',NULL,891,48150000,'BA','2923308',1,'2006-11-12 16:53:33'),(488,NULL,1,19,'OUROLNDIA',NULL,893,44718000,'BA','2923357',1,'2006-11-12 16:53:33'),(489,NULL,1,19,'PALMAS DE MONTE ALTO',NULL,898,46460000,'BA','2923407',1,'2006-11-12 16:53:33'),(490,NULL,1,19,'PALMEIRAS',NULL,899,46930000,'BA','2923506',1,'2006-11-12 16:53:33'),(491,NULL,1,19,'PARAMIRIM',NULL,901,46190000,'BA','2923605',1,'2006-11-12 16:53:33'),(492,NULL,1,19,'PARATINGA',NULL,903,47500000,'BA','2923704',1,'2006-11-12 16:53:33'),(493,NULL,1,19,'PARIPIRANGA',NULL,904,48430000,'BA','2923803',1,'2006-11-12 16:53:33'),(494,NULL,1,19,'PAU BRASIL',NULL,908,45890000,'BA','2923902',1,'2006-11-12 16:53:33'),(495,NULL,1,19,'PAULO AFONSO',NULL,909,NULL,'BA','2924009',1,'2006-11-12 16:53:33'),(496,NULL,1,19,'P DE SERRA',NULL,910,44655000,'BA','2924058',1,'2006-11-12 16:53:33'),(497,NULL,1,19,'PEDRO',NULL,911,48140000,'BA','2924108',1,'2006-11-12 16:53:33'),(498,NULL,1,19,'PEDRO ALEXANDRE',NULL,913,48580000,'BA','2924207',1,'2006-11-12 16:53:33'),(499,NULL,1,19,'PIAT',NULL,917,46765000,'BA','2924306',1,'2006-11-12 16:53:33'),(500,NULL,1,19,'PILO ARCADO',NULL,919,47240000,'BA','2924405',1,'2006-11-12 16:53:33'),(501,NULL,1,19,'PINDA',NULL,921,46360000,'BA','2924504',1,'2006-11-12 16:53:33'),(502,NULL,1,19,'PINDOBAU',NULL,922,44770000,'BA','2924603',1,'2006-11-12 16:53:33'),(503,NULL,1,19,'PINTADAS',NULL,924,44610000,'BA','2924652',1,'2006-11-12 16:53:33'),(504,NULL,1,19,'PIRA DO NORTE',NULL,926,45436000,'BA','2924678',1,'2006-11-12 16:53:33'),(505,NULL,1,19,'PIRIP',NULL,930,46270000,'BA','2924702',1,'2006-11-12 16:53:33'),(506,NULL,1,19,'PIRITIBA',NULL,931,44830000,'BA','2924801',1,'2006-11-12 16:53:33'),(507,NULL,1,19,'PLANALTINO',NULL,933,45375000,'BA','2924900',1,'2006-11-12 16:53:33'),(508,NULL,1,19,'PLANALTO',NULL,934,45190000,'BA','2925006',1,'2006-11-12 16:53:33'),(509,NULL,1,19,'POES',NULL,937,45260000,'BA','2925105',1,'2006-11-12 16:53:33'),(510,NULL,1,19,'POJUCA',NULL,939,48120000,'BA','2925204',1,'2006-11-12 16:53:34'),(511,NULL,1,19,'PONTO NOVO',NULL,942,44755000,'BA','2925253',1,'2006-11-12 16:53:34'),(512,NULL,1,19,'PORTO SEGURO',NULL,944,45810000,'BA','2925303',1,'2006-11-12 16:53:34'),(513,NULL,1,19,'POTIRAGU',NULL,946,45790000,'BA','2925402',1,'2006-11-12 16:53:34'),(514,NULL,1,19,'PRADO',NULL,948,45980000,'BA','2925501',1,'2006-11-12 16:53:34'),(515,NULL,1,19,'PRESIDENTE DUTRA',NULL,949,44930000,'BA','2925600',1,'2006-11-12 16:53:34'),(516,NULL,1,19,'PRESIDENTE JNIO QUADROS',NULL,950,46250000,'BA','2925709',1,'2006-11-12 16:53:34'),(517,NULL,1,19,'PRESIDENTE TANCREDO NEVES',NULL,951,45416000,'BA','2925758',1,'2006-11-12 16:53:34'),(518,NULL,1,19,'QUEIMADAS',NULL,954,48860000,'BA','2925808',1,'2006-11-12 16:53:34'),(519,NULL,1,19,'QUIJINGUE',NULL,955,48830000,'BA','2925907',1,'2006-11-12 16:53:34'),(520,NULL,1,19,'QUIXABEIRA',NULL,957,44713000,'BA','2925931',1,'2006-11-12 16:53:34'),(521,NULL,1,19,'RAFAEL JAMBEIRO',NULL,958,44520000,'BA','2925956',1,'2006-11-12 16:53:34'),(522,NULL,1,19,'REMANSO',NULL,960,47200000,'BA','2926004',1,'2006-11-12 16:53:34'),(523,NULL,1,19,'RETIROLNDIA',NULL,962,48750000,'BA','2926103',1,'2006-11-12 16:53:34'),(524,NULL,1,19,'RIACHO DAS NEVES',NULL,963,47970000,'BA','2926202',1,'2006-11-12 16:53:34'),(525,NULL,1,19,'RIACHO DO JACUPE',NULL,964,44640000,'BA','2926301',1,'2006-11-12 16:53:34'),(526,NULL,1,19,'RIACHO DE SANTANA',NULL,967,46470000,'BA','2926400',1,'2006-11-12 16:53:34'),(527,NULL,1,19,'RIBEIRA DO AMPARO',NULL,969,48440000,'BA','2926509',1,'2006-11-12 16:53:34'),(528,NULL,1,19,'RIBEIRA DO POMBAL',NULL,970,48400000,'BA','2926608',1,'2006-11-12 16:53:34'),(529,NULL,1,19,'RIBEIRO DO LARGO',NULL,971,45155000,'BA','2926657',1,'2006-11-12 16:53:34'),(530,NULL,1,19,'RIO DE CONTAS',NULL,974,46170000,'BA','2926707',1,'2006-11-12 16:53:34'),(531,NULL,1,19,'RIO DO ANTNIO',NULL,975,46220000,'BA','2926806',1,'2006-11-12 16:53:34'),(532,NULL,1,19,'RIO DO PIRES',NULL,978,46550000,'BA','2926905',1,'2006-11-12 16:53:35'),(533,NULL,1,19,'RIO REAL',NULL,980,48330000,'BA','2927002',1,'2006-11-12 16:53:35'),(534,NULL,1,19,'RODELAS',NULL,981,48630000,'BA','2927101',1,'2006-11-12 16:53:35'),(535,NULL,1,19,'RUY BARBOSA',NULL,982,46800000,'BA','2927200',1,'2006-11-12 16:53:35'),(536,NULL,1,19,'SALINAS DA MARGARIDA',NULL,985,44450000,'BA','2927309',1,'2006-11-12 16:53:35'),(537,NULL,1,19,'SALVADOR',NULL,988,NULL,'BA','2927408',1,'2006-11-12 16:53:35'),(538,NULL,1,19,'SANTA BRBARA',NULL,990,44150000,'BA','2927507',1,'2006-11-12 16:53:35'),(539,NULL,1,19,'SANTA BRGIDA',NULL,991,48570000,'BA','2927606',1,'2006-11-12 16:53:35'),(540,NULL,1,19,'SANTA CRUZ CABRLIA',NULL,992,45807000,'BA','2927705',1,'2006-11-12 16:53:35'),(541,NULL,1,19,'SANTA CRUZ DA VITRIA',NULL,993,45725000,'BA','2927804',1,'2006-11-12 16:53:35'),(542,NULL,1,19,'SANTA INS',NULL,994,45320000,'BA','2927903',1,'2006-11-12 16:53:35'),(543,NULL,1,19,'SANTA LUZIA',NULL,995,45865000,'BA','2928059',1,'2006-11-12 16:53:35'),(544,NULL,1,19,'SANTA MARIA DA VITRIA',NULL,996,47640000,'BA','2928109',1,'2006-11-12 16:53:35'),(545,NULL,1,19,'SANTA RITA DE CSSIA',NULL,997,47150000,'BA','2928406',1,'2006-11-12 16:53:35'),(546,NULL,1,19,'SANTA TEREZINHA',NULL,998,44590000,'BA',NULL,1,'2006-11-12 16:53:35'),(547,NULL,1,19,'SANTALUZ',NULL,999,48880000,'BA','2928000',1,'2006-11-12 16:53:35'),(548,NULL,1,19,'SANTANA',NULL,1000,47700000,'BA','2928208',1,'2006-11-12 16:53:35'),(549,NULL,1,19,'SANTANPOLIS',NULL,1002,44260000,'BA','2928307',1,'2006-11-12 16:53:35'),(550,NULL,1,19,'SANTO AMARO',NULL,1004,44200000,'BA','2928604',1,'2006-11-12 16:53:35'),(551,NULL,1,19,'SANTO ANTNIO DE JESUS',NULL,1006,NULL,'BA','2928703',1,'2006-11-12 16:53:35'),(552,NULL,1,19,'SANTO ESTEVO',NULL,1007,44190000,'BA','2928802',1,'2006-11-12 16:53:35'),(553,NULL,1,19,'SO DESIDRIO',NULL,1009,47820000,'BA','2928901',1,'2006-11-12 16:53:35'),(554,NULL,1,19,'SO DOMINGOS',NULL,1010,48895000,'BA','2928950',1,'2006-11-12 16:53:35'),(555,NULL,1,19,'SO FELIPE',NULL,1011,44550000,'BA','2929107',1,'2006-11-12 16:53:36'),(556,NULL,1,19,'SO FLIX',NULL,1012,44360000,'BA','2929008',1,'2006-11-12 16:53:36'),(557,NULL,1,19,'SO FLIX DO CORIBE',NULL,1013,47665000,'BA','2929057',1,'2006-11-12 16:53:36'),(558,NULL,1,19,'SO FRANCISCO DO CONDE',NULL,1014,43900000,'BA','2929206',1,'2006-11-12 16:53:36'),(559,NULL,1,19,'SO GABRIEL',NULL,1015,44915000,'BA','2929255',1,'2006-11-12 16:53:36'),(560,NULL,1,19,'SO GONALO DOS CAMPOS',NULL,1016,44330000,'BA','2929305',1,'2006-11-12 16:53:36'),(561,NULL,1,19,'SO JOS DA VITRIA',NULL,1019,45620000,'BA','2929354',1,'2006-11-12 16:53:36'),(562,NULL,1,19,'SO JOS DO JACUPE',NULL,1021,44698000,'BA','2929370',1,'2006-11-12 16:53:36'),(563,NULL,1,19,'SO MIGUEL DAS MATAS',NULL,1024,44580000,'BA','2929404',1,'2006-11-12 16:53:36'),(564,NULL,1,19,'SO SEBASTIO DO PASSE',NULL,1027,43850000,'BA','2929503',1,'2006-11-12 16:53:36'),(565,NULL,1,19,'SAPEAU',NULL,1029,44530000,'BA','2929602',1,'2006-11-12 16:53:36'),(566,NULL,1,19,'STIRO DIAS',NULL,1030,48485000,'BA','2929701',1,'2006-11-12 16:53:36'),(567,NULL,1,19,'SAUBARA',NULL,1031,44220000,'BA','2929750',1,'2006-11-12 16:53:36'),(568,NULL,1,19,'SADE',NULL,1033,44740000,'BA','2929800',1,'2006-11-12 16:53:36'),(569,NULL,1,19,'SEABRA',NULL,1034,46900000,'BA','2929909',1,'2006-11-12 16:53:36'),(570,NULL,1,19,'SEBASTIO LARANJEIRAS',NULL,1035,46450000,'BA','2930006',1,'2006-11-12 16:53:36'),(571,NULL,1,19,'SENHOR DO BONFIM',NULL,1036,48970000,'BA','2930105',1,'2006-11-12 16:53:36'),(572,NULL,1,19,'SENTO S',NULL,1037,47350000,'BA','2930204',1,'2006-11-12 16:53:36'),(573,NULL,1,19,'SERRA DO RAMALHO',NULL,1040,47630000,'BA','2930154',1,'2006-11-12 16:53:36'),(574,NULL,1,19,'SERRA DOURADA',NULL,1041,47740000,'BA','2930303',1,'2006-11-12 16:53:37'),(575,NULL,1,19,'SERRA PRETA',NULL,1044,44660000,'BA','2930402',1,'2006-11-12 16:53:37'),(576,NULL,1,19,'SERRINHA',NULL,1045,48700000,'BA','2930501',1,'2006-11-12 16:53:37'),(577,NULL,1,19,'SERROLNDIA',NULL,1046,44710000,'BA','2930600',1,'2006-11-12 16:53:37'),(578,NULL,1,19,'SIMES FILHO',NULL,1047,43700000,'BA','2930709',1,'2006-11-12 16:53:37'),(579,NULL,1,19,'STIO DO MATO',NULL,1049,47610000,'BA','2930758',1,'2006-11-12 16:53:37'),(580,NULL,1,19,'STIO DO QUINTO',NULL,1051,48565000,'BA','2930766',1,'2006-11-12 16:53:37'),(581,NULL,1,19,'SOBRADINHO',NULL,1055,48925000,'BA','2930774',1,'2006-11-12 16:53:37'),(582,NULL,1,19,'SOUTO SOARES',NULL,1056,46990000,'BA','2930808',1,'2006-11-12 16:53:37'),(583,NULL,1,19,'TABOCAS DO BREJO VELHO',NULL,1059,47760000,'BA','2930907',1,'2006-11-12 16:53:37'),(584,NULL,1,19,'TANHAU',NULL,1064,46600000,'BA','2931004',1,'2006-11-12 16:53:37'),(585,NULL,1,19,'TANQUE NOVO',NULL,1065,46580000,'BA','2931053',1,'2006-11-12 16:53:37'),(586,NULL,1,19,'TANQUINHO',NULL,1066,44160000,'BA','2931103',1,'2006-11-12 16:53:37'),(587,NULL,1,19,'TAPERO',NULL,1068,45430000,'BA','2931202',1,'2006-11-12 16:53:37'),(588,NULL,1,19,'TAPIRAMUT',NULL,1071,44840000,'BA','2931301',1,'2006-11-12 16:53:37'),(589,NULL,1,19,'TEIXEIRA DE FREITAS',NULL,1078,NULL,'BA','2931350',1,'2006-11-12 16:53:37'),(590,NULL,1,19,'TEODORO SAMPAIO',NULL,1079,44280000,'BA','2931400',1,'2006-11-12 16:53:37'),(591,NULL,1,19,'TEOFILNDIA',NULL,1080,48770000,'BA','2931509',1,'2006-11-12 16:53:37'),(592,NULL,1,19,'TEOLNDIA',NULL,1081,45465000,'BA','2931608',1,'2006-11-12 16:53:37'),(593,NULL,1,19,'TERRA NOVA',NULL,1082,44270000,'BA','2931707',1,'2006-11-12 16:53:37'),(594,NULL,1,19,'TREMEDAL',NULL,1085,45170000,'BA','2931806',1,'2006-11-12 16:53:37'),(595,NULL,1,19,'TUCANO',NULL,1087,48790000,'BA','2931905',1,'2006-11-12 16:53:37'),(596,NULL,1,19,'UAU',NULL,1088,48950000,'BA','2932002',1,'2006-11-12 16:53:38'),(597,NULL,1,19,'UBARA',NULL,1089,45310000,'BA','2932101',1,'2006-11-12 16:53:38'),(598,NULL,1,19,'UBAITABA',NULL,1090,45545000,'BA','2932200',1,'2006-11-12 16:53:38'),(599,NULL,1,19,'UBAT',NULL,1091,45550000,'BA','2932309',1,'2006-11-12 16:53:38'),(600,NULL,1,19,'UIBA',NULL,1094,44950000,'BA','2932408',1,'2006-11-12 16:53:38'),(601,NULL,1,19,'UMBURANAS',NULL,1095,44798000,'BA','2932457',1,'2006-11-12 16:53:38'),(602,NULL,1,19,'UNA',NULL,1097,45690000,'BA','2932507',1,'2006-11-12 16:53:38'),(603,NULL,1,19,'URANDI',NULL,1098,46350000,'BA','2932606',1,'2006-11-12 16:53:38'),(604,NULL,1,19,'URUUCA',NULL,1099,45680000,'BA','2932705',1,'2006-11-12 16:53:38'),(605,NULL,1,19,'UTINGA',NULL,1100,46810000,'BA','2932804',1,'2006-11-12 16:53:38'),(606,NULL,1,19,'VALENA',NULL,1102,45400000,'BA','2932903',1,'2006-11-12 16:53:38'),(607,NULL,1,19,'VALENTE',NULL,1103,48890000,'BA','2933000',1,'2006-11-12 16:53:38'),(608,NULL,1,19,'VRZEA DA ROA',NULL,1104,44635000,'BA','2933059',1,'2006-11-12 16:53:38'),(609,NULL,1,19,'VRZEA DO POO',NULL,1107,44715000,'BA','2933109',1,'2006-11-12 16:53:38'),(610,NULL,1,19,'VRZEA NOVA',NULL,1108,44690000,'BA','2933158',1,'2006-11-12 16:53:38'),(611,NULL,1,19,'VARZEDO',NULL,1110,44565000,'BA','2933174',1,'2006-11-12 16:53:38'),(612,NULL,1,19,'VERA CRUZ',NULL,1113,44470000,'BA','2933208',1,'2006-11-12 16:53:38'),(613,NULL,1,19,'VEREDA',NULL,1114,45955000,'BA','2933257',1,'2006-11-12 16:53:38'),(614,NULL,1,19,'VITRIA DA CONQUISTA',NULL,1116,NULL,'BA','2933307',1,'2006-11-12 16:53:38'),(615,NULL,1,19,'WAGNER',NULL,1118,46970000,'BA','2933406',1,'2006-11-12 16:53:38'),(616,NULL,1,19,'WANDERLEY',NULL,1119,47940000,'BA','2933455',1,'2006-11-12 16:53:38'),(617,NULL,1,19,'WENCESLAU GUIMARES',NULL,1120,45460000,'BA','2933505',1,'2006-11-12 16:53:38'),(618,NULL,1,19,'XIQUE-XIQUE',NULL,1121,47400000,'BA','2933604',1,'2006-11-12 16:53:39'),(619,NULL,1,14,'ABAIARA',NULL,1122,63240000,'CE','2300101',1,'2006-11-12 16:53:39'),(620,NULL,1,14,'ACARAP',NULL,1124,62785000,'CE','2300150',1,'2006-11-12 16:53:39'),(621,NULL,1,14,'ACARA',NULL,1125,62580000,'CE','2300200',1,'2006-11-12 16:53:39'),(622,NULL,1,14,'ACOPIARA',NULL,1126,63560000,'CE','2300309',1,'2006-11-12 16:53:39'),(623,NULL,1,14,'AIUABA',NULL,1131,63575000,'CE','2300408',1,'2006-11-12 16:53:39'),(624,NULL,1,14,'ALCNTARAS',NULL,1134,62120000,'CE','2300507',1,'2006-11-12 16:53:39'),(625,NULL,1,14,'ALTANEIRA',NULL,1137,63195000,'CE','2300606',1,'2006-11-12 16:53:39'),(626,NULL,1,14,'ALTO SANTO',NULL,1138,62970000,'CE','2300705',1,'2006-11-12 16:53:39'),(627,NULL,1,14,'AMONTADA',NULL,1145,62540000,'CE','2300754',1,'2006-11-12 16:53:39'),(628,NULL,1,14,'ANTONINA DO NORTE',NULL,1149,63570000,'CE','2300804',1,'2006-11-12 16:53:39'),(629,NULL,1,14,'APUIARS',NULL,1154,62630000,'CE','2300903',1,'2006-11-12 16:53:39'),(630,NULL,1,14,'AQUIRAZ',NULL,1156,61700000,'CE','2301000',1,'2006-11-12 16:53:39'),(631,NULL,1,14,'ARACATI',NULL,1158,62800000,'CE','2301109',1,'2006-11-12 16:53:39'),(632,NULL,1,14,'ARACOIABA',NULL,1161,62750000,'CE','2301208',1,'2006-11-12 16:53:39'),(633,NULL,1,14,'ARAREND',NULL,1168,62210000,'CE','2301257',1,'2006-11-12 16:53:39'),(634,NULL,1,14,'ARARIPE',NULL,1169,63170000,'CE','2301307',1,'2006-11-12 16:53:39'),(635,NULL,1,14,'ARATUBA',NULL,1173,62762000,'CE','2301406',1,'2006-11-12 16:53:39'),(636,NULL,1,14,'ARNEIROZ',NULL,1176,63670000,'CE','2301505',1,'2006-11-12 16:53:39'),(637,NULL,1,14,'ASSAR',NULL,1180,63140000,'CE','2301604',1,'2006-11-12 16:53:39'),(638,NULL,1,14,'AURORA',NULL,1183,63360000,'CE','2301703',1,'2006-11-12 16:53:39'),(639,NULL,1,14,'BAIXIO',NULL,1185,63320000,'CE','2301802',1,'2006-11-12 16:53:39'),(640,NULL,1,14,'BANABUI',NULL,1187,63960000,'CE','2301851',1,'2006-11-12 16:53:39'),(641,NULL,1,14,'BARBALHA',NULL,1190,63180000,'CE','2301901',1,'2006-11-12 16:53:40'),(642,NULL,1,14,'BARREIRA',NULL,1196,62795000,'CE','2301950',1,'2006-11-12 16:53:40'),(643,NULL,1,14,'BARRO',NULL,1203,63380000,'CE','2302008',1,'2006-11-12 16:53:40'),(644,NULL,1,14,'BARROQUINHA',NULL,1205,62410000,'CE','2302057',1,'2006-11-12 16:53:40'),(645,NULL,1,14,'BATURIT',NULL,1206,62760000,'CE','2302107',1,'2006-11-12 16:53:40'),(646,NULL,1,14,'BEBERIBE',NULL,1208,62840000,'CE','2302206',1,'2006-11-12 16:53:40'),(647,NULL,1,14,'BELA CRUZ',NULL,1209,62570000,'CE','2302305',1,'2006-11-12 16:53:40'),(648,NULL,1,14,'BOA VIAGEM',NULL,1218,63870000,'CE','2302404',1,'2006-11-12 16:53:40'),(649,NULL,1,14,'BREJO SANTO',NULL,1229,63260000,'CE','2302503',1,'2006-11-12 16:53:40'),(650,NULL,1,14,'CAMOCIM',NULL,1247,62400000,'CE','2302602',1,'2006-11-12 16:53:40'),(651,NULL,1,14,'CAMPOS SALES',NULL,1250,63150000,'CE','2302701',1,'2006-11-12 16:53:40'),(652,NULL,1,14,'CANIND',NULL,1256,62700000,'CE','2302800',1,'2006-11-12 16:53:40'),(653,NULL,1,14,'CAPISTRANO',NULL,1260,62748000,'CE','2302909',1,'2006-11-12 16:53:40'),(654,NULL,1,14,'CARIDADE',NULL,1264,62730000,'CE','2303006',1,'2006-11-12 16:53:40'),(655,NULL,1,14,'CARIR',NULL,1265,62184000,'CE','2303105',1,'2006-11-12 16:53:40'),(656,NULL,1,14,'CARIRIAU',NULL,1266,63220000,'CE','2303204',1,'2006-11-12 16:53:40'),(657,NULL,1,14,'CARIS',NULL,1267,63530000,'CE','2303303',1,'2006-11-12 16:53:40'),(658,NULL,1,14,'CARNAUBAL',NULL,1270,62375000,'CE','2303402',1,'2006-11-12 16:53:40'),(659,NULL,1,14,'CASCAVEL',NULL,1278,62850000,'CE','2303501',1,'2006-11-12 16:53:40'),(660,NULL,1,14,'CATARINA',NULL,1280,63595000,'CE','2303600',1,'2006-11-12 16:53:41'),(661,NULL,1,14,'CATUNDA',NULL,1283,62297000,'CE','2303659',1,'2006-11-12 16:53:41'),(662,NULL,1,14,'CAUCAIA',NULL,1284,NULL,'CE','2303709',1,'2006-11-12 16:53:41'),(663,NULL,1,14,'CEDRO',NULL,1287,63400000,'CE','2303808',1,'2006-11-12 16:53:41'),(664,NULL,1,14,'CHAVAL',NULL,1289,62420000,'CE','2303907',1,'2006-11-12 16:53:41'),(665,NULL,1,14,'CHOR',NULL,1290,63950000,'CE','2303931',1,'2006-11-12 16:53:41'),(666,NULL,1,14,'CHOROZINHO',NULL,1291,62875000,'CE','2303956',1,'2006-11-12 16:53:41'),(667,NULL,1,14,'COREA',NULL,1298,62160000,'CE','2304004',1,'2006-11-12 16:53:41'),(668,NULL,1,14,'CRATES',NULL,1300,63700000,'CE','2304103',1,'2006-11-12 16:53:41'),(669,NULL,1,14,'CRATO',NULL,1301,NULL,'CE','2304202',1,'2006-11-12 16:53:41'),(670,NULL,1,14,'CROAT',NULL,1304,62390000,'CE','2304236',1,'2006-11-12 16:53:41'),(671,NULL,1,14,'CRUZ',NULL,1308,62595000,'CE','2304251',1,'2006-11-12 16:53:41'),(672,NULL,1,14,'DEPUTADO IRAPUAN PINHEIRO',NULL,1318,63645000,'CE','2304269',1,'2006-11-12 16:53:41'),(673,NULL,1,14,'ERER',NULL,1333,63470000,'CE','2304277',1,'2006-11-12 16:53:41'),(674,NULL,1,14,'EUSBIO',NULL,1337,61760000,'CE','2304285',1,'2006-11-12 16:53:41'),(675,NULL,1,14,'FARIAS BRITO',NULL,1338,63185000,'CE','2304301',1,'2006-11-12 16:53:41'),(676,NULL,1,14,'FORQUILHA',NULL,1346,62115000,'CE','2304350',1,'2006-11-12 16:53:41'),(677,NULL,1,14,'FORTALEZA',NULL,1347,NULL,'CE','2304400',1,'2006-11-12 16:53:41'),(678,NULL,1,14,'FORTIM',NULL,1348,62815000,'CE','2304459',1,'2006-11-12 16:53:41'),(679,NULL,1,14,'FRECHEIRINHA',NULL,1349,62340000,'CE','2304509',1,'2006-11-12 16:53:41'),(680,NULL,1,14,'GENERAL SAMPAIO',NULL,1355,62738000,'CE','2304608',1,'2006-11-12 16:53:41'),(681,NULL,1,14,'GRAA',NULL,1361,62365000,'CE','2304657',1,'2006-11-12 16:53:41'),(682,NULL,1,14,'GRANJA',NULL,1362,62430000,'CE','2304707',1,'2006-11-12 16:53:42'),(683,NULL,1,14,'GRANJEIRO',NULL,1363,63230000,'CE','2304806',1,'2006-11-12 16:53:42'),(684,NULL,1,14,'GROAIRAS',NULL,1364,62190000,'CE','2304905',1,'2006-11-12 16:53:42'),(685,NULL,1,14,'GUAIBA',NULL,1365,61890000,'CE','2304954',1,'2006-11-12 16:53:42'),(686,NULL,1,14,'GUARACIABA DO NORTE',NULL,1368,62380000,'CE','2305001',1,'2006-11-12 16:53:42'),(687,NULL,1,14,'GUARAMIRANGA',NULL,1369,62766000,'CE','2305100',1,'2006-11-12 16:53:42'),(688,NULL,1,14,'HIDROLNDIA',NULL,1375,62270000,'CE','2305209',1,'2006-11-12 16:53:42'),(689,NULL,1,14,'HORIZONTE',NULL,1377,62880000,'CE','2305233',1,'2006-11-12 16:53:42'),(690,NULL,1,14,'IBARETAMA',NULL,1380,63970000,'CE','2305266',1,'2006-11-12 16:53:42'),(691,NULL,1,14,'IBIAPINA',NULL,1382,62360000,'CE','2305308',1,'2006-11-12 16:53:42'),(692,NULL,1,14,'IBICUITINGA',NULL,1386,62955000,'CE','2305332',1,'2006-11-12 16:53:42'),(693,NULL,1,14,'ICAPU',NULL,1390,62810000,'CE','2305357',1,'2006-11-12 16:53:42'),(694,NULL,1,14,'IC',NULL,1392,63430000,'CE','2305407',1,'2006-11-12 16:53:42'),(695,NULL,1,14,'IGUATU',NULL,1396,63500000,'CE','2305506',1,'2006-11-12 16:53:42'),(696,NULL,1,14,'INDEPENDNCIA',NULL,1397,63640000,'CE','2305605',1,'2006-11-12 16:53:42'),(697,NULL,1,14,'IPAPORANGA',NULL,1402,62215000,'CE','2305654',1,'2006-11-12 16:53:42'),(698,NULL,1,14,'IPAUMIRIM',NULL,1403,63340000,'CE','2305704',1,'2006-11-12 16:53:42'),(699,NULL,1,14,'IPU',NULL,1404,62250000,'CE','2305803',1,'2006-11-12 16:53:42'),(700,NULL,1,14,'IPUEIRAS',NULL,1405,62230000,'CE','2305902',1,'2006-11-12 16:53:42'),(701,NULL,1,14,'IRACEMA',NULL,1407,62980000,'CE','2306009',1,'2006-11-12 16:53:42'),(702,NULL,1,14,'IRAUUBA',NULL,1411,62620000,'CE','2306108',1,'2006-11-12 16:53:42'),(703,NULL,1,14,'ITAIABA',NULL,1415,62820000,'CE','2306207',1,'2006-11-12 16:53:43'),(704,NULL,1,14,'ITAITINGA',NULL,1417,61880000,'CE','2306256',1,'2006-11-12 16:53:43'),(705,NULL,1,14,'ITAPAG',NULL,1419,62600000,'CE','2306306',1,'2006-11-12 16:53:43'),(706,NULL,1,14,'ITAPIPOCA',NULL,1422,62500000,'CE','2306405',1,'2006-11-12 16:53:43'),(707,NULL,1,14,'ITAPINA',NULL,1423,62740000,'CE','2306504',1,'2006-11-12 16:53:43'),(708,NULL,1,14,'ITAREMA',NULL,1425,62590000,'CE','2306553',1,'2006-11-12 16:53:43'),(709,NULL,1,14,'ITATIRA',NULL,1426,62720000,'CE','2306603',1,'2006-11-12 16:53:43'),(710,NULL,1,14,'JAGUARETAMA',NULL,1432,63480000,'CE','2306702',1,'2006-11-12 16:53:43'),(711,NULL,1,14,'JAGUARIBARA',NULL,1433,63490000,'CE','2306801',1,'2006-11-12 16:53:43'),(712,NULL,1,14,'JAGUARIBE',NULL,1434,63475000,'CE','2306900',1,'2006-11-12 16:53:43'),(713,NULL,1,14,'JAGUARUANA',NULL,1435,62823000,'CE','2307007',1,'2006-11-12 16:53:43'),(714,NULL,1,14,'JARDIM',NULL,1439,63290000,'CE','2307106',1,'2006-11-12 16:53:43'),(715,NULL,1,14,'JATI',NULL,1442,63275000,'CE','2307205',1,'2006-11-12 16:53:43'),(716,NULL,1,14,'JIJOCA DE JERICOACOARA',NULL,1443,62598000,'CE','2307254',1,'2006-11-12 16:53:43'),(717,NULL,1,14,'JUAZEIRO DO NORTE',NULL,1451,NULL,'CE','2307304',1,'2006-11-12 16:53:43'),(718,NULL,1,14,'JUCS',NULL,1453,63580000,'CE','2307403',1,'2006-11-12 16:53:43'),(719,NULL,1,14,'LAVRAS DA MANGABEIRA',NULL,1468,63300000,'CE','2307502',1,'2006-11-12 16:53:43'),(720,NULL,1,14,'LIMOEIRO DO NORTE',NULL,1470,62930000,'CE','2307601',1,'2006-11-12 16:53:43'),(721,NULL,1,14,'MADALENA',NULL,1478,63860000,'CE','2307635',1,'2006-11-12 16:53:43'),(722,NULL,1,14,'MARACANA',NULL,1486,NULL,'CE','2307650',1,'2006-11-12 16:53:43'),(723,NULL,1,14,'MARANGUAPE',NULL,1488,61940000,'CE','2307700',1,'2006-11-12 16:53:43'),(724,NULL,1,14,'MARCO',NULL,1490,62560000,'CE','2307809',1,'2006-11-12 16:53:44'),(725,NULL,1,14,'MARTINPOLE',NULL,1495,62450000,'CE','2307908',1,'2006-11-12 16:53:44'),(726,NULL,1,14,'MASSAP',NULL,1496,62140000,'CE','2308005',1,'2006-11-12 16:53:44'),(727,NULL,1,14,'MAURITI',NULL,1500,63210000,'CE','2308104',1,'2006-11-12 16:53:44'),(728,NULL,1,14,'MERUOCA',NULL,1502,62130000,'CE','2308203',1,'2006-11-12 16:53:44'),(729,NULL,1,14,'MILAGRES',NULL,1505,63250000,'CE','2308302',1,'2006-11-12 16:53:44'),(730,NULL,1,14,'MILH',NULL,1506,63635000,'CE','2308351',1,'2006-11-12 16:53:44'),(731,NULL,1,14,'MIRAMA',NULL,1510,62530000,'CE','2308377',1,'2006-11-12 16:53:44'),(732,NULL,1,14,'MISSO VELHA',NULL,1513,63200000,'CE','2308401',1,'2006-11-12 16:53:44'),(733,NULL,1,14,'MOMBAA',NULL,1516,63610000,'CE','2308500',1,'2006-11-12 16:53:44'),(734,NULL,1,14,'MONSENHOR TABOSA',NULL,1519,63780000,'CE','2308609',1,'2006-11-12 16:53:44'),(735,NULL,1,14,'MORADA NOVA',NULL,1526,62940000,'CE','2308708',1,'2006-11-12 16:53:44'),(736,NULL,1,14,'MORAJO',NULL,1527,62480000,'CE','2308807',1,'2006-11-12 16:53:44'),(737,NULL,1,14,'MORRINHOS',NULL,1528,62550000,'CE','2308906',1,'2006-11-12 16:53:44'),(738,NULL,1,14,'MUCAMBO',NULL,1531,62170000,'CE','2309003',1,'2006-11-12 16:53:44'),(739,NULL,1,14,'MULUNGU',NULL,1532,62764000,'CE','2309102',1,'2006-11-12 16:53:44'),(740,NULL,1,14,'NOVA OLINDA',NULL,1547,63165000,'CE','2309201',1,'2006-11-12 16:53:44'),(741,NULL,1,14,'NOVA RUSSAS',NULL,1548,62200000,'CE','2309300',1,'2006-11-12 16:53:44'),(742,NULL,1,14,'NOVO ORIENTE',NULL,1551,63740000,'CE','2309409',1,'2006-11-12 16:53:44'),(743,NULL,1,14,'OCARA',NULL,1553,62755000,'CE','2309458',1,'2006-11-12 16:53:44'),(744,NULL,1,14,'ORS',NULL,1559,63520000,'CE','2309508',1,'2006-11-12 16:53:44'),(745,NULL,1,14,'PACAJUS',NULL,1560,62870000,'CE','2309607',1,'2006-11-12 16:53:45'),(746,NULL,1,14,'PACATUBA',NULL,1561,61800000,'CE','2309706',1,'2006-11-12 16:53:45'),(747,NULL,1,14,'PACOTI',NULL,1562,62770000,'CE','2309805',1,'2006-11-12 16:53:45'),(748,NULL,1,14,'PACUJ',NULL,1563,62180000,'CE','2309904',1,'2006-11-12 16:53:45'),(749,NULL,1,14,'PALHANO',NULL,1572,62910000,'CE','2310001',1,'2006-11-12 16:53:45'),(750,NULL,1,14,'PALMCIA',NULL,1573,62780000,'CE','2310100',1,'2006-11-12 16:53:45'),(751,NULL,1,14,'PARACURU',NULL,1577,62680000,'CE','2310209',1,'2006-11-12 16:53:45'),(752,NULL,1,14,'PARAIPABA',NULL,1578,62685000,'CE','2310258',1,'2006-11-12 16:53:45'),(753,NULL,1,14,'PARAMBU',NULL,1580,63680000,'CE','2310308',1,'2006-11-12 16:53:45'),(754,NULL,1,14,'PARAMOTI',NULL,1581,62736000,'CE','2310407',1,'2006-11-12 16:53:45'),(755,NULL,1,14,'PEDRA BRANCA',NULL,1594,63630000,'CE','2310506',1,'2006-11-12 16:53:45'),(756,NULL,1,14,'PENAFORTE',NULL,1600,63280000,'CE','2310605',1,'2006-11-12 16:53:45'),(757,NULL,1,14,'PENTECOSTE',NULL,1601,62640000,'CE','2310704',1,'2006-11-12 16:53:45'),(758,NULL,1,14,'PEREIRO',NULL,1602,63460000,'CE','2310803',1,'2006-11-12 16:53:45'),(759,NULL,1,14,'PINDORETAMA',NULL,1606,62860000,'CE','2310852',1,'2006-11-12 16:53:45'),(760,NULL,1,14,'PIQUET CARNEIRO',NULL,1608,63605000,'CE','2310902',1,'2006-11-12 16:53:45'),(761,NULL,1,14,'PIRES FERREIRA',NULL,1611,62255000,'CE','2310951',1,'2006-11-12 16:53:45'),(762,NULL,1,14,'PORANGA',NULL,1621,62220000,'CE','2311009',1,'2006-11-12 16:53:45'),(763,NULL,1,14,'PORTEIRAS',NULL,1623,63270000,'CE','2311108',1,'2006-11-12 16:53:45'),(764,NULL,1,14,'POTENGI',NULL,1624,63160000,'CE','2311207',1,'2006-11-12 16:53:45'),(765,NULL,1,14,'POTIRETAMA',NULL,1626,62990000,'CE','2311231',1,'2006-11-12 16:53:45'),(766,NULL,1,14,'QUITERIANPOLIS',NULL,1635,63650000,'CE','2311264',1,'2006-11-12 16:53:46'),(767,NULL,1,14,'QUIXAD',NULL,1636,63900000,'CE','2311306',1,'2006-11-12 16:53:46'),(768,NULL,1,14,'QUIXEL',NULL,1638,63515000,'CE','2311355',1,'2006-11-12 16:53:46'),(769,NULL,1,14,'QUIXERAMOBIM',NULL,1639,63800000,'CE','2311405',1,'2006-11-12 16:53:46'),(770,NULL,1,14,'QUIXER',NULL,1640,62920000,'CE','2311504',1,'2006-11-12 16:53:46'),(771,NULL,1,14,'REDENO',NULL,1643,62790000,'CE','2311603',1,'2006-11-12 16:53:46'),(772,NULL,1,14,'RERIUTABA',NULL,1644,62260000,'CE','2311702',1,'2006-11-12 16:53:46'),(773,NULL,1,14,'RUSSAS',NULL,1651,62900000,'CE','2311801',1,'2006-11-12 16:53:46'),(774,NULL,1,14,'SABOEIRO',NULL,1653,63590000,'CE','2311900',1,'2006-11-12 16:53:46'),(775,NULL,1,14,'SALITRE',NULL,1656,63155000,'CE','2311959',1,'2006-11-12 16:53:46'),(776,NULL,1,14,'SANTA QUITRIA',NULL,1662,62280000,'CE','2312205',1,'2006-11-12 16:53:46'),(777,NULL,1,14,'SANTANA DO ACARA',NULL,1666,62150000,'CE','2312007',1,'2006-11-12 16:53:46'),(778,NULL,1,14,'SANTANA DO CARIRI',NULL,1667,63190000,'CE','2312106',1,'2006-11-12 16:53:46'),(779,NULL,1,14,'SO BENEDITO',NULL,1676,62370000,'CE','2312304',1,'2006-11-12 16:53:46'),(780,NULL,1,14,'SO GONALO DO AMARANTE',NULL,1682,62670000,'CE','2312403',1,'2006-11-12 16:53:46'),(781,NULL,1,14,'SO JOO DO JAGUARIBE',NULL,1685,62965000,'CE','2312502',1,'2006-11-12 16:53:46'),(782,NULL,1,14,'SO LUS DO CURU',NULL,1696,62665000,'CE','2312601',1,'2006-11-12 16:53:46'),(783,NULL,1,14,'SENADOR POMPEU',NULL,1710,63600000,'CE','2312700',1,'2006-11-12 16:53:46'),(784,NULL,1,14,'SENADOR S',NULL,1711,62470000,'CE','2312809',1,'2006-11-12 16:53:46'),(785,NULL,1,14,'SOBRAL',NULL,1722,NULL,'CE','2312908',1,'2006-11-12 16:53:46'),(786,NULL,1,14,'SOLONPOLE',NULL,1724,63620000,'CE','2313005',1,'2006-11-12 16:53:46'),(787,NULL,1,14,'TABULEIRO DO NORTE',NULL,1731,62960000,'CE','2313104',1,'2006-11-12 16:53:47'),(788,NULL,1,14,'TAMBORIL',NULL,1733,63750000,'CE','2313203',1,'2006-11-12 16:53:47'),(789,NULL,1,14,'TARRAFAS',NULL,1739,63145000,'CE','2313252',1,'2006-11-12 16:53:47'),(790,NULL,1,14,'TAU',NULL,1740,63660000,'CE','2313302',1,'2006-11-12 16:53:47'),(791,NULL,1,14,'TEJUUOCA',NULL,1741,62610000,'CE','2313351',1,'2006-11-12 16:53:47'),(792,NULL,1,14,'TIANGU',NULL,1742,62320000,'CE','2313401',1,'2006-11-12 16:53:47'),(793,NULL,1,14,'TRAIRI',NULL,1746,62690000,'CE','2313500',1,'2006-11-12 16:53:47'),(794,NULL,1,14,'TURURU',NULL,1755,62655000,'CE','2313559',1,'2006-11-12 16:53:47'),(795,NULL,1,14,'UBAJARA',NULL,1756,62350000,'CE','2313609',1,'2006-11-12 16:53:47'),(796,NULL,1,14,'UMARI',NULL,1760,63310000,'CE','2313708',1,'2006-11-12 16:53:47'),(797,NULL,1,14,'UMIRIM',NULL,1763,62660000,'CE','2313757',1,'2006-11-12 16:53:47'),(798,NULL,1,14,'URUBURETAMA',NULL,1764,62650000,'CE','2313807',1,'2006-11-12 16:53:47'),(799,NULL,1,14,'URUOCA',NULL,1765,62460000,'CE','2313906',1,'2006-11-12 16:53:47'),(800,NULL,1,14,'VARJOTA',NULL,1767,62265000,'CE','2313955',1,'2006-11-12 16:53:47'),(801,NULL,1,14,'VRZEA ALEGRE',NULL,1769,63540000,'CE','2314003',1,'2006-11-12 16:53:47'),(802,NULL,1,14,'VIOSA DO CEAR',NULL,1776,62300000,'CE','2314102',1,'2006-11-12 16:53:47'),(803,NULL,1,10,'BRASLIA',NULL,1778,NULL,'DF','5300108',1,'2006-11-12 16:53:47'),(804,NULL,1,21,'AFONSO CLUDIO',NULL,1798,29600000,'ES','3200102',1,'2006-11-12 16:53:47'),(805,NULL,1,21,'GUA DOCE DO NORTE',NULL,1800,29820000,'ES','3200169',1,'2006-11-12 16:53:47'),(806,NULL,1,21,'GUIA BRANCA',NULL,1801,29795000,'ES','3200136',1,'2006-11-12 16:53:47'),(807,NULL,1,21,'ALEGRE',NULL,1803,29500000,'ES','3200201',1,'2006-11-12 16:53:47'),(808,NULL,1,21,'ALFREDO CHAVES',NULL,1804,29240000,'ES','3200300',1,'2006-11-12 16:53:48'),(809,NULL,1,21,'ALTO RIO NOVO',NULL,1808,29760000,'ES','3200359',1,'2006-11-12 16:53:48'),(810,NULL,1,21,'ANCHIETA',NULL,1810,29230000,'ES','3200409',1,'2006-11-12 16:53:48'),(811,NULL,1,21,'APIAC',NULL,1813,29450000,'ES','3200508',1,'2006-11-12 16:53:48'),(812,NULL,1,21,'ARACRUZ',NULL,1816,29190000,'ES','3200607',1,'2006-11-12 16:53:48'),(813,NULL,1,21,'ATLIO VIVCQUA',NULL,1821,29490000,'ES','3200706',1,'2006-11-12 16:53:48'),(814,NULL,1,21,'BAIXO GUANDU',NULL,1823,29730000,'ES','3200805',1,'2006-11-12 16:53:48'),(815,NULL,1,21,'BARRA DE SO FRANCISCO',NULL,1825,29800000,'ES','3200904',1,'2006-11-12 16:53:48'),(816,NULL,1,21,'BOA ESPERANA',NULL,1831,29845000,'ES','3201001',1,'2006-11-12 16:53:48'),(817,NULL,1,21,'BOM JESUS DO NORTE',NULL,1833,29460000,'ES','3201100',1,'2006-11-12 16:53:48'),(818,NULL,1,21,'BREJETUBA',NULL,1836,29630000,'ES','3201159',1,'2006-11-12 16:53:48'),(819,NULL,1,21,'CACHOEIRO DE ITAPEMIRIM',NULL,1839,NULL,'ES','3201209',1,'2006-11-12 16:53:48'),(820,NULL,1,21,'CARIACICA',NULL,1844,NULL,'ES','3201308',1,'2006-11-12 16:53:48'),(821,NULL,1,21,'CASTELO',NULL,1845,29360000,'ES','3201407',1,'2006-11-12 16:53:48'),(822,NULL,1,21,'COLATINA',NULL,1847,NULL,'ES','3201506',1,'2006-11-12 16:53:48'),(823,NULL,1,21,'CONCEIO DA BARRA',NULL,1848,29960000,'ES','3201605',1,'2006-11-12 16:53:48'),(824,NULL,1,21,'CONCEIO DO CASTELO',NULL,1849,29370000,'ES','3201704',1,'2006-11-12 16:53:48'),(825,NULL,1,21,'DIVINO DE SO LOURENO',NULL,1858,29590000,'ES','3201803',1,'2006-11-12 16:53:48'),(826,NULL,1,21,'DOMINGOS MARTINS',NULL,1861,29260000,'ES','3201902',1,'2006-11-12 16:53:48'),(827,NULL,1,21,'DORES DO RIO PRETO',NULL,1863,29580000,'ES','3202009',1,'2006-11-12 16:53:48'),(828,NULL,1,21,'ECOPORANGA',NULL,1865,29850000,'ES','3202108',1,'2006-11-12 16:53:48'),(829,NULL,1,21,'FUNDO',NULL,1869,29185000,'ES','3202207',1,'2006-11-12 16:53:49'),(830,NULL,1,21,'GOVERNADOR LINDENBERG',NULL,1874,29720000,'ES','3202256',1,'2006-11-12 16:53:49'),(831,NULL,1,21,'GUAU',NULL,1877,29560000,'ES','3202306',1,'2006-11-12 16:53:49'),(832,NULL,1,21,'GUARAPARI',NULL,1879,NULL,'ES','3202405',1,'2006-11-12 16:53:49'),(833,NULL,1,21,'IBATIBA',NULL,1881,29395000,'ES','3202454',1,'2006-11-12 16:53:49'),(834,NULL,1,21,'IBIRAU',NULL,1884,29670000,'ES','3202504',1,'2006-11-12 16:53:49'),(835,NULL,1,21,'IBITIRAMA',NULL,1885,29540000,'ES','3202553',1,'2006-11-12 16:53:49'),(836,NULL,1,21,'ICONHA',NULL,1888,29280000,'ES','3202603',1,'2006-11-12 16:53:49'),(837,NULL,1,21,'IRUPI',NULL,1892,29398000,'ES','3202652',1,'2006-11-12 16:53:49'),(838,NULL,1,21,'ITAGUAU',NULL,1896,29690000,'ES','3202702',1,'2006-11-12 16:53:49'),(839,NULL,1,21,'ITAPEMIRIM',NULL,1903,29330000,'ES','3202801',1,'2006-11-12 16:53:49'),(840,NULL,1,21,'ITARAN',NULL,1907,29620000,'ES','3202900',1,'2006-11-12 16:53:49'),(841,NULL,1,21,'INA',NULL,1910,29390000,'ES','3203007',1,'2006-11-12 16:53:49'),(842,NULL,1,21,'JAGUAR',NULL,1915,29950000,'ES','3203056',1,'2006-11-12 16:53:49'),(843,NULL,1,21,'JERNIMO MONTEIRO',NULL,1916,29550000,'ES','3203106',1,'2006-11-12 16:53:49'),(844,NULL,1,21,'JOO NEIVA',NULL,1918,29680000,'ES','3203130',1,'2006-11-12 16:53:49'),(845,NULL,1,21,'LARANJA DA TERRA',NULL,1923,29615000,'ES','3203163',1,'2006-11-12 16:53:49'),(846,NULL,1,21,'LINHARES',NULL,1925,NULL,'ES','3203205',1,'2006-11-12 16:53:49'),(847,NULL,1,21,'MANTENPOLIS',NULL,1927,29770000,'ES','3203304',1,'2006-11-12 16:53:49'),(848,NULL,1,21,'MARATAZES',NULL,1928,29345000,'ES','3203320',1,'2006-11-12 16:53:49'),(849,NULL,1,21,'MARECHAL FLORIANO',NULL,1929,29255000,'ES','3203346',1,'2006-11-12 16:53:49'),(850,NULL,1,21,'MARILNDIA',NULL,1930,29725000,'ES','3203353',1,'2006-11-12 16:53:49'),(851,NULL,1,21,'MIMOSO DO SUL',NULL,1934,29400000,'ES','3203403',1,'2006-11-12 16:53:50'),(852,NULL,1,21,'MONTANHA',NULL,1935,29890000,'ES','3203502',1,'2006-11-12 16:53:50'),(853,NULL,1,21,'MUCURICI',NULL,1939,29880000,'ES','3203601',1,'2006-11-12 16:53:50'),(854,NULL,1,21,'MUNIZ FREIRE',NULL,1941,29380000,'ES','3203700',1,'2006-11-12 16:53:50'),(855,NULL,1,21,'MUQUI',NULL,1942,29480000,'ES','3203809',1,'2006-11-12 16:53:50'),(856,NULL,1,21,'NOVA VENCIA',NULL,1946,29830000,'ES','3203908',1,'2006-11-12 16:53:50'),(857,NULL,1,21,'PANCAS',NULL,1954,29750000,'ES','3204005',1,'2006-11-12 16:53:50'),(858,NULL,1,21,'PEDRO CANRIO',NULL,1957,29970000,'ES','3204054',1,'2006-11-12 16:53:50'),(859,NULL,1,21,'PINHEIROS',NULL,1962,29980000,'ES','3204104',1,'2006-11-12 16:53:50'),(860,NULL,1,21,'PIMA',NULL,1964,29285000,'ES','3204203',1,'2006-11-12 16:53:50'),(861,NULL,1,21,'PONTO BELO',NULL,1966,29885000,'ES','3204252',1,'2006-11-12 16:53:50'),(862,NULL,1,21,'PRESIDENTE KENNEDY',NULL,1971,29350000,'ES','3204302',1,'2006-11-12 16:53:50'),(863,NULL,1,21,'RIO BANANAL',NULL,1978,29920000,'ES','3204351',1,'2006-11-12 16:53:50'),(864,NULL,1,21,'RIO NOVO DO SUL',NULL,1981,29290000,'ES','3204401',1,'2006-11-12 16:53:50'),(865,NULL,1,21,'SANTA LEOPOLDINA',NULL,1988,29640000,'ES','3204500',1,'2006-11-12 16:53:50'),(866,NULL,1,21,'SANTA MARIA DE JETIB',NULL,1992,29645000,'ES','3204559',1,'2006-11-12 16:53:50'),(867,NULL,1,21,'SANTA TERESA',NULL,1994,29650000,'ES','3204609',1,'2006-11-12 16:53:50'),(868,NULL,1,21,'SO DOMINGOS DO NORTE',NULL,2003,29745000,'ES','3204658',1,'2006-11-12 16:53:50'),(869,NULL,1,21,'SO GABRIEL DA PALHA',NULL,2006,29780000,'ES','3204708',1,'2006-11-12 16:53:50'),(870,NULL,1,21,'SO JOS DO CALADO',NULL,2017,29470000,'ES','3204807',1,'2006-11-12 16:53:50'),(871,NULL,1,21,'SO MATEUS',NULL,2019,29930000,'ES','3204906',1,'2006-11-12 16:53:50'),(872,NULL,1,21,'SO ROQUE DO CANNA',NULL,2024,29665000,'ES',NULL,1,'2006-11-12 16:53:51'),(873,NULL,1,21,'SERRA',NULL,2028,NULL,'ES','3205002',1,'2006-11-12 16:53:51'),(874,NULL,1,21,'SOORETAMA',NULL,2031,29927000,'ES','3205010',1,'2006-11-12 16:53:51'),(875,NULL,1,21,'VARGEM ALTA',NULL,2035,29295000,'ES','3205036',1,'2006-11-12 16:53:51'),(876,NULL,1,21,'VENDA NOVA DO IMIGRANTE',NULL,2037,29375000,'ES','3205069',1,'2006-11-12 16:53:51'),(877,NULL,1,21,'VIANA',NULL,2038,29135000,'ES','3205101',1,'2006-11-12 16:53:51'),(878,NULL,1,21,'VILA PAVO',NULL,2042,29843000,'ES','3205150',1,'2006-11-12 16:53:51'),(879,NULL,1,21,'VILA VALRIO',NULL,2043,29785000,'ES','3205176',1,'2006-11-12 16:53:51'),(880,NULL,1,21,'VILA VELHA',NULL,2044,NULL,'ES','3205200',1,'2006-11-12 16:53:51'),(881,NULL,1,21,'VITRIA',NULL,2048,NULL,'ES','3205309',1,'2006-11-12 16:53:51'),(882,NULL,1,9,'ABADIA DE GOIS',NULL,2049,75345000,'GO','5200050',1,'2006-11-12 16:53:51'),(883,NULL,1,9,'ABADINIA',NULL,2050,72940000,'GO','5200100',1,'2006-11-12 16:53:51'),(884,NULL,1,9,'ACRENA',NULL,2051,75960000,'GO','5200134',1,'2006-11-12 16:53:51'),(885,NULL,1,9,'ADELNDIA',NULL,2052,76155000,'GO','5200159',1,'2006-11-12 16:53:51'),(886,NULL,1,9,'GUA FRIA DE GOIS',NULL,2053,73780000,'GO','5200175',1,'2006-11-12 16:53:51'),(887,NULL,1,9,'GUA LIMPA',NULL,2054,75665000,'GO','5200209',1,'2006-11-12 16:53:51'),(888,NULL,1,9,'GUAS LINDAS DE GOIS',NULL,2055,72910000,'GO','5200258',1,'2006-11-12 16:53:51'),(889,NULL,1,9,'ALEXNIA',NULL,2056,72920000,'GO','5200308',1,'2006-11-12 16:53:51'),(890,NULL,1,9,'ALONDIA',NULL,2057,75615000,'GO','5200506',1,'2006-11-12 16:53:51'),(891,NULL,1,9,'ALTO HORIZONTE',NULL,2059,76560000,'GO','5200555',1,'2006-11-12 16:53:52'),(892,NULL,1,9,'ALTO PARASO DE GOIS',NULL,2060,73770000,'GO','5200605',1,'2006-11-12 16:53:52'),(893,NULL,1,9,'ALVORADA DO NORTE',NULL,2061,73950000,'GO','5200803',1,'2006-11-12 16:53:52'),(894,NULL,1,9,'AMARALINA',NULL,2062,76493000,'GO','5200829',1,'2006-11-12 16:53:52'),(895,NULL,1,9,'AMERICANO DO BRASIL',NULL,2063,76165000,'GO','5200852',1,'2006-11-12 16:53:52'),(896,NULL,1,9,'AMORINPOLIS',NULL,2064,76140000,'GO','5200902',1,'2006-11-12 16:53:52'),(897,NULL,1,9,'ANPOLIS',NULL,2065,NULL,'GO','5201108',1,'2006-11-12 16:53:52'),(898,NULL,1,9,'ANHANGERA',NULL,2066,75770000,'GO',NULL,1,'2006-11-12 16:53:52'),(899,NULL,1,9,'ANICUNS',NULL,2067,76170000,'GO','5201306',1,'2006-11-12 16:53:52'),(900,NULL,1,9,'APARECIDA DE GOINIA',NULL,2069,NULL,'GO','5201405',1,'2006-11-12 16:53:52'),(901,NULL,1,9,'APARECIDA DO RIO DOCE',NULL,2072,75827000,'GO','5201454',1,'2006-11-12 16:53:52'),(902,NULL,1,9,'APOR',NULL,2073,75825000,'GO','5201504',1,'2006-11-12 16:53:52'),(903,NULL,1,9,'ARAU',NULL,2074,75410000,'GO','5201603',1,'2006-11-12 16:53:52'),(904,NULL,1,9,'ARAGARAS',NULL,2075,76240000,'GO','5201702',1,'2006-11-12 16:53:52'),(905,NULL,1,9,'ARAGOINIA',NULL,2076,75360000,'GO','5201801',1,'2006-11-12 16:53:52'),(906,NULL,1,9,'ARAGUAPAZ',NULL,2077,76720000,'GO','5202155',1,'2006-11-12 16:53:52'),(907,NULL,1,9,'ARENPOLIS',NULL,2078,76235000,'GO','5202353',1,'2006-11-12 16:53:52'),(908,NULL,1,9,'ARUAN',NULL,2079,76710000,'GO','5202502',1,'2006-11-12 16:53:52'),(909,NULL,1,9,'AURILNDIA',NULL,2080,76120000,'GO','5202601',1,'2006-11-12 16:53:52'),(910,NULL,1,9,'AVELINPOLIS',NULL,2082,75395000,'GO','5202809',1,'2006-11-12 16:53:52'),(911,NULL,1,9,'BALIZA',NULL,2084,76250000,'GO','5203104',1,'2006-11-12 16:53:52'),(912,NULL,1,9,'BARRO ALTO',NULL,2087,76390000,'GO','5203203',1,'2006-11-12 16:53:52'),(913,NULL,1,9,'BELA VISTA DE GOIS',NULL,2088,75240000,'GO','5203302',1,'2006-11-12 16:53:52'),(914,NULL,1,9,'BOM JARDIM DE GOIS',NULL,2089,76245000,'GO','5203401',1,'2006-11-12 16:53:53'),(915,NULL,1,9,'BOM JESUS DE GOIS',NULL,2090,75570000,'GO','5203500',1,'2006-11-12 16:53:53'),(916,NULL,1,9,'BONFINPOLIS',NULL,2091,75195000,'GO','5203559',1,'2006-11-12 16:53:53'),(917,NULL,1,9,'BONPOLIS',NULL,2092,76555000,'GO','5203575',1,'2006-11-12 16:53:53'),(918,NULL,1,9,'BRAZABRANTES',NULL,2093,75440000,'GO','5203609',1,'2006-11-12 16:53:53'),(919,NULL,1,9,'BRITNIA',NULL,2094,76280000,'GO','5203807',1,'2006-11-12 16:53:53'),(920,NULL,1,9,'BURITI ALEGRE',NULL,2096,75660000,'GO','5203906',1,'2006-11-12 16:53:53'),(921,NULL,1,9,'BURITI DE GOIS',NULL,2097,76152000,'GO','5203939',1,'2006-11-12 16:53:53'),(922,NULL,1,9,'BURITINPOLIS',NULL,2098,73975000,'GO','5203962',1,'2006-11-12 16:53:53'),(923,NULL,1,9,'CABECEIRAS',NULL,2099,73870000,'GO','5204003',1,'2006-11-12 16:53:53'),(924,NULL,1,9,'CACHOEIRA ALTA',NULL,2100,75870000,'GO','5204102',1,'2006-11-12 16:53:53'),(925,NULL,1,9,'CACHOEIRA DE GOIS',NULL,2101,76125000,'GO','5204201',1,'2006-11-12 16:53:53'),(926,NULL,1,9,'CACHOEIRA DOURADA',NULL,2102,75560000,'GO','5204250',1,'2006-11-12 16:53:53'),(927,NULL,1,9,'CAU',NULL,2103,75813000,'GO','5204300',1,'2006-11-12 16:53:53'),(928,NULL,1,9,'CAIAPNIA',NULL,2104,75850000,'GO','5204409',1,'2006-11-12 16:53:53'),(929,NULL,1,9,'CALDAS NOVAS',NULL,2107,75690000,'GO','5204508',1,'2006-11-12 16:53:53'),(930,NULL,1,9,'CALDAZINHA',NULL,2108,75245000,'GO','5204557',1,'2006-11-12 16:53:53'),(931,NULL,1,9,'CAMPESTRE DE GOIS',NULL,2110,75385000,'GO','5204607',1,'2006-11-12 16:53:53'),(932,NULL,1,9,'CAMPINAU',NULL,2111,76440000,'GO','5204656',1,'2006-11-12 16:53:53'),(933,NULL,1,9,'CAMPINORTE',NULL,2112,76410000,'GO','5204706',1,'2006-11-12 16:53:53'),(934,NULL,1,9,'CAMPO ALEGRE DE GOIS',NULL,2113,75795000,'GO','5204805',1,'2006-11-12 16:53:53'),(935,NULL,1,9,'CAMPOS BELOS',NULL,2116,73840000,'GO','5204904',1,'2006-11-12 16:53:53'),(936,NULL,1,9,'CAMPOS VERDES',NULL,2117,76515000,'GO','5204953',1,'2006-11-12 16:53:54'),(937,NULL,1,9,'CARMO DO RIO VERDE',NULL,2122,76340000,'GO','5205000',1,'2006-11-12 16:53:54'),(938,NULL,1,9,'CASTELNDIA',NULL,2123,75925000,'GO','5205059',1,'2006-11-12 16:53:54'),(939,NULL,1,9,'CATALO',NULL,2125,NULL,'GO','5205109',1,'2006-11-12 16:53:54'),(940,NULL,1,9,'CATURA',NULL,2126,75430000,'GO','5205208',1,'2006-11-12 16:53:54'),(941,NULL,1,9,'CAVALCANTE',NULL,2127,73790000,'GO','5205307',1,'2006-11-12 16:53:54'),(942,NULL,1,9,'CERES',NULL,2130,76300000,'GO','5205406',1,'2006-11-12 16:53:54'),(943,NULL,1,9,'CEZARINA',NULL,2131,76195000,'GO','5205455',1,'2006-11-12 16:53:54'),(944,NULL,1,9,'CHAPADO DO CU',NULL,2132,75828000,'GO','5205471',1,'2006-11-12 16:53:54'),(945,NULL,1,9,'Cidade OCIDENTAL',NULL,2135,72880000,'GO','5205497',1,'2006-11-12 16:53:54'),(946,NULL,1,9,'COCALZINHO DE GOIS',NULL,2137,72975000,'GO','5205513',1,'2006-11-12 16:53:54'),(947,NULL,1,9,'COLINAS DO SUL',NULL,2138,73740000,'GO','5205521',1,'2006-11-12 16:53:54'),(948,NULL,1,9,'CRREGO DO OURO',NULL,2139,76145000,'GO','5205703',1,'2006-11-12 16:53:54'),(949,NULL,1,9,'CORUMB DE GOIS',NULL,2141,72960000,'GO','5205802',1,'2006-11-12 16:53:54'),(950,NULL,1,9,'CORUMBABA',NULL,2142,75680000,'GO','5205901',1,'2006-11-12 16:53:54'),(951,NULL,1,9,'CRISTALINA',NULL,2143,73850000,'GO','5206206',1,'2006-11-12 16:53:54'),(952,NULL,1,9,'CRISTIANPOLIS',NULL,2144,75230000,'GO','5206305',1,'2006-11-12 16:53:54'),(953,NULL,1,9,'CRIXS',NULL,2145,76510000,'GO','5206404',1,'2006-11-12 16:53:54'),(954,NULL,1,9,'CROMNIA',NULL,2146,75635000,'GO','5206503',1,'2006-11-12 16:53:54'),(955,NULL,1,9,'CUMARI',NULL,2148,75760000,'GO','5206602',1,'2006-11-12 16:53:54'),(956,NULL,1,9,'DAMIANPOLIS',NULL,2149,73980000,'GO','5206701',1,'2006-11-12 16:53:54'),(957,NULL,1,9,'DAMOLNDIA',NULL,2150,75420000,'GO','5206800',1,'2006-11-12 16:53:54'),(958,NULL,1,9,'DAVINPOLIS',NULL,2152,75730000,'GO','5206909',1,'2006-11-12 16:53:55'),(959,NULL,1,9,'DIORAMA',NULL,2154,76260000,'GO','5207105',1,'2006-11-12 16:53:55'),(960,NULL,1,9,'DIVINPOLIS DE GOIS',NULL,2155,73865000,'GO','5208301',1,'2006-11-12 16:53:55'),(961,NULL,1,9,'DOVERLNDIA',NULL,2157,75855000,'GO','5207253',1,'2006-11-12 16:53:55'),(962,NULL,1,9,'EDEALINA',NULL,2158,75945000,'GO','5207352',1,'2006-11-12 16:53:55'),(963,NULL,1,9,'EDIA',NULL,2159,75940000,'GO','5207402',1,'2006-11-12 16:53:55'),(964,NULL,1,9,'ESTRELA DO NORTE',NULL,2160,76485000,'GO','5207501',1,'2006-11-12 16:53:55'),(965,NULL,1,9,'FAINA',NULL,2161,76740000,'GO','5207535',1,'2006-11-12 16:53:55'),(966,NULL,1,9,'FAZENDA NOVA',NULL,2162,76220000,'GO','5207600',1,'2006-11-12 16:53:55'),(967,NULL,1,9,'FIRMINPOLIS',NULL,2163,76105000,'GO','5207808',1,'2006-11-12 16:53:55'),(968,NULL,1,9,'FLORES DE GOIS',NULL,2164,73890000,'GO','5207907',1,'2006-11-12 16:53:55'),(969,NULL,1,9,'FORMOSA',NULL,2165,NULL,'GO','5208004',1,'2006-11-12 16:53:55'),(970,NULL,1,9,'FORMOSO',NULL,2166,76470000,'GO','5208103',1,'2006-11-12 16:53:55'),(971,NULL,1,9,'GAMELEIRA DE GOIS',NULL,2168,75184000,'GO','5208152',1,'2006-11-12 16:53:55'),(972,NULL,1,9,'GOIANPOLIS',NULL,2171,75170000,'GO','5208400',1,'2006-11-12 16:53:55'),(973,NULL,1,9,'GOIANDIRA',NULL,2172,75740000,'GO','5208509',1,'2006-11-12 16:53:55'),(974,NULL,1,9,'GOIANSIA',NULL,2173,76380000,'GO','5208608',1,'2006-11-12 16:53:55'),(975,NULL,1,9,'GOINIA',NULL,2174,NULL,'GO','5208707',1,'2006-11-12 16:53:55'),(976,NULL,1,9,'GOIANIRA',NULL,2175,75370000,'GO','5208806',1,'2006-11-12 16:53:55'),(977,NULL,1,9,'GOIS',NULL,2176,76600000,'GO','5208905',1,'2006-11-12 16:53:55'),(978,NULL,1,9,'GOIATUBA',NULL,2177,75600000,'GO','5209101',1,'2006-11-12 16:53:55'),(979,NULL,1,9,'GOUVELNDIA',NULL,2178,75865000,'GO','5209150',1,'2006-11-12 16:53:55'),(980,NULL,1,9,'GUAP',NULL,2179,75350000,'GO','5209200',1,'2006-11-12 16:53:55'),(981,NULL,1,9,'GUARATA',NULL,2180,76690000,'GO','5209291',1,'2006-11-12 16:53:56'),(982,NULL,1,9,'GUARANI DE GOIS',NULL,2181,73910000,'GO','5209408',1,'2006-11-12 16:53:56'),(983,NULL,1,9,'GUARINOS',NULL,2182,76385000,'GO','5209457',1,'2006-11-12 16:53:56'),(984,NULL,1,9,'HEITORA',NULL,2183,76670000,'GO','5209606',1,'2006-11-12 16:53:56'),(985,NULL,1,9,'HIDROLNDIA',NULL,2184,75340000,'GO','5209705',1,'2006-11-12 16:53:56'),(986,NULL,1,9,'HIDROLINA',NULL,2185,76375000,'GO','5209804',1,'2006-11-12 16:53:56'),(987,NULL,1,9,'IACIARA',NULL,2186,73920000,'GO','5209903',1,'2006-11-12 16:53:56'),(988,NULL,1,9,'INACIOLNDIA',NULL,2187,75550000,'GO','5209937',1,'2006-11-12 16:53:56'),(989,NULL,1,9,'INDIARA',NULL,2188,75955000,'GO','5209952',1,'2006-11-12 16:53:56'),(990,NULL,1,9,'INHUMAS',NULL,2189,75400000,'GO','5210000',1,'2006-11-12 16:53:56'),(991,NULL,1,9,'IPAMERI',NULL,2191,75780000,'GO','5210109',1,'2006-11-12 16:53:56'),(992,NULL,1,9,'IPOR',NULL,2192,76200000,'GO','5210208',1,'2006-11-12 16:53:56'),(993,NULL,1,9,'ISRAELNDIA',NULL,2193,76205000,'GO','5210307',1,'2006-11-12 16:53:56'),(994,NULL,1,9,'ITABERA',NULL,2194,76630000,'GO','5210406',1,'2006-11-12 16:53:56'),(995,NULL,1,9,'ITAGUARI',NULL,2196,76650000,'GO','5210562',1,'2006-11-12 16:53:56'),(996,NULL,1,9,'ITAGUARU',NULL,2197,76660000,'GO','5210604',1,'2006-11-12 16:53:56'),(997,NULL,1,9,'ITAJ',NULL,2198,75815000,'GO','5210802',1,'2006-11-12 16:53:56'),(998,NULL,1,9,'ITAPACI',NULL,2199,76360000,'GO','5210901',1,'2006-11-12 16:53:56'),(999,NULL,1,9,'ITAPIRAPU',NULL,2200,76290000,'GO','5211008',1,'2006-11-12 16:53:56'),(1000,NULL,1,9,'ITAPURANGA',NULL,2201,76680000,'GO','5211206',1,'2006-11-12 16:53:56'),(1001,NULL,1,9,'ITARUM',NULL,2202,75810000,'GO','5211305',1,'2006-11-12 16:53:56'),(1002,NULL,1,9,'ITAUU',NULL,2203,75450000,'GO','5211404',1,'2006-11-12 16:53:56'),(1003,NULL,1,9,'ITUMBIARA',NULL,2204,NULL,'GO','5211503',1,'2006-11-12 16:53:57'),(1004,NULL,1,9,'IVOLNDIA',NULL,2205,76130000,'GO','5211602',1,'2006-11-12 16:53:57'),(1005,NULL,1,9,'JANDAIA',NULL,2207,75950000,'GO','5211701',1,'2006-11-12 16:53:57'),(1006,NULL,1,9,'JARAGU',NULL,2208,76330000,'GO','5211800',1,'2006-11-12 16:53:57'),(1007,NULL,1,9,'JATA',NULL,2209,NULL,'GO','5211909',1,'2006-11-12 16:53:57'),(1008,NULL,1,9,'JAUPACI',NULL,2210,76210000,'GO','5212006',1,'2006-11-12 16:53:57'),(1009,NULL,1,9,'JESPOLIS',NULL,2212,75495000,'GO','5212055',1,'2006-11-12 16:53:57'),(1010,NULL,1,9,'JOVINIA',NULL,2214,75610000,'GO','5212105',1,'2006-11-12 16:53:57'),(1011,NULL,1,9,'JUSSARA',NULL,2217,76270000,'GO','5212204',1,'2006-11-12 16:53:57'),(1012,NULL,1,9,'LEOPOLDO DE BULHES',NULL,2220,75190000,'GO','5212303',1,'2006-11-12 16:53:57'),(1013,NULL,1,9,'LUZINIA',NULL,2222,NULL,'GO','5212501',1,'2006-11-12 16:53:57'),(1014,NULL,1,9,'MAIRIPOTABA',NULL,2223,75630000,'GO','5212600',1,'2006-11-12 16:53:57'),(1015,NULL,1,9,'MAMBA',NULL,2224,73970000,'GO','5212709',1,'2006-11-12 16:53:57'),(1016,NULL,1,9,'MARA ROSA',NULL,2225,76490000,'GO','5212808',1,'2006-11-12 16:53:57'),(1017,NULL,1,9,'MARZAGO',NULL,2227,75670000,'GO','5212907',1,'2006-11-12 16:53:57'),(1018,NULL,1,9,'MATRINCH',NULL,2228,76730000,'GO','5212956',1,'2006-11-12 16:53:57'),(1019,NULL,1,9,'MAURILNDIA',NULL,2229,75930000,'GO','5213004',1,'2006-11-12 16:53:57'),(1020,NULL,1,9,'MIMOSO DE GOIS',NULL,2232,73730000,'GO','5213053',1,'2006-11-12 16:53:57'),(1021,NULL,1,9,'MINAU',NULL,2233,76450000,'GO','5213087',1,'2006-11-12 16:53:57'),(1022,NULL,1,9,'MINEIROS',NULL,2234,75830000,'GO','5213103',1,'2006-11-12 16:53:57'),(1023,NULL,1,9,'MOIPOR',NULL,2235,76135000,'GO','5213400',1,'2006-11-12 16:53:57'),(1024,NULL,1,9,'MONTE ALEGRE DE GOIS',NULL,2236,73830000,'GO','5213509',1,'2006-11-12 16:53:57'),(1025,NULL,1,9,'MONTES CLAROS DE GOIS',NULL,2237,76255000,'GO','5213707',1,'2006-11-12 16:53:58'),(1026,NULL,1,9,'MONTIVIDIU',NULL,2238,75915000,'GO','5213756',1,'2006-11-12 16:53:58'),(1027,NULL,1,9,'MONTIVIDIU DO NORTE',NULL,2239,76465000,'GO','5213772',1,'2006-11-12 16:53:58'),(1028,NULL,1,9,'MORRINHOS',NULL,2240,75650000,'GO','5213806',1,'2006-11-12 16:53:58'),(1029,NULL,1,9,'MORRO AGUDO DE GOIS',NULL,2241,76355000,'GO','5213855',1,'2006-11-12 16:53:58'),(1030,NULL,1,9,'MOSSMEDES',NULL,2242,76150000,'GO','5213905',1,'2006-11-12 16:53:58'),(1031,NULL,1,9,'MOZARLNDIA',NULL,2243,76700000,'GO','5214002',1,'2006-11-12 16:53:58'),(1032,NULL,1,9,'MUNDO NOVO',NULL,2244,76530000,'GO','5214051',1,'2006-11-12 16:53:58'),(1033,NULL,1,9,'MUTUNPOLIS',NULL,2245,76540000,'GO','5214101',1,'2006-11-12 16:53:58'),(1034,NULL,1,9,'NAZRIO',NULL,2247,76180000,'GO','5214408',1,'2006-11-12 16:53:58'),(1035,NULL,1,9,'NERPOLIS',NULL,2248,75460000,'GO','5214507',1,'2006-11-12 16:53:58'),(1036,NULL,1,9,'NIQUELNDIA',NULL,2249,76420000,'GO','5214606',1,'2006-11-12 16:53:58'),(1037,NULL,1,9,'NOVA AMRICA',NULL,2250,76345000,'GO','5214705',1,'2006-11-12 16:53:58'),(1038,NULL,1,9,'NOVA AURORA',NULL,2251,75750000,'GO','5214804',1,'2006-11-12 16:53:58'),(1039,NULL,1,9,'NOVA CRIXS',NULL,2252,76520000,'GO','5214838',1,'2006-11-12 16:53:58'),(1040,NULL,1,9,'NOVA GLRIA',NULL,2253,76305000,'GO','5214861',1,'2006-11-12 16:53:58'),(1041,NULL,1,9,'NOVA IGUAU DE GOIS',NULL,2254,76495000,'GO','5214879',1,'2006-11-12 16:53:58'),(1042,NULL,1,9,'NOVA ROMA',NULL,2255,73820000,'GO','5214903',1,'2006-11-12 16:53:58'),(1043,NULL,1,9,'NOVA VENEZA',NULL,2256,75470000,'GO','5215009',1,'2006-11-12 16:53:58'),(1044,NULL,1,9,'NOVO BRASIL',NULL,2257,76285000,'GO','5215207',1,'2006-11-12 16:53:58'),(1045,NULL,1,9,'NOVO GAMA',NULL,2258,NULL,'GO','5215231',1,'2006-11-12 16:53:58'),(1046,NULL,1,9,'NOVO PLANALTO',NULL,2259,76580000,'GO','5215256',1,'2006-11-12 16:53:58'),(1047,NULL,1,9,'ORIZONA',NULL,2262,75280000,'GO','5215306',1,'2006-11-12 16:53:59'),(1048,NULL,1,9,'OURO VERDE DE GOIS',NULL,2263,75165000,'GO','5215405',1,'2006-11-12 16:53:59'),(1049,NULL,1,9,'OUVIDOR',NULL,2265,75715000,'GO','5215504',1,'2006-11-12 16:53:59'),(1050,NULL,1,9,'PADRE BERNARDO',NULL,2266,73700000,'GO','5215603',1,'2006-11-12 16:53:59'),(1051,NULL,1,9,'PALESTINA DE GOIS',NULL,2267,75845000,'GO','5215652',1,'2006-11-12 16:53:59'),(1052,NULL,1,9,'PALMEIRAS DE GOIS',NULL,2268,76190000,'GO','5215702',1,'2006-11-12 16:53:59'),(1053,NULL,1,9,'PALMELO',NULL,2269,75210000,'GO','5215801',1,'2006-11-12 16:53:59'),(1054,NULL,1,9,'PALMINPOLIS',NULL,2270,75990000,'GO','5215900',1,'2006-11-12 16:53:59'),(1055,NULL,1,9,'PANAM',NULL,2271,75580000,'GO','5216007',1,'2006-11-12 16:53:59'),(1056,NULL,1,9,'PARANAIGUARA',NULL,2272,75880000,'GO','5216304',1,'2006-11-12 16:53:59'),(1057,NULL,1,9,'PARANA',NULL,2273,75980000,'GO','5216403',1,'2006-11-12 16:53:59'),(1058,NULL,1,9,'PEROLNDIA',NULL,2276,75823000,'GO','5216452',1,'2006-11-12 16:53:59'),(1059,NULL,1,9,'PETROLINA DE GOIS',NULL,2277,75480000,'GO','5216809',1,'2006-11-12 16:53:59'),(1060,NULL,1,9,'PILAR DE GOIS',NULL,2278,76370000,'GO','5216908',1,'2006-11-12 16:53:59'),(1061,NULL,1,9,'PIRACANJUBA',NULL,2280,75640000,'GO','5217104',1,'2006-11-12 16:53:59'),(1062,NULL,1,9,'PIRANHAS',NULL,2281,76230000,'GO','5217203',1,'2006-11-12 16:53:59'),(1063,NULL,1,9,'PIRENPOLIS',NULL,2282,72980000,'GO','5217302',1,'2006-11-12 16:53:59'),(1064,NULL,1,9,'PIRES DO RIO',NULL,2284,75200000,'GO','5217401',1,'2006-11-12 16:53:59'),(1065,NULL,1,9,'PLANALTINA DE GOIS',NULL,2285,NULL,'GO',NULL,1,'2006-11-12 16:53:59'),(1066,NULL,1,9,'PONTALINA',NULL,2286,75620000,'GO','5217708',1,'2006-11-12 16:53:59'),(1067,NULL,1,9,'PORANGATU',NULL,2287,76550000,'GO','5218003',1,'2006-11-12 16:53:59'),(1068,NULL,1,9,'PORTEIRO',NULL,2288,75603000,'GO','5218052',1,'2006-11-12 16:53:59'),(1069,NULL,1,9,'PORTELNDIA',NULL,2289,75835000,'GO','5218102',1,'2006-11-12 16:54:00'),(1070,NULL,1,9,'POSSE',NULL,2290,73900000,'GO','5218300',1,'2006-11-12 16:54:00'),(1071,NULL,1,9,'PROFESSOR JAMIL',NULL,2292,75645000,'GO','5218391',1,'2006-11-12 16:54:00'),(1072,NULL,1,9,'QUIRINPOLIS',NULL,2293,75860000,'GO','5218508',1,'2006-11-12 16:54:00'),(1073,NULL,1,9,'RIANPOLIS',NULL,2295,76315000,'GO','5218706',1,'2006-11-12 16:54:00'),(1074,NULL,1,9,'RIO QUENTE',NULL,2297,75695000,'GO','5218789',1,'2006-11-12 16:54:00'),(1075,NULL,1,9,'RIO VERDE',NULL,2298,NULL,'GO','5218805',1,'2006-11-12 16:54:00'),(1076,NULL,1,9,'CAMPO LIMPO DE GOIS',NULL,2300,75160000,'GO','5204854',1,'2006-11-12 16:54:00'),(1077,NULL,1,9,'RUBIATABA',NULL,2302,76350000,'GO','5218904',1,'2006-11-12 16:54:00'),(1078,NULL,1,9,'SANCLERLNDIA',NULL,2303,76160000,'GO','5219001',1,'2006-11-12 16:54:00'),(1079,NULL,1,9,'SANTA BRBARA DE GOIS',NULL,2304,75390000,'GO','5219100',1,'2006-11-12 16:54:00'),(1080,NULL,1,9,'SANTA CRUZ DE GOIS',NULL,2306,75220000,'GO','5219209',1,'2006-11-12 16:54:00'),(1081,NULL,1,9,'SANTA F DE GOIS',NULL,2307,76265000,'GO','5219258',1,'2006-11-12 16:54:00'),(1082,NULL,1,9,'SANTA HELENA DE GOIS',NULL,2308,75920000,'GO','5219308',1,'2006-11-12 16:54:00'),(1083,NULL,1,9,'SANTA ISABEL',NULL,2309,76320000,'GO','5219357',1,'2006-11-12 16:54:00'),(1084,NULL,1,9,'SANTA RITA DO ARAGUAIA',NULL,2310,75840000,'GO','5219407',1,'2006-11-12 16:54:00'),(1085,NULL,1,9,'SANTA RITA DO NOVO DESTINO',NULL,2311,76395000,'GO','5219456',1,'2006-11-12 16:54:00'),(1086,NULL,1,9,'SANTA ROSA DE GOIS',NULL,2313,75455000,'GO','5219506',1,'2006-11-12 16:54:00'),(1087,NULL,1,9,'SANTA TEREZA DE GOIS',NULL,2314,76480000,'GO','5219605',1,'2006-11-12 16:54:00'),(1088,NULL,1,9,'SANTA TEREZINHA DE GOIS',NULL,2315,76500000,'GO','5219704',1,'2006-11-12 16:54:00'),(1089,NULL,1,9,'SANTO ANTNIO DA BARRA',NULL,2316,75935000,'GO','5219712',1,'2006-11-12 16:54:00'),(1090,NULL,1,9,'SANTO ANTNIO DE GOIS',NULL,2317,75375000,'GO','5219738',1,'2006-11-12 16:54:00'),(1091,NULL,1,9,'SANTO ANTNIO DO DESCOBERTO',NULL,2318,72900000,'GO','5219753',1,'2006-11-12 16:54:01'),(1092,NULL,1,9,'SO DOMINGOS',NULL,2320,73860000,'GO','5219803',1,'2006-11-12 16:54:01'),(1093,NULL,1,9,'SO FRANCISCO DE GOIS',NULL,2321,75490000,'GO','5219902',1,'2006-11-12 16:54:01'),(1094,NULL,1,9,'SO JOO D\'ALIANA',NULL,2324,73760000,'GO',NULL,1,'2006-11-12 16:54:01'),(1095,NULL,1,9,'SO JOO DA PARANA',NULL,2325,75985000,'GO','5220058',1,'2006-11-12 16:54:01'),(1096,NULL,1,9,'SO LUS DE MONTES BELOS',NULL,2326,76100000,'GO','5220108',1,'2006-11-12 16:54:01'),(1097,NULL,1,9,'SO LUIZ DO NORTE',NULL,2327,76365000,'GO','5220157',1,'2006-11-12 16:54:01'),(1098,NULL,1,9,'SO MIGUEL DO ARAGUAIA',NULL,2329,76590000,'GO','5220207',1,'2006-11-12 16:54:01'),(1099,NULL,1,9,'SO MIGUEL DO PASSA QUATRO',NULL,2330,75185000,'GO','5220264',1,'2006-11-12 16:54:01'),(1100,NULL,1,9,'SO PATRCIO',NULL,2331,76343000,'GO','5220280',1,'2006-11-12 16:54:01'),(1101,NULL,1,9,'SO SIMO',NULL,2333,75890000,'GO','5220405',1,'2006-11-12 16:54:01'),(1102,NULL,1,9,'SENADOR CANEDO',NULL,2336,75250000,'GO','5220454',1,'2006-11-12 16:54:01'),(1103,NULL,1,9,'SERRANPOLIS',NULL,2338,75820000,'GO','5220504',1,'2006-11-12 16:54:01'),(1104,NULL,1,9,'SILVNIA',NULL,2339,75180000,'GO','5220603',1,'2006-11-12 16:54:01'),(1105,NULL,1,9,'SIMOLNDIA',NULL,2340,73930000,'GO','5220686',1,'2006-11-12 16:54:01'),(1106,NULL,1,9,'STIO D\'ABADIA',NULL,2341,73990000,'GO',NULL,1,'2006-11-12 16:54:01'),(1107,NULL,1,9,'TAQUARAL DE GOIS',NULL,2343,76640000,'GO','5221007',1,'2006-11-12 16:54:01'),(1108,NULL,1,9,'TERESINA DE GOIS',NULL,2345,73795000,'GO','5221080',1,'2006-11-12 16:54:01'),(1109,NULL,1,9,'TEREZPOLIS DE GOIS',NULL,2346,75175000,'GO','5221197',1,'2006-11-12 16:54:01'),(1110,NULL,1,9,'LAGOA SANTA',NULL,2347,75819000,'GO','5212253',1,'2006-11-12 16:54:02'),(1111,NULL,1,9,'TRS RANCHOS',NULL,2348,75720000,'GO','5221304',1,'2006-11-12 16:54:02'),(1112,NULL,1,9,'TRINDADE',NULL,2349,75380000,'GO','5221403',1,'2006-11-12 16:54:02'),(1113,NULL,1,9,'TROMBAS',NULL,2350,76460000,'GO','5221452',1,'2006-11-12 16:54:02'),(1114,NULL,1,9,'TURVNIA',NULL,2352,76110000,'GO','5221502',1,'2006-11-12 16:54:02'),(1115,NULL,1,9,'TURVELNDIA',NULL,2353,75970000,'GO','5221551',1,'2006-11-12 16:54:02'),(1116,NULL,1,9,'UIRAPURU',NULL,2354,76525000,'GO','5221577',1,'2006-11-12 16:54:02'),(1117,NULL,1,9,'URUAU',NULL,2355,76400000,'GO','5221601',1,'2006-11-12 16:54:02'),(1118,NULL,1,9,'URUANA',NULL,2356,76335000,'GO','5221700',1,'2006-11-12 16:54:02'),(1119,NULL,1,9,'URUTA',NULL,2358,75790000,'GO','5221809',1,'2006-11-12 16:54:02'),(1120,NULL,1,9,'VALPARASO DE GOIS',NULL,2361,NULL,'GO','5221858',1,'2006-11-12 16:54:02'),(1121,NULL,1,9,'VARJO',NULL,2362,75355000,'GO','5221908',1,'2006-11-12 16:54:02'),(1122,NULL,1,9,'VIANPOLIS',NULL,2363,75260000,'GO','5222005',1,'2006-11-12 16:54:02'),(1123,NULL,1,9,'VICENTINPOLIS',NULL,2364,75555000,'GO','5222054',1,'2006-11-12 16:54:02'),(1124,NULL,1,9,'VILA BOA',NULL,2365,73825000,'GO','5222203',1,'2006-11-12 16:54:02'),(1125,NULL,1,9,'VILA PROPCIO',NULL,2367,76393000,'GO','5222302',1,'2006-11-12 16:54:02'),(1126,NULL,1,13,'AAILNDIA',NULL,2369,65930000,'MA','2100055',1,'2006-11-12 16:54:02'),(1127,NULL,1,13,'AFONSO CUNHA',NULL,2370,65505000,'MA','2100105',1,'2006-11-12 16:54:02'),(1128,NULL,1,13,'GUA DOCE DO MARANHO',NULL,2371,65578000,'MA','2100154',1,'2006-11-12 16:54:02'),(1129,NULL,1,13,'ALCNTARA',NULL,2372,65250000,'MA','2100204',1,'2006-11-12 16:54:02'),(1130,NULL,1,13,'ALDEIAS ALTAS',NULL,2373,65610000,'MA','2100303',1,'2006-11-12 16:54:02'),(1131,NULL,1,13,'ALTAMIRA DO MARANHO',NULL,2374,65310000,'MA','2100402',1,'2006-11-12 16:54:03'),(1132,NULL,1,13,'ALTO ALEGRE DO MARANHO',NULL,2375,65413000,'MA','2100436',1,'2006-11-12 16:54:03'),(1133,NULL,1,13,'ALTO ALEGRE DO PINDAR',NULL,2376,65398000,'MA','2100477',1,'2006-11-12 16:54:03'),(1134,NULL,1,13,'ALTO PARNABA',NULL,2377,65810000,'MA','2100501',1,'2006-11-12 16:54:03'),(1135,NULL,1,13,'AMAP DO MARANHO',NULL,2378,65293000,'MA','2100550',1,'2006-11-12 16:54:03'),(1136,NULL,1,13,'AMARANTE DO MARANHO',NULL,2379,65923000,'MA','2100600',1,'2006-11-12 16:54:03'),(1137,NULL,1,13,'ANAJATUBA',NULL,2380,65490000,'MA','2100709',1,'2006-11-12 16:54:03'),(1138,NULL,1,13,'ANAPURUS',NULL,2381,65525000,'MA','2100808',1,'2006-11-12 16:54:03'),(1139,NULL,1,13,'APICUM-AU',NULL,2383,65275000,'MA','2100832',1,'2006-11-12 16:54:03'),(1140,NULL,1,13,'ARAGUAN',NULL,2384,65368000,'MA','2100873',1,'2006-11-12 16:54:03'),(1141,NULL,1,13,'ARAISES',NULL,2385,65570000,'MA','2100907',1,'2006-11-12 16:54:03'),(1142,NULL,1,13,'ARAME',NULL,2386,65945000,'MA','2100956',1,'2006-11-12 16:54:03'),(1143,NULL,1,13,'ARARI',NULL,2387,65480000,'MA','2101004',1,'2006-11-12 16:54:03'),(1144,NULL,1,13,'AXIX',NULL,2389,65108000,'MA','2101103',1,'2006-11-12 16:54:03'),(1145,NULL,1,13,'BACABAL',NULL,2390,65700000,'MA','2101202',1,'2006-11-12 16:54:03'),(1146,NULL,1,13,'BACABEIRA',NULL,2391,65103000,'MA','2101251',1,'2006-11-12 16:54:03'),(1147,NULL,1,13,'BACURI',NULL,2393,65270000,'MA','2101301',1,'2006-11-12 16:54:03'),(1148,NULL,1,13,'BACURITUBA',NULL,2394,65233000,'MA','2101350',1,'2006-11-12 16:54:03'),(1149,NULL,1,13,'BALSAS',NULL,2395,65800000,'MA','2101400',1,'2006-11-12 16:54:03'),(1150,NULL,1,13,'BARO DE GRAJA',NULL,2396,65660000,'MA','2101509',1,'2006-11-12 16:54:03'),(1151,NULL,1,13,'BARRA DO CORDA',NULL,2398,65950000,'MA','2101608',1,'2006-11-12 16:54:03'),(1152,NULL,1,13,'BARREIRINHAS',NULL,2399,65590000,'MA','2101707',1,'2006-11-12 16:54:03'),(1153,NULL,1,13,'BELA VISTA DO MARANHO',NULL,2401,65335000,'MA','2101772',1,'2006-11-12 16:54:04'),(1154,NULL,1,13,'BELAGUA',NULL,2402,65535000,'MA','2101731',1,'2006-11-12 16:54:04'),(1155,NULL,1,13,'BENEDITO LEITE',NULL,2403,65885000,'MA','2101806',1,'2006-11-12 16:54:04'),(1156,NULL,1,13,'BEQUIMO',NULL,2404,65248000,'MA','2101905',1,'2006-11-12 16:54:04'),(1157,NULL,1,13,'BERNARDO DO MEARIM',NULL,2405,65723000,'MA','2101939',1,'2006-11-12 16:54:04'),(1158,NULL,1,13,'BOA VISTA DO GURUPI',NULL,2406,65292000,'MA','2101970',1,'2006-11-12 16:54:04'),(1159,NULL,1,13,'BOM JARDIM',NULL,2408,65380000,'MA','2102002',1,'2006-11-12 16:54:04'),(1160,NULL,1,13,'BOM JESUS DAS SELVAS',NULL,2409,65395000,'MA','2102036',1,'2006-11-12 16:54:04'),(1161,NULL,1,13,'BOM LUGAR',NULL,2410,65704000,'MA','2102077',1,'2006-11-12 16:54:04'),(1162,NULL,1,13,'BREJO',NULL,2412,65520000,'MA','2102101',1,'2006-11-12 16:54:04'),(1163,NULL,1,13,'BREJO DE AREIA',NULL,2413,65315000,'MA','2102150',1,'2006-11-12 16:54:04'),(1164,NULL,1,13,'BURITI',NULL,2415,65515000,'MA','2102200',1,'2006-11-12 16:54:04'),(1165,NULL,1,13,'BURITI BRAVO',NULL,2416,65685000,'MA','2102309',1,'2006-11-12 16:54:04'),(1166,NULL,1,13,'BURITICUPU',NULL,2418,65393000,'MA','2102325',1,'2006-11-12 16:54:04'),(1167,NULL,1,13,'BURITIRAMA',NULL,2419,65935500,'MA',NULL,1,'2006-11-12 16:54:04'),(1168,NULL,1,13,'CACHOEIRA GRANDE',NULL,2420,65165000,'MA','2102374',1,'2006-11-12 16:54:04'),(1169,NULL,1,13,'CAJAPI',NULL,2421,65230000,'MA','2102408',1,'2006-11-12 16:54:04'),(1170,NULL,1,13,'CAJARI',NULL,2422,65210000,'MA','2102507',1,'2006-11-12 16:54:04'),(1171,NULL,1,13,'CAMPESTRE DO MARANHO',NULL,2423,65968000,'MA','2102556',1,'2006-11-12 16:54:04'),(1172,NULL,1,13,'CNDIDO MENDES',NULL,2424,65280000,'MA','2102606',1,'2006-11-12 16:54:04'),(1173,NULL,1,13,'CANTANHEDE',NULL,2425,65465000,'MA','2102705',1,'2006-11-12 16:54:04'),(1174,NULL,1,13,'CAPINZAL DO NORTE',NULL,2426,65735000,'MA','2102754',1,'2006-11-12 16:54:05'),(1175,NULL,1,13,'CAROLINA',NULL,2428,65980000,'MA','2102804',1,'2006-11-12 16:54:05'),(1176,NULL,1,13,'CARUTAPERA',NULL,2429,65295000,'MA','2102903',1,'2006-11-12 16:54:05'),(1177,NULL,1,13,'CAXIAS',NULL,2430,NULL,'MA','2103000',1,'2006-11-12 16:54:05'),(1178,NULL,1,13,'CEDRAL',NULL,2431,65260000,'MA','2103109',1,'2006-11-12 16:54:05'),(1179,NULL,1,13,'CENTRAL DO MARANHO',NULL,2432,65267000,'MA','2103125',1,'2006-11-12 16:54:05'),(1180,NULL,1,13,'CENTRO DO GUILHERME',NULL,2433,65288000,'MA','2103158',1,'2006-11-12 16:54:05'),(1181,NULL,1,13,'CENTRO NOVO DO MARANHO',NULL,2434,65299000,'MA','2103174',1,'2006-11-12 16:54:05'),(1182,NULL,1,13,'CHAPADINHA',NULL,2435,65500000,'MA','2103208',1,'2006-11-12 16:54:05'),(1183,NULL,1,13,'CIDELNDIA',NULL,2436,65921000,'MA','2103257',1,'2006-11-12 16:54:05'),(1184,NULL,1,13,'COD',NULL,2437,65400000,'MA','2103307',1,'2006-11-12 16:54:05'),(1185,NULL,1,13,'COELHO NETO',NULL,2439,65620000,'MA','2103406',1,'2006-11-12 16:54:05'),(1186,NULL,1,13,'COLINAS',NULL,2440,65690000,'MA','2103505',1,'2006-11-12 16:54:05'),(1187,NULL,1,13,'CONCEIO DO LAGO AU',NULL,2441,65340000,'MA',NULL,1,'2006-11-12 16:54:05'),(1188,NULL,1,13,'COROAT',NULL,2442,65415000,'MA','2103604',1,'2006-11-12 16:54:05'),(1189,NULL,1,13,'CURURUPU',NULL,2444,65268000,'MA','2103703',1,'2006-11-12 16:54:05'),(1190,NULL,1,13,'DAVINPOLIS',NULL,2447,65927000,'MA','2103752',1,'2006-11-12 16:54:05'),(1191,NULL,1,13,'DOM PEDRO',NULL,2448,65765000,'MA','2103802',1,'2006-11-12 16:54:05'),(1192,NULL,1,13,'DUQUE BACELAR',NULL,2449,65625000,'MA','2103901',1,'2006-11-12 16:54:05'),(1193,NULL,1,13,'ESPERANTINPOLIS',NULL,2450,65750000,'MA','2104008',1,'2006-11-12 16:54:05'),(1194,NULL,1,13,'ESTREITO',NULL,2452,65975000,'MA','2104057',1,'2006-11-12 16:54:06'),(1195,NULL,1,13,'FEIRA NOVA DO MARANHO',NULL,2453,65995000,'MA','2104073',1,'2006-11-12 16:54:06'),(1196,NULL,1,13,'FERNANDO FALCO',NULL,2454,65964000,'MA','2104081',1,'2006-11-12 16:54:06'),(1197,NULL,1,13,'FORMOSA DA SERRA NEGRA',NULL,2455,65943000,'MA','2104099',1,'2006-11-12 16:54:06'),(1198,NULL,1,13,'FORTALEZA DOS NOGUEIRAS',NULL,2456,65805000,'MA','2104107',1,'2006-11-12 16:54:06'),(1199,NULL,1,13,'FORTUNA',NULL,2457,65695000,'MA','2104206',1,'2006-11-12 16:54:06'),(1200,NULL,1,13,'GODOFREDO VIANA',NULL,2459,65285000,'MA','2104305',1,'2006-11-12 16:54:06'),(1201,NULL,1,13,'GONALVES DIAS',NULL,2460,65775000,'MA','2104404',1,'2006-11-12 16:54:06'),(1202,NULL,1,13,'GOVERNADOR ARCHER',NULL,2461,65770000,'MA','2104503',1,'2006-11-12 16:54:06'),(1203,NULL,1,13,'GOVERNADOR EDSON LOBO',NULL,2462,65928000,'MA',NULL,1,'2006-11-12 16:54:06'),(1204,NULL,1,13,'GOVERNADOR EUGNIO BARROS',NULL,2463,65780000,'MA','2104602',1,'2006-11-12 16:54:06'),(1205,NULL,1,13,'GOVERNADOR LUIZ ROCHA',NULL,2464,65795000,'MA','2104628',1,'2006-11-12 16:54:06'),(1206,NULL,1,13,'GOVERNADOR NEWTON BELLO',NULL,2465,65363000,'MA','2104651',1,'2006-11-12 16:54:06'),(1207,NULL,1,13,'GOVERNADOR NUNES FREIRE',NULL,2466,65284000,'MA','2104677',1,'2006-11-12 16:54:06'),(1208,NULL,1,13,'GRAA ARANHA',NULL,2467,65785000,'MA','2104701',1,'2006-11-12 16:54:06'),(1209,NULL,1,13,'GRAJA',NULL,2468,65940000,'MA','2104800',1,'2006-11-12 16:54:06'),(1210,NULL,1,13,'GUIMARES',NULL,2469,65255000,'MA','2104909',1,'2006-11-12 16:54:06'),(1211,NULL,1,13,'HUMBERTO DE CAMPOS',NULL,2470,65180000,'MA','2105005',1,'2006-11-12 16:54:06'),(1212,NULL,1,13,'ICATU',NULL,2472,65170000,'MA','2105104',1,'2006-11-12 16:54:06'),(1213,NULL,1,13,'IGARAP DO MEIO',NULL,2473,65345000,'MA','2105153',1,'2006-11-12 16:54:06'),(1214,NULL,1,13,'IGARAP GRANDE',NULL,2474,65720000,'MA','2105203',1,'2006-11-12 16:54:06'),(1215,NULL,1,13,'IMPERATRIZ',NULL,2475,NULL,'MA','2105302',1,'2006-11-12 16:54:06'),(1216,NULL,1,13,'ITAIPAVA DO GRAJA',NULL,2476,65948000,'MA','2105351',1,'2006-11-12 16:54:07'),(1217,NULL,1,13,'ITAPECURU MIRIM',NULL,2478,65485000,'MA','2105401',1,'2006-11-12 16:54:07'),(1218,NULL,1,13,'ITINGA DO MARANHO',NULL,2480,65939000,'MA','2105427',1,'2006-11-12 16:54:07'),(1219,NULL,1,13,'JATOB',NULL,2481,65693000,'MA','2105450',1,'2006-11-12 16:54:07'),(1220,NULL,1,13,'JENIPAPO DOS VIEIRAS',NULL,2482,65962000,'MA','2105476',1,'2006-11-12 16:54:07'),(1221,NULL,1,13,'JOO LISBOA',NULL,2483,65922000,'MA','2105500',1,'2006-11-12 16:54:07'),(1222,NULL,1,13,'JOSELNDIA',NULL,2484,65755000,'MA','2105609',1,'2006-11-12 16:54:07'),(1223,NULL,1,13,'JUNCO DO MARANHO',NULL,2485,65294000,'MA','2105658',1,'2006-11-12 16:54:07'),(1224,NULL,1,13,'LAGO DA PEDRA',NULL,2486,65715000,'MA','2105708',1,'2006-11-12 16:54:07'),(1225,NULL,1,13,'LAGO DO JUNCO',NULL,2487,65710000,'MA','2105807',1,'2006-11-12 16:54:07'),(1226,NULL,1,13,'LAGO DOS RODRIGUES',NULL,2488,65712000,'MA','2105948',1,'2006-11-12 16:54:07'),(1227,NULL,1,13,'LAGO VERDE',NULL,2489,65705000,'MA','2105906',1,'2006-11-12 16:54:07'),(1228,NULL,1,13,'LAGOA DO MATO',NULL,2490,65683000,'MA','2105922',1,'2006-11-12 16:54:07'),(1229,NULL,1,13,'LAGOA GRANDE DO MARANHO',NULL,2491,65718000,'MA','2105963',1,'2006-11-12 16:54:07'),(1230,NULL,1,13,'LAJEADO NOVO',NULL,2492,65937000,'MA','2105989',1,'2006-11-12 16:54:07'),(1231,NULL,1,13,'LIMA CAMPOS',NULL,2495,65728000,'MA','2106003',1,'2006-11-12 16:54:07'),(1232,NULL,1,13,'LORETO',NULL,2496,65895000,'MA','2106102',1,'2006-11-12 16:54:07'),(1233,NULL,1,13,'LUS DOMINGUES',NULL,2497,65290000,'MA','2106201',1,'2006-11-12 16:54:07'),(1234,NULL,1,13,'MAGALHES DE ALMEIDA',NULL,2498,65560000,'MA','2106300',1,'2006-11-12 16:54:07'),(1235,NULL,1,13,'MARACAUM',NULL,2500,65289000,'MA','2106326',1,'2006-11-12 16:54:08'),(1236,NULL,1,13,'MARAJ DO SENA',NULL,2501,65714000,'MA','2106359',1,'2006-11-12 16:54:08'),(1237,NULL,1,13,'MARANHOZINHO',NULL,2502,65283000,'MA','2106375',1,'2006-11-12 16:54:08'),(1238,NULL,1,13,'MATA ROMA',NULL,2505,65510000,'MA','2106409',1,'2006-11-12 16:54:08'),(1239,NULL,1,13,'MATINHA',NULL,2506,65218000,'MA','2106508',1,'2006-11-12 16:54:08'),(1240,NULL,1,13,'MATES',NULL,2507,65645000,'MA','2106607',1,'2006-11-12 16:54:08'),(1241,NULL,1,13,'MATES DO NORTE',NULL,2508,65468000,'MA','2106631',1,'2006-11-12 16:54:08'),(1242,NULL,1,13,'MILAGRES DO MARANHO',NULL,2509,65545000,'MA','2106672',1,'2006-11-12 16:54:08'),(1243,NULL,1,13,'MIRADOR',NULL,2510,65850000,'MA','2106706',1,'2006-11-12 16:54:08'),(1244,NULL,1,13,'MIRANDA DO NORTE',NULL,2511,65495000,'MA','2106755',1,'2006-11-12 16:54:08'),(1245,NULL,1,13,'MIRINZAL',NULL,2512,65265000,'MA','2106805',1,'2006-11-12 16:54:08'),(1246,NULL,1,13,'MONO',NULL,2513,65360000,'MA','2106904',1,'2006-11-12 16:54:08'),(1247,NULL,1,13,'MONTES ALTOS',NULL,2514,65936000,'MA','2107001',1,'2006-11-12 16:54:08'),(1248,NULL,1,13,'MORROS',NULL,2515,65160000,'MA','2107100',1,'2006-11-12 16:54:08'),(1249,NULL,1,13,'NINA RODRIGUES',NULL,2516,65450000,'MA','2107209',1,'2006-11-12 16:54:08'),(1250,NULL,1,13,'NOVA COLINAS',NULL,2517,65808000,'MA','2107258',1,'2006-11-12 16:54:08'),(1251,NULL,1,13,'NOVA IORQUE',NULL,2518,65880000,'MA','2107308',1,'2006-11-12 16:54:08'),(1252,NULL,1,13,'NOVA OLINDA DO MARANHO',NULL,2519,65274000,'MA','2107357',1,'2006-11-12 16:54:08'),(1253,NULL,1,13,'OLHO D\'GUA DAS CUNHS',NULL,2520,65706000,'MA',NULL,1,'2006-11-12 16:54:08'),(1254,NULL,1,13,'OLINDA NOVA DO MARANHO',NULL,2521,65223000,'MA','2107456',1,'2006-11-12 16:54:08'),(1255,NULL,1,13,'PAO DO LUMIAR',NULL,2522,65130000,'MA','2107506',1,'2006-11-12 16:54:08'),(1256,NULL,1,13,'PALMEIRNDIA',NULL,2523,65238000,'MA','2107605',1,'2006-11-12 16:54:09'),(1257,NULL,1,13,'PARAIBANO',NULL,2525,65670000,'MA','2107704',1,'2006-11-12 16:54:09'),(1258,NULL,1,13,'PARNARAMA',NULL,2526,65640000,'MA','2107803',1,'2006-11-12 16:54:09'),(1259,NULL,1,13,'PASSAGEM FRANCA',NULL,2527,65680000,'MA','2107902',1,'2006-11-12 16:54:09'),(1260,NULL,1,13,'PASTOS BONS',NULL,2528,65870000,'MA','2108009',1,'2006-11-12 16:54:09'),(1261,NULL,1,13,'PAULINO NEVES',NULL,2529,65585000,'MA','2108058',1,'2006-11-12 16:54:09'),(1262,NULL,1,13,'PAULO RAMOS',NULL,2530,65716000,'MA','2108108',1,'2006-11-12 16:54:09'),(1263,NULL,1,13,'PEDREIRAS',NULL,2531,65725000,'MA','2108207',1,'2006-11-12 16:54:09'),(1264,NULL,1,13,'PEDRO DO ROSRIO',NULL,2532,65206000,'MA','2108256',1,'2006-11-12 16:54:09'),(1265,NULL,1,13,'PENALVA',NULL,2533,65213000,'MA','2108306',1,'2006-11-12 16:54:09'),(1266,NULL,1,13,'PERI MIRIM',NULL,2534,65245000,'MA','2108405',1,'2006-11-12 16:54:09'),(1267,NULL,1,13,'PERITOR',NULL,2535,65418000,'MA','2108454',1,'2006-11-12 16:54:09'),(1268,NULL,1,13,'PINDAR MIRIM',NULL,2537,65370000,'MA',NULL,1,'2006-11-12 16:54:09'),(1269,NULL,1,13,'PINHEIRO',NULL,2538,65200000,'MA','2108603',1,'2006-11-12 16:54:09'),(1270,NULL,1,13,'PIO XII',NULL,2539,65707000,'MA','2108702',1,'2006-11-12 16:54:09'),(1271,NULL,1,13,'PIRAPEMAS',NULL,2540,65460000,'MA','2108801',1,'2006-11-12 16:54:09'),(1272,NULL,1,13,'POO DE PEDRAS',NULL,2541,65740000,'MA','2108900',1,'2006-11-12 16:54:09'),(1273,NULL,1,13,'PORTO FRANCO',NULL,2543,65970000,'MA','2109007',1,'2006-11-12 16:54:09'),(1274,NULL,1,13,'PORTO RICO DO MARANHO',NULL,2544,65263000,'MA','2109056',1,'2006-11-12 16:54:09'),(1275,NULL,1,13,'PRESIDENTE DUTRA',NULL,2545,65760000,'MA','2109106',1,'2006-11-12 16:54:09'),(1276,NULL,1,13,'PRESIDENTE JUSCELINO',NULL,2546,65140000,'MA','2109205',1,'2006-11-12 16:54:09'),(1277,NULL,1,13,'PRESIDENTE MDICI',NULL,2547,65279000,'MA','2109239',1,'2006-11-12 16:54:09'),(1278,NULL,1,13,'PRESIDENTE SARNEY',NULL,2548,65204000,'MA','2109270',1,'2006-11-12 16:54:10'),(1279,NULL,1,13,'PRESIDENTE VARGAS',NULL,2549,65455000,'MA','2109304',1,'2006-11-12 16:54:10'),(1280,NULL,1,13,'PRIMEIRA CRUZ',NULL,2550,65190000,'MA','2109403',1,'2006-11-12 16:54:10'),(1281,NULL,1,13,'RAPOSA',NULL,2551,65138000,'MA','2109452',1,'2006-11-12 16:54:10'),(1282,NULL,1,13,'RIACHO',NULL,2553,65990000,'MA','2109502',1,'2006-11-12 16:54:10'),(1283,NULL,1,13,'RIBAMAR FIQUENE',NULL,2554,65938000,'MA','2109551',1,'2006-11-12 16:54:10'),(1284,NULL,1,13,'ROSRIO',NULL,2558,65100000,'MA','2109601',1,'2006-11-12 16:54:10'),(1285,NULL,1,13,'SAMBABA',NULL,2559,65830000,'MA','2109700',1,'2006-11-12 16:54:10'),(1286,NULL,1,13,'SANTA FILOMENA DO MARANHO',NULL,2560,65768000,'MA','2109759',1,'2006-11-12 16:54:10'),(1287,NULL,1,13,'SANTA HELENA',NULL,2561,65208000,'MA','2109809',1,'2006-11-12 16:54:10'),(1288,NULL,1,13,'SANTA INS',NULL,2562,65300000,'MA','2109908',1,'2006-11-12 16:54:10'),(1289,NULL,1,13,'SANTA LUZIA',NULL,2563,65390000,'MA','2110005',1,'2006-11-12 16:54:10'),(1290,NULL,1,13,'SANTA LUZIA DO PARU',NULL,2564,65272000,'MA','2110039',1,'2006-11-12 16:54:10'),(1291,NULL,1,13,'SANTA QUITRIA DO MARANHO',NULL,2565,65540000,'MA','2110104',1,'2006-11-12 16:54:10'),(1292,NULL,1,13,'SANTA RITA',NULL,2566,65105000,'MA','2110203',1,'2006-11-12 16:54:10'),(1293,NULL,1,13,'SANTANA DO MARANHO',NULL,2567,65555000,'MA','2110237',1,'2006-11-12 16:54:10'),(1294,NULL,1,13,'SANTO AMARO',NULL,2568,65195000,'MA',NULL,1,'2006-11-12 16:54:10'),(1295,NULL,1,13,'SANTO ANTNIO DOS LOPES',NULL,2569,65730000,'MA','2110302',1,'2006-11-12 16:54:10'),(1296,NULL,1,13,'SO BENEDITO DO RIO PRETO',NULL,2570,65440000,'MA','2110401',1,'2006-11-12 16:54:10'),(1297,NULL,1,13,'SO BENTO',NULL,2571,65235000,'MA','2110500',1,'2006-11-12 16:54:10'),(1298,NULL,1,13,'SO BERNARDO',NULL,2572,65550000,'MA','2110609',1,'2006-11-12 16:54:11'),(1299,NULL,1,13,'SO DOMINGOS DO AZEITO',NULL,2573,65888000,'MA','2110658',1,'2006-11-12 16:54:11'),(1300,NULL,1,13,'SO DOMINGOS DO MARANHO',NULL,2574,65790000,'MA','2110708',1,'2006-11-12 16:54:11'),(1301,NULL,1,13,'SO FLIX DE BALSAS',NULL,2575,65890000,'MA','2110807',1,'2006-11-12 16:54:11'),(1302,NULL,1,13,'SO FRANCISCO DO BREJO',NULL,2576,65929000,'MA','2110856',1,'2006-11-12 16:54:11'),(1303,NULL,1,13,'SO FRANCISCO DO MARANHO',NULL,2577,65650000,'MA','2110906',1,'2006-11-12 16:54:11'),(1304,NULL,1,13,'SO JOO BATISTA',NULL,2578,65225000,'MA','2111003',1,'2006-11-12 16:54:11'),(1305,NULL,1,13,'SO JOO DO CAR',NULL,2580,65385000,'MA','2111029',1,'2006-11-12 16:54:11'),(1306,NULL,1,13,'SO JOO DO PARASO',NULL,2581,65973000,'MA','2111052',1,'2006-11-12 16:54:11'),(1307,NULL,1,13,'SO JOO DO STER',NULL,2582,65615000,'MA','2111078',1,'2006-11-12 16:54:11'),(1308,NULL,1,13,'SO JOO DOS PATOS',NULL,2583,65665000,'MA','2111102',1,'2006-11-12 16:54:11'),(1309,NULL,1,13,'SO JOS DE RIBAMAR',NULL,2585,65110000,'MA','2111201',1,'2006-11-12 16:54:11'),(1310,NULL,1,13,'SO JOS DOS BASLIOS',NULL,2586,65762000,'MA','2111250',1,'2006-11-12 16:54:11'),(1311,NULL,1,13,'SO LUS',NULL,2587,NULL,'MA','2111300',1,'2006-11-12 16:54:11'),(1312,NULL,1,13,'SO LUS GONZAGA DO MARANHO',NULL,2588,65708000,'MA','2111409',1,'2006-11-12 16:54:11'),(1313,NULL,1,13,'SO MATEUS DO MARANHO',NULL,2589,65470000,'MA','2111508',1,'2006-11-12 16:54:11'),(1314,NULL,1,13,'SO PEDRO DA GUA BRANCA',NULL,2590,65920000,'MA','2111532',1,'2006-11-12 16:54:11'),(1315,NULL,1,13,'SO PEDRO DOS CRENTES',NULL,2591,65978000,'MA','2111573',1,'2006-11-12 16:54:12'),(1316,NULL,1,13,'SO RAIMUNDO DAS MANGABEIRAS',NULL,2592,65840000,'MA','2111607',1,'2006-11-12 16:54:12'),(1317,NULL,1,13,'SO RAIMUNDO DO DOCA BEZERRA',NULL,2594,65753000,'MA','2111631',1,'2006-11-12 16:54:12'),(1318,NULL,1,13,'SO ROBERTO',NULL,2595,65758000,'MA','2111672',1,'2006-11-12 16:54:12'),(1319,NULL,1,13,'SO VICENTE FERRER',NULL,2596,65220000,'MA','2111706',1,'2006-11-12 16:54:12'),(1320,NULL,1,13,'SATUBINHA',NULL,2597,65709000,'MA','2111722',1,'2006-11-12 16:54:12'),(1321,NULL,1,13,'SENADOR ALEXANDRE COSTA',NULL,2598,65783000,'MA','2111748',1,'2006-11-12 16:54:12'),(1322,NULL,1,13,'SENADOR LA ROQUE',NULL,2599,65935000,'MA',NULL,1,'2006-11-12 16:54:12'),(1323,NULL,1,13,'SERRANO DO MARANHO',NULL,2600,65269000,'MA','2111789',1,'2006-11-12 16:54:12'),(1324,NULL,1,13,'STIO NOVO',NULL,2601,65925000,'MA','2111805',1,'2006-11-12 16:54:12'),(1325,NULL,1,13,'SUCUPIRA DO NORTE',NULL,2602,65860000,'MA','2111904',1,'2006-11-12 16:54:12'),(1326,NULL,1,13,'SUCUPIRA DO RIACHO',NULL,2603,65668000,'MA','2111953',1,'2006-11-12 16:54:12'),(1327,NULL,1,13,'TASSO FRAGOSO',NULL,2604,65820000,'MA','2112001',1,'2006-11-12 16:54:12'),(1328,NULL,1,13,'TIMBIRAS',NULL,2605,65420000,'MA','2112100',1,'2006-11-12 16:54:12'),(1329,NULL,1,13,'TIMON',NULL,2606,NULL,'MA','2112209',1,'2006-11-12 16:54:12'),(1330,NULL,1,13,'TRIZIDELA DO VALE',NULL,2607,65727000,'MA','2112233',1,'2006-11-12 16:54:12'),(1331,NULL,1,13,'TUFILNDIA',NULL,2608,65378000,'MA','2112274',1,'2006-11-12 16:54:12'),(1332,NULL,1,13,'TUNTUM',NULL,2609,65763000,'MA','2112308',1,'2006-11-12 16:54:12'),(1333,NULL,1,13,'TURIAU',NULL,2610,65278000,'MA','2112407',1,'2006-11-12 16:54:12'),(1334,NULL,1,13,'TURILNDIA',NULL,2611,65276000,'MA','2112456',1,'2006-11-12 16:54:12'),(1335,NULL,1,13,'TUTIA',NULL,2612,65580000,'MA','2112506',1,'2006-11-12 16:54:13'),(1336,NULL,1,13,'URBANO SANTOS',NULL,2613,65530000,'MA','2112605',1,'2006-11-12 16:54:13'),(1337,NULL,1,13,'VARGEM GRANDE',NULL,2614,65430000,'MA','2112704',1,'2006-11-12 16:54:13'),(1338,NULL,1,13,'VIANA',NULL,2615,65215000,'MA','2112803',1,'2006-11-12 16:54:13'),(1339,NULL,1,13,'VILA NOVA DOS MARTRIOS',NULL,2616,65924000,'MA','2112852',1,'2006-11-12 16:54:13'),(1340,NULL,1,13,'VITRIA DO MEARIM',NULL,2617,65350000,'MA','2112902',1,'2006-11-12 16:54:13'),(1341,NULL,1,13,'VITORINO FREIRE',NULL,2618,65320000,'MA','2113009',1,'2006-11-12 16:54:13'),(1342,NULL,1,13,'Z DOCA',NULL,2619,65365000,'MA','2114007',1,'2006-11-12 16:54:13'),(1343,NULL,1,20,'ABADIA DOS DOURADOS',NULL,2620,38540000,'MG','3100104',1,'2006-11-12 16:54:13'),(1344,NULL,1,20,'ABAET',NULL,2621,35620000,'MG','3100203',1,'2006-11-12 16:54:13'),(1345,NULL,1,20,'ABRE CAMPO',NULL,2624,35365000,'MG','3100302',1,'2006-11-12 16:54:13'),(1346,NULL,1,20,'ACAIACA',NULL,2626,35438000,'MG','3100401',1,'2006-11-12 16:54:13'),(1347,NULL,1,20,'AUCENA',NULL,2627,35150000,'MG','3100500',1,'2006-11-12 16:54:13'),(1348,NULL,1,20,'GUA BOA',NULL,2630,39790000,'MG','3100609',1,'2006-11-12 16:54:13'),(1349,NULL,1,20,'GUA COMPRIDA',NULL,2632,38110000,'MG','3100708',1,'2006-11-12 16:54:13'),(1350,NULL,1,20,'AGUANIL',NULL,2634,37273000,'MG','3100807',1,'2006-11-12 16:54:13'),(1351,NULL,1,20,'GUAS FORMOSAS',NULL,2638,39880000,'MG','3100906',1,'2006-11-12 16:54:13'),(1352,NULL,1,20,'GUAS VERMELHAS',NULL,2639,39990000,'MG','3101003',1,'2006-11-12 16:54:13'),(1353,NULL,1,20,'AIMORS',NULL,2640,35200000,'MG','3101102',1,'2006-11-12 16:54:13'),(1354,NULL,1,20,'AIURUOCA',NULL,2641,37450000,'MG','3101201',1,'2006-11-12 16:54:13'),(1355,NULL,1,20,'ALAGOA',NULL,2642,37458000,'MG','3101300',1,'2006-11-12 16:54:13'),(1356,NULL,1,20,'ALBERTINA',NULL,2643,37596000,'MG','3101409',1,'2006-11-12 16:54:14'),(1357,NULL,1,20,'ALM PARABA',NULL,2649,36660000,'MG','3101508',1,'2006-11-12 16:54:14'),(1358,NULL,1,20,'ALFENAS',NULL,2651,37130000,'MG','3101607',1,'2006-11-12 16:54:14'),(1359,NULL,1,20,'ALFREDO VASCONCELOS',NULL,2652,36272000,'MG','3101631',1,'2006-11-12 16:54:14'),(1360,NULL,1,20,'ALMENARA',NULL,2654,39900000,'MG','3101706',1,'2006-11-12 16:54:14'),(1361,NULL,1,20,'ALPERCATA',NULL,2655,35138000,'MG','3101805',1,'2006-11-12 16:54:14'),(1362,NULL,1,20,'ALPINPOLIS',NULL,2656,37940000,'MG','3101904',1,'2006-11-12 16:54:14'),(1363,NULL,1,20,'ALTEROSA',NULL,2657,37145000,'MG','3102001',1,'2006-11-12 16:54:14'),(1364,NULL,1,20,'ALTO CAPARA',NULL,2658,36836000,'MG','3102050',1,'2006-11-12 16:54:14'),(1365,NULL,1,20,'ALTO JEQUITIB',NULL,2661,36976000,'MG','3153509',1,'2006-11-12 16:54:14'),(1366,NULL,1,20,'ALTO RIO DOCE',NULL,2663,36260000,'MG','3102100',1,'2006-11-12 16:54:14'),(1367,NULL,1,20,'ALVARENGA',NULL,2666,35249000,'MG','3102209',1,'2006-11-12 16:54:14'),(1368,NULL,1,20,'ALVINPOLIS',NULL,2667,35950000,'MG','3102308',1,'2006-11-12 16:54:14'),(1369,NULL,1,20,'ALVORADA DE MINAS',NULL,2669,39140000,'MG','3102407',1,'2006-11-12 16:54:14'),(1370,NULL,1,20,'AMPARO DA SERRA',NULL,2673,35444000,'MG',NULL,1,'2006-11-12 16:54:14'),(1371,NULL,1,20,'ANDRADAS',NULL,2675,37795000,'MG','3102605',1,'2006-11-12 16:54:14'),(1372,NULL,1,20,'ANDRELNDIA',NULL,2676,37300000,'MG','3102803',1,'2006-11-12 16:54:14'),(1373,NULL,1,20,'ANGELNDIA',NULL,2679,39685000,'MG','3102852',1,'2006-11-12 16:54:14'),(1374,NULL,1,20,'ANTNIO CARLOS',NULL,2683,36220000,'MG','3102902',1,'2006-11-12 16:54:14'),(1375,NULL,1,20,'ANTNIO DIAS',NULL,2684,35177000,'MG','3103009',1,'2006-11-12 16:54:14'),(1376,NULL,1,20,'ANTNIO PRADO DE MINAS',NULL,2688,36850000,'MG','3103108',1,'2006-11-12 16:54:14'),(1377,NULL,1,20,'ARAA',NULL,2691,35777000,'MG','3103207',1,'2006-11-12 16:54:14'),(1378,NULL,1,20,'ARACITABA',NULL,2693,36255000,'MG','3103306',1,'2006-11-12 16:54:14'),(1379,NULL,1,20,'ARAUA',NULL,2694,39600000,'MG','3103405',1,'2006-11-12 16:54:15'),(1380,NULL,1,20,'ARAGUARI',NULL,2695,NULL,'MG','3103504',1,'2006-11-12 16:54:15'),(1381,NULL,1,20,'ARANTINA',NULL,2698,37360000,'MG','3103603',1,'2006-11-12 16:54:15'),(1382,NULL,1,20,'ARAPONGA',NULL,2699,36594000,'MG','3103702',1,'2006-11-12 16:54:15'),(1383,NULL,1,20,'ARAPOR',NULL,2700,38435000,'MG','3103751',1,'2006-11-12 16:54:15'),(1384,NULL,1,20,'ARAPU',NULL,2701,38860000,'MG','3103801',1,'2006-11-12 16:54:15'),(1385,NULL,1,20,'ARAJOS',NULL,2702,35603000,'MG','3103900',1,'2006-11-12 16:54:15'),(1386,NULL,1,20,'ARAX',NULL,2704,NULL,'MG','3104007',1,'2006-11-12 16:54:15'),(1387,NULL,1,20,'ARCEBURGO',NULL,2706,37820000,'MG','3104106',1,'2006-11-12 16:54:15'),(1388,NULL,1,20,'ARCOS',NULL,2707,35588000,'MG','3104205',1,'2006-11-12 16:54:15'),(1389,NULL,1,20,'AREADO',NULL,2708,37140000,'MG','3104304',1,'2006-11-12 16:54:15'),(1390,NULL,1,20,'ARGIRITA',NULL,2710,36710000,'MG','3104403',1,'2006-11-12 16:54:15'),(1391,NULL,1,20,'ARICANDUVA',NULL,2711,39678000,'MG','3104452',1,'2006-11-12 16:54:15'),(1392,NULL,1,20,'ARINOS',NULL,2712,38680000,'MG','3104502',1,'2006-11-12 16:54:15'),(1393,NULL,1,20,'ASTOLFO DUTRA',NULL,2716,36780000,'MG','3104601',1,'2006-11-12 16:54:15'),(1394,NULL,1,20,'ATALIA',NULL,2717,39850000,'MG','3104700',1,'2006-11-12 16:54:15'),(1395,NULL,1,20,'AUGUSTO DE LIMA',NULL,2718,39220000,'MG','3104809',1,'2006-11-12 16:54:15'),(1396,NULL,1,20,'BAEPENDI',NULL,2723,37443000,'MG','3104908',1,'2006-11-12 16:54:15'),(1397,NULL,1,20,'BALDIM',NULL,2728,35706000,'MG','3105004',1,'2006-11-12 16:54:15'),(1398,NULL,1,20,'BAMBU',NULL,2729,38900000,'MG','3105103',1,'2006-11-12 16:54:15'),(1399,NULL,1,20,'BANDEIRA',NULL,2730,39917000,'MG','3105202',1,'2006-11-12 16:54:15'),(1400,NULL,1,20,'BANDEIRA DO SUL',NULL,2731,37740000,'MG','3105301',1,'2006-11-12 16:54:15'),(1401,NULL,1,20,'BARO DE COCAIS',NULL,2733,35970000,'MG','3105400',1,'2006-11-12 16:54:15'),(1402,NULL,1,20,'BARO DE MONTE ALTO',NULL,2734,36870000,'MG','3105509',1,'2006-11-12 16:54:16'),(1403,NULL,1,20,'BARBACENA',NULL,2735,NULL,'MG','3105608',1,'2006-11-12 16:54:16'),(1404,NULL,1,20,'BARRA LONGA',NULL,2741,35447000,'MG','3105707',1,'2006-11-12 16:54:16'),(1405,NULL,1,20,'BARROSO',NULL,2749,36212000,'MG','3105905',1,'2006-11-12 16:54:16'),(1406,NULL,1,20,'BELA VISTA DE MINAS',NULL,2751,35938000,'MG','3106002',1,'2006-11-12 16:54:16'),(1407,NULL,1,20,'BELMIRO BRAGA',NULL,2753,36126000,'MG','3106101',1,'2006-11-12 16:54:16'),(1408,NULL,1,20,'BELO HORIZONTE',NULL,2754,NULL,'MG','3106200',1,'2006-11-12 16:54:16'),(1409,NULL,1,20,'BELO ORIENTE',NULL,2755,35195000,'MG','3106309',1,'2006-11-12 16:54:16'),(1410,NULL,1,20,'BELO VALE',NULL,2757,35473000,'MG','3106408',1,'2006-11-12 16:54:16'),(1411,NULL,1,20,'BERILO',NULL,2759,39640000,'MG','3106507',1,'2006-11-12 16:54:16'),(1412,NULL,1,20,'BERIZAL',NULL,2760,39555000,'MG','3106655',1,'2006-11-12 16:54:16'),(1413,NULL,1,20,'BERTPOLIS',NULL,2761,39875000,'MG','3106606',1,'2006-11-12 16:54:16'),(1414,NULL,1,20,'BETIM',NULL,2762,NULL,'MG','3106705',1,'2006-11-12 16:54:16'),(1415,NULL,1,20,'BIAS FORTES',NULL,2763,36230000,'MG','3106804',1,'2006-11-12 16:54:16'),(1416,NULL,1,20,'BICAS',NULL,2764,36600000,'MG','3106903',1,'2006-11-12 16:54:16'),(1417,NULL,1,20,'BIQUINHAS',NULL,2766,35621000,'MG','3107000',1,'2006-11-12 16:54:16'),(1418,NULL,1,20,'BOA ESPERANA',NULL,2768,37170000,'MG','3107109',1,'2006-11-12 16:54:16'),(1419,NULL,1,20,'BOCAINA DE MINAS',NULL,2772,37340000,'MG','3107208',1,'2006-11-12 16:54:16'),(1420,NULL,1,20,'BOCAIVA',NULL,2773,39390000,'MG','3107307',1,'2006-11-12 16:54:16'),(1421,NULL,1,20,'BOM DESPACHO',NULL,2774,35600000,'MG','3107406',1,'2006-11-12 16:54:16'),(1422,NULL,1,20,'BOM JARDIM DE MINAS',NULL,2775,37310000,'MG','3107505',1,'2006-11-12 16:54:16'),(1423,NULL,1,20,'BOM JESUS DA PENHA',NULL,2777,37948000,'MG','3107604',1,'2006-11-12 16:54:16'),(1424,NULL,1,20,'BOM JESUS DO AMPARO',NULL,2779,35908000,'MG','3107703',1,'2006-11-12 16:54:16'),(1425,NULL,1,20,'BOM JESUS DO GALHO',NULL,2781,35340000,'MG','3107802',1,'2006-11-12 16:54:17'),(1426,NULL,1,20,'BOM REPOUSO',NULL,2784,37610000,'MG','3107901',1,'2006-11-12 16:54:17'),(1427,NULL,1,20,'BOM SUCESSO',NULL,2786,37220000,'MG','3108008',1,'2006-11-12 16:54:17'),(1428,NULL,1,20,'BONFIM',NULL,2789,35521000,'MG','3108107',1,'2006-11-12 16:54:17'),(1429,NULL,1,20,'BONFINPOLIS DE MINAS',NULL,2790,38650000,'MG','3108206',1,'2006-11-12 16:54:17'),(1430,NULL,1,20,'BONITO DE MINAS',NULL,2791,39490000,'MG','3108255',1,'2006-11-12 16:54:17'),(1431,NULL,1,20,'BORDA DA MATA',NULL,2793,37564000,'MG','3108305',1,'2006-11-12 16:54:17'),(1432,NULL,1,20,'BOTELHOS',NULL,2794,37720000,'MG','3108404',1,'2006-11-12 16:54:17'),(1433,NULL,1,20,'BOTUMIRIM',NULL,2795,39596000,'MG','3108503',1,'2006-11-12 16:54:17'),(1434,NULL,1,20,'BRS PIRES',NULL,2796,36542000,'MG','3108701',1,'2006-11-12 16:54:17'),(1435,NULL,1,20,'BRASILNDIA DE MINAS',NULL,2797,38779000,'MG','3108552',1,'2006-11-12 16:54:17'),(1436,NULL,1,20,'BRASLIA DE MINAS',NULL,2798,39330000,'MG','3108602',1,'2006-11-12 16:54:17'),(1437,NULL,1,20,'BRASPOLIS',NULL,2799,37530000,'MG','3108909',1,'2006-11-12 16:54:17'),(1438,NULL,1,20,'BRANAS',NULL,2800,35169000,'MG','3108800',1,'2006-11-12 16:54:17'),(1439,NULL,1,20,'BRUMADINHO',NULL,2805,35460000,'MG','3109006',1,'2006-11-12 16:54:17'),(1440,NULL,1,20,'BUENO BRANDO',NULL,2809,37578000,'MG','3109105',1,'2006-11-12 16:54:17'),(1441,NULL,1,20,'BUENPOLIS',NULL,2810,39230000,'MG','3109204',1,'2006-11-12 16:54:17'),(1442,NULL,1,20,'BUGRE',NULL,2811,35193000,'MG','3109253',1,'2006-11-12 16:54:17'),(1443,NULL,1,20,'BURITIS',NULL,2812,38660000,'MG','3109303',1,'2006-11-12 16:54:17'),(1444,NULL,1,20,'BURITIZEIRO',NULL,2813,39280000,'MG','3109402',1,'2006-11-12 16:54:17'),(1445,NULL,1,20,'CABECEIRA GRANDE',NULL,2815,38625000,'MG','3109451',1,'2006-11-12 16:54:17'),(1446,NULL,1,20,'CABO VERDE',NULL,2816,37880000,'MG','3109501',1,'2006-11-12 16:54:17'),(1447,NULL,1,20,'CACHOEIRA DA PRATA',NULL,2821,35765000,'MG','3109600',1,'2006-11-12 16:54:17'),(1448,NULL,1,20,'CACHOEIRA DE MINAS',NULL,2822,37545000,'MG','3109709',1,'2006-11-12 16:54:18'),(1449,NULL,1,20,'CACHOEIRA DE PAJE',NULL,2823,39980000,'MG','3102704',1,'2006-11-12 16:54:18'),(1450,NULL,1,20,'CACHOEIRA DOURADA',NULL,2830,38370000,'MG','3109808',1,'2006-11-12 16:54:18'),(1451,NULL,1,20,'CAETANPOLIS',NULL,2833,35770000,'MG','3109907',1,'2006-11-12 16:54:18'),(1452,NULL,1,20,'CAET',NULL,2834,34800000,'MG','3110004',1,'2006-11-12 16:54:18'),(1453,NULL,1,20,'CAIANA',NULL,2836,36832000,'MG','3110103',1,'2006-11-12 16:54:18'),(1454,NULL,1,20,'CAJURI',NULL,2838,36560000,'MG','3110202',1,'2006-11-12 16:54:18'),(1455,NULL,1,20,'CALDAS',NULL,2839,37780000,'MG','3110301',1,'2006-11-12 16:54:18'),(1456,NULL,1,20,'CAMACHO',NULL,2841,35555000,'MG','3110400',1,'2006-11-12 16:54:18'),(1457,NULL,1,20,'CAMANDUCAIA',NULL,2842,37650000,'MG','3110509',1,'2006-11-12 16:54:18'),(1458,NULL,1,20,'CAMBU',NULL,2844,37600000,'MG','3110608',1,'2006-11-12 16:54:18'),(1459,NULL,1,20,'CAMBUQUIRA',NULL,2845,37420000,'MG','3110707',1,'2006-11-12 16:54:18'),(1460,NULL,1,20,'CAMPANRIO',NULL,2846,39835000,'MG','3110806',1,'2006-11-12 16:54:18'),(1461,NULL,1,20,'CAMPANHA',NULL,2847,37400000,'MG','3110905',1,'2006-11-12 16:54:18'),(1462,NULL,1,20,'CAMPESTRE',NULL,2848,37730000,'MG','3111002',1,'2006-11-12 16:54:18'),(1463,NULL,1,20,'CAMPINA VERDE',NULL,2850,38270000,'MG','3111101',1,'2006-11-12 16:54:18'),(1464,NULL,1,20,'CAMPO AZUL',NULL,2853,39338000,'MG','3111150',1,'2006-11-12 16:54:18'),(1465,NULL,1,20,'CAMPO BELO',NULL,2854,37270000,'MG','3111200',1,'2006-11-12 16:54:18'),(1466,NULL,1,20,'CAMPO DO MEIO',NULL,2855,37165000,'MG','3111309',1,'2006-11-12 16:54:18'),(1467,NULL,1,20,'CAMPO FLORIDO',NULL,2856,38130000,'MG','3111408',1,'2006-11-12 16:54:18'),(1468,NULL,1,20,'CAMPOS ALTOS',NULL,2859,38970000,'MG','3111507',1,'2006-11-12 16:54:18'),(1469,NULL,1,20,'CAMPOS GERAIS',NULL,2860,37160000,'MG','3111606',1,'2006-11-12 16:54:18'),(1470,NULL,1,20,'CANA VERDE',NULL,2861,37267000,'MG','3111903',1,'2006-11-12 16:54:18'),(1471,NULL,1,20,'CANA',NULL,2862,36592000,'MG','3111705',1,'2006-11-12 16:54:19'),(1472,NULL,1,20,'CANPOLIS',NULL,2865,38380000,'MG','3111804',1,'2006-11-12 16:54:19'),(1473,NULL,1,20,'CANDEIAS',NULL,2867,37280000,'MG','3112000',1,'2006-11-12 16:54:19'),(1474,NULL,1,20,'CANTAGALO',NULL,2869,39703000,'MG','3112059',1,'2006-11-12 16:54:19'),(1475,NULL,1,20,'CAPARA',NULL,2870,36834000,'MG','3112109',1,'2006-11-12 16:54:19'),(1476,NULL,1,20,'CAPELA NOVA',NULL,2871,36290000,'MG','3112208',1,'2006-11-12 16:54:19'),(1477,NULL,1,20,'CAPELINHA',NULL,2872,39680000,'MG','3112307',1,'2006-11-12 16:54:19'),(1478,NULL,1,20,'CAPETINGA',NULL,2873,37993000,'MG','3112406',1,'2006-11-12 16:54:19'),(1479,NULL,1,20,'CAPIM BRANCO',NULL,2874,35730000,'MG','3112505',1,'2006-11-12 16:54:19'),(1480,NULL,1,20,'CAPINPOLIS',NULL,2875,38360000,'MG','3112604',1,'2006-11-12 16:54:19'),(1481,NULL,1,20,'CAPITO ANDRADE',NULL,2877,35123000,'MG','3112653',1,'2006-11-12 16:54:19'),(1482,NULL,1,20,'CAPITO ENAS',NULL,2878,39445000,'MG','3112703',1,'2006-11-12 16:54:19'),(1483,NULL,1,20,'CAPITLIO',NULL,2879,37930000,'MG','3112802',1,'2006-11-12 16:54:19'),(1484,NULL,1,20,'CAPUTIRA',NULL,2880,36925000,'MG','3112901',1,'2006-11-12 16:54:19'),(1485,NULL,1,20,'CARA',NULL,2881,39810000,'MG','3113008',1,'2006-11-12 16:54:19'),(1486,NULL,1,20,'CARANABA',NULL,2882,36428000,'MG','3113107',1,'2006-11-12 16:54:19'),(1487,NULL,1,20,'CARANDA',NULL,2883,36280000,'MG','3113206',1,'2006-11-12 16:54:19'),(1488,NULL,1,20,'CARANGOLA',NULL,2884,36800000,'MG','3113305',1,'2006-11-12 16:54:19'),(1489,NULL,1,20,'CARATINGA',NULL,2885,NULL,'MG','3113404',1,'2006-11-12 16:54:19'),(1490,NULL,1,20,'CARBONITA',NULL,2886,39665000,'MG','3113503',1,'2006-11-12 16:54:19'),(1491,NULL,1,20,'CAREAU',NULL,2888,37556000,'MG','3113602',1,'2006-11-12 16:54:19'),(1492,NULL,1,20,'CARLOS CHAGAS',NULL,2891,39864000,'MG','3113701',1,'2006-11-12 16:54:19'),(1493,NULL,1,20,'CARMSIA',NULL,2892,35878000,'MG','3113800',1,'2006-11-12 16:54:19'),(1494,NULL,1,20,'CARMO DA CACHOEIRA',NULL,2893,37225000,'MG','3113909',1,'2006-11-12 16:54:20'),(1495,NULL,1,20,'CARMO DA MATA',NULL,2894,35547000,'MG','3114006',1,'2006-11-12 16:54:20'),(1496,NULL,1,20,'CARMO DE MINAS',NULL,2895,37472000,'MG','3114105',1,'2006-11-12 16:54:20'),(1497,NULL,1,20,'CARMO DO CAJURU',NULL,2896,35510000,'MG','3114204',1,'2006-11-12 16:54:20'),(1498,NULL,1,20,'CARMO DO PARANABA',NULL,2897,38840000,'MG','3114303',1,'2006-11-12 16:54:20'),(1499,NULL,1,20,'CARMO DO RIO CLARO',NULL,2898,37150000,'MG','3114402',1,'2006-11-12 16:54:20'),(1500,NULL,1,20,'CARMPOLIS DE MINAS',NULL,2899,35534000,'MG','3114501',1,'2006-11-12 16:54:20'),(1501,NULL,1,20,'CARNEIRINHO',NULL,2900,38290000,'MG','3114550',1,'2006-11-12 16:54:20'),(1502,NULL,1,20,'CARRANCAS',NULL,2901,37245000,'MG','3114600',1,'2006-11-12 16:54:20'),(1503,NULL,1,20,'CARVALHPOLIS',NULL,2903,37760000,'MG','3114709',1,'2006-11-12 16:54:20'),(1504,NULL,1,20,'CARVALHOS',NULL,2904,37456000,'MG','3114808',1,'2006-11-12 16:54:20'),(1505,NULL,1,20,'CASA GRANDE',NULL,2905,36422000,'MG','3114907',1,'2006-11-12 16:54:20'),(1506,NULL,1,20,'CASCALHO RICO',NULL,2906,38460000,'MG','3115003',1,'2006-11-12 16:54:20'),(1507,NULL,1,20,'CSSIA',NULL,2907,37980000,'MG','3115102',1,'2006-11-12 16:54:20'),(1508,NULL,1,20,'CATAGUASES',NULL,2909,NULL,'MG','3115300',1,'2006-11-12 16:54:20'),(1509,NULL,1,20,'CATAS ALTAS',NULL,2911,35969000,'MG','3115359',1,'2006-11-12 16:54:20'),(1510,NULL,1,20,'CATAS ALTAS DA NORUEGA',NULL,2912,36450000,'MG','3115409',1,'2006-11-12 16:54:20'),(1511,NULL,1,20,'CATUJI',NULL,2914,39816000,'MG','3115458',1,'2006-11-12 16:54:20'),(1512,NULL,1,20,'CATUTI',NULL,2917,39526000,'MG','3115474',1,'2006-11-12 16:54:20'),(1513,NULL,1,20,'CAXAMBU',NULL,2918,37440000,'MG','3115508',1,'2006-11-12 16:54:20'),(1514,NULL,1,20,'CEDRO DO ABAET',NULL,2919,35624000,'MG','3115607',1,'2006-11-12 16:54:20'),(1515,NULL,1,20,'CENTRAL DE MINAS',NULL,2921,35260000,'MG','3115706',1,'2006-11-12 16:54:20'),(1516,NULL,1,20,'CENTRALINA',NULL,2923,38390000,'MG','3115805',1,'2006-11-12 16:54:21'),(1517,NULL,1,20,'CHCARA',NULL,2925,36110000,'MG','3115904',1,'2006-11-12 16:54:21'),(1518,NULL,1,20,'CHAL',NULL,2926,36985000,'MG','3116001',1,'2006-11-12 16:54:21'),(1519,NULL,1,20,'CHAPADA DO NORTE',NULL,2928,39648000,'MG','3116100',1,'2006-11-12 16:54:21'),(1520,NULL,1,20,'CHAPADA GACHA',NULL,2929,39314000,'MG','3116159',1,'2006-11-12 16:54:21'),(1521,NULL,1,20,'CHIADOR',NULL,2931,36630000,'MG','3116209',1,'2006-11-12 16:54:21'),(1522,NULL,1,20,'CIPOTNEA',NULL,2934,36265000,'MG','3116308',1,'2006-11-12 16:54:21'),(1523,NULL,1,20,'CLARAVAL',NULL,2937,37997000,'MG','3116407',1,'2006-11-12 16:54:21'),(1524,NULL,1,20,'CLARO DOS POES',NULL,2939,39380000,'MG','3116506',1,'2006-11-12 16:54:21'),(1525,NULL,1,20,'CLUDIO',NULL,2940,35530000,'MG','3116605',1,'2006-11-12 16:54:21'),(1526,NULL,1,20,'COIMBRA',NULL,2944,36550000,'MG','3116704',1,'2006-11-12 16:54:21'),(1527,NULL,1,20,'COLUNA',NULL,2945,39770000,'MG','3116803',1,'2006-11-12 16:54:21'),(1528,NULL,1,20,'COMENDADOR GOMES',NULL,2946,38250000,'MG','3116902',1,'2006-11-12 16:54:21'),(1529,NULL,1,20,'COMERCINHO',NULL,2947,39628000,'MG','3117009',1,'2006-11-12 16:54:21'),(1530,NULL,1,20,'CONCEIO DA APARECIDA',NULL,2948,37148000,'MG','3117108',1,'2006-11-12 16:54:21'),(1531,NULL,1,20,'CONCEIO DA BARRA DE MINAS',NULL,2949,36360000,'MG','3115201',1,'2006-11-12 16:54:21'),(1532,NULL,1,20,'CONCEIO DAS ALAGOAS',NULL,2953,38120000,'MG','3117306',1,'2006-11-12 16:54:21'),(1533,NULL,1,20,'CONCEIO DAS PEDRAS',NULL,2954,37527000,'MG','3117207',1,'2006-11-12 16:54:21'),(1534,NULL,1,20,'CONCEIO DE IPANEMA',NULL,2955,36947000,'MG','3117405',1,'2006-11-12 16:54:21'),(1535,NULL,1,20,'CONCEIO DO MATO DENTRO',NULL,2962,35860000,'MG','3117504',1,'2006-11-12 16:54:21'),(1536,NULL,1,20,'CONCEIO DO PAR',NULL,2963,35668000,'MG','3117603',1,'2006-11-12 16:54:21'),(1537,NULL,1,20,'CONCEIO DO RIO VERDE',NULL,2965,37430000,'MG','3117702',1,'2006-11-12 16:54:21'),(1538,NULL,1,20,'CONCEIO DOS OUROS',NULL,2966,37548000,'MG','3117801',1,'2006-11-12 16:54:21'),(1539,NULL,1,20,'CNEGO MARINHO',NULL,2970,39489000,'MG','3117836',1,'2006-11-12 16:54:21'),(1540,NULL,1,20,'CONFINS',NULL,2971,33500000,'MG','3117876',1,'2006-11-12 16:54:22'),(1541,NULL,1,20,'CONGONHAL',NULL,2972,37557000,'MG','3117900',1,'2006-11-12 16:54:22'),(1542,NULL,1,20,'CONGONHAS',NULL,2973,36415000,'MG','3118007',1,'2006-11-12 16:54:22'),(1543,NULL,1,20,'CONGONHAS DO NORTE',NULL,2974,35850000,'MG','3118106',1,'2006-11-12 16:54:22'),(1544,NULL,1,20,'CONQUISTA',NULL,2975,38195000,'MG','3118205',1,'2006-11-12 16:54:22'),(1545,NULL,1,20,'CONSELHEIRO LAFAIETE',NULL,2976,36400000,'MG','3118304',1,'2006-11-12 16:54:22'),(1546,NULL,1,20,'CONSELHEIRO PENA',NULL,2978,35240000,'MG','3118403',1,'2006-11-12 16:54:22'),(1547,NULL,1,20,'CONSOLAO',NULL,2979,37670000,'MG','3118502',1,'2006-11-12 16:54:22'),(1548,NULL,1,20,'CONTAGEM',NULL,2980,NULL,'MG','3118601',1,'2006-11-12 16:54:22'),(1549,NULL,1,20,'COQUEIRAL',NULL,2983,37235000,'MG','3118700',1,'2006-11-12 16:54:22'),(1550,NULL,1,20,'CORAO DE JESUS',NULL,2984,39340000,'MG','3118809',1,'2006-11-12 16:54:22'),(1551,NULL,1,20,'CORDISBURGO',NULL,2985,35780000,'MG','3118908',1,'2006-11-12 16:54:22'),(1552,NULL,1,20,'CORDISLNDIA',NULL,2986,37498000,'MG','3119005',1,'2006-11-12 16:54:22'),(1553,NULL,1,20,'CORINTO',NULL,2987,39200000,'MG','3119104',1,'2006-11-12 16:54:22'),(1554,NULL,1,20,'COROACI',NULL,2988,39710000,'MG','3119203',1,'2006-11-12 16:54:22'),(1555,NULL,1,20,'COROMANDEL',NULL,2989,38550000,'MG','3119302',1,'2006-11-12 16:54:22'),(1556,NULL,1,20,'CORONEL FABRICIANO',NULL,2990,NULL,'MG','3119401',1,'2006-11-12 16:54:22'),(1557,NULL,1,20,'CORONEL MURTA',NULL,2991,39635000,'MG','3119500',1,'2006-11-12 16:54:22'),(1558,NULL,1,20,'CORONEL PACHECO',NULL,2992,36155000,'MG','3119609',1,'2006-11-12 16:54:22'),(1559,NULL,1,20,'CORONEL XAVIER CHAVES',NULL,2993,36330000,'MG','3119708',1,'2006-11-12 16:54:23'),(1560,NULL,1,20,'CRREGO DANTA',NULL,2994,38990000,'MG','3119807',1,'2006-11-12 16:54:23'),(1561,NULL,1,20,'CRREGO DO BOM JESUS',NULL,2996,37605000,'MG','3119906',1,'2006-11-12 16:54:23'),(1562,NULL,1,20,'CRREGO FUNDO',NULL,2998,35578000,'MG','3119955',1,'2006-11-12 16:54:23'),(1563,NULL,1,20,'CRREGO NOVO',NULL,2999,35345000,'MG','3120003',1,'2006-11-12 16:54:23'),(1564,NULL,1,20,'COUTO DE MAGALHES DE MINAS',NULL,3006,39188000,'MG','3120102',1,'2006-11-12 16:54:23'),(1565,NULL,1,20,'CRISLITA',NULL,3008,39885000,'MG','3120151',1,'2006-11-12 16:54:23'),(1566,NULL,1,20,'CRISTAIS',NULL,3010,37275000,'MG','3120201',1,'2006-11-12 16:54:23'),(1567,NULL,1,20,'CRISTLIA',NULL,3011,39598000,'MG','3120300',1,'2006-11-12 16:54:23'),(1568,NULL,1,20,'CRISTIANO OTONI',NULL,3012,36426000,'MG','3120409',1,'2006-11-12 16:54:23'),(1569,NULL,1,20,'CRISTINA',NULL,3013,37476000,'MG','3120508',1,'2006-11-12 16:54:23'),(1570,NULL,1,20,'CRUCILNDIA',NULL,3014,35520000,'MG','3120607',1,'2006-11-12 16:54:23'),(1571,NULL,1,20,'CRUZEIRO DA FORTALEZA',NULL,3015,38735000,'MG','3120706',1,'2006-11-12 16:54:23'),(1572,NULL,1,20,'CRUZLIA',NULL,3017,37445000,'MG','3120805',1,'2006-11-12 16:54:23'),(1573,NULL,1,20,'CUPARAQUE',NULL,3020,35246000,'MG','3120839',1,'2006-11-12 16:54:23'),(1574,NULL,1,20,'CURRAL DE DENTRO',NULL,3022,39998000,'MG','3120870',1,'2006-11-12 16:54:23'),(1575,NULL,1,20,'CURVELO',NULL,3023,35790000,'MG','3120904',1,'2006-11-12 16:54:23'),(1576,NULL,1,20,'DATAS',NULL,3024,39130000,'MG','3121001',1,'2006-11-12 16:54:23'),(1577,NULL,1,20,'DELFIM MOREIRA',NULL,3025,37514000,'MG','3121100',1,'2006-11-12 16:54:23'),(1578,NULL,1,20,'DELFINPOLIS',NULL,3026,37910000,'MG','3121209',1,'2006-11-12 16:54:23'),(1579,NULL,1,20,'DELTA',NULL,3027,38108000,'MG','3121258',1,'2006-11-12 16:54:23'),(1580,NULL,1,20,'DESCOBERTO',NULL,3030,36690000,'MG','3121308',1,'2006-11-12 16:54:23'),(1581,NULL,1,20,'DESTERRO DE ENTRE RIOS',NULL,3033,35494000,'MG','3121407',1,'2006-11-12 16:54:23'),(1582,NULL,1,20,'DESTERRO DO MELO',NULL,3034,36210000,'MG','3121506',1,'2006-11-12 16:54:24'),(1583,NULL,1,20,'DIAMANTINA',NULL,3036,39100000,'MG','3121605',1,'2006-11-12 16:54:24'),(1584,NULL,1,20,'DIOGO DE VASCONCELOS',NULL,3039,35437000,'MG','3121704',1,'2006-11-12 16:54:24'),(1585,NULL,1,20,'DIONSIO',NULL,3040,35984000,'MG','3121803',1,'2006-11-12 16:54:24'),(1586,NULL,1,20,'DIVINSIA',NULL,3041,36546000,'MG','3121902',1,'2006-11-12 16:54:24'),(1587,NULL,1,20,'DIVINO',NULL,3042,36820000,'MG','3122009',1,'2006-11-12 16:54:24'),(1588,NULL,1,20,'DIVINO DAS LARANJEIRAS',NULL,3043,35265000,'MG','3122108',1,'2006-11-12 16:54:24'),(1589,NULL,1,20,'DIVINOLNDIA DE MINAS',NULL,3046,39735000,'MG','3122207',1,'2006-11-12 16:54:24'),(1590,NULL,1,20,'DIVINPOLIS',NULL,3047,NULL,'MG','3122306',1,'2006-11-12 16:54:24'),(1591,NULL,1,20,'DIVISA ALEGRE',NULL,3048,39995000,'MG','3122355',1,'2006-11-12 16:54:24'),(1592,NULL,1,20,'DIVISA NOVA',NULL,3049,37134000,'MG','3122405',1,'2006-11-12 16:54:24'),(1593,NULL,1,20,'DIVISPOLIS',NULL,3050,39912000,'MG','3122454',1,'2006-11-12 16:54:24'),(1594,NULL,1,20,'DOM BOSCO',NULL,3052,38654000,'MG','3122470',1,'2006-11-12 16:54:24'),(1595,NULL,1,20,'DOM CAVATI',NULL,3053,35148000,'MG','3122504',1,'2006-11-12 16:54:24'),(1596,NULL,1,20,'DOM JOAQUIM',NULL,3054,35865000,'MG','3122603',1,'2006-11-12 16:54:24'),(1597,NULL,1,20,'DOM SILVRIO',NULL,3057,35440000,'MG','3122702',1,'2006-11-12 16:54:24'),(1598,NULL,1,20,'DOM VIOSO',NULL,3058,37474000,'MG','3122801',1,'2006-11-12 16:54:24'),(1599,NULL,1,20,'DONA EUZBIA',NULL,3059,36784000,'MG',NULL,1,'2006-11-12 16:54:24'),(1600,NULL,1,20,'DORES DE CAMPOS',NULL,3061,36213000,'MG','3123007',1,'2006-11-12 16:54:24'),(1601,NULL,1,20,'DORES DE GUANHES',NULL,3062,35894000,'MG','3123106',1,'2006-11-12 16:54:24'),(1602,NULL,1,20,'DORES DO INDAI',NULL,3063,35610000,'MG','3123205',1,'2006-11-12 16:54:24'),(1603,NULL,1,20,'DORES DO TURVO',NULL,3065,36513000,'MG','3123304',1,'2006-11-12 16:54:24'),(1604,NULL,1,20,'DORESPOLIS',NULL,3066,37926000,'MG','3123403',1,'2006-11-12 16:54:24'),(1605,NULL,1,20,'DOURADOQUARA',NULL,3068,38530000,'MG','3123502',1,'2006-11-12 16:54:24'),(1606,NULL,1,20,'DURAND',NULL,3071,36974000,'MG','3123528',1,'2006-11-12 16:54:25'),(1607,NULL,1,20,'ELI MENDES',NULL,3073,37110000,'MG','3123601',1,'2006-11-12 16:54:25'),(1608,NULL,1,20,'ENGENHEIRO CALDAS',NULL,3075,35130000,'MG','3123700',1,'2006-11-12 16:54:25'),(1609,NULL,1,20,'ENGENHEIRO NAVARRO',NULL,3077,39417000,'MG','3123809',1,'2006-11-12 16:54:25'),(1610,NULL,1,20,'ENTRE FOLHAS',NULL,3081,35324000,'MG','3123858',1,'2006-11-12 16:54:25'),(1611,NULL,1,20,'ENTRE RIOS DE MINAS',NULL,3082,35490000,'MG','3123908',1,'2006-11-12 16:54:25'),(1612,NULL,1,20,'ERVLIA',NULL,3085,36555000,'MG','3124005',1,'2006-11-12 16:54:25'),(1613,NULL,1,20,'ESMERALDAS',NULL,3086,35740000,'MG','3124104',1,'2006-11-12 16:54:25'),(1614,NULL,1,20,'ESPERA FELIZ',NULL,3088,36830000,'MG','3124203',1,'2006-11-12 16:54:25'),(1615,NULL,1,20,'ESPINOSA',NULL,3089,39510000,'MG','3124302',1,'2006-11-12 16:54:25'),(1616,NULL,1,20,'ESPRITO SANTO DO DOURADO',NULL,3090,37566000,'MG','3124401',1,'2006-11-12 16:54:25'),(1617,NULL,1,20,'ESTIVA',NULL,3093,37542000,'MG','3124500',1,'2006-11-12 16:54:25'),(1618,NULL,1,20,'ESTRELA DALVA',NULL,3095,36725000,'MG','3124609',1,'2006-11-12 16:54:25'),(1619,NULL,1,20,'ESTRELA DO INDAI',NULL,3097,35613000,'MG','3124708',1,'2006-11-12 16:54:25'),(1620,NULL,1,20,'ESTRELA DO SUL',NULL,3098,38525000,'MG','3124807',1,'2006-11-12 16:54:25'),(1621,NULL,1,20,'EUGENPOLIS',NULL,3099,36855000,'MG','3124906',1,'2006-11-12 16:54:25'),(1622,NULL,1,20,'EWBANK DA CMARA',NULL,3101,36108000,'MG','3125002',1,'2006-11-12 16:54:25'),(1623,NULL,1,20,'EXTREMA',NULL,3104,37640000,'MG','3125101',1,'2006-11-12 16:54:25'),(1624,NULL,1,20,'FAMA',NULL,3105,37138000,'MG','3125200',1,'2006-11-12 16:54:25'),(1625,NULL,1,20,'FARIA LEMOS',NULL,3106,36840000,'MG','3125309',1,'2006-11-12 16:54:25'),(1626,NULL,1,20,'FELCIO DOS SANTOS',NULL,3110,39180000,'MG','3125408',1,'2006-11-12 16:54:25'),(1627,NULL,1,20,'FELISBURGO',NULL,3111,39895000,'MG','3125606',1,'2006-11-12 16:54:26'),(1628,NULL,1,20,'FELIXLNDIA',NULL,3112,35794000,'MG','3125705',1,'2006-11-12 16:54:26'),(1629,NULL,1,20,'FERNANDES TOURINHO',NULL,3113,35135000,'MG','3125804',1,'2006-11-12 16:54:26'),(1630,NULL,1,20,'FERROS',NULL,3117,35800000,'MG','3125903',1,'2006-11-12 16:54:26'),(1631,NULL,1,20,'FERVEDOURO',NULL,3119,36815000,'MG','3125952',1,'2006-11-12 16:54:26'),(1632,NULL,1,20,'FLORESTAL',NULL,3125,35690000,'MG','3126000',1,'2006-11-12 16:54:26'),(1633,NULL,1,20,'FORMIGA',NULL,3128,35570000,'MG','3126109',1,'2006-11-12 16:54:26'),(1634,NULL,1,20,'FORMOSO',NULL,3129,38690000,'MG','3126208',1,'2006-11-12 16:54:26'),(1635,NULL,1,20,'FORTALEZA DE MINAS',NULL,3130,37905000,'MG','3126307',1,'2006-11-12 16:54:26'),(1636,NULL,1,20,'FORTUNA DE MINAS',NULL,3131,35760000,'MG','3126406',1,'2006-11-12 16:54:26'),(1637,NULL,1,20,'FRANCISCO BADAR',NULL,3132,39644000,'MG','3126505',1,'2006-11-12 16:54:26'),(1638,NULL,1,20,'FRANCISCO DUMONT',NULL,3133,39387000,'MG','3126604',1,'2006-11-12 16:54:26'),(1639,NULL,1,20,'FRANCISCO S',NULL,3134,39580000,'MG','3126703',1,'2006-11-12 16:54:26'),(1640,NULL,1,20,'FRANCISCPOLIS',NULL,3135,39695000,'MG','3126752',1,'2006-11-12 16:54:26'),(1641,NULL,1,20,'FREI GASPAR',NULL,3137,39840000,'MG','3126802',1,'2006-11-12 16:54:26'),(1642,NULL,1,20,'FREI INOCNCIO',NULL,3138,35112000,'MG','3126901',1,'2006-11-12 16:54:26'),(1643,NULL,1,20,'FREI LAGONEGRO',NULL,3139,39708000,'MG','3126950',1,'2006-11-12 16:54:26'),(1644,NULL,1,20,'FRONTEIRA',NULL,3143,38230000,'MG','3127008',1,'2006-11-12 16:54:26'),(1645,NULL,1,20,'FRONTEIRA DOS VALES',NULL,3144,39870000,'MG','3127057',1,'2006-11-12 16:54:26'),(1646,NULL,1,20,'FRUTA DE LEITE',NULL,3145,39558000,'MG','3127073',1,'2006-11-12 16:54:26'),(1647,NULL,1,20,'FRUTAL',NULL,3146,38200000,'MG','3127107',1,'2006-11-12 16:54:26'),(1648,NULL,1,20,'FUNILNDIA',NULL,3148,35709000,'MG','3127206',1,'2006-11-12 16:54:27'),(1649,NULL,1,20,'GALILIA',NULL,3153,35250000,'MG','3127305',1,'2006-11-12 16:54:27'),(1650,NULL,1,20,'GAMELEIRAS',NULL,3155,39505000,'MG','3127339',1,'2006-11-12 16:54:27'),(1651,NULL,1,20,'GLAUCILNDIA',NULL,3158,39592000,'MG','3127354',1,'2006-11-12 16:54:27'),(1652,NULL,1,20,'GOIABEIRA',NULL,3161,35248000,'MG','3127370',1,'2006-11-12 16:54:27'),(1653,NULL,1,20,'GOIAN',NULL,3162,36152000,'MG','3127388',1,'2006-11-12 16:54:27'),(1654,NULL,1,20,'GONALVES',NULL,3164,37680000,'MG','3127404',1,'2006-11-12 16:54:27'),(1655,NULL,1,20,'GONZAGA',NULL,3165,39720000,'MG','3127503',1,'2006-11-12 16:54:27'),(1656,NULL,1,20,'GOUVA',NULL,3168,39120000,'MG',NULL,1,'2006-11-12 16:54:27'),(1657,NULL,1,20,'GOVERNADOR VALADARES',NULL,3169,NULL,'MG','3127701',1,'2006-11-12 16:54:27'),(1658,NULL,1,20,'GRO MOGOL',NULL,3172,39570000,'MG','3127800',1,'2006-11-12 16:54:27'),(1659,NULL,1,20,'GRUPIARA',NULL,3174,38470000,'MG','3127909',1,'2006-11-12 16:54:27'),(1660,NULL,1,20,'GUANHES',NULL,3177,39740000,'MG','3128006',1,'2006-11-12 16:54:27'),(1661,NULL,1,20,'GUAP',NULL,3178,37177000,'MG','3128105',1,'2006-11-12 16:54:27'),(1662,NULL,1,20,'GUARACIABA',NULL,3179,35436000,'MG','3128204',1,'2006-11-12 16:54:27'),(1663,NULL,1,20,'GUARACIAMA',NULL,3180,39397000,'MG','3128253',1,'2006-11-12 16:54:27'),(1664,NULL,1,20,'GUARANSIA',NULL,3181,37810000,'MG','3128303',1,'2006-11-12 16:54:27'),(1665,NULL,1,20,'GUARANI',NULL,3182,36160000,'MG','3128402',1,'2006-11-12 16:54:27'),(1666,NULL,1,20,'GUARAR',NULL,3184,36606000,'MG','3128501',1,'2006-11-12 16:54:27'),(1667,NULL,1,20,'GUARDA-MOR',NULL,3187,38570000,'MG','3128600',1,'2006-11-12 16:54:27'),(1668,NULL,1,20,'GUAXUP',NULL,3190,37800000,'MG','3128709',1,'2006-11-12 16:54:27'),(1669,NULL,1,20,'GUIDOVAL',NULL,3191,36515000,'MG','3128808',1,'2006-11-12 16:54:27'),(1670,NULL,1,20,'GUIMARNIA',NULL,3192,38730000,'MG','3128907',1,'2006-11-12 16:54:28'),(1671,NULL,1,20,'GUIRICEMA',NULL,3194,36525000,'MG','3129004',1,'2006-11-12 16:54:28'),(1672,NULL,1,20,'GURINHAT',NULL,3195,38310000,'MG','3129103',1,'2006-11-12 16:54:28'),(1673,NULL,1,20,'HELIODORA',NULL,3196,37484000,'MG','3129202',1,'2006-11-12 16:54:28'),(1674,NULL,1,20,'IAPU',NULL,3200,35190000,'MG','3129301',1,'2006-11-12 16:54:28'),(1675,NULL,1,20,'IBERTIOGA',NULL,3201,36225000,'MG','3129400',1,'2006-11-12 16:54:28'),(1676,NULL,1,20,'IBI',NULL,3202,38950000,'MG','3129509',1,'2006-11-12 16:54:28'),(1677,NULL,1,20,'IBIA',NULL,3203,39350000,'MG','3129608',1,'2006-11-12 16:54:28'),(1678,NULL,1,20,'IBIRACATU',NULL,3204,39455000,'MG','3129657',1,'2006-11-12 16:54:28'),(1679,NULL,1,20,'IBIRACI',NULL,3205,37990000,'MG','3129707',1,'2006-11-12 16:54:28'),(1680,NULL,1,20,'IBIRIT',NULL,3206,32400000,'MG','3129806',1,'2006-11-12 16:54:28'),(1681,NULL,1,20,'IBITIRA DE MINAS',NULL,3208,37790000,'MG','3129905',1,'2006-11-12 16:54:28'),(1682,NULL,1,20,'IBITURUNA',NULL,3209,37223000,'MG','3130002',1,'2006-11-12 16:54:28'),(1683,NULL,1,20,'ICARA DE MINAS',NULL,3210,39318000,'MG','3130051',1,'2006-11-12 16:54:28'),(1684,NULL,1,20,'IGARAP',NULL,3211,32900000,'MG','3130101',1,'2006-11-12 16:54:28'),(1685,NULL,1,20,'IGARATINGA',NULL,3212,35695000,'MG','3130200',1,'2006-11-12 16:54:28'),(1686,NULL,1,20,'IGUATAMA',NULL,3213,38910000,'MG','3130309',1,'2006-11-12 16:54:28'),(1687,NULL,1,20,'IJACI',NULL,3214,37205000,'MG','3130408',1,'2006-11-12 16:54:28'),(1688,NULL,1,20,'ILICNEA',NULL,3216,37175000,'MG','3130507',1,'2006-11-12 16:54:28'),(1689,NULL,1,20,'IMB DE MINAS',NULL,3217,35323000,'MG','3130556',1,'2006-11-12 16:54:28'),(1690,NULL,1,20,'INCONFIDENTES',NULL,3218,37576000,'MG','3130606',1,'2006-11-12 16:54:28'),(1691,NULL,1,20,'INDAIABIRA',NULL,3219,39536000,'MG','3130655',1,'2006-11-12 16:54:28'),(1692,NULL,1,20,'INDIANPOLIS',NULL,3221,38490000,'MG','3130705',1,'2006-11-12 16:54:29'),(1693,NULL,1,20,'INGA',NULL,3222,37215000,'MG','3130804',1,'2006-11-12 16:54:29'),(1694,NULL,1,20,'INHAPIM',NULL,3224,35330000,'MG','3130903',1,'2006-11-12 16:54:29'),(1695,NULL,1,20,'INHAMA',NULL,3225,35710000,'MG','3131000',1,'2006-11-12 16:54:29'),(1696,NULL,1,20,'INIMUTABA',NULL,3226,35796000,'MG','3131109',1,'2006-11-12 16:54:29'),(1697,NULL,1,20,'IPABA',NULL,3227,35198000,'MG','3131158',1,'2006-11-12 16:54:29'),(1698,NULL,1,20,'IPANEMA',NULL,3228,36950000,'MG','3131208',1,'2006-11-12 16:54:29'),(1699,NULL,1,20,'IPATINGA',NULL,3229,NULL,'MG','3131307',1,'2006-11-12 16:54:29'),(1700,NULL,1,20,'IPIAU',NULL,3230,38350000,'MG','3131406',1,'2006-11-12 16:54:29'),(1701,NULL,1,20,'IPUINA',NULL,3232,37559000,'MG','3131505',1,'2006-11-12 16:54:29'),(1702,NULL,1,20,'IRA DE MINAS',NULL,3233,38510000,'MG','3131604',1,'2006-11-12 16:54:29'),(1703,NULL,1,20,'ITABIRA',NULL,3234,NULL,'MG','3131703',1,'2006-11-12 16:54:29'),(1704,NULL,1,20,'ITABIRINHA DE MANTENA',NULL,3235,35280000,'MG',NULL,1,'2006-11-12 16:54:29'),(1705,NULL,1,20,'ITABIRITO',NULL,3236,35450000,'MG','3131901',1,'2006-11-12 16:54:29'),(1706,NULL,1,20,'ITACAMBIRA',NULL,3238,39594000,'MG','3132008',1,'2006-11-12 16:54:29'),(1707,NULL,1,20,'ITACARAMBI',NULL,3239,39470000,'MG','3132107',1,'2006-11-12 16:54:29'),(1708,NULL,1,20,'ITAGUARA',NULL,3242,35514000,'MG','3132206',1,'2006-11-12 16:54:29'),(1709,NULL,1,20,'ITAIP',NULL,3244,39815000,'MG','3132305',1,'2006-11-12 16:54:29'),(1710,NULL,1,20,'ITAJUB',NULL,3245,NULL,'MG','3132404',1,'2006-11-12 16:54:29'),(1711,NULL,1,20,'ITAMARANDIBA',NULL,3247,39670000,'MG','3132503',1,'2006-11-12 16:54:29'),(1712,NULL,1,20,'ITAMARATI DE MINAS',NULL,3249,36788000,'MG','3132602',1,'2006-11-12 16:54:29'),(1713,NULL,1,20,'ITAMBACURI',NULL,3250,39830000,'MG','3132701',1,'2006-11-12 16:54:29'),(1714,NULL,1,20,'ITAMB DO MATO DENTRO',NULL,3251,35820000,'MG','3132800',1,'2006-11-12 16:54:30'),(1715,NULL,1,20,'ITAMOGI',NULL,3253,37955000,'MG','3132909',1,'2006-11-12 16:54:30'),(1716,NULL,1,20,'ITAMONTE',NULL,3254,37466000,'MG','3133006',1,'2006-11-12 16:54:30'),(1717,NULL,1,20,'ITANHANDU',NULL,3256,37464000,'MG','3133105',1,'2006-11-12 16:54:30'),(1718,NULL,1,20,'ITANHOMI',NULL,3257,35120000,'MG','3133204',1,'2006-11-12 16:54:30'),(1719,NULL,1,20,'ITAOBIM',NULL,3258,39625000,'MG','3133303',1,'2006-11-12 16:54:30'),(1720,NULL,1,20,'ITAPAGIPE',NULL,3259,38240000,'MG','3133402',1,'2006-11-12 16:54:30'),(1721,NULL,1,20,'ITAPECERICA',NULL,3261,35550000,'MG','3133501',1,'2006-11-12 16:54:30'),(1722,NULL,1,20,'ITAPEVA',NULL,3262,37655000,'MG','3133600',1,'2006-11-12 16:54:30'),(1723,NULL,1,20,'ITATIAIUU',NULL,3265,35685000,'MG','3133709',1,'2006-11-12 16:54:30'),(1724,NULL,1,20,'ITA DE MINAS',NULL,3266,37975000,'MG','3133758',1,'2006-11-12 16:54:30'),(1725,NULL,1,20,'ITANA',NULL,3267,NULL,'MG','3133808',1,'2006-11-12 16:54:30'),(1726,NULL,1,20,'ITAVERAVA',NULL,3269,36440000,'MG','3133907',1,'2006-11-12 16:54:30'),(1727,NULL,1,20,'ITINGA',NULL,3271,39610000,'MG','3134004',1,'2006-11-12 16:54:30'),(1728,NULL,1,20,'ITUETA',NULL,3273,35220000,'MG','3134103',1,'2006-11-12 16:54:30'),(1729,NULL,1,20,'ITUIUTABA',NULL,3275,NULL,'MG','3134202',1,'2006-11-12 16:54:30'),(1730,NULL,1,20,'ITUMIRIM',NULL,3276,37210000,'MG','3134301',1,'2006-11-12 16:54:30'),(1731,NULL,1,20,'ITURAMA',NULL,3277,38280000,'MG','3134400',1,'2006-11-12 16:54:30'),(1732,NULL,1,20,'ITUTINGA',NULL,3278,36390000,'MG','3134509',1,'2006-11-12 16:54:30'),(1733,NULL,1,20,'JABOTICATUBAS',NULL,3279,35830000,'MG','3134608',1,'2006-11-12 16:54:30'),(1734,NULL,1,20,'JACINTO',NULL,3282,39930000,'MG','3134707',1,'2006-11-12 16:54:30'),(1735,NULL,1,20,'JACU',NULL,3283,37965000,'MG','3134806',1,'2006-11-12 16:54:30'),(1736,NULL,1,20,'JACUTINGA',NULL,3284,37590000,'MG','3134905',1,'2006-11-12 16:54:31'),(1737,NULL,1,20,'JAGUARAU',NULL,3285,35188000,'MG','3135001',1,'2006-11-12 16:54:31'),(1738,NULL,1,20,'JABA',NULL,3288,39508000,'MG','3135050',1,'2006-11-12 16:54:31'),(1739,NULL,1,20,'JAMPRUCA',NULL,3289,39837000,'MG','3135076',1,'2006-11-12 16:54:31'),(1740,NULL,1,20,'JANABA',NULL,3290,39440000,'MG','3135100',1,'2006-11-12 16:54:31'),(1741,NULL,1,20,'JANURIA',NULL,3291,39480000,'MG','3135209',1,'2006-11-12 16:54:31'),(1742,NULL,1,20,'JAPARABA',NULL,3292,35580000,'MG','3135308',1,'2006-11-12 16:54:31'),(1743,NULL,1,20,'JAPONVAR',NULL,3293,39335000,'MG','3135357',1,'2006-11-12 16:54:31'),(1744,NULL,1,20,'JECEABA',NULL,3295,35498000,'MG','3135407',1,'2006-11-12 16:54:31'),(1745,NULL,1,20,'JENIPAPO DE MINAS',NULL,3296,39645000,'MG','3135456',1,'2006-11-12 16:54:31'),(1746,NULL,1,20,'JEQUERI',NULL,3297,35390000,'MG','3135506',1,'2006-11-12 16:54:31'),(1747,NULL,1,20,'JEQUITA',NULL,3298,39370000,'MG','3135605',1,'2006-11-12 16:54:31'),(1748,NULL,1,20,'JEQUITIB',NULL,3299,35767000,'MG','3135704',1,'2006-11-12 16:54:31'),(1749,NULL,1,20,'JEQUITINHONHA',NULL,3300,39960000,'MG','3135803',1,'2006-11-12 16:54:31'),(1750,NULL,1,20,'JESUNIA',NULL,3301,37485000,'MG','3135902',1,'2006-11-12 16:54:31'),(1751,NULL,1,20,'JOAMA',NULL,3302,39890000,'MG','3136009',1,'2006-11-12 16:54:31'),(1752,NULL,1,20,'JOANSIA',NULL,3303,35168000,'MG','3136108',1,'2006-11-12 16:54:31'),(1753,NULL,1,20,'JOO MONLEVADE',NULL,3304,NULL,'MG','3136207',1,'2006-11-12 16:54:31'),(1754,NULL,1,20,'JOO PINHEIRO',NULL,3305,38770000,'MG','3136306',1,'2006-11-12 16:54:31'),(1755,NULL,1,20,'JOAQUIM FELCIO',NULL,3306,39240000,'MG','3136405',1,'2006-11-12 16:54:31'),(1756,NULL,1,20,'JORDNIA',NULL,3307,39920000,'MG','3136504',1,'2006-11-12 16:54:31'),(1757,NULL,1,20,'JOS GONALVES DE MINAS',NULL,3308,39642000,'MG','3136520',1,'2006-11-12 16:54:32'),(1758,NULL,1,20,'JOS RAYDAN',NULL,3309,39775000,'MG','3136553',1,'2006-11-12 16:54:32'),(1759,NULL,1,20,'JOSENPOLIS',NULL,3311,39575000,'MG','3136579',1,'2006-11-12 16:54:32'),(1760,NULL,1,20,'JUATUBA',NULL,3312,35675000,'MG','3136652',1,'2006-11-12 16:54:32'),(1761,NULL,1,20,'JUIZ DE FORA',NULL,3315,NULL,'MG','3136702',1,'2006-11-12 16:54:32'),(1762,NULL,1,20,'JURAMENTO',NULL,3317,39590000,'MG','3136801',1,'2006-11-12 16:54:32'),(1763,NULL,1,20,'JURUAIA',NULL,3319,37805000,'MG','3136900',1,'2006-11-12 16:54:32'),(1764,NULL,1,20,'JUVENLIA',NULL,3322,39467000,'MG','3136959',1,'2006-11-12 16:54:32'),(1765,NULL,1,20,'LADAINHA',NULL,3324,39825000,'MG','3137007',1,'2006-11-12 16:54:32'),(1766,NULL,1,20,'LAGAMAR',NULL,3325,38785000,'MG','3137106',1,'2006-11-12 16:54:32'),(1767,NULL,1,20,'LAGOA DA PRATA',NULL,3327,35590000,'MG','3137205',1,'2006-11-12 16:54:32'),(1768,NULL,1,20,'LAGOA DOS PATOS',NULL,3328,39360000,'MG','3137304',1,'2006-11-12 16:54:32'),(1769,NULL,1,20,'LAGOA DOURADA',NULL,3329,36345000,'MG','3137403',1,'2006-11-12 16:54:32'),(1770,NULL,1,20,'LAGOA FORMOSA',NULL,3330,38720000,'MG','3137502',1,'2006-11-12 16:54:32'),(1771,NULL,1,20,'LAGOA GRANDE',NULL,3331,38755000,'MG','3137536',1,'2006-11-12 16:54:32'),(1772,NULL,1,20,'LAGOA SANTA',NULL,3332,33400000,'MG','3137601',1,'2006-11-12 16:54:32'),(1773,NULL,1,20,'LAJINHA',NULL,3333,36980000,'MG','3137700',1,'2006-11-12 16:54:32'),(1774,NULL,1,20,'LAMBARI',NULL,3334,37480000,'MG','3137809',1,'2006-11-12 16:54:32'),(1775,NULL,1,20,'LAMIM',NULL,3335,36455000,'MG','3137908',1,'2006-11-12 16:54:33'),(1776,NULL,1,20,'LARANJAL',NULL,3338,36760000,'MG','3138005',1,'2006-11-12 16:54:33'),(1777,NULL,1,20,'LASSANCE',NULL,3340,39250000,'MG','3138104',1,'2006-11-12 16:54:33'),(1778,NULL,1,20,'LAVRAS',NULL,3341,37200000,'MG','3138203',1,'2006-11-12 16:54:33'),(1779,NULL,1,20,'LEANDRO FERREIRA',NULL,3342,35657000,'MG','3138302',1,'2006-11-12 16:54:33'),(1780,NULL,1,20,'LEME DO PRADO',NULL,3343,39655000,'MG','3138351',1,'2006-11-12 16:54:33'),(1781,NULL,1,20,'LEOPOLDINA',NULL,3344,36700000,'MG','3138401',1,'2006-11-12 16:54:33'),(1782,NULL,1,20,'LIBERDADE',NULL,3346,37350000,'MG','3138500',1,'2006-11-12 16:54:33'),(1783,NULL,1,20,'LIMA DUARTE',NULL,3347,36140000,'MG','3138609',1,'2006-11-12 16:54:33'),(1784,NULL,1,20,'LIMEIRA D\'OESTE',NULL,3348,38295000,'MG',NULL,1,'2006-11-12 16:54:33'),(1785,NULL,1,20,'LONTRA',NULL,3351,39437000,'MG','3138658',1,'2006-11-12 16:54:33'),(1786,NULL,1,20,'LUISBURGO',NULL,3354,36923000,'MG','3138674',1,'2006-11-12 16:54:33'),(1787,NULL,1,20,'LUISLNDIA',NULL,3355,39336000,'MG','3138682',1,'2006-11-12 16:54:33'),(1788,NULL,1,20,'LUMINRIAS',NULL,3358,37240000,'MG','3138708',1,'2006-11-12 16:54:33'),(1789,NULL,1,20,'LUZ',NULL,3360,35595000,'MG','3138807',1,'2006-11-12 16:54:33'),(1790,NULL,1,20,'MACHACALIS',NULL,3362,39873000,'MG','3138906',1,'2006-11-12 16:54:33'),(1791,NULL,1,20,'MACHADO',NULL,3363,37750000,'MG','3139003',1,'2006-11-12 16:54:33'),(1792,NULL,1,20,'MADRE DE DEUS DE MINAS',NULL,3366,37305000,'MG','3139102',1,'2006-11-12 16:54:33'),(1793,NULL,1,20,'MALACACHETA',NULL,3370,39690000,'MG','3139201',1,'2006-11-12 16:54:33'),(1794,NULL,1,20,'MAMONAS',NULL,3371,39516000,'MG','3139250',1,'2006-11-12 16:54:33'),(1795,NULL,1,20,'MANGA',NULL,3372,39460000,'MG','3139300',1,'2006-11-12 16:54:33'),(1796,NULL,1,20,'MANHUAU',NULL,3373,36900000,'MG','3139409',1,'2006-11-12 16:54:33'),(1797,NULL,1,20,'MANHUMIRIM',NULL,3374,36970000,'MG','3139508',1,'2006-11-12 16:54:33'),(1798,NULL,1,20,'MANTENA',NULL,3375,35290000,'MG','3139607',1,'2006-11-12 16:54:34'),(1799,NULL,1,20,'MAR DE ESPANHA',NULL,3378,36640000,'MG','3139805',1,'2006-11-12 16:54:34'),(1800,NULL,1,20,'MARAVILHAS',NULL,3380,35666000,'MG','3139706',1,'2006-11-12 16:54:34'),(1801,NULL,1,20,'MARIA DA F',NULL,3381,37517000,'MG','3139904',1,'2006-11-12 16:54:34'),(1802,NULL,1,20,'MARIANA',NULL,3382,35420000,'MG','3140001',1,'2006-11-12 16:54:34'),(1803,NULL,1,20,'MARILAC',NULL,3383,35115000,'MG','3140100',1,'2006-11-12 16:54:34'),(1804,NULL,1,20,'MRIO CAMPOS',NULL,3385,32470000,'MG','3140159',1,'2006-11-12 16:54:34'),(1805,NULL,1,20,'MARIP DE MINAS',NULL,3386,36608000,'MG','3140209',1,'2006-11-12 16:54:34'),(1806,NULL,1,20,'MARLIRIA',NULL,3387,35185000,'MG','3140308',1,'2006-11-12 16:54:34'),(1807,NULL,1,20,'MARMELPOLIS',NULL,3388,37516000,'MG','3140407',1,'2006-11-12 16:54:34'),(1808,NULL,1,20,'MARTINHO CAMPOS',NULL,3390,35606000,'MG','3140506',1,'2006-11-12 16:54:34'),(1809,NULL,1,20,'MARTINS SOARES',NULL,3392,36972000,'MG','3140530',1,'2006-11-12 16:54:34'),(1810,NULL,1,20,'MATA VERDE',NULL,3393,39915000,'MG','3140555',1,'2006-11-12 16:54:34'),(1811,NULL,1,20,'MATERLNDIA',NULL,3394,39755000,'MG','3140605',1,'2006-11-12 16:54:34'),(1812,NULL,1,20,'MATEUS LEME',NULL,3395,35670000,'MG','3140704',1,'2006-11-12 16:54:34'),(1813,NULL,1,20,'MATHIAS LOBATO',NULL,3396,35110000,'MG','3171501',1,'2006-11-12 16:54:34'),(1814,NULL,1,20,'MATIAS BARBOSA',NULL,3397,36120000,'MG','3140803',1,'2006-11-12 16:54:34'),(1815,NULL,1,20,'MATIAS CARDOSO',NULL,3398,39478000,'MG','3140852',1,'2006-11-12 16:54:34'),(1816,NULL,1,20,'MATIP',NULL,3399,35367000,'MG','3140902',1,'2006-11-12 16:54:34'),(1817,NULL,1,20,'MATO VERDE',NULL,3400,39527000,'MG','3141009',1,'2006-11-12 16:54:34'),(1818,NULL,1,20,'MATOZINHOS',NULL,3401,35720000,'MG','3141108',1,'2006-11-12 16:54:34'),(1819,NULL,1,20,'MATUTINA',NULL,3402,38870000,'MG','3141207',1,'2006-11-12 16:54:34'),(1820,NULL,1,20,'MEDEIROS',NULL,3403,38930000,'MG','3141306',1,'2006-11-12 16:54:35'),(1821,NULL,1,20,'MEDINA',NULL,3404,39620000,'MG','3141405',1,'2006-11-12 16:54:35'),(1822,NULL,1,20,'MENDES PIMENTEL',NULL,3407,35270000,'MG','3141504',1,'2006-11-12 16:54:35'),(1823,NULL,1,20,'MERCS',NULL,3409,36190000,'MG','3141603',1,'2006-11-12 16:54:35'),(1824,NULL,1,20,'MESQUITA',NULL,3411,35166000,'MG','3141702',1,'2006-11-12 16:54:35'),(1825,NULL,1,20,'MINAS NOVAS',NULL,3416,39650000,'MG','3141801',1,'2006-11-12 16:54:35'),(1826,NULL,1,20,'MINDURI',NULL,3417,37447000,'MG','3141900',1,'2006-11-12 16:54:35'),(1827,NULL,1,20,'MIRABELA',NULL,3418,39420000,'MG','3142007',1,'2006-11-12 16:54:35'),(1828,NULL,1,20,'MIRADOURO',NULL,3419,36893000,'MG','3142106',1,'2006-11-12 16:54:35'),(1829,NULL,1,20,'MIRA',NULL,3421,36790000,'MG','3142205',1,'2006-11-12 16:54:35'),(1830,NULL,1,20,'MIRAVNIA',NULL,3425,39465000,'MG','3142254',1,'2006-11-12 16:54:35'),(1831,NULL,1,20,'MOEDA',NULL,3429,35470000,'MG','3142304',1,'2006-11-12 16:54:35'),(1832,NULL,1,20,'MOEMA',NULL,3430,35604000,'MG','3142403',1,'2006-11-12 16:54:35'),(1833,NULL,1,20,'MONJOLOS',NULL,3432,39215000,'MG','3142502',1,'2006-11-12 16:54:35'),(1834,NULL,1,20,'MONSENHOR PAULO',NULL,3436,37405000,'MG','3142601',1,'2006-11-12 16:54:35'),(1835,NULL,1,20,'MONTALVNIA',NULL,3437,39495000,'MG','3142700',1,'2006-11-12 16:54:35'),(1836,NULL,1,20,'MONTE ALEGRE DE MINAS',NULL,3438,38420000,'MG','3142809',1,'2006-11-12 16:54:35'),(1837,NULL,1,20,'MONTE AZUL',NULL,3439,39500000,'MG','3142908',1,'2006-11-12 16:54:35'),(1838,NULL,1,20,'MONTE BELO',NULL,3440,37115000,'MG','3143005',1,'2006-11-12 16:54:35'),(1839,NULL,1,20,'MONTE CARMELO',NULL,3441,38500000,'MG','3143104',1,'2006-11-12 16:54:35'),(1840,NULL,1,20,'MONTE FORMOSO',NULL,3443,39893000,'MG','3143153',1,'2006-11-12 16:54:35'),(1841,NULL,1,20,'MONTE SANTO DE MINAS',NULL,3445,37958000,'MG','3143203',1,'2006-11-12 16:54:35'),(1842,NULL,1,20,'MONTE SIO',NULL,3446,37580000,'MG','3143401',1,'2006-11-12 16:54:35'),(1843,NULL,1,20,'MONTES CLAROS',NULL,3448,NULL,'MG','3143302',1,'2006-11-12 16:54:36'),(1844,NULL,1,20,'MONTEZUMA',NULL,3449,39547000,'MG','3143450',1,'2006-11-12 16:54:36'),(1845,NULL,1,20,'MORADA NOVA DE MINAS',NULL,3450,35628000,'MG','3143500',1,'2006-11-12 16:54:36'),(1846,NULL,1,20,'MORRO DA GARA',NULL,3452,35798000,'MG','3143609',1,'2006-11-12 16:54:36'),(1847,NULL,1,20,'MORRO DO PILAR',NULL,3454,35875000,'MG','3143708',1,'2006-11-12 16:54:36'),(1848,NULL,1,20,'MUNHOZ',NULL,3458,37620000,'MG','3143807',1,'2006-11-12 16:54:36'),(1849,NULL,1,20,'MURIA',NULL,3460,36880000,'MG','3143906',1,'2006-11-12 16:54:36'),(1850,NULL,1,20,'MUTUM',NULL,3461,36955000,'MG','3144003',1,'2006-11-12 16:54:36'),(1851,NULL,1,20,'MUZAMBINHO',NULL,3462,37890000,'MG','3144102',1,'2006-11-12 16:54:36'),(1852,NULL,1,20,'NACIP RAYDAN',NULL,3463,39718000,'MG','3144201',1,'2006-11-12 16:54:36'),(1853,NULL,1,20,'NANUQUE',NULL,3464,39860000,'MG','3144300',1,'2006-11-12 16:54:36'),(1854,NULL,1,20,'NAQUE',NULL,3465,35157000,'MG','3144359',1,'2006-11-12 16:54:36'),(1855,NULL,1,20,'NATALNDIA',NULL,3467,38658000,'MG','3144375',1,'2006-11-12 16:54:36'),(1856,NULL,1,20,'NATRCIA',NULL,3468,37524000,'MG','3144409',1,'2006-11-12 16:54:36'),(1857,NULL,1,20,'NAZARENO',NULL,3470,36370000,'MG','3144508',1,'2006-11-12 16:54:36'),(1858,NULL,1,20,'NEPOMUCENO',NULL,3473,37250000,'MG','3144607',1,'2006-11-12 16:54:36'),(1859,NULL,1,20,'NINHEIRA',NULL,3476,39553000,'MG','3144656',1,'2006-11-12 16:54:36'),(1860,NULL,1,20,'NOVA BELM',NULL,3477,35298000,'MG','3144672',1,'2006-11-12 16:54:36'),(1861,NULL,1,20,'NOVA ERA',NULL,3478,35920000,'MG','3144706',1,'2006-11-12 16:54:36'),(1862,NULL,1,20,'NOVA LIMA',NULL,3480,34000000,'MG','3144805',1,'2006-11-12 16:54:36'),(1863,NULL,1,20,'NOVA MDICA',NULL,3482,35113000,'MG','3144904',1,'2006-11-12 16:54:36'),(1864,NULL,1,20,'NOVA PONTE',NULL,3483,38160000,'MG','3145000',1,'2006-11-12 16:54:36'),(1865,NULL,1,20,'NOVA PORTEIRINHA',NULL,3484,39525000,'MG','3145059',1,'2006-11-12 16:54:36'),(1866,NULL,1,20,'NOVA RESENDE',NULL,3485,37860000,'MG','3145109',1,'2006-11-12 16:54:37'),(1867,NULL,1,20,'NOVA SERRANA',NULL,3486,35519000,'MG','3145208',1,'2006-11-12 16:54:37'),(1868,NULL,1,20,'NOVA UNIO',NULL,3487,34990000,'MG','3136603',1,'2006-11-12 16:54:37'),(1869,NULL,1,20,'NOVO CRUZEIRO',NULL,3489,39820000,'MG','3145307',1,'2006-11-12 16:54:37'),(1870,NULL,1,20,'NOVO ORIENTE DE MINAS',NULL,3491,39817000,'MG','3145356',1,'2006-11-12 16:54:37'),(1871,NULL,1,20,'NOVORIZONTE',NULL,3492,39568000,'MG','3145372',1,'2006-11-12 16:54:37'),(1872,NULL,1,20,'OLARIA',NULL,3494,36145000,'MG','3145406',1,'2006-11-12 16:54:37'),(1873,NULL,1,20,'OLHOS D\' GUA',NULL,3497,39398000,'MG',NULL,1,'2006-11-12 16:54:37'),(1874,NULL,1,20,'OLMPIO NORONHA',NULL,3499,37488000,'MG','3145505',1,'2006-11-12 16:54:37'),(1875,NULL,1,20,'OLIVEIRA',NULL,3500,35540000,'MG','3145604',1,'2006-11-12 16:54:37'),(1876,NULL,1,20,'OLIVEIRA FORTES',NULL,3501,36250000,'MG','3145703',1,'2006-11-12 16:54:37'),(1877,NULL,1,20,'ONA DE PITANGUI',NULL,3502,35655000,'MG','3145802',1,'2006-11-12 16:54:37'),(1878,NULL,1,20,'ORATRIOS',NULL,3503,35439000,'MG','3145851',1,'2006-11-12 16:54:37'),(1879,NULL,1,20,'ORIZNIA',NULL,3504,36828000,'MG','3145877',1,'2006-11-12 16:54:37'),(1880,NULL,1,20,'OURO BRANCO',NULL,3505,36420000,'MG','3145901',1,'2006-11-12 16:54:37'),(1881,NULL,1,20,'OURO FINO',NULL,3506,37570000,'MG','3146008',1,'2006-11-12 16:54:37'),(1882,NULL,1,20,'OURO PRETO',NULL,3507,35400000,'MG','3146107',1,'2006-11-12 16:54:37'),(1883,NULL,1,20,'OURO VERDE DE MINAS',NULL,3508,39855000,'MG','3146206',1,'2006-11-12 16:54:37'),(1884,NULL,1,20,'PADRE CARVALHO',NULL,3511,39573000,'MG','3146255',1,'2006-11-12 16:54:37'),(1885,NULL,1,20,'PADRE PARASO',NULL,3516,39818000,'MG','3146305',1,'2006-11-12 16:54:37'),(1886,NULL,1,20,'PAI PEDRO',NULL,3519,39517000,'MG','3146552',1,'2006-11-12 16:54:37'),(1887,NULL,1,20,'PAINEIRAS',NULL,3520,35622000,'MG','3146404',1,'2006-11-12 16:54:37'),(1888,NULL,1,20,'PAINS',NULL,3521,35582000,'MG','3146503',1,'2006-11-12 16:54:37'),(1889,NULL,1,20,'PAIVA',NULL,3523,36195000,'MG','3146602',1,'2006-11-12 16:54:38'),(1890,NULL,1,20,'PALMA',NULL,3524,36750000,'MG','3146701',1,'2006-11-12 16:54:38'),(1891,NULL,1,20,'PALMPOLIS',NULL,3528,39945000,'MG','3146750',1,'2006-11-12 16:54:38'),(1892,NULL,1,20,'PAPAGAIOS',NULL,3530,35669000,'MG','3146909',1,'2006-11-12 16:54:38'),(1893,NULL,1,20,'PAR DE MINAS',NULL,3531,NULL,'MG','3147105',1,'2006-11-12 16:54:38'),(1894,NULL,1,20,'PARACATU',NULL,3532,38600000,'MG','3147006',1,'2006-11-12 16:54:38'),(1895,NULL,1,20,'PARAGUAU',NULL,3533,37120000,'MG','3147204',1,'2006-11-12 16:54:38'),(1896,NULL,1,20,'PARAISPOLIS',NULL,3536,37660000,'MG','3147303',1,'2006-11-12 16:54:38'),(1897,NULL,1,20,'PARAOPEBA',NULL,3537,35774000,'MG','3147402',1,'2006-11-12 16:54:38'),(1898,NULL,1,20,'PASSA QUATRO',NULL,3542,37460000,'MG','3147600',1,'2006-11-12 16:54:38'),(1899,NULL,1,20,'PASSA TEMPO',NULL,3543,35537000,'MG','3147709',1,'2006-11-12 16:54:38'),(1900,NULL,1,20,'PASSA VINTE',NULL,3544,37330000,'MG',NULL,1,'2006-11-12 16:54:38'),(1901,NULL,1,20,'PASSABM',NULL,3545,35810000,'MG','3147501',1,'2006-11-12 16:54:38'),(1902,NULL,1,20,'PASSOS',NULL,3547,NULL,'MG','3147907',1,'2006-11-12 16:54:38'),(1903,NULL,1,20,'PATIS',NULL,3548,39425000,'MG','3147956',1,'2006-11-12 16:54:38'),(1904,NULL,1,20,'PATOS DE MINAS',NULL,3549,NULL,'MG','3148004',1,'2006-11-12 16:54:38'),(1905,NULL,1,20,'PATROCNIO',NULL,3551,38740000,'MG','3148103',1,'2006-11-12 16:54:38'),(1906,NULL,1,20,'PATROCNIO DO MURIA',NULL,3552,36860000,'MG','3148202',1,'2006-11-12 16:54:38'),(1907,NULL,1,20,'PAULA CNDIDO',NULL,3553,36544000,'MG','3148301',1,'2006-11-12 16:54:38'),(1908,NULL,1,20,'PAULISTAS',NULL,3555,39765000,'MG','3148400',1,'2006-11-12 16:54:38'),(1909,NULL,1,20,'PAVO',NULL,3556,39814000,'MG','3148509',1,'2006-11-12 16:54:38'),(1910,NULL,1,20,'PEANHA',NULL,3558,39700000,'MG','3148608',1,'2006-11-12 16:54:38'),(1911,NULL,1,20,'PEDRA AZUL',NULL,3559,39970000,'MG','3148707',1,'2006-11-12 16:54:38'),(1912,NULL,1,20,'PEDRA BONITA',NULL,3560,35364000,'MG','3148756',1,'2006-11-12 16:54:39'),(1913,NULL,1,20,'PEDRA DO ANTA',NULL,3562,36585000,'MG','3148806',1,'2006-11-12 16:54:39'),(1914,NULL,1,20,'PEDRA DO INDAI',NULL,3563,35565000,'MG','3148905',1,'2006-11-12 16:54:39'),(1915,NULL,1,20,'PEDRA DOURADA',NULL,3565,36847000,'MG','3149002',1,'2006-11-12 16:54:39'),(1916,NULL,1,20,'PEDRALVA',NULL,3568,37520000,'MG','3149101',1,'2006-11-12 16:54:39'),(1917,NULL,1,20,'PEDRAS DE MARIA DA CRUZ',NULL,3569,39492000,'MG','3149150',1,'2006-11-12 16:54:39'),(1918,NULL,1,20,'PEDRINPOLIS',NULL,3570,38178000,'MG','3149200',1,'2006-11-12 16:54:39'),(1919,NULL,1,20,'PEDRO LEOPOLDO',NULL,3571,33600000,'MG','3149309',1,'2006-11-12 16:54:39'),(1920,NULL,1,20,'PEDRO TEIXEIRA',NULL,3573,36148000,'MG','3149408',1,'2006-11-12 16:54:39'),(1921,NULL,1,20,'PEQUERI',NULL,3581,36610000,'MG','3149507',1,'2006-11-12 16:54:39'),(1922,NULL,1,20,'PEQUI',NULL,3582,35667000,'MG','3149606',1,'2006-11-12 16:54:39'),(1923,NULL,1,20,'PERDIGO',NULL,3583,35515000,'MG','3149705',1,'2006-11-12 16:54:39'),(1924,NULL,1,20,'PERDIZES',NULL,3585,38170000,'MG','3149804',1,'2006-11-12 16:54:39'),(1925,NULL,1,20,'PERDES',NULL,3586,37260000,'MG','3149903',1,'2006-11-12 16:54:39'),(1926,NULL,1,20,'PERIQUITO',NULL,3588,35156000,'MG','3149952',1,'2006-11-12 16:54:39'),(1927,NULL,1,20,'PESCADOR',NULL,3590,35114000,'MG','3150000',1,'2006-11-12 16:54:39'),(1928,NULL,1,20,'PIAU',NULL,3594,36157000,'MG','3150109',1,'2006-11-12 16:54:39'),(1929,NULL,1,20,'PIEDADE DE CARATINGA',NULL,3596,35325000,'MG','3150158',1,'2006-11-12 16:54:39'),(1930,NULL,1,20,'PIEDADE DE PONTE NOVA',NULL,3597,35382000,'MG','3150208',1,'2006-11-12 16:54:39'),(1931,NULL,1,20,'PIEDADE DO RIO GRANDE',NULL,3599,36227000,'MG','3150307',1,'2006-11-12 16:54:39'),(1932,NULL,1,20,'PIEDADE DOS GERAIS',NULL,3600,35526000,'MG','3150406',1,'2006-11-12 16:54:39'),(1933,NULL,1,20,'PIMENTA',NULL,3602,35585000,'MG','3150505',1,'2006-11-12 16:54:39'),(1934,NULL,1,20,'PINGO-D\'GUA',NULL,3604,35348000,'MG',NULL,1,'2006-11-12 16:54:40'),(1935,NULL,1,20,'PINTPOLIS',NULL,3608,39317000,'MG','3150570',1,'2006-11-12 16:54:40'),(1936,NULL,1,20,'PIRACEMA',NULL,3611,35536000,'MG','3150604',1,'2006-11-12 16:54:40'),(1937,NULL,1,20,'PIRAJUBA',NULL,3612,38210000,'MG','3150703',1,'2006-11-12 16:54:40'),(1938,NULL,1,20,'PIRANGA',NULL,3613,36480000,'MG','3150802',1,'2006-11-12 16:54:40'),(1939,NULL,1,20,'PIRANGUU',NULL,3614,37511000,'MG','3150901',1,'2006-11-12 16:54:40'),(1940,NULL,1,20,'PIRANGUINHO',NULL,3615,37508000,'MG','3151008',1,'2006-11-12 16:54:40'),(1941,NULL,1,20,'PIRAPETINGA',NULL,3618,36730000,'MG','3151107',1,'2006-11-12 16:54:40'),(1942,NULL,1,20,'PIRAPORA',NULL,3619,39270000,'MG','3151206',1,'2006-11-12 16:54:40'),(1943,NULL,1,20,'PIRABA',NULL,3620,36170000,'MG','3151305',1,'2006-11-12 16:54:40'),(1944,NULL,1,20,'PITANGUI',NULL,3623,35650000,'MG','3151404',1,'2006-11-12 16:54:40'),(1945,NULL,1,20,'PIUMHI',NULL,3625,37925000,'MG','3151503',1,'2006-11-12 16:54:40'),(1946,NULL,1,20,'PLANURA',NULL,3627,38220000,'MG','3151602',1,'2006-11-12 16:54:40'),(1947,NULL,1,20,'POO FUNDO',NULL,3630,37757000,'MG','3151701',1,'2006-11-12 16:54:40'),(1948,NULL,1,20,'POOS DE CALDAS',NULL,3632,NULL,'MG','3151800',1,'2006-11-12 16:54:40'),(1949,NULL,1,20,'POCRANE',NULL,3633,36960000,'MG','3151909',1,'2006-11-12 16:54:40'),(1950,NULL,1,20,'POMPU',NULL,3634,35640000,'MG','3152006',1,'2006-11-12 16:54:40'),(1951,NULL,1,20,'PONTE NOVA',NULL,3641,NULL,'MG','3152105',1,'2006-11-12 16:54:40'),(1952,NULL,1,20,'PONTO CHIQUE',NULL,3644,39328000,'MG','3152131',1,'2006-11-12 16:54:40'),(1953,NULL,1,20,'PONTO DOS VOLANTES',NULL,3647,39615000,'MG','3152170',1,'2006-11-12 16:54:40'),(1954,NULL,1,20,'PORTEIRINHA',NULL,3648,39520000,'MG','3152204',1,'2006-11-12 16:54:40'),(1955,NULL,1,20,'PORTO FIRME',NULL,3652,36576000,'MG','3152303',1,'2006-11-12 16:54:40'),(1956,NULL,1,20,'POT',NULL,3653,39827000,'MG','3152402',1,'2006-11-12 16:54:40'),(1957,NULL,1,20,'POUSO ALEGRE',NULL,3654,37550000,'MG','3152501',1,'2006-11-12 16:54:41'),(1958,NULL,1,20,'POUSO ALTO',NULL,3655,37468000,'MG','3152600',1,'2006-11-12 16:54:41'),(1959,NULL,1,20,'PRADOS',NULL,3656,36320000,'MG','3152709',1,'2006-11-12 16:54:41'),(1960,NULL,1,20,'PRATA',NULL,3657,38140000,'MG','3152808',1,'2006-11-12 16:54:41'),(1961,NULL,1,20,'PRATPOLIS',NULL,3658,37970000,'MG','3152907',1,'2006-11-12 16:54:41'),(1962,NULL,1,20,'PRATINHA',NULL,3659,38960000,'MG','3153004',1,'2006-11-12 16:54:41'),(1963,NULL,1,20,'PRESIDENTE BERNARDES',NULL,3660,36475000,'MG','3153103',1,'2006-11-12 16:54:41'),(1964,NULL,1,20,'PRESIDENTE JUSCELINO',NULL,3661,35797000,'MG','3153202',1,'2006-11-12 16:54:41'),(1965,NULL,1,20,'PRESIDENTE KUBITSCHEK',NULL,3662,39135000,'MG','3153301',1,'2006-11-12 16:54:41'),(1966,NULL,1,20,'PRESIDENTE OLEGRIO',NULL,3663,38750000,'MG','3153400',1,'2006-11-12 16:54:41'),(1967,NULL,1,20,'PRUDENTE DE MORAIS',NULL,3667,35715000,'MG','3153608',1,'2006-11-12 16:54:41'),(1968,NULL,1,20,'QUARTEL GERAL',NULL,3670,35625000,'MG','3153707',1,'2006-11-12 16:54:41'),(1969,NULL,1,20,'QUELUZITA',NULL,3673,36424000,'MG',NULL,1,'2006-11-12 16:54:41'),(1970,NULL,1,20,'RAPOSOS',NULL,3677,34400000,'MG','3153905',1,'2006-11-12 16:54:41'),(1971,NULL,1,20,'RAUL SOARES',NULL,3678,35350000,'MG','3154002',1,'2006-11-12 16:54:41'),(1972,NULL,1,20,'RECREIO',NULL,3681,36740000,'MG','3154101',1,'2006-11-12 16:54:41'),(1973,NULL,1,20,'REDUTO',NULL,3682,36920000,'MG','3154150',1,'2006-11-12 16:54:41'),(1974,NULL,1,20,'RESENDE COSTA',NULL,3683,36340000,'MG','3154200',1,'2006-11-12 16:54:41'),(1975,NULL,1,20,'RESPLENDOR',NULL,3684,35230000,'MG','3154309',1,'2006-11-12 16:54:41'),(1976,NULL,1,20,'RESSAQUINHA',NULL,3685,36270000,'MG','3154408',1,'2006-11-12 16:54:41'),(1977,NULL,1,20,'RIACHINHO',NULL,3686,38640000,'MG','3154457',1,'2006-11-12 16:54:41'),(1978,NULL,1,20,'RIACHO DOS MACHADOS',NULL,3688,39529000,'MG','3154507',1,'2006-11-12 16:54:41'),(1979,NULL,1,20,'RIBEIRO DAS NEVES',NULL,3689,NULL,'MG','3154606',1,'2006-11-12 16:54:41'),(1980,NULL,1,20,'RIBEIRO VERMELHO',NULL,3691,37264000,'MG','3154705',1,'2006-11-12 16:54:41'),(1981,NULL,1,20,'RIO ACIMA',NULL,3694,34300000,'MG','3154804',1,'2006-11-12 16:54:42'),(1982,NULL,1,20,'RIO CASCA',NULL,3695,35370000,'MG','3154903',1,'2006-11-12 16:54:42'),(1983,NULL,1,20,'RIO DO PRADO',NULL,3697,39940000,'MG','3155108',1,'2006-11-12 16:54:42'),(1984,NULL,1,20,'RIO DOCE',NULL,3698,35442000,'MG','3155009',1,'2006-11-12 16:54:42'),(1985,NULL,1,20,'RIO ESPERA',NULL,3699,36460000,'MG','3155207',1,'2006-11-12 16:54:42'),(1986,NULL,1,20,'RIO MANSO',NULL,3700,35525000,'MG','3155306',1,'2006-11-12 16:54:42'),(1987,NULL,1,20,'RIO NOVO',NULL,3702,36150000,'MG','3155405',1,'2006-11-12 16:54:42'),(1988,NULL,1,20,'RIO PARANABA',NULL,3703,38810000,'MG','3155504',1,'2006-11-12 16:54:42'),(1989,NULL,1,20,'RIO PARDO DE MINAS',NULL,3704,39530000,'MG','3155603',1,'2006-11-12 16:54:42'),(1990,NULL,1,20,'RIO PIRACICABA',NULL,3705,35940000,'MG','3155702',1,'2006-11-12 16:54:42'),(1991,NULL,1,20,'RIO POMBA',NULL,3706,36180000,'MG','3155801',1,'2006-11-12 16:54:42'),(1992,NULL,1,20,'RIO PRETO',NULL,3708,36130000,'MG','3155900',1,'2006-11-12 16:54:42'),(1993,NULL,1,20,'RIO VERMELHO',NULL,3709,39170000,'MG','3156007',1,'2006-11-12 16:54:42'),(1994,NULL,1,20,'RITPOLIS',NULL,3710,36335000,'MG','3156106',1,'2006-11-12 16:54:42'),(1995,NULL,1,20,'ROCHEDO DE MINAS',NULL,3713,36604000,'MG','3156205',1,'2006-11-12 16:54:42'),(1996,NULL,1,20,'RODEIRO',NULL,3715,36510000,'MG','3156304',1,'2006-11-12 16:54:42'),(1997,NULL,1,20,'ROMARIA',NULL,3717,38520000,'MG','3156403',1,'2006-11-12 16:54:42'),(1998,NULL,1,20,'ROSRIO DA LIMEIRA',NULL,3718,36878000,'MG','3156452',1,'2006-11-12 16:54:42'),(1999,NULL,1,20,'RUBELITA',NULL,3722,39565000,'MG','3156502',1,'2006-11-12 16:54:42'),(2000,NULL,1,20,'RUBIM',NULL,3723,39950000,'MG','3156601',1,'2006-11-12 16:54:42'),(2001,NULL,1,20,'SABAR',NULL,3724,NULL,'MG','3156700',1,'2006-11-12 16:54:42'),(2002,NULL,1,20,'SABINPOLIS',NULL,3725,39750000,'MG','3156809',1,'2006-11-12 16:54:43'),(2003,NULL,1,20,'SACRAMENTO',NULL,3726,38190000,'MG','3156908',1,'2006-11-12 16:54:43'),(2004,NULL,1,20,'SALINAS',NULL,3727,39560000,'MG','3157005',1,'2006-11-12 16:54:43'),(2005,NULL,1,20,'SALTO DA DIVISA',NULL,3729,39925000,'MG','3157104',1,'2006-11-12 16:54:43'),(2006,NULL,1,20,'SANTA BRBARA',NULL,3731,35960000,'MG','3157203',1,'2006-11-12 16:54:43'),(2007,NULL,1,20,'SANTA BRBARA DO LESTE',NULL,3732,35328000,'MG','3157252',1,'2006-11-12 16:54:43'),(2008,NULL,1,20,'SANTA BRBARA DO MONTE VERDE',NULL,3733,36132000,'MG','3157278',1,'2006-11-12 16:54:43'),(2009,NULL,1,20,'SANTA BRBARA DO TUGRIO',NULL,3734,36215000,'MG','3157302',1,'2006-11-12 16:54:43'),(2010,NULL,1,20,'SANTA CRUZ DE MINAS',NULL,3737,36328000,'MG','3157336',1,'2006-11-12 16:54:43'),(2011,NULL,1,20,'SANTA CRUZ DE SALINAS',NULL,3738,39563000,'MG','3157377',1,'2006-11-12 16:54:43'),(2012,NULL,1,20,'SANTA CRUZ DO ESCALVADO',NULL,3739,35384000,'MG','3157401',1,'2006-11-12 16:54:43'),(2013,NULL,1,20,'SANTA EFIGNIA DE MINAS',NULL,3743,39725000,'MG','3157500',1,'2006-11-12 16:54:43'),(2014,NULL,1,20,'SANTA F DE MINAS',NULL,3744,39295000,'MG','3157609',1,'2006-11-12 16:54:43'),(2015,NULL,1,20,'SANTA HELENA DE MINAS',NULL,3746,39874000,'MG','3157658',1,'2006-11-12 16:54:43'),(2016,NULL,1,20,'SANTA JULIANA',NULL,3748,38175000,'MG','3157708',1,'2006-11-12 16:54:43'),(2017,NULL,1,20,'SANTA LUZIA',NULL,3749,NULL,'MG','3157807',1,'2006-11-12 16:54:43'),(2018,NULL,1,20,'SANTA MARGARIDA',NULL,3751,36910000,'MG','3157906',1,'2006-11-12 16:54:43'),(2019,NULL,1,20,'SANTA MARIA DE ITABIRA',NULL,3752,35910000,'MG','3158003',1,'2006-11-12 16:54:43'),(2020,NULL,1,20,'SANTA MARIA DO SALTO',NULL,3753,39928000,'MG','3158102',1,'2006-11-12 16:54:43'),(2021,NULL,1,20,'SANTA MARIA DO SUAU',NULL,3754,39780000,'MG','3158201',1,'2006-11-12 16:54:43'),(2022,NULL,1,20,'SANTA RITA DE CALDAS',NULL,3756,37775000,'MG','3159209',1,'2006-11-12 16:54:43'),(2023,NULL,1,20,'SANTA RITA DE JACUTINGA',NULL,3757,36135000,'MG','3159308',1,'2006-11-12 16:54:43'),(2024,NULL,1,20,'SANTA RITA DE MINAS',NULL,3758,35326000,'MG','3159357',1,'2006-11-12 16:54:44'),(2025,NULL,1,20,'SANTA RITA DO IBITIPOCA',NULL,3761,36235000,'MG',NULL,1,'2006-11-12 16:54:44'),(2026,NULL,1,20,'SANTA RITA DO ITUETO',NULL,3762,35225000,'MG','3159506',1,'2006-11-12 16:54:44'),(2027,NULL,1,20,'SANTA RITA DO SAPUCA',NULL,3764,37540000,'MG','3159605',1,'2006-11-12 16:54:44'),(2028,NULL,1,20,'SANTA ROSA DA SERRA',NULL,3766,38805000,'MG','3159704',1,'2006-11-12 16:54:44'),(2029,NULL,1,20,'SANTA VITRIA',NULL,3771,38320000,'MG','3159803',1,'2006-11-12 16:54:44'),(2030,NULL,1,20,'SANTANA DA VARGEM',NULL,3772,37195000,'MG','3158300',1,'2006-11-12 16:54:44'),(2031,NULL,1,20,'SANTANA DE CATAGUASES',NULL,3774,36795000,'MG','3158409',1,'2006-11-12 16:54:44'),(2032,NULL,1,20,'SANTANA DE PIRAPAMA',NULL,3776,35785000,'MG','3158508',1,'2006-11-12 16:54:44'),(2033,NULL,1,20,'SANTANA DO DESERTO',NULL,3781,36620000,'MG','3158607',1,'2006-11-12 16:54:44'),(2034,NULL,1,20,'SANTANA DO GARAMBU',NULL,3782,36146000,'MG','3158706',1,'2006-11-12 16:54:44'),(2035,NULL,1,20,'SANTANA DO JACAR',NULL,3783,37278000,'MG','3158805',1,'2006-11-12 16:54:44'),(2036,NULL,1,20,'SANTANA DO MANHUAU',NULL,3784,36940000,'MG','3158904',1,'2006-11-12 16:54:44'),(2037,NULL,1,20,'SANTANA DO PARASO',NULL,3785,35167000,'MG','3158953',1,'2006-11-12 16:54:44'),(2038,NULL,1,20,'SANTANA DO RIACHO',NULL,3787,35845000,'MG','3159001',1,'2006-11-12 16:54:44'),(2039,NULL,1,20,'SANTANA DOS MONTES',NULL,3789,36430000,'MG','3159100',1,'2006-11-12 16:54:44'),(2040,NULL,1,20,'SANTO ANTNIO DO AMPARO',NULL,3793,37262000,'MG','3159902',1,'2006-11-12 16:54:44'),(2041,NULL,1,20,'SANTO ANTNIO DO AVENTUREIRO',NULL,3794,36670000,'MG','3160009',1,'2006-11-12 16:54:44'),(2042,NULL,1,20,'SANTO ANTNIO DO GRAMA',NULL,3798,35388000,'MG','3160108',1,'2006-11-12 16:54:44'),(2043,NULL,1,20,'SANTO ANTNIO DO ITAMB',NULL,3799,39160000,'MG','3160207',1,'2006-11-12 16:54:44'),(2044,NULL,1,20,'SANTO ANTNIO DO JACINTO',NULL,3800,39935000,'MG','3160306',1,'2006-11-12 16:54:44'),(2045,NULL,1,20,'SANTO ANTNIO DO MONTE',NULL,3803,35560000,'MG','3160405',1,'2006-11-12 16:54:44'),(2046,NULL,1,20,'SANTO ANTNIO DO RETIRO',NULL,3807,39538000,'MG','3160454',1,'2006-11-12 16:54:44'),(2047,NULL,1,20,'SANTO ANTNIO DO RIO ABAIXO',NULL,3808,35880000,'MG','3160504',1,'2006-11-12 16:54:44'),(2048,NULL,1,20,'SANTO HIPLITO',NULL,3812,39210000,'MG','3160603',1,'2006-11-12 16:54:45'),(2049,NULL,1,20,'SANTOS DUMONT',NULL,3813,36240000,'MG','3160702',1,'2006-11-12 16:54:45'),(2050,NULL,1,20,'SO BENTO ABADE',NULL,3816,37414000,'MG','3160801',1,'2006-11-12 16:54:45'),(2051,NULL,1,20,'SO BRS DO SUAU',NULL,3818,35495000,'MG','3160900',1,'2006-11-12 16:54:45'),(2052,NULL,1,20,'SO DOMINGOS DAS DORES',NULL,3823,35335000,'MG','3160959',1,'2006-11-12 16:54:45'),(2053,NULL,1,20,'SO DOMINGOS DO PRATA',NULL,3824,35995000,'MG','3161007',1,'2006-11-12 16:54:45'),(2054,NULL,1,20,'SO FLIX DE MINAS',NULL,3825,35275000,'MG','3161056',1,'2006-11-12 16:54:45'),(2055,NULL,1,20,'SO FRANCISCO',NULL,3826,39300000,'MG','3161106',1,'2006-11-12 16:54:45'),(2056,NULL,1,20,'SO FRANCISCO DE PAULA',NULL,3827,35543000,'MG','3161205',1,'2006-11-12 16:54:45'),(2057,NULL,1,20,'SO FRANCISCO DE SALES',NULL,3828,38260000,'MG','3161304',1,'2006-11-12 16:54:45'),(2058,NULL,1,20,'SO FRANCISCO DO GLRIA',NULL,3829,36810000,'MG','3161403',1,'2006-11-12 16:54:45'),(2059,NULL,1,20,'SO GERALDO',NULL,3831,36530000,'MG','3161502',1,'2006-11-12 16:54:45'),(2060,NULL,1,20,'SO GERALDO DA PIEDADE',NULL,3833,39723000,'MG','3161601',1,'2006-11-12 16:54:45'),(2061,NULL,1,20,'SO GERALDO DO BAIXIO',NULL,3836,35258000,'MG','3161650',1,'2006-11-12 16:54:45'),(2062,NULL,1,20,'SO GONALO DO ABAET',NULL,3838,38790000,'MG','3161700',1,'2006-11-12 16:54:45'),(2063,NULL,1,20,'SO GONALO DO PAR',NULL,3840,35516000,'MG','3161809',1,'2006-11-12 16:54:45'),(2064,NULL,1,20,'SO GONALO DO RIO ABAIXO',NULL,3841,35935000,'MG','3161908',1,'2006-11-12 16:54:45'),(2065,NULL,1,20,'SO GONALO DO RIO PRETO',NULL,3843,39185000,'MG','3125507',1,'2006-11-12 16:54:45'),(2066,NULL,1,20,'SO GONALO DO SAPUCA',NULL,3844,37490000,'MG','3162005',1,'2006-11-12 16:54:45'),(2067,NULL,1,20,'SO GOTARDO',NULL,3845,38800000,'MG','3162104',1,'2006-11-12 16:54:45'),(2068,NULL,1,20,'SO JOO BATISTA DO GLRIA',NULL,3847,37920000,'MG','3162203',1,'2006-11-12 16:54:45'),(2069,NULL,1,20,'SO JOO DA LAGOA',NULL,3849,39355000,'MG','3162252',1,'2006-11-12 16:54:45'),(2070,NULL,1,20,'SO JOO DA MATA',NULL,3850,37568000,'MG','3162302',1,'2006-11-12 16:54:45'),(2071,NULL,1,20,'SO JOO DA PONTE',NULL,3851,39430000,'MG','3162401',1,'2006-11-12 16:54:45'),(2072,NULL,1,20,'SO JOO DAS MISSES',NULL,3856,39475000,'MG','3162450',1,'2006-11-12 16:54:46'),(2073,NULL,1,20,'SO JOO DEL REI',NULL,3857,NULL,'MG','3162500',1,'2006-11-12 16:54:46'),(2074,NULL,1,20,'SO JOO DO MANHUAU',NULL,3860,36918000,'MG','3162559',1,'2006-11-12 16:54:46'),(2075,NULL,1,20,'SO JOO DO MANTENINHA',NULL,3861,35277000,'MG','3162575',1,'2006-11-12 16:54:46'),(2076,NULL,1,20,'SO JOO DO ORIENTE',NULL,3862,35146000,'MG','3162609',1,'2006-11-12 16:54:46'),(2077,NULL,1,20,'SO JOO DO PACU',NULL,3863,39365000,'MG','3162658',1,'2006-11-12 16:54:46'),(2078,NULL,1,20,'SO JOO DO PARASO',NULL,3864,39540000,'MG','3162708',1,'2006-11-12 16:54:46'),(2079,NULL,1,20,'SO JOO EVANGELISTA',NULL,3865,39705000,'MG','3162807',1,'2006-11-12 16:54:46'),(2080,NULL,1,20,'SO JOO NEPOMUCENO',NULL,3866,36680000,'MG','3162906',1,'2006-11-12 16:54:46'),(2081,NULL,1,20,'SO JOAQUIM DE BICAS',NULL,3869,32920000,'MG','3162922',1,'2006-11-12 16:54:46'),(2082,NULL,1,20,'SO JOS DA BARRA',NULL,3870,37945000,'MG','3162948',1,'2006-11-12 16:54:46'),(2083,NULL,1,20,'SO JOS DA LAPA',NULL,3872,33350000,'MG','3162955',1,'2006-11-12 16:54:46'),(2084,NULL,1,20,'SO JOS DA SAFIRA',NULL,3874,39785000,'MG','3163003',1,'2006-11-12 16:54:46'),(2085,NULL,1,20,'SO JOS DA VARGINHA',NULL,3875,35694000,'MG','3163102',1,'2006-11-12 16:54:46'),(2086,NULL,1,20,'SO JOS DO ALEGRE',NULL,3878,37510000,'MG','3163201',1,'2006-11-12 16:54:46'),(2087,NULL,1,20,'SO JOS DO DIVINO',NULL,3882,39848000,'MG','3163300',1,'2006-11-12 16:54:46'),(2088,NULL,1,20,'SO JOS DO GOIABAL',NULL,3883,35986000,'MG','3163409',1,'2006-11-12 16:54:46'),(2089,NULL,1,20,'SO JOS DO JACURI',NULL,3885,39707000,'MG','3163508',1,'2006-11-12 16:54:46'),(2090,NULL,1,20,'SO JOS DO MANTIMENTO',NULL,3886,36990000,'MG','3163607',1,'2006-11-12 16:54:46'),(2091,NULL,1,20,'SO LOURENO',NULL,3892,37470000,'MG','3163706',1,'2006-11-12 16:54:46'),(2092,NULL,1,20,'SO MIGUEL DO ANTA',NULL,3895,36590000,'MG','3163805',1,'2006-11-12 16:54:46'),(2093,NULL,1,20,'SO PEDRO DA UNIO',NULL,3897,37855000,'MG','3163904',1,'2006-11-12 16:54:46'),(2094,NULL,1,20,'SO PEDRO DO SUAU',NULL,3903,39784000,'MG','3164100',1,'2006-11-12 16:54:46'),(2095,NULL,1,20,'SO PEDRO DOS FERROS',NULL,3904,35360000,'MG','3164001',1,'2006-11-12 16:54:46'),(2096,NULL,1,20,'SO ROMO',NULL,3906,39290000,'MG','3164209',1,'2006-11-12 16:54:46'),(2097,NULL,1,20,'SO ROQUE DE MINAS',NULL,3907,37928000,'MG','3164308',1,'2006-11-12 16:54:47'),(2098,NULL,1,20,'SO SEBASTIO DA BELA VISTA',NULL,3909,37567000,'MG','3164407',1,'2006-11-12 16:54:47'),(2099,NULL,1,20,'SO SEBASTIO DA VARGEM ALEGRE',NULL,3911,36793000,'MG','3164431',1,'2006-11-12 16:54:47'),(2100,NULL,1,20,'SO SEBASTIO DO ANTA',NULL,3914,35334000,'MG','3164472',1,'2006-11-12 16:54:47'),(2101,NULL,1,20,'SO SEBASTIO DO MARANHO',NULL,3921,39795000,'MG','3164506',1,'2006-11-12 16:54:47'),(2102,NULL,1,20,'SO SEBASTIO DO OESTE',NULL,3923,35506000,'MG','3164605',1,'2006-11-12 16:54:47'),(2103,NULL,1,20,'SO SEBASTIO DO PARASO',NULL,3924,37950000,'MG','3164704',1,'2006-11-12 16:54:47'),(2104,NULL,1,20,'SO SEBASTIO DO RIO PRETO',NULL,3926,35815000,'MG','3164803',1,'2006-11-12 16:54:47'),(2105,NULL,1,20,'SO SEBASTIO DO RIO VERDE',NULL,3927,37467000,'MG','3164902',1,'2006-11-12 16:54:47'),(2106,NULL,1,20,'SO TIAGO',NULL,3933,36350000,'MG','3165008',1,'2006-11-12 16:54:47'),(2107,NULL,1,20,'SO TOMS DE AQUINO',NULL,3934,37960000,'MG','3165107',1,'2006-11-12 16:54:47'),(2108,NULL,1,20,'SO TOM DAS LETRAS',NULL,3935,37418000,'MG',NULL,1,'2006-11-12 16:54:47'),(2109,NULL,1,20,'SO VICENTE DE MINAS',NULL,3938,37370000,'MG','3165305',1,'2006-11-12 16:54:47'),(2110,NULL,1,20,'SAPUCA-MIRIM',NULL,3943,37690000,'MG','3165404',1,'2006-11-12 16:54:47'),(2111,NULL,1,20,'SARDO',NULL,3948,39728000,'MG','3165503',1,'2006-11-12 16:54:47'),(2112,NULL,1,20,'SARZEDO',NULL,3949,32450000,'MG','3165537',1,'2006-11-12 16:54:47'),(2113,NULL,1,20,'SEM PEIXE',NULL,3951,35441000,'MG',NULL,1,'2006-11-12 16:54:47'),(2114,NULL,1,20,'SENADOR AMARAL',NULL,3952,37615000,'MG','3165578',1,'2006-11-12 16:54:47'),(2115,NULL,1,20,'SENADOR CORTES',NULL,3953,36650000,'MG','3165602',1,'2006-11-12 16:54:47'),(2116,NULL,1,20,'SENADOR FIRMINO',NULL,3954,36540000,'MG','3165701',1,'2006-11-12 16:54:47'),(2117,NULL,1,20,'SENADOR JOS BENTO',NULL,3955,37558000,'MG','3165800',1,'2006-11-12 16:54:47'),(2118,NULL,1,20,'SENADOR MODESTINO GONALVES',NULL,3957,39190000,'MG','3165909',1,'2006-11-12 16:54:47'),(2119,NULL,1,20,'SENHORA DE OLIVEIRA',NULL,3962,36470000,'MG','3166006',1,'2006-11-12 16:54:47'),(2120,NULL,1,20,'SENHORA DO PORTO',NULL,3964,39745000,'MG','3166105',1,'2006-11-12 16:54:47'),(2121,NULL,1,20,'SENHORA DOS REMDIOS',NULL,3965,36275000,'MG','3166204',1,'2006-11-12 16:54:47'),(2122,NULL,1,20,'SERICITA',NULL,3967,35368000,'MG','3166303',1,'2006-11-12 16:54:47'),(2123,NULL,1,20,'SERITINGA',NULL,3968,37454000,'MG','3166402',1,'2006-11-12 16:54:47'),(2124,NULL,1,20,'SERRA AZUL DE MINAS',NULL,3970,39165000,'MG','3166501',1,'2006-11-12 16:54:48'),(2125,NULL,1,20,'SERRA DA SAUDADE',NULL,3973,35617000,'MG','3166600',1,'2006-11-12 16:54:48'),(2126,NULL,1,20,'SERRA DO SALITRE',NULL,3976,38760000,'MG','3166808',1,'2006-11-12 16:54:48'),(2127,NULL,1,20,'SERRA DOS AIMORS',NULL,3977,39868000,'MG','3166709',1,'2006-11-12 16:54:48'),(2128,NULL,1,20,'SERRANIA',NULL,3980,37136000,'MG','3166907',1,'2006-11-12 16:54:48'),(2129,NULL,1,20,'SERRANPOLIS DE MINAS',NULL,3981,39518000,'MG','3166956',1,'2006-11-12 16:54:48'),(2130,NULL,1,20,'SERRANOS',NULL,3982,37452000,'MG','3167004',1,'2006-11-12 16:54:48'),(2131,NULL,1,20,'SERRO',NULL,3983,39150000,'MG','3167103',1,'2006-11-12 16:54:48'),(2132,NULL,1,20,'SETE LAGOAS',NULL,3986,NULL,'MG','3167202',1,'2006-11-12 16:54:48'),(2133,NULL,1,20,'SETUBINHA',NULL,3987,39688000,'MG','3165552',1,'2006-11-12 16:54:48'),(2134,NULL,1,20,'SILVEIRNIA',NULL,3992,36185000,'MG','3167301',1,'2006-11-12 16:54:48'),(2135,NULL,1,20,'SILVIANPOLIS',NULL,3994,37560000,'MG','3167400',1,'2006-11-12 16:54:48'),(2136,NULL,1,20,'SIMO PEREIRA',NULL,3996,36123000,'MG','3167509',1,'2006-11-12 16:54:48'),(2137,NULL,1,20,'SIMONSIA',NULL,3997,36930000,'MG','3167608',1,'2006-11-12 16:54:48'),(2138,NULL,1,20,'SOBRLIA',NULL,3999,35145000,'MG','3167707',1,'2006-11-12 16:54:48'),(2139,NULL,1,20,'SOLEDADE DE MINAS',NULL,4000,37478000,'MG','3167806',1,'2006-11-12 16:54:48'),(2140,NULL,1,20,'TABULEIRO',NULL,4005,36165000,'MG','3167905',1,'2006-11-12 16:54:48'),(2141,NULL,1,20,'TAIOBEIRAS',NULL,4006,39550000,'MG','3168002',1,'2006-11-12 16:54:48'),(2142,NULL,1,20,'TAPARUBA',NULL,4007,36953000,'MG','3168051',1,'2006-11-12 16:54:48'),(2143,NULL,1,20,'TAPIRA',NULL,4008,38185000,'MG','3168101',1,'2006-11-12 16:54:48'),(2144,NULL,1,20,'TAPIRA',NULL,4009,38980000,'MG','3168200',1,'2006-11-12 16:54:48'),(2145,NULL,1,20,'TAQUARAU DE MINAS',NULL,4011,33980000,'MG','3168309',1,'2006-11-12 16:54:48'),(2146,NULL,1,20,'TARUMIRIM',NULL,4013,35140000,'MG','3168408',1,'2006-11-12 16:54:48'),(2147,NULL,1,20,'TEIXEIRAS',NULL,4015,36580000,'MG','3168507',1,'2006-11-12 16:54:48'),(2148,NULL,1,20,'TEFILO OTONI',NULL,4017,NULL,'MG','3168606',1,'2006-11-12 16:54:48'),(2149,NULL,1,20,'TIMTEO',NULL,4019,NULL,'MG','3168705',1,'2006-11-12 16:54:48'),(2150,NULL,1,20,'TIRADENTES',NULL,4020,36325000,'MG','3168804',1,'2006-11-12 16:54:48'),(2151,NULL,1,20,'TIROS',NULL,4021,38880000,'MG','3168903',1,'2006-11-12 16:54:49'),(2152,NULL,1,20,'TOCANTINS',NULL,4024,36512000,'MG','3169000',1,'2006-11-12 16:54:49'),(2153,NULL,1,20,'TOCOS DO MOJI',NULL,4025,37563000,'MG','3169059',1,'2006-11-12 16:54:49'),(2154,NULL,1,20,'TOLEDO',NULL,4026,37630000,'MG','3169109',1,'2006-11-12 16:54:49'),(2155,NULL,1,20,'TOMBOS',NULL,4028,36844000,'MG','3169208',1,'2006-11-12 16:54:49'),(2156,NULL,1,20,'TRS CORAES',NULL,4032,37410000,'MG','3169307',1,'2006-11-12 16:54:49'),(2157,NULL,1,20,'TRS MARIAS',NULL,4034,39205000,'MG','3169356',1,'2006-11-12 16:54:49'),(2158,NULL,1,20,'TRS PONTAS',NULL,4035,37190000,'MG','3169406',1,'2006-11-12 16:54:49'),(2159,NULL,1,20,'TUMIRITINGA',NULL,4038,35125000,'MG','3169505',1,'2006-11-12 16:54:49'),(2160,NULL,1,20,'TUPACIGUARA',NULL,4039,38430000,'MG','3169604',1,'2006-11-12 16:54:49'),(2161,NULL,1,20,'TURMALINA',NULL,4041,39660000,'MG','3169703',1,'2006-11-12 16:54:49'),(2162,NULL,1,20,'TURVOLNDIA',NULL,4042,37496000,'MG','3169802',1,'2006-11-12 16:54:49'),(2163,NULL,1,20,'UB',NULL,4043,36500000,'MG','3169901',1,'2006-11-12 16:54:49'),(2164,NULL,1,20,'UBA',NULL,4044,39320000,'MG','3170008',1,'2006-11-12 16:54:49'),(2165,NULL,1,20,'UBAPORANGA',NULL,4045,35338000,'MG','3170057',1,'2006-11-12 16:54:49'),(2166,NULL,1,20,'UBERABA',NULL,4047,NULL,'MG','3170107',1,'2006-11-12 16:54:49'),(2167,NULL,1,20,'UBERLNDIA',NULL,4048,NULL,'MG','3170206',1,'2006-11-12 16:54:49'),(2168,NULL,1,20,'UMBURATIBA',NULL,4049,39878000,'MG','3170305',1,'2006-11-12 16:54:49'),(2169,NULL,1,20,'UNA',NULL,4051,38610000,'MG','3170404',1,'2006-11-12 16:54:49'),(2170,NULL,1,20,'UNIO DE MINAS',NULL,4052,38288000,'MG','3170438',1,'2006-11-12 16:54:49'),(2171,NULL,1,20,'URUANA DE MINAS',NULL,4053,38630000,'MG','3170479',1,'2006-11-12 16:54:49'),(2172,NULL,1,20,'URUCNIA',NULL,4054,35380000,'MG','3170503',1,'2006-11-12 16:54:49'),(2173,NULL,1,20,'URUCUIA',NULL,4055,39315000,'MG','3170529',1,'2006-11-12 16:54:49'),(2174,NULL,1,20,'VARGEM ALEGRE',NULL,4062,35199000,'MG','3170578',1,'2006-11-12 16:54:49'),(2175,NULL,1,20,'VARGEM BONITA',NULL,4063,37922000,'MG','3170602',1,'2006-11-12 16:54:49'),(2176,NULL,1,20,'VARGEM GRANDE DO RIO PARDO',NULL,4064,39535000,'MG','3170651',1,'2006-11-12 16:54:49'),(2177,NULL,1,20,'VARGINHA',NULL,4066,NULL,'MG','3170701',1,'2006-11-12 16:54:50'),(2178,NULL,1,20,'VARJO DE MINAS',NULL,4067,38794000,'MG','3170750',1,'2006-11-12 16:54:50'),(2179,NULL,1,20,'VRZEA DA PALMA',NULL,4068,39260000,'MG','3170800',1,'2006-11-12 16:54:50'),(2180,NULL,1,20,'VARZELNDIA',NULL,4069,39450000,'MG','3170909',1,'2006-11-12 16:54:50'),(2181,NULL,1,20,'VAZANTE',NULL,4071,38780000,'MG','3171006',1,'2006-11-12 16:54:50'),(2182,NULL,1,20,'VERDELNDIA',NULL,4073,39458000,'MG','3171030',1,'2006-11-12 16:54:50'),(2183,NULL,1,20,'VEREDINHA',NULL,4076,39663000,'MG','3171071',1,'2006-11-12 16:54:50'),(2184,NULL,1,20,'VERSSIMO',NULL,4077,38150000,'MG','3171105',1,'2006-11-12 16:54:50'),(2185,NULL,1,20,'VERMELHO NOVO',NULL,4079,35359000,'MG','3171154',1,'2006-11-12 16:54:50'),(2186,NULL,1,20,'VESPASIANO',NULL,4081,33200000,'MG','3171204',1,'2006-11-12 16:54:50'),(2187,NULL,1,20,'VIOSA',NULL,4082,36570000,'MG','3171303',1,'2006-11-12 16:54:50'),(2188,NULL,1,20,'VIEIRAS',NULL,4083,36895000,'MG','3171402',1,'2006-11-12 16:54:50'),(2189,NULL,1,20,'VIRGEM DA LAPA',NULL,4090,39630000,'MG','3171600',1,'2006-11-12 16:54:50'),(2190,NULL,1,20,'VIRGNIA',NULL,4091,37465000,'MG','3171709',1,'2006-11-12 16:54:50'),(2191,NULL,1,20,'VIRGINPOLIS',NULL,4092,39730000,'MG','3171808',1,'2006-11-12 16:54:50'),(2192,NULL,1,20,'VIRGOLNDIA',NULL,4093,39715000,'MG','3171907',1,'2006-11-12 16:54:50'),(2193,NULL,1,20,'VISCONDE DO RIO BRANCO',NULL,4094,36520000,'MG','3172004',1,'2006-11-12 16:54:50'),(2194,NULL,1,20,'VOLTA GRANDE',NULL,4098,36720000,'MG','3172103',1,'2006-11-12 16:54:50'),(2195,NULL,1,20,'WENCESLAU BRAZ',NULL,4099,37512000,'MG','3172202',1,'2006-11-12 16:54:50'),(2196,NULL,1,8,'GUA CLARA',NULL,4103,79680000,'MS','5000203',1,'2006-11-12 16:54:50'),(2197,NULL,1,8,'ALCINPOLIS',NULL,4105,79530000,'MS','5000252',1,'2006-11-12 16:54:50'),(2198,NULL,1,8,'AMAMBI',NULL,4107,79990000,'MS','5000609',1,'2006-11-12 16:54:51'),(2199,NULL,1,8,'ANASTCIO',NULL,4110,79210000,'MS','5000708',1,'2006-11-12 16:54:51'),(2200,NULL,1,8,'ANAURILNDIA',NULL,4111,79770000,'MS','5000807',1,'2006-11-12 16:54:51'),(2201,NULL,1,8,'ANGLICA',NULL,4112,79785000,'MS','5000856',1,'2006-11-12 16:54:51'),(2202,NULL,1,8,'ANTNIO JOO',NULL,4114,79910000,'MS','5000906',1,'2006-11-12 16:54:51'),(2203,NULL,1,8,'APARECIDA DO TABOADO',NULL,4115,79570000,'MS','5001003',1,'2006-11-12 16:54:51'),(2204,NULL,1,8,'AQUIDAUANA',NULL,4116,79200000,'MS','5001102',1,'2006-11-12 16:54:51'),(2205,NULL,1,8,'ARAL MOREIRA',NULL,4117,79930000,'MS','5001243',1,'2006-11-12 16:54:51'),(2206,NULL,1,8,'BANDEIRANTES',NULL,4123,79430000,'MS','5001508',1,'2006-11-12 16:54:51'),(2207,NULL,1,8,'BATAGUASSU',NULL,4124,79780000,'MS','5001904',1,'2006-11-12 16:54:51'),(2208,NULL,1,8,'BATAIPOR',NULL,4125,79760000,'MS',NULL,1,'2006-11-12 16:54:51'),(2209,NULL,1,8,'BELA VISTA',NULL,4127,79260000,'MS','5002100',1,'2006-11-12 16:54:51'),(2210,NULL,1,8,'BODOQUENA',NULL,4130,79390000,'MS','5002159',1,'2006-11-12 16:54:51'),(2211,NULL,1,8,'BONITO',NULL,4132,79290000,'MS','5002209',1,'2006-11-12 16:54:51'),(2212,NULL,1,8,'BRASILNDIA',NULL,4134,79670000,'MS','5002308',1,'2006-11-12 16:54:51'),(2213,NULL,1,8,'CAARAP',NULL,4135,79940000,'MS','5002407',1,'2006-11-12 16:54:51'),(2214,NULL,1,8,'CAMAPU',NULL,4138,79420000,'MS','5002605',1,'2006-11-12 16:54:51'),(2215,NULL,1,8,'CAMPO GRANDE',NULL,4141,NULL,'MS','5002704',1,'2006-11-12 16:54:51'),(2216,NULL,1,8,'CARACOL',NULL,4143,79270000,'MS','5002803',1,'2006-11-12 16:54:51'),(2217,NULL,1,8,'CASSILNDIA',NULL,4145,79540000,'MS','5002902',1,'2006-11-12 16:54:51'),(2218,NULL,1,8,'CHAPADO DO SUL',NULL,4146,79560000,'MS','5002951',1,'2006-11-12 16:54:51'),(2219,NULL,1,8,'CORGUINHO',NULL,4150,79460000,'MS','5003108',1,'2006-11-12 16:54:51'),(2220,NULL,1,8,'CORONEL SAPUCAIA',NULL,4151,79995000,'MS','5003157',1,'2006-11-12 16:54:52'),(2221,NULL,1,8,'CORUMB',NULL,4152,NULL,'MS','5003207',1,'2006-11-12 16:54:52'),(2222,NULL,1,8,'COSTA RICA',NULL,4153,79550000,'MS','5003256',1,'2006-11-12 16:54:52'),(2223,NULL,1,8,'COXIM',NULL,4154,79400000,'MS','5003306',1,'2006-11-12 16:54:52'),(2224,NULL,1,8,'DEODPOLIS',NULL,4160,79790000,'MS','5003454',1,'2006-11-12 16:54:52'),(2225,NULL,1,8,'DOIS IRMOS DO BURITI',NULL,4161,79215000,'MS','5003488',1,'2006-11-12 16:54:52'),(2226,NULL,1,8,'DOURADINA',NULL,4162,79880000,'MS','5003504',1,'2006-11-12 16:54:52'),(2227,NULL,1,8,'DOURADOS',NULL,4163,NULL,'MS','5003702',1,'2006-11-12 16:54:52'),(2228,NULL,1,8,'ELDORADO',NULL,4164,79970000,'MS','5003751',1,'2006-11-12 16:54:52'),(2229,NULL,1,8,'FTIMA DO SUL',NULL,4165,79700000,'MS','5003801',1,'2006-11-12 16:54:52'),(2230,NULL,1,8,'GLRIA DE DOURADOS',NULL,4168,79730000,'MS','5004007',1,'2006-11-12 16:54:52'),(2231,NULL,1,8,'GUIA LOPES DA LAGUNA',NULL,4172,79230000,'MS','5004106',1,'2006-11-12 16:54:52'),(2232,NULL,1,8,'IGUATEMI',NULL,4173,79960000,'MS','5004304',1,'2006-11-12 16:54:52'),(2233,NULL,1,8,'INOCNCIA',NULL,4179,79580000,'MS','5004403',1,'2006-11-12 16:54:52'),(2234,NULL,1,8,'ITAPOR',NULL,4182,79890000,'MS','5004502',1,'2006-11-12 16:54:52'),(2235,NULL,1,8,'ITAQUIRA',NULL,4183,79965000,'MS','5004601',1,'2006-11-12 16:54:52'),(2236,NULL,1,8,'IVINHEMA',NULL,4184,79740000,'MS','5004700',1,'2006-11-12 16:54:52'),(2237,NULL,1,8,'JAPOR',NULL,4187,79985000,'MS','5004809',1,'2006-11-12 16:54:52'),(2238,NULL,1,8,'JARAGUARI',NULL,4188,79440000,'MS','5004908',1,'2006-11-12 16:54:52'),(2239,NULL,1,8,'JARDIM',NULL,4189,79240000,'MS','5005004',1,'2006-11-12 16:54:52'),(2240,NULL,1,8,'JATE',NULL,4190,79720000,'MS','5005103',1,'2006-11-12 16:54:52'),(2241,NULL,1,8,'JUT',NULL,4193,79955000,'MS','5005152',1,'2006-11-12 16:54:52'),(2242,NULL,1,8,'LADRIO',NULL,4194,79370000,'MS','5005202',1,'2006-11-12 16:54:53'),(2243,NULL,1,8,'LAGUNA CARAP',NULL,4196,79920000,'MS','5005251',1,'2006-11-12 16:54:53'),(2244,NULL,1,8,'MARACAJ',NULL,4197,79150000,'MS','5005400',1,'2006-11-12 16:54:53'),(2245,NULL,1,8,'MIRANDA',NULL,4198,79380000,'MS','5005608',1,'2006-11-12 16:54:53'),(2246,NULL,1,8,'MUNDO NOVO',NULL,4203,79980000,'MS','5005681',1,'2006-11-12 16:54:53'),(2247,NULL,1,8,'NAVIRA',NULL,4204,79950000,'MS','5005707',1,'2006-11-12 16:54:53'),(2248,NULL,1,8,'NIOAQUE',NULL,4206,79220000,'MS','5005806',1,'2006-11-12 16:54:53'),(2249,NULL,1,8,'NOVA ALVORADA DO SUL',NULL,4208,79140000,'MS','5006002',1,'2006-11-12 16:54:53'),(2250,NULL,1,8,'NOVA ANDRADINA',NULL,4210,79750000,'MS','5006200',1,'2006-11-12 16:54:53'),(2251,NULL,1,8,'NOVO HORIZONTE DO SUL',NULL,4214,79745000,'MS','5006259',1,'2006-11-12 16:54:53'),(2252,NULL,1,8,'PARANABA',NULL,4220,79500000,'MS','5006309',1,'2006-11-12 16:54:53'),(2253,NULL,1,8,'PARANHOS',NULL,4221,79925000,'MS','5006358',1,'2006-11-12 16:54:53'),(2254,NULL,1,8,'PEDRO GOMES',NULL,4222,79410000,'MS','5006408',1,'2006-11-12 16:54:53'),(2255,NULL,1,8,'PONTA POR',NULL,4226,79900000,'MS','5006606',1,'2006-11-12 16:54:53'),(2256,NULL,1,8,'PORTO MURTINHO',NULL,4230,79280000,'MS','5006903',1,'2006-11-12 16:54:53'),(2257,NULL,1,8,'RIBAS DO RIO PARDO',NULL,4237,79180000,'MS','5007109',1,'2006-11-12 16:54:53'),(2258,NULL,1,8,'RIO BRILHANTE',NULL,4238,79130000,'MS','5007208',1,'2006-11-12 16:54:53'),(2259,NULL,1,8,'RIO NEGRO',NULL,4239,79470000,'MS','5007307',1,'2006-11-12 16:54:53'),(2260,NULL,1,8,'RIO VERDE DE MATO GROSSO',NULL,4240,79480000,'MS','5007406',1,'2006-11-12 16:54:54'),(2261,NULL,1,8,'ROCHEDO',NULL,4242,79450000,'MS','5007505',1,'2006-11-12 16:54:54'),(2262,NULL,1,8,'SANTA RITA DO PARDO',NULL,4244,79690000,'MS','5007554',1,'2006-11-12 16:54:54'),(2263,NULL,1,8,'SO GABRIEL DO OESTE',NULL,4246,79490000,'MS','5007695',1,'2006-11-12 16:54:54'),(2264,NULL,1,8,'SELVRIA',NULL,4253,79590000,'MS','5007802',1,'2006-11-12 16:54:54'),(2265,NULL,1,8,'SETE QUEDAS',NULL,4254,79935000,'MS','5007703',1,'2006-11-12 16:54:54'),(2266,NULL,1,8,'SIDROLNDIA',NULL,4255,79170000,'MS','5007901',1,'2006-11-12 16:54:54'),(2267,NULL,1,8,'SONORA',NULL,4256,79415000,'MS','5007935',1,'2006-11-12 16:54:54'),(2268,NULL,1,8,'TACURU',NULL,4257,79975000,'MS','5007950',1,'2006-11-12 16:54:54'),(2269,NULL,1,8,'TAQUARUSSU',NULL,4260,79765000,'MS','5007976',1,'2006-11-12 16:54:54'),(2270,NULL,1,8,'TERENOS',NULL,4262,79190000,'MS','5008008',1,'2006-11-12 16:54:54'),(2271,NULL,1,8,'TRS LAGOAS',NULL,4263,NULL,'MS','5008305',1,'2006-11-12 16:54:54'),(2272,NULL,1,8,'VICENTINA',NULL,4265,79710000,'MS','5008404',1,'2006-11-12 16:54:54'),(2273,NULL,1,7,'ACORIZAL',NULL,4272,78480000,'MT','5100102',1,'2006-11-12 16:54:54'),(2274,NULL,1,7,'GUA BOA',NULL,4273,78635000,'MT','5100201',1,'2006-11-12 16:54:54'),(2275,NULL,1,7,'ALTA FLORESTA',NULL,4280,78580000,'MT','5100250',1,'2006-11-12 16:54:54'),(2276,NULL,1,7,'ALTO ARAGUAIA',NULL,4281,78780000,'MT','5100300',1,'2006-11-12 16:54:54'),(2277,NULL,1,7,'ALTO BOA VISTA',NULL,4282,78665000,'MT','5100359',1,'2006-11-12 16:54:54'),(2278,NULL,1,7,'ALTO GARAS',NULL,4284,78770000,'MT','5100409',1,'2006-11-12 16:54:54'),(2279,NULL,1,7,'ALTO PARAGUAI',NULL,4286,78410000,'MT','5100508',1,'2006-11-12 16:54:54'),(2280,NULL,1,7,'ALTO TAQUARI',NULL,4288,78785000,'MT','5100607',1,'2006-11-12 16:54:54'),(2281,NULL,1,7,'APIACS',NULL,4290,78595000,'MT','5100805',1,'2006-11-12 16:54:55'),(2282,NULL,1,7,'ARAGUAIANA',NULL,4291,78685000,'MT','5101001',1,'2006-11-12 16:54:55'),(2283,NULL,1,7,'ARAGUAINHA',NULL,4292,78615000,'MT','5101209',1,'2006-11-12 16:54:55'),(2284,NULL,1,7,'ARAPUTANGA',NULL,4293,78260000,'MT','5101258',1,'2006-11-12 16:54:55'),(2285,NULL,1,7,'ARENPOLIS',NULL,4294,78420000,'MT','5101308',1,'2006-11-12 16:54:55'),(2286,NULL,1,7,'ARIPUAN',NULL,4295,78325000,'MT','5101407',1,'2006-11-12 16:54:55'),(2287,NULL,1,7,'BARO DE MELGAO',NULL,4298,78190000,'MT','5101605',1,'2006-11-12 16:54:55'),(2288,NULL,1,7,'BARRA DO BUGRES',NULL,4299,78390000,'MT','5101704',1,'2006-11-12 16:54:55'),(2289,NULL,1,7,'BARRA DO GARAS',NULL,4300,78600000,'MT','5101803',1,'2006-11-12 16:54:55'),(2290,NULL,1,7,'BRASNORTE',NULL,4310,78350000,'MT','5101902',1,'2006-11-12 16:54:55'),(2291,NULL,1,7,'CCERES',NULL,4313,78200000,'MT','5102504',1,'2006-11-12 16:54:55'),(2292,NULL,1,7,'CAMPINPOLIS',NULL,4315,78630000,'MT','5102603',1,'2006-11-12 16:54:55'),(2293,NULL,1,7,'CAMPO NOVO DO PARECIS',NULL,4316,78360000,'MT','5102637',1,'2006-11-12 16:54:55'),(2294,NULL,1,7,'CAMPO VERDE',NULL,4317,78840000,'MT','5102678',1,'2006-11-12 16:54:55'),(2295,NULL,1,7,'CAMPOS DE JLIO',NULL,4318,78307000,'MT','5102686',1,'2006-11-12 16:54:55'),(2296,NULL,1,7,'CANABRAVA DO NORTE',NULL,4320,78658000,'MT','5102694',1,'2006-11-12 16:54:55'),(2297,NULL,1,7,'CANARANA',NULL,4321,78640000,'MT','5102702',1,'2006-11-12 16:54:55'),(2298,NULL,1,7,'CARLINDA',NULL,4327,78587000,'MT','5102793',1,'2006-11-12 16:54:55'),(2299,NULL,1,7,'CASTANHEIRA',NULL,4329,78345000,'MT','5102850',1,'2006-11-12 16:54:55'),(2300,NULL,1,7,'CHAPADA DOS GUIMARES',NULL,4331,78195000,'MT','5103007',1,'2006-11-12 16:54:55'),(2301,NULL,1,7,'CLUDIA',NULL,4333,78540000,'MT','5103056',1,'2006-11-12 16:54:55'),(2302,NULL,1,7,'COCALINHO',NULL,4334,78680000,'MT','5103106',1,'2006-11-12 16:54:55'),(2303,NULL,1,7,'COLIDER',NULL,4335,78500000,'MT','5103205',1,'2006-11-12 16:54:56'),(2304,NULL,1,7,'COMODORO',NULL,4337,78310000,'MT','5103304',1,'2006-11-12 16:54:56'),(2305,NULL,1,7,'CONFRESA',NULL,4338,78652000,'MT','5103353',1,'2006-11-12 16:54:56'),(2306,NULL,1,7,'COTRIGUAU',NULL,4341,78330000,'MT','5103379',1,'2006-11-12 16:54:56'),(2307,NULL,1,7,'CUIAB',NULL,4347,NULL,'MT','5103403',1,'2006-11-12 16:54:56'),(2308,NULL,1,7,'CURVELNDIA',NULL,4348,78237000,'MT','5103437',1,'2006-11-12 16:54:56'),(2309,NULL,1,7,'DENISE',NULL,4350,78380000,'MT','5103452',1,'2006-11-12 16:54:56'),(2310,NULL,1,7,'DIAMANTINO',NULL,4351,78400000,'MT','5103502',1,'2006-11-12 16:54:56'),(2311,NULL,1,7,'DOM AQUINO',NULL,4352,78830000,'MT','5103601',1,'2006-11-12 16:54:56'),(2312,NULL,1,7,'FELIZ NATAL',NULL,4359,78885000,'MT','5103700',1,'2006-11-12 16:54:56'),(2313,NULL,1,7,'FIGUEIRPOLIS D\'OESTE',NULL,4360,78290000,'MT',NULL,1,'2006-11-12 16:54:56'),(2314,NULL,1,7,'GACHA DO NORTE',NULL,4364,78875000,'MT','5103858',1,'2006-11-12 16:54:56'),(2315,NULL,1,7,'GENERAL CARNEIRO',NULL,4365,78620000,'MT','5103908',1,'2006-11-12 16:54:56'),(2316,NULL,1,7,'GLRIA D\'OESTE',NULL,4366,78293000,'MT',NULL,1,'2006-11-12 16:54:56'),(2317,NULL,1,7,'GUARANT DO NORTE',NULL,4367,78520000,'MT','5104104',1,'2006-11-12 16:54:56'),(2318,NULL,1,7,'GUIRATINGA',NULL,4369,78760000,'MT','5104203',1,'2006-11-12 16:54:56'),(2319,NULL,1,7,'INDIAVA',NULL,4372,78295000,'MT','5104500',1,'2006-11-12 16:54:56'),(2320,NULL,1,7,'ITABA',NULL,4375,78510000,'MT','5104559',1,'2006-11-12 16:54:56'),(2321,NULL,1,7,'ITIQUIRA',NULL,4376,78790000,'MT','5104609',1,'2006-11-12 16:54:56'),(2322,NULL,1,7,'JACIARA',NULL,4377,78820000,'MT','5104807',1,'2006-11-12 16:54:56'),(2323,NULL,1,7,'JANGADA',NULL,4378,78490000,'MT','5104906',1,'2006-11-12 16:54:56'),(2324,NULL,1,7,'JAURU',NULL,4381,78255000,'MT','5105002',1,'2006-11-12 16:54:56'),(2325,NULL,1,7,'JUAR',NULL,4383,78575000,'MT','5105101',1,'2006-11-12 16:54:56'),(2326,NULL,1,7,'JUNA',NULL,4384,78320000,'MT','5105150',1,'2006-11-12 16:54:57'),(2327,NULL,1,7,'JURUENA',NULL,4385,78340000,'MT','5105176',1,'2006-11-12 16:54:57'),(2328,NULL,1,7,'JUSCIMEIRA',NULL,4386,78810000,'MT','5105200',1,'2006-11-12 16:54:57'),(2329,NULL,1,7,'LAMBARI D\'OESTE',NULL,4387,78278000,'MT',NULL,1,'2006-11-12 16:54:57'),(2330,NULL,1,7,'LUCAS DO RIO VERDE',NULL,4389,78455000,'MT','5105259',1,'2006-11-12 16:54:57'),(2331,NULL,1,7,'LUCIARA',NULL,4391,78660000,'MT','5105309',1,'2006-11-12 16:54:57'),(2332,NULL,1,7,'MARCELNDIA',NULL,4393,78535000,'MT','5105580',1,'2006-11-12 16:54:57'),(2333,NULL,1,7,'MATUP',NULL,4396,78525000,'MT','5105606',1,'2006-11-12 16:54:57'),(2334,NULL,1,7,'MIRASSOL D\'OESTE',NULL,4398,78280000,'MT',NULL,1,'2006-11-12 16:54:57'),(2335,NULL,1,7,'NOBRES',NULL,4399,78460000,'MT','5105903',1,'2006-11-12 16:54:57'),(2336,NULL,1,7,'NORTELNDIA',NULL,4401,78430000,'MT','5106000',1,'2006-11-12 16:54:57'),(2337,NULL,1,7,'NOSSA SENHORA DO LIVRAMENTO',NULL,4403,78170000,'MT','5106109',1,'2006-11-12 16:54:57'),(2338,NULL,1,7,'NOVA BANDEIRANTES',NULL,4405,78565000,'MT','5106158',1,'2006-11-12 16:54:57'),(2339,NULL,1,7,'NOVA BRASILNDIA',NULL,4406,78860000,'MT','5106208',1,'2006-11-12 16:54:57'),(2340,NULL,1,7,'NOVA CANA DO NORTE',NULL,4408,78515000,'MT','5106216',1,'2006-11-12 16:54:57'),(2341,NULL,1,7,'NOVA GUARITA',NULL,4411,78508000,'MT','5108808',1,'2006-11-12 16:54:57'),(2342,NULL,1,7,'NOVA LACERDA',NULL,4412,78243000,'MT','5106182',1,'2006-11-12 16:54:57'),(2343,NULL,1,7,'NOVA MARILNDIA',NULL,4413,78415000,'MT','5108857',1,'2006-11-12 16:54:57'),(2344,NULL,1,7,'NOVA MARING',NULL,4414,78445000,'MT','5108907',1,'2006-11-12 16:54:57'),(2345,NULL,1,7,'NOVA MONTE VERDE',NULL,4415,78593000,'MT','5108956',1,'2006-11-12 16:54:57'),(2346,NULL,1,7,'NOVA MUTUM',NULL,4416,78450000,'MT','5106224',1,'2006-11-12 16:54:57'),(2347,NULL,1,7,'NOVA OLMPIA',NULL,4417,78370000,'MT','5106232',1,'2006-11-12 16:54:57'),(2348,NULL,1,7,'NOVA UBIRAT',NULL,4418,78888000,'MT','5106240',1,'2006-11-12 16:54:57'),(2349,NULL,1,7,'NOVA XAVANTINA',NULL,4419,78690000,'MT','5106257',1,'2006-11-12 16:54:58'),(2350,NULL,1,7,'NOVO HORIZONTE DO NORTE',NULL,4422,78570000,'MT','5106273',1,'2006-11-12 16:54:58'),(2351,NULL,1,7,'NOVO MUNDO',NULL,4423,78528000,'MT','5106265',1,'2006-11-12 16:54:58'),(2352,NULL,1,7,'NOVO SO JOAQUIM',NULL,4425,78625000,'MT','5106281',1,'2006-11-12 16:54:58'),(2353,NULL,1,7,'PARANAIT',NULL,4429,78590000,'MT','5106299',1,'2006-11-12 16:54:58'),(2354,NULL,1,7,'PARANATINGA',NULL,4430,78870000,'MT','5106307',1,'2006-11-12 16:54:58'),(2355,NULL,1,7,'PEDRA PRETA',NULL,4432,78795000,'MT','5106372',1,'2006-11-12 16:54:58'),(2356,NULL,1,7,'PEIXOTO DE AZEVEDO',NULL,4433,78530000,'MT','5106422',1,'2006-11-12 16:54:58'),(2357,NULL,1,7,'PLANALTO DA SERRA',NULL,4436,78855000,'MT','5106455',1,'2006-11-12 16:54:58'),(2358,NULL,1,7,'POCON',NULL,4437,78175000,'MT','5106505',1,'2006-11-12 16:54:58'),(2359,NULL,1,7,'PONTAL DO ARAGUAIA',NULL,4439,78698000,'MT','5106653',1,'2006-11-12 16:54:58'),(2360,NULL,1,7,'PONTE BRANCA',NULL,4440,78610000,'MT','5106703',1,'2006-11-12 16:54:58'),(2361,NULL,1,7,'PONTES E LACERDA',NULL,4442,78250000,'MT','5106752',1,'2006-11-12 16:54:58'),(2362,NULL,1,7,'PORTO ALEGRE DO NORTE',NULL,4444,78655000,'MT','5106778',1,'2006-11-12 16:54:58'),(2363,NULL,1,7,'PORTO DOS GACHOS',NULL,4445,78560000,'MT','5106802',1,'2006-11-12 16:54:58'),(2364,NULL,1,7,'PORTO ESPERIDIO',NULL,4446,78240000,'MT','5106828',1,'2006-11-12 16:54:58'),(2365,NULL,1,7,'PORTO ESTRELA',NULL,4447,78398000,'MT','5106851',1,'2006-11-12 16:54:58'),(2366,NULL,1,7,'POXORO',NULL,4448,78800000,'MT','5107008',1,'2006-11-12 16:54:58'),(2367,NULL,1,7,'PRIMAVERA DO LESTE',NULL,4451,78850000,'MT','5107040',1,'2006-11-12 16:54:58'),(2368,NULL,1,7,'QUERNCIA',NULL,4453,78643000,'MT','5107065',1,'2006-11-12 16:54:58'),(2369,NULL,1,7,'RESERVA DO CABAAL',NULL,4455,78265000,'MT','5107156',1,'2006-11-12 16:54:58'),(2370,NULL,1,7,'RIBEIRO CASCALHEIRA',NULL,4456,78675000,'MT','5107180',1,'2006-11-12 16:54:59'),(2371,NULL,1,7,'RIBEIROZINHO',NULL,4458,78613000,'MT','5107198',1,'2006-11-12 16:54:59'),(2372,NULL,1,7,'RIO BRANCO',NULL,4459,78275000,'MT','5107206',1,'2006-11-12 16:54:59'),(2373,NULL,1,7,'RONDONPOLIS',NULL,4462,NULL,'MT','5107602',1,'2006-11-12 16:54:59'),(2374,NULL,1,7,'ROSRIO OESTE',NULL,4463,78470000,'MT','5107701',1,'2006-11-12 16:54:59'),(2375,NULL,1,7,'SALTO DO CU',NULL,4464,78270000,'MT','5107750',1,'2006-11-12 16:54:59'),(2376,NULL,1,7,'SANTA CARMEM',NULL,4466,78545000,'MT','5107248',1,'2006-11-12 16:54:59'),(2377,NULL,1,7,'SANTA TEREZINHA',NULL,4470,78650000,'MT','5107776',1,'2006-11-12 16:54:59'),(2378,NULL,1,7,'SANTO AFONSO',NULL,4472,78425000,'MT','5107263',1,'2006-11-12 16:54:59'),(2379,NULL,1,7,'SANTO ANTNIO DO LEVERGER',NULL,4473,78180000,'MT','5107800',1,'2006-11-12 16:54:59'),(2380,NULL,1,7,'VALE DE SO DOMINGOS',NULL,4476,78253000,'MT','5108352',1,'2006-11-12 16:54:59'),(2381,NULL,1,7,'SO FLIX DO ARAGUAIA',NULL,4477,78670000,'MT','5107859',1,'2006-11-12 16:54:59'),(2382,NULL,1,7,'SO JOS DO POVO',NULL,4483,78773000,'MT','5107297',1,'2006-11-12 16:54:59'),(2383,NULL,1,7,'SO JOS DO RIO CLARO',NULL,4484,78435000,'MT','5107305',1,'2006-11-12 16:54:59'),(2384,NULL,1,7,'SO JOS DO XINGU',NULL,4485,78663000,'MT','5107354',1,'2006-11-12 16:54:59'),(2385,NULL,1,7,'SO JOS DOS QUATRO MARCOS',NULL,4486,78285000,'MT','5107107',1,'2006-11-12 16:54:59'),(2386,NULL,1,7,'SO PEDRO DA CIPA',NULL,4488,78835000,'MT','5107404',1,'2006-11-12 16:54:59'),(2387,NULL,1,7,'SAPEZAL',NULL,4490,78365000,'MT','5107875',1,'2006-11-12 16:54:59'),(2388,NULL,1,7,'SERRA NOVA DOURADA',NULL,4492,78668000,'MT','5107883',1,'2006-11-12 16:54:59'),(2389,NULL,1,7,'SINOP',NULL,4493,78550000,'MT','5107909',1,'2006-11-12 16:54:59'),(2390,NULL,1,7,'SORRISO',NULL,4495,78890000,'MT','5107925',1,'2006-11-12 16:54:59'),(2391,NULL,1,7,'TABAPOR',NULL,4497,78563000,'MT','5107941',1,'2006-11-12 16:54:59'),(2392,NULL,1,7,'TANGAR DA SERRA',NULL,4498,78300000,'MT','5107958',1,'2006-11-12 16:54:59'),(2393,NULL,1,7,'TAPURAH',NULL,4500,78555000,'MT','5108006',1,'2006-11-12 16:55:00'),(2394,NULL,1,7,'TERRA NOVA DO NORTE',NULL,4501,78505000,'MT','5108055',1,'2006-11-12 16:55:00'),(2395,NULL,1,7,'TESOURO',NULL,4503,78775000,'MT','5108105',1,'2006-11-12 16:55:00'),(2396,NULL,1,7,'TORIXORU',NULL,4505,78695000,'MT','5108204',1,'2006-11-12 16:55:00'),(2397,NULL,1,7,'UNIO DO SUL',NULL,4507,78543000,'MT','5108303',1,'2006-11-12 16:55:00'),(2398,NULL,1,7,'VRZEA GRANDE',NULL,4511,NULL,'MT','5108402',1,'2006-11-12 16:55:00'),(2399,NULL,1,7,'VERA',NULL,4512,78880000,'MT','5108501',1,'2006-11-12 16:55:00'),(2400,NULL,1,7,'VILA BELA DA SANTSSIMA TRINDADE',NULL,4514,78245000,'MT','5105507',1,'2006-11-12 16:55:00'),(2401,NULL,1,7,'VILA RICA',NULL,4520,78645000,'MT','5108600',1,'2006-11-12 16:55:00'),(2402,NULL,1,7,'NOVO SANTO ANTNIO',NULL,4521,78674000,'MT','5106315',1,'2006-11-12 16:55:00'),(2403,NULL,1,1,'ABAETETUBA',NULL,4522,68440000,'PA',NULL,1,'2006-11-12 16:55:00'),(2404,NULL,1,1,'ABEL FIGUEIREDO',NULL,4523,68527000,'PA',NULL,1,'2006-11-12 16:55:00'),(2405,NULL,1,1,'ACAR',NULL,4524,68690000,'PA',NULL,1,'2006-11-12 16:55:00'),(2406,NULL,1,1,'AFU',NULL,4525,68890000,'PA',NULL,1,'2006-11-12 16:55:00'),(2407,NULL,1,1,'GUA AZUL DO NORTE',NULL,4527,68533000,'PA',NULL,1,'2006-11-12 16:55:00'),(2408,NULL,1,1,'ALENQUER',NULL,4529,68200000,'PA',NULL,1,'2006-11-12 16:55:00'),(2409,NULL,1,1,'ALMEIRIM',NULL,4531,68230000,'PA',NULL,1,'2006-11-12 16:55:00'),(2410,NULL,1,1,'ALTAMIRA',NULL,4534,NULL,'PA',NULL,1,'2006-11-12 16:55:00'),(2411,NULL,1,1,'ANAJS',NULL,4538,68810000,'PA',NULL,1,'2006-11-12 16:55:00'),(2412,NULL,1,1,'ANANINDEUA',NULL,4539,NULL,'PA',NULL,1,'2006-11-12 16:55:00'),(2413,NULL,1,1,'ANAPU',NULL,4540,68365000,'PA',NULL,1,'2006-11-12 16:55:00'),(2414,NULL,1,1,'AUGUSTO CORRA',NULL,4552,68610000,'PA',NULL,1,'2006-11-12 16:55:00'),(2415,NULL,1,1,'AURORA DO PAR',NULL,4553,68658000,'PA',NULL,1,'2006-11-12 16:55:01'),(2416,NULL,1,1,'AVEIRO',NULL,4554,68150000,'PA',NULL,1,'2006-11-12 16:55:01'),(2417,NULL,1,1,'BAGRE',NULL,4555,68475000,'PA',NULL,1,'2006-11-12 16:55:01'),(2418,NULL,1,1,'BAIO',NULL,4556,68465000,'PA',NULL,1,'2006-11-12 16:55:01'),(2419,NULL,1,1,'BANNACH',NULL,4557,68388000,'PA',NULL,1,'2006-11-12 16:55:01'),(2420,NULL,1,1,'BARCARENA',NULL,4558,68445000,'PA',NULL,1,'2006-11-12 16:55:01'),(2421,NULL,1,1,'BELM',NULL,4565,NULL,'PA',NULL,1,'2006-11-12 16:55:01'),(2422,NULL,1,1,'BELTERRA',NULL,4566,68143000,'PA',NULL,1,'2006-11-12 16:55:01'),(2423,NULL,1,1,'BENEVIDES',NULL,4567,68795000,'PA',NULL,1,'2006-11-12 16:55:01'),(2424,NULL,1,1,'BOM JESUS DO TOCANTINS',NULL,4576,68525000,'PA',NULL,1,'2006-11-12 16:55:01'),(2425,NULL,1,1,'BONITO',NULL,4577,68645000,'PA',NULL,1,'2006-11-12 16:55:01'),(2426,NULL,1,1,'BRAGANA',NULL,4578,68600000,'PA',NULL,1,'2006-11-12 16:55:01'),(2427,NULL,1,1,'BRASIL NOVO',NULL,4579,68148000,'PA',NULL,1,'2006-11-12 16:55:01'),(2428,NULL,1,1,'BREJO GRANDE DO ARAGUAIA',NULL,4582,68521000,'PA',NULL,1,'2006-11-12 16:55:01'),(2429,NULL,1,1,'BREU BRANCO',NULL,4583,68488000,'PA',NULL,1,'2006-11-12 16:55:01'),(2430,NULL,1,1,'BREVES',NULL,4584,68800000,'PA',NULL,1,'2006-11-12 16:55:01'),(2431,NULL,1,1,'BUJARU',NULL,4585,68670000,'PA',NULL,1,'2006-11-12 16:55:01'),(2432,NULL,1,1,'CACHOEIRA DE PRIA',NULL,4586,68617000,'PA',NULL,1,'2006-11-12 16:55:01'),(2433,NULL,1,1,'CACHOEIRA DO ARARI',NULL,4587,68840000,'PA',NULL,1,'2006-11-12 16:55:01'),(2434,NULL,1,1,'CAMET',NULL,4593,68400000,'PA',NULL,1,'2006-11-12 16:55:01'),(2435,NULL,1,1,'CANA DOS CARAJS',NULL,4595,68537000,'PA',NULL,1,'2006-11-12 16:55:01'),(2436,NULL,1,1,'CAPANEMA',NULL,4596,NULL,'PA',NULL,1,'2006-11-12 16:55:01'),(2437,NULL,1,1,'CAPITO POO',NULL,4597,68650000,'PA',NULL,1,'2006-11-12 16:55:01'),(2438,NULL,1,1,'CASTANHAL',NULL,4605,NULL,'PA',NULL,1,'2006-11-12 16:55:02'),(2439,NULL,1,1,'CHAVES',NULL,4607,68880000,'PA',NULL,1,'2006-11-12 16:55:02'),(2440,NULL,1,1,'COLARES',NULL,4608,68785000,'PA',NULL,1,'2006-11-12 16:55:02'),(2441,NULL,1,1,'CONCEIO DO ARAGUAIA',NULL,4610,68540000,'PA',NULL,1,'2006-11-12 16:55:02'),(2442,NULL,1,1,'CONCRDIA DO PAR',NULL,4611,68685000,'PA',NULL,1,'2006-11-12 16:55:02'),(2443,NULL,1,1,'CUMARU DO NORTE',NULL,4617,68398000,'PA',NULL,1,'2006-11-12 16:55:02'),(2444,NULL,1,1,'CURIONPOLIS',NULL,4618,68523000,'PA',NULL,1,'2006-11-12 16:55:02'),(2445,NULL,1,1,'CURRALINHO',NULL,4619,68815000,'PA',NULL,1,'2006-11-12 16:55:02'),(2446,NULL,1,1,'CURU',NULL,4620,68210000,'PA',NULL,1,'2006-11-12 16:55:02'),(2447,NULL,1,1,'CURU',NULL,4622,68750000,'PA',NULL,1,'2006-11-12 16:55:02'),(2448,NULL,1,1,'DOM ELISEU',NULL,4625,68633000,'PA',NULL,1,'2006-11-12 16:55:02'),(2449,NULL,1,1,'ELDORADO DOS CARAJS',NULL,4626,68524000,'PA',NULL,1,'2006-11-12 16:55:02'),(2450,NULL,1,1,'FARO',NULL,4629,68280000,'PA',NULL,1,'2006-11-12 16:55:02'),(2451,NULL,1,1,'FLORESTA DO ARAGUAIA',NULL,4633,68543000,'PA',NULL,1,'2006-11-12 16:55:02'),(2452,NULL,1,1,'GARRAFO DO NORTE',NULL,4634,68665000,'PA',NULL,1,'2006-11-12 16:55:02'),(2453,NULL,1,1,'GOIANSIA DO PAR',NULL,4635,68639000,'PA',NULL,1,'2006-11-12 16:55:02'),(2454,NULL,1,1,'GURUP',NULL,4639,68300000,'PA',NULL,1,'2006-11-12 16:55:02'),(2455,NULL,1,1,'IGARAP-AU',NULL,4645,68725000,'PA',NULL,1,'2006-11-12 16:55:02'),(2456,NULL,1,1,'IGARAP-MIRI',NULL,4646,68430000,'PA',NULL,1,'2006-11-12 16:55:02'),(2457,NULL,1,1,'INHANGAPI',NULL,4648,68770000,'PA',NULL,1,'2006-11-12 16:55:02'),(2458,NULL,1,1,'IPIXUNA DO PAR',NULL,4649,68637000,'PA',NULL,1,'2006-11-12 16:55:02'),(2459,NULL,1,1,'IRITUIA',NULL,4650,68655000,'PA',NULL,1,'2006-11-12 16:55:02'),(2460,NULL,1,1,'ITAITUBA',NULL,4651,NULL,'PA',NULL,1,'2006-11-12 16:55:03'),(2461,NULL,1,1,'ITUPIRANGA',NULL,4654,68580000,'PA',NULL,1,'2006-11-12 16:55:03'),(2462,NULL,1,1,'JACAREACANGA',NULL,4655,68195000,'PA',NULL,1,'2006-11-12 16:55:03'),(2463,NULL,1,1,'JACUND',NULL,4656,68590000,'PA',NULL,1,'2006-11-12 16:55:03'),(2464,NULL,1,1,'JURUTI',NULL,4667,68170000,'PA',NULL,1,'2006-11-12 16:55:03'),(2465,NULL,1,1,'LIMOEIRO DO AJURU',NULL,4672,68415000,'PA',NULL,1,'2006-11-12 16:55:03'),(2466,NULL,1,1,'ME DO RIO',NULL,4673,68675000,'PA',NULL,1,'2006-11-12 16:55:03'),(2467,NULL,1,1,'MAGALHES BARATA',NULL,4674,68722000,'PA',NULL,1,'2006-11-12 16:55:03'),(2468,NULL,1,1,'MARAB',NULL,4677,NULL,'PA',NULL,1,'2006-11-12 16:55:03'),(2469,NULL,1,1,'MARACAN',NULL,4678,68710000,'PA',NULL,1,'2006-11-12 16:55:03'),(2470,NULL,1,1,'MARAPANIM',NULL,4680,68760000,'PA',NULL,1,'2006-11-12 16:55:03'),(2471,NULL,1,1,'MARITUBA',NULL,4681,67200000,'PA',NULL,1,'2006-11-12 16:55:03'),(2472,NULL,1,1,'MEDICILNDIA',NULL,4685,68145000,'PA',NULL,1,'2006-11-12 16:55:03'),(2473,NULL,1,1,'MELGAO',NULL,4686,68490000,'PA',NULL,1,'2006-11-12 16:55:03'),(2474,NULL,1,1,'MOCAJUBA',NULL,4691,68420000,'PA',NULL,1,'2006-11-12 16:55:03'),(2475,NULL,1,1,'MOJU',NULL,4693,68450000,'PA',NULL,1,'2006-11-12 16:55:03'),(2476,NULL,1,1,'MONTE ALEGRE',NULL,4695,68220000,'PA',NULL,1,'2006-11-12 16:55:03'),(2477,NULL,1,1,'MUAN',NULL,4700,68825000,'PA',NULL,1,'2006-11-12 16:55:03'),(2478,NULL,1,1,'NOVA ESPERANA DO PIRI',NULL,4709,68618000,'PA',NULL,1,'2006-11-12 16:55:03'),(2479,NULL,1,1,'NOVA IPIXUNA',NULL,4710,68585000,'PA',NULL,1,'2006-11-12 16:55:04'),(2480,NULL,1,1,'NOVA TIMBOTEUA',NULL,4712,68730000,'PA',NULL,1,'2006-11-12 16:55:04'),(2481,NULL,1,1,'NOVO PROGRESSO',NULL,4714,68193000,'PA',NULL,1,'2006-11-12 16:55:04'),(2482,NULL,1,1,'NOVO REPARTIMENTO',NULL,4715,68473000,'PA',NULL,1,'2006-11-12 16:55:04'),(2483,NULL,1,1,'BIDOS',NULL,4717,68250000,'PA',NULL,1,'2006-11-12 16:55:04'),(2484,NULL,1,1,'OEIRAS DO PAR',NULL,4718,68470000,'PA',NULL,1,'2006-11-12 16:55:04'),(2485,NULL,1,1,'ORIXIMIN',NULL,4719,68270000,'PA',NULL,1,'2006-11-12 16:55:04'),(2486,NULL,1,1,'OURM',NULL,4722,68640000,'PA',NULL,1,'2006-11-12 16:55:04'),(2487,NULL,1,1,'OURILNDIA DO NORTE',NULL,4723,68390000,'PA',NULL,1,'2006-11-12 16:55:04'),(2488,NULL,1,1,'PACAJ',NULL,4725,68485000,'PA',NULL,1,'2006-11-12 16:55:04'),(2489,NULL,1,1,'PALESTINA DO PAR',NULL,4727,68535000,'PA',NULL,1,'2006-11-12 16:55:04'),(2490,NULL,1,1,'PARAGOMINAS',NULL,4728,NULL,'PA',NULL,1,'2006-11-12 16:55:04'),(2491,NULL,1,1,'PARAUAPEBAS',NULL,4730,68515000,'PA',NULL,1,'2006-11-12 16:55:04'),(2492,NULL,1,1,'PAU D\' ARCO',NULL,4731,68545000,'PA',NULL,1,'2006-11-12 16:55:04'),(2493,NULL,1,1,'PEIXE-BOI',NULL,4733,68734000,'PA',NULL,1,'2006-11-12 16:55:04'),(2494,NULL,1,1,'PIARRA',NULL,4738,68575000,'PA',NULL,1,'2006-11-12 16:55:04'),(2495,NULL,1,1,'PLACAS',NULL,4743,68138000,'PA',NULL,1,'2006-11-12 16:55:04'),(2496,NULL,1,1,'PONTA DE PEDRAS',NULL,4744,68830000,'PA',NULL,1,'2006-11-12 16:55:04'),(2497,NULL,1,1,'PORTEL',NULL,4746,68480000,'PA',NULL,1,'2006-11-12 16:55:04'),(2498,NULL,1,1,'PORTO DE MOZ',NULL,4747,68330000,'PA',NULL,1,'2006-11-12 16:55:04'),(2499,NULL,1,1,'PRAINHA',NULL,4750,68130000,'PA',NULL,1,'2006-11-12 16:55:04'),(2500,NULL,1,1,'PRIMAVERA',NULL,4751,68707000,'PA',NULL,1,'2006-11-12 16:55:04'),(2501,NULL,1,1,'QUATIPURU',NULL,4752,68709000,'PA',NULL,1,'2006-11-12 16:55:05'),(2502,NULL,1,1,'REDENO',NULL,4754,NULL,'PA',NULL,1,'2006-11-12 16:55:05'),(2503,NULL,1,1,'RIO MARIA',NULL,4757,68530000,'PA',NULL,1,'2006-11-12 16:55:05'),(2504,NULL,1,1,'RONDON DO PAR',NULL,4760,68638000,'PA',NULL,1,'2006-11-12 16:55:05'),(2505,NULL,1,1,'RURPOLIS',NULL,4761,68165000,'PA',NULL,1,'2006-11-12 16:55:05'),(2506,NULL,1,1,'SALINPOLIS',NULL,4762,68721000,'PA',NULL,1,'2006-11-12 16:55:05'),(2507,NULL,1,1,'SALVATERRA',NULL,4763,68860000,'PA',NULL,1,'2006-11-12 16:55:05'),(2508,NULL,1,1,'SANTA BRBARA DO PAR',NULL,4764,68798000,'PA',NULL,1,'2006-11-12 16:55:05'),(2509,NULL,1,1,'SANTA CRUZ DO ARARI',NULL,4765,68850000,'PA',NULL,1,'2006-11-12 16:55:05'),(2510,NULL,1,1,'SANTA ISABEL DO PAR',NULL,4766,68790000,'PA',NULL,1,'2006-11-12 16:55:05'),(2511,NULL,1,1,'SANTA LUZIA DO PAR',NULL,4767,68644000,'PA',NULL,1,'2006-11-12 16:55:05'),(2512,NULL,1,1,'SANTA MARIA DAS BARREIRAS',NULL,4769,68565000,'PA',NULL,1,'2006-11-12 16:55:05'),(2513,NULL,1,1,'SANTA MARIA DO PAR',NULL,4770,68738000,'PA',NULL,1,'2006-11-12 16:55:05'),(2514,NULL,1,1,'SANTANA DO ARAGUAIA',NULL,4773,68560000,'PA',NULL,1,'2006-11-12 16:55:05'),(2515,NULL,1,1,'SANTARM',NULL,4774,NULL,'PA',NULL,1,'2006-11-12 16:55:05'),(2516,NULL,1,1,'SANTARM NOVO',NULL,4775,68720000,'PA',NULL,1,'2006-11-12 16:55:05'),(2517,NULL,1,1,'SANTO ANTNIO DO TAU',NULL,4777,68786000,'PA',NULL,1,'2006-11-12 16:55:05'),(2518,NULL,1,1,'SO CAETANO DE ODIVELAS',NULL,4778,68775000,'PA',NULL,1,'2006-11-12 16:55:05'),(2519,NULL,1,1,'SO DOMINGOS DO ARAGUAIA',NULL,4779,68520000,'PA',NULL,1,'2006-11-12 16:55:05'),(2520,NULL,1,1,'SO DOMINGOS DO CAPIM',NULL,4780,68635000,'PA',NULL,1,'2006-11-12 16:55:05'),(2521,NULL,1,1,'SO FLIX DO XINGU',NULL,4781,68380000,'PA',NULL,1,'2006-11-12 16:55:05'),(2522,NULL,1,1,'SO FRANCISCO DO PAR',NULL,4784,68748000,'PA',NULL,1,'2006-11-12 16:55:05'),(2523,NULL,1,1,'SO GERALDO DO ARAGUAIA',NULL,4785,68570000,'PA',NULL,1,'2006-11-12 16:55:05'),(2524,NULL,1,1,'SO JOO DA PONTA',NULL,4786,68774000,'PA',NULL,1,'2006-11-12 16:55:06'),(2525,NULL,1,1,'SO JOO DE PIRABAS',NULL,4787,68719000,'PA',NULL,1,'2006-11-12 16:55:06'),(2526,NULL,1,1,'SO JOO DO ARAGUAIA',NULL,4789,68518000,'PA',NULL,1,'2006-11-12 16:55:06'),(2527,NULL,1,1,'SO MIGUEL DO GUAM',NULL,4797,68660000,'PA',NULL,1,'2006-11-12 16:55:06'),(2528,NULL,1,1,'SO SEBASTIO DA BOA VISTA',NULL,4805,68820000,'PA',NULL,1,'2006-11-12 16:55:06'),(2529,NULL,1,1,'SAPUCAIA',NULL,4807,68548000,'PA',NULL,1,'2006-11-12 16:55:06'),(2530,NULL,1,1,'SENADOR JOS PORFRIO',NULL,4808,68360000,'PA',NULL,1,'2006-11-12 16:55:06'),(2531,NULL,1,1,'SOURE',NULL,4810,68870000,'PA',NULL,1,'2006-11-12 16:55:06'),(2532,NULL,1,1,'TAILNDIA',NULL,4811,68695000,'PA',NULL,1,'2006-11-12 16:55:06'),(2533,NULL,1,1,'TERRA ALTA',NULL,4816,68773000,'PA',NULL,1,'2006-11-12 16:55:06'),(2534,NULL,1,1,'TERRA SANTA',NULL,4817,68285000,'PA',NULL,1,'2006-11-12 16:55:06'),(2535,NULL,1,1,'TOM-A',NULL,4820,68680000,'PA',NULL,1,'2006-11-12 16:55:06'),(2536,NULL,1,1,'TRACUATEUA',NULL,4821,68647000,'PA',NULL,1,'2006-11-12 16:55:06'),(2537,NULL,1,1,'TRAIRO',NULL,4822,68198000,'PA',NULL,1,'2006-11-12 16:55:06'),(2538,NULL,1,1,'TUCUM',NULL,4823,68385000,'PA',NULL,1,'2006-11-12 16:55:06'),(2539,NULL,1,1,'TUCURU',NULL,4824,NULL,'PA',NULL,1,'2006-11-12 16:55:06'),(2540,NULL,1,1,'ULIANPOLIS',NULL,4825,68632000,'PA',NULL,1,'2006-11-12 16:55:06'),(2541,NULL,1,1,'URUAR',NULL,4826,68140000,'PA',NULL,1,'2006-11-12 16:55:06'),(2542,NULL,1,1,'VIGIA',NULL,4831,68780000,'PA',NULL,1,'2006-11-12 16:55:06'),(2543,NULL,1,1,'VISEU',NULL,4842,68620000,'PA',NULL,1,'2006-11-12 16:55:06'),(2544,NULL,1,1,'VITRIA DO XINGU',NULL,4845,68383000,'PA',NULL,1,'2006-11-12 16:55:06'),(2545,NULL,1,1,'XINGUARA',NULL,4846,NULL,'PA',NULL,1,'2006-11-12 16:55:06'),(2546,NULL,1,28,'GUA BRANCA',NULL,4848,58748000,'PB','2500106',1,'2006-11-12 16:55:07'),(2547,NULL,1,28,'AGUIAR',NULL,4849,58778000,'PB','2500205',1,'2006-11-12 16:55:07'),(2548,NULL,1,28,'ALAGOA GRANDE',NULL,4850,58388000,'PB','2500304',1,'2006-11-12 16:55:07'),(2549,NULL,1,28,'ALAGOA NOVA',NULL,4851,58125000,'PB','2500403',1,'2006-11-12 16:55:07'),(2550,NULL,1,28,'ALAGOINHA',NULL,4852,58390000,'PB','2500502',1,'2006-11-12 16:55:07'),(2551,NULL,1,28,'ALCANTIL',NULL,4853,58460000,'PB','2500536',1,'2006-11-12 16:55:07'),(2552,NULL,1,28,'ALGODO DE JANDARA',NULL,4854,58399000,'PB','2500577',1,'2006-11-12 16:55:07'),(2553,NULL,1,28,'ALHANDRA',NULL,4855,58320000,'PB','2500601',1,'2006-11-12 16:55:07'),(2554,NULL,1,28,'AMPARO',NULL,4856,58548000,'PB','2500734',1,'2006-11-12 16:55:07'),(2555,NULL,1,28,'APARECIDA',NULL,4857,58823000,'PB','2500775',1,'2006-11-12 16:55:07'),(2556,NULL,1,28,'ARAAGI',NULL,4858,58270000,'PB','2500809',1,'2006-11-12 16:55:07'),(2557,NULL,1,28,'ARARA',NULL,4859,58396000,'PB','2500908',1,'2006-11-12 16:55:07'),(2558,NULL,1,28,'ARARUNA',NULL,4860,58233000,'PB','2501005',1,'2006-11-12 16:55:07'),(2559,NULL,1,28,'AREIA',NULL,4861,58397000,'PB','2501104',1,'2006-11-12 16:55:07'),(2560,NULL,1,28,'AREIA DE BARANAS',NULL,4862,58732000,'PB','2501153',1,'2006-11-12 16:55:07'),(2561,NULL,1,28,'AREIAL',NULL,4863,58140000,'PB','2501203',1,'2006-11-12 16:55:07'),(2562,NULL,1,28,'AROEIRAS',NULL,4865,58400000,'PB','2501302',1,'2006-11-12 16:55:07'),(2563,NULL,1,28,'ASSIS CHATEAUBRIAND',NULL,4866,58382000,'PB',NULL,1,'2006-11-12 16:55:07'),(2564,NULL,1,28,'ASSUNO',NULL,4867,58685000,'PB','2501351',1,'2006-11-12 16:55:07'),(2565,NULL,1,28,'BAA DA TRAIO',NULL,4868,58295000,'PB','2501401',1,'2006-11-12 16:55:07'),(2566,NULL,1,28,'BANANEIRAS',NULL,4870,58220000,'PB','2501500',1,'2006-11-12 16:55:07'),(2567,NULL,1,28,'BARANA',NULL,4871,58188000,'PB','2501534',1,'2006-11-12 16:55:07'),(2568,NULL,1,28,'BARRA DE SANTA ROSA',NULL,4872,58170000,'PB','2501609',1,'2006-11-12 16:55:08'),(2569,NULL,1,28,'BARRA DE SANTANA',NULL,4873,58458000,'PB','2501575',1,'2006-11-12 16:55:08'),(2570,NULL,1,28,'BARRA DE SO MIGUEL',NULL,4874,58470000,'PB','2501708',1,'2006-11-12 16:55:08'),(2571,NULL,1,28,'BAYEUX',NULL,4876,NULL,'PB','2501807',1,'2006-11-12 16:55:08'),(2572,NULL,1,28,'BELM',NULL,4877,58255000,'PB','2501906',1,'2006-11-12 16:55:08'),(2573,NULL,1,28,'BELM DO BREJO DO CRUZ',NULL,4878,58895000,'PB','2502003',1,'2006-11-12 16:55:08'),(2574,NULL,1,28,'BERNARDINO BATISTA',NULL,4879,58922000,'PB','2502052',1,'2006-11-12 16:55:08'),(2575,NULL,1,28,'BOA VENTURA',NULL,4880,58993000,'PB','2502102',1,'2006-11-12 16:55:08'),(2576,NULL,1,28,'BOA VISTA',NULL,4881,58123000,'PB','2502151',1,'2006-11-12 16:55:08'),(2577,NULL,1,28,'BOM JESUS',NULL,4882,58930000,'PB','2502201',1,'2006-11-12 16:55:08'),(2578,NULL,1,28,'BOM SUCESSO',NULL,4883,58887000,'PB','2502300',1,'2006-11-12 16:55:08'),(2579,NULL,1,28,'BONITO DE SANTA F',NULL,4885,58960000,'PB','2502409',1,'2006-11-12 16:55:08'),(2580,NULL,1,28,'BOQUEIRO',NULL,4886,58450000,'PB','2502508',1,'2006-11-12 16:55:08'),(2581,NULL,1,28,'BORBOREMA',NULL,4887,58394000,'PB','2502706',1,'2006-11-12 16:55:08'),(2582,NULL,1,28,'BREJO DO CRUZ',NULL,4888,58890000,'PB','2502805',1,'2006-11-12 16:55:08'),(2583,NULL,1,28,'BREJO DOS SANTOS',NULL,4889,58880000,'PB','2502904',1,'2006-11-12 16:55:08'),(2584,NULL,1,28,'CAAPOR',NULL,4890,58326000,'PB','2503001',1,'2006-11-12 16:55:08'),(2585,NULL,1,28,'CABACEIRAS',NULL,4891,58480000,'PB','2503100',1,'2006-11-12 16:55:08'),(2586,NULL,1,28,'CABEDELO',NULL,4892,58310000,'PB','2503209',1,'2006-11-12 16:55:08'),(2587,NULL,1,28,'CACHOEIRA DOS NDIOS',NULL,4894,58935000,'PB','2503308',1,'2006-11-12 16:55:08'),(2588,NULL,1,28,'CACIMBA DE AREIA',NULL,4896,58730000,'PB','2503407',1,'2006-11-12 16:55:08'),(2589,NULL,1,28,'CACIMBA DE DENTRO',NULL,4897,58230000,'PB','2503506',1,'2006-11-12 16:55:08'),(2590,NULL,1,28,'CACIMBAS',NULL,4898,58698000,'PB','2503555',1,'2006-11-12 16:55:08'),(2591,NULL,1,28,'CAIARA',NULL,4899,58253000,'PB','2503605',1,'2006-11-12 16:55:09'),(2592,NULL,1,28,'CAJAZEIRAS',NULL,4900,58900000,'PB','2503704',1,'2006-11-12 16:55:09'),(2593,NULL,1,28,'CAJAZEIRINHAS',NULL,4901,58855000,'PB','2503753',1,'2006-11-12 16:55:09'),(2594,NULL,1,28,'CALDAS BRANDO',NULL,4902,58350000,'PB','2503803',1,'2006-11-12 16:55:09'),(2595,NULL,1,28,'CAMALA',NULL,4903,58530000,'PB','2503902',1,'2006-11-12 16:55:09'),(2596,NULL,1,28,'CAMPINA GRANDE',NULL,4904,NULL,'PB','2504009',1,'2006-11-12 16:55:09'),(2597,NULL,1,28,'CAPIM',NULL,4908,58287000,'PB','2504033',1,'2006-11-12 16:55:09'),(2598,NULL,1,28,'CARABAS',NULL,4909,58595000,'PB','2504074',1,'2006-11-12 16:55:09'),(2599,NULL,1,28,'CARRAPATEIRA',NULL,4911,58945000,'PB','2504108',1,'2006-11-12 16:55:09'),(2600,NULL,1,28,'CASSERENGUE',NULL,4913,58238000,'PB','2504157',1,'2006-11-12 16:55:09'),(2601,NULL,1,28,'CATINGUEIRA',NULL,4914,58715000,'PB','2504207',1,'2006-11-12 16:55:09'),(2602,NULL,1,28,'CATOL DO ROCHA',NULL,4916,58884000,'PB','2504306',1,'2006-11-12 16:55:09'),(2603,NULL,1,28,'CATURIT',NULL,4917,58455000,'PB','2504355',1,'2006-11-12 16:55:09'),(2604,NULL,1,28,'CONCEIO',NULL,4919,58970000,'PB','2504405',1,'2006-11-12 16:55:09'),(2605,NULL,1,28,'CONDADO',NULL,4920,58714000,'PB','2504504',1,'2006-11-12 16:55:09'),(2606,NULL,1,28,'CONDE',NULL,4921,58322000,'PB','2504603',1,'2006-11-12 16:55:09'),(2607,NULL,1,28,'CONGO',NULL,4922,58535000,'PB','2504702',1,'2006-11-12 16:55:09'),(2608,NULL,1,28,'COREMAS',NULL,4923,58770000,'PB','2504801',1,'2006-11-12 16:55:09'),(2609,NULL,1,28,'COXIXOLA',NULL,4925,58588000,'PB','2504850',1,'2006-11-12 16:55:09'),(2610,NULL,1,28,'CRUZ DO ESPRITO SANTO',NULL,4926,58337000,'PB','2504900',1,'2006-11-12 16:55:09'),(2611,NULL,1,28,'CUBATI',NULL,4927,58167000,'PB','2505006',1,'2006-11-12 16:55:09'),(2612,NULL,1,28,'CUIT',NULL,4928,58175000,'PB','2505105',1,'2006-11-12 16:55:09'),(2613,NULL,1,28,'CUIT DE MAMANGUAPE',NULL,4929,58289000,'PB','2505238',1,'2006-11-12 16:55:09'),(2614,NULL,1,28,'CUITEGI',NULL,4930,58208000,'PB','2505204',1,'2006-11-12 16:55:10'),(2615,NULL,1,28,'CURRAL DE CIMA',NULL,4932,58291000,'PB','2505279',1,'2006-11-12 16:55:10'),(2616,NULL,1,28,'CURRAL VELHO',NULL,4933,58990000,'PB','2505303',1,'2006-11-12 16:55:10'),(2617,NULL,1,28,'DAMIO',NULL,4934,58173000,'PB','2505352',1,'2006-11-12 16:55:10'),(2618,NULL,1,28,'DESTERRO',NULL,4935,58695000,'PB','2505402',1,'2006-11-12 16:55:10'),(2619,NULL,1,28,'DIAMANTE',NULL,4936,58994000,'PB','2505600',1,'2006-11-12 16:55:10'),(2620,NULL,1,28,'DONA INS',NULL,4937,58228000,'PB','2505709',1,'2006-11-12 16:55:10'),(2621,NULL,1,28,'DUAS ESTRADAS',NULL,4938,58265000,'PB','2505808',1,'2006-11-12 16:55:10'),(2622,NULL,1,28,'EMAS',NULL,4939,58763000,'PB','2505907',1,'2006-11-12 16:55:10'),(2623,NULL,1,28,'ESPERANA',NULL,4941,58135000,'PB','2506004',1,'2006-11-12 16:55:10'),(2624,NULL,1,28,'FAGUNDES',NULL,4942,58430000,'PB','2506103',1,'2006-11-12 16:55:10'),(2625,NULL,1,28,'FREI MARTINHO',NULL,4946,58195000,'PB','2506202',1,'2006-11-12 16:55:10'),(2626,NULL,1,28,'GADO BRAVO',NULL,4947,58405000,'PB','2506251',1,'2006-11-12 16:55:10'),(2627,NULL,1,28,'GUARABIRA',NULL,4949,58200000,'PB','2506301',1,'2006-11-12 16:55:10'),(2628,NULL,1,28,'GURINHM',NULL,4951,58356000,'PB','2506400',1,'2006-11-12 16:55:10'),(2629,NULL,1,28,'GURJO',NULL,4952,58670000,'PB','2506509',1,'2006-11-12 16:55:10'),(2630,NULL,1,28,'IBIARA',NULL,4953,58980000,'PB','2506608',1,'2006-11-12 16:55:10'),(2631,NULL,1,28,'IGARACY',NULL,4954,58775000,'PB','2502607',1,'2006-11-12 16:55:10'),(2632,NULL,1,28,'IMACULADA',NULL,4955,58745000,'PB','2506707',1,'2006-11-12 16:55:10'),(2633,NULL,1,28,'ING',NULL,4956,58380000,'PB','2506806',1,'2006-11-12 16:55:10'),(2634,NULL,1,28,'ITABAIANA',NULL,4957,58360000,'PB','2506905',1,'2006-11-12 16:55:10'),(2635,NULL,1,28,'ITAPORANGA',NULL,4959,58780000,'PB','2507002',1,'2006-11-12 16:55:11'),(2636,NULL,1,28,'ITAPOROROCA',NULL,4960,58275000,'PB','2507101',1,'2006-11-12 16:55:11'),(2637,NULL,1,28,'ITATUBA',NULL,4961,58378000,'PB','2507200',1,'2006-11-12 16:55:11'),(2638,NULL,1,28,'JACARA',NULL,4962,58278000,'PB','2507309',1,'2006-11-12 16:55:11'),(2639,NULL,1,28,'JERIC',NULL,4963,58830000,'PB','2507408',1,'2006-11-12 16:55:11'),(2640,NULL,1,28,'JOO PESSOA',NULL,4964,NULL,'PB','2507507',1,'2006-11-12 16:55:11'),(2641,NULL,1,28,'JUAREZ TVORA',NULL,4965,58387000,'PB','2507606',1,'2006-11-12 16:55:11'),(2642,NULL,1,28,'JUAZEIRINHO',NULL,4966,58660000,'PB','2507705',1,'2006-11-12 16:55:11'),(2643,NULL,1,28,'JUNCO DO SERID',NULL,4967,58640000,'PB','2507804',1,'2006-11-12 16:55:11'),(2644,NULL,1,28,'JURIPIRANGA',NULL,4968,58330000,'PB','2507903',1,'2006-11-12 16:55:11'),(2645,NULL,1,28,'JURU',NULL,4969,58750000,'PB','2508000',1,'2006-11-12 16:55:11'),(2646,NULL,1,28,'LAGOA',NULL,4970,58835000,'PB','2508109',1,'2006-11-12 16:55:11'),(2647,NULL,1,28,'LAGOA DE DENTRO',NULL,4971,58250000,'PB','2508208',1,'2006-11-12 16:55:11'),(2648,NULL,1,28,'LAGOA SECA',NULL,4973,58117000,'PB','2508307',1,'2006-11-12 16:55:11'),(2649,NULL,1,28,'LASTRO',NULL,4974,58820000,'PB','2508406',1,'2006-11-12 16:55:11'),(2650,NULL,1,28,'LIVRAMENTO',NULL,4976,58690000,'PB','2508505',1,'2006-11-12 16:55:11'),(2651,NULL,1,28,'LOGRADOURO',NULL,4977,58254000,'PB','2508554',1,'2006-11-12 16:55:11'),(2652,NULL,1,28,'LUCENA',NULL,4978,58315000,'PB','2508604',1,'2006-11-12 16:55:11'),(2653,NULL,1,28,'ME D\'GUA',NULL,4979,58740000,'PB',NULL,1,'2006-11-12 16:55:11'),(2654,NULL,1,28,'MALTA',NULL,4981,58713000,'PB','2508802',1,'2006-11-12 16:55:11'),(2655,NULL,1,28,'MAMANGUAPE',NULL,4982,58280000,'PB','2508901',1,'2006-11-12 16:55:12'),(2656,NULL,1,28,'MANARA',NULL,4983,58995000,'PB','2509008',1,'2006-11-12 16:55:12'),(2657,NULL,1,28,'MARCAO',NULL,4984,58294000,'PB','2509057',1,'2006-11-12 16:55:12'),(2658,NULL,1,28,'MARI',NULL,4985,58345000,'PB','2509107',1,'2006-11-12 16:55:12'),(2659,NULL,1,28,'MARIZPOLIS',NULL,4986,58819000,'PB','2509156',1,'2006-11-12 16:55:12'),(2660,NULL,1,28,'MASSARANDUBA',NULL,4987,58120000,'PB','2509206',1,'2006-11-12 16:55:12'),(2661,NULL,1,28,'MATARACA',NULL,4990,58292000,'PB','2509305',1,'2006-11-12 16:55:12'),(2662,NULL,1,28,'MATINHAS',NULL,4991,58128000,'PB','2509339',1,'2006-11-12 16:55:12'),(2663,NULL,1,28,'MATO GROSSO',NULL,4992,58832000,'PB','2509370',1,'2006-11-12 16:55:12'),(2664,NULL,1,28,'MATURIA',NULL,4993,58737000,'PB','2509396',1,'2006-11-12 16:55:12'),(2665,NULL,1,28,'MOGEIRO',NULL,4995,58375000,'PB','2509404',1,'2006-11-12 16:55:12'),(2666,NULL,1,28,'MONTADAS',NULL,4996,58145000,'PB','2509503',1,'2006-11-12 16:55:12'),(2667,NULL,1,28,'MONTE HOREBE',NULL,4997,58950000,'PB','2509602',1,'2006-11-12 16:55:12'),(2668,NULL,1,28,'MONTEIRO',NULL,4998,58500000,'PB','2509701',1,'2006-11-12 16:55:12'),(2669,NULL,1,28,'MULUNGU',NULL,5000,58354000,'PB','2509800',1,'2006-11-12 16:55:12'),(2670,NULL,1,28,'NATUBA',NULL,5002,58410000,'PB','2509909',1,'2006-11-12 16:55:12'),(2671,NULL,1,28,'NAZAREZINHO',NULL,5004,58817000,'PB','2510006',1,'2006-11-12 16:55:12'),(2672,NULL,1,28,'NOVA FLORESTA',NULL,5006,58178000,'PB','2510105',1,'2006-11-12 16:55:12'),(2673,NULL,1,28,'NOVA OLINDA',NULL,5007,58798000,'PB','2510204',1,'2006-11-12 16:55:12'),(2674,NULL,1,28,'NOVA PALMEIRA',NULL,5008,58184000,'PB','2510303',1,'2006-11-12 16:55:12'),(2675,NULL,1,28,'OLHO D\' GUA',NULL,5012,58760000,'PB',NULL,1,'2006-11-12 16:55:12'),(2676,NULL,1,28,'OLIVEDOS',NULL,5013,58160000,'PB','2510501',1,'2006-11-12 16:55:12'),(2677,NULL,1,28,'OURO VELHO',NULL,5014,58560000,'PB','2510600',1,'2006-11-12 16:55:13'),(2678,NULL,1,28,'PARARI',NULL,5015,58575000,'PB','2510659',1,'2006-11-12 16:55:13'),(2679,NULL,1,28,'PASSAGEM',NULL,5016,58734000,'PB','2510709',1,'2006-11-12 16:55:13'),(2680,NULL,1,28,'PATOS',NULL,5017,NULL,'PB','2510808',1,'2006-11-12 16:55:13'),(2681,NULL,1,28,'PAULISTA',NULL,5018,58860000,'PB','2510907',1,'2006-11-12 16:55:13'),(2682,NULL,1,28,'PEDRA BRANCA',NULL,5019,58790000,'PB','2511004',1,'2006-11-12 16:55:13'),(2683,NULL,1,28,'PEDRA LAVRADA',NULL,5020,58180000,'PB','2511103',1,'2006-11-12 16:55:13'),(2684,NULL,1,28,'PEDRAS DE FOGO',NULL,5021,58328000,'PB','2511202',1,'2006-11-12 16:55:13'),(2685,NULL,1,28,'PEDRO RGIS',NULL,5022,58273000,'PB','2512721',1,'2006-11-12 16:55:13'),(2686,NULL,1,28,'PIANC',NULL,5025,58765000,'PB','2511301',1,'2006-11-12 16:55:13'),(2687,NULL,1,28,'PICU',NULL,5026,58187000,'PB','2511400',1,'2006-11-12 16:55:13'),(2688,NULL,1,28,'PILAR',NULL,5027,58338000,'PB','2511509',1,'2006-11-12 16:55:13'),(2689,NULL,1,28,'PILES',NULL,5028,58393000,'PB','2511608',1,'2006-11-12 16:55:13'),(2690,NULL,1,28,'PILEZINHOS',NULL,5029,58210000,'PB','2511707',1,'2006-11-12 16:55:13'),(2691,NULL,1,28,'PIRPIRITUBA',NULL,5033,58213000,'PB','2511806',1,'2006-11-12 16:55:13'),(2692,NULL,1,28,'PITIMBU',NULL,5035,58324000,'PB','2511905',1,'2006-11-12 16:55:13'),(2693,NULL,1,28,'POCINHOS',NULL,5036,58150000,'PB','2512002',1,'2006-11-12 16:55:13'),(2694,NULL,1,28,'POO DANTAS',NULL,5037,58933000,'PB','2512036',1,'2006-11-12 16:55:13'),(2695,NULL,1,28,'POO DE JOS DE MOURA',NULL,5038,58908000,'PB','2512077',1,'2006-11-12 16:55:13'),(2696,NULL,1,28,'POMBAL',NULL,5039,58840000,'PB','2512101',1,'2006-11-12 16:55:13'),(2697,NULL,1,28,'PRATA',NULL,5041,58550000,'PB','2512200',1,'2006-11-12 16:55:13'),(2698,NULL,1,28,'PRINCESA ISABEL',NULL,5042,58755000,'PB','2512309',1,'2006-11-12 16:55:14'),(2699,NULL,1,28,'PUXINAN',NULL,5043,58115000,'PB','2512408',1,'2006-11-12 16:55:14'),(2700,NULL,1,28,'QUEIMADAS',NULL,5044,58440000,'PB','2512507',1,'2006-11-12 16:55:14'),(2701,NULL,1,28,'QUIXAB',NULL,5045,58733000,'PB','2512606',1,'2006-11-12 16:55:14'),(2702,NULL,1,28,'REMGIO',NULL,5047,58398000,'PB','2512705',1,'2006-11-12 16:55:14'),(2703,NULL,1,28,'RIACHO',NULL,5048,58235000,'PB','2512747',1,'2006-11-12 16:55:14'),(2704,NULL,1,28,'RIACHO DO POO',NULL,5049,58348000,'PB','2512762',1,'2006-11-12 16:55:14'),(2705,NULL,1,28,'RIACHO DE SANTO ANTNIO',NULL,5050,58465000,'PB','2512788',1,'2006-11-12 16:55:14'),(2706,NULL,1,28,'RIACHO DOS CAVALOS',NULL,5051,58870000,'PB','2512804',1,'2006-11-12 16:55:14'),(2707,NULL,1,28,'RIO TINTO',NULL,5053,58297000,'PB','2512903',1,'2006-11-12 16:55:14'),(2708,NULL,1,28,'SALGADINHO',NULL,5056,58650000,'PB','2513000',1,'2006-11-12 16:55:14'),(2709,NULL,1,28,'SALGADO DE SO FLIX',NULL,5057,58370000,'PB','2513109',1,'2006-11-12 16:55:14'),(2710,NULL,1,28,'SANTA CECLIA DE UMBUZEIRO',NULL,5058,58428000,'PB',NULL,1,'2006-11-12 16:55:14'),(2711,NULL,1,28,'SANTA CRUZ',NULL,5059,58824000,'PB','2513208',1,'2006-11-12 16:55:14'),(2712,NULL,1,28,'SANTA HELENA',NULL,5061,58925000,'PB','2513307',1,'2006-11-12 16:55:14'),(2713,NULL,1,28,'SANTA INS',NULL,5062,58978000,'PB','2513356',1,'2006-11-12 16:55:14'),(2714,NULL,1,28,'SANTA LUZIA',NULL,5063,58600000,'PB','2513406',1,'2006-11-12 16:55:15'),(2715,NULL,1,28,'SANTA RITA',NULL,5066,NULL,'PB','2513703',1,'2006-11-12 16:55:15'),(2716,NULL,1,28,'SANTA TERESINHA',NULL,5068,58720000,'PB','2513802',1,'2006-11-12 16:55:15'),(2717,NULL,1,28,'SANTANA DE MANGUEIRA',NULL,5070,58985000,'PB','2513505',1,'2006-11-12 16:55:15'),(2718,NULL,1,28,'SANTANA DOS GARROTES',NULL,5071,58795000,'PB','2513604',1,'2006-11-12 16:55:15'),(2719,NULL,1,28,'SANTARM',NULL,5072,58928000,'PB','2513653',1,'2006-11-12 16:55:15'),(2720,NULL,1,28,'SANTO ANDR',NULL,5073,58675000,'PB','2513851',1,'2006-11-12 16:55:15'),(2721,NULL,1,28,'SO BENTO',NULL,5074,58865000,'PB','2513901',1,'2006-11-12 16:55:15'),(2722,NULL,1,28,'SO BENTO DE POMBAL',NULL,5075,58857000,'PB',NULL,1,'2006-11-12 16:55:15'),(2723,NULL,1,28,'SO DOMINGOS DE POMBAL',NULL,5076,58853000,'PB','2513968',1,'2006-11-12 16:55:15'),(2724,NULL,1,28,'SO DOMINGOS DO CARIRI',NULL,5077,58485000,'PB','2513943',1,'2006-11-12 16:55:15'),(2725,NULL,1,28,'SO FRANCISCO',NULL,5078,58818000,'PB','2513984',1,'2006-11-12 16:55:15'),(2726,NULL,1,28,'SO JOO DO CARIRI',NULL,5081,58590000,'PB','2514008',1,'2006-11-12 16:55:15'),(2727,NULL,1,28,'SO JOO DO RIO DO PEIXE',NULL,5082,58910000,'PB','2500700',1,'2006-11-12 16:55:15'),(2728,NULL,1,28,'SO JOO DO TIGRE',NULL,5083,58520000,'PB','2514107',1,'2006-11-12 16:55:15'),(2729,NULL,1,28,'SO JOS DA LAGOA TAPADA',NULL,5084,58815000,'PB','2514206',1,'2006-11-12 16:55:15'),(2730,NULL,1,28,'SO JOS DE CAIANA',NULL,5086,58784000,'PB','2514305',1,'2006-11-12 16:55:15'),(2731,NULL,1,28,'SO JOS DE ESPINHARAS',NULL,5087,58723000,'PB','2514404',1,'2006-11-12 16:55:15'),(2732,NULL,1,28,'SO JOS DE PIRANHAS',NULL,5089,58940000,'PB','2514503',1,'2006-11-12 16:55:15'),(2733,NULL,1,28,'SO JOS DE PRINCESA',NULL,5090,58758000,'PB','2514552',1,'2006-11-12 16:55:15'),(2734,NULL,1,28,'SO JOS DO BONFIM',NULL,5091,58725000,'PB','2514602',1,'2006-11-12 16:55:15'),(2735,NULL,1,28,'SO JOS DO BREJO DO CRUZ',NULL,5092,58893000,'PB','2514651',1,'2006-11-12 16:55:15'),(2736,NULL,1,28,'SO JOS DO SABUGI',NULL,5093,58610000,'PB','2514701',1,'2006-11-12 16:55:15'),(2737,NULL,1,28,'SO JOS DOS CORDEIROS',NULL,5094,58570000,'PB','2514800',1,'2006-11-12 16:55:16'),(2738,NULL,1,28,'SO JOS DOS RAMOS',NULL,5095,58339000,'PB','2514453',1,'2006-11-12 16:55:16'),(2739,NULL,1,28,'SO MAMEDE',NULL,5096,58625000,'PB','2514909',1,'2006-11-12 16:55:16'),(2740,NULL,1,28,'SO MIGUEL DE TAIP',NULL,5097,58334000,'PB','2515005',1,'2006-11-12 16:55:16'),(2741,NULL,1,28,'SO SEBASTIO DE LAGOA DE ROCA',NULL,5099,58119000,'PB','2515104',1,'2006-11-12 16:55:16'),(2742,NULL,1,28,'SO SEBASTIO DO UMBUZEIRO',NULL,5100,58510000,'PB','2515203',1,'2006-11-12 16:55:16'),(2743,NULL,1,28,'SAP',NULL,5101,58340000,'PB','2515302',1,'2006-11-12 16:55:16'),(2744,NULL,1,28,'SO VICENTE DO SERID',NULL,5103,58158000,'PB',NULL,1,'2006-11-12 16:55:16'),(2745,NULL,1,28,'SERRA BRANCA',NULL,5104,58580000,'PB','2515500',1,'2006-11-12 16:55:16'),(2746,NULL,1,28,'SERRA DA RAIZ',NULL,5105,58260000,'PB','2515609',1,'2006-11-12 16:55:16'),(2747,NULL,1,28,'SERRA GRANDE',NULL,5106,58955000,'PB','2515708',1,'2006-11-12 16:55:16'),(2748,NULL,1,28,'SERRA REDONDA',NULL,5107,58385000,'PB','2515807',1,'2006-11-12 16:55:16'),(2749,NULL,1,28,'SERRARIA',NULL,5108,58395000,'PB','2515906',1,'2006-11-12 16:55:16'),(2750,NULL,1,28,'SERTOZINHO',NULL,5109,58268000,'PB','2515930',1,'2006-11-12 16:55:16'),(2751,NULL,1,28,'SOBRADO',NULL,5110,58342000,'PB','2515971',1,'2006-11-12 16:55:16'),(2752,NULL,1,28,'SOLNEA',NULL,5111,58225000,'PB','2516003',1,'2006-11-12 16:55:16'),(2753,NULL,1,28,'SOLEDADE',NULL,5112,58155000,'PB','2516102',1,'2006-11-12 16:55:16'),(2754,NULL,1,28,'SOSSEGO',NULL,5113,58177000,'PB','2516151',1,'2006-11-12 16:55:16'),(2755,NULL,1,28,'SOUSA',NULL,5114,NULL,'PB','2516201',1,'2006-11-12 16:55:16'),(2756,NULL,1,28,'SUM',NULL,5116,58540000,'PB','2516300',1,'2006-11-12 16:55:16'),(2757,NULL,1,28,'CAMPO DE SANTANA',NULL,5117,58240000,'PB','2516409',1,'2006-11-12 16:55:17'),(2758,NULL,1,28,'TAPERO',NULL,5120,58680000,'PB','2516508',1,'2006-11-12 16:55:17'),(2759,NULL,1,28,'TAVARES',NULL,5121,58753000,'PB','2516607',1,'2006-11-12 16:55:17'),(2760,NULL,1,28,'TEIXEIRA',NULL,5122,58735000,'PB','2516706',1,'2006-11-12 16:55:17'),(2761,NULL,1,28,'TENRIO',NULL,5123,58665000,'PB','2516755',1,'2006-11-12 16:55:17'),(2762,NULL,1,28,'TRIUNFO',NULL,5124,58920000,'PB','2516805',1,'2006-11-12 16:55:17'),(2763,NULL,1,28,'UIRANA',NULL,5125,58915000,'PB','2516904',1,'2006-11-12 16:55:17'),(2764,NULL,1,28,'UMBUZEIRO',NULL,5127,58420000,'PB','2517001',1,'2006-11-12 16:55:17'),(2765,NULL,1,28,'VRZEA',NULL,5128,58620000,'PB','2517100',1,'2006-11-12 16:55:17'),(2766,NULL,1,28,'VIEIRPOLIS',NULL,5132,58822000,'PB','2517209',1,'2006-11-12 16:55:17'),(2767,NULL,1,28,'VISTA SERRANA',NULL,5133,58710000,'PB','2505501',1,'2006-11-12 16:55:17'),(2768,NULL,1,28,'ZABEL',NULL,5134,58515000,'PB','2517407',1,'2006-11-12 16:55:17'),(2769,NULL,1,17,'ABREU E LIMA',NULL,5135,NULL,'PE','2600054',1,'2006-11-12 16:55:17'),(2770,NULL,1,17,'AFOGADOS DA INGAZEIRA',NULL,5136,56800000,'PE','2600104',1,'2006-11-12 16:55:17'),(2771,NULL,1,17,'AFRNIO',NULL,5137,56360000,'PE','2600203',1,'2006-11-12 16:55:17'),(2772,NULL,1,17,'AGRESTINA',NULL,5138,55495000,'PE','2600302',1,'2006-11-12 16:55:17'),(2773,NULL,1,17,'GUA PRETA',NULL,5140,55550000,'PE','2600401',1,'2006-11-12 16:55:17'),(2774,NULL,1,17,'GUAS BELAS',NULL,5141,55340000,'PE','2600500',1,'2006-11-12 16:55:17'),(2775,NULL,1,17,'ALAGOINHA',NULL,5143,55260000,'PE','2600609',1,'2006-11-12 16:55:17'),(2776,NULL,1,17,'ALIANA',NULL,5146,55890000,'PE','2600708',1,'2006-11-12 16:55:17'),(2777,NULL,1,17,'ALTINHO',NULL,5147,55490000,'PE','2600807',1,'2006-11-12 16:55:17'),(2778,NULL,1,17,'AMARAJI',NULL,5148,55515000,'PE','2600906',1,'2006-11-12 16:55:17'),(2779,NULL,1,17,'ANGELIM',NULL,5150,55430000,'PE','2601003',1,'2006-11-12 16:55:17'),(2780,NULL,1,17,'ARAOIABA',NULL,5152,53690000,'PE','2601052',1,'2006-11-12 16:55:17'),(2781,NULL,1,17,'ARARIPINA',NULL,5153,56280000,'PE','2601102',1,'2006-11-12 16:55:18'),(2782,NULL,1,17,'ARCOVERDE',NULL,5154,NULL,'PE','2601201',1,'2006-11-12 16:55:18'),(2783,NULL,1,17,'BARRA DE GUABIRABA',NULL,5158,55690000,'PE','2601300',1,'2006-11-12 16:55:18'),(2784,NULL,1,17,'BARREIROS',NULL,5165,55560000,'PE','2601409',1,'2006-11-12 16:55:18'),(2785,NULL,1,17,'BELM DE MARIA',NULL,5167,55440000,'PE','2601508',1,'2006-11-12 16:55:18'),(2786,NULL,1,17,'BELM DE SO FRANCISCO',NULL,5168,56440000,'PE','2601607',1,'2006-11-12 16:55:18'),(2787,NULL,1,17,'BELO JARDIM',NULL,5169,55150000,'PE','2601706',1,'2006-11-12 16:55:18'),(2788,NULL,1,17,'BETNIA',NULL,5173,56670000,'PE','2601805',1,'2006-11-12 16:55:18'),(2789,NULL,1,17,'BEZERROS',NULL,5174,55660000,'PE','2601904',1,'2006-11-12 16:55:18'),(2790,NULL,1,17,'BODOC',NULL,5177,56220000,'PE','2602001',1,'2006-11-12 16:55:18'),(2791,NULL,1,17,'BOM CONSELHO',NULL,5178,55330000,'PE','2602100',1,'2006-11-12 16:55:18'),(2792,NULL,1,17,'BOM JARDIM',NULL,5179,55730000,'PE','2602209',1,'2006-11-12 16:55:18'),(2793,NULL,1,17,'BONITO',NULL,5182,55680000,'PE','2602308',1,'2006-11-12 16:55:18'),(2794,NULL,1,17,'BREJO',NULL,5183,55325000,'PE','2602407',1,'2006-11-12 16:55:18'),(2795,NULL,1,17,'BREJINHO',NULL,5184,56740000,'PE','2602506',1,'2006-11-12 16:55:18'),(2796,NULL,1,17,'BREJO DA MADRE DE DEUS',NULL,5185,55170000,'PE','2602605',1,'2006-11-12 16:55:18'),(2797,NULL,1,17,'BUENOS AIRES',NULL,5186,55845000,'PE','2602704',1,'2006-11-12 16:55:18'),(2798,NULL,1,17,'BUQUE',NULL,5187,56520000,'PE','2602803',1,'2006-11-12 16:55:18'),(2799,NULL,1,17,'CABO DE SANTO AGOSTINHO',NULL,5189,NULL,'PE','2602902',1,'2006-11-12 16:55:18'),(2800,NULL,1,17,'CABROB',NULL,5190,56180000,'PE','2603009',1,'2006-11-12 16:55:18'),(2801,NULL,1,17,'CACHOEIRINHA',NULL,5192,55380000,'PE','2603108',1,'2006-11-12 16:55:18'),(2802,NULL,1,17,'CAETS',NULL,5193,55360000,'PE','2603207',1,'2006-11-12 16:55:18'),(2803,NULL,1,17,'CALADO',NULL,5195,55375000,'PE','2603306',1,'2006-11-12 16:55:18'),(2804,NULL,1,17,'CALUMBI',NULL,5197,56930000,'PE','2603405',1,'2006-11-12 16:55:19'),(2805,NULL,1,17,'CAMARAGIBE',NULL,5198,NULL,'PE','2603454',1,'2006-11-12 16:55:19'),(2806,NULL,1,17,'CAMOCIM DE SO FLIX',NULL,5200,55665000,'PE','2603504',1,'2006-11-12 16:55:19'),(2807,NULL,1,17,'CAMUTANGA',NULL,5201,55930000,'PE','2603603',1,'2006-11-12 16:55:19'),(2808,NULL,1,17,'CANHOTINHO',NULL,5203,55420000,'PE','2603702',1,'2006-11-12 16:55:19'),(2809,NULL,1,17,'CAPOEIRAS',NULL,5204,55365000,'PE','2603801',1,'2006-11-12 16:55:19'),(2810,NULL,1,17,'CARNABA',NULL,5211,56820000,'PE','2603900',1,'2006-11-12 16:55:19'),(2811,NULL,1,17,'CARNAUBEIRA DA PENHA',NULL,5212,56420000,'PE','2603926',1,'2006-11-12 16:55:19'),(2812,NULL,1,17,'CARPINA',NULL,5214,NULL,'PE','2604007',1,'2006-11-12 16:55:19'),(2813,NULL,1,17,'CARUARU',NULL,5216,NULL,'PE','2604106',1,'2006-11-12 16:55:19'),(2814,NULL,1,17,'CASINHAS',NULL,5217,55755000,'PE','2604155',1,'2006-11-12 16:55:19'),(2815,NULL,1,17,'CATENDE',NULL,5218,55400000,'PE','2604205',1,'2006-11-12 16:55:19'),(2816,NULL,1,17,'CEDRO',NULL,5222,56130000,'PE','2604304',1,'2006-11-12 16:55:19'),(2817,NULL,1,17,'CH DE ALEGRIA',NULL,5223,55835000,'PE','2604403',1,'2006-11-12 16:55:19'),(2818,NULL,1,17,'CH GRANDE',NULL,5225,55636000,'PE','2604502',1,'2006-11-12 16:55:19'),(2819,NULL,1,17,'CONDADO',NULL,5231,55940000,'PE','2604601',1,'2006-11-12 16:55:19'),(2820,NULL,1,17,'CORRENTES',NULL,5232,55315000,'PE','2604700',1,'2006-11-12 16:55:19'),(2821,NULL,1,17,'CORTS',NULL,5233,55525000,'PE','2604809',1,'2006-11-12 16:55:19'),(2822,NULL,1,17,'CUMARU',NULL,5239,55655000,'PE','2604908',1,'2006-11-12 16:55:19'),(2823,NULL,1,17,'CUPIRA',NULL,5240,55460000,'PE','2605004',1,'2006-11-12 16:55:19'),(2824,NULL,1,17,'CUSTDIA',NULL,5242,56640000,'PE','2605103',1,'2006-11-12 16:55:19'),(2825,NULL,1,17,'DORMENTES',NULL,5244,56355000,'PE','2605152',1,'2006-11-12 16:55:19'),(2826,NULL,1,17,'ESCADA',NULL,5246,55500000,'PE','2605202',1,'2006-11-12 16:55:20'),(2827,NULL,1,17,'EXU',NULL,5248,56230000,'PE','2605301',1,'2006-11-12 16:55:20'),(2828,NULL,1,17,'FEIRA NOVA',NULL,5250,55715000,'PE','2605400',1,'2006-11-12 16:55:20'),(2829,NULL,1,17,'FERNANDO DE NORONHA',NULL,5252,53990000,'PE','2605459',1,'2006-11-12 16:55:20'),(2830,NULL,1,17,'FERREIROS',NULL,5253,55880000,'PE','2605509',1,'2006-11-12 16:55:20'),(2831,NULL,1,17,'FLORES',NULL,5254,56850000,'PE','2605608',1,'2006-11-12 16:55:20'),(2832,NULL,1,17,'FLORESTA',NULL,5255,56400000,'PE','2605707',1,'2006-11-12 16:55:20'),(2833,NULL,1,17,'FREI MIGUELINHO',NULL,5256,55780000,'PE','2605806',1,'2006-11-12 16:55:20'),(2834,NULL,1,17,'GAMELEIRA',NULL,5258,55530000,'PE','2605905',1,'2006-11-12 16:55:20'),(2835,NULL,1,17,'GARANHUNS',NULL,5259,NULL,'PE','2606002',1,'2006-11-12 16:55:20'),(2836,NULL,1,17,'GLRIA DO GOIT',NULL,5260,55620000,'PE','2606101',1,'2006-11-12 16:55:20'),(2837,NULL,1,17,'GOIANA',NULL,5261,55900000,'PE','2606200',1,'2006-11-12 16:55:20'),(2838,NULL,1,17,'GRANITO',NULL,5263,56160000,'PE','2606309',1,'2006-11-12 16:55:20'),(2839,NULL,1,17,'GRAVAT',NULL,5264,NULL,'PE','2606408',1,'2006-11-12 16:55:20'),(2840,NULL,1,17,'IATI',NULL,5270,55345000,'PE','2606507',1,'2006-11-12 16:55:20'),(2841,NULL,1,17,'IBIMIRIM',NULL,5271,56580000,'PE','2606606',1,'2006-11-12 16:55:20'),(2842,NULL,1,17,'IBIRAJUBA',NULL,5272,55390000,'PE','2606705',1,'2006-11-12 16:55:20'),(2843,NULL,1,17,'IGARASSU',NULL,5281,NULL,'PE','2606804',1,'2006-11-12 16:55:20'),(2844,NULL,1,17,'IGUARACI',NULL,5282,56840000,'PE','2606903',1,'2006-11-12 16:55:20'),(2845,NULL,1,17,'INAJ',NULL,5283,56560000,'PE','2607000',1,'2006-11-12 16:55:20'),(2846,NULL,1,17,'INGAZEIRA',NULL,5284,56830000,'PE','2607109',1,'2006-11-12 16:55:20'),(2847,NULL,1,17,'IPOJUCA',NULL,5285,55590000,'PE','2607208',1,'2006-11-12 16:55:20'),(2848,NULL,1,17,'IPUBI',NULL,5286,56260000,'PE','2607307',1,'2006-11-12 16:55:20'),(2849,NULL,1,17,'ITACURUBA',NULL,5291,56430000,'PE','2607406',1,'2006-11-12 16:55:21'),(2850,NULL,1,17,'ITABA',NULL,5292,56550000,'PE','2607505',1,'2006-11-12 16:55:21'),(2851,NULL,1,17,'ITAMARAC',NULL,5293,53900000,'PE',NULL,1,'2006-11-12 16:55:21'),(2852,NULL,1,17,'ITAMB',NULL,5294,55920000,'PE','2607653',1,'2006-11-12 16:55:21'),(2853,NULL,1,17,'ITAPETIM',NULL,5295,56720000,'PE','2607703',1,'2006-11-12 16:55:21'),(2854,NULL,1,17,'ITAPISSUMA',NULL,5296,53700000,'PE','2607752',1,'2006-11-12 16:55:21'),(2855,NULL,1,17,'ITAQUITINGA',NULL,5297,55950000,'PE','2607802',1,'2006-11-12 16:55:21'),(2856,NULL,1,17,'JABOATO DOS GUARARAPES',NULL,5302,NULL,'PE','2607901',1,'2006-11-12 16:55:21'),(2857,NULL,1,17,'JAQUEIRA',NULL,5304,55409000,'PE','2607950',1,'2006-11-12 16:55:21'),(2858,NULL,1,17,'JATABA',NULL,5305,55180000,'PE','2608008',1,'2006-11-12 16:55:21'),(2859,NULL,1,17,'JATOB',NULL,5307,56470000,'PE','2608057',1,'2006-11-12 16:55:21'),(2860,NULL,1,17,'JOO ALFREDO',NULL,5309,55720000,'PE','2608107',1,'2006-11-12 16:55:21'),(2861,NULL,1,17,'JOAQUIM NABUCO',NULL,5310,55535000,'PE','2608206',1,'2006-11-12 16:55:21'),(2862,NULL,1,17,'JUCATI',NULL,5314,55398000,'PE','2608255',1,'2006-11-12 16:55:21'),(2863,NULL,1,17,'JUPI',NULL,5315,55395000,'PE','2608305',1,'2006-11-12 16:55:21'),(2864,NULL,1,17,'JUREMA',NULL,5316,55480000,'PE','2608404',1,'2006-11-12 16:55:21'),(2865,NULL,1,17,'LAGOA DO CARRO',NULL,5321,55820000,'PE','2608453',1,'2006-11-12 16:55:21'),(2866,NULL,1,17,'LAGOA DO ITAENGA',NULL,5322,55840000,'PE','2608503',1,'2006-11-12 16:55:21'),(2867,NULL,1,17,'LAGOA DO OURO',NULL,5323,55320000,'PE','2608602',1,'2006-11-12 16:55:21'),(2868,NULL,1,17,'LAGOA DOS GATOS',NULL,5325,55450000,'PE','2608701',1,'2006-11-12 16:55:21'),(2869,NULL,1,17,'LAGOA GRANDE',NULL,5326,56395000,'PE','2608750',1,'2006-11-12 16:55:21'),(2870,NULL,1,17,'LAJEDO',NULL,5329,55385000,'PE','2608800',1,'2006-11-12 16:55:21'),(2871,NULL,1,17,'LIMOEIRO',NULL,5331,55700000,'PE','2608909',1,'2006-11-12 16:55:22'),(2872,NULL,1,17,'MACAPARANA',NULL,5334,55865000,'PE','2609006',1,'2006-11-12 16:55:22'),(2873,NULL,1,17,'MACHADOS',NULL,5335,55740000,'PE','2609105',1,'2006-11-12 16:55:22'),(2874,NULL,1,17,'MANARI',NULL,5337,56565000,'PE','2609154',1,'2006-11-12 16:55:22'),(2875,NULL,1,17,'MARAIAL',NULL,5341,55405000,'PE','2609204',1,'2006-11-12 16:55:22'),(2876,NULL,1,17,'MIRANDIBA',NULL,5345,56980000,'PE','2609303',1,'2006-11-12 16:55:22'),(2877,NULL,1,17,'MOREILNDIA',NULL,5347,56150000,'PE','2614303',1,'2006-11-12 16:55:22'),(2878,NULL,1,17,'MORENO',NULL,5348,54800000,'PE','2609402',1,'2006-11-12 16:55:22'),(2879,NULL,1,17,'NAZAR DA MATA',NULL,5355,55800000,'PE','2609501',1,'2006-11-12 16:55:22'),(2880,NULL,1,17,'OLINDA',NULL,5362,NULL,'PE','2609600',1,'2006-11-12 16:55:22'),(2881,NULL,1,17,'OROB',NULL,5365,55745000,'PE','2609709',1,'2006-11-12 16:55:22'),(2882,NULL,1,17,'OROC',NULL,5366,56170000,'PE','2609808',1,'2006-11-12 16:55:22'),(2883,NULL,1,17,'OURICURI',NULL,5367,56200000,'PE','2609907',1,'2006-11-12 16:55:22'),(2884,NULL,1,17,'PALMARES',NULL,5369,55540000,'PE','2610004',1,'2006-11-12 16:55:22'),(2885,NULL,1,17,'PALMEIRINA',NULL,5370,55310000,'PE','2610103',1,'2006-11-12 16:55:22'),(2886,NULL,1,17,'PANELAS',NULL,5371,55470000,'PE','2610202',1,'2006-11-12 16:55:22'),(2887,NULL,1,17,'PARANATAMA',NULL,5377,55355000,'PE','2610301',1,'2006-11-12 16:55:22'),(2888,NULL,1,17,'PARNAMIRIM',NULL,5379,56163000,'PE','2610400',1,'2006-11-12 16:55:22'),(2889,NULL,1,17,'PASSIRA',NULL,5381,55650000,'PE','2610509',1,'2006-11-12 16:55:22'),(2890,NULL,1,17,'PAUDALHO',NULL,5383,55825000,'PE','2610608',1,'2006-11-12 16:55:22'),(2891,NULL,1,17,'PAULISTA',NULL,5384,NULL,'PE','2610707',1,'2006-11-12 16:55:22'),(2892,NULL,1,17,'PEDRA',NULL,5385,55280000,'PE','2610806',1,'2006-11-12 16:55:22'),(2893,NULL,1,17,'PESQUEIRA',NULL,5387,55200000,'PE','2610905',1,'2006-11-12 16:55:22'),(2894,NULL,1,17,'PETROLNDIA',NULL,5388,56460000,'PE','2611002',1,'2006-11-12 16:55:23'),(2895,NULL,1,17,'PETROLINA',NULL,5389,NULL,'PE','2611101',1,'2006-11-12 16:55:23'),(2896,NULL,1,17,'POO',NULL,5391,55240000,'PE','2611200',1,'2006-11-12 16:55:23'),(2897,NULL,1,17,'POMBOS',NULL,5395,55630000,'PE','2611309',1,'2006-11-12 16:55:23'),(2898,NULL,1,17,'PRIMAVERA',NULL,5399,55510000,'PE','2611408',1,'2006-11-12 16:55:23'),(2899,NULL,1,17,'QUIPAP',NULL,5400,55415000,'PE','2611507',1,'2006-11-12 16:55:23'),(2900,NULL,1,17,'QUIXAB',NULL,5402,56828000,'PE','2611533',1,'2006-11-12 16:55:23'),(2901,NULL,1,17,'RECIFE',NULL,5406,NULL,'PE','2611606',1,'2006-11-12 16:55:23'),(2902,NULL,1,17,'RIACHO DAS ALMAS',NULL,5407,55120000,'PE','2611705',1,'2006-11-12 16:55:23'),(2903,NULL,1,17,'RIBEIRO',NULL,5411,55520000,'PE','2611804',1,'2006-11-12 16:55:23'),(2904,NULL,1,17,'RIO FORMOSO',NULL,5413,55570000,'PE','2611903',1,'2006-11-12 16:55:23'),(2905,NULL,1,17,'SAIR',NULL,5414,55695000,'PE','2612000',1,'2006-11-12 16:55:23'),(2906,NULL,1,17,'SALGADINHO',NULL,5415,55675000,'PE','2612109',1,'2006-11-12 16:55:23'),(2907,NULL,1,17,'SALGUEIRO',NULL,5416,56000000,'PE','2612208',1,'2006-11-12 16:55:23'),(2908,NULL,1,17,'SALO',NULL,5417,55350000,'PE','2612307',1,'2006-11-12 16:55:23'),(2909,NULL,1,17,'SANHAR',NULL,5419,55250000,'PE','2612406',1,'2006-11-12 16:55:23'),(2910,NULL,1,17,'SANTA CRUZ',NULL,5420,56215000,'PE','2612455',1,'2006-11-12 16:55:23'),(2911,NULL,1,17,'SANTA CRUZ DA BAIXA VERDE',NULL,5421,56895000,'PE','2612471',1,'2006-11-12 16:55:23'),(2912,NULL,1,17,'SANTA CRUZ DO CAPIBARIBE',NULL,5422,55190000,'PE','2612505',1,'2006-11-12 16:55:23'),(2913,NULL,1,17,'SANTA FILOMENA',NULL,5423,56210000,'PE','2612554',1,'2006-11-12 16:55:23'),(2914,NULL,1,17,'SANTA MARIA DA BOA VISTA',NULL,5424,56380000,'PE','2612604',1,'2006-11-12 16:55:23'),(2915,NULL,1,17,'SANTA MARIA DO CAMBUC',NULL,5425,55765000,'PE','2612703',1,'2006-11-12 16:55:23'),(2916,NULL,1,17,'SANTA TEREZINHA',NULL,5427,56750000,'PE','2612802',1,'2006-11-12 16:55:23'),(2917,NULL,1,17,'SO BENEDITO DO SUL',NULL,5433,55410000,'PE','2612901',1,'2006-11-12 16:55:24'),(2918,NULL,1,17,'SO BENTO DO UNA',NULL,5434,55370000,'PE','2613008',1,'2006-11-12 16:55:24'),(2919,NULL,1,17,'SO CAITANO',NULL,5436,55130000,'PE','2613107',1,'2006-11-12 16:55:24'),(2920,NULL,1,17,'SO JOO',NULL,5438,55435000,'PE','2613206',1,'2006-11-12 16:55:24'),(2921,NULL,1,17,'SO JOAQUIM DO MONTE',NULL,5439,55670000,'PE','2613305',1,'2006-11-12 16:55:24'),(2922,NULL,1,17,'SO JOS DA COROA GRANDE',NULL,5441,55565000,'PE','2613404',1,'2006-11-12 16:55:24'),(2923,NULL,1,17,'SO JOS DO BELMONTE',NULL,5442,56950000,'PE','2613503',1,'2006-11-12 16:55:24'),(2924,NULL,1,17,'SO JOS DO EGITO',NULL,5443,56700000,'PE','2613602',1,'2006-11-12 16:55:24'),(2925,NULL,1,17,'SO LOURENO DA MATA',NULL,5445,NULL,'PE','2613701',1,'2006-11-12 16:55:24'),(2926,NULL,1,17,'SO VICENTE FERRER',NULL,5448,55860000,'PE','2613800',1,'2006-11-12 16:55:24'),(2927,NULL,1,17,'SERRA TALHADA',NULL,5453,NULL,'PE','2613909',1,'2006-11-12 16:55:24'),(2928,NULL,1,17,'SERRITA',NULL,5454,56140000,'PE','2614006',1,'2006-11-12 16:55:24'),(2929,NULL,1,17,'SERTNIA',NULL,5456,56600000,'PE','2614105',1,'2006-11-12 16:55:24'),(2930,NULL,1,17,'SIRINHAM',NULL,5459,55580000,'PE','2614204',1,'2006-11-12 16:55:24'),(2931,NULL,1,17,'SOLIDO',NULL,5461,56795000,'PE','2614402',1,'2006-11-12 16:55:24'),(2932,NULL,1,17,'SURUBIM',NULL,5462,55750000,'PE','2614501',1,'2006-11-12 16:55:24'),(2933,NULL,1,17,'TABIRA',NULL,5463,56780000,'PE','2614600',1,'2006-11-12 16:55:24'),(2934,NULL,1,17,'TACAIMB',NULL,5465,55140000,'PE','2614709',1,'2006-11-12 16:55:24'),(2935,NULL,1,17,'TACARATU',NULL,5466,56480000,'PE','2614808',1,'2006-11-12 16:55:24'),(2936,NULL,1,17,'TAMANDAR',NULL,5467,55578000,'PE','2614857',1,'2006-11-12 16:55:25'),(2937,NULL,1,17,'TAQUARITINGA DO NORTE',NULL,5470,55790000,'PE','2615003',1,'2006-11-12 16:55:25'),(2938,NULL,1,17,'TEREZINHA',NULL,5474,55305000,'PE','2615102',1,'2006-11-12 16:55:25'),(2939,NULL,1,17,'TERRA NOVA',NULL,5475,56190000,'PE','2615201',1,'2006-11-12 16:55:25'),(2940,NULL,1,17,'TIMBABA',NULL,5476,55870000,'PE','2615300',1,'2006-11-12 16:55:25'),(2941,NULL,1,17,'TORITAMA',NULL,5478,55125000,'PE','2615409',1,'2006-11-12 16:55:25'),(2942,NULL,1,17,'TRACUNHAM',NULL,5479,55805000,'PE','2615508',1,'2006-11-12 16:55:25'),(2943,NULL,1,17,'TRINDADE',NULL,5482,56250000,'PE','2615607',1,'2006-11-12 16:55:25'),(2944,NULL,1,17,'TRIUNFO',NULL,5483,56870000,'PE','2615706',1,'2006-11-12 16:55:25'),(2945,NULL,1,17,'TUPANATINGA',NULL,5485,56540000,'PE','2615805',1,'2006-11-12 16:55:25'),(2946,NULL,1,17,'TUPARETAMA',NULL,5487,56760000,'PE','2615904',1,'2006-11-12 16:55:25'),(2947,NULL,1,17,'VENTUROSA',NULL,5496,55270000,'PE','2616001',1,'2006-11-12 16:55:25'),(2948,NULL,1,17,'VERDEJANTE',NULL,5497,56120000,'PE','2616100',1,'2006-11-12 16:55:25'),(2949,NULL,1,17,'VERTENTE DO LRIO',NULL,5498,55760000,'PE','2616183',1,'2006-11-12 16:55:25'),(2950,NULL,1,17,'VERTENTES',NULL,5499,55770000,'PE','2616209',1,'2006-11-12 16:55:25'),(2951,NULL,1,17,'VICNCIA',NULL,5500,55850000,'PE','2616308',1,'2006-11-12 16:55:25'),(2952,NULL,1,17,'VITRIA DE SANTO ANTO',NULL,5503,NULL,'PE','2616407',1,'2006-11-12 16:55:25'),(2953,NULL,1,17,'XEXU',NULL,5505,55555000,'PE','2616506',1,'2006-11-12 16:55:25'),(2954,NULL,1,12,'ACAU',NULL,5508,64748000,'PI','2200053',1,'2006-11-12 16:55:25'),(2955,NULL,1,12,'AGRICOLNDIA',NULL,5509,64440000,'PI','2200103',1,'2006-11-12 16:55:25'),(2956,NULL,1,12,'GUA BRANCA',NULL,5510,64460000,'PI','2200202',1,'2006-11-12 16:55:25'),(2957,NULL,1,12,'ALAGOINHA DO PIAU',NULL,5511,64655000,'PI','2200251',1,'2006-11-12 16:55:25'),(2958,NULL,1,12,'ALEGRETE DO PIAU',NULL,5512,64675000,'PI','2200277',1,'2006-11-12 16:55:26'),(2959,NULL,1,12,'ALTO LONG',NULL,5513,64360000,'PI','2200301',1,'2006-11-12 16:55:26'),(2960,NULL,1,12,'ALTOS',NULL,5514,64290000,'PI','2200400',1,'2006-11-12 16:55:26'),(2961,NULL,1,12,'ALVORADA DO GURGUIA',NULL,5515,64923000,'PI','2200459',1,'2006-11-12 16:55:26'),(2962,NULL,1,12,'AMARANTE',NULL,5516,64400000,'PI','2200509',1,'2006-11-12 16:55:26'),(2963,NULL,1,12,'ANGICAL DO PIAU',NULL,5517,64410000,'PI','2200608',1,'2006-11-12 16:55:26'),(2964,NULL,1,12,'ANSIO DE ABREU',NULL,5518,64780000,'PI','2200707',1,'2006-11-12 16:55:26'),(2965,NULL,1,12,'ANTNIO ALMEIDA',NULL,5519,64855000,'PI','2200806',1,'2006-11-12 16:55:26'),(2966,NULL,1,12,'AROAZES',NULL,5520,64310000,'PI','2200905',1,'2006-11-12 16:55:26'),(2967,NULL,1,12,'ARRAIAL',NULL,5521,64480000,'PI','2201002',1,'2006-11-12 16:55:26'),(2968,NULL,1,12,'ASSUNO DO PIAU',NULL,5522,64333000,'PI','2201051',1,'2006-11-12 16:55:26'),(2969,NULL,1,12,'AVELINO LOPES',NULL,5523,64965000,'PI','2201101',1,'2006-11-12 16:55:26'),(2970,NULL,1,12,'BAIXA GRANDE DO RIBEIRO',NULL,5524,64868000,'PI','2201150',1,'2006-11-12 16:55:26'),(2971,NULL,1,12,'BARRA D\'ALCNTARA',NULL,5525,64528000,'PI',NULL,1,'2006-11-12 16:55:26'),(2972,NULL,1,12,'BARRAS',NULL,5526,64100000,'PI','2201200',1,'2006-11-12 16:55:26'),(2973,NULL,1,12,'BARREIRAS DO PIAU',NULL,5527,64990000,'PI','2201309',1,'2006-11-12 16:55:26'),(2974,NULL,1,12,'BARRO DURO',NULL,5528,64455000,'PI','2201408',1,'2006-11-12 16:55:26'),(2975,NULL,1,12,'BATALHA',NULL,5529,64190000,'PI','2201507',1,'2006-11-12 16:55:26'),(2976,NULL,1,12,'BELA VISTA DO PIAU',NULL,5530,64705000,'PI','2201556',1,'2006-11-12 16:55:26'),(2977,NULL,1,12,'BELM DO PIAU',NULL,5531,64678000,'PI','2201572',1,'2006-11-12 16:55:26'),(2978,NULL,1,12,'BENEDITINOS',NULL,5532,64380000,'PI','2201606',1,'2006-11-12 16:55:26'),(2979,NULL,1,12,'BERTOLNIA',NULL,5533,64870000,'PI','2201705',1,'2006-11-12 16:55:26'),(2980,NULL,1,12,'BETNIA DO PIAU',NULL,5534,64753000,'PI','2201739',1,'2006-11-12 16:55:26'),(2981,NULL,1,12,'BOA HORA',NULL,5535,64108000,'PI','2201770',1,'2006-11-12 16:55:27'),(2982,NULL,1,12,'BOCAINA',NULL,5536,64630000,'PI','2201804',1,'2006-11-12 16:55:27'),(2983,NULL,1,12,'BOM JESUS',NULL,5537,64900000,'PI','2201903',1,'2006-11-12 16:55:27'),(2984,NULL,1,12,'BOM PRINCPIO DO PIAU',NULL,5538,64225000,'PI','2201919',1,'2006-11-12 16:55:27'),(2985,NULL,1,12,'BONFIM DO PIAU',NULL,5539,64775000,'PI','2201929',1,'2006-11-12 16:55:27'),(2986,NULL,1,12,'BOQUEIRO DO PIAU',NULL,5540,64283000,'PI','2201945',1,'2006-11-12 16:55:27'),(2987,NULL,1,12,'BRASILEIRA',NULL,5541,64265000,'PI','2201960',1,'2006-11-12 16:55:27'),(2988,NULL,1,12,'BREJO DO PIAU',NULL,5542,64895000,'PI','2201988',1,'2006-11-12 16:55:27'),(2989,NULL,1,12,'BURITI DOS LOPES',NULL,5543,64230000,'PI','2202000',1,'2006-11-12 16:55:27'),(2990,NULL,1,12,'BURITI DOS MONTES',NULL,5544,64345000,'PI','2202026',1,'2006-11-12 16:55:27'),(2991,NULL,1,12,'CABECEIRAS DO PIAU',NULL,5545,64105000,'PI','2202059',1,'2006-11-12 16:55:27'),(2992,NULL,1,12,'CAJAZEIRAS DO PIAU',NULL,5546,64514000,'PI','2202075',1,'2006-11-12 16:55:27'),(2993,NULL,1,12,'CAJUEIRO DA PRAIA',NULL,5547,64222000,'PI','2202083',1,'2006-11-12 16:55:27'),(2994,NULL,1,12,'CALDEIRO GRANDE DO PIAU',NULL,5548,64695000,'PI','2202091',1,'2006-11-12 16:55:27'),(2995,NULL,1,12,'CAMPINAS DO PIAU',NULL,5549,64730000,'PI','2202109',1,'2006-11-12 16:55:27'),(2996,NULL,1,12,'CAMPO ALEGRE DO FIDALGO',NULL,5550,64767000,'PI','2202117',1,'2006-11-12 16:55:27'),(2997,NULL,1,12,'CAMPO GRANDE DO PIAU',NULL,5551,64578000,'PI','2202133',1,'2006-11-12 16:55:27'),(2998,NULL,1,12,'CAMPO LARGO DO PIAU',NULL,5552,64148000,'PI','2202174',1,'2006-11-12 16:55:27'),(2999,NULL,1,12,'CAMPO MAIOR',NULL,5553,64280000,'PI','2202208',1,'2006-11-12 16:55:27'),(3000,NULL,1,12,'CANAVIEIRA',NULL,5554,64833000,'PI','2202251',1,'2006-11-12 16:55:27'),(3001,NULL,1,12,'CANTO DO BURITI',NULL,5555,64890000,'PI','2202307',1,'2006-11-12 16:55:27'),(3002,NULL,1,12,'CAPITO DE CAMPOS',NULL,5556,64270000,'PI','2202406',1,'2006-11-12 16:55:28'),(3003,NULL,1,12,'CAPITO GERVSIO OLIVEIRA',NULL,5557,64763000,'PI','2202455',1,'2006-11-12 16:55:28'),(3004,NULL,1,12,'CARACOL',NULL,5558,64795000,'PI','2202505',1,'2006-11-12 16:55:28'),(3005,NULL,1,12,'CARABAS DO PIAU',NULL,5559,64233000,'PI','2202539',1,'2006-11-12 16:55:28'),(3006,NULL,1,12,'CARIDADE DO PIAU',NULL,5560,64590000,'PI','2202554',1,'2006-11-12 16:55:28'),(3007,NULL,1,12,'CASTELO DO PIAU',NULL,5561,64340000,'PI','2202604',1,'2006-11-12 16:55:28'),(3008,NULL,1,12,'CAXING',NULL,5562,64228000,'PI','2202653',1,'2006-11-12 16:55:28'),(3009,NULL,1,12,'COCAL',NULL,5563,64235000,'PI','2202703',1,'2006-11-12 16:55:28'),(3010,NULL,1,12,'COCAL DE TELHA',NULL,5564,64278000,'PI','2202711',1,'2006-11-12 16:55:28'),(3011,NULL,1,12,'COCAL DOS ALVES',NULL,5565,64238000,'PI','2202729',1,'2006-11-12 16:55:28'),(3012,NULL,1,12,'COIVARAS',NULL,5566,64335000,'PI','2202737',1,'2006-11-12 16:55:28'),(3013,NULL,1,12,'COLNIA DO GURGUIA',NULL,5567,64885000,'PI','2202752',1,'2006-11-12 16:55:28'),(3014,NULL,1,12,'COLNIA DO PIAU',NULL,5568,64516000,'PI','2202778',1,'2006-11-12 16:55:28'),(3015,NULL,1,12,'CONCEIO DO CANIND',NULL,5569,64740000,'PI','2202802',1,'2006-11-12 16:55:28'),(3016,NULL,1,12,'CORONEL JOS DIAS',NULL,5570,64793000,'PI','2202851',1,'2006-11-12 16:55:28'),(3017,NULL,1,12,'CORRENTE',NULL,5571,64980000,'PI','2202901',1,'2006-11-12 16:55:28'),(3018,NULL,1,12,'CRISTALNDIA DO PIAU',NULL,5572,64995000,'PI','2203008',1,'2006-11-12 16:55:28'),(3019,NULL,1,12,'CRISTINO CASTRO',NULL,5573,64920000,'PI','2203107',1,'2006-11-12 16:55:28'),(3020,NULL,1,12,'CURIMAT',NULL,5574,64960000,'PI','2203206',1,'2006-11-12 16:55:28'),(3021,NULL,1,12,'CURRAIS',NULL,5575,64905000,'PI','2203230',1,'2006-11-12 16:55:28'),(3022,NULL,1,12,'CURRAL NOVO DO PIAU',NULL,5576,64595000,'PI','2203271',1,'2006-11-12 16:55:28'),(3023,NULL,1,12,'CURRALINHOS',NULL,5577,64453000,'PI','2203255',1,'2006-11-12 16:55:28'),(3024,NULL,1,12,'DEMERVAL LOBO',NULL,5578,64390000,'PI','2203305',1,'2006-11-12 16:55:28'),(3025,NULL,1,12,'DIRCEU ARCOVERDE',NULL,5579,64785000,'PI','2203354',1,'2006-11-12 16:55:29'),(3026,NULL,1,12,'DOM EXPEDITO LOPES',NULL,5580,64620000,'PI','2203404',1,'2006-11-12 16:55:29'),(3027,NULL,1,12,'DOM INOCNCIO',NULL,5581,64790000,'PI','2203453',1,'2006-11-12 16:55:29'),(3028,NULL,1,12,'DOMINGOS MOURO',NULL,5582,64250000,'PI','2203420',1,'2006-11-12 16:55:29'),(3029,NULL,1,12,'ELESBO VELOSO',NULL,5583,64325000,'PI','2203503',1,'2006-11-12 16:55:29'),(3030,NULL,1,12,'ELISEU MARTINS',NULL,5584,64880000,'PI','2203602',1,'2006-11-12 16:55:29'),(3031,NULL,1,12,'ESPERANTINA',NULL,5585,64180000,'PI','2203701',1,'2006-11-12 16:55:29'),(3032,NULL,1,12,'FARTURA DO PIAU',NULL,5586,64788000,'PI','2203750',1,'2006-11-12 16:55:29'),(3033,NULL,1,12,'FLORES DO PIAU',NULL,5587,64815000,'PI','2203800',1,'2006-11-12 16:55:29'),(3034,NULL,1,12,'FLORESTA DO PIAU',NULL,5588,64563000,'PI','2203859',1,'2006-11-12 16:55:29'),(3035,NULL,1,12,'FLORIANO',NULL,5589,64800000,'PI','2203909',1,'2006-11-12 16:55:29'),(3036,NULL,1,12,'FRANCINPOLIS',NULL,5590,64520000,'PI','2204006',1,'2006-11-12 16:55:29'),(3037,NULL,1,12,'FRANCISCO AYRES',NULL,5591,64475000,'PI','2204105',1,'2006-11-12 16:55:29'),(3038,NULL,1,12,'FRANCISCO MACEDO',NULL,5592,64683000,'PI','2204154',1,'2006-11-12 16:55:29'),(3039,NULL,1,12,'FRANCISCO SANTOS',NULL,5593,64645000,'PI','2204204',1,'2006-11-12 16:55:29'),(3040,NULL,1,12,'FRONTEIRAS',NULL,5594,64690000,'PI','2204303',1,'2006-11-12 16:55:29'),(3041,NULL,1,12,'GEMINIANO',NULL,5595,64613000,'PI','2204352',1,'2006-11-12 16:55:29'),(3042,NULL,1,12,'GILBUS',NULL,5596,64930000,'PI','2204402',1,'2006-11-12 16:55:29'),(3043,NULL,1,12,'GUADALUPE',NULL,5597,64840000,'PI','2204501',1,'2006-11-12 16:55:29'),(3044,NULL,1,12,'GUARIBAS',NULL,5598,64798000,'PI','2204550',1,'2006-11-12 16:55:29'),(3045,NULL,1,12,'HUGO NAPOLEO',NULL,5599,64470000,'PI','2204600',1,'2006-11-12 16:55:29'),(3046,NULL,1,12,'ILHA GRANDE',NULL,5600,64224000,'PI','2204659',1,'2006-11-12 16:55:29'),(3047,NULL,1,12,'INHUMA',NULL,5601,64535000,'PI','2204709',1,'2006-11-12 16:55:29'),(3048,NULL,1,12,'IPIRANGA DO PIAU',NULL,5602,64540000,'PI','2204808',1,'2006-11-12 16:55:30'),(3049,NULL,1,12,'ISAAS COELHO',NULL,5603,64570000,'PI','2204907',1,'2006-11-12 16:55:30'),(3050,NULL,1,12,'ITAINPOLIS',NULL,5604,64565000,'PI','2205003',1,'2006-11-12 16:55:30'),(3051,NULL,1,12,'ITAUEIRA',NULL,5605,64820000,'PI','2205102',1,'2006-11-12 16:55:30'),(3052,NULL,1,12,'JACOBINA DO PIAU',NULL,5606,64755000,'PI','2205151',1,'2006-11-12 16:55:30'),(3053,NULL,1,12,'JAICS',NULL,5607,64575000,'PI','2205201',1,'2006-11-12 16:55:30'),(3054,NULL,1,12,'JARDIM DO MULATO',NULL,5608,64495000,'PI','2205250',1,'2006-11-12 16:55:30'),(3055,NULL,1,12,'JATOB DO PIAU',NULL,5609,64275000,'PI','2205276',1,'2006-11-12 16:55:30'),(3056,NULL,1,12,'JERUMENHA',NULL,5610,64830000,'PI','2205300',1,'2006-11-12 16:55:30'),(3057,NULL,1,12,'JOO COSTA',NULL,5611,64765000,'PI','2205359',1,'2006-11-12 16:55:30'),(3058,NULL,1,12,'JOAQUIM PIRES',NULL,5612,64170000,'PI','2205409',1,'2006-11-12 16:55:30'),(3059,NULL,1,12,'JOCA MARQUES',NULL,5613,64165000,'PI','2205458',1,'2006-11-12 16:55:30'),(3060,NULL,1,12,'JOS DE FREITAS',NULL,5614,64110000,'PI','2205508',1,'2006-11-12 16:55:30'),(3061,NULL,1,12,'JUAZEIRO DO PIAU',NULL,5615,64343000,'PI','2205516',1,'2006-11-12 16:55:30'),(3062,NULL,1,12,'JLIO BORGES',NULL,5616,64963000,'PI','2205524',1,'2006-11-12 16:55:30'),(3063,NULL,1,12,'JUREMA',NULL,5617,64782000,'PI','2205532',1,'2006-11-12 16:55:30'),(3064,NULL,1,12,'LAGOA ALEGRE',NULL,5618,64138000,'PI','2205557',1,'2006-11-12 16:55:30'),(3065,NULL,1,12,'LAGOA DE SO FRANCISCO',NULL,5619,64258000,'PI','2205573',1,'2006-11-12 16:55:30'),(3066,NULL,1,12,'LAGOA DO BARRO DO PIAU',NULL,5620,64768000,'PI','2205565',1,'2006-11-12 16:55:30'),(3067,NULL,1,12,'LAGOA DO PIAU',NULL,5621,64388000,'PI','2205581',1,'2006-11-12 16:55:30'),(3068,NULL,1,12,'LAGOA DO STIO',NULL,5622,64308000,'PI','2205599',1,'2006-11-12 16:55:30'),(3069,NULL,1,12,'LAGOINHA DO PIAU',NULL,5623,64465000,'PI','2205540',1,'2006-11-12 16:55:30'),(3070,NULL,1,12,'LANDRI SALES',NULL,5624,64850000,'PI','2205607',1,'2006-11-12 16:55:31'),(3071,NULL,1,12,'LUS CORREIA',NULL,5625,64220000,'PI','2205706',1,'2006-11-12 16:55:31'),(3072,NULL,1,12,'LUZILNDIA',NULL,5626,64160000,'PI','2205805',1,'2006-11-12 16:55:31'),(3073,NULL,1,12,'MADEIRO',NULL,5627,64168000,'PI','2205854',1,'2006-11-12 16:55:31'),(3074,NULL,1,12,'MANOEL EMDIO',NULL,5628,64875000,'PI','2205904',1,'2006-11-12 16:55:31'),(3075,NULL,1,12,'MARCOLNDIA',NULL,5629,64685000,'PI','2205953',1,'2006-11-12 16:55:31'),(3076,NULL,1,12,'MARCOS PARENTE',NULL,5630,64845000,'PI','2206001',1,'2006-11-12 16:55:31'),(3077,NULL,1,12,'MASSAP DO PIAU',NULL,5631,64573000,'PI','2206050',1,'2006-11-12 16:55:31'),(3078,NULL,1,12,'MATIAS OLMPIO',NULL,5632,64150000,'PI','2206100',1,'2006-11-12 16:55:31'),(3079,NULL,1,12,'MIGUEL ALVES',NULL,5633,64130000,'PI','2206209',1,'2006-11-12 16:55:31'),(3080,NULL,1,12,'MIGUEL LEO',NULL,5634,64445000,'PI','2206308',1,'2006-11-12 16:55:31'),(3081,NULL,1,12,'MILTON BRANDO',NULL,5635,64253000,'PI','2206357',1,'2006-11-12 16:55:31'),(3082,NULL,1,12,'MONSENHOR GIL',NULL,5636,64450000,'PI','2206407',1,'2006-11-12 16:55:31'),(3083,NULL,1,12,'MONSENHOR HIPLITO',NULL,5637,64650000,'PI','2206506',1,'2006-11-12 16:55:31'),(3084,NULL,1,12,'MONTE ALEGRE DO PIAU',NULL,5638,64940000,'PI','2206605',1,'2006-11-12 16:55:31'),(3085,NULL,1,12,'MORRO CABEA NO TEMPO',NULL,5639,64968000,'PI','2206654',1,'2006-11-12 16:55:31'),(3086,NULL,1,12,'MORRO DO CHAPU DO PIAU',NULL,5640,64178000,'PI','2206670',1,'2006-11-12 16:55:31'),(3087,NULL,1,12,'MURICI DOS PORTELAS',NULL,5641,64175000,'PI','2206696',1,'2006-11-12 16:55:31'),(3088,NULL,1,12,'NAZAR DO PIAU',NULL,5642,64825000,'PI','2206704',1,'2006-11-12 16:55:31'),(3089,NULL,1,12,'NOSSA SENHORA DE NAZAR',NULL,5643,64288000,'PI','2206753',1,'2006-11-12 16:55:31'),(3090,NULL,1,12,'NOSSA SENHORA DOS REMDIOS',NULL,5644,64140000,'PI','2206803',1,'2006-11-12 16:55:31'),(3091,NULL,1,12,'NOVA SANTA RITA',NULL,5645,64764000,'PI','2207959',1,'2006-11-12 16:55:31'),(3092,NULL,1,12,'NOVO ORIENTE DO PIAU',NULL,5647,64530000,'PI','2206902',1,'2006-11-12 16:55:31'),(3093,NULL,1,12,'NOVO SANTO ANTNIO',NULL,5648,64365000,'PI','2206951',1,'2006-11-12 16:55:32'),(3094,NULL,1,12,'OEIRAS',NULL,5649,64500000,'PI','2207009',1,'2006-11-12 16:55:32'),(3095,NULL,1,12,'OLHO D\'GUA DO PIAU',NULL,5650,64468000,'PI',NULL,1,'2006-11-12 16:55:32'),(3096,NULL,1,12,'PADRE MARCOS',NULL,5651,64680000,'PI','2207207',1,'2006-11-12 16:55:32'),(3097,NULL,1,12,'PAES LANDIM',NULL,5652,64710000,'PI','2207306',1,'2006-11-12 16:55:32'),(3098,NULL,1,12,'PAJE DO PIAU',NULL,5653,64898000,'PI','2207355',1,'2006-11-12 16:55:32'),(3099,NULL,1,12,'PALMEIRA DO PIAU',NULL,5654,64925000,'PI','2207405',1,'2006-11-12 16:55:32'),(3100,NULL,1,12,'PALMEIRAIS',NULL,5655,64420000,'PI','2207504',1,'2006-11-12 16:55:32'),(3101,NULL,1,12,'PAQUET',NULL,5656,64618000,'PI','2207553',1,'2006-11-12 16:55:32'),(3102,NULL,1,12,'PARNAGU',NULL,5657,64970000,'PI','2207603',1,'2006-11-12 16:55:32'),(3103,NULL,1,12,'PARNABA',NULL,5658,NULL,'PI','2207702',1,'2006-11-12 16:55:32'),(3104,NULL,1,12,'PASSAGEM FRANCA DO PIAU',NULL,5659,64395000,'PI','2207751',1,'2006-11-12 16:55:32'),(3105,NULL,1,12,'PATOS DO PIAU',NULL,5660,64580000,'PI','2207777',1,'2006-11-12 16:55:32'),(3106,NULL,1,12,'PAULISTANA',NULL,5661,64750000,'PI','2207801',1,'2006-11-12 16:55:32'),(3107,NULL,1,12,'PAVUSSU',NULL,5662,64838000,'PI','2207850',1,'2006-11-12 16:55:32'),(3108,NULL,1,12,'PEDRO II',NULL,5663,64255000,'PI','2207900',1,'2006-11-12 16:55:32'),(3109,NULL,1,12,'PEDRO LAURENTINO',NULL,5664,64728000,'PI','2207934',1,'2006-11-12 16:55:32'),(3110,NULL,1,12,'PICOS',NULL,5665,64600000,'PI','2208007',1,'2006-11-12 16:55:32'),(3111,NULL,1,12,'PIMENTEIRAS',NULL,5666,64320000,'PI','2208106',1,'2006-11-12 16:55:32'),(3112,NULL,1,12,'PIO IX',NULL,5667,64660000,'PI','2208205',1,'2006-11-12 16:55:32'),(3113,NULL,1,12,'PIRACURUCA',NULL,5668,64240000,'PI','2208304',1,'2006-11-12 16:55:33'),(3114,NULL,1,12,'PIRIPIRI',NULL,5669,64260000,'PI','2208403',1,'2006-11-12 16:55:33'),(3115,NULL,1,12,'PORTO',NULL,5670,64145000,'PI','2208502',1,'2006-11-12 16:55:33'),(3116,NULL,1,12,'PORTO ALEGRE DO PIAU',NULL,5671,64858000,'PI','2208551',1,'2006-11-12 16:55:33'),(3117,NULL,1,12,'PRATA DO PIAU',NULL,5672,64370000,'PI','2208601',1,'2006-11-12 16:55:33'),(3118,NULL,1,12,'QUEIMADA NOVA',NULL,5673,64758000,'PI','2208650',1,'2006-11-12 16:55:33'),(3119,NULL,1,12,'REDENO DO GURGUIA',NULL,5674,64915000,'PI','2208700',1,'2006-11-12 16:55:33'),(3120,NULL,1,12,'REGENERAO',NULL,5675,64490000,'PI','2208809',1,'2006-11-12 16:55:33'),(3121,NULL,1,12,'RIACHO FRIO',NULL,5676,64975000,'PI','2208858',1,'2006-11-12 16:55:33'),(3122,NULL,1,12,'RIBEIRA DO PIAU',NULL,5677,64725000,'PI','2208874',1,'2006-11-12 16:55:33'),(3123,NULL,1,12,'RIBEIRO GONALVES',NULL,5678,64865000,'PI','2208908',1,'2006-11-12 16:55:33'),(3124,NULL,1,12,'RIO GRANDE DO PIAU',NULL,5679,64835000,'PI','2209005',1,'2006-11-12 16:55:33'),(3125,NULL,1,12,'SANTA CRUZ DO PIAU',NULL,5680,64545000,'PI','2209104',1,'2006-11-12 16:55:33'),(3126,NULL,1,12,'SANTA CRUZ DOS MILAGRES',NULL,5681,64315000,'PI','2209153',1,'2006-11-12 16:55:33'),(3127,NULL,1,12,'SANTA FILOMENA',NULL,5682,64945000,'PI','2209203',1,'2006-11-12 16:55:33'),(3128,NULL,1,12,'SANTA LUZ',NULL,5683,64910000,'PI','2209302',1,'2006-11-12 16:55:33'),(3129,NULL,1,12,'SANTA ROSA DO PIAU',NULL,5684,64518000,'PI','2209377',1,'2006-11-12 16:55:33'),(3130,NULL,1,12,'SANTANA DO PIAU',NULL,5685,64615000,'PI','2209351',1,'2006-11-12 16:55:33'),(3131,NULL,1,12,'SANTO ANTNIO DE LISBOA',NULL,5686,64640000,'PI','2209401',1,'2006-11-12 16:55:33'),(3132,NULL,1,12,'SANTO ANTNIO DOS MILAGRES',NULL,5687,64438000,'PI','2209450',1,'2006-11-12 16:55:33'),(3133,NULL,1,12,'SANTO INCIO DO PIAU',NULL,5688,64560000,'PI','2209500',1,'2006-11-12 16:55:33'),(3134,NULL,1,12,'SO BRAZ DO PIAU',NULL,5689,64783000,'PI','2209559',1,'2006-11-12 16:55:33'),(3135,NULL,1,12,'SO FLIX DO PIAU',NULL,5690,64375000,'PI','2209609',1,'2006-11-12 16:55:33'),(3136,NULL,1,12,'SO FRANCISCO DE ASSIS DO PIAU',NULL,5691,64745000,'PI','2209658',1,'2006-11-12 16:55:34'),(3137,NULL,1,12,'SO FRANCISCO DO PIAU',NULL,5692,64550000,'PI','2209708',1,'2006-11-12 16:55:34'),(3138,NULL,1,12,'SO GONALO DO GURGUIA',NULL,5693,64993000,'PI','2209757',1,'2006-11-12 16:55:34'),(3139,NULL,1,12,'SO GONALO DO PIAU',NULL,5694,64435000,'PI','2209807',1,'2006-11-12 16:55:34'),(3140,NULL,1,12,'SO JOO DA CANABRAVA',NULL,5695,64635000,'PI','2209856',1,'2006-11-12 16:55:34'),(3141,NULL,1,12,'SO JOO DA FRONTEIRA',NULL,5696,64243000,'PI','2209872',1,'2006-11-12 16:55:34'),(3142,NULL,1,12,'SO JOO DA SERRA',NULL,5697,64350000,'PI','2209906',1,'2006-11-12 16:55:34'),(3143,NULL,1,12,'SO JOO DA VARJOTA',NULL,5698,64510000,'PI','2209955',1,'2006-11-12 16:55:34'),(3144,NULL,1,12,'SO JOO DO ARRAIAL',NULL,5699,64155000,'PI','2209971',1,'2006-11-12 16:55:34'),(3145,NULL,1,12,'SO JOO DO PIAU',NULL,5700,64760000,'PI','2210003',1,'2006-11-12 16:55:34'),(3146,NULL,1,12,'SO JOS DO DIVINO',NULL,5701,64245000,'PI','2210052',1,'2006-11-12 16:55:34'),(3147,NULL,1,12,'SO JOS DO PEIXE',NULL,5702,64555000,'PI','2210102',1,'2006-11-12 16:55:34'),(3148,NULL,1,12,'SO JOS DO PIAU',NULL,5703,64625000,'PI','2210201',1,'2006-11-12 16:55:34'),(3149,NULL,1,12,'SO JULIO',NULL,5704,64670000,'PI','2210300',1,'2006-11-12 16:55:34'),(3150,NULL,1,12,'SO LOURENO DO PIAU',NULL,5705,64778000,'PI','2210359',1,'2006-11-12 16:55:34'),(3151,NULL,1,12,'SO LUS DO PIAU',NULL,5706,64638000,'PI','2210375',1,'2006-11-12 16:55:34'),(3152,NULL,1,12,'SO MIGUEL DA BAIXA GRANDE',NULL,5707,64378000,'PI','2210383',1,'2006-11-12 16:55:34'),(3153,NULL,1,12,'SO MIGUEL DO FIDALGO',NULL,5708,64558000,'PI','2210391',1,'2006-11-12 16:55:34'),(3154,NULL,1,12,'SO MIGUEL DO TAPUIO',NULL,5709,64330000,'PI','2210409',1,'2006-11-12 16:55:35'),(3155,NULL,1,12,'SO PEDRO DO PIAU',NULL,5710,64430000,'PI','2210508',1,'2006-11-12 16:55:35'),(3156,NULL,1,12,'SO RAIMUNDO NONATO',NULL,5711,64770000,'PI','2210607',1,'2006-11-12 16:55:35'),(3157,NULL,1,12,'SEBASTIO BARROS',NULL,5712,64985000,'PI','2210623',1,'2006-11-12 16:55:35'),(3158,NULL,1,12,'SEBASTIO LEAL',NULL,5713,64873000,'PI','2210631',1,'2006-11-12 16:55:35'),(3159,NULL,1,12,'SIGEFREDO PACHECO',NULL,5714,64285000,'PI','2210656',1,'2006-11-12 16:55:35'),(3160,NULL,1,12,'SIMES',NULL,5715,64585000,'PI','2210706',1,'2006-11-12 16:55:35'),(3161,NULL,1,12,'SIMPLCIO MENDES',NULL,5716,64700000,'PI','2210805',1,'2006-11-12 16:55:35'),(3162,NULL,1,12,'SOCORRO DO PIAU',NULL,5717,64720000,'PI','2210904',1,'2006-11-12 16:55:35'),(3163,NULL,1,12,'SUSSUAPARA',NULL,5718,64610000,'PI','2210938',1,'2006-11-12 16:55:35'),(3164,NULL,1,12,'TAMBORIL DO PIAU',NULL,5719,64893000,'PI','2210953',1,'2006-11-12 16:55:35'),(3165,NULL,1,12,'TANQUE DO PIAU',NULL,5720,64512000,'PI','2210979',1,'2006-11-12 16:55:35'),(3166,NULL,1,12,'TERESINA',NULL,5721,NULL,'PI','2211001',1,'2006-11-12 16:55:35'),(3167,NULL,1,12,'UNIO',NULL,5722,64120000,'PI','2211100',1,'2006-11-12 16:55:35'),(3168,NULL,1,12,'URUU',NULL,5723,64860000,'PI','2211209',1,'2006-11-12 16:55:35'),(3169,NULL,1,12,'VALENA DO PIAU',NULL,5724,64300000,'PI','2211308',1,'2006-11-12 16:55:35'),(3170,NULL,1,12,'VRZEA BRANCA',NULL,5725,64773000,'PI','2211357',1,'2006-11-12 16:55:35'),(3171,NULL,1,12,'VRZEA GRANDE',NULL,5726,64525000,'PI','2211407',1,'2006-11-12 16:55:35'),(3172,NULL,1,12,'VERA MENDES',NULL,5727,64568000,'PI','2211506',1,'2006-11-12 16:55:35'),(3173,NULL,1,12,'VILA NOVA DO PIAU',NULL,5728,64688000,'PI','2211605',1,'2006-11-12 16:55:35'),(3174,NULL,1,12,'WALL FERRAZ',NULL,5729,64548000,'PI','2211704',1,'2006-11-12 16:55:35'),(3175,NULL,1,24,'ABATI',NULL,5731,86460000,'PR','4100103',1,'2006-11-12 16:55:35'),(3176,NULL,1,24,'ADRIANPOLIS',NULL,5735,83490000,'PR','4100202',1,'2006-11-12 16:55:35'),(3177,NULL,1,24,'AGUDOS DO SUL',NULL,5743,83850000,'PR','4100301',1,'2006-11-12 16:55:36'),(3178,NULL,1,24,'ALMIRANTE TAMANDAR',NULL,5746,NULL,'PR','4100400',1,'2006-11-12 16:55:36'),(3179,NULL,1,24,'ALTAMIRA DO PARAN',NULL,5747,85280000,'PR','4100459',1,'2006-11-12 16:55:36'),(3180,NULL,1,24,'ALTO PARAN',NULL,5755,87750000,'PR','4100608',1,'2006-11-12 16:55:36'),(3181,NULL,1,24,'ALTO PIQUIRI',NULL,5756,87580000,'PR','4100707',1,'2006-11-12 16:55:36'),(3182,NULL,1,24,'ALTNIA',NULL,5761,87550000,'PR','4100509',1,'2006-11-12 16:55:36'),(3183,NULL,1,24,'ALVORADA DO SUL',NULL,5763,86150000,'PR','4100806',1,'2006-11-12 16:55:36'),(3184,NULL,1,24,'AMAPOR',NULL,5764,87850000,'PR','4100905',1,'2006-11-12 16:55:36'),(3185,NULL,1,24,'AMPRE',NULL,5766,85640000,'PR','4101002',1,'2006-11-12 16:55:36'),(3186,NULL,1,24,'ANAHY',NULL,5767,85425000,'PR','4101051',1,'2006-11-12 16:55:36'),(3187,NULL,1,24,'ANDIR',NULL,5768,86380000,'PR','4101101',1,'2006-11-12 16:55:36'),(3188,NULL,1,24,'NGULO',NULL,5771,86755000,'PR','4101150',1,'2006-11-12 16:55:36'),(3189,NULL,1,24,'ANTONINA',NULL,5774,83370000,'PR','4101200',1,'2006-11-12 16:55:36'),(3190,NULL,1,24,'ANTNIO OLINTO',NULL,5776,83980000,'PR','4101309',1,'2006-11-12 16:55:36'),(3191,NULL,1,24,'APUCARANA',NULL,5780,NULL,'PR','4101408',1,'2006-11-12 16:55:36'),(3192,NULL,1,24,'ARAPONGAS',NULL,5783,NULL,'PR','4101507',1,'2006-11-12 16:55:36'),(3193,NULL,1,24,'ARAPOTI',NULL,5784,84990000,'PR','4101606',1,'2006-11-12 16:55:36'),(3194,NULL,1,24,'ARAPU',NULL,5785,86884000,'PR','4101655',1,'2006-11-12 16:55:36'),(3195,NULL,1,24,'ARARUNA',NULL,5788,87260000,'PR','4101705',1,'2006-11-12 16:55:36'),(3196,NULL,1,24,'ARAUCRIA',NULL,5789,NULL,'PR','4101804',1,'2006-11-12 16:55:36'),(3197,NULL,1,24,'ARIRANHA DO IVA',NULL,5793,86880000,'PR','4101853',1,'2006-11-12 16:55:36'),(3198,NULL,1,24,'ASSA',NULL,5796,86220000,'PR','4101903',1,'2006-11-12 16:55:37'),(3199,NULL,1,24,'ASSIS CHATEAUBRIAND',NULL,5797,85935000,'PR','4102000',1,'2006-11-12 16:55:37'),(3200,NULL,1,24,'ASTORGA',NULL,5798,86730000,'PR','4102109',1,'2006-11-12 16:55:37'),(3201,NULL,1,24,'ATALAIA',NULL,5799,87630000,'PR','4102208',1,'2006-11-12 16:55:37'),(3202,NULL,1,24,'BALSA NOVA',NULL,5804,83650000,'PR','4102307',1,'2006-11-12 16:55:37'),(3203,NULL,1,24,'BANDEIRANTES',NULL,5805,86360000,'PR','4102406',1,'2006-11-12 16:55:37'),(3204,NULL,1,24,'BARBOSA FERRAZ',NULL,5809,86960000,'PR','4102505',1,'2006-11-12 16:55:37'),(3205,NULL,1,24,'BARRA DO JACAR',NULL,5812,86385000,'PR','4102703',1,'2006-11-12 16:55:37'),(3206,NULL,1,24,'BARRACO',NULL,5819,85700000,'PR','4102604',1,'2006-11-12 16:55:37'),(3207,NULL,1,24,'BELA VISTA DO CAROBA',NULL,5834,85745000,'PR',NULL,1,'2006-11-12 16:55:37'),(3208,NULL,1,24,'BELA VISTA DO PARASO',NULL,5836,86130000,'PR','4102802',1,'2006-11-12 16:55:37'),(3209,NULL,1,24,'BITURUNA',NULL,5842,84640000,'PR','4102901',1,'2006-11-12 16:55:37'),(3210,NULL,1,24,'BOA ESPERANA',NULL,5843,87390000,'PR','4103008',1,'2006-11-12 16:55:37'),(3211,NULL,1,24,'BOA ESPERANA DO IGUAU',NULL,5845,85680000,'PR','4103024',1,'2006-11-12 16:55:37'),(3212,NULL,1,24,'BOA VENTURA DE SO ROQUE',NULL,5846,85225000,'PR','4103040',1,'2006-11-12 16:55:37'),(3213,NULL,1,24,'BOA VISTA DA APARECIDA',NULL,5852,85780000,'PR','4103057',1,'2006-11-12 16:55:37'),(3214,NULL,1,24,'BOCAIVA DO SUL',NULL,5854,83450000,'PR','4103107',1,'2006-11-12 16:55:37'),(3215,NULL,1,24,'BOM JESUS DO SUL',NULL,5856,85708000,'PR','4103156',1,'2006-11-12 16:55:37'),(3216,NULL,1,24,'BOM SUCESSO',NULL,5862,86940000,'PR','4103206',1,'2006-11-12 16:55:37'),(3217,NULL,1,24,'BOM SUCESSO DO SUL',NULL,5864,85515000,'PR','4103222',1,'2006-11-12 16:55:37'),(3218,NULL,1,24,'BORRAZPOLIS',NULL,5868,86925000,'PR','4103305',1,'2006-11-12 16:55:37'),(3219,NULL,1,24,'BRAGANEY',NULL,5871,85430000,'PR','4103354',1,'2006-11-12 16:55:37'),(3220,NULL,1,24,'BRASILNDIA DO SUL',NULL,5873,87595000,'PR','4103370',1,'2006-11-12 16:55:37'),(3221,NULL,1,24,'CAFEARA',NULL,5886,86640000,'PR','4103404',1,'2006-11-12 16:55:38'),(3222,NULL,1,24,'CAFELNDIA',NULL,5888,85415000,'PR','4103453',1,'2006-11-12 16:55:38'),(3223,NULL,1,24,'CAFEZAL DO SUL',NULL,5889,87565000,'PR','4103479',1,'2006-11-12 16:55:38'),(3224,NULL,1,24,'CALIFRNIA',NULL,5892,86820000,'PR','4103503',1,'2006-11-12 16:55:38'),(3225,NULL,1,24,'CAMBAR',NULL,5894,86390000,'PR','4103602',1,'2006-11-12 16:55:38'),(3226,NULL,1,24,'CAMB',NULL,5895,NULL,'PR','4103701',1,'2006-11-12 16:55:38'),(3227,NULL,1,24,'CAMBIRA',NULL,5897,86890000,'PR','4103800',1,'2006-11-12 16:55:38'),(3228,NULL,1,24,'CAMPINA DA LAGOA',NULL,5902,87345000,'PR','4103909',1,'2006-11-12 16:55:38'),(3229,NULL,1,24,'CAMPINA DO SIMO',NULL,5904,85148000,'PR','4103958',1,'2006-11-12 16:55:38'),(3230,NULL,1,24,'CAMPINA GRANDE DO SUL',NULL,5906,83430000,'PR','4104006',1,'2006-11-12 16:55:38'),(3231,NULL,1,24,'CAMPO BONITO',NULL,5908,85450000,'PR','4104055',1,'2006-11-12 16:55:38'),(3232,NULL,1,24,'CAMPO DO TENENTE',NULL,5910,83870000,'PR','4104105',1,'2006-11-12 16:55:38'),(3233,NULL,1,24,'CAMPO LARGO',NULL,5911,NULL,'PR','4104204',1,'2006-11-12 16:55:38'),(3234,NULL,1,24,'CAMPO MAGRO',NULL,5913,83535000,'PR','4104253',1,'2006-11-12 16:55:38'),(3235,NULL,1,24,'CAMPO MOURO',NULL,5914,NULL,'PR','4104303',1,'2006-11-12 16:55:38'),(3236,NULL,1,24,'CNDIDO DE ABREU',NULL,5915,84470000,'PR','4104402',1,'2006-11-12 16:55:38'),(3237,NULL,1,24,'CANDI',NULL,5916,85140000,'PR','4104428',1,'2006-11-12 16:55:38'),(3238,NULL,1,24,'CANTAGALO',NULL,5918,85160000,'PR','4104451',1,'2006-11-12 16:55:38'),(3239,NULL,1,24,'CAPANEMA',NULL,5920,85760000,'PR','4104501',1,'2006-11-12 16:55:38'),(3240,NULL,1,24,'CAPITO LENIDAS MARQUES',NULL,5927,85790000,'PR','4104600',1,'2006-11-12 16:55:38'),(3241,NULL,1,24,'CARAMBE',NULL,5933,84145000,'PR','4104659',1,'2006-11-12 16:55:38'),(3242,NULL,1,24,'CARLPOLIS',NULL,5938,86420000,'PR','4104709',1,'2006-11-12 16:55:38'),(3243,NULL,1,24,'CASCAVEL',NULL,5941,NULL,'PR','4104808',1,'2006-11-12 16:55:38'),(3244,NULL,1,24,'CASTRO',NULL,5942,NULL,'PR','4104907',1,'2006-11-12 16:55:39'),(3245,NULL,1,24,'CATANDUVAS',NULL,5943,85470000,'PR','4105003',1,'2006-11-12 16:55:39'),(3246,NULL,1,24,'CENTENRIO DO SUL',NULL,5949,86630000,'PR','4105102',1,'2006-11-12 16:55:39'),(3247,NULL,1,24,'CERRO AZUL',NULL,5955,83570000,'PR','4105201',1,'2006-11-12 16:55:39'),(3248,NULL,1,24,'CU AZUL',NULL,5957,85840000,'PR','4105300',1,'2006-11-12 16:55:39'),(3249,NULL,1,24,'CHOPINZINHO',NULL,5958,85560000,'PR','4105409',1,'2006-11-12 16:55:39'),(3250,NULL,1,24,'CIANORTE',NULL,5959,87200000,'PR','4105508',1,'2006-11-12 16:55:39'),(3251,NULL,1,24,'Cidade GACHA',NULL,5960,87820000,'PR','4105607',1,'2006-11-12 16:55:39'),(3252,NULL,1,24,'CLEVELNDIA',NULL,5962,85530000,'PR','4105706',1,'2006-11-12 16:55:39'),(3253,NULL,1,24,'COLOMBO',NULL,5964,NULL,'PR','4105805',1,'2006-11-12 16:55:39'),(3254,NULL,1,24,'COLORADO',NULL,5983,86690000,'PR','4105904',1,'2006-11-12 16:55:39'),(3255,NULL,1,24,'CONGONHINHAS',NULL,5990,86320000,'PR','4106001',1,'2006-11-12 16:55:39'),(3256,NULL,1,24,'CONSELHEIRO MAIRINCK',NULL,5991,86480000,'PR','4106100',1,'2006-11-12 16:55:39'),(3257,NULL,1,24,'CONTENDA',NULL,5993,83730000,'PR','4106209',1,'2006-11-12 16:55:39'),(3258,NULL,1,24,'CORBLIA',NULL,5995,85420000,'PR','4106308',1,'2006-11-12 16:55:39'),(3259,NULL,1,24,'CORNLIO PROCPIO',NULL,5996,86300000,'PR','4106407',1,'2006-11-12 16:55:39'),(3260,NULL,1,24,'CORONEL DOMINGOS SOARES',NULL,5997,85557000,'PR','4106456',1,'2006-11-12 16:55:39'),(3261,NULL,1,24,'CORONEL VIVIDA',NULL,5999,85550000,'PR','4106506',1,'2006-11-12 16:55:39'),(3262,NULL,1,24,'CORUMBATA DO SUL',NULL,6001,86970000,'PR','4106555',1,'2006-11-12 16:55:39'),(3263,NULL,1,24,'CRUZ MACHADO',NULL,6008,84620000,'PR','4106803',1,'2006-11-12 16:55:39'),(3264,NULL,1,24,'CRUZEIRO DO IGUAU',NULL,6009,85598000,'PR','4106571',1,'2006-11-12 16:55:39'),(3265,NULL,1,24,'CRUZEIRO DO OESTE',NULL,6011,87400000,'PR','4106605',1,'2006-11-12 16:55:39'),(3266,NULL,1,24,'CRUZEIRO DO SUL',NULL,6012,87650000,'PR','4106704',1,'2006-11-12 16:55:39'),(3267,NULL,1,24,'CRUZMALTINA',NULL,6013,86855000,'PR','4106852',1,'2006-11-12 16:55:40'),(3268,NULL,1,24,'CURITIBA',NULL,6015,NULL,'PR','4106902',1,'2006-11-12 16:55:40'),(3269,NULL,1,24,'CURIVA',NULL,6016,84280000,'PR','4107009',1,'2006-11-12 16:55:40'),(3270,NULL,1,24,'DIAMANTE D\'OESTE',NULL,6023,85896000,'PR',NULL,1,'2006-11-12 16:55:40'),(3271,NULL,1,24,'DIAMANTE DO NORTE',NULL,6024,87990000,'PR','4107108',1,'2006-11-12 16:55:40'),(3272,NULL,1,24,'DIAMANTE DO SUL',NULL,6025,85408000,'PR','4107124',1,'2006-11-12 16:55:40'),(3273,NULL,1,24,'DOIS VIZINHOS',NULL,6030,85660000,'PR','4107207',1,'2006-11-12 16:55:40'),(3274,NULL,1,24,'DOURADINA',NULL,6033,87485000,'PR','4107256',1,'2006-11-12 16:55:40'),(3275,NULL,1,24,'DOUTOR CAMARGO',NULL,6035,87155000,'PR','4107306',1,'2006-11-12 16:55:40'),(3276,NULL,1,24,'DOUTOR ULYSSES',NULL,6038,83590000,'PR','4128633',1,'2006-11-12 16:55:40'),(3277,NULL,1,24,'ENAS MARQUES',NULL,6046,85630000,'PR','4107405',1,'2006-11-12 16:55:40'),(3278,NULL,1,24,'ENGENHEIRO BELTRO',NULL,6047,87270000,'PR','4107504',1,'2006-11-12 16:55:40'),(3279,NULL,1,24,'ENTRE RIOS DO OESTE',NULL,6049,85988000,'PR','4107538',1,'2006-11-12 16:55:40'),(3280,NULL,1,24,'ESPERANA NOVA',NULL,6051,87545000,'PR','4107520',1,'2006-11-12 16:55:40'),(3281,NULL,1,24,'ESPIGO ALTO DO IGUAU',NULL,6052,85465000,'PR','4107546',1,'2006-11-12 16:55:40'),(3282,NULL,1,24,'FAROL',NULL,6059,87325000,'PR','4107553',1,'2006-11-12 16:55:40'),(3283,NULL,1,24,'FAXINAL',NULL,6061,86840000,'PR','4107603',1,'2006-11-12 16:55:40'),(3284,NULL,1,24,'FAZENDA RIO GRANDE',NULL,6068,83820000,'PR','4107652',1,'2006-11-12 16:55:40'),(3285,NULL,1,24,'FNIX',NULL,6072,86950000,'PR','4107702',1,'2006-11-12 16:55:40'),(3286,NULL,1,24,'FERNANDES PINHEIRO',NULL,6073,84535000,'PR','4107736',1,'2006-11-12 16:55:40'),(3287,NULL,1,24,'FIGUEIRA',NULL,6077,84285000,'PR','4107751',1,'2006-11-12 16:55:40'),(3288,NULL,1,24,'FLOR DA SERRA DO SUL',NULL,6081,85618000,'PR','4107850',1,'2006-11-12 16:55:40'),(3289,NULL,1,24,'FLORA',NULL,6082,87185000,'PR','4107801',1,'2006-11-12 16:55:40'),(3290,NULL,1,24,'FLORESTA',NULL,6083,87120000,'PR','4107900',1,'2006-11-12 16:55:41'),(3291,NULL,1,24,'FLORESTPOLIS',NULL,6084,86165000,'PR','4108007',1,'2006-11-12 16:55:41'),(3292,NULL,1,24,'FLRIDA',NULL,6086,86780000,'PR','4108106',1,'2006-11-12 16:55:41'),(3293,NULL,1,24,'FORMOSA DO OESTE',NULL,6090,85830000,'PR','4108205',1,'2006-11-12 16:55:41'),(3294,NULL,1,24,'FOZ DO IGUAU',NULL,6091,NULL,'PR','4108304',1,'2006-11-12 16:55:41'),(3295,NULL,1,24,'FOZ DO JORDO',NULL,6092,85145000,'PR','4108452',1,'2006-11-12 16:55:41'),(3296,NULL,1,24,'FRANCISCO ALVES',NULL,6093,87570000,'PR','4108320',1,'2006-11-12 16:55:41'),(3297,NULL,1,24,'FRANCISCO BELTRO',NULL,6094,NULL,'PR','4108403',1,'2006-11-12 16:55:41'),(3298,NULL,1,24,'GENERAL CARNEIRO',NULL,6104,84660000,'PR','4108502',1,'2006-11-12 16:55:41'),(3299,NULL,1,24,'GODOY MOREIRA',NULL,6107,86938000,'PR','4108551',1,'2006-11-12 16:55:41'),(3300,NULL,1,24,'GOIOER',NULL,6108,87360000,'PR','4108601',1,'2006-11-12 16:55:41'),(3301,NULL,1,24,'GOIOXIM',NULL,6109,85162000,'PR','4108650',1,'2006-11-12 16:55:41'),(3302,NULL,1,24,'GRANDES RIOS',NULL,6113,86845000,'PR','4108700',1,'2006-11-12 16:55:41'),(3303,NULL,1,24,'GUARA',NULL,6115,85980000,'PR','4108809',1,'2006-11-12 16:55:41'),(3304,NULL,1,24,'GUAIRA',NULL,6116,87880000,'PR','4108908',1,'2006-11-12 16:55:41'),(3305,NULL,1,24,'GUAMIRANGA',NULL,6120,84435000,'PR','4108957',1,'2006-11-12 16:55:41'),(3306,NULL,1,24,'GUAPIRAMA',NULL,6122,86465000,'PR','4109005',1,'2006-11-12 16:55:41'),(3307,NULL,1,24,'GUAPOREMA',NULL,6124,87810000,'PR','4109104',1,'2006-11-12 16:55:41'),(3308,NULL,1,24,'GUARACI',NULL,6126,86620000,'PR','4109203',1,'2006-11-12 16:55:41'),(3309,NULL,1,24,'GUARANIAU',NULL,6130,85400000,'PR','4109302',1,'2006-11-12 16:55:41'),(3310,NULL,1,24,'GUARAPUAVA',NULL,6131,NULL,'PR','4109401',1,'2006-11-12 16:55:41'),(3311,NULL,1,24,'GUARAQUEABA',NULL,6133,83390000,'PR','4109500',1,'2006-11-12 16:55:41'),(3312,NULL,1,24,'GUARATUBA',NULL,6135,83280000,'PR','4109609',1,'2006-11-12 16:55:41'),(3313,NULL,1,24,'HONRIO SERPA',NULL,6145,85548000,'PR','4109658',1,'2006-11-12 16:55:42'),(3314,NULL,1,24,'IBAITI',NULL,6147,84900000,'PR','4109708',1,'2006-11-12 16:55:42'),(3315,NULL,1,24,'IBEMA',NULL,6148,85478000,'PR','4109757',1,'2006-11-12 16:55:42'),(3316,NULL,1,24,'IBIPOR',NULL,6150,86200000,'PR','4109807',1,'2006-11-12 16:55:42'),(3317,NULL,1,24,'ICARAMA',NULL,6152,87530000,'PR','4109906',1,'2006-11-12 16:55:42'),(3318,NULL,1,24,'IGUARAU',NULL,6155,86750000,'PR','4110003',1,'2006-11-12 16:55:42'),(3319,NULL,1,24,'IGUATU',NULL,6157,85423000,'PR','4110052',1,'2006-11-12 16:55:42'),(3320,NULL,1,24,'IMBA',NULL,6161,84250000,'PR','4110078',1,'2006-11-12 16:55:42'),(3321,NULL,1,24,'IMBITUVA',NULL,6163,84430000,'PR','4110102',1,'2006-11-12 16:55:42'),(3322,NULL,1,24,'INCIO MARTINS',NULL,6164,85155000,'PR','4110201',1,'2006-11-12 16:55:42'),(3323,NULL,1,24,'INAJ',NULL,6165,87670000,'PR','4110300',1,'2006-11-12 16:55:42'),(3324,NULL,1,24,'INDIANPOLIS',NULL,6167,87210000,'PR','4110409',1,'2006-11-12 16:55:42'),(3325,NULL,1,24,'IPIRANGA',NULL,6172,84450000,'PR','4110508',1,'2006-11-12 16:55:42'),(3326,NULL,1,24,'IPOR',NULL,6175,87560000,'PR','4110607',1,'2006-11-12 16:55:42'),(3327,NULL,1,24,'IRACEMA DO OESTE',NULL,6176,85833000,'PR','4110656',1,'2006-11-12 16:55:42'),(3328,NULL,1,24,'IRATI',NULL,6178,84500000,'PR','4110706',1,'2006-11-12 16:55:42'),(3329,NULL,1,24,'IRETAMA',NULL,6180,87280000,'PR','4110805',1,'2006-11-12 16:55:42'),(3330,NULL,1,24,'ITAGUAJ',NULL,6181,86670000,'PR','4110904',1,'2006-11-12 16:55:42'),(3331,NULL,1,24,'ITAIPULNDIA',NULL,6183,85880000,'PR','4110953',1,'2006-11-12 16:55:42'),(3332,NULL,1,24,'ITAMBARAC',NULL,6184,86375000,'PR','4111001',1,'2006-11-12 16:55:42'),(3333,NULL,1,24,'ITAMB',NULL,6185,87175000,'PR','4111100',1,'2006-11-12 16:55:42'),(3334,NULL,1,24,'ITAPEJARA D\'OESTE',NULL,6189,85580000,'PR',NULL,1,'2006-11-12 16:55:42'),(3335,NULL,1,24,'ITAPERUU',NULL,6190,83560000,'PR','4111258',1,'2006-11-12 16:55:42'),(3336,NULL,1,24,'ITANA DO SUL',NULL,6192,87980000,'PR','4111308',1,'2006-11-12 16:55:43'),(3337,NULL,1,24,'IVA',NULL,6194,84460000,'PR','4111407',1,'2006-11-12 16:55:43'),(3338,NULL,1,24,'IVAIPOR',NULL,6196,86870000,'PR','4111506',1,'2006-11-12 16:55:43'),(3339,NULL,1,24,'IVAT',NULL,6198,87525000,'PR','4111555',1,'2006-11-12 16:55:43'),(3340,NULL,1,24,'IVATUBA',NULL,6199,87130000,'PR','4111605',1,'2006-11-12 16:55:43'),(3341,NULL,1,24,'JABOTI',NULL,6201,84930000,'PR','4111704',1,'2006-11-12 16:55:43'),(3342,NULL,1,24,'JACAREZINHO',NULL,6205,86400000,'PR','4111803',1,'2006-11-12 16:55:43'),(3343,NULL,1,24,'JAGUAPIT',NULL,6211,86610000,'PR','4111902',1,'2006-11-12 16:55:43'),(3344,NULL,1,24,'JAGUARIAVA',NULL,6212,84200000,'PR','4112009',1,'2006-11-12 16:55:43'),(3345,NULL,1,24,'JANDAIA DO SUL',NULL,6213,86900000,'PR','4112108',1,'2006-11-12 16:55:43'),(3346,NULL,1,24,'JANIPOLIS',NULL,6216,87380000,'PR','4112207',1,'2006-11-12 16:55:43'),(3347,NULL,1,24,'JAPIRA',NULL,6217,84920000,'PR','4112306',1,'2006-11-12 16:55:43'),(3348,NULL,1,24,'JAPUR',NULL,6218,87225000,'PR','4112405',1,'2006-11-12 16:55:43'),(3349,NULL,1,24,'JARDIM ALEGRE',NULL,6221,86860000,'PR','4112504',1,'2006-11-12 16:55:43'),(3350,NULL,1,24,'JARDIM OLINDA',NULL,6222,87690000,'PR','4112603',1,'2006-11-12 16:55:43'),(3351,NULL,1,24,'JATAIZINHO',NULL,6226,86210000,'PR','4112702',1,'2006-11-12 16:55:43'),(3352,NULL,1,24,'JESUTAS',NULL,6228,85835000,'PR','4112751',1,'2006-11-12 16:55:43'),(3353,NULL,1,24,'JOAQUIM TVORA',NULL,6230,86455000,'PR','4112801',1,'2006-11-12 16:55:43'),(3354,NULL,1,24,'JUNDIA DO SUL',NULL,6234,86470000,'PR','4112900',1,'2006-11-12 16:55:43'),(3355,NULL,1,24,'JURANDA',NULL,6235,87355000,'PR','4112959',1,'2006-11-12 16:55:43'),(3356,NULL,1,24,'JUSSARA',NULL,6236,87230000,'PR','4113007',1,'2006-11-12 16:55:43'),(3357,NULL,1,24,'KALOR',NULL,6238,86920000,'PR','4113106',1,'2006-11-12 16:55:43'),(3358,NULL,1,24,'LAPA',NULL,6254,83750000,'PR','4113205',1,'2006-11-12 16:55:44'),(3359,NULL,1,24,'LARANJAL',NULL,6256,85275000,'PR','4113254',1,'2006-11-12 16:55:44'),(3360,NULL,1,24,'LARANJEIRAS DO SUL',NULL,6257,NULL,'PR','4113304',1,'2006-11-12 16:55:44'),(3361,NULL,1,24,'LEPOLIS',NULL,6261,86330000,'PR','4113403',1,'2006-11-12 16:55:44'),(3362,NULL,1,24,'LIDIANPOLIS',NULL,6263,86865000,'PR','4113429',1,'2006-11-12 16:55:44'),(3363,NULL,1,24,'LINDOESTE',NULL,6264,85826000,'PR','4113452',1,'2006-11-12 16:55:44'),(3364,NULL,1,24,'LOANDA',NULL,6266,87900000,'PR','4113502',1,'2006-11-12 16:55:44'),(3365,NULL,1,24,'LOBATO',NULL,6267,86790000,'PR','4113601',1,'2006-11-12 16:55:44'),(3366,NULL,1,24,'LONDRINA',NULL,6268,NULL,'PR','4113700',1,'2006-11-12 16:55:44'),(3367,NULL,1,24,'LUIZIANA',NULL,6272,87290000,'PR','4113734',1,'2006-11-12 16:55:44'),(3368,NULL,1,24,'LUNARDELLI',NULL,6273,86935000,'PR','4113759',1,'2006-11-12 16:55:44'),(3369,NULL,1,24,'LUPIONPOLIS',NULL,6274,86635000,'PR','4113809',1,'2006-11-12 16:55:44'),(3370,NULL,1,24,'MALLET',NULL,6279,84570000,'PR','4113908',1,'2006-11-12 16:55:44'),(3371,NULL,1,24,'MAMBOR',NULL,6281,87340000,'PR','4114005',1,'2006-11-12 16:55:44'),(3372,NULL,1,24,'MANDAGUAU',NULL,6283,87160000,'PR','4114104',1,'2006-11-12 16:55:44'),(3373,NULL,1,24,'MANDAGUARI',NULL,6284,86975000,'PR','4114203',1,'2006-11-12 16:55:44'),(3374,NULL,1,24,'MANDIRITUBA',NULL,6286,83800000,'PR','4114302',1,'2006-11-12 16:55:44'),(3375,NULL,1,24,'MANFRINPOLIS',NULL,6287,85628000,'PR','4114351',1,'2006-11-12 16:55:44'),(3376,NULL,1,24,'MANGUEIRINHA',NULL,6288,85540000,'PR','4114401',1,'2006-11-12 16:55:44'),(3377,NULL,1,24,'MANOEL RIBAS',NULL,6289,85260000,'PR','4114500',1,'2006-11-12 16:55:44'),(3378,NULL,1,24,'MARECHAL CNDIDO RONDON',NULL,6297,85960000,'PR','4114609',1,'2006-11-12 16:55:44'),(3379,NULL,1,24,'MARIA HELENA',NULL,6299,87480000,'PR','4114708',1,'2006-11-12 16:55:44'),(3380,NULL,1,24,'MARIALVA',NULL,6301,86990000,'PR','4114807',1,'2006-11-12 16:55:45'),(3381,NULL,1,24,'MARILNDIA DO SUL',NULL,6303,86825000,'PR','4114906',1,'2006-11-12 16:55:45'),(3382,NULL,1,24,'MARILENA',NULL,6304,87960000,'PR','4115002',1,'2006-11-12 16:55:45'),(3383,NULL,1,24,'MARILUZ',NULL,6306,87470000,'PR','4115101',1,'2006-11-12 16:55:45'),(3384,NULL,1,24,'MARING',NULL,6308,NULL,'PR','4115200',1,'2006-11-12 16:55:45'),(3385,NULL,1,24,'MARIPOLIS',NULL,6309,85525000,'PR','4115309',1,'2006-11-12 16:55:45'),(3386,NULL,1,24,'MARIP',NULL,6310,85955000,'PR','4115358',1,'2006-11-12 16:55:45'),(3387,NULL,1,24,'MARMELEIRO',NULL,6314,85615000,'PR','4115408',1,'2006-11-12 16:55:45'),(3388,NULL,1,24,'MARQUINHO',NULL,6316,85168000,'PR','4115457',1,'2006-11-12 16:55:45'),(3389,NULL,1,24,'MARUMBI',NULL,6319,86910000,'PR','4115507',1,'2006-11-12 16:55:45'),(3390,NULL,1,24,'MATELNDIA',NULL,6320,85887000,'PR','4115606',1,'2006-11-12 16:55:45'),(3391,NULL,1,24,'MATINHOS',NULL,6321,83260000,'PR','4115705',1,'2006-11-12 16:55:45'),(3392,NULL,1,24,'MATO RICO',NULL,6324,85240000,'PR','4115739',1,'2006-11-12 16:55:45'),(3393,NULL,1,24,'MAU DA SERRA',NULL,6325,86828000,'PR','4115754',1,'2006-11-12 16:55:45'),(3394,NULL,1,24,'MEDIANEIRA',NULL,6326,85884000,'PR','4115804',1,'2006-11-12 16:55:45'),(3395,NULL,1,24,'MERCEDES',NULL,6330,85998000,'PR','4115853',1,'2006-11-12 16:55:45'),(3396,NULL,1,24,'MIRADOR',NULL,6331,87840000,'PR','4115903',1,'2006-11-12 16:55:45'),(3397,NULL,1,24,'MIRASELVA',NULL,6334,86615000,'PR','4116000',1,'2006-11-12 16:55:45'),(3398,NULL,1,24,'MISSAL',NULL,6335,85890000,'PR','4116059',1,'2006-11-12 16:55:45'),(3399,NULL,1,24,'MOREIRA SALES',NULL,6338,87370000,'PR','4116109',1,'2006-11-12 16:55:45'),(3400,NULL,1,24,'MORRETES',NULL,6339,83350000,'PR','4116208',1,'2006-11-12 16:55:45'),(3401,NULL,1,24,'MUNHOZ DE MELO',NULL,6342,86760000,'PR','4116307',1,'2006-11-12 16:55:46'),(3402,NULL,1,24,'NOSSA SENHORA DAS GRAAS',NULL,6349,86680000,'PR','4116406',1,'2006-11-12 16:55:46'),(3403,NULL,1,24,'NOVA ALIANA DO IVA',NULL,6352,87790000,'PR','4116505',1,'2006-11-12 16:55:46'),(3404,NULL,1,24,'NOVA AMRICA DA COLINA',NULL,6354,86230000,'PR','4116604',1,'2006-11-12 16:55:46'),(3405,NULL,1,24,'NOVA AURORA',NULL,6356,85410000,'PR','4116703',1,'2006-11-12 16:55:46'),(3406,NULL,1,24,'NOVA CANTU',NULL,6361,87330000,'PR','4116802',1,'2006-11-12 16:55:46'),(3407,NULL,1,24,'NOVA ESPERANA',NULL,6364,87600000,'PR','4116901',1,'2006-11-12 16:55:46'),(3408,NULL,1,24,'NOVA ESPERANA DO SUDOESTE',NULL,6365,85635000,'PR','4116950',1,'2006-11-12 16:55:46'),(3409,NULL,1,24,'NOVA FTIMA',NULL,6366,86310000,'PR','4117008',1,'2006-11-12 16:55:46'),(3410,NULL,1,24,'NOVA LARANJEIRAS',NULL,6367,85350000,'PR','4117057',1,'2006-11-12 16:55:46'),(3411,NULL,1,24,'NOVA LONDRINA',NULL,6368,87970000,'PR','4117107',1,'2006-11-12 16:55:46'),(3412,NULL,1,24,'NOVA OLMPIA',NULL,6370,87490000,'PR','4117206',1,'2006-11-12 16:55:46'),(3413,NULL,1,24,'NOVA PRATA DO IGUAU',NULL,6371,85685000,'PR','4117255',1,'2006-11-12 16:55:46'),(3414,NULL,1,24,'NOVA SANTA BRBARA',NULL,6373,86250000,'PR','4117214',1,'2006-11-12 16:55:46'),(3415,NULL,1,24,'NOVA SANTA ROSA',NULL,6374,85930000,'PR','4117222',1,'2006-11-12 16:55:46'),(3416,NULL,1,24,'NOVA TEBAS',NULL,6375,85250000,'PR','4117271',1,'2006-11-12 16:55:46'),(3417,NULL,1,24,'NOVO ITACOLOMI',NULL,6380,86895000,'PR','4117297',1,'2006-11-12 16:55:46'),(3418,NULL,1,24,'ORTIGUEIRA',NULL,6390,84350000,'PR','4117305',1,'2006-11-12 16:55:46'),(3419,NULL,1,24,'OURIZONA',NULL,6392,87170000,'PR','4117404',1,'2006-11-12 16:55:46'),(3420,NULL,1,24,'OURO VERDE DO OESTE',NULL,6393,85933000,'PR','4117453',1,'2006-11-12 16:55:46'),(3421,NULL,1,24,'PAIANDU',NULL,6396,87140000,'PR','4117503',1,'2006-11-12 16:55:46'),(3422,NULL,1,24,'PALMAS',NULL,6401,85555000,'PR','4117602',1,'2006-11-12 16:55:47'),(3423,NULL,1,24,'PALMEIRA',NULL,6402,84130000,'PR','4117701',1,'2006-11-12 16:55:47'),(3424,NULL,1,24,'PALMITAL',NULL,6406,85270000,'PR','4117800',1,'2006-11-12 16:55:47'),(3425,NULL,1,24,'PALOTINA',NULL,6410,85950000,'PR','4117909',1,'2006-11-12 16:55:47'),(3426,NULL,1,24,'PARASO DO NORTE',NULL,6414,87780000,'PR','4118006',1,'2006-11-12 16:55:47'),(3427,NULL,1,24,'PARANACITY',NULL,6416,87660000,'PR','4118105',1,'2006-11-12 16:55:47'),(3428,NULL,1,24,'PARANAGU',NULL,6418,NULL,'PR','4118204',1,'2006-11-12 16:55:47'),(3429,NULL,1,24,'PARANAPOEMA',NULL,6419,87680000,'PR','4118303',1,'2006-11-12 16:55:47'),(3430,NULL,1,24,'PARANAVA',NULL,6420,NULL,'PR','4118402',1,'2006-11-12 16:55:47'),(3431,NULL,1,24,'PATO BRAGADO',NULL,6426,85948000,'PR','4118451',1,'2006-11-12 16:55:47'),(3432,NULL,1,24,'PATO BRANCO',NULL,6427,NULL,'PR','4118501',1,'2006-11-12 16:55:47'),(3433,NULL,1,24,'PAULA FREITAS',NULL,6430,84630000,'PR','4118600',1,'2006-11-12 16:55:47'),(3434,NULL,1,24,'PAULO FRONTIN',NULL,6432,84635000,'PR','4118709',1,'2006-11-12 16:55:47'),(3435,NULL,1,24,'PEABIRU',NULL,6433,87250000,'PR','4118808',1,'2006-11-12 16:55:47'),(3436,NULL,1,24,'PEROBAL',NULL,6438,87538000,'PR','4118857',1,'2006-11-12 16:55:47'),(3437,NULL,1,24,'PROLA',NULL,6439,87540000,'PR','4118907',1,'2006-11-12 16:55:47'),(3438,NULL,1,24,'PROLA D\'OESTE',NULL,6440,85740000,'PR',NULL,1,'2006-11-12 16:55:47'),(3439,NULL,1,24,'PIN',NULL,6443,83860000,'PR','4119103',1,'2006-11-12 16:55:47'),(3440,NULL,1,24,'PINHAIS',NULL,6445,NULL,'PR','4119152',1,'2006-11-12 16:55:47'),(3441,NULL,1,24,'PINHAL DE SO BENTO',NULL,6446,85727000,'PR','4119251',1,'2006-11-12 16:55:47'),(3442,NULL,1,24,'PINHALO',NULL,6448,84925000,'PR','4119202',1,'2006-11-12 16:55:47'),(3443,NULL,1,24,'PINHO',NULL,6454,85170000,'PR','4119301',1,'2006-11-12 16:55:47'),(3444,NULL,1,24,'PIRA DO SUL',NULL,6458,84240000,'PR','4119400',1,'2006-11-12 16:55:47'),(3445,NULL,1,24,'PIRAQUARA',NULL,6460,NULL,'PR','4119509',1,'2006-11-12 16:55:48'),(3446,NULL,1,24,'PITANGA',NULL,6462,85200000,'PR','4119608',1,'2006-11-12 16:55:48'),(3447,NULL,1,24,'PITANGUEIRAS',NULL,6463,86613000,'PR','4119657',1,'2006-11-12 16:55:48'),(3448,NULL,1,24,'PLANALTINA DO PARAN',NULL,6465,87860000,'PR','4119707',1,'2006-11-12 16:55:48'),(3449,NULL,1,24,'PLANALTO',NULL,6466,85750000,'PR','4119806',1,'2006-11-12 16:55:48'),(3450,NULL,1,24,'PONTA GROSSA',NULL,6471,NULL,'PR','4119905',1,'2006-11-12 16:55:48'),(3451,NULL,1,24,'PONTAL DO PARAN',NULL,6472,83255000,'PR','4119954',1,'2006-11-12 16:55:48'),(3452,NULL,1,24,'PORECATU',NULL,6473,86160000,'PR','4120002',1,'2006-11-12 16:55:48'),(3453,NULL,1,24,'PORTO AMAZONAS',NULL,6476,84140000,'PR','4120101',1,'2006-11-12 16:55:48'),(3454,NULL,1,24,'PORTO BARREIRO',NULL,6477,85345000,'PR','4120150',1,'2006-11-12 16:55:48'),(3455,NULL,1,24,'PORTO RICO',NULL,6484,87950000,'PR','4120200',1,'2006-11-12 16:55:48'),(3456,NULL,1,24,'PORTO VITRIA',NULL,6489,84610000,'PR','4120309',1,'2006-11-12 16:55:48'),(3457,NULL,1,24,'PRADO FERREIRA',NULL,6490,86618000,'PR','4120333',1,'2006-11-12 16:55:48'),(3458,NULL,1,24,'PRANCHITA',NULL,6491,85730000,'PR','4120358',1,'2006-11-12 16:55:48'),(3459,NULL,1,24,'PRESIDENTE CASTELO BRANCO',NULL,6494,87180000,'PR','4120408',1,'2006-11-12 16:55:48'),(3460,NULL,1,24,'PRIMEIRO DE MAIO',NULL,6496,86140000,'PR','4120507',1,'2006-11-12 16:55:48'),(3461,NULL,1,24,'PRUDENTPOLIS',NULL,6498,84400000,'PR','4120606',1,'2006-11-12 16:55:48'),(3462,NULL,1,24,'QUATIGU',NULL,6500,86450000,'PR','4120705',1,'2006-11-12 16:55:48'),(3463,NULL,1,24,'QUATRO BARRAS',NULL,6501,83420000,'PR','4120804',1,'2006-11-12 16:55:48'),(3464,NULL,1,24,'QUATRO PONTES',NULL,6502,85940000,'PR','4120853',1,'2006-11-12 16:55:48'),(3465,NULL,1,24,'QUEDAS DO IGUAU',NULL,6504,85460000,'PR','4120903',1,'2006-11-12 16:55:48'),(3466,NULL,1,24,'QUERNCIA DO NORTE',NULL,6506,87930000,'PR','4121000',1,'2006-11-12 16:55:48'),(3467,NULL,1,24,'QUINTA DO SOL',NULL,6507,87265000,'PR','4121109',1,'2006-11-12 16:55:48'),(3468,NULL,1,24,'QUITANDINHA',NULL,6509,83840000,'PR','4121208',1,'2006-11-12 16:55:49'),(3469,NULL,1,24,'RAMILNDIA',NULL,6510,85888000,'PR','4121257',1,'2006-11-12 16:55:49'),(3470,NULL,1,24,'RANCHO ALEGRE',NULL,6511,86290000,'PR','4121307',1,'2006-11-12 16:55:49'),(3471,NULL,1,24,'RANCHO ALEGRE D\'OESTE',NULL,6512,87395000,'PR',NULL,1,'2006-11-12 16:55:49'),(3472,NULL,1,24,'REALEZA',NULL,6513,85770000,'PR','4121406',1,'2006-11-12 16:55:49'),(3473,NULL,1,24,'REBOUAS',NULL,6514,84550000,'PR','4121505',1,'2006-11-12 16:55:49'),(3474,NULL,1,24,'RENASCENA',NULL,6517,85610000,'PR','4121604',1,'2006-11-12 16:55:49'),(3475,NULL,1,24,'RESERVA',NULL,6518,84320000,'PR','4121703',1,'2006-11-12 16:55:49'),(3476,NULL,1,24,'RESERVA DO IGUAU',NULL,6519,85195000,'PR','4121752',1,'2006-11-12 16:55:49'),(3477,NULL,1,24,'RIBEIRO CLARO',NULL,6523,86410000,'PR','4121802',1,'2006-11-12 16:55:49'),(3478,NULL,1,24,'RIBEIRO DO PINHAL',NULL,6524,86490000,'PR','4121901',1,'2006-11-12 16:55:49'),(3479,NULL,1,24,'RIO AZUL',NULL,6527,84560000,'PR','4122008',1,'2006-11-12 16:55:49'),(3480,NULL,1,24,'RIO BOM',NULL,6528,86830000,'PR','4122107',1,'2006-11-12 16:55:49'),(3481,NULL,1,24,'RIO BONITO DO IGUAU',NULL,6530,85340000,'PR','4122156',1,'2006-11-12 16:55:49'),(3482,NULL,1,24,'RIO BRANCO DO IVA',NULL,6531,86848000,'PR','4122172',1,'2006-11-12 16:55:49'),(3483,NULL,1,24,'RIO BRANCO DO SUL',NULL,6532,83540000,'PR','4122206',1,'2006-11-12 16:55:49'),(3484,NULL,1,24,'RIO NEGRO',NULL,6543,83880000,'PR','4122305',1,'2006-11-12 16:55:49'),(3485,NULL,1,24,'ROLNDIA',NULL,6554,86600000,'PR','4122404',1,'2006-11-12 16:55:49'),(3486,NULL,1,24,'RONCADOR',NULL,6556,87320000,'PR','4122503',1,'2006-11-12 16:55:49'),(3487,NULL,1,24,'RONDON',NULL,6558,87800000,'PR','4122602',1,'2006-11-12 16:55:49'),(3488,NULL,1,24,'ROSRIO DO IVA',NULL,6559,86850000,'PR','4122651',1,'2006-11-12 16:55:49'),(3489,NULL,1,24,'SABUDIA',NULL,6560,86720000,'PR','4122701',1,'2006-11-12 16:55:49'),(3490,NULL,1,24,'SALGADO FILHO',NULL,6562,85620000,'PR','4122800',1,'2006-11-12 16:55:49'),(3491,NULL,1,24,'SALTO DO ITARAR',NULL,6565,84945000,'PR','4122909',1,'2006-11-12 16:55:50'),(3492,NULL,1,24,'SALTO DO LONTRA',NULL,6566,85670000,'PR','4123006',1,'2006-11-12 16:55:50'),(3493,NULL,1,24,'SANTA AMLIA',NULL,6569,86370000,'PR','4123105',1,'2006-11-12 16:55:50'),(3494,NULL,1,24,'SANTA CECLIA DO PAVO',NULL,6570,86225000,'PR','4123204',1,'2006-11-12 16:55:50'),(3495,NULL,1,24,'SANTA CRUZ DE MONTE CASTELO',NULL,6572,87920000,'PR','4123303',1,'2006-11-12 16:55:50'),(3496,NULL,1,24,'SANTA F',NULL,6575,86770000,'PR','4123402',1,'2006-11-12 16:55:50'),(3497,NULL,1,24,'SANTA HELENA',NULL,6577,85892000,'PR','4123501',1,'2006-11-12 16:55:50'),(3498,NULL,1,24,'SANTA INS',NULL,6578,86660000,'PR','4123600',1,'2006-11-12 16:55:50'),(3499,NULL,1,24,'SANTA ISABEL DO IVA',NULL,6579,87910000,'PR','4123709',1,'2006-11-12 16:55:50'),(3500,NULL,1,24,'SANTA IZABEL DO OESTE',NULL,6580,85650000,'PR','4123808',1,'2006-11-12 16:55:50'),(3501,NULL,1,24,'SANTA LCIA',NULL,6581,85795000,'PR','4123824',1,'2006-11-12 16:55:50'),(3502,NULL,1,24,'SANTA MARIA DO OESTE',NULL,6587,85230000,'PR','4123857',1,'2006-11-12 16:55:50'),(3503,NULL,1,24,'SANTA MARIANA',NULL,6589,86350000,'PR','4123907',1,'2006-11-12 16:55:50'),(3504,NULL,1,24,'SANTA MNICA',NULL,6590,87915000,'PR','4123956',1,'2006-11-12 16:55:50'),(3505,NULL,1,24,'SANTA TEREZA DO OESTE',NULL,6597,85825000,'PR','4124020',1,'2006-11-12 16:55:50'),(3506,NULL,1,24,'SANTA TEREZINHA DE ITAIPU',NULL,6598,85875000,'PR','4124053',1,'2006-11-12 16:55:50'),(3507,NULL,1,24,'SANTANA DO ITARAR',NULL,6601,84970000,'PR','4124004',1,'2006-11-12 16:55:50'),(3508,NULL,1,24,'SANTO ANTNIO DA PLATINA',NULL,6604,86430000,'PR','4124103',1,'2006-11-12 16:55:50'),(3509,NULL,1,24,'SANTO ANTNIO DO CAIU',NULL,6605,87730000,'PR','4124202',1,'2006-11-12 16:55:50'),(3510,NULL,1,24,'SANTO ANTNIO DO PARASO',NULL,6608,86315000,'PR','4124301',1,'2006-11-12 16:55:50'),(3511,NULL,1,24,'SANTO ANTNIO DO SUDOESTE',NULL,6609,85710000,'PR','4124400',1,'2006-11-12 16:55:50'),(3512,NULL,1,24,'SANTO INCIO',NULL,6610,86650000,'PR','4124509',1,'2006-11-12 16:55:50'),(3513,NULL,1,24,'SO CARLOS DO IVA',NULL,6616,87770000,'PR','4124608',1,'2006-11-12 16:55:50'),(3514,NULL,1,24,'SO JERNIMO DA SERRA',NULL,6632,86270000,'PR','4124707',1,'2006-11-12 16:55:51'),(3515,NULL,1,24,'SO JOO',NULL,6633,85570000,'PR','4124806',1,'2006-11-12 16:55:51'),(3516,NULL,1,24,'SO JOO DO CAIU',NULL,6639,87740000,'PR','4124905',1,'2006-11-12 16:55:51'),(3517,NULL,1,24,'SO JOO DO IVA',NULL,6640,86930000,'PR','4125001',1,'2006-11-12 16:55:51'),(3518,NULL,1,24,'SO JOO DO TRIUNFO',NULL,6642,84150000,'PR','4125100',1,'2006-11-12 16:55:51'),(3519,NULL,1,24,'SO JORGE DO OESTE',NULL,6646,85575000,'PR',NULL,1,'2006-11-12 16:55:51'),(3520,NULL,1,24,'SO JORGE DO IVA',NULL,6647,87190000,'PR','4125308',1,'2006-11-12 16:55:51'),(3521,NULL,1,24,'SO JORGE DO PATROCNIO',NULL,6648,87555000,'PR','4125357',1,'2006-11-12 16:55:51'),(3522,NULL,1,24,'SO JOS DA BOA VISTA',NULL,6651,84980000,'PR','4125407',1,'2006-11-12 16:55:51'),(3523,NULL,1,24,'SO JOS DAS PALMEIRAS',NULL,6652,85898000,'PR','4125456',1,'2006-11-12 16:55:51'),(3524,NULL,1,24,'SO JOS DOS PINHAIS',NULL,6656,NULL,'PR','4125506',1,'2006-11-12 16:55:51'),(3525,NULL,1,24,'SO MANOEL DO PARAN',NULL,6670,87215000,'PR','4125555',1,'2006-11-12 16:55:51'),(3526,NULL,1,24,'SO MATEUS DO SUL',NULL,6674,83900000,'PR','4125605',1,'2006-11-12 16:55:51'),(3527,NULL,1,24,'SO MIGUEL DO IGUAU',NULL,6679,85877000,'PR','4125704',1,'2006-11-12 16:55:51'),(3528,NULL,1,24,'SO PEDRO DO IGUAU',NULL,6687,85929000,'PR','4125753',1,'2006-11-12 16:55:51'),(3529,NULL,1,24,'SO PEDRO DO IVA',NULL,6688,86945000,'PR','4125803',1,'2006-11-12 16:55:51'),(3530,NULL,1,24,'SO PEDRO DO PARAN',NULL,6689,87955000,'PR','4125902',1,'2006-11-12 16:55:51'),(3531,NULL,1,24,'SO SEBASTIO DA AMOREIRA',NULL,6702,86240000,'PR','4126009',1,'2006-11-12 16:55:51'),(3532,NULL,1,24,'SO TOM',NULL,6704,87220000,'PR','4126108',1,'2006-11-12 16:55:51'),(3533,NULL,1,24,'SAPOPEMA',NULL,6708,84290000,'PR','4126207',1,'2006-11-12 16:55:51'),(3534,NULL,1,24,'SARANDI',NULL,6709,NULL,'PR','4126256',1,'2006-11-12 16:55:51'),(3535,NULL,1,24,'SAUDADE DO IGUAU',NULL,6711,85568000,'PR','4126272',1,'2006-11-12 16:55:51'),(3536,NULL,1,24,'SENGS',NULL,6718,84220000,'PR','4126306',1,'2006-11-12 16:55:51'),(3537,NULL,1,24,'SERRANPOLIS DO IGUAU',NULL,6722,85885000,'PR','4126355',1,'2006-11-12 16:55:52'),(3538,NULL,1,24,'SERTANEJA',NULL,6727,86340000,'PR','4126405',1,'2006-11-12 16:55:52'),(3539,NULL,1,24,'SERTANPOLIS',NULL,6728,86170000,'PR','4126504',1,'2006-11-12 16:55:52'),(3540,NULL,1,24,'SIQUEIRA CAMPOS',NULL,6734,84940000,'PR','4126603',1,'2006-11-12 16:55:52'),(3541,NULL,1,24,'SULINA',NULL,6737,85565000,'PR','4126652',1,'2006-11-12 16:55:52'),(3542,NULL,1,24,'TAMARANA',NULL,6742,86125000,'PR','4126678',1,'2006-11-12 16:55:52'),(3543,NULL,1,24,'TAMBOARA',NULL,6744,87760000,'PR','4126702',1,'2006-11-12 16:55:52'),(3544,NULL,1,24,'TAPEJARA',NULL,6746,87430000,'PR','4126801',1,'2006-11-12 16:55:52'),(3545,NULL,1,24,'TAPIRA',NULL,6747,87830000,'PR','4126900',1,'2006-11-12 16:55:52'),(3546,NULL,1,24,'TEIXEIRA SOARES',NULL,6753,84530000,'PR','4127007',1,'2006-11-12 16:55:52'),(3547,NULL,1,24,'TELMACO BORBA',NULL,6754,NULL,'PR','4127106',1,'2006-11-12 16:55:52'),(3548,NULL,1,24,'TERRA BOA',NULL,6758,87240000,'PR','4127205',1,'2006-11-12 16:55:52'),(3549,NULL,1,24,'TERRA RICA',NULL,6760,87890000,'PR','4127304',1,'2006-11-12 16:55:52'),(3550,NULL,1,24,'TERRA ROXA',NULL,6761,85990000,'PR','4127403',1,'2006-11-12 16:55:52'),(3551,NULL,1,24,'TIBAGI',NULL,6762,84300000,'PR','4127502',1,'2006-11-12 16:55:52'),(3552,NULL,1,24,'TIJUCAS DO SUL',NULL,6763,83190000,'PR','4127601',1,'2006-11-12 16:55:52'),(3553,NULL,1,24,'TOLEDO',NULL,6770,NULL,'PR','4127700',1,'2006-11-12 16:55:52'),(3554,NULL,1,24,'TOMAZINA',NULL,6772,84935000,'PR','4127809',1,'2006-11-12 16:55:52'),(3555,NULL,1,24,'TRS BARRAS DO PARAN',NULL,6774,85485000,'PR','4127858',1,'2006-11-12 16:55:52'),(3556,NULL,1,24,'TUNAS DO PARAN',NULL,6786,83480000,'PR','4127882',1,'2006-11-12 16:55:52'),(3557,NULL,1,24,'TUNEIRAS DO OESTE',NULL,6787,87450000,'PR','4127908',1,'2006-11-12 16:55:52'),(3558,NULL,1,24,'TUPSSI',NULL,6788,85945000,'PR','4127957',1,'2006-11-12 16:55:52'),(3559,NULL,1,24,'TURVO',NULL,6790,85150000,'PR','4127965',1,'2006-11-12 16:55:53'),(3560,NULL,1,24,'UBIRAT',NULL,6793,85440000,'PR','4128005',1,'2006-11-12 16:55:53'),(3561,NULL,1,24,'UMUARAMA',NULL,6794,NULL,'PR','4128104',1,'2006-11-12 16:55:53'),(3562,NULL,1,24,'UNIO DA VITRIA',NULL,6796,84600000,'PR','4128203',1,'2006-11-12 16:55:53'),(3563,NULL,1,24,'UNIFLOR',NULL,6798,87640000,'PR','4128302',1,'2006-11-12 16:55:53'),(3564,NULL,1,24,'URA',NULL,6799,86280000,'PR','4128401',1,'2006-11-12 16:55:53'),(3565,NULL,1,24,'VENTANIA',NULL,6806,84345000,'PR','4128534',1,'2006-11-12 16:55:53'),(3566,NULL,1,24,'VERA CRUZ DO OESTE',NULL,6807,85845000,'PR','4128559',1,'2006-11-12 16:55:53'),(3567,NULL,1,24,'VER',NULL,6809,85585000,'PR','4128609',1,'2006-11-12 16:55:53'),(3568,NULL,1,24,'VILA ALTA',NULL,6812,87528000,'PR',NULL,1,'2006-11-12 16:55:53'),(3569,NULL,1,24,'VIRMOND',NULL,6827,85390000,'PR','4128658',1,'2006-11-12 16:55:53'),(3570,NULL,1,24,'VITORINO',NULL,6832,85520000,'PR','4128708',1,'2006-11-12 16:55:53'),(3571,NULL,1,24,'WENCESLAU BRAZ',NULL,6834,84950000,'PR','4128500',1,'2006-11-12 16:55:53'),(3572,NULL,1,24,'XAMBR',NULL,6835,87535000,'PR','4128807',1,'2006-11-12 16:55:53'),(3573,NULL,1,24,'4. CENTENRIO',NULL,6838,87365000,'PR',NULL,1,'2006-11-12 16:55:53'),(3574,NULL,1,22,'ANGRA DOS REIS',NULL,6845,23900000,'RJ','3300100',1,'2006-11-12 16:55:53'),(3575,NULL,1,22,'APERIB',NULL,6847,28495000,'RJ','3300159',1,'2006-11-12 16:55:53'),(3576,NULL,1,22,'ARARUAMA',NULL,6848,28970000,'RJ','3300209',1,'2006-11-12 16:55:53'),(3577,NULL,1,22,'AREAL',NULL,6849,25845000,'RJ','3300225',1,'2006-11-12 16:55:53'),(3578,NULL,1,22,'ARMAO DE BZIOS',NULL,6850,28950000,'RJ',NULL,1,'2006-11-12 16:55:53'),(3579,NULL,1,22,'ARRAIAL DO CABO',NULL,6851,28930000,'RJ','3300258',1,'2006-11-12 16:55:53'),(3580,NULL,1,22,'BARRA DO PIRA',NULL,6862,NULL,'RJ','3300308',1,'2006-11-12 16:55:54'),(3581,NULL,1,22,'BARRA MANSA',NULL,6863,NULL,'RJ','3300407',1,'2006-11-12 16:55:54'),(3582,NULL,1,22,'BELFORD ROXO',NULL,6865,NULL,'RJ','3300456',1,'2006-11-12 16:55:54'),(3583,NULL,1,22,'BOM JARDIM',NULL,6870,28660000,'RJ','3300506',1,'2006-11-12 16:55:54'),(3584,NULL,1,22,'BOM JESUS DO ITABAPOANA',NULL,6871,28360000,'RJ','3300605',1,'2006-11-12 16:55:54'),(3585,NULL,1,22,'CABO FRIO',NULL,6873,NULL,'RJ','3300704',1,'2006-11-12 16:55:54'),(3586,NULL,1,22,'CACHOEIRAS DE MACACU',NULL,6875,28680000,'RJ','3300803',1,'2006-11-12 16:55:54'),(3587,NULL,1,22,'CAMBUCI',NULL,6879,28430000,'RJ','3300902',1,'2006-11-12 16:55:54'),(3588,NULL,1,22,'CAMPOS DOS GOYTACAZES',NULL,6881,NULL,'RJ','3301009',1,'2006-11-12 16:55:54'),(3589,NULL,1,22,'CANTAGALO',NULL,6883,28500000,'RJ','3301108',1,'2006-11-12 16:55:54'),(3590,NULL,1,22,'CARAPEBUS',NULL,6885,27998000,'RJ','3300936',1,'2006-11-12 16:55:54'),(3591,NULL,1,22,'CARDOSO MOREIRA',NULL,6886,28180000,'RJ','3301157',1,'2006-11-12 16:55:54'),(3592,NULL,1,22,'CARMO',NULL,6887,28640000,'RJ','3301207',1,'2006-11-12 16:55:54'),(3593,NULL,1,22,'CASIMIRO DE ABREU',NULL,6889,28860000,'RJ','3301306',1,'2006-11-12 16:55:54'),(3594,NULL,1,22,'COMENDADOR LEVY GASPARIAN',NULL,6893,25870000,'RJ','3300951',1,'2006-11-12 16:55:54'),(3595,NULL,1,22,'CONCEIO DE MACABU',NULL,6896,28740000,'RJ','3301405',1,'2006-11-12 16:55:54'),(3596,NULL,1,22,'CORDEIRO',NULL,6900,28540000,'RJ','3301504',1,'2006-11-12 16:55:54'),(3597,NULL,1,22,'DUAS BARRAS',NULL,6911,28650000,'RJ','3301603',1,'2006-11-12 16:55:54'),(3598,NULL,1,22,'DUQUE DE CAXIAS',NULL,6912,NULL,'RJ','3301702',1,'2006-11-12 16:55:54'),(3599,NULL,1,22,'ENGENHEIRO PAULO DE FRONTIN',NULL,6914,26650000,'RJ','3301801',1,'2006-11-12 16:55:54'),(3600,NULL,1,22,'GUAPIMIRIM',NULL,6927,25940000,'RJ','3301850',1,'2006-11-12 16:55:54'),(3601,NULL,1,22,'IGUABA GRANDE',NULL,6932,28960000,'RJ','3301876',1,'2006-11-12 16:55:54'),(3602,NULL,1,22,'ITABORA',NULL,6941,24800000,'RJ','3301900',1,'2006-11-12 16:55:55'),(3603,NULL,1,22,'ITAGUA',NULL,6943,NULL,'RJ','3302007',1,'2006-11-12 16:55:55'),(3604,NULL,1,22,'ITALVA',NULL,6947,28250000,'RJ','3302056',1,'2006-11-12 16:55:55'),(3605,NULL,1,22,'ITAOCARA',NULL,6949,28570000,'RJ','3302106',1,'2006-11-12 16:55:55'),(3606,NULL,1,22,'ITAPERUNA',NULL,6950,28300000,'RJ','3302205',1,'2006-11-12 16:55:55'),(3607,NULL,1,22,'ITATIAIA',NULL,6951,27580000,'RJ','3302254',1,'2006-11-12 16:55:55'),(3608,NULL,1,22,'JAPERI',NULL,6955,NULL,'RJ','3302270',1,'2006-11-12 16:55:55'),(3609,NULL,1,22,'LAJE DO MURIA',NULL,6957,28350000,'RJ','3302304',1,'2006-11-12 16:55:55'),(3610,NULL,1,22,'MACA',NULL,6962,NULL,'RJ','3302403',1,'2006-11-12 16:55:55'),(3611,NULL,1,22,'MACUCO',NULL,6963,28545000,'RJ','3302452',1,'2006-11-12 16:55:55'),(3612,NULL,1,22,'MAG',NULL,6964,25900000,'RJ','3302502',1,'2006-11-12 16:55:55'),(3613,NULL,1,22,'MANGARATIBA',NULL,6966,23860000,'RJ','3302601',1,'2006-11-12 16:55:55'),(3614,NULL,1,22,'MARIC',NULL,6971,24900000,'RJ','3302700',1,'2006-11-12 16:55:55'),(3615,NULL,1,22,'MENDES',NULL,6972,26700000,'RJ','3302809',1,'2006-11-12 16:55:55'),(3616,NULL,1,22,'MESQUITA',NULL,6973,NULL,'RJ','3302858',1,'2006-11-12 16:55:55'),(3617,NULL,1,22,'MIGUEL PEREIRA',NULL,6974,26900000,'RJ','3302908',1,'2006-11-12 16:55:55'),(3618,NULL,1,22,'MIRACEMA',NULL,6975,28460000,'RJ','3303005',1,'2006-11-12 16:55:55'),(3619,NULL,1,22,'NATIVIDADE',NULL,6985,28380000,'RJ','3303104',1,'2006-11-12 16:55:55'),(3620,NULL,1,22,'NILPOLIS',NULL,6988,NULL,'RJ','3303203',1,'2006-11-12 16:55:55'),(3621,NULL,1,22,'NITERI',NULL,6989,NULL,'RJ','3303302',1,'2006-11-12 16:55:56'),(3622,NULL,1,22,'NOVA FRIBURGO',NULL,6993,NULL,'RJ','3303401',1,'2006-11-12 16:55:56'),(3623,NULL,1,22,'NOVA IGUAU',NULL,6994,NULL,'RJ','3303500',1,'2006-11-12 16:55:56'),(3624,NULL,1,22,'PARACAMBI',NULL,6999,26600000,'RJ','3303609',1,'2006-11-12 16:55:56'),(3625,NULL,1,22,'PARABA DO SUL',NULL,7000,25850000,'RJ','3303708',1,'2006-11-12 16:55:56'),(3626,NULL,1,22,'PARATI',NULL,7004,23970000,'RJ','3303807',1,'2006-11-12 16:55:56'),(3627,NULL,1,22,'PATY DO ALFERES',NULL,7007,26950000,'RJ','3303856',1,'2006-11-12 16:55:56'),(3628,NULL,1,22,'PETRPOLIS',NULL,7012,NULL,'RJ','3303906',1,'2006-11-12 16:55:56'),(3629,NULL,1,22,'PINHEIRAL',NULL,7015,27197000,'RJ','3303955',1,'2006-11-12 16:55:56'),(3630,NULL,1,22,'PIRA',NULL,7017,27175000,'RJ','3304003',1,'2006-11-12 16:55:56'),(3631,NULL,1,22,'PORCINCULA',NULL,7020,28390000,'RJ','3304102',1,'2006-11-12 16:55:56'),(3632,NULL,1,22,'PORTO REAL',NULL,7023,27570000,'RJ','3304110',1,'2006-11-12 16:55:56'),(3633,NULL,1,22,'QUATIS',NULL,7030,NULL,'RJ','3304128',1,'2006-11-12 16:55:56'),(3634,NULL,1,22,'QUEIMADOS',NULL,7031,NULL,'RJ','3304144',1,'2006-11-12 16:55:56'),(3635,NULL,1,22,'QUISSAM',NULL,7032,28735000,'RJ','3304151',1,'2006-11-12 16:55:56'),(3636,NULL,1,22,'RESENDE',NULL,7035,NULL,'RJ','3304201',1,'2006-11-12 16:55:56'),(3637,NULL,1,22,'RIO BONITO',NULL,7039,28800000,'RJ','3304300',1,'2006-11-12 16:55:56'),(3638,NULL,1,22,'RIO CLARO',NULL,7040,27460000,'RJ','3304409',1,'2006-11-12 16:55:56'),(3639,NULL,1,22,'RIO DAS FLORES',NULL,7041,27660000,'RJ','3304508',1,'2006-11-12 16:55:56'),(3640,NULL,1,22,'RIO DAS OSTRAS',NULL,7042,28890000,'RJ','3304524',1,'2006-11-12 16:55:56'),(3641,NULL,1,22,'RIO DE JANEIRO',NULL,7043,NULL,'RJ','3304557',1,'2006-11-12 16:55:56'),(3642,NULL,1,22,'SANTA MARIA MADALENA',NULL,7057,28770000,'RJ','3304607',1,'2006-11-12 16:55:56'),(3643,NULL,1,22,'SANTO ANTNIO DE PDUA',NULL,7062,28470000,'RJ','3304706',1,'2006-11-12 16:55:57'),(3644,NULL,1,22,'SO FIDLIS',NULL,7065,28400000,'RJ','3304805',1,'2006-11-12 16:55:57'),(3645,NULL,1,22,'SO FRANCISCO DE ITABAPOANA',NULL,7066,28230000,'RJ','3304755',1,'2006-11-12 16:55:57'),(3646,NULL,1,22,'SO GONALO',NULL,7067,NULL,'RJ','3304904',1,'2006-11-12 16:55:57'),(3647,NULL,1,22,'SO JOO DA BARRA',NULL,7068,28200000,'RJ','3305000',1,'2006-11-12 16:55:57'),(3648,NULL,1,22,'SO JOO DE MERITI',NULL,7069,NULL,'RJ','3305109',1,'2006-11-12 16:55:57'),(3649,NULL,1,22,'SO JOS DE UB',NULL,7073,28455000,'RJ','3305133',1,'2006-11-12 16:55:57'),(3650,NULL,1,22,'SO JOS DO VALE DO RIO PRETO',NULL,7076,25780000,'RJ','3305158',1,'2006-11-12 16:55:57'),(3651,NULL,1,22,'SO PEDRO DA ALDEIA',NULL,7078,28940000,'RJ','3305208',1,'2006-11-12 16:55:57'),(3652,NULL,1,22,'SO SEBASTIO DO ALTO',NULL,7080,28550000,'RJ','3305307',1,'2006-11-12 16:55:57'),(3653,NULL,1,22,'SAPUCAIA',NULL,7084,25880000,'RJ','3305406',1,'2006-11-12 16:55:57'),(3654,NULL,1,22,'SAQUAREMA',NULL,7085,28990000,'RJ','3305505',1,'2006-11-12 16:55:57'),(3655,NULL,1,22,'SEROPDICA',NULL,7088,23890000,'RJ','3305554',1,'2006-11-12 16:55:57'),(3656,NULL,1,22,'SILVA JARDIM',NULL,7091,28820000,'RJ','3305604',1,'2006-11-12 16:55:57'),(3657,NULL,1,22,'SUMIDOURO',NULL,7095,28637000,'RJ','3305703',1,'2006-11-12 16:55:57'),(3658,NULL,1,22,'TANGU',NULL,7099,24890000,'RJ','3305752',1,'2006-11-12 16:55:57'),(3659,NULL,1,22,'TERESPOLIS',NULL,7102,NULL,'RJ','3305802',1,'2006-11-12 16:55:57'),(3660,NULL,1,22,'TRAJANO DE MORAIS',NULL,7104,28750000,'RJ','3305901',1,'2006-11-12 16:55:57'),(3661,NULL,1,22,'TRS RIOS',NULL,7107,NULL,'RJ','3306008',1,'2006-11-12 16:55:57'),(3662,NULL,1,22,'VALENA',NULL,7110,27600000,'RJ','3306107',1,'2006-11-12 16:55:57'),(3663,NULL,1,22,'VARRE-SAI',NULL,7112,28375000,'RJ','3306156',1,'2006-11-12 16:55:57'),(3664,NULL,1,22,'VASSOURAS',NULL,7113,27700000,'RJ','3306206',1,'2006-11-12 16:55:58'),(3665,NULL,1,22,'VOLTA REDONDA',NULL,7121,NULL,'RJ','3306305',1,'2006-11-12 16:55:58'),(3666,NULL,1,15,'ACARI',NULL,7124,59370000,'RN','2400109',1,'2006-11-12 16:55:58'),(3667,NULL,1,15,'AU',NULL,7125,59650000,'RN','2400208',1,'2006-11-12 16:55:58'),(3668,NULL,1,15,'AFONSO BEZERRA',NULL,7126,59510000,'RN','2400307',1,'2006-11-12 16:55:58'),(3669,NULL,1,15,'GUA NOVA',NULL,7127,59995000,'RN','2400406',1,'2006-11-12 16:55:58'),(3670,NULL,1,15,'ALEXANDRIA',NULL,7128,59965000,'RN','2400505',1,'2006-11-12 16:55:58'),(3671,NULL,1,15,'ALMINO AFONSO',NULL,7129,59760000,'RN','2400604',1,'2006-11-12 16:55:58'),(3672,NULL,1,15,'ALTO DO RODRIGUES',NULL,7130,59507000,'RN','2400703',1,'2006-11-12 16:55:58'),(3673,NULL,1,15,'ANGICOS',NULL,7131,59515000,'RN','2400802',1,'2006-11-12 16:55:58'),(3674,NULL,1,15,'ANTNIO MARTINS',NULL,7132,59870000,'RN','2400901',1,'2006-11-12 16:55:58'),(3675,NULL,1,15,'APODI',NULL,7133,59700000,'RN','2401008',1,'2006-11-12 16:55:58'),(3676,NULL,1,15,'AREIA BRANCA',NULL,7134,59655000,'RN','2401107',1,'2006-11-12 16:55:58'),(3677,NULL,1,15,'AREZ',NULL,7135,59170000,'RN',NULL,1,'2006-11-12 16:55:58'),(3678,NULL,1,15,'BAA FORMOSA',NULL,7136,59194000,'RN','2401404',1,'2006-11-12 16:55:58'),(3679,NULL,1,15,'BARANA',NULL,7138,59695000,'RN','2401453',1,'2006-11-12 16:55:58'),(3680,NULL,1,15,'BARCELONA',NULL,7139,59410000,'RN','2401503',1,'2006-11-12 16:55:58'),(3681,NULL,1,15,'BENTO FERNANDES',NULL,7141,59555000,'RN','2401602',1,'2006-11-12 16:55:58'),(3682,NULL,1,15,'BOA SADE',NULL,7142,59260000,'RN',NULL,1,'2006-11-12 16:55:58'),(3683,NULL,1,15,'BOD',NULL,7143,59528000,'RN','2401651',1,'2006-11-12 16:55:58'),(3684,NULL,1,15,'BOM JESUS',NULL,7144,59270000,'RN','2401701',1,'2006-11-12 16:55:58'),(3685,NULL,1,15,'BREJINHO',NULL,7145,59219000,'RN','2401800',1,'2006-11-12 16:55:59'),(3686,NULL,1,15,'CAIARA DO NORTE',NULL,7146,59592000,'RN','2401859',1,'2006-11-12 16:55:59'),(3687,NULL,1,15,'CAIARA DO RIO DO VENTO',NULL,7147,59540000,'RN','2401909',1,'2006-11-12 16:55:59'),(3688,NULL,1,15,'CAIC',NULL,7148,59300000,'RN','2402006',1,'2006-11-12 16:55:59'),(3689,NULL,1,15,'CAMPO GRANDE',NULL,7149,59680000,'RN',NULL,1,'2006-11-12 16:55:59'),(3690,NULL,1,15,'CAMPO REDONDO',NULL,7150,59230000,'RN','2402105',1,'2006-11-12 16:55:59'),(3691,NULL,1,15,'CANGUARETAMA',NULL,7151,59190000,'RN','2402204',1,'2006-11-12 16:55:59'),(3692,NULL,1,15,'CARABAS',NULL,7152,59780000,'RN','2402303',1,'2006-11-12 16:55:59'),(3693,NULL,1,15,'CARNABA DOS DANTAS',NULL,7153,59374000,'RN','2402402',1,'2006-11-12 16:55:59'),(3694,NULL,1,15,'CARNAUBAIS',NULL,7154,59665000,'RN','2402501',1,'2006-11-12 16:55:59'),(3695,NULL,1,15,'CEAR-MIRIM',NULL,7155,59570000,'RN','2402600',1,'2006-11-12 16:55:59'),(3696,NULL,1,15,'CERRO COR',NULL,7156,59395000,'RN','2402709',1,'2006-11-12 16:55:59'),(3697,NULL,1,15,'CORONEL EZEQUIEL',NULL,7157,59220000,'RN','2402808',1,'2006-11-12 16:55:59'),(3698,NULL,1,15,'CORONEL JOO PESSOA',NULL,7158,59930000,'RN','2402907',1,'2006-11-12 16:55:59'),(3699,NULL,1,15,'CRUZETA',NULL,7160,59375000,'RN','2403004',1,'2006-11-12 16:55:59'),(3700,NULL,1,15,'CURRAIS NOVOS',NULL,7161,59380000,'RN','2403103',1,'2006-11-12 16:55:59'),(3701,NULL,1,15,'DOUTOR SEVERIANO',NULL,7162,59910000,'RN','2403202',1,'2006-11-12 16:55:59'),(3702,NULL,1,15,'ENCANTO',NULL,7163,59905000,'RN','2403301',1,'2006-11-12 16:55:59'),(3703,NULL,1,15,'EQUADOR',NULL,7164,59355000,'RN','2403400',1,'2006-11-12 16:55:59'),(3704,NULL,1,15,'ESPRITO SANTO',NULL,7165,59180000,'RN','2403509',1,'2006-11-12 16:55:59'),(3705,NULL,1,15,'ESPRITO SANTO DO OESTE',NULL,7166,59660000,'RN',NULL,1,'2006-11-12 16:55:59'),(3706,NULL,1,15,'EXTREMOZ',NULL,7167,59575000,'RN','2403608',1,'2006-11-12 16:55:59'),(3707,NULL,1,15,'FELIPE GUERRA',NULL,7168,59795000,'RN','2403707',1,'2006-11-12 16:56:00'),(3708,NULL,1,15,'FERNANDO PEDROZA',NULL,7169,59517000,'RN','2403756',1,'2006-11-12 16:56:00'),(3709,NULL,1,15,'FLORNIA',NULL,7171,59335000,'RN','2403806',1,'2006-11-12 16:56:00'),(3710,NULL,1,15,'FRANCISCO DANTAS',NULL,7172,59902000,'RN','2403905',1,'2006-11-12 16:56:00'),(3711,NULL,1,15,'FRUTUOSO GOMES',NULL,7173,59890000,'RN','2404002',1,'2006-11-12 16:56:00'),(3712,NULL,1,15,'GALINHOS',NULL,7174,59596000,'RN','2404101',1,'2006-11-12 16:56:00'),(3713,NULL,1,15,'GOIANINHA',NULL,7176,59173000,'RN','2404200',1,'2006-11-12 16:56:00'),(3714,NULL,1,15,'GOVERNADOR DIX-SEPT ROSADO',NULL,7177,59790000,'RN','2404309',1,'2006-11-12 16:56:00'),(3715,NULL,1,15,'GROSSOS',NULL,7178,59675000,'RN','2404408',1,'2006-11-12 16:56:00'),(3716,NULL,1,15,'GUAMAR',NULL,7179,59598000,'RN','2404507',1,'2006-11-12 16:56:00'),(3717,NULL,1,15,'IELMO MARINHO',NULL,7180,59490000,'RN','2404606',1,'2006-11-12 16:56:00'),(3718,NULL,1,15,'IPANGUAU',NULL,7182,59508000,'RN','2404705',1,'2006-11-12 16:56:00'),(3719,NULL,1,15,'IPUEIRA',NULL,7184,59315000,'RN','2404804',1,'2006-11-12 16:56:00'),(3720,NULL,1,15,'ITAJ',NULL,7185,59513000,'RN','2404853',1,'2006-11-12 16:56:00'),(3721,NULL,1,15,'ITA',NULL,7186,59855000,'RN','2404903',1,'2006-11-12 16:56:00'),(3722,NULL,1,15,'JAAN',NULL,7187,59225000,'RN','2405009',1,'2006-11-12 16:56:00'),(3723,NULL,1,15,'JANDARA',NULL,7188,59594000,'RN','2405108',1,'2006-11-12 16:56:00'),(3724,NULL,1,15,'JANDUS',NULL,7189,59690000,'RN','2405207',1,'2006-11-12 16:56:00'),(3725,NULL,1,15,'JAPI',NULL,7190,59213000,'RN','2405405',1,'2006-11-12 16:56:00'),(3726,NULL,1,15,'JARDIM DE ANGICOS',NULL,7191,59544000,'RN','2405504',1,'2006-11-12 16:56:00'),(3727,NULL,1,15,'JARDIM DE PIRANHAS',NULL,7192,59324000,'RN','2405603',1,'2006-11-12 16:56:00'),(3728,NULL,1,15,'JARDIM DO SERID',NULL,7193,59343000,'RN','2405702',1,'2006-11-12 16:56:00'),(3729,NULL,1,15,'JOO CMARA',NULL,7194,59550000,'RN','2405801',1,'2006-11-12 16:56:00'),(3730,NULL,1,15,'JOO DIAS',NULL,7195,59880000,'RN','2405900',1,'2006-11-12 16:56:00'),(3731,NULL,1,15,'JOS DA PENHA',NULL,7196,59980000,'RN','2406007',1,'2006-11-12 16:56:01'),(3732,NULL,1,15,'JUCURUTU',NULL,7197,59330000,'RN','2406106',1,'2006-11-12 16:56:01'),(3733,NULL,1,15,'JUNDI',NULL,7198,59188000,'RN','2406155',1,'2006-11-12 16:56:01'),(3734,NULL,1,15,'LAGOA D\'ANTA',NULL,7199,59227000,'RN',NULL,1,'2006-11-12 16:56:01'),(3735,NULL,1,15,'LAGOA DE PEDRAS',NULL,7200,59244000,'RN','2406304',1,'2006-11-12 16:56:01'),(3736,NULL,1,15,'LAGOA DE VELHOS',NULL,7201,59430000,'RN','2406403',1,'2006-11-12 16:56:01'),(3737,NULL,1,15,'LAGOA NOVA',NULL,7202,59390000,'RN','2406502',1,'2006-11-12 16:56:01'),(3738,NULL,1,15,'LAGOA SALGADA',NULL,7203,59247000,'RN','2406601',1,'2006-11-12 16:56:01'),(3739,NULL,1,15,'LAJES',NULL,7204,59535000,'RN','2406700',1,'2006-11-12 16:56:01'),(3740,NULL,1,15,'LAJES PINTADAS',NULL,7205,59235000,'RN','2406809',1,'2006-11-12 16:56:01'),(3741,NULL,1,15,'LUCRCIA',NULL,7206,59805000,'RN','2406908',1,'2006-11-12 16:56:01'),(3742,NULL,1,15,'LUS GOMES',NULL,7207,59940000,'RN','2407005',1,'2006-11-12 16:56:01'),(3743,NULL,1,15,'MACABA',NULL,7208,59280000,'RN','2407104',1,'2006-11-12 16:56:01'),(3744,NULL,1,15,'MACAU',NULL,7209,59500000,'RN','2407203',1,'2006-11-12 16:56:01'),(3745,NULL,1,15,'MAJOR SALES',NULL,7211,59945000,'RN','2407252',1,'2006-11-12 16:56:01'),(3746,NULL,1,15,'MARCELINO VIEIRA',NULL,7212,59970000,'RN','2407302',1,'2006-11-12 16:56:01'),(3747,NULL,1,15,'MARTINS',NULL,7213,59800000,'RN','2407401',1,'2006-11-12 16:56:01'),(3748,NULL,1,15,'MAXARANGUAPE',NULL,7215,59580000,'RN','2407500',1,'2006-11-12 16:56:01'),(3749,NULL,1,15,'MESSIAS TARGINO',NULL,7216,59775000,'RN','2407609',1,'2006-11-12 16:56:01'),(3750,NULL,1,15,'MONTANHAS',NULL,7217,59198000,'RN','2407708',1,'2006-11-12 16:56:01'),(3751,NULL,1,15,'MONTE ALEGRE',NULL,7218,59182000,'RN','2407807',1,'2006-11-12 16:56:01'),(3752,NULL,1,15,'MONTE DAS GAMELEIRAS',NULL,7219,59217000,'RN','2407906',1,'2006-11-12 16:56:01'),(3753,NULL,1,15,'MOSSOR',NULL,7220,NULL,'RN','2408003',1,'2006-11-12 16:56:01'),(3754,NULL,1,15,'NATAL',NULL,7221,NULL,'RN','2408102',1,'2006-11-12 16:56:02'),(3755,NULL,1,15,'NSIA FLORESTA',NULL,7222,59164000,'RN','2408201',1,'2006-11-12 16:56:02'),(3756,NULL,1,15,'NOVA CRUZ',NULL,7223,59215000,'RN','2408300',1,'2006-11-12 16:56:02'),(3757,NULL,1,15,'OLHO-D\'GUA DO BORGES',NULL,7224,59730000,'RN',NULL,1,'2006-11-12 16:56:02'),(3758,NULL,1,15,'OURO BRANCO',NULL,7225,59347000,'RN','2408508',1,'2006-11-12 16:56:02'),(3759,NULL,1,15,'PARAN',NULL,7226,59950000,'RN','2408607',1,'2006-11-12 16:56:02'),(3760,NULL,1,15,'PARAZINHO',NULL,7227,59586000,'RN','2408805',1,'2006-11-12 16:56:02'),(3761,NULL,1,15,'PARELHAS',NULL,7228,59360000,'RN','2408904',1,'2006-11-12 16:56:02'),(3762,NULL,1,15,'PARNAMIRIM',NULL,7229,59150000,'RN','2403251',1,'2006-11-12 16:56:02'),(3763,NULL,1,15,'PASSA E FICA',NULL,7230,59218000,'RN','2409100',1,'2006-11-12 16:56:02'),(3764,NULL,1,15,'PASSAGEM',NULL,7231,59259000,'RN','2409209',1,'2006-11-12 16:56:02'),(3765,NULL,1,15,'PATU',NULL,7232,59770000,'RN','2409308',1,'2006-11-12 16:56:02'),(3766,NULL,1,15,'PAU DOS FERROS',NULL,7233,59900000,'RN','2409407',1,'2006-11-12 16:56:02'),(3767,NULL,1,15,'PEDRA GRANDE',NULL,7234,59588000,'RN','2409506',1,'2006-11-12 16:56:02'),(3768,NULL,1,15,'PEDRA PRETA',NULL,7235,59547000,'RN','2409605',1,'2006-11-12 16:56:02'),(3769,NULL,1,15,'PEDRO AVELINO',NULL,7236,59530000,'RN','2409704',1,'2006-11-12 16:56:02'),(3770,NULL,1,15,'PEDRO VELHO',NULL,7237,59196000,'RN','2409803',1,'2006-11-12 16:56:02'),(3771,NULL,1,15,'PENDNCIAS',NULL,7238,59504000,'RN','2409902',1,'2006-11-12 16:56:02'),(3772,NULL,1,15,'PILES',NULL,7239,59960000,'RN','2410009',1,'2006-11-12 16:56:02'),(3773,NULL,1,15,'POO BRANCO',NULL,7240,59560000,'RN','2410108',1,'2006-11-12 16:56:02'),(3774,NULL,1,15,'PORTALEGRE',NULL,7241,59810000,'RN','2410207',1,'2006-11-12 16:56:02'),(3775,NULL,1,15,'PORTO DO MANGUE',NULL,7242,59668000,'RN','2410256',1,'2006-11-12 16:56:02'),(3776,NULL,1,15,'PUREZA',NULL,7243,59582000,'RN','2410405',1,'2006-11-12 16:56:03'),(3777,NULL,1,15,'RAFAEL FERNANDES',NULL,7244,59990000,'RN','2410504',1,'2006-11-12 16:56:03'),(3778,NULL,1,15,'RAFAEL GODEIRO',NULL,7245,59740000,'RN','2410603',1,'2006-11-12 16:56:03'),(3779,NULL,1,15,'RIACHO DA CRUZ',NULL,7246,59820000,'RN','2410702',1,'2006-11-12 16:56:03'),(3780,NULL,1,15,'RIACHO DE SANTANA',NULL,7247,59987000,'RN','2410801',1,'2006-11-12 16:56:03'),(3781,NULL,1,15,'RIACHUELO',NULL,7248,59470000,'RN','2410900',1,'2006-11-12 16:56:03'),(3782,NULL,1,15,'RIO DO FOGO',NULL,7249,59578000,'RN','2408953',1,'2006-11-12 16:56:03'),(3783,NULL,1,15,'RODOLFO FERNANDES',NULL,7250,59830000,'RN','2411007',1,'2006-11-12 16:56:03'),(3784,NULL,1,15,'RUY BARBOSA',NULL,7252,59420000,'RN','2411106',1,'2006-11-12 16:56:03'),(3785,NULL,1,15,'SANTA CRUZ',NULL,7254,59200000,'RN','2411205',1,'2006-11-12 16:56:03'),(3786,NULL,1,15,'SANTA MARIA',NULL,7256,59464000,'RN','2409332',1,'2006-11-12 16:56:03'),(3787,NULL,1,15,'SANTANA DO MATOS',NULL,7258,59520000,'RN','2411403',1,'2006-11-12 16:56:03'),(3788,NULL,1,15,'SANTANA DO SERID',NULL,7259,59350000,'RN','2411429',1,'2006-11-12 16:56:03'),(3789,NULL,1,15,'SANTO ANTNIO',NULL,7260,59255000,'RN','2411502',1,'2006-11-12 16:56:03'),(3790,NULL,1,15,'SO BENTO DO NORTE',NULL,7262,59590000,'RN','2411601',1,'2006-11-12 16:56:03'),(3791,NULL,1,15,'SO BENTO DO TRAIRI',NULL,7263,59210000,'RN','2411700',1,'2006-11-12 16:56:03'),(3792,NULL,1,15,'SO FERNANDO',NULL,7265,59327000,'RN','2411809',1,'2006-11-12 16:56:03'),(3793,NULL,1,15,'SO FRANCISCO DO OESTE',NULL,7266,59908000,'RN','2411908',1,'2006-11-12 16:56:03'),(3794,NULL,1,15,'SO GONALO DO AMARANTE',NULL,7268,59290000,'RN','2412005',1,'2006-11-12 16:56:03'),(3795,NULL,1,15,'SO JOO DO SABUGI',NULL,7269,59310000,'RN','2412104',1,'2006-11-12 16:56:03'),(3796,NULL,1,15,'SO JOS DE MIPIBU',NULL,7271,59162000,'RN','2412203',1,'2006-11-12 16:56:03'),(3797,NULL,1,15,'SO JOS DO CAMPESTRE',NULL,7272,59275000,'RN','2412302',1,'2006-11-12 16:56:03'),(3798,NULL,1,15,'SO JOS DO SERID',NULL,7273,59378000,'RN','2412401',1,'2006-11-12 16:56:04'),(3799,NULL,1,15,'SO MIGUEL',NULL,7274,59920000,'RN','2412500',1,'2006-11-12 16:56:04'),(3800,NULL,1,15,'SO MIGUEL DE TOUROS',NULL,7275,59585000,'RN',NULL,1,'2006-11-12 16:56:04'),(3801,NULL,1,15,'SO PAULO DO POTENGI',NULL,7276,59460000,'RN','2412609',1,'2006-11-12 16:56:04'),(3802,NULL,1,15,'SO PEDRO',NULL,7277,59480000,'RN','2412708',1,'2006-11-12 16:56:04'),(3803,NULL,1,15,'SO RAFAEL',NULL,7278,59518000,'RN','2412807',1,'2006-11-12 16:56:04'),(3804,NULL,1,15,'SO TOM',NULL,7279,59400000,'RN','2412906',1,'2006-11-12 16:56:04'),(3805,NULL,1,15,'SO VICENTE',NULL,7280,59340000,'RN','2413003',1,'2006-11-12 16:56:04'),(3806,NULL,1,15,'SENADOR ELI DE SOUZA',NULL,7281,59250000,'RN','2413102',1,'2006-11-12 16:56:04'),(3807,NULL,1,15,'SENADOR GEORGINO AVELINO',NULL,7282,59168000,'RN','2413201',1,'2006-11-12 16:56:04'),(3808,NULL,1,15,'SERRA CAIADA',NULL,7283,59245000,'RN',NULL,1,'2006-11-12 16:56:04'),(3809,NULL,1,15,'SERRA DE SO BENTO',NULL,7285,59214000,'RN','2413300',1,'2006-11-12 16:56:04'),(3810,NULL,1,15,'SERRA DO MEL',NULL,7286,59663000,'RN','2413359',1,'2006-11-12 16:56:04'),(3811,NULL,1,15,'SERRA NEGRA DO NORTE',NULL,7287,59318000,'RN','2413409',1,'2006-11-12 16:56:04'),(3812,NULL,1,15,'SERRINHA',NULL,7288,59258000,'RN','2413508',1,'2006-11-12 16:56:04'),(3813,NULL,1,15,'SERRINHA DOS PINTOS',NULL,7289,59808000,'RN','2413557',1,'2006-11-12 16:56:04'),(3814,NULL,1,15,'SEVERIANO MELO',NULL,7290,59856000,'RN','2413607',1,'2006-11-12 16:56:04'),(3815,NULL,1,15,'STIO NOVO',NULL,7291,59440000,'RN','2413706',1,'2006-11-12 16:56:04'),(3816,NULL,1,15,'TABOLEIRO GRANDE',NULL,7292,59840000,'RN','2413805',1,'2006-11-12 16:56:04'),(3817,NULL,1,15,'TAIPU',NULL,7293,59565000,'RN','2413904',1,'2006-11-12 16:56:04'),(3818,NULL,1,15,'TANGAR',NULL,7294,59240000,'RN','2414001',1,'2006-11-12 16:56:04'),(3819,NULL,1,15,'TENENTE ANANIAS',NULL,7295,59955000,'RN','2414100',1,'2006-11-12 16:56:04'),(3820,NULL,1,15,'TENENTE LAURENTINO CRUZ',NULL,7296,59338000,'RN','2414159',1,'2006-11-12 16:56:05'),(3821,NULL,1,15,'TIBAU',NULL,7297,59678000,'RN','2411056',1,'2006-11-12 16:56:05'),(3822,NULL,1,15,'TIBAU DO SUL',NULL,7298,59178000,'RN','2414209',1,'2006-11-12 16:56:05'),(3823,NULL,1,15,'TIMBABA DOS BATISTAS',NULL,7299,59320000,'RN','2414308',1,'2006-11-12 16:56:05'),(3824,NULL,1,15,'TOUROS',NULL,7300,59584000,'RN','2414407',1,'2006-11-12 16:56:05'),(3825,NULL,1,15,'TRIUNFO POTIGUAR',NULL,7302,59685000,'RN','2414456',1,'2006-11-12 16:56:05'),(3826,NULL,1,15,'UMARIZAL',NULL,7303,59865000,'RN','2414506',1,'2006-11-12 16:56:05'),(3827,NULL,1,15,'UPANEMA',NULL,7304,59670000,'RN','2414605',1,'2006-11-12 16:56:05'),(3828,NULL,1,15,'VRZEA',NULL,7305,59185000,'RN','2414704',1,'2006-11-12 16:56:05'),(3829,NULL,1,15,'VENHA-VER',NULL,7306,59925000,'RN','2414753',1,'2006-11-12 16:56:05'),(3830,NULL,1,15,'VERA CRUZ',NULL,7307,59184000,'RN','2414803',1,'2006-11-12 16:56:05'),(3831,NULL,1,15,'VIOSA',NULL,7308,59815000,'RN','2414902',1,'2006-11-12 16:56:05'),(3832,NULL,1,15,'VILA FLOR',NULL,7309,59192000,'RN','2415008',1,'2006-11-12 16:56:05'),(3833,NULL,1,1,'ALTA ALEGRE DOS PARECIS',NULL,7311,78994800,'RO',NULL,1,'2006-11-12 16:56:05'),(3834,NULL,1,1,'ALTA FLORESTA DO OESTE',NULL,7312,78994000,'RO',NULL,1,'2006-11-12 16:56:05'),(3835,NULL,1,1,'ALTO PARASO',NULL,7313,78956000,'RO','1100403',1,'2006-11-12 16:56:05'),(3836,NULL,1,1,'ALVORADA DO OESTE',NULL,7314,78969000,'RO',NULL,1,'2006-11-12 16:56:05'),(3837,NULL,1,1,'ARIQUEMES',NULL,7315,NULL,'RO','1100023',1,'2006-11-12 16:56:05'),(3838,NULL,1,1,'BURITIS',NULL,7316,78967800,'RO','1100452',1,'2006-11-12 16:56:05'),(3839,NULL,1,1,'CABIXI',NULL,7317,78999000,'RO','1100031',1,'2006-11-12 16:56:06'),(3840,NULL,1,1,'CACAULNDIA',NULL,7318,78944000,'RO','1100601',1,'2006-11-12 16:56:06'),(3841,NULL,1,1,'CACOAL',NULL,7319,NULL,'RO','1100049',1,'2006-11-12 16:56:06'),(3842,NULL,1,1,'CAMPO NOVO DE RONDNIA',NULL,7321,78967000,'RO','1100700',1,'2006-11-12 16:56:06'),(3843,NULL,1,1,'CANDEIAS DO JAMARI',NULL,7322,78938000,'RO','1100809',1,'2006-11-12 16:56:06'),(3844,NULL,1,1,'CASTANHEIRAS',NULL,7323,78992000,'RO','1100908',1,'2006-11-12 16:56:06'),(3845,NULL,1,1,'CEREJEIRAS',NULL,7324,78997000,'RO','1100056',1,'2006-11-12 16:56:06'),(3846,NULL,1,1,'CHUPINGUAIA',NULL,7325,78995800,'RO','1100924',1,'2006-11-12 16:56:06'),(3847,NULL,1,1,'COLORADO DO OESTE',NULL,7326,78996000,'RO','1100064',1,'2006-11-12 16:56:06'),(3848,NULL,1,1,'CORUMBIARA',NULL,7327,78966000,'RO','1100072',1,'2006-11-12 16:56:06'),(3849,NULL,1,1,'COSTA MARQUES',NULL,7328,78971000,'RO','1100080',1,'2006-11-12 16:56:06'),(3850,NULL,1,1,'CUJUBIM',NULL,7329,78945800,'RO','1100940',1,'2006-11-12 16:56:06'),(3851,NULL,1,1,'ESPIGO D\'OESTE',NULL,7330,78983000,'RO',NULL,1,'2006-11-12 16:56:06'),(3852,NULL,1,1,'GOVERNADOR JORGE TEIXEIRA',NULL,7331,78946000,'RO','1101005',1,'2006-11-12 16:56:06'),(3853,NULL,1,1,'GUAJAR MIRIM',NULL,7332,78957000,'RO',NULL,1,'2006-11-12 16:56:06'),(3854,NULL,1,1,'ITAPU DO OESTE',NULL,7334,78937000,'RO','1101104',1,'2006-11-12 16:56:06'),(3855,NULL,1,1,'JARU',NULL,7335,78940000,'RO','1100114',1,'2006-11-12 16:56:06'),(3856,NULL,1,1,'JI-PARAN',NULL,7336,NULL,'RO','1100122',1,'2006-11-12 16:56:06'),(3857,NULL,1,1,'MACHADINHO D\'OESTE',NULL,7337,78948000,'RO',NULL,1,'2006-11-12 16:56:06'),(3858,NULL,1,1,'MINISTRO ANDREAZZA',NULL,7339,78981000,'RO','1101203',1,'2006-11-12 16:56:06'),(3859,NULL,1,1,'MIRANTE DA SERRA',NULL,7340,78949000,'RO','1101302',1,'2006-11-12 16:56:06'),(3860,NULL,1,1,'MONTE NEGRO',NULL,7341,78965000,'RO','1101401',1,'2006-11-12 16:56:06'),(3861,NULL,1,1,'NOVA BRASILNDIA D\'OESTE',NULL,7342,78974000,'RO',NULL,1,'2006-11-12 16:56:07'),(3862,NULL,1,1,'NOVA MAMOR',NULL,7343,78939000,'RO','1100338',1,'2006-11-12 16:56:07'),(3863,NULL,1,1,'NOVA UNIO',NULL,7344,78953000,'RO','1101435',1,'2006-11-12 16:56:07'),(3864,NULL,1,1,'NOVO HORIZONTE DO OESTE',NULL,7346,78991000,'RO','1100502',1,'2006-11-12 16:56:07'),(3865,NULL,1,1,'OURO PRETO DO OESTE',NULL,7347,78950000,'RO','1100155',1,'2006-11-12 16:56:07'),(3866,NULL,1,1,'PARECIS',NULL,7348,78989000,'RO','1101450',1,'2006-11-12 16:56:07'),(3867,NULL,1,1,'PIMENTA BUENO',NULL,7350,78984000,'RO','1100189',1,'2006-11-12 16:56:07'),(3868,NULL,1,1,'PIMENTEIRAS DO OESTE',NULL,7351,78998000,'RO','1101468',1,'2006-11-12 16:56:07'),(3869,NULL,1,1,'PORTO VELHO',NULL,7352,NULL,'RO','1100205',1,'2006-11-12 16:56:07'),(3870,NULL,1,1,'PRESIDENTE MDICI',NULL,7353,78968000,'RO','1100254',1,'2006-11-12 16:56:07'),(3871,NULL,1,1,'PRIMAVERA DE RONDNIA',NULL,7354,78988000,'RO','1101476',1,'2006-11-12 16:56:07'),(3872,NULL,1,1,'RIO CRESPO',NULL,7356,78945000,'RO','1100262',1,'2006-11-12 16:56:07'),(3873,NULL,1,1,'ROLIM DE MOURA',NULL,7358,78987000,'RO','1100288',1,'2006-11-12 16:56:07'),(3874,NULL,1,1,'SANTA LUZIA DO OESTE',NULL,7359,78993000,'RO',NULL,1,'2006-11-12 16:56:07'),(3875,NULL,1,1,'SO FELIPE D\'OESTE',NULL,7360,78986000,'RO',NULL,1,'2006-11-12 16:56:07'),(3876,NULL,1,1,'SO FRANCISCO DO GUAPOR',NULL,7361,78973000,'RO','1101492',1,'2006-11-12 16:56:07'),(3877,NULL,1,1,'SO MIGUEL DO GUAPOR',NULL,7362,78970000,'RO','1100320',1,'2006-11-12 16:56:07'),(3878,NULL,1,1,'SERINGUEIRAS',NULL,7363,78990000,'RO','1101500',1,'2006-11-12 16:56:07'),(3879,NULL,1,1,'TEIXEIRPOLIS',NULL,7365,78954000,'RO','1101559',1,'2006-11-12 16:56:07'),(3880,NULL,1,1,'THEOBROMA',NULL,7366,78947000,'RO','1101609',1,'2006-11-12 16:56:07'),(3881,NULL,1,1,'URUP',NULL,7367,78955000,'RO','1101708',1,'2006-11-12 16:56:07'),(3882,NULL,1,1,'VALE DO ANARI',NULL,7368,78948800,'RO','1101757',1,'2006-11-12 16:56:07'),(3883,NULL,1,1,'VALE DO PARASO',NULL,7369,78959000,'RO','1101807',1,'2006-11-12 16:56:07'),(3884,NULL,1,1,'VILHENA',NULL,7371,78995000,'RO','1100304',1,'2006-11-12 16:56:08'),(3885,NULL,1,1,'ALTO ALEGRE',NULL,7373,69350000,'RR',NULL,1,'2006-11-12 16:56:08'),(3886,NULL,1,1,'AMAJAR',NULL,7374,69343000,'RR',NULL,1,'2006-11-12 16:56:08'),(3887,NULL,1,1,'BOA VISTA',NULL,7375,NULL,'RR',NULL,1,'2006-11-12 16:56:08'),(3888,NULL,1,1,'BONFIM',NULL,7376,69380000,'RR',NULL,1,'2006-11-12 16:56:08'),(3889,NULL,1,1,'CANT',NULL,7377,69390000,'RR',NULL,1,'2006-11-12 16:56:08'),(3890,NULL,1,1,'CARACARA',NULL,7378,69360000,'RR',NULL,1,'2006-11-12 16:56:08'),(3891,NULL,1,1,'CAROEBE',NULL,7379,69378000,'RR',NULL,1,'2006-11-12 16:56:08'),(3892,NULL,1,1,'IRACEMA',NULL,7380,69348000,'RR',NULL,1,'2006-11-12 16:56:08'),(3893,NULL,1,1,'MUCAJA',NULL,7381,69340000,'RR',NULL,1,'2006-11-12 16:56:08'),(3894,NULL,1,1,'NORMANDIA',NULL,7382,69355000,'RR',NULL,1,'2006-11-12 16:56:08'),(3895,NULL,1,1,'PACARAIMA',NULL,7383,69345000,'RR',NULL,1,'2006-11-12 16:56:08'),(3896,NULL,1,1,'RORAINPOLIS',NULL,7384,69373000,'RR',NULL,1,'2006-11-12 16:56:08'),(3897,NULL,1,1,'SO JOO DA BALIZA',NULL,7385,69375000,'RR',NULL,1,'2006-11-12 16:56:08'),(3898,NULL,1,1,'SO LUIZ',NULL,7386,69370000,'RR',NULL,1,'2006-11-12 16:56:08'),(3899,NULL,1,1,'UIRAMUT',NULL,7387,69358000,'RR',NULL,1,'2006-11-12 16:56:08'),(3900,NULL,1,26,'ACEGU',NULL,7388,96445000,'RS','4300034',1,'2006-11-12 16:56:08'),(3901,NULL,1,26,'GUA SANTA',NULL,7390,99965000,'RS','4300059',1,'2006-11-12 16:56:08'),(3902,NULL,1,26,'AGUDO',NULL,7392,96540000,'RS','4300109',1,'2006-11-12 16:56:08'),(3903,NULL,1,26,'AJURICABA',NULL,7393,98750000,'RS','4300208',1,'2006-11-12 16:56:08'),(3904,NULL,1,26,'ALECRIM',NULL,7395,98950000,'RS','4300307',1,'2006-11-12 16:56:08'),(3905,NULL,1,26,'ALEGRETE',NULL,7396,NULL,'RS','4300406',1,'2006-11-12 16:56:08'),(3906,NULL,1,26,'ALEGRIA',NULL,7397,98905000,'RS','4300455',1,'2006-11-12 16:56:08'),(3907,NULL,1,26,'ALMIRANTE TAMANDAR DO SUL',NULL,7399,99523000,'RS','4300471',1,'2006-11-12 16:56:09'),(3908,NULL,1,26,'ALPESTRE',NULL,7400,98480000,'RS','4300505',1,'2006-11-12 16:56:09'),(3909,NULL,1,26,'ALTO ALEGRE',NULL,7401,99430000,'RS','4300554',1,'2006-11-12 16:56:09'),(3910,NULL,1,26,'ALTO FELIZ',NULL,7404,95773000,'RS','4300570',1,'2006-11-12 16:56:09'),(3911,NULL,1,26,'ALVORADA',NULL,7408,NULL,'RS','4300604',1,'2006-11-12 16:56:09'),(3912,NULL,1,26,'AMARAL FERRADOR',NULL,7409,96635000,'RS','4300638',1,'2006-11-12 16:56:09'),(3913,NULL,1,26,'AMETISTA DO SUL',NULL,7410,98465000,'RS','4300646',1,'2006-11-12 16:56:09'),(3914,NULL,1,26,'ANDR DA ROCHA',NULL,7411,95310000,'RS','4300661',1,'2006-11-12 16:56:09'),(3915,NULL,1,26,'ANTA GORDA',NULL,7412,95980000,'RS','4300703',1,'2006-11-12 16:56:09'),(3916,NULL,1,26,'ANTNIO PRADO',NULL,7414,95250000,'RS','4300802',1,'2006-11-12 16:56:09'),(3917,NULL,1,26,'ARAMBAR',NULL,7415,96178000,'RS','4300851',1,'2006-11-12 16:56:09'),(3918,NULL,1,26,'ARARIC',NULL,7416,93880000,'RS','4300877',1,'2006-11-12 16:56:09'),(3919,NULL,1,26,'ARATIBA',NULL,7417,99770000,'RS','4300901',1,'2006-11-12 16:56:09'),(3920,NULL,1,26,'ARROIO DO MEIO',NULL,7421,95940000,'RS','4301008',1,'2006-11-12 16:56:09'),(3921,NULL,1,26,'ARROIO DO PADRE',NULL,7422,96155000,'RS','4301073',1,'2006-11-12 16:56:09'),(3922,NULL,1,26,'ARROIO DO SAL',NULL,7423,95585000,'RS','4301057',1,'2006-11-12 16:56:09'),(3923,NULL,1,26,'ARROIO DO TIGRE',NULL,7425,96950000,'RS','4301206',1,'2006-11-12 16:56:09'),(3924,NULL,1,26,'ARROIO DOS RATOS',NULL,7426,96740000,'RS','4301107',1,'2006-11-12 16:56:09'),(3925,NULL,1,26,'ARROIO GRANDE',NULL,7427,96330000,'RS','4301305',1,'2006-11-12 16:56:09'),(3926,NULL,1,26,'ARVOREZINHA',NULL,7431,95995000,'RS','4301404',1,'2006-11-12 16:56:09'),(3927,NULL,1,26,'AUGUSTO PESTANA',NULL,7434,98740000,'RS','4301503',1,'2006-11-12 16:56:09'),(3928,NULL,1,26,'UREA',NULL,7435,99835000,'RS','4301552',1,'2006-11-12 16:56:09'),(3929,NULL,1,26,'BAG',NULL,7439,NULL,'RS','4301602',1,'2006-11-12 16:56:09'),(3930,NULL,1,26,'BALNERIO PINHAL',NULL,7441,95599000,'RS','4301636',1,'2006-11-12 16:56:10'),(3931,NULL,1,26,'BARO',NULL,7443,95730000,'RS','4301651',1,'2006-11-12 16:56:10'),(3932,NULL,1,26,'BARO DE COTEGIPE',NULL,7444,99740000,'RS','4301701',1,'2006-11-12 16:56:10'),(3933,NULL,1,26,'BARO DO TRIUNFO',NULL,7445,96735000,'RS','4301750',1,'2006-11-12 16:56:10'),(3934,NULL,1,26,'BARRA DO GUARITA',NULL,7446,98530000,'RS','4301859',1,'2006-11-12 16:56:10'),(3935,NULL,1,26,'BARRA DO QUARA',NULL,7448,97538000,'RS','4301875',1,'2006-11-12 16:56:10'),(3936,NULL,1,26,'BARRA DO RIBEIRO',NULL,7449,96790000,'RS','4301909',1,'2006-11-12 16:56:10'),(3937,NULL,1,26,'BARRA DO RIO AZUL',NULL,7450,99795000,'RS','4301925',1,'2006-11-12 16:56:10'),(3938,NULL,1,26,'BARRA FUNDA',NULL,7451,99585000,'RS','4301958',1,'2006-11-12 16:56:10'),(3939,NULL,1,26,'BARRACO',NULL,7452,95370000,'RS','4301800',1,'2006-11-12 16:56:10'),(3940,NULL,1,26,'BARROS CASSAL',NULL,7458,99360000,'RS','4302006',1,'2006-11-12 16:56:10'),(3941,NULL,1,26,'BENJAMIN CONSTANT DO SUL',NULL,7465,99650000,'RS','4302055',1,'2006-11-12 16:56:10'),(3942,NULL,1,26,'BENTO GONALVES',NULL,7466,95700000,'RS','4302105',1,'2006-11-12 16:56:10'),(3943,NULL,1,26,'BOA VISTA DAS MISSES',NULL,7472,98335000,'RS','4302154',1,'2006-11-12 16:56:10'),(3944,NULL,1,26,'BOA VISTA DO BURIC',NULL,7473,98918000,'RS','4302204',1,'2006-11-12 16:56:10'),(3945,NULL,1,26,'BOA VISTA DO CADEADO',NULL,7474,98118000,'RS','4302220',1,'2006-11-12 16:56:10'),(3946,NULL,1,26,'BOA VISTA DO INCRA',NULL,7475,98120000,'RS','4302238',1,'2006-11-12 16:56:10'),(3947,NULL,1,26,'BOA VISTA DO SUL',NULL,7476,95727000,'RS','4302253',1,'2006-11-12 16:56:10'),(3948,NULL,1,26,'BOM JESUS',NULL,7481,95290000,'RS','4302303',1,'2006-11-12 16:56:10'),(3949,NULL,1,26,'BOM PRINCPIO',NULL,7482,95765000,'RS','4302352',1,'2006-11-12 16:56:10'),(3950,NULL,1,26,'BOM PROGRESSO',NULL,7483,98575000,'RS','4302378',1,'2006-11-12 16:56:10'),(3951,NULL,1,26,'BOM RETIRO DO SUL',NULL,7486,95870000,'RS','4302402',1,'2006-11-12 16:56:10'),(3952,NULL,1,26,'BOQUEIRO DO LEO',NULL,7490,95920000,'RS','4302451',1,'2006-11-12 16:56:10'),(3953,NULL,1,26,'BOSSOROCA',NULL,7492,97850000,'RS','4302501',1,'2006-11-12 16:56:11'),(3954,NULL,1,26,'BRAGA',NULL,7494,98560000,'RS','4302600',1,'2006-11-12 16:56:11'),(3955,NULL,1,26,'BROCHIER',NULL,7495,95790000,'RS','4302659',1,'2006-11-12 16:56:11'),(3956,NULL,1,26,'BUTI',NULL,7497,96750000,'RS','4302709',1,'2006-11-12 16:56:11'),(3957,NULL,1,26,'CAAPAVA DO SUL',NULL,7499,96570000,'RS','4302808',1,'2006-11-12 16:56:11'),(3958,NULL,1,26,'CACEQUI',NULL,7500,97450000,'RS','4302907',1,'2006-11-12 16:56:11'),(3959,NULL,1,26,'CACHOEIRA DO SUL',NULL,7501,NULL,'RS','4303004',1,'2006-11-12 16:56:11'),(3960,NULL,1,26,'CACHOEIRINHA',NULL,7502,NULL,'RS','4303103',1,'2006-11-12 16:56:11'),(3961,NULL,1,26,'CACIQUE DOBLE',NULL,7503,99860000,'RS','4303202',1,'2006-11-12 16:56:11'),(3962,NULL,1,26,'CAIBAT',NULL,7505,97930000,'RS','4303301',1,'2006-11-12 16:56:11'),(3963,NULL,1,26,'CAIARA',NULL,7506,98440000,'RS','4303400',1,'2006-11-12 16:56:11'),(3964,NULL,1,26,'CAMAQU',NULL,7507,96180000,'RS','4303509',1,'2006-11-12 16:56:11'),(3965,NULL,1,26,'CAMARGO',NULL,7508,99165000,'RS','4303558',1,'2006-11-12 16:56:11'),(3966,NULL,1,26,'CAMBAR DO SUL',NULL,7509,95480000,'RS','4303608',1,'2006-11-12 16:56:11'),(3967,NULL,1,26,'CAMPESTRE DA SERRA',NULL,7512,95255000,'RS','4303673',1,'2006-11-12 16:56:11'),(3968,NULL,1,26,'CAMPINA DAS MISSES',NULL,7513,98975000,'RS','4303707',1,'2006-11-12 16:56:11'),(3969,NULL,1,26,'CAMPINAS DO SUL',NULL,7516,99660000,'RS','4303806',1,'2006-11-12 16:56:11'),(3970,NULL,1,26,'CAMPO BOM',NULL,7517,93700000,'RS','4303905',1,'2006-11-12 16:56:11'),(3971,NULL,1,26,'CAMPO NOVO',NULL,7520,98570000,'RS','4304002',1,'2006-11-12 16:56:11'),(3972,NULL,1,26,'CAMPOS BORGES',NULL,7525,99435000,'RS','4304101',1,'2006-11-12 16:56:11'),(3973,NULL,1,26,'CANDELRIA',NULL,7526,96930000,'RS','4304200',1,'2006-11-12 16:56:11'),(3974,NULL,1,26,'CNDIDO GODI',NULL,7528,98970000,'RS','4304309',1,'2006-11-12 16:56:11'),(3975,NULL,1,26,'CANDIOTA',NULL,7529,96495000,'RS','4304358',1,'2006-11-12 16:56:11'),(3976,NULL,1,26,'CANELA',NULL,7530,95680000,'RS','4304408',1,'2006-11-12 16:56:12'),(3977,NULL,1,26,'CANGUU',NULL,7531,96600000,'RS','4304507',1,'2006-11-12 16:56:12'),(3978,NULL,1,26,'CANOAS',NULL,7533,NULL,'RS','4304606',1,'2006-11-12 16:56:12'),(3979,NULL,1,26,'CANUDOS DO VALE',NULL,7534,95933000,'RS','4304614',1,'2006-11-12 16:56:12'),(3980,NULL,1,26,'CAPO BONITO DO SUL',NULL,7536,95308000,'RS','4304622',1,'2006-11-12 16:56:12'),(3981,NULL,1,26,'CAPO DA CANOA',NULL,7539,95555000,'RS','4304630',1,'2006-11-12 16:56:12'),(3982,NULL,1,26,'CAPO DO CIP',NULL,7542,97753000,'RS','4304655',1,'2006-11-12 16:56:12'),(3983,NULL,1,26,'CAPO DO LEO',NULL,7543,96160000,'RS','4304663',1,'2006-11-12 16:56:12'),(3984,NULL,1,26,'CAPELA DE SANTANA',NULL,7544,95745000,'RS','4304689',1,'2006-11-12 16:56:12'),(3985,NULL,1,26,'CAPITO',NULL,7547,95935000,'RS','4304697',1,'2006-11-12 16:56:12'),(3986,NULL,1,26,'CAPIVARI DO SUL',NULL,7548,95552000,'RS','4304671',1,'2006-11-12 16:56:12'),(3987,NULL,1,26,'CARA',NULL,7552,95515000,'RS','4304713',1,'2006-11-12 16:56:12'),(3988,NULL,1,26,'CARAZINHO',NULL,7554,99500000,'RS','4304705',1,'2006-11-12 16:56:12'),(3989,NULL,1,26,'CARLOS BARBOSA',NULL,7555,95185000,'RS','4304804',1,'2006-11-12 16:56:12'),(3990,NULL,1,26,'CARLOS GOMES',NULL,7556,99825000,'RS','4304853',1,'2006-11-12 16:56:12'),(3991,NULL,1,26,'CASCA',NULL,7558,99260000,'RS','4304903',1,'2006-11-12 16:56:12'),(3992,NULL,1,26,'CASEIROS',NULL,7561,95315000,'RS','4304952',1,'2006-11-12 16:56:12'),(3993,NULL,1,26,'CATUPE',NULL,7563,98770000,'RS','4305009',1,'2006-11-12 16:56:12'),(3994,NULL,1,26,'CAXIAS DO SUL',NULL,7566,NULL,'RS','4305108',1,'2006-11-12 16:56:12'),(3995,NULL,1,26,'CENTENRIO',NULL,7569,99838000,'RS','4305116',1,'2006-11-12 16:56:12'),(3996,NULL,1,26,'CERRITO',NULL,7572,96395000,'RS','4305124',1,'2006-11-12 16:56:12'),(3997,NULL,1,26,'CERRO BRANCO',NULL,7576,96535000,'RS','4305132',1,'2006-11-12 16:56:12'),(3998,NULL,1,26,'CERRO GRANDE',NULL,7580,98340000,'RS','4305157',1,'2006-11-12 16:56:12'),(3999,NULL,1,26,'CERRO GRANDE DO SUL',NULL,7581,96770000,'RS','4305173',1,'2006-11-12 16:56:13'),(4000,NULL,1,26,'CERRO LARGO',NULL,7582,97900000,'RS','4305207',1,'2006-11-12 16:56:13'),(4001,NULL,1,26,'CHAPADA',NULL,7583,99530000,'RS','4305306',1,'2006-11-12 16:56:13'),(4002,NULL,1,26,'CHARQUEADAS',NULL,7585,96745000,'RS','4305355',1,'2006-11-12 16:56:13'),(4003,NULL,1,26,'CHARRUA',NULL,7586,99960000,'RS','4305371',1,'2006-11-12 16:56:13'),(4004,NULL,1,26,'CHIAPETA',NULL,7587,98760000,'RS',NULL,1,'2006-11-12 16:56:13'),(4005,NULL,1,26,'CHU',NULL,7591,96255000,'RS','4305439',1,'2006-11-12 16:56:13'),(4006,NULL,1,26,'CHUVISCA',NULL,7592,96193000,'RS','4305447',1,'2006-11-12 16:56:13'),(4007,NULL,1,26,'CIDREIRA',NULL,7593,95595000,'RS','4305454',1,'2006-11-12 16:56:13'),(4008,NULL,1,26,'CIRACO',NULL,7595,99970000,'RS','4305504',1,'2006-11-12 16:56:13'),(4009,NULL,1,26,'COLINAS',NULL,7599,95895000,'RS','4305587',1,'2006-11-12 16:56:13'),(4010,NULL,1,26,'COLORADO',NULL,7607,99460000,'RS','4305603',1,'2006-11-12 16:56:13'),(4011,NULL,1,26,'CONDOR',NULL,7609,98290000,'RS','4305702',1,'2006-11-12 16:56:13'),(4012,NULL,1,26,'CONSTANTINA',NULL,7611,99680000,'RS','4305801',1,'2006-11-12 16:56:13'),(4013,NULL,1,26,'COQUEIRO BAIXO',NULL,7612,95955000,'RS','4305835',1,'2006-11-12 16:56:13'),(4014,NULL,1,26,'COQUEIROS DO SUL',NULL,7613,99528000,'RS','4305850',1,'2006-11-12 16:56:13'),(4015,NULL,1,26,'CORONEL BARROS',NULL,7616,98735000,'RS','4305871',1,'2006-11-12 16:56:13'),(4016,NULL,1,26,'CORONEL BICACO',NULL,7617,98580000,'RS','4305900',1,'2006-11-12 16:56:13'),(4017,NULL,1,26,'CORONEL PILAR',NULL,7619,95726000,'RS','4305934',1,'2006-11-12 16:56:13'),(4018,NULL,1,26,'COTIPOR',NULL,7624,95335000,'RS','4305959',1,'2006-11-12 16:56:13'),(4019,NULL,1,26,'COXILHA',NULL,7625,99145000,'RS','4305975',1,'2006-11-12 16:56:13'),(4020,NULL,1,26,'CRISSIUMAL',NULL,7628,98640000,'RS','4306007',1,'2006-11-12 16:56:13'),(4021,NULL,1,26,'CRISTAL',NULL,7629,96195000,'RS','4306056',1,'2006-11-12 16:56:14'),(4022,NULL,1,26,'CRISTAL DO SUL',NULL,7630,98368000,'RS','4306072',1,'2006-11-12 16:56:14'),(4023,NULL,1,26,'CRUZ ALTA',NULL,7632,NULL,'RS','4306106',1,'2006-11-12 16:56:14'),(4024,NULL,1,26,'CRUZALTENSE',NULL,7633,99665000,'RS','4306130',1,'2006-11-12 16:56:14'),(4025,NULL,1,26,'CRUZEIRO DO SUL',NULL,7635,95930000,'RS','4306205',1,'2006-11-12 16:56:14'),(4026,NULL,1,26,'DAVID CANABARRO',NULL,7642,99980000,'RS','4306304',1,'2006-11-12 16:56:14'),(4027,NULL,1,26,'DERRUBADAS',NULL,7646,98528000,'RS','4306320',1,'2006-11-12 16:56:14'),(4028,NULL,1,26,'DEZESSEIS DE NOVEMBRO',NULL,7647,97845000,'RS','4306353',1,'2006-11-12 16:56:14'),(4029,NULL,1,26,'DILERMANDO DE AGUIAR',NULL,7648,97180000,'RS','4306379',1,'2006-11-12 16:56:14'),(4030,NULL,1,26,'DOIS IRMOS',NULL,7650,93950000,'RS','4306403',1,'2006-11-12 16:56:14'),(4031,NULL,1,26,'DOIS IRMOS DAS MISSES',NULL,7651,98385000,'RS','4306429',1,'2006-11-12 16:56:14'),(4032,NULL,1,26,'DOIS LAJEADOS',NULL,7652,99220000,'RS','4306452',1,'2006-11-12 16:56:14'),(4033,NULL,1,26,'SO JOS DO SUL',NULL,7653,95748000,'RS','4318614',1,'2006-11-12 16:56:14'),(4034,NULL,1,26,'DOM FELICIANO',NULL,7654,96190000,'RS','4306502',1,'2006-11-12 16:56:14'),(4035,NULL,1,26,'DOM PEDRITO',NULL,7656,96450000,'RS','4306601',1,'2006-11-12 16:56:14'),(4036,NULL,1,26,'DOM PEDRO DE ALCNTARA',NULL,7657,95568000,'RS','4306551',1,'2006-11-12 16:56:14'),(4037,NULL,1,26,'DONA FRANCISCA',NULL,7658,97280000,'RS','4306700',1,'2006-11-12 16:56:14'),(4038,NULL,1,26,'BOZANO',NULL,7661,98733000,'RS','4302584',1,'2006-11-12 16:56:14'),(4039,NULL,1,26,'DOUTOR MAURCIO CARDOSO',NULL,7663,98925000,'RS','4306734',1,'2006-11-12 16:56:14'),(4040,NULL,1,26,'DOUTOR RICARDO',NULL,7664,95967000,'RS','4306759',1,'2006-11-12 16:56:14'),(4041,NULL,1,26,'ELDORADO DO SUL',NULL,7665,92990000,'RS','4306767',1,'2006-11-12 16:56:14'),(4042,NULL,1,26,'ENCANTADO',NULL,7667,95960000,'RS','4306809',1,'2006-11-12 16:56:14'),(4043,NULL,1,26,'ENCRUZILHADA DO SUL',NULL,7669,96610000,'RS','4306908',1,'2006-11-12 16:56:14'),(4044,NULL,1,26,'ENGENHO VELHO',NULL,7670,99698000,'RS','4306924',1,'2006-11-12 16:56:15'),(4045,NULL,1,26,'ENTRE RIOS DO SUL',NULL,7671,99645000,'RS','4306957',1,'2006-11-12 16:56:15'),(4046,NULL,1,26,'ENTRE-IJUS',NULL,7672,98855000,'RS','4306932',1,'2006-11-12 16:56:15'),(4047,NULL,1,26,'EREBANGO',NULL,7674,99920000,'RS','4306973',1,'2006-11-12 16:56:15'),(4048,NULL,1,26,'ERECHIM',NULL,7675,99700000,'RS','4307005',1,'2006-11-12 16:56:15'),(4049,NULL,1,26,'ERNESTINA',NULL,7676,99140000,'RS','4307054',1,'2006-11-12 16:56:15'),(4050,NULL,1,26,'ERVAL GRANDE',NULL,7678,99750000,'RS','4307203',1,'2006-11-12 16:56:15'),(4051,NULL,1,26,'ERVAL SECO',NULL,7679,98390000,'RS','4307302',1,'2006-11-12 16:56:15'),(4052,NULL,1,26,'ESMERALDA',NULL,7681,95380000,'RS','4307401',1,'2006-11-12 16:56:15'),(4053,NULL,1,26,'ESPERANA DO SUL',NULL,7682,98635000,'RS','4307450',1,'2006-11-12 16:56:15'),(4054,NULL,1,26,'ESPUMOSO',NULL,7687,99400000,'RS','4307500',1,'2006-11-12 16:56:15'),(4055,NULL,1,26,'ESTAO',NULL,7694,99930000,'RS','4307559',1,'2006-11-12 16:56:15'),(4056,NULL,1,26,'ESTNCIA VELHA',NULL,7696,93600000,'RS','4307609',1,'2006-11-12 16:56:15'),(4057,NULL,1,26,'ESTEIO',NULL,7697,NULL,'RS','4307708',1,'2006-11-12 16:56:15'),(4058,NULL,1,26,'ESTRELA',NULL,7700,95880000,'RS','4307807',1,'2006-11-12 16:56:15'),(4059,NULL,1,26,'ESTRELA VELHA',NULL,7702,96990000,'RS','4307815',1,'2006-11-12 16:56:15'),(4060,NULL,1,26,'EUGNIO DE CASTRO',NULL,7703,98860000,'RS','4307831',1,'2006-11-12 16:56:15'),(4061,NULL,1,26,'FAGUNDES VARELA',NULL,7705,95333000,'RS','4307864',1,'2006-11-12 16:56:15'),(4062,NULL,1,26,'FARROUPILHA',NULL,7710,95180000,'RS','4307906',1,'2006-11-12 16:56:15'),(4063,NULL,1,26,'FAXINAL DO SOTURNO',NULL,7712,97220000,'RS','4308003',1,'2006-11-12 16:56:15'),(4064,NULL,1,26,'FAXINALZINHO',NULL,7713,99655000,'RS','4308052',1,'2006-11-12 16:56:15'),(4065,NULL,1,26,'FAZENDA VILANOVA',NULL,7716,95875000,'RS','4308078',1,'2006-11-12 16:56:15'),(4066,NULL,1,26,'FELIZ',NULL,7717,95770000,'RS','4308102',1,'2006-11-12 16:56:16'),(4067,NULL,1,26,'FLORES DA CUNHA',NULL,7719,95270000,'RS','4308201',1,'2006-11-12 16:56:16'),(4068,NULL,1,26,'FLORIANO PEIXOTO',NULL,7722,99910000,'RS','4308250',1,'2006-11-12 16:56:16'),(4069,NULL,1,26,'FONTOURA XAVIER',NULL,7724,99370000,'RS','4308300',1,'2006-11-12 16:56:16'),(4070,NULL,1,26,'FORMIGUEIRO',NULL,7725,97210000,'RS','4308409',1,'2006-11-12 16:56:16'),(4071,NULL,1,26,'FORQUETINHA',NULL,7728,95937000,'RS','4308433',1,'2006-11-12 16:56:16'),(4072,NULL,1,26,'FORTALEZA DOS VALOS',NULL,7729,98125000,'RS','4308458',1,'2006-11-12 16:56:16'),(4073,NULL,1,26,'FREDERICO WESTPHALEN',NULL,7730,98400000,'RS','4308508',1,'2006-11-12 16:56:16'),(4074,NULL,1,26,'GARIBALDI',NULL,7733,95720000,'RS','4308607',1,'2006-11-12 16:56:16'),(4075,NULL,1,26,'GARRUCHOS',NULL,7735,97690000,'RS','4308656',1,'2006-11-12 16:56:16'),(4076,NULL,1,26,'GAURAMA',NULL,7736,99830000,'RS','4308706',1,'2006-11-12 16:56:16'),(4077,NULL,1,26,'GENERAL CMARA',NULL,7737,95820000,'RS','4308805',1,'2006-11-12 16:56:16'),(4078,NULL,1,26,'GENTIL',NULL,7738,99160000,'RS','4308854',1,'2006-11-12 16:56:16'),(4079,NULL,1,26,'GETLIO VARGAS',NULL,7739,99900000,'RS','4308904',1,'2006-11-12 16:56:16'),(4080,NULL,1,26,'GIRU',NULL,7740,98870000,'RS','4309001',1,'2006-11-12 16:56:16'),(4081,NULL,1,26,'GLORINHA',NULL,7742,94380000,'RS','4309050',1,'2006-11-12 16:56:16'),(4082,NULL,1,26,'GRAMADO',NULL,7744,95670000,'RS','4309100',1,'2006-11-12 16:56:16'),(4083,NULL,1,26,'GRAMADO DOS LOUREIROS',NULL,7745,99605000,'RS','4309126',1,'2006-11-12 16:56:16'),(4084,NULL,1,26,'GRAMADO XAVIER',NULL,7747,96875000,'RS','4309159',1,'2006-11-12 16:56:16'),(4085,NULL,1,26,'GRAVATA',NULL,7748,NULL,'RS','4309209',1,'2006-11-12 16:56:17'),(4086,NULL,1,26,'GUABIJU',NULL,7749,95355000,'RS','4309258',1,'2006-11-12 16:56:17'),(4087,NULL,1,26,'GUABA',NULL,7750,92500000,'RS','4309308',1,'2006-11-12 16:56:17'),(4088,NULL,1,26,'GUAPOR',NULL,7752,99200000,'RS','4309407',1,'2006-11-12 16:56:17'),(4089,NULL,1,26,'GUARANI DAS MISSES',NULL,7753,97950000,'RS','4309506',1,'2006-11-12 16:56:17'),(4090,NULL,1,26,'HARMONIA',NULL,7755,95785000,'RS','4309555',1,'2006-11-12 16:56:17'),(4091,NULL,1,26,'HERVAL',NULL,7756,96310000,'RS','4307104',1,'2006-11-12 16:56:17'),(4092,NULL,1,26,'HERVEIRAS',NULL,7757,96888000,'RS','4309571',1,'2006-11-12 16:56:17'),(4093,NULL,1,26,'HORIZONTINA',NULL,7759,98920000,'RS','4309605',1,'2006-11-12 16:56:17'),(4094,NULL,1,26,'HULHA NEGRA',NULL,7760,96460000,'RS','4309654',1,'2006-11-12 16:56:17'),(4095,NULL,1,26,'HUMAIT',NULL,7761,98670000,'RS','4309704',1,'2006-11-12 16:56:17'),(4096,NULL,1,26,'IBARAMA',NULL,7762,96925000,'RS','4309753',1,'2006-11-12 16:56:17'),(4097,NULL,1,26,'IBIA',NULL,7764,99940000,'RS','4309803',1,'2006-11-12 16:56:17'),(4098,NULL,1,26,'IBIRAIARAS',NULL,7765,95305000,'RS','4309902',1,'2006-11-12 16:56:17'),(4099,NULL,1,26,'IBIRAPUIT',NULL,7766,99320000,'RS','4309951',1,'2006-11-12 16:56:17'),(4100,NULL,1,26,'IBIRUB',NULL,7767,98200000,'RS','4310009',1,'2006-11-12 16:56:17'),(4101,NULL,1,26,'IGREJINHA',NULL,7768,95650000,'RS','4310108',1,'2006-11-12 16:56:17'),(4102,NULL,1,26,'IJU',NULL,7771,98700000,'RS','4310207',1,'2006-11-12 16:56:17'),(4103,NULL,1,26,'ILPOLIS',NULL,7773,95990000,'RS','4310306',1,'2006-11-12 16:56:17'),(4104,NULL,1,26,'IMB',NULL,7774,95625000,'RS','4310330',1,'2006-11-12 16:56:17'),(4105,NULL,1,26,'IMIGRANTE',NULL,7775,95885000,'RS','4310363',1,'2006-11-12 16:56:17'),(4106,NULL,1,26,'INDEPENDNCIA',NULL,7776,98915000,'RS','4310405',1,'2006-11-12 16:56:17'),(4107,NULL,1,26,'INHACOR',NULL,7777,98765000,'RS','4310413',1,'2006-11-12 16:56:18'),(4108,NULL,1,26,'IP',NULL,7778,95240000,'RS','4310439',1,'2006-11-12 16:56:18'),(4109,NULL,1,26,'IPIRANGA DO SUL',NULL,7780,99925000,'RS','4310462',1,'2006-11-12 16:56:18'),(4110,NULL,1,26,'IRA',NULL,7782,98460000,'RS','4310504',1,'2006-11-12 16:56:18'),(4111,NULL,1,26,'ITAARA',NULL,7784,97185000,'RS','4310538',1,'2006-11-12 16:56:18'),(4112,NULL,1,26,'ITACURUBI',NULL,7786,97685000,'RS','4310553',1,'2006-11-12 16:56:18'),(4113,NULL,1,26,'ITAPUC',NULL,7792,95997000,'RS','4310579',1,'2006-11-12 16:56:18'),(4114,NULL,1,26,'ITAQUI',NULL,7794,97650000,'RS','4310603',1,'2006-11-12 16:56:18'),(4115,NULL,1,26,'ITATI',NULL,7795,95538000,'RS','4310652',1,'2006-11-12 16:56:18'),(4116,NULL,1,26,'ITATIBA DO SUL',NULL,7796,99760000,'RS','4310702',1,'2006-11-12 16:56:18'),(4117,NULL,1,26,'IVOR',NULL,7800,98160000,'RS','4310751',1,'2006-11-12 16:56:18'),(4118,NULL,1,26,'IVOTI',NULL,7801,93900000,'RS','4310801',1,'2006-11-12 16:56:18'),(4119,NULL,1,26,'JABOTICABA',NULL,7802,98350000,'RS','4310850',1,'2006-11-12 16:56:18'),(4120,NULL,1,26,'JACUIZINHO',NULL,7803,99457000,'RS','4310876',1,'2006-11-12 16:56:18'),(4121,NULL,1,26,'JACUTINGA',NULL,7804,99730000,'RS','4310900',1,'2006-11-12 16:56:18'),(4122,NULL,1,26,'JAGUARO',NULL,7805,96300000,'RS','4311007',1,'2006-11-12 16:56:18'),(4123,NULL,1,26,'JAGUARI',NULL,7807,97760000,'RS','4311106',1,'2006-11-12 16:56:18'),(4124,NULL,1,26,'JAQUIRANA',NULL,7809,95420000,'RS','4311122',1,'2006-11-12 16:56:18'),(4125,NULL,1,26,'JARI',NULL,7810,98175000,'RS','4311130',1,'2006-11-12 16:56:18'),(4126,NULL,1,26,'JIA',NULL,7815,98180000,'RS','4311155',1,'2006-11-12 16:56:18'),(4127,NULL,1,26,'JLIO DE CASTILHOS',NULL,7818,98130000,'RS','4311205',1,'2006-11-12 16:56:19'),(4128,NULL,1,26,'LAGOA BONITA DO SUL',NULL,7819,96920000,'RS','4311239',1,'2006-11-12 16:56:19'),(4129,NULL,1,26,'LAGOA DOS TRS CANTOS',NULL,7820,99495000,'RS','4311270',1,'2006-11-12 16:56:19'),(4130,NULL,1,26,'LAGOA VERMELHA',NULL,7821,95300000,'RS','4311304',1,'2006-11-12 16:56:19'),(4131,NULL,1,26,'LAGOO',NULL,7822,99340000,'RS','4311254',1,'2006-11-12 16:56:19'),(4132,NULL,1,26,'LAJEADO',NULL,7823,95900000,'RS','4311403',1,'2006-11-12 16:56:19'),(4133,NULL,1,26,'LAJEADO DO BUGRE',NULL,7827,98320000,'RS','4311429',1,'2006-11-12 16:56:19'),(4134,NULL,1,26,'LAVRAS DO SUL',NULL,7833,97390000,'RS','4311502',1,'2006-11-12 16:56:19'),(4135,NULL,1,26,'LIBERATO SALZANO',NULL,7835,99690000,'RS','4311601',1,'2006-11-12 16:56:19'),(4136,NULL,1,26,'LINDOLFO COLLOR',NULL,7836,93940000,'RS','4311627',1,'2006-11-12 16:56:19'),(4137,NULL,1,26,'LINHA NOVA',NULL,7838,95768000,'RS','4311643',1,'2006-11-12 16:56:19'),(4138,NULL,1,26,'MAAMBAR',NULL,7841,97645000,'RS','4311718',1,'2006-11-12 16:56:19'),(4139,NULL,1,26,'MACHADINHO',NULL,7842,99880000,'RS','4311700',1,'2006-11-12 16:56:19'),(4140,NULL,1,26,'MAMPITUBA',NULL,7844,95572000,'RS','4311734',1,'2006-11-12 16:56:19'),(4141,NULL,1,26,'MANOEL VIANA',NULL,7847,97640000,'RS','4311759',1,'2006-11-12 16:56:19'),(4142,NULL,1,26,'MAQUIN',NULL,7848,95530000,'RS','4311775',1,'2006-11-12 16:56:19'),(4143,NULL,1,26,'MARAT',NULL,7849,95793000,'RS','4311791',1,'2006-11-12 16:56:19'),(4144,NULL,1,26,'MARAU',NULL,7850,99150000,'RS','4311809',1,'2006-11-12 16:56:19'),(4145,NULL,1,26,'MARCELINO RAMOS',NULL,7851,99800000,'RS','4311908',1,'2006-11-12 16:56:19'),(4146,NULL,1,26,'MARIANA PIMENTEL',NULL,7853,92900000,'RS','4311981',1,'2006-11-12 16:56:19'),(4147,NULL,1,26,'MARIANO MORO',NULL,7854,99790000,'RS','4312005',1,'2006-11-12 16:56:19'),(4148,NULL,1,26,'MARQUES DE SOUZA',NULL,7857,95923000,'RS','4312054',1,'2006-11-12 16:56:19'),(4149,NULL,1,26,'MATA',NULL,7858,97410000,'RS','4312104',1,'2006-11-12 16:56:20'),(4150,NULL,1,26,'MATO CASTELHANO',NULL,7860,99180000,'RS','4312138',1,'2006-11-12 16:56:20'),(4151,NULL,1,26,'MATO LEITO',NULL,7862,95835000,'RS','4312153',1,'2006-11-12 16:56:20'),(4152,NULL,1,26,'MATO QUEIMADO',NULL,7863,97935000,'RS','4312179',1,'2006-11-12 16:56:20'),(4153,NULL,1,26,'MAXIMILIANO DE ALMEIDA',NULL,7866,99890000,'RS','4312203',1,'2006-11-12 16:56:20'),(4154,NULL,1,26,'MINAS DO LEO',NULL,7868,96755000,'RS','4312252',1,'2006-11-12 16:56:20'),(4155,NULL,1,26,'MIRAGUA',NULL,7869,98540000,'RS','4312302',1,'2006-11-12 16:56:20'),(4156,NULL,1,26,'MONTAURI',NULL,7873,99255000,'RS','4312351',1,'2006-11-12 16:56:20'),(4157,NULL,1,26,'MONTE ALEGRE DOS CAMPOS',NULL,7876,95236000,'RS','4312377',1,'2006-11-12 16:56:20'),(4158,NULL,1,26,'MONTE BELO DO SUL',NULL,7878,95718000,'RS','4312385',1,'2006-11-12 16:56:20'),(4159,NULL,1,26,'MONTENEGRO',NULL,7880,95780000,'RS','4312401',1,'2006-11-12 16:56:20'),(4160,NULL,1,26,'MORMAO',NULL,7881,99315000,'RS','4312427',1,'2006-11-12 16:56:20'),(4161,NULL,1,26,'MORRINHOS DO SUL',NULL,7883,95577000,'RS','4312443',1,'2006-11-12 16:56:20'),(4162,NULL,1,26,'MORRO REDONDO',NULL,7886,96150000,'RS','4312450',1,'2006-11-12 16:56:20'),(4163,NULL,1,26,'MORRO REUTER',NULL,7887,93990000,'RS','4312476',1,'2006-11-12 16:56:20'),(4164,NULL,1,26,'MOSTARDAS',NULL,7889,96270000,'RS','4312500',1,'2006-11-12 16:56:20'),(4165,NULL,1,26,'MUUM',NULL,7890,95970000,'RS','4312609',1,'2006-11-12 16:56:20'),(4166,NULL,1,26,'MUITOS CAPES',NULL,7891,95230000,'RS','4312617',1,'2006-11-12 16:56:20'),(4167,NULL,1,26,'MULITERNO',NULL,7892,99990000,'RS','4312625',1,'2006-11-12 16:56:20'),(4168,NULL,1,26,'NO-ME-TOQUE',NULL,7893,99470000,'RS','4312658',1,'2006-11-12 16:56:20'),(4169,NULL,1,26,'NICOLAU VERGUEIRO',NULL,7895,99175000,'RS','4312674',1,'2006-11-12 16:56:20'),(4170,NULL,1,26,'NONOAI',NULL,7896,99600000,'RS','4312708',1,'2006-11-12 16:56:20'),(4171,NULL,1,26,'NOVA ALVORADA',NULL,7899,95985000,'RS','4312757',1,'2006-11-12 16:56:20'),(4172,NULL,1,26,'NOVA ARA',NULL,7900,95350000,'RS','4312807',1,'2006-11-12 16:56:21'),(4173,NULL,1,26,'NOVA BASSANO',NULL,7901,95340000,'RS','4312906',1,'2006-11-12 16:56:21'),(4174,NULL,1,26,'NOVA BOA VISTA',NULL,7902,99580000,'RS','4312955',1,'2006-11-12 16:56:21'),(4175,NULL,1,26,'NOVA BRSCIA',NULL,7903,95950000,'RS','4313003',1,'2006-11-12 16:56:21'),(4176,NULL,1,26,'NOVA CANDELRIA',NULL,7904,98919000,'RS','4313011',1,'2006-11-12 16:56:21'),(4177,NULL,1,26,'NOVA ESPERANA DO SUL',NULL,7905,97770000,'RS','4313037',1,'2006-11-12 16:56:21'),(4178,NULL,1,26,'NOVA HARTZ',NULL,7906,93890000,'RS','4313060',1,'2006-11-12 16:56:21'),(4179,NULL,1,26,'NOVA PDUA',NULL,7908,95275000,'RS','4313086',1,'2006-11-12 16:56:21'),(4180,NULL,1,26,'NOVA PALMA',NULL,7909,97250000,'RS','4313102',1,'2006-11-12 16:56:21'),(4181,NULL,1,26,'NOVA PETRPOLIS',NULL,7910,95150000,'RS','4313201',1,'2006-11-12 16:56:21'),(4182,NULL,1,26,'NOVA PRATA',NULL,7911,95320000,'RS','4313300',1,'2006-11-12 16:56:21'),(4183,NULL,1,26,'NOVA RAMADA',NULL,7912,98758000,'RS','4313334',1,'2006-11-12 16:56:21'),(4184,NULL,1,26,'NOVA ROMA DO SUL',NULL,7913,95260000,'RS','4313359',1,'2006-11-12 16:56:21'),(4185,NULL,1,26,'NOVA SANTA RITA',NULL,7914,92480000,'RS','4313375',1,'2006-11-12 16:56:21'),(4186,NULL,1,26,'NOVO BARREIRO',NULL,7916,98338000,'RS','4313490',1,'2006-11-12 16:56:21'),(4187,NULL,1,26,'NOVO CABRAIS',NULL,7917,96545000,'RS','4313391',1,'2006-11-12 16:56:21'),(4188,NULL,1,26,'NOVO HAMBURGO',NULL,7918,NULL,'RS','4313409',1,'2006-11-12 16:56:21'),(4189,NULL,1,26,'NOVO MACHADO',NULL,7920,98955000,'RS','4313425',1,'2006-11-12 16:56:21'),(4190,NULL,1,26,'NOVO TIRADENTES',NULL,7922,98370000,'RS','4313441',1,'2006-11-12 16:56:21'),(4191,NULL,1,26,'OSRIO',NULL,7925,95520000,'RS','4313508',1,'2006-11-12 16:56:21'),(4192,NULL,1,26,'PAIM FILHO',NULL,7932,99850000,'RS','4313607',1,'2006-11-12 16:56:21'),(4193,NULL,1,26,'PALMARES DO SUL',NULL,7933,95540000,'RS','4313656',1,'2006-11-12 16:56:21'),(4194,NULL,1,26,'PALMEIRA DAS MISSES',NULL,7935,98300000,'RS','4313706',1,'2006-11-12 16:56:22'),(4195,NULL,1,26,'PALMITINHO',NULL,7936,98430000,'RS','4313805',1,'2006-11-12 16:56:22'),(4196,NULL,1,26,'PANAMBI',NULL,7938,98280000,'RS','4313904',1,'2006-11-12 16:56:22'),(4197,NULL,1,26,'PNTANO GRANDE',NULL,7939,96690000,'RS','4313953',1,'2006-11-12 16:56:22'),(4198,NULL,1,26,'PARA',NULL,7940,95360000,'RS','4314001',1,'2006-11-12 16:56:22'),(4199,NULL,1,26,'PARASO DO SUL',NULL,7941,96530000,'RS','4314027',1,'2006-11-12 16:56:22'),(4200,NULL,1,26,'PARECI NOVO',NULL,7942,95783000,'RS','4314035',1,'2006-11-12 16:56:22'),(4201,NULL,1,26,'PAROB',NULL,7943,95630000,'RS','4314050',1,'2006-11-12 16:56:22'),(4202,NULL,1,26,'PASSA SETE',NULL,7944,96908000,'RS','4314068',1,'2006-11-12 16:56:22'),(4203,NULL,1,26,'PASSO DO SOBRADO',NULL,7952,96685000,'RS','4314076',1,'2006-11-12 16:56:22'),(4204,NULL,1,26,'PASSO FUNDO',NULL,7953,NULL,'RS','4314100',1,'2006-11-12 16:56:22'),(4205,NULL,1,26,'PAULO BENTO',NULL,7956,99718000,'RS','4314134',1,'2006-11-12 16:56:22'),(4206,NULL,1,26,'PAVERAMA',NULL,7958,95865000,'RS','4314159',1,'2006-11-12 16:56:22'),(4207,NULL,1,26,'PEDRAS ALTAS',NULL,7959,96487000,'RS','4314175',1,'2006-11-12 16:56:22'),(4208,NULL,1,26,'PEDRO OSRIO',NULL,7962,96360000,'RS','4314209',1,'2006-11-12 16:56:22'),(4209,NULL,1,26,'PEJUARA',NULL,7964,98270000,'RS','4314308',1,'2006-11-12 16:56:22'),(4210,NULL,1,26,'PELOTAS',NULL,7965,NULL,'RS','4314407',1,'2006-11-12 16:56:22'),(4211,NULL,1,26,'PICADA CAF',NULL,7966,95175000,'RS','4314423',1,'2006-11-12 16:56:22'),(4212,NULL,1,26,'PINHAL',NULL,7967,98345000,'RS','4314456',1,'2006-11-12 16:56:22'),(4213,NULL,1,26,'PINHAL DA SERRA',NULL,7972,95390000,'RS','4314464',1,'2006-11-12 16:56:22'),(4214,NULL,1,26,'PINHAL GRANDE',NULL,7973,98150000,'RS','4314472',1,'2006-11-12 16:56:22'),(4215,NULL,1,26,'PINHEIRINHO DO VALE',NULL,7976,98435000,'RS','4314498',1,'2006-11-12 16:56:22'),(4216,NULL,1,26,'PINHEIRO MACHADO',NULL,7977,96470000,'RS','4314506',1,'2006-11-12 16:56:22'),(4217,NULL,1,26,'PINTO BANDEIRA',NULL,7980,95717000,'RS',NULL,1,'2006-11-12 16:56:22'),(4218,NULL,1,26,'PIRAP',NULL,7982,97885000,'RS','4314555',1,'2006-11-12 16:56:23'),(4219,NULL,1,26,'PIRATINI',NULL,7983,96490000,'RS','4314605',1,'2006-11-12 16:56:23'),(4220,NULL,1,26,'PLANALTO',NULL,7985,98470000,'RS','4314704',1,'2006-11-12 16:56:23'),(4221,NULL,1,26,'POO DAS ANTAS',NULL,7988,95740000,'RS','4314753',1,'2006-11-12 16:56:23'),(4222,NULL,1,26,'PONTO',NULL,7991,99190000,'RS','4314779',1,'2006-11-12 16:56:23'),(4223,NULL,1,26,'PONTE PRETA',NULL,7992,99735000,'RS','4314787',1,'2006-11-12 16:56:23'),(4224,NULL,1,26,'PORTO',NULL,7993,93180000,'RS','4314803',1,'2006-11-12 16:56:23'),(4225,NULL,1,26,'PORTO ALEGRE',NULL,7994,NULL,'RS','4314902',1,'2006-11-12 16:56:23'),(4226,NULL,1,26,'PORTO LUCENA',NULL,7996,98980000,'RS','4315008',1,'2006-11-12 16:56:23'),(4227,NULL,1,26,'PORTO MAU',NULL,7997,98947000,'RS','4315057',1,'2006-11-12 16:56:23'),(4228,NULL,1,26,'PORTO VERA CRUZ',NULL,7998,98985000,'RS','4315073',1,'2006-11-12 16:56:23'),(4229,NULL,1,26,'PORTO XAVIER',NULL,7999,98995000,'RS','4315107',1,'2006-11-12 16:56:23'),(4230,NULL,1,26,'POUSO NOVO',NULL,8000,95945000,'RS','4315131',1,'2006-11-12 16:56:23'),(4231,NULL,1,26,'PRESIDENTE LUCENA',NULL,8005,93945000,'RS','4315149',1,'2006-11-12 16:56:23'),(4232,NULL,1,26,'PROGRESSO',NULL,8006,95925000,'RS','4315156',1,'2006-11-12 16:56:23'),(4233,NULL,1,26,'PROTSIO ALVES',NULL,8010,95345000,'RS','4315172',1,'2006-11-12 16:56:23'),(4234,NULL,1,26,'PUTINGA',NULL,8012,95975000,'RS','4315206',1,'2006-11-12 16:56:23'),(4235,NULL,1,26,'QUARA',NULL,8013,97560000,'RS','4315305',1,'2006-11-12 16:56:23'),(4236,NULL,1,26,'QUATRO IRMOS',NULL,8015,99720000,'RS','4315313',1,'2006-11-12 16:56:23'),(4237,NULL,1,26,'QUEVEDOS',NULL,8016,98140000,'RS','4315321',1,'2006-11-12 16:56:23'),(4238,NULL,1,26,'QUINZE DE NOVEMBRO',NULL,8020,98230000,'RS','4315354',1,'2006-11-12 16:56:23'),(4239,NULL,1,26,'REDENTORA',NULL,8023,98550000,'RS','4315404',1,'2006-11-12 16:56:23'),(4240,NULL,1,26,'RELVADO',NULL,8025,95965000,'RS','4315453',1,'2006-11-12 16:56:23'),(4241,NULL,1,26,'RESTINGA SECA',NULL,8026,97200000,'RS','4315503',1,'2006-11-12 16:56:23'),(4242,NULL,1,26,'RIO DOS NDIOS',NULL,8040,99610000,'RS','4315552',1,'2006-11-12 16:56:24'),(4243,NULL,1,26,'RIO GRANDE',NULL,8041,NULL,'RS','4315602',1,'2006-11-12 16:56:24'),(4244,NULL,1,26,'RIO PARDO',NULL,8043,96640000,'RS','4315701',1,'2006-11-12 16:56:24'),(4245,NULL,1,26,'RIOZINHO',NULL,8047,95695000,'RS','4315750',1,'2006-11-12 16:56:24'),(4246,NULL,1,26,'ROCA SALES',NULL,8048,95735000,'RS','4315800',1,'2006-11-12 16:56:24'),(4247,NULL,1,26,'RODEIO BONITO',NULL,8049,98360000,'RS','4315909',1,'2006-11-12 16:56:24'),(4248,NULL,1,26,'ROLADOR',NULL,8050,97843000,'RS','4315958',1,'2006-11-12 16:56:24'),(4249,NULL,1,26,'ROLANTE',NULL,8051,95690000,'RS','4316006',1,'2006-11-12 16:56:24'),(4250,NULL,1,26,'RONDA ALTA',NULL,8053,99670000,'RS','4316105',1,'2006-11-12 16:56:24'),(4251,NULL,1,26,'RONDINHA',NULL,8054,99590000,'RS','4316204',1,'2006-11-12 16:56:24'),(4252,NULL,1,26,'ROQUE GONZALES',NULL,8055,97970000,'RS','4316303',1,'2006-11-12 16:56:24'),(4253,NULL,1,26,'ROSRIO DO SUL',NULL,8057,97590000,'RS','4316402',1,'2006-11-12 16:56:24'),(4254,NULL,1,26,'SAGRADA FAMLIA',NULL,8058,98330000,'RS','4316428',1,'2006-11-12 16:56:24'),(4255,NULL,1,26,'SALDANHA MARINHO',NULL,8060,98250000,'RS','4316436',1,'2006-11-12 16:56:24'),(4256,NULL,1,26,'SALTO DO JACU',NULL,8064,99440000,'RS','4316451',1,'2006-11-12 16:56:24'),(4257,NULL,1,26,'SALVADOR DAS MISSES',NULL,8065,97940000,'RS','4316477',1,'2006-11-12 16:56:24'),(4258,NULL,1,26,'SALVADOR DO SUL',NULL,8066,95750000,'RS','4316501',1,'2006-11-12 16:56:24'),(4259,NULL,1,26,'SANANDUVA',NULL,8067,99840000,'RS','4316600',1,'2006-11-12 16:56:24'),(4260,NULL,1,26,'SANTA BRBARA DO SUL',NULL,8071,98240000,'RS','4316709',1,'2006-11-12 16:56:24'),(4261,NULL,1,26,'SANTA CECLIA DO SUL',NULL,8073,99952000,'RS','4316733',1,'2006-11-12 16:56:24'),(4262,NULL,1,26,'SANTA CLARA DO SUL',NULL,8075,95915000,'RS','4316758',1,'2006-11-12 16:56:24'),(4263,NULL,1,26,'SANTA CRUZ DO SUL',NULL,8079,NULL,'RS','4316808',1,'2006-11-12 16:56:24'),(4264,NULL,1,26,'SANTA MARIA',NULL,8087,NULL,'RS','4316907',1,'2006-11-12 16:56:25'),(4265,NULL,1,26,'SANTA MARIA DO HERVAL',NULL,8088,93995000,'RS','4316956',1,'2006-11-12 16:56:25'),(4266,NULL,1,26,'SANTA ROSA',NULL,8090,98900000,'RS','4317202',1,'2006-11-12 16:56:25'),(4267,NULL,1,26,'SANTA TEREZA',NULL,8094,95715000,'RS','4317251',1,'2006-11-12 16:56:25'),(4268,NULL,1,26,'SANTA VITRIA DO PALMAR',NULL,8096,96230000,'RS','4317301',1,'2006-11-12 16:56:25'),(4269,NULL,1,26,'SANTANA DA BOA VISTA',NULL,8100,96590000,'RS','4317004',1,'2006-11-12 16:56:25'),(4270,NULL,1,26,'SANTANA DO LIVRAMENTO',NULL,8101,NULL,'RS','4317103',1,'2006-11-12 16:56:25'),(4271,NULL,1,26,'SANTIAGO',NULL,8102,97700000,'RS','4317400',1,'2006-11-12 16:56:25'),(4272,NULL,1,26,'SANTO NGELO',NULL,8104,NULL,'RS','4317509',1,'2006-11-12 16:56:25'),(4273,NULL,1,26,'SANTO ANTNIO DA PATRULHA',NULL,8108,95500000,'RS','4317608',1,'2006-11-12 16:56:25'),(4274,NULL,1,26,'SANTO ANTNIO DAS MISSES',NULL,8109,97870000,'RS','4317707',1,'2006-11-12 16:56:25'),(4275,NULL,1,26,'SANTO ANTNIO DO PALMA',NULL,8112,99265000,'RS','4317558',1,'2006-11-12 16:56:25'),(4276,NULL,1,26,'SANTO ANTNIO DO PLANALTO',NULL,8113,99525000,'RS','4317756',1,'2006-11-12 16:56:25'),(4277,NULL,1,26,'SANTO AUGUSTO',NULL,8114,98590000,'RS','4317806',1,'2006-11-12 16:56:25'),(4278,NULL,1,26,'SANTO CRISTO',NULL,8115,98960000,'RS','4317905',1,'2006-11-12 16:56:25'),(4279,NULL,1,26,'SANTO EXPEDITO DO SUL',NULL,8116,99895000,'RS','4317954',1,'2006-11-12 16:56:25'),(4280,NULL,1,26,'SO BORJA',NULL,8120,97670000,'RS','4318002',1,'2006-11-12 16:56:25'),(4281,NULL,1,26,'SO DOMINGOS DO SUL',NULL,8122,99270000,'RS','4318051',1,'2006-11-12 16:56:25'),(4282,NULL,1,26,'SO FRANCISCO DE ASSIS',NULL,8124,97610000,'RS','4318101',1,'2006-11-12 16:56:25'),(4283,NULL,1,26,'SO FRANCISCO DE PAULA',NULL,8125,95400000,'RS','4318200',1,'2006-11-12 16:56:25'),(4284,NULL,1,26,'SO GABRIEL',NULL,8126,97300000,'RS','4318309',1,'2006-11-12 16:56:25'),(4285,NULL,1,26,'SO JERNIMO',NULL,8127,96700000,'RS','4318408',1,'2006-11-12 16:56:25'),(4286,NULL,1,26,'SO JOO DA URTIGA',NULL,8131,99855000,'RS','4318424',1,'2006-11-12 16:56:25'),(4287,NULL,1,26,'SO JOO DO POLESINE',NULL,8132,97230000,'RS','4318432',1,'2006-11-12 16:56:25'),(4288,NULL,1,26,'SO JORGE',NULL,8133,95365000,'RS','4318440',1,'2006-11-12 16:56:25'),(4289,NULL,1,26,'SO JOS DAS MISSES',NULL,8137,98325000,'RS','4318457',1,'2006-11-12 16:56:25'),(4290,NULL,1,26,'SO JOS DO HERVAL',NULL,8140,99380000,'RS','4318465',1,'2006-11-12 16:56:26'),(4291,NULL,1,26,'SO JOS DO HORTNCIO',NULL,8141,95755000,'RS','4318481',1,'2006-11-12 16:56:26'),(4292,NULL,1,26,'SO JOS DO INHACOR',NULL,8142,98958000,'RS','4318499',1,'2006-11-12 16:56:26'),(4293,NULL,1,26,'SO JOS DO NORTE',NULL,8143,96225000,'RS','4318507',1,'2006-11-12 16:56:26'),(4294,NULL,1,26,'SO JOS DO OURO',NULL,8144,99870000,'RS','4318606',1,'2006-11-12 16:56:26'),(4295,NULL,1,26,'SO JOS DOS AUSENTES',NULL,8145,95280000,'RS','4318622',1,'2006-11-12 16:56:26'),(4296,NULL,1,26,'SO LEOPOLDO',NULL,8146,NULL,'RS','4318705',1,'2006-11-12 16:56:26'),(4297,NULL,1,26,'SO LOURENO DO SUL',NULL,8148,96170000,'RS','4318804',1,'2006-11-12 16:56:26'),(4298,NULL,1,26,'SO LUIZ GONZAGA',NULL,8151,97800000,'RS','4318903',1,'2006-11-12 16:56:26'),(4299,NULL,1,26,'SO MARCOS',NULL,8153,95190000,'RS','4319000',1,'2006-11-12 16:56:26'),(4300,NULL,1,26,'SO MARTINHO',NULL,8155,98690000,'RS','4319109',1,'2006-11-12 16:56:26'),(4301,NULL,1,26,'SO MARTINHO DA SERRA',NULL,8156,97190000,'RS','4319125',1,'2006-11-12 16:56:26'),(4302,NULL,1,26,'SO MIGUEL DAS MISSES',NULL,8158,98865000,'RS','4319158',1,'2006-11-12 16:56:26'),(4303,NULL,1,26,'SO NICOLAU',NULL,8159,97880000,'RS','4319208',1,'2006-11-12 16:56:26'),(4304,NULL,1,26,'SO PAULO DAS MISSES',NULL,8161,97980000,'RS','4319307',1,'2006-11-12 16:56:26'),(4305,NULL,1,26,'SO PEDRO DAS MISSES',NULL,8163,98323000,'RS','4319364',1,'2006-11-12 16:56:26'),(4306,NULL,1,26,'SO PEDRO DA SERRA',NULL,8164,95758000,'RS','4319356',1,'2006-11-12 16:56:26'),(4307,NULL,1,26,'SO PEDRO DO BUTI',NULL,8165,97920000,'RS','4319372',1,'2006-11-12 16:56:26'),(4308,NULL,1,26,'SO PEDRO DO SUL',NULL,8167,97400000,'RS','4319406',1,'2006-11-12 16:56:26'),(4309,NULL,1,26,'SO SEBASTIO DO CA',NULL,8171,95760000,'RS','4319505',1,'2006-11-12 16:56:26'),(4310,NULL,1,26,'SO SEP',NULL,8172,97340000,'RS','4319604',1,'2006-11-12 16:56:26'),(4311,NULL,1,26,'SO VALENTIM',NULL,8174,99640000,'RS','4319703',1,'2006-11-12 16:56:26'),(4312,NULL,1,26,'SO VALENTIM DO SUL',NULL,8176,99240000,'RS','4319711',1,'2006-11-12 16:56:26'),(4313,NULL,1,26,'SO VALRIO DO SUL',NULL,8177,98595000,'RS','4319737',1,'2006-11-12 16:56:26'),(4314,NULL,1,26,'SO VENDELINO',NULL,8178,95795000,'RS','4319752',1,'2006-11-12 16:56:27'),(4315,NULL,1,26,'SO VICENTE DO SUL',NULL,8179,97420000,'RS','4319802',1,'2006-11-12 16:56:27'),(4316,NULL,1,26,'SAPIRANGA',NULL,8180,93800000,'RS','4319901',1,'2006-11-12 16:56:27'),(4317,NULL,1,26,'SAPUCAIA DO SUL',NULL,8181,NULL,'RS','4320008',1,'2006-11-12 16:56:27'),(4318,NULL,1,26,'SARANDI',NULL,8182,99560000,'RS','4320107',1,'2006-11-12 16:56:27'),(4319,NULL,1,26,'SEBERI',NULL,8184,98380000,'RS','4320206',1,'2006-11-12 16:56:27'),(4320,NULL,1,26,'SEDE NOVA',NULL,8187,98675000,'RS','4320230',1,'2006-11-12 16:56:27'),(4321,NULL,1,26,'SEGREDO',NULL,8188,96910000,'RS','4320263',1,'2006-11-12 16:56:27'),(4322,NULL,1,26,'SELBACH',NULL,8191,99450000,'RS','4320305',1,'2006-11-12 16:56:27'),(4323,NULL,1,26,'SENADOR SALGADO FILHO',NULL,8192,98895000,'RS','4320321',1,'2006-11-12 16:56:27'),(4324,NULL,1,26,'SENTINELA DO SUL',NULL,8193,96765000,'RS','4320354',1,'2006-11-12 16:56:27'),(4325,NULL,1,26,'SERAFINA CORRA',NULL,8195,99250000,'RS','4320404',1,'2006-11-12 16:56:27'),(4326,NULL,1,26,'SRIO',NULL,8196,95918000,'RS','4320453',1,'2006-11-12 16:56:27'),(4327,NULL,1,26,'SERTO',NULL,8199,99170000,'RS','4320503',1,'2006-11-12 16:56:27'),(4328,NULL,1,26,'SERTO SANTANA',NULL,8200,92850000,'RS','4320552',1,'2006-11-12 16:56:27'),(4329,NULL,1,26,'SETE DE SETEMBRO',NULL,8202,97960000,'RS','4320578',1,'2006-11-12 16:56:27'),(4330,NULL,1,26,'SEVERIANO DE ALMEIDA',NULL,8206,99810000,'RS','4320602',1,'2006-11-12 16:56:27'),(4331,NULL,1,26,'SILVEIRA MARTINS',NULL,8209,97195000,'RS','4320651',1,'2006-11-12 16:56:27'),(4332,NULL,1,26,'SINIMBU',NULL,8210,96890000,'RS','4320677',1,'2006-11-12 16:56:27'),(4333,NULL,1,26,'SOBRADINHO',NULL,8213,96900000,'RS','4320701',1,'2006-11-12 16:56:27'),(4334,NULL,1,26,'SOLEDADE',NULL,8214,99300000,'RS','4320800',1,'2006-11-12 16:56:27'),(4335,NULL,1,26,'TABA',NULL,8217,95863000,'RS','4320859',1,'2006-11-12 16:56:27'),(4336,NULL,1,26,'TAPEJARA',NULL,8223,99950000,'RS','4320909',1,'2006-11-12 16:56:27'),(4337,NULL,1,26,'TAPERA',NULL,8224,99490000,'RS','4321006',1,'2006-11-12 16:56:27'),(4338,NULL,1,26,'TAPES',NULL,8226,96760000,'RS','4321105',1,'2006-11-12 16:56:27'),(4339,NULL,1,26,'TAQUARA',NULL,8227,95600000,'RS','4321204',1,'2006-11-12 16:56:27'),(4340,NULL,1,26,'TAQUARI',NULL,8228,95860000,'RS','4321303',1,'2006-11-12 16:56:28'),(4341,NULL,1,26,'TAQUARUU DO SUL',NULL,8230,98410000,'RS','4321329',1,'2006-11-12 16:56:28'),(4342,NULL,1,26,'TAVARES',NULL,8231,96290000,'RS','4321352',1,'2006-11-12 16:56:28'),(4343,NULL,1,26,'TENENTE PORTELA',NULL,8232,98500000,'RS','4321402',1,'2006-11-12 16:56:28'),(4344,NULL,1,26,'TERRA DE AREIA',NULL,8233,95535000,'RS','4321436',1,'2006-11-12 16:56:28'),(4345,NULL,1,26,'TEUTNIA',NULL,8235,95890000,'RS','4321451',1,'2006-11-12 16:56:28'),(4346,NULL,1,26,'TIRADENTES DO SUL',NULL,8238,98680000,'RS','4321477',1,'2006-11-12 16:56:28'),(4347,NULL,1,26,'TOROPI',NULL,8239,97418000,'RS','4321493',1,'2006-11-12 16:56:28'),(4348,NULL,1,26,'TORRES',NULL,8242,95560000,'RS','4321501',1,'2006-11-12 16:56:28'),(4349,NULL,1,26,'TRAMANDA',NULL,8245,95590000,'RS','4321600',1,'2006-11-12 16:56:28'),(4350,NULL,1,26,'TRAVESSEIRO',NULL,8246,95948000,'RS','4321626',1,'2006-11-12 16:56:28'),(4351,NULL,1,26,'TRS ARROIOS',NULL,8248,99725000,'RS','4321634',1,'2006-11-12 16:56:28'),(4352,NULL,1,26,'TRS CACHOEIRAS',NULL,8250,95580000,'RS','4321667',1,'2006-11-12 16:56:28'),(4353,NULL,1,26,'TRS COROAS',NULL,8251,95660000,'RS','4321709',1,'2006-11-12 16:56:28'),(4354,NULL,1,26,'TRS DE MAIO',NULL,8252,98910000,'RS','4321808',1,'2006-11-12 16:56:28'),(4355,NULL,1,26,'TRS FORQUILHAS',NULL,8253,95575000,'RS','4321832',1,'2006-11-12 16:56:28'),(4356,NULL,1,26,'TRS PALMEIRAS',NULL,8254,99675000,'RS','4321857',1,'2006-11-12 16:56:28'),(4357,NULL,1,26,'TRS PASSOS',NULL,8255,98600000,'RS','4321907',1,'2006-11-12 16:56:28'),(4358,NULL,1,26,'TRINDADE DO SUL',NULL,8257,99615000,'RS','4321956',1,'2006-11-12 16:56:28'),(4359,NULL,1,26,'TRIUNFO',NULL,8258,95840000,'RS','4322004',1,'2006-11-12 16:56:28'),(4360,NULL,1,26,'TUCUNDUVA',NULL,8260,98930000,'RS','4322103',1,'2006-11-12 16:56:28'),(4361,NULL,1,26,'TUNAS',NULL,8262,99330000,'RS','4322152',1,'2006-11-12 16:56:28'),(4362,NULL,1,26,'TUPANCI DO SUL',NULL,8264,99878000,'RS','4322186',1,'2006-11-12 16:56:28'),(4363,NULL,1,26,'TUPANCIRET',NULL,8265,98170000,'RS','4322202',1,'2006-11-12 16:56:28'),(4364,NULL,1,26,'TUPANDI',NULL,8267,95775000,'RS','4322251',1,'2006-11-12 16:56:28'),(4365,NULL,1,26,'TUPARENDI',NULL,8269,98940000,'RS','4322301',1,'2006-11-12 16:56:29'),(4366,NULL,1,26,'TURUU',NULL,8272,96148000,'RS','4322327',1,'2006-11-12 16:56:29'),(4367,NULL,1,26,'UBIRETAMA',NULL,8274,98898000,'RS','4322343',1,'2006-11-12 16:56:29'),(4368,NULL,1,26,'UNIO DA SERRA',NULL,8276,99215000,'RS','4322350',1,'2006-11-12 16:56:29'),(4369,NULL,1,26,'UNISTALDA',NULL,8277,97755000,'RS','4322376',1,'2006-11-12 16:56:29'),(4370,NULL,1,26,'URUGUAIANA',NULL,8278,NULL,'RS','4322400',1,'2006-11-12 16:56:29'),(4371,NULL,1,26,'VACARIA',NULL,8280,95200000,'RS','4322509',1,'2006-11-12 16:56:29'),(4372,NULL,1,26,'VALE DO SOL',NULL,8283,96878000,'RS','4322533',1,'2006-11-12 16:56:29'),(4373,NULL,1,26,'VALE REAL',NULL,8284,95778000,'RS','4322541',1,'2006-11-12 16:56:29'),(4374,NULL,1,26,'VALE VERDE',NULL,8286,95833000,'RS','4322525',1,'2006-11-12 16:56:29'),(4375,NULL,1,26,'VANINI',NULL,8287,99290000,'RS','4322558',1,'2006-11-12 16:56:29'),(4376,NULL,1,26,'VENNCIO AIRES',NULL,8288,95800000,'RS','4322608',1,'2006-11-12 16:56:29'),(4377,NULL,1,26,'VERA CRUZ',NULL,8289,96880000,'RS','4322707',1,'2006-11-12 16:56:29'),(4378,NULL,1,26,'VERANPOLIS',NULL,8290,95330000,'RS','4322806',1,'2006-11-12 16:56:29'),(4379,NULL,1,26,'VESPASIANO CORREA',NULL,8292,95972000,'RS','4322855',1,'2006-11-12 16:56:29'),(4380,NULL,1,26,'VIADUTOS',NULL,8293,99820000,'RS','4322905',1,'2006-11-12 16:56:29'),(4381,NULL,1,26,'VIAMO',NULL,8294,NULL,'RS','4323002',1,'2006-11-12 16:56:29'),(4382,NULL,1,26,'VICENTE DUTRA',NULL,8295,98450000,'RS','4323101',1,'2006-11-12 16:56:29'),(4383,NULL,1,26,'VICTOR GRAEFF',NULL,8296,99350000,'RS','4323200',1,'2006-11-12 16:56:29'),(4384,NULL,1,26,'VILA FLORES',NULL,8299,95334000,'RS','4323309',1,'2006-11-12 16:56:29'),(4385,NULL,1,26,'VILA LANGARO',NULL,8300,99955000,'RS','4323358',1,'2006-11-12 16:56:29'),(4386,NULL,1,26,'VILA MARIA',NULL,8302,99155000,'RS','4323408',1,'2006-11-12 16:56:29'),(4387,NULL,1,26,'VILA NOVA DO SUL',NULL,8303,97385000,'RS','4323457',1,'2006-11-12 16:56:29'),(4388,NULL,1,26,'VISTA ALEGRE',NULL,8307,98415000,'RS','4323507',1,'2006-11-12 16:56:29'),(4389,NULL,1,26,'VISTA ALEGRE DO PRATA',NULL,8309,95325000,'RS','4323606',1,'2006-11-12 16:56:29'),(4390,NULL,1,26,'VISTA GACHA',NULL,8310,98535000,'RS','4323705',1,'2006-11-12 16:56:30'),(4391,NULL,1,26,'VITRIA DAS MISSES',NULL,8312,98850000,'RS','4323754',1,'2006-11-12 16:56:30'),(4392,NULL,1,26,'XANGRI-L',NULL,8317,95588000,'RS','4323804',1,'2006-11-12 16:56:30'),(4393,NULL,1,26,'NOVO XINGU',NULL,8318,99687000,'RS','4313466',1,'2006-11-12 16:56:30'),(4394,NULL,1,25,'ABDON BATISTA',NULL,8319,89636000,'SC','4200051',1,'2006-11-12 16:56:30'),(4395,NULL,1,25,'ABELARDO LUZ',NULL,8320,89830000,'SC','4200101',1,'2006-11-12 16:56:30'),(4396,NULL,1,25,'AGROLNDIA',NULL,8321,88420000,'SC','4200200',1,'2006-11-12 16:56:30'),(4397,NULL,1,25,'AGRONMICA',NULL,8322,89188000,'SC','4200309',1,'2006-11-12 16:56:30'),(4398,NULL,1,25,'GUA DOCE',NULL,8323,89654000,'SC','4200408',1,'2006-11-12 16:56:30'),(4399,NULL,1,25,'GUAS DE CHAPEC',NULL,8326,89883000,'SC','4200507',1,'2006-11-12 16:56:30'),(4400,NULL,1,25,'GUAS FRIAS',NULL,8327,89843000,'SC','4200556',1,'2006-11-12 16:56:30'),(4401,NULL,1,25,'GUAS MORNAS',NULL,8328,88150000,'SC','4200606',1,'2006-11-12 16:56:30'),(4402,NULL,1,25,'ALFREDO WAGNER',NULL,8331,88450000,'SC','4200705',1,'2006-11-12 16:56:30'),(4403,NULL,1,25,'ALTO BELA VISTA',NULL,8333,89730000,'SC','4200754',1,'2006-11-12 16:56:30'),(4404,NULL,1,25,'ANCHIETA',NULL,8335,89970000,'SC','4200804',1,'2006-11-12 16:56:30'),(4405,NULL,1,25,'ANGELINA',NULL,8336,88460000,'SC','4200903',1,'2006-11-12 16:56:30'),(4406,NULL,1,25,'ANITA GARIBALDI',NULL,8337,88590000,'SC','4201000',1,'2006-11-12 16:56:30'),(4407,NULL,1,25,'ANITPOLIS',NULL,8338,88475000,'SC','4201109',1,'2006-11-12 16:56:30'),(4408,NULL,1,25,'ANTNIO CARLOS',NULL,8340,88180000,'SC','4201208',1,'2006-11-12 16:56:30'),(4409,NULL,1,25,'APINA',NULL,8341,89135000,'SC','4201257',1,'2006-11-12 16:56:30'),(4410,NULL,1,25,'ARABUT',NULL,8342,89740000,'SC','4201273',1,'2006-11-12 16:56:30'),(4411,NULL,1,25,'ARAQUARI',NULL,8343,89245000,'SC','4201307',1,'2006-11-12 16:56:30'),(4412,NULL,1,25,'ARARANGU',NULL,8344,88900000,'SC','4201406',1,'2006-11-12 16:56:30'),(4413,NULL,1,25,'ARMAZM',NULL,8345,88740000,'SC','4201505',1,'2006-11-12 16:56:31'),(4414,NULL,1,25,'ARROIO TRINTA',NULL,8347,89590000,'SC','4201604',1,'2006-11-12 16:56:31'),(4415,NULL,1,25,'ARVOREDO',NULL,8348,89778000,'SC','4201653',1,'2006-11-12 16:56:31'),(4416,NULL,1,25,'ASCURRA',NULL,8349,89138000,'SC','4201703',1,'2006-11-12 16:56:31'),(4417,NULL,1,25,'ATALANTA',NULL,8350,88410000,'SC','4201802',1,'2006-11-12 16:56:31'),(4418,NULL,1,25,'AURORA',NULL,8352,89186000,'SC','4201901',1,'2006-11-12 16:56:31'),(4419,NULL,1,25,'BALNERIO ARROIO DO SILVA',NULL,8355,88914000,'SC','4201950',1,'2006-11-12 16:56:31'),(4420,NULL,1,25,'BALNERIO BARRA DO SUL',NULL,8356,89247000,'SC','4202057',1,'2006-11-12 16:56:31'),(4421,NULL,1,25,'BALNERIO CAMBORI',NULL,8357,88330000,'SC','4202008',1,'2006-11-12 16:56:31'),(4422,NULL,1,25,'BALNERIO GAIVOTA',NULL,8358,88955000,'SC','4202073',1,'2006-11-12 16:56:31'),(4423,NULL,1,25,'BANDEIRANTE',NULL,8360,89905000,'SC','4202081',1,'2006-11-12 16:56:31'),(4424,NULL,1,25,'BARRA BONITA',NULL,8361,89909000,'SC','4202099',1,'2006-11-12 16:56:31'),(4425,NULL,1,25,'BARRA VELHA',NULL,8367,88390000,'SC','4202107',1,'2006-11-12 16:56:31'),(4426,NULL,1,25,'BELA VISTA DO TOLDO',NULL,8373,89478000,'SC','4202131',1,'2006-11-12 16:56:31'),(4427,NULL,1,25,'BELMONTE',NULL,8374,89925000,'SC','4202156',1,'2006-11-12 16:56:31'),(4428,NULL,1,25,'BENEDITO NOVO',NULL,8375,89124000,'SC','4202206',1,'2006-11-12 16:56:31'),(4429,NULL,1,25,'BIGUAU',NULL,8376,88160000,'SC','4202305',1,'2006-11-12 16:56:31'),(4430,NULL,1,25,'BLUMENAU',NULL,8377,NULL,'SC','4202404',1,'2006-11-12 16:56:31'),(4431,NULL,1,25,'BOCANA DO SUL',NULL,8378,88538000,'SC','4202438',1,'2006-11-12 16:56:31'),(4432,NULL,1,25,'BOM JARDIM DA SERRA',NULL,8380,88640000,'SC','4202503',1,'2006-11-12 16:56:31'),(4433,NULL,1,25,'BOM JESUS',NULL,8381,89824000,'SC','4202537',1,'2006-11-12 16:56:31'),(4434,NULL,1,25,'BOM JESUS DO OESTE',NULL,8382,89873000,'SC','4202578',1,'2006-11-12 16:56:31'),(4435,NULL,1,25,'BOM RETIRO',NULL,8383,88680000,'SC','4202602',1,'2006-11-12 16:56:31'),(4436,NULL,1,25,'BOMBINHAS',NULL,8385,88215000,'SC','4202453',1,'2006-11-12 16:56:32'),(4437,NULL,1,25,'BOTUVER',NULL,8386,88370000,'SC','4202701',1,'2006-11-12 16:56:32'),(4438,NULL,1,25,'BRAO DO NORTE',NULL,8387,88750000,'SC','4202800',1,'2006-11-12 16:56:32'),(4439,NULL,1,25,'BRAO DO TROMBUDO',NULL,8388,89178000,'SC','4202859',1,'2006-11-12 16:56:32'),(4440,NULL,1,25,'BRUNPOLIS',NULL,8389,89634000,'SC','4202875',1,'2006-11-12 16:56:32'),(4441,NULL,1,25,'BRUSQUE',NULL,8390,NULL,'SC','4202909',1,'2006-11-12 16:56:32'),(4442,NULL,1,25,'CAADOR',NULL,8391,89500000,'SC','4203006',1,'2006-11-12 16:56:32'),(4443,NULL,1,25,'CAIBI',NULL,8394,89888000,'SC','4203105',1,'2006-11-12 16:56:32'),(4444,NULL,1,25,'CALMON',NULL,8395,89430000,'SC','4203154',1,'2006-11-12 16:56:32'),(4445,NULL,1,25,'CAMBORI',NULL,8396,88340000,'SC','4203204',1,'2006-11-12 16:56:32'),(4446,NULL,1,25,'CAMPO ALEGRE',NULL,8400,89294000,'SC','4203303',1,'2006-11-12 16:56:32'),(4447,NULL,1,25,'CAMPO BELO DO SUL',NULL,8401,88580000,'SC','4203402',1,'2006-11-12 16:56:32'),(4448,NULL,1,25,'CAMPO ER',NULL,8402,89980000,'SC','4203501',1,'2006-11-12 16:56:32'),(4449,NULL,1,25,'CAMPOS NOVOS',NULL,8403,89620000,'SC','4203600',1,'2006-11-12 16:56:32'),(4450,NULL,1,25,'CANELINHA',NULL,8405,88230000,'SC','4203709',1,'2006-11-12 16:56:32'),(4451,NULL,1,25,'CANOINHAS',NULL,8407,89460000,'SC','4203808',1,'2006-11-12 16:56:32'),(4452,NULL,1,25,'CAPO ALTO',NULL,8408,88548000,'SC','4203253',1,'2006-11-12 16:56:32'),(4453,NULL,1,25,'CAPINZAL',NULL,8409,89665000,'SC','4203907',1,'2006-11-12 16:56:32'),(4454,NULL,1,25,'CAPIVARI DE BAIXO',NULL,8410,88745000,'SC','4203956',1,'2006-11-12 16:56:32'),(4455,NULL,1,25,'CATANDUVAS',NULL,8412,89670000,'SC','4204004',1,'2006-11-12 16:56:32'),(4456,NULL,1,25,'CAXAMBU DO SUL',NULL,8414,89880000,'SC','4204103',1,'2006-11-12 16:56:32'),(4457,NULL,1,25,'CELSO RAMOS',NULL,8416,88598000,'SC','4204152',1,'2006-11-12 16:56:32'),(4458,NULL,1,25,'CERRO NEGRO',NULL,8417,88585000,'SC','4204178',1,'2006-11-12 16:56:33'),(4459,NULL,1,25,'CHAPADO DO LAGEADO',NULL,8418,88407000,'SC','4204194',1,'2006-11-12 16:56:33'),(4460,NULL,1,25,'CHAPEC',NULL,8419,NULL,'SC','4204202',1,'2006-11-12 16:56:33'),(4461,NULL,1,25,'COCAL DO SUL',NULL,8421,88845000,'SC','4204251',1,'2006-11-12 16:56:33'),(4462,NULL,1,25,'CONCRDIA',NULL,8424,89700000,'SC','4204301',1,'2006-11-12 16:56:33'),(4463,NULL,1,25,'CORDILHEIRA ALTA',NULL,8425,89819000,'SC','4204350',1,'2006-11-12 16:56:33'),(4464,NULL,1,25,'CORONEL FREITAS',NULL,8426,89840000,'SC','4204400',1,'2006-11-12 16:56:33'),(4465,NULL,1,25,'CORONEL MARTINS',NULL,8427,89837000,'SC','4204459',1,'2006-11-12 16:56:33'),(4466,NULL,1,25,'CORREIA PINTO',NULL,8428,88535000,'SC','4204558',1,'2006-11-12 16:56:33'),(4467,NULL,1,25,'CORUP',NULL,8429,89280000,'SC','4204509',1,'2006-11-12 16:56:33'),(4468,NULL,1,25,'CRICIMA',NULL,8430,NULL,'SC','4204608',1,'2006-11-12 16:56:33'),(4469,NULL,1,25,'CUNHA POR',NULL,8431,89890000,'SC','4204707',1,'2006-11-12 16:56:33'),(4470,NULL,1,25,'CUNHATA',NULL,8432,89886000,'SC','4204756',1,'2006-11-12 16:56:33'),(4471,NULL,1,25,'CURITIBANOS',NULL,8433,89520000,'SC','4204806',1,'2006-11-12 16:56:33'),(4472,NULL,1,25,'DESCANSO',NULL,8436,89910000,'SC','4204905',1,'2006-11-12 16:56:33'),(4473,NULL,1,25,'DIONSIO CERQUEIRA',NULL,8437,89950000,'SC','4205001',1,'2006-11-12 16:56:33'),(4474,NULL,1,25,'DONA EMMA',NULL,8438,89155000,'SC','4205100',1,'2006-11-12 16:56:33'),(4475,NULL,1,25,'DOUTOR PEDRINHO',NULL,8439,89126000,'SC','4205159',1,'2006-11-12 16:56:33'),(4476,NULL,1,25,'ENTRE RIOS',NULL,8442,89862000,'SC','4205175',1,'2006-11-12 16:56:33'),(4477,NULL,1,25,'ERMO',NULL,8443,88935000,'SC','4205191',1,'2006-11-12 16:56:33'),(4478,NULL,1,25,'ERVAL VELHO',NULL,8444,89613000,'SC','4205209',1,'2006-11-12 16:56:33'),(4479,NULL,1,25,'FAXINAL DOS GUEDES',NULL,8447,89694000,'SC','4205308',1,'2006-11-12 16:56:33'),(4480,NULL,1,25,'FLOR DO SERTO',NULL,8451,89878000,'SC','4205357',1,'2006-11-12 16:56:33'),(4481,NULL,1,25,'FLORIANPOLIS',NULL,8452,NULL,'SC','4205407',1,'2006-11-12 16:56:34'),(4482,NULL,1,25,'FORMOSA DO SUL',NULL,8453,89859000,'SC','4205431',1,'2006-11-12 16:56:34'),(4483,NULL,1,25,'FORQUILHINHA',NULL,8454,88850000,'SC','4205456',1,'2006-11-12 16:56:34'),(4484,NULL,1,25,'FRAIBURGO',NULL,8456,89580000,'SC','4205506',1,'2006-11-12 16:56:34'),(4485,NULL,1,25,'FREI ROGRIO',NULL,8458,89530000,'SC','4205555',1,'2006-11-12 16:56:34'),(4486,NULL,1,25,'GALVO',NULL,8459,89838000,'SC','4205605',1,'2006-11-12 16:56:34'),(4487,NULL,1,25,'GAROPABA',NULL,8461,88495000,'SC','4205704',1,'2006-11-12 16:56:34'),(4488,NULL,1,25,'GARUVA',NULL,8462,89248000,'SC','4205803',1,'2006-11-12 16:56:34'),(4489,NULL,1,25,'GASPAR',NULL,8463,89110000,'SC','4205902',1,'2006-11-12 16:56:34'),(4490,NULL,1,25,'GOVERNADOR CELSO RAMOS',NULL,8465,88190000,'SC','4206009',1,'2006-11-12 16:56:34'),(4491,NULL,1,25,'GRO PAR',NULL,8466,88890000,'SC','4206108',1,'2006-11-12 16:56:34'),(4492,NULL,1,25,'GRAVATAL',NULL,8468,88735000,'SC','4206207',1,'2006-11-12 16:56:34'),(4493,NULL,1,25,'GUABIRUBA',NULL,8469,88360000,'SC','4206306',1,'2006-11-12 16:56:34'),(4494,NULL,1,25,'GUARACIABA',NULL,8471,89920000,'SC','4206405',1,'2006-11-12 16:56:34'),(4495,NULL,1,25,'GUARAMIRIM',NULL,8472,89270000,'SC','4206504',1,'2006-11-12 16:56:34'),(4496,NULL,1,25,'GUARUJ DO SUL',NULL,8473,89940000,'SC','4206603',1,'2006-11-12 16:56:34'),(4497,NULL,1,25,'GUATAMB',NULL,8475,89817000,'SC','4206652',1,'2006-11-12 16:56:34'),(4498,NULL,1,25,'HERVAL D\' OESTE',NULL,8478,89610000,'SC',NULL,1,'2006-11-12 16:56:34'),(4499,NULL,1,25,'IBIAM',NULL,8479,89652000,'SC','4206751',1,'2006-11-12 16:56:34'),(4500,NULL,1,25,'IBICAR',NULL,8480,89640000,'SC','4206801',1,'2006-11-12 16:56:34'),(4501,NULL,1,25,'IBIRAMA',NULL,8482,89140000,'SC','4206900',1,'2006-11-12 16:56:35'),(4502,NULL,1,25,'IARA',NULL,8483,88820000,'SC','4207007',1,'2006-11-12 16:56:35'),(4503,NULL,1,25,'ILHOTA',NULL,8484,88320000,'SC','4207106',1,'2006-11-12 16:56:35'),(4504,NULL,1,25,'IMARU',NULL,8485,88770000,'SC','4207205',1,'2006-11-12 16:56:35'),(4505,NULL,1,25,'IMBITUBA',NULL,8486,88780000,'SC','4207304',1,'2006-11-12 16:56:35'),(4506,NULL,1,25,'IMBUIA',NULL,8487,88440000,'SC','4207403',1,'2006-11-12 16:56:35'),(4507,NULL,1,25,'INDAIAL',NULL,8488,89130000,'SC','4207502',1,'2006-11-12 16:56:35'),(4508,NULL,1,25,'IOMER',NULL,8492,89558000,'SC','4207577',1,'2006-11-12 16:56:35'),(4509,NULL,1,25,'IPIRA',NULL,8493,89669000,'SC','4207601',1,'2006-11-12 16:56:35'),(4510,NULL,1,25,'IPOR DO OESTE',NULL,8495,89899000,'SC','4207650',1,'2006-11-12 16:56:35'),(4511,NULL,1,25,'IPUAU',NULL,8496,89832000,'SC','4207684',1,'2006-11-12 16:56:35'),(4512,NULL,1,25,'IPUMIRIM',NULL,8497,89790000,'SC','4207700',1,'2006-11-12 16:56:35'),(4513,NULL,1,25,'IRACEMINHA',NULL,8498,89891000,'SC','4207759',1,'2006-11-12 16:56:35'),(4514,NULL,1,25,'IRANI',NULL,8500,89680000,'SC','4207809',1,'2006-11-12 16:56:35'),(4515,NULL,1,25,'IRATI',NULL,8502,89856000,'SC','4207858',1,'2006-11-12 16:56:35'),(4516,NULL,1,25,'IRINEPOLIS',NULL,8503,89440000,'SC','4207908',1,'2006-11-12 16:56:35'),(4517,NULL,1,25,'IT',NULL,8504,89760000,'SC','4208005',1,'2006-11-12 16:56:35'),(4518,NULL,1,25,'ITAIPOLIS',NULL,8506,89340000,'SC','4208104',1,'2006-11-12 16:56:35'),(4519,NULL,1,25,'ITAJA',NULL,8507,NULL,'SC','4208203',1,'2006-11-12 16:56:35'),(4520,NULL,1,25,'ITAPEMA',NULL,8509,88220000,'SC','4208302',1,'2006-11-12 16:56:35'),(4521,NULL,1,25,'ITAPIRANGA',NULL,8510,89896000,'SC','4208401',1,'2006-11-12 16:56:35'),(4522,NULL,1,25,'ITAPO',NULL,8511,89249000,'SC','4208450',1,'2006-11-12 16:56:35'),(4523,NULL,1,25,'ITUPORANGA',NULL,8514,88400000,'SC','4208500',1,'2006-11-12 16:56:36'),(4524,NULL,1,25,'JABOR',NULL,8515,89677000,'SC','4208609',1,'2006-11-12 16:56:36'),(4525,NULL,1,25,'JACINTO MACHADO',NULL,8516,88950000,'SC','4208708',1,'2006-11-12 16:56:36'),(4526,NULL,1,25,'JAGUARUNA',NULL,8517,88715000,'SC','4208807',1,'2006-11-12 16:56:36'),(4527,NULL,1,25,'JARAGU DO SUL',NULL,8518,NULL,'SC','4208906',1,'2006-11-12 16:56:36'),(4528,NULL,1,25,'JARDINPOLIS',NULL,8519,89848000,'SC','4208955',1,'2006-11-12 16:56:36'),(4529,NULL,1,25,'JOAABA',NULL,8520,89600000,'SC','4209003',1,'2006-11-12 16:56:36'),(4530,NULL,1,25,'JOINVILLE',NULL,8521,NULL,'SC','4209102',1,'2006-11-12 16:56:36'),(4531,NULL,1,25,'JOS BOITEUX',NULL,8522,89145000,'SC','4209151',1,'2006-11-12 16:56:36'),(4532,NULL,1,25,'JUPI',NULL,8523,89839000,'SC','4209177',1,'2006-11-12 16:56:36'),(4533,NULL,1,25,'LACERDPOLIS',NULL,8524,89660000,'SC','4209201',1,'2006-11-12 16:56:36'),(4534,NULL,1,25,'LAGES',NULL,8525,NULL,'SC','4209300',1,'2006-11-12 16:56:36'),(4535,NULL,1,25,'LAGUNA',NULL,8528,88790000,'SC','4209409',1,'2006-11-12 16:56:36'),(4536,NULL,1,25,'LAJEADO GRANDE',NULL,8529,89828000,'SC','4209458',1,'2006-11-12 16:56:36'),(4537,NULL,1,25,'LAURENTINO',NULL,8530,89170000,'SC','4209508',1,'2006-11-12 16:56:36'),(4538,NULL,1,25,'LAURO MLLER',NULL,8531,88880000,'SC',NULL,1,'2006-11-12 16:56:36'),(4539,NULL,1,25,'LEBON RGIS',NULL,8533,89515000,'SC','4209706',1,'2006-11-12 16:56:36'),(4540,NULL,1,25,'LEOBERTO LEAL',NULL,8534,88445000,'SC','4209805',1,'2006-11-12 16:56:36'),(4541,NULL,1,25,'LINDIA DO SUL',NULL,8535,89735000,'SC','4209854',1,'2006-11-12 16:56:37'),(4542,NULL,1,25,'LONTRAS',NULL,8537,89182000,'SC','4209904',1,'2006-11-12 16:56:37'),(4543,NULL,1,25,'LUIZ ALVES',NULL,8539,89115000,'SC','4210001',1,'2006-11-12 16:56:37'),(4544,NULL,1,25,'LUZERNA',NULL,8540,89609000,'SC','4210035',1,'2006-11-12 16:56:37'),(4545,NULL,1,25,'MACIEIRA',NULL,8542,89518000,'SC','4210050',1,'2006-11-12 16:56:37'),(4546,NULL,1,25,'MAFRA',NULL,8543,89300000,'SC','4210100',1,'2006-11-12 16:56:37'),(4547,NULL,1,25,'MAJOR GERCINO',NULL,8544,88260000,'SC','4210209',1,'2006-11-12 16:56:37'),(4548,NULL,1,25,'MAJOR VIEIRA',NULL,8545,89480000,'SC','4210308',1,'2006-11-12 16:56:37'),(4549,NULL,1,25,'MARACAJ',NULL,8546,88915000,'SC','4210407',1,'2006-11-12 16:56:37'),(4550,NULL,1,25,'MARAVILHA',NULL,8549,89874000,'SC','4210506',1,'2006-11-12 16:56:37'),(4551,NULL,1,25,'MAREMA',NULL,8552,89860000,'SC','4210555',1,'2006-11-12 16:56:37'),(4552,NULL,1,25,'MASSARANDUBA',NULL,8556,89108000,'SC','4210605',1,'2006-11-12 16:56:37'),(4553,NULL,1,25,'MATOS COSTA',NULL,8557,89420000,'SC','4210704',1,'2006-11-12 16:56:37'),(4554,NULL,1,25,'MELEIRO',NULL,8558,88920000,'SC','4210803',1,'2006-11-12 16:56:37'),(4555,NULL,1,25,'MIRIM DOCE',NULL,8561,89194000,'SC','4210852',1,'2006-11-12 16:56:37'),(4556,NULL,1,25,'MODELO',NULL,8562,89872000,'SC','4210902',1,'2006-11-12 16:56:37'),(4557,NULL,1,25,'MONDA',NULL,8563,89893000,'SC','4211009',1,'2006-11-12 16:56:37'),(4558,NULL,1,25,'MONTE CARLO',NULL,8565,89618000,'SC','4211058',1,'2006-11-12 16:56:37'),(4559,NULL,1,25,'MONTE CASTELO',NULL,8566,89380000,'SC','4211108',1,'2006-11-12 16:56:37'),(4560,NULL,1,25,'MORRO DA FUMAA',NULL,8568,88830000,'SC','4211207',1,'2006-11-12 16:56:37'),(4561,NULL,1,25,'MORRO GRANDE',NULL,8570,88925000,'SC','4211256',1,'2006-11-12 16:56:37'),(4562,NULL,1,25,'NAVEGANTES',NULL,8571,88375000,'SC','4211306',1,'2006-11-12 16:56:38'),(4563,NULL,1,25,'NOVA ERECHIM',NULL,8574,89865000,'SC','4211405',1,'2006-11-12 16:56:38'),(4564,NULL,1,25,'NOVA ITABERABA',NULL,8576,89818000,'SC','4211454',1,'2006-11-12 16:56:38'),(4565,NULL,1,25,'NOVA TRENTO',NULL,8579,88270000,'SC','4211504',1,'2006-11-12 16:56:38'),(4566,NULL,1,25,'NOVA VENEZA',NULL,8580,88865000,'SC','4211603',1,'2006-11-12 16:56:38'),(4567,NULL,1,25,'NOVO HORIZONTE',NULL,8581,89998000,'SC','4211652',1,'2006-11-12 16:56:38'),(4568,NULL,1,25,'ORLEANS',NULL,8582,88870000,'SC','4211702',1,'2006-11-12 16:56:38'),(4569,NULL,1,25,'OTACLIO COSTA',NULL,8583,88540000,'SC','4211751',1,'2006-11-12 16:56:38'),(4570,NULL,1,25,'OURO',NULL,8584,89663000,'SC','4211801',1,'2006-11-12 16:56:38'),(4571,NULL,1,25,'OURO VERDE',NULL,8585,89834000,'SC','4211850',1,'2006-11-12 16:56:38'),(4572,NULL,1,25,'PAIAL',NULL,8587,89765000,'SC','4211876',1,'2006-11-12 16:56:38'),(4573,NULL,1,25,'PAINEL',NULL,8588,88543000,'SC','4211892',1,'2006-11-12 16:56:38'),(4574,NULL,1,25,'PALHOA',NULL,8589,NULL,'SC','4211900',1,'2006-11-12 16:56:38'),(4575,NULL,1,25,'PALMA SOLA',NULL,8590,89985000,'SC','4212007',1,'2006-11-12 16:56:38'),(4576,NULL,1,25,'PALMEIRA',NULL,8591,88545000,'SC','4212056',1,'2006-11-12 16:56:38'),(4577,NULL,1,25,'PALMITOS',NULL,8592,89887000,'SC','4212106',1,'2006-11-12 16:56:38'),(4578,NULL,1,25,'PAPANDUVA',NULL,8594,89370000,'SC','4212205',1,'2006-11-12 16:56:38'),(4579,NULL,1,25,'PARASO',NULL,8595,89906000,'SC','4212239',1,'2006-11-12 16:56:38'),(4580,NULL,1,25,'PASSO DE TORRES',NULL,8596,88980000,'SC','4212254',1,'2006-11-12 16:56:38'),(4581,NULL,1,25,'PASSOS MAIA',NULL,8598,89687000,'SC','4212270',1,'2006-11-12 16:56:38'),(4582,NULL,1,25,'PAULO LOPES',NULL,8600,88490000,'SC','4212304',1,'2006-11-12 16:56:38'),(4583,NULL,1,25,'PEDRAS GRANDES',NULL,8601,88720000,'SC','4212403',1,'2006-11-12 16:56:38'),(4584,NULL,1,25,'PENHA',NULL,8602,88385000,'SC','4212502',1,'2006-11-12 16:56:39'),(4585,NULL,1,25,'PERITIBA',NULL,8604,89750000,'SC','4212601',1,'2006-11-12 16:56:39'),(4586,NULL,1,25,'PETROLNDIA',NULL,8606,88430000,'SC','4212700',1,'2006-11-12 16:56:39'),(4587,NULL,1,25,'PIARRAS',NULL,8607,88380000,'SC',NULL,1,'2006-11-12 16:56:39'),(4588,NULL,1,25,'PINHALZINHO',NULL,8609,89870000,'SC','4212908',1,'2006-11-12 16:56:39'),(4589,NULL,1,25,'PINHEIRO PRETO',NULL,8611,89570000,'SC','4213005',1,'2006-11-12 16:56:39'),(4590,NULL,1,25,'PIRATUBA',NULL,8614,89667000,'SC','4213104',1,'2006-11-12 16:56:39'),(4591,NULL,1,25,'PLANALTO ALEGRE',NULL,8616,89882000,'SC','4213153',1,'2006-11-12 16:56:39'),(4592,NULL,1,25,'POMERODE',NULL,8618,89107000,'SC','4213203',1,'2006-11-12 16:56:39'),(4593,NULL,1,25,'PONTE ALTA',NULL,8619,88550000,'SC','4213302',1,'2006-11-12 16:56:39'),(4594,NULL,1,25,'PONTE ALTA DO NORTE',NULL,8620,89535000,'SC','4213351',1,'2006-11-12 16:56:39'),(4595,NULL,1,25,'PONTE SERRADA',NULL,8621,89683000,'SC','4213401',1,'2006-11-12 16:56:39'),(4596,NULL,1,25,'PORTO BELO',NULL,8622,88210000,'SC','4213500',1,'2006-11-12 16:56:39'),(4597,NULL,1,25,'PORTO UNIO',NULL,8623,89400000,'SC','4213609',1,'2006-11-12 16:56:39'),(4598,NULL,1,25,'POUSO REDONDO',NULL,8624,89172000,'SC','4213708',1,'2006-11-12 16:56:39'),(4599,NULL,1,25,'PRAIA GRANDE',NULL,8625,88990000,'SC','4213807',1,'2006-11-12 16:56:39'),(4600,NULL,1,25,'PRESIDENTE CASTELO BRANCO',NULL,8627,89745000,'SC',NULL,1,'2006-11-12 16:56:39'),(4601,NULL,1,25,'PRESIDENTE GETLIO',NULL,8628,89150000,'SC','4214003',1,'2006-11-12 16:56:39'),(4602,NULL,1,25,'PRESIDENTE NEREU',NULL,8631,89184000,'SC','4214102',1,'2006-11-12 16:56:39'),(4603,NULL,1,25,'PRINCESA',NULL,8632,89935000,'SC','4214151',1,'2006-11-12 16:56:39'),(4604,NULL,1,25,'QUILOMBO',NULL,8634,89850000,'SC','4214201',1,'2006-11-12 16:56:39'),(4605,NULL,1,25,'RANCHO QUEIMADO',NULL,8636,88470000,'SC','4214300',1,'2006-11-12 16:56:39'),(4606,NULL,1,25,'RIO DAS ANTAS',NULL,8646,89550000,'SC','4214409',1,'2006-11-12 16:56:40'),(4607,NULL,1,25,'RIO DO CAMPO',NULL,8648,89198000,'SC','4214508',1,'2006-11-12 16:56:40'),(4608,NULL,1,25,'RIO DO OESTE',NULL,8649,89180000,'SC','4214607',1,'2006-11-12 16:56:40'),(4609,NULL,1,25,'RIO DO SUL',NULL,8650,89160000,'SC','4214805',1,'2006-11-12 16:56:40'),(4610,NULL,1,25,'RIO DOS CEDROS',NULL,8652,89121000,'SC','4214706',1,'2006-11-12 16:56:40'),(4611,NULL,1,25,'RIO FORTUNA',NULL,8653,88760000,'SC','4214904',1,'2006-11-12 16:56:40'),(4612,NULL,1,25,'RIO NEGRINHO',NULL,8655,89295000,'SC','4215000',1,'2006-11-12 16:56:40'),(4613,NULL,1,25,'RIO RUFINO',NULL,8657,88658000,'SC','4215059',1,'2006-11-12 16:56:40'),(4614,NULL,1,25,'RIQUEZA',NULL,8658,89895000,'SC','4215075',1,'2006-11-12 16:56:40'),(4615,NULL,1,25,'RODEIO',NULL,8659,89136000,'SC','4215109',1,'2006-11-12 16:56:40'),(4616,NULL,1,25,'ROMELNDIA',NULL,8660,89908000,'SC','4215208',1,'2006-11-12 16:56:40'),(4617,NULL,1,25,'SALETE',NULL,8662,89196000,'SC','4215307',1,'2006-11-12 16:56:40'),(4618,NULL,1,25,'SALTINHO',NULL,8663,89981000,'SC','4215356',1,'2006-11-12 16:56:40'),(4619,NULL,1,25,'SALTO VELOSO',NULL,8664,89595000,'SC','4215406',1,'2006-11-12 16:56:40'),(4620,NULL,1,25,'SANGO',NULL,8666,88717000,'SC','4215455',1,'2006-11-12 16:56:40'),(4621,NULL,1,25,'SANTA CECLIA',NULL,8667,89540000,'SC','4215505',1,'2006-11-12 16:56:40'),(4622,NULL,1,25,'SANTA HELENA',NULL,8669,89915000,'SC','4215554',1,'2006-11-12 16:56:40'),(4623,NULL,1,25,'SANTA ROSA DE LIMA',NULL,8675,88763000,'SC','4215604',1,'2006-11-12 16:56:40'),(4624,NULL,1,25,'SANTA ROSA DO SUL',NULL,8676,88965000,'SC','4215653',1,'2006-11-12 16:56:40'),(4625,NULL,1,25,'SANTA TEREZINHA',NULL,8677,89199000,'SC','4215679',1,'2006-11-12 16:56:40'),(4626,NULL,1,25,'SANTA TEREZINHA DO PROGRESSO',NULL,8678,89983000,'SC','4215687',1,'2006-11-12 16:56:40'),(4627,NULL,1,25,'SANTIAGO DO SUL',NULL,8680,89854000,'SC','4215695',1,'2006-11-12 16:56:40'),(4628,NULL,1,25,'SANTO AMARO DA IMPERATRIZ',NULL,8681,88140000,'SC','4215703',1,'2006-11-12 16:56:41'),(4629,NULL,1,25,'SO BENTO DO SUL',NULL,8684,89290000,'SC','4215802',1,'2006-11-12 16:56:41'),(4630,NULL,1,25,'SO BERNARDINO',NULL,8685,89982000,'SC','4215752',1,'2006-11-12 16:56:41'),(4631,NULL,1,25,'SO BONIFCIO',NULL,8686,88485000,'SC','4215901',1,'2006-11-12 16:56:41'),(4632,NULL,1,25,'SO CARLOS',NULL,8687,89885000,'SC','4216008',1,'2006-11-12 16:56:41'),(4633,NULL,1,25,'SO CRISTVO DO SUL',NULL,8689,89533000,'SC','4216057',1,'2006-11-12 16:56:41'),(4634,NULL,1,25,'SO DOMINGOS',NULL,8691,89835000,'SC','4216107',1,'2006-11-12 16:56:41'),(4635,NULL,1,25,'SO FRANCISCO DO SUL',NULL,8692,89240000,'SC','4216206',1,'2006-11-12 16:56:41'),(4636,NULL,1,25,'SO JOO BATISTA',NULL,8694,88240000,'SC','4216305',1,'2006-11-12 16:56:41'),(4637,NULL,1,25,'SO JOO DO ITAPERI',NULL,8695,88395000,'SC','4216354',1,'2006-11-12 16:56:41'),(4638,NULL,1,25,'SO JOO DO OESTE',NULL,8696,89897000,'SC','4216255',1,'2006-11-12 16:56:41'),(4639,NULL,1,25,'SO JOO DO SUL',NULL,8698,88970000,'SC','4216404',1,'2006-11-12 16:56:41'),(4640,NULL,1,25,'SO JOAQUIM',NULL,8699,88600000,'SC','4216503',1,'2006-11-12 16:56:41'),(4641,NULL,1,25,'SO JOS',NULL,8700,NULL,'SC','4216602',1,'2006-11-12 16:56:41'),(4642,NULL,1,25,'SO JOS DO CEDRO',NULL,8701,89930000,'SC','4216701',1,'2006-11-12 16:56:41'),(4643,NULL,1,25,'SO JOS DO CERRITO',NULL,8702,88570000,'SC','4216800',1,'2006-11-12 16:56:41'),(4644,NULL,1,25,'SO LOURENO DO OESTE',NULL,8705,89990000,'SC','4216909',1,'2006-11-12 16:56:41'),(4645,NULL,1,25,'SO LUDGERO',NULL,8706,88730000,'SC','4217006',1,'2006-11-12 16:56:41'),(4646,NULL,1,25,'SO MARTINHO',NULL,8707,88765000,'SC','4217105',1,'2006-11-12 16:56:41'),(4647,NULL,1,25,'SO MIGUEL DO OESTE',NULL,8708,89900000,'SC','4217204',1,'2006-11-12 16:56:41'),(4648,NULL,1,25,'SO MIGUEL DA BOA VISTA',NULL,8709,89879000,'SC','4217154',1,'2006-11-12 16:56:41'),(4649,NULL,1,25,'SO PEDRO DE ALCNTARA',NULL,8711,88125000,'SC','4217253',1,'2006-11-12 16:56:42'),(4650,NULL,1,25,'SAUDADES',NULL,8717,89868000,'SC','4217303',1,'2006-11-12 16:56:42'),(4651,NULL,1,25,'SCHROEDER',NULL,8718,89275000,'SC','4217402',1,'2006-11-12 16:56:42'),(4652,NULL,1,25,'SEARA',NULL,8719,89770000,'SC','4217501',1,'2006-11-12 16:56:42'),(4653,NULL,1,25,'SERRA ALTA',NULL,8721,89871000,'SC','4217550',1,'2006-11-12 16:56:42'),(4654,NULL,1,25,'SIDERPOLIS',NULL,8723,88860000,'SC','4217600',1,'2006-11-12 16:56:42'),(4655,NULL,1,25,'SOMBRIO',NULL,8724,88960000,'SC','4217709',1,'2006-11-12 16:56:42'),(4656,NULL,1,25,'SUL BRASIL',NULL,8726,89855000,'SC','4217758',1,'2006-11-12 16:56:42'),(4657,NULL,1,25,'TAI',NULL,8727,89190000,'SC','4217808',1,'2006-11-12 16:56:42'),(4658,NULL,1,25,'TANGAR',NULL,8728,89642000,'SC','4217907',1,'2006-11-12 16:56:42'),(4659,NULL,1,25,'TIGRINHOS',NULL,8732,89875000,'SC','4217956',1,'2006-11-12 16:56:42'),(4660,NULL,1,25,'TIJUCAS',NULL,8733,88200000,'SC','4218004',1,'2006-11-12 16:56:42'),(4661,NULL,1,25,'TIMB DO SUL',NULL,8734,88940000,'SC','4218103',1,'2006-11-12 16:56:42'),(4662,NULL,1,25,'TIMB',NULL,8735,89120000,'SC','4218202',1,'2006-11-12 16:56:42'),(4663,NULL,1,25,'TIMB GRANDE',NULL,8736,89545000,'SC','4218251',1,'2006-11-12 16:56:42'),(4664,NULL,1,25,'TRS BARRAS',NULL,8737,89490000,'SC','4218301',1,'2006-11-12 16:56:42'),(4665,NULL,1,25,'TREVISO',NULL,8738,88862000,'SC','4218350',1,'2006-11-12 16:56:42'),(4666,NULL,1,25,'TREZE DE MAIO',NULL,8739,88710000,'SC','4218400',1,'2006-11-12 16:56:42'),(4667,NULL,1,25,'TREZE TLIAS',NULL,8740,89650000,'SC','4218509',1,'2006-11-12 16:56:42'),(4668,NULL,1,25,'TROMBUDO CENTRAL',NULL,8741,89176000,'SC','4218608',1,'2006-11-12 16:56:42'),(4669,NULL,1,25,'TUBARO',NULL,8742,NULL,'SC','4218707',1,'2006-11-12 16:56:42'),(4670,NULL,1,25,'TUNPOLIS',NULL,8743,89898000,'SC','4218756',1,'2006-11-12 16:56:42'),(4671,NULL,1,25,'TURVO',NULL,8745,88930000,'SC','4218806',1,'2006-11-12 16:56:43'),(4672,NULL,1,25,'UNIO DO OESTE',NULL,8746,89845000,'SC','4218855',1,'2006-11-12 16:56:43'),(4673,NULL,1,25,'URUBICI',NULL,8747,88650000,'SC','4218905',1,'2006-11-12 16:56:43'),(4674,NULL,1,25,'URUPEMA',NULL,8749,88625000,'SC','4218954',1,'2006-11-12 16:56:43'),(4675,NULL,1,25,'URUSSANGA',NULL,8750,88840000,'SC','4219002',1,'2006-11-12 16:56:43'),(4676,NULL,1,25,'VARGEO',NULL,8751,89690000,'SC','4219101',1,'2006-11-12 16:56:43'),(4677,NULL,1,25,'VARGEM',NULL,8752,89638000,'SC','4219150',1,'2006-11-12 16:56:43'),(4678,NULL,1,25,'VARGEM BONITA',NULL,8753,89675000,'SC','4219176',1,'2006-11-12 16:56:43'),(4679,NULL,1,25,'VIDAL RAMOS',NULL,8755,88443000,'SC','4219200',1,'2006-11-12 16:56:43'),(4680,NULL,1,25,'VIDEIRA',NULL,8756,89560000,'SC','4219309',1,'2006-11-12 16:56:43'),(4681,NULL,1,25,'VTOR MEIRELES',NULL,8761,89148000,'SC','4219358',1,'2006-11-12 16:56:43'),(4682,NULL,1,25,'WITMARSUM',NULL,8762,89157000,'SC','4219408',1,'2006-11-12 16:56:43'),(4683,NULL,1,25,'XANXER',NULL,8763,89820000,'SC','4219507',1,'2006-11-12 16:56:43'),(4684,NULL,1,25,'XAVANTINA',NULL,8764,89780000,'SC','4219606',1,'2006-11-12 16:56:43'),(4685,NULL,1,25,'XAXIM',NULL,8765,89825000,'SC','4219705',1,'2006-11-12 16:56:43'),(4686,NULL,1,25,'ZORTA',NULL,8766,89633000,'SC','4219853',1,'2006-11-12 16:56:43'),(4687,NULL,1,18,'AMPARO DE SO FRANCISCO',NULL,8768,49920000,'SE','2800100',1,'2006-11-12 16:56:43'),(4688,NULL,1,18,'AQUIDAB',NULL,8769,49790000,'SE','2800209',1,'2006-11-12 16:56:43'),(4689,NULL,1,18,'ARACAJU',NULL,8770,NULL,'SE','2800308',1,'2006-11-12 16:56:43'),(4690,NULL,1,18,'ARAU',NULL,8771,49220000,'SE','2800407',1,'2006-11-12 16:56:43'),(4691,NULL,1,18,'AREIA BRANCA',NULL,8772,49580000,'SE','2800506',1,'2006-11-12 16:56:43'),(4692,NULL,1,18,'BARRA DOS COQUEIROS',NULL,8774,49140000,'SE','2800605',1,'2006-11-12 16:56:43'),(4693,NULL,1,18,'BOQUIM',NULL,8776,49360000,'SE','2800670',1,'2006-11-12 16:56:43'),(4694,NULL,1,18,'BREJO GRANDE',NULL,8777,49995000,'SE','2800704',1,'2006-11-12 16:56:44'),(4695,NULL,1,18,'CAMPO DO BRITO',NULL,8778,49520000,'SE','2801009',1,'2006-11-12 16:56:44'),(4696,NULL,1,18,'CANHOBA',NULL,8779,49880000,'SE','2801108',1,'2006-11-12 16:56:44'),(4697,NULL,1,18,'CANIND DE SO FRANCISCO',NULL,8780,49820000,'SE','2801207',1,'2006-11-12 16:56:44'),(4698,NULL,1,18,'CAPELA',NULL,8781,49700000,'SE','2801306',1,'2006-11-12 16:56:44'),(4699,NULL,1,18,'CARIRA',NULL,8782,49550000,'SE','2801405',1,'2006-11-12 16:56:44'),(4700,NULL,1,18,'CARMPOLIS',NULL,8783,49740000,'SE','2801504',1,'2006-11-12 16:56:44'),(4701,NULL,1,18,'CEDRO DE SO JOO',NULL,8784,49930000,'SE','2801603',1,'2006-11-12 16:56:44'),(4702,NULL,1,18,'CRISTINPOLIS',NULL,8785,49270000,'SE','2801702',1,'2006-11-12 16:56:44'),(4703,NULL,1,18,'CUMBE',NULL,8786,49660000,'SE','2801900',1,'2006-11-12 16:56:44'),(4704,NULL,1,18,'DIVINA PASTORA',NULL,8787,49650000,'SE','2802007',1,'2006-11-12 16:56:44'),(4705,NULL,1,18,'ESTNCIA',NULL,8788,49200000,'SE','2802106',1,'2006-11-12 16:56:44'),(4706,NULL,1,18,'FEIRA NOVA',NULL,8789,49670000,'SE','2802205',1,'2006-11-12 16:56:44'),(4707,NULL,1,18,'FREI PAULO',NULL,8790,49514000,'SE','2802304',1,'2006-11-12 16:56:44'),(4708,NULL,1,18,'GARARU',NULL,8791,49830000,'SE','2802403',1,'2006-11-12 16:56:44'),(4709,NULL,1,18,'GENERAL MAYNARD',NULL,8792,49750000,'SE','2802502',1,'2006-11-12 16:56:44'),(4710,NULL,1,18,'GRACCHO CARDOSO',NULL,8793,49860000,'SE',NULL,1,'2006-11-12 16:56:44'),(4711,NULL,1,18,'ILHA DAS FLORES',NULL,8794,49990000,'SE','2802700',1,'2006-11-12 16:56:44'),(4712,NULL,1,18,'INDIAROBA',NULL,8795,49250000,'SE','2802809',1,'2006-11-12 16:56:44'),(4713,NULL,1,18,'ITABAIANA',NULL,8796,49500000,'SE','2802908',1,'2006-11-12 16:56:44'),(4714,NULL,1,18,'ITABAIANINHA',NULL,8797,49290000,'SE','2803005',1,'2006-11-12 16:56:44'),(4715,NULL,1,18,'ITABI',NULL,8798,49870000,'SE','2803104',1,'2006-11-12 16:56:44'),(4716,NULL,1,18,'ITAPORANGA D\'AJUDA',NULL,8799,49120000,'SE',NULL,1,'2006-11-12 16:56:45'),(4717,NULL,1,18,'JAPARATUBA',NULL,8800,49960000,'SE','2803302',1,'2006-11-12 16:56:45'),(4718,NULL,1,18,'JAPOAT',NULL,8801,49950000,'SE','2803401',1,'2006-11-12 16:56:45'),(4719,NULL,1,18,'LAGARTO',NULL,8802,49400000,'SE','2803500',1,'2006-11-12 16:56:45'),(4720,NULL,1,18,'LARANJEIRAS',NULL,8804,49170000,'SE','2803609',1,'2006-11-12 16:56:45'),(4721,NULL,1,18,'MACAMBIRA',NULL,8805,49565000,'SE','2803708',1,'2006-11-12 16:56:45'),(4722,NULL,1,18,'MALHADA DOS BOIS',NULL,8806,49940000,'SE','2803807',1,'2006-11-12 16:56:45'),(4723,NULL,1,18,'MALHADOR',NULL,8807,49570000,'SE','2803906',1,'2006-11-12 16:56:45'),(4724,NULL,1,18,'MARUIM',NULL,8808,49770000,'SE','2804003',1,'2006-11-12 16:56:45'),(4725,NULL,1,18,'MOITA BONITA',NULL,8810,49560000,'SE','2804102',1,'2006-11-12 16:56:45'),(4726,NULL,1,18,'MONTE ALEGRE DE SERGIPE',NULL,8811,49690000,'SE','2804201',1,'2006-11-12 16:56:45'),(4727,NULL,1,18,'MURIBECA',NULL,8813,49780000,'SE','2804300',1,'2006-11-12 16:56:45'),(4728,NULL,1,18,'NEPOLIS',NULL,8814,49980000,'SE','2804409',1,'2006-11-12 16:56:45'),(4729,NULL,1,18,'NOSSA SENHORA APARECIDA',NULL,8815,49540000,'SE','2804458',1,'2006-11-12 16:56:45'),(4730,NULL,1,18,'NOSSA SENHORA DA GLRIA',NULL,8816,49680000,'SE','2804508',1,'2006-11-12 16:56:45'),(4731,NULL,1,18,'NOSSA SENHORA DAS DORES',NULL,8817,49600000,'SE','2804607',1,'2006-11-12 16:56:45'),(4732,NULL,1,18,'NOSSA SENHORA DE LOURDES',NULL,8818,49890000,'SE','2804706',1,'2006-11-12 16:56:45'),(4733,NULL,1,18,'NOSSA SENHORA DO SOCORRO',NULL,8819,49160000,'SE','2804805',1,'2006-11-12 16:56:45'),(4734,NULL,1,18,'PACATUBA',NULL,8820,49970000,'SE','2804904',1,'2006-11-12 16:56:45'),(4735,NULL,1,18,'PEDRA MOLE',NULL,8822,49512000,'SE','2805000',1,'2006-11-12 16:56:45'),(4736,NULL,1,18,'PEDRINHAS',NULL,8824,49350000,'SE','2805109',1,'2006-11-12 16:56:45'),(4737,NULL,1,18,'PINHO',NULL,8825,49517000,'SE','2805208',1,'2006-11-12 16:56:45'),(4738,NULL,1,18,'PIRAMBU',NULL,8826,49190000,'SE','2805307',1,'2006-11-12 16:56:46'),(4739,NULL,1,18,'POO REDONDO',NULL,8827,49810000,'SE','2805406',1,'2006-11-12 16:56:46'),(4740,NULL,1,18,'POO VERDE',NULL,8828,49490000,'SE','2805505',1,'2006-11-12 16:56:46'),(4741,NULL,1,18,'PORTO DA FOLHA',NULL,8829,49800000,'SE','2805604',1,'2006-11-12 16:56:46'),(4742,NULL,1,18,'PROPRI',NULL,8830,49900000,'SE','2805703',1,'2006-11-12 16:56:46'),(4743,NULL,1,18,'RIACHO DO DANTAS',NULL,8831,49320000,'SE','2805802',1,'2006-11-12 16:56:46'),(4744,NULL,1,18,'RIACHUELO',NULL,8832,49130000,'SE','2805901',1,'2006-11-12 16:56:46'),(4745,NULL,1,18,'RIBEIRPOLIS',NULL,8833,49530000,'SE','2806008',1,'2006-11-12 16:56:46'),(4746,NULL,1,18,'ROSRIO DO CATETE',NULL,8834,49760000,'SE','2806107',1,'2006-11-12 16:56:46'),(4747,NULL,1,18,'SALGADO',NULL,8835,49390000,'SE','2806206',1,'2006-11-12 16:56:46'),(4748,NULL,1,18,'SANTA LUZIA DO ITANHY',NULL,8837,49230000,'SE','2806305',1,'2006-11-12 16:56:46'),(4749,NULL,1,18,'SANTA ROSA DE LIMA',NULL,8838,49640000,'SE','2806503',1,'2006-11-12 16:56:46'),(4750,NULL,1,18,'SANTANA DO SO FRANCISCO',NULL,8839,49985000,'SE','2806404',1,'2006-11-12 16:56:46'),(4751,NULL,1,18,'SANTO AMARO DAS BROTAS',NULL,8840,49180000,'SE','2806602',1,'2006-11-12 16:56:46'),(4752,NULL,1,18,'SO CRISTVO',NULL,8841,49100000,'SE','2806701',1,'2006-11-12 16:56:46'),(4753,NULL,1,18,'SO DOMINGOS',NULL,8842,49525000,'SE','2806800',1,'2006-11-12 16:56:46'),(4754,NULL,1,18,'SO FRANCISCO',NULL,8843,49945000,'SE','2806909',1,'2006-11-12 16:56:46'),(4755,NULL,1,18,'SO MIGUEL DO ALEIXO',NULL,8846,49535000,'SE','2807006',1,'2006-11-12 16:56:46'),(4756,NULL,1,18,'SIMO DIAS',NULL,8847,49480000,'SE','2807105',1,'2006-11-12 16:56:46'),(4757,NULL,1,18,'SIRIRI',NULL,8848,49630000,'SE','2807204',1,'2006-11-12 16:56:46'),(4758,NULL,1,18,'TELHA',NULL,8849,49910000,'SE','2807303',1,'2006-11-12 16:56:46'),(4759,NULL,1,18,'TOBIAS BARRETO',NULL,8850,49300000,'SE','2807402',1,'2006-11-12 16:56:46'),(4760,NULL,1,18,'TOMAR DO GERU',NULL,8851,49280000,'SE','2807501',1,'2006-11-12 16:56:46'),(4761,NULL,1,18,'UMBABA',NULL,8852,49260000,'SE','2807600',1,'2006-11-12 16:56:47'),(4762,NULL,1,23,'ADAMANTINA',NULL,8853,17800000,'SP','3500105',1,'2006-11-12 16:56:47'),(4763,NULL,1,23,'ADOLFO',NULL,8854,15230000,'SP','3500204',1,'2006-11-12 16:56:47'),(4764,NULL,1,23,'AGUA',NULL,8857,13860000,'SP','3500303',1,'2006-11-12 16:56:47'),(4765,NULL,1,23,'GUAS DA PRATA',NULL,8858,13890000,'SP','3500402',1,'2006-11-12 16:56:47'),(4766,NULL,1,23,'GUAS DE LINDIA',NULL,8859,13940000,'SP','3500501',1,'2006-11-12 16:56:47'),(4767,NULL,1,23,'GUAS DE SANTA BRBARA',NULL,8860,18770000,'SP','3500550',1,'2006-11-12 16:56:47'),(4768,NULL,1,23,'GUAS DE SO PEDRO',NULL,8861,13525000,'SP','3500600',1,'2006-11-12 16:56:47'),(4769,NULL,1,23,'AGUDOS',NULL,8862,17120000,'SP','3500709',1,'2006-11-12 16:56:47'),(4770,NULL,1,23,'ALAMBARI',NULL,8865,18220000,'SP','3500758',1,'2006-11-12 16:56:47'),(4771,NULL,1,23,'ALFREDO MARCONDES',NULL,8870,19180000,'SP','3500808',1,'2006-11-12 16:56:47'),(4772,NULL,1,23,'ALTAIR',NULL,8871,15430000,'SP','3500907',1,'2006-11-12 16:56:47'),(4773,NULL,1,23,'ALTINPOLIS',NULL,8872,14350000,'SP','3501004',1,'2006-11-12 16:56:47'),(4774,NULL,1,23,'ALTO ALEGRE',NULL,8873,16310000,'SP','3501103',1,'2006-11-12 16:56:47'),(4775,NULL,1,23,'ALUMNIO',NULL,8875,18125000,'SP','3501152',1,'2006-11-12 16:56:47'),(4776,NULL,1,23,'LVARES FLORENCE',NULL,8876,15540000,'SP','3501202',1,'2006-11-12 16:56:47'),(4777,NULL,1,23,'LVARES MACHADO',NULL,8877,19160000,'SP','3501301',1,'2006-11-12 16:56:47'),(4778,NULL,1,23,'LVARO DE CARVALHO',NULL,8878,17410000,'SP','3501400',1,'2006-11-12 16:56:47'),(4779,NULL,1,23,'ALVINLNDIA',NULL,8879,17430000,'SP','3501509',1,'2006-11-12 16:56:47'),(4780,NULL,1,23,'AMERICANA',NULL,8883,NULL,'SP','3501608',1,'2006-11-12 16:56:47'),(4781,NULL,1,23,'AMRICO BRASILIENSE',NULL,8884,14820000,'SP','3501707',1,'2006-11-12 16:56:47'),(4782,NULL,1,23,'AMRICO DE CAMPOS',NULL,8885,15550000,'SP','3501806',1,'2006-11-12 16:56:48'),(4783,NULL,1,23,'AMPARO',NULL,8886,NULL,'SP','3501905',1,'2006-11-12 16:56:48'),(4784,NULL,1,23,'ANALNDIA',NULL,8888,13550000,'SP','3502002',1,'2006-11-12 16:56:48'),(4785,NULL,1,23,'ANDRADINA',NULL,8891,NULL,'SP','3502101',1,'2006-11-12 16:56:48'),(4786,NULL,1,23,'ANGATUBA',NULL,8892,18240000,'SP','3502200',1,'2006-11-12 16:56:48'),(4787,NULL,1,23,'ANHEMBI',NULL,8893,18620000,'SP','3502309',1,'2006-11-12 16:56:48'),(4788,NULL,1,23,'ANHUMAS',NULL,8894,19580000,'SP','3502408',1,'2006-11-12 16:56:48'),(4789,NULL,1,23,'APARECIDA',NULL,8896,12570000,'SP','3502507',1,'2006-11-12 16:56:48'),(4790,NULL,1,23,'APARECIDA D\'OESTE',NULL,8897,15735000,'SP',NULL,1,'2006-11-12 16:56:48'),(4791,NULL,1,23,'APIA',NULL,8901,18320000,'SP','3502705',1,'2006-11-12 16:56:48'),(4792,NULL,1,23,'ARAARIGUAMA',NULL,8906,18147000,'SP','3502754',1,'2006-11-12 16:56:48'),(4793,NULL,1,23,'ARAATUBA',NULL,8907,NULL,'SP','3502804',1,'2006-11-12 16:56:48'),(4794,NULL,1,23,'ARAOIABA DA SERRA',NULL,8908,18190000,'SP','3502903',1,'2006-11-12 16:56:48'),(4795,NULL,1,23,'ARAMINA',NULL,8909,14550000,'SP','3503000',1,'2006-11-12 16:56:48'),(4796,NULL,1,23,'ARANDU',NULL,8910,18710000,'SP','3503109',1,'2006-11-12 16:56:48'),(4797,NULL,1,23,'ARAPE',NULL,8911,12870000,'SP','3503158',1,'2006-11-12 16:56:48'),(4798,NULL,1,23,'ARARAQUARA',NULL,8912,NULL,'SP','3503208',1,'2006-11-12 16:56:48'),(4799,NULL,1,23,'ARARAS',NULL,8913,NULL,'SP','3503307',1,'2006-11-12 16:56:48'),(4800,NULL,1,23,'ARCO-RIS',NULL,8916,17630000,'SP','3503356',1,'2006-11-12 16:56:48'),(4801,NULL,1,23,'AREALVA',NULL,8917,17160000,'SP','3503406',1,'2006-11-12 16:56:48'),(4802,NULL,1,23,'AREIAS',NULL,8918,12820000,'SP','3503505',1,'2006-11-12 16:56:48'),(4803,NULL,1,23,'AREIPOLIS',NULL,8919,18670000,'SP','3503604',1,'2006-11-12 16:56:48'),(4804,NULL,1,23,'ARIRANHA',NULL,8920,15960000,'SP','3503703',1,'2006-11-12 16:56:49'),(4805,NULL,1,23,'ARTUR NOGUEIRA',NULL,8923,13160000,'SP','3503802',1,'2006-11-12 16:56:49'),(4806,NULL,1,23,'ARUJ',NULL,8924,7400000,'SP','3503901',1,'2006-11-12 16:56:49'),(4807,NULL,1,23,'ASPSIA',NULL,8925,15763000,'SP','3503950',1,'2006-11-12 16:56:49'),(4808,NULL,1,23,'ASSIS',NULL,8926,NULL,'SP','3504008',1,'2006-11-12 16:56:49'),(4809,NULL,1,23,'ATIBAIA',NULL,8928,NULL,'SP','3504107',1,'2006-11-12 16:56:49'),(4810,NULL,1,23,'AURIFLAMA',NULL,8930,15350000,'SP','3504206',1,'2006-11-12 16:56:49'),(4811,NULL,1,23,'AVA',NULL,8931,16680000,'SP','3504305',1,'2006-11-12 16:56:49'),(4812,NULL,1,23,'AVANHANDAVA',NULL,8932,16360000,'SP','3504404',1,'2006-11-12 16:56:49'),(4813,NULL,1,23,'AVAR',NULL,8933,NULL,'SP','3504503',1,'2006-11-12 16:56:49'),(4814,NULL,1,23,'BADY BASSITT',NULL,8937,15115000,'SP','3504602',1,'2006-11-12 16:56:49'),(4815,NULL,1,23,'BALBINOS',NULL,8940,16640000,'SP','3504701',1,'2006-11-12 16:56:49'),(4816,NULL,1,23,'BLSAMO',NULL,8941,15140000,'SP','3504800',1,'2006-11-12 16:56:49'),(4817,NULL,1,23,'BANANAL',NULL,8942,12850000,'SP','3504909',1,'2006-11-12 16:56:49'),(4818,NULL,1,23,'BARO DE ANTONINA',NULL,8945,18490000,'SP','3505005',1,'2006-11-12 16:56:49'),(4819,NULL,1,23,'BARBOSA',NULL,8947,16350000,'SP','3505104',1,'2006-11-12 16:56:49'),(4820,NULL,1,23,'BARIRI',NULL,8948,17250000,'SP','3505203',1,'2006-11-12 16:56:49'),(4821,NULL,1,23,'BARRA BONITA',NULL,8949,17340000,'SP','3505302',1,'2006-11-12 16:56:49'),(4822,NULL,1,23,'BARRA DO CHAPU',NULL,8950,18325000,'SP','3505351',1,'2006-11-12 16:56:49'),(4823,NULL,1,23,'BARRA DO TURVO',NULL,8951,11955000,'SP','3505401',1,'2006-11-12 16:56:49'),(4824,NULL,1,23,'BARRETOS',NULL,8954,NULL,'SP','3505500',1,'2006-11-12 16:56:49'),(4825,NULL,1,23,'BARRINHA',NULL,8955,14860000,'SP','3505609',1,'2006-11-12 16:56:49'),(4826,NULL,1,23,'BARUERI',NULL,8956,NULL,'SP','3505708',1,'2006-11-12 16:56:49'),(4827,NULL,1,23,'BASTOS',NULL,8957,17690000,'SP','3505807',1,'2006-11-12 16:56:50'),(4828,NULL,1,23,'BATATAIS',NULL,8958,14300000,'SP','3505906',1,'2006-11-12 16:56:50'),(4829,NULL,1,23,'BAURU',NULL,8961,NULL,'SP','3506003',1,'2006-11-12 16:56:50'),(4830,NULL,1,23,'BEBEDOURO',NULL,8962,NULL,'SP','3506102',1,'2006-11-12 16:56:50'),(4831,NULL,1,23,'BENTO DE ABREU',NULL,8965,16790000,'SP','3506201',1,'2006-11-12 16:56:50'),(4832,NULL,1,23,'BERNARDINO DE CAMPOS',NULL,8966,18960000,'SP','3506300',1,'2006-11-12 16:56:50'),(4833,NULL,1,23,'BERTIOGA',NULL,8967,11250000,'SP','3506359',1,'2006-11-12 16:56:50'),(4834,NULL,1,23,'BILAC',NULL,8968,16210000,'SP','3506409',1,'2006-11-12 16:56:50'),(4835,NULL,1,23,'BIRIGI',NULL,8969,NULL,'SP',NULL,1,'2006-11-12 16:56:50'),(4836,NULL,1,23,'BIRITIBA-MIRIM',NULL,8970,8940000,'SP','3506607',1,'2006-11-12 16:56:50'),(4837,NULL,1,23,'BOA ESPERANA DO SUL',NULL,8972,14930000,'SP','3506706',1,'2006-11-12 16:56:50'),(4838,NULL,1,23,'BOCAINA',NULL,8975,17240000,'SP','3506805',1,'2006-11-12 16:56:50'),(4839,NULL,1,23,'BOFETE',NULL,8976,18590000,'SP','3506904',1,'2006-11-12 16:56:50'),(4840,NULL,1,23,'BOITUVA',NULL,8977,18550000,'SP','3507001',1,'2006-11-12 16:56:50'),(4841,NULL,1,23,'BOM JESUS DOS PERDES',NULL,8979,12955000,'SP','3507100',1,'2006-11-12 16:56:50'),(4842,NULL,1,23,'BOM SUCESSO DE ITARAR',NULL,8981,18475000,'SP','3507159',1,'2006-11-12 16:56:50'),(4843,NULL,1,23,'BOR',NULL,8983,19740000,'SP','3507209',1,'2006-11-12 16:56:50'),(4844,NULL,1,23,'BORACIA',NULL,8984,17270000,'SP','3507308',1,'2006-11-12 16:56:50'),(4845,NULL,1,23,'BORBOREMA',NULL,8985,14955000,'SP','3507407',1,'2006-11-12 16:56:50'),(4846,NULL,1,23,'BOREBI',NULL,8986,18675000,'SP','3507456',1,'2006-11-12 16:56:50'),(4847,NULL,1,23,'BOTUCATU',NULL,8989,NULL,'SP','3507506',1,'2006-11-12 16:56:50'),(4848,NULL,1,23,'BRAGANA PAULISTA',NULL,8992,NULL,'SP','3507605',1,'2006-11-12 16:56:50'),(4849,NULL,1,23,'BRANA',NULL,8995,16290000,'SP','3507704',1,'2006-11-12 16:56:50'),(4850,NULL,1,23,'BREJO ALEGRE',NULL,8996,16265000,'SP','3507753',1,'2006-11-12 16:56:51'),(4851,NULL,1,23,'BRODOWSKI',NULL,8997,14340000,'SP','3507803',1,'2006-11-12 16:56:51'),(4852,NULL,1,23,'BROTAS',NULL,8998,17380000,'SP','3507902',1,'2006-11-12 16:56:51'),(4853,NULL,1,23,'BURI',NULL,9000,18290000,'SP','3508009',1,'2006-11-12 16:56:51'),(4854,NULL,1,23,'BURITAMA',NULL,9001,15290000,'SP','3508108',1,'2006-11-12 16:56:51'),(4855,NULL,1,23,'BURITIZAL',NULL,9002,14570000,'SP','3508207',1,'2006-11-12 16:56:51'),(4856,NULL,1,23,'CABRLIA PAULISTA',NULL,9003,17480000,'SP','3508306',1,'2006-11-12 16:56:51'),(4857,NULL,1,23,'CABREVA',NULL,9004,13315000,'SP','3508405',1,'2006-11-12 16:56:51'),(4858,NULL,1,23,'CAAPAVA',NULL,9005,NULL,'SP','3508504',1,'2006-11-12 16:56:51'),(4859,NULL,1,23,'CACHOEIRA PAULISTA',NULL,9007,12630000,'SP','3508603',1,'2006-11-12 16:56:51'),(4860,NULL,1,23,'CACONDE',NULL,9008,13770000,'SP','3508702',1,'2006-11-12 16:56:51'),(4861,NULL,1,23,'CAFELNDIA',NULL,9009,16500000,'SP','3508801',1,'2006-11-12 16:56:51'),(4862,NULL,1,23,'CAIABU',NULL,9011,19530000,'SP','3508900',1,'2006-11-12 16:56:51'),(4863,NULL,1,23,'CAIEIRAS',NULL,9013,7700000,'SP','3509007',1,'2006-11-12 16:56:51'),(4864,NULL,1,23,'CAIU',NULL,9014,19450000,'SP','3509106',1,'2006-11-12 16:56:51'),(4865,NULL,1,23,'CAJAMAR',NULL,9015,7750000,'SP','3509205',1,'2006-11-12 16:56:51'),(4866,NULL,1,23,'CAJATI',NULL,9016,11950000,'SP','3509254',1,'2006-11-12 16:56:51'),(4867,NULL,1,23,'CAJOBI',NULL,9017,15410000,'SP','3509304',1,'2006-11-12 16:56:51'),(4868,NULL,1,23,'CAJURU',NULL,9018,14240000,'SP','3509403',1,'2006-11-12 16:56:51'),(4869,NULL,1,23,'CAMPINA DO MONTE ALEGRE',NULL,9023,18245000,'SP','3509452',1,'2006-11-12 16:56:51'),(4870,NULL,1,23,'CAMPINAS',NULL,9025,NULL,'SP','3509502',1,'2006-11-12 16:56:51'),(4871,NULL,1,23,'CAMPO LIMPO PAULISTA',NULL,9026,NULL,'SP','3509601',1,'2006-11-12 16:56:51'),(4872,NULL,1,23,'CAMPOS DO JORDO',NULL,9028,12460000,'SP','3509700',1,'2006-11-12 16:56:51'),(4873,NULL,1,23,'CAMPOS NOVOS PAULISTA',NULL,9029,19960000,'SP','3509809',1,'2006-11-12 16:56:52'),(4874,NULL,1,23,'CANANIA',NULL,9030,11990000,'SP','3509908',1,'2006-11-12 16:56:52'),(4875,NULL,1,23,'CANAS',NULL,9031,12615000,'SP','3509957',1,'2006-11-12 16:56:52'),(4876,NULL,1,23,'CNDIDO MOTA',NULL,9033,19880000,'SP','3510005',1,'2006-11-12 16:56:52'),(4877,NULL,1,23,'CNDIDO RODRIGUES',NULL,9034,15930000,'SP','3510104',1,'2006-11-12 16:56:52'),(4878,NULL,1,23,'CANITAR',NULL,9036,18990000,'SP','3510153',1,'2006-11-12 16:56:52'),(4879,NULL,1,23,'CAPO BONITO',NULL,9037,NULL,'SP','3510203',1,'2006-11-12 16:56:52'),(4880,NULL,1,23,'CAPELA DO ALTO',NULL,9038,18195000,'SP','3510302',1,'2006-11-12 16:56:52'),(4881,NULL,1,23,'CAPIVARI',NULL,9039,13360000,'SP','3510401',1,'2006-11-12 16:56:52'),(4882,NULL,1,23,'CARAGUATATUBA',NULL,9043,NULL,'SP','3510500',1,'2006-11-12 16:56:52'),(4883,NULL,1,23,'CARAPICUBA',NULL,9044,NULL,'SP','3510609',1,'2006-11-12 16:56:52'),(4884,NULL,1,23,'CARDOSO',NULL,9046,15570000,'SP','3510708',1,'2006-11-12 16:56:52'),(4885,NULL,1,23,'CASA BRANCA',NULL,9049,13700000,'SP','3510807',1,'2006-11-12 16:56:52'),(4886,NULL,1,23,'CSSIA DOS COQUEIROS',NULL,9050,14260000,'SP','3510906',1,'2006-11-12 16:56:52'),(4887,NULL,1,23,'CASTILHO',NULL,9051,16920000,'SP','3511003',1,'2006-11-12 16:56:52'),(4888,NULL,1,23,'CATANDUVA',NULL,9052,NULL,'SP','3511102',1,'2006-11-12 16:56:52'),(4889,NULL,1,23,'CATIGU',NULL,9053,15870000,'SP','3511201',1,'2006-11-12 16:56:52'),(4890,NULL,1,23,'CEDRAL',NULL,9056,15895000,'SP','3511300',1,'2006-11-12 16:56:52'),(4891,NULL,1,23,'CERQUEIRA CSAR',NULL,9057,18760000,'SP','3511409',1,'2006-11-12 16:56:52'),(4892,NULL,1,23,'CERQUILHO',NULL,9058,18520000,'SP','3511508',1,'2006-11-12 16:56:52'),(4893,NULL,1,23,'CESRIO LANGE',NULL,9059,18285000,'SP','3511607',1,'2006-11-12 16:56:52'),(4894,NULL,1,23,'CHARQUEADA',NULL,9061,13515000,'SP','3511706',1,'2006-11-12 16:56:52'),(4895,NULL,1,23,'CHAVANTES',NULL,9062,18970000,'SP','3557204',1,'2006-11-12 16:56:53'),(4896,NULL,1,23,'CLEMENTINA',NULL,9065,16250000,'SP','3511904',1,'2006-11-12 16:56:53'),(4897,NULL,1,23,'COLINA',NULL,9067,14770000,'SP','3512001',1,'2006-11-12 16:56:53'),(4898,NULL,1,23,'COLMBIA',NULL,9068,14795000,'SP','3512100',1,'2006-11-12 16:56:53'),(4899,NULL,1,23,'CONCHAL',NULL,9070,13835000,'SP','3512209',1,'2006-11-12 16:56:53'),(4900,NULL,1,23,'CONCHAS',NULL,9071,18570000,'SP','3512308',1,'2006-11-12 16:56:53'),(4901,NULL,1,23,'CORDEIRPOLIS',NULL,9072,13490000,'SP','3512407',1,'2006-11-12 16:56:53'),(4902,NULL,1,23,'COROADOS',NULL,9073,16260000,'SP','3512506',1,'2006-11-12 16:56:53'),(4903,NULL,1,23,'CORONEL MACEDO',NULL,9075,18745000,'SP','3512605',1,'2006-11-12 16:56:53'),(4904,NULL,1,23,'CORUMBATA',NULL,9078,13540000,'SP','3512704',1,'2006-11-12 16:56:53'),(4905,NULL,1,23,'COSMPOLIS',NULL,9079,13150000,'SP','3512803',1,'2006-11-12 16:56:53'),(4906,NULL,1,23,'COSMORAMA',NULL,9080,15530000,'SP','3512902',1,'2006-11-12 16:56:53'),(4907,NULL,1,23,'COTIA',NULL,9082,NULL,'SP','3513009',1,'2006-11-12 16:56:53'),(4908,NULL,1,23,'CRAVINHOS',NULL,9083,14140000,'SP','3513108',1,'2006-11-12 16:56:53'),(4909,NULL,1,23,'CRISTAIS PAULISTA',NULL,9084,14460000,'SP','3513207',1,'2006-11-12 16:56:53'),(4910,NULL,1,23,'CRUZLIA',NULL,9086,19860000,'SP','3513306',1,'2006-11-12 16:56:53'),(4911,NULL,1,23,'CRUZEIRO',NULL,9087,NULL,'SP','3513405',1,'2006-11-12 16:56:53'),(4912,NULL,1,23,'CUBATO',NULL,9088,NULL,'SP','3513504',1,'2006-11-12 16:56:53'),(4913,NULL,1,23,'CUNHA',NULL,9090,12530000,'SP','3513603',1,'2006-11-12 16:56:53'),(4914,NULL,1,23,'DESCALVADO',NULL,9093,13690000,'SP','3513702',1,'2006-11-12 16:56:53'),(4915,NULL,1,23,'DIADEMA',NULL,9094,NULL,'SP','3513801',1,'2006-11-12 16:56:53'),(4916,NULL,1,23,'DIRCE REIS',NULL,9095,15715000,'SP','3513850',1,'2006-11-12 16:56:53'),(4917,NULL,1,23,'DIVINOLNDIA',NULL,9097,13780000,'SP','3513900',1,'2006-11-12 16:56:53'),(4918,NULL,1,23,'DOBRADA',NULL,9098,15980000,'SP','3514007',1,'2006-11-12 16:56:54'),(4919,NULL,1,23,'DOIS CRREGOS',NULL,9099,17300000,'SP','3514106',1,'2006-11-12 16:56:54'),(4920,NULL,1,23,'DOLCINPOLIS',NULL,9100,15740000,'SP','3514205',1,'2006-11-12 16:56:54'),(4921,NULL,1,23,'DOURADO',NULL,9102,13590000,'SP','3514304',1,'2006-11-12 16:56:54'),(4922,NULL,1,23,'DRACENA',NULL,9103,17900000,'SP','3514403',1,'2006-11-12 16:56:54'),(4923,NULL,1,23,'DUARTINA',NULL,9104,17470000,'SP','3514502',1,'2006-11-12 16:56:54'),(4924,NULL,1,23,'DUMONT',NULL,9105,14120000,'SP','3514601',1,'2006-11-12 16:56:54'),(4925,NULL,1,23,'ECHAPOR',NULL,9107,19830000,'SP','3514700',1,'2006-11-12 16:56:54'),(4926,NULL,1,23,'ELDORADO',NULL,9108,11960000,'SP','3514809',1,'2006-11-12 16:56:54'),(4927,NULL,1,23,'ELIAS FAUSTO',NULL,9110,13350000,'SP','3514908',1,'2006-11-12 16:56:54'),(4928,NULL,1,23,'ELISIRIO',NULL,9111,15823000,'SP','3514924',1,'2006-11-12 16:56:54'),(4929,NULL,1,23,'EMBABA',NULL,9112,15425000,'SP','3514957',1,'2006-11-12 16:56:54'),(4930,NULL,1,23,'EMBU',NULL,9113,NULL,'SP','3515004',1,'2006-11-12 16:56:54'),(4931,NULL,1,23,'EMBU-GUAU',NULL,9114,6900000,'SP','3515103',1,'2006-11-12 16:56:54'),(4932,NULL,1,23,'EMILIANPOLIS',NULL,9115,19350000,'SP','3515129',1,'2006-11-12 16:56:54'),(4933,NULL,1,23,'ENGENHEIRO COELHO',NULL,9118,13165000,'SP','3515152',1,'2006-11-12 16:56:54'),(4934,NULL,1,23,'ESPRITO SANTO DO PINHAL',NULL,9124,13990000,'SP','3515186',1,'2006-11-12 16:56:54'),(4935,NULL,1,23,'ESPRITO SANTO DO TURVO',NULL,9125,18935000,'SP','3515194',1,'2006-11-12 16:56:54'),(4936,NULL,1,23,'ESTIVA GERBI',NULL,9126,13857000,'SP','3557303',1,'2006-11-12 16:56:54'),(4937,NULL,1,23,'ESTRELA D\'OESTE',NULL,9127,15650000,'SP',NULL,1,'2006-11-12 16:56:54'),(4938,NULL,1,23,'ESTRELA DO NORTE',NULL,9128,19230000,'SP','3515301',1,'2006-11-12 16:56:54'),(4939,NULL,1,23,'EUCLIDES DA CUNHA PAULISTA',NULL,9129,19275000,'SP','3515350',1,'2006-11-12 16:56:54'),(4940,NULL,1,23,'FARTURA',NULL,9131,18870000,'SP','3515400',1,'2006-11-12 16:56:55'),(4941,NULL,1,23,'FERNANDO PRESTES',NULL,9135,15940000,'SP','3515608',1,'2006-11-12 16:56:55'),(4942,NULL,1,23,'FERNANDPOLIS',NULL,9136,15600000,'SP','3515509',1,'2006-11-12 16:56:55'),(4943,NULL,1,23,'FERNO',NULL,9137,17455000,'SP','3515657',1,'2006-11-12 16:56:55'),(4944,NULL,1,23,'FERRAZ DE VASCONCELOS',NULL,9138,NULL,'SP','3515707',1,'2006-11-12 16:56:55'),(4945,NULL,1,23,'FLORA RICA',NULL,9139,17870000,'SP','3515806',1,'2006-11-12 16:56:55'),(4946,NULL,1,23,'FLOREAL',NULL,9140,15320000,'SP','3515905',1,'2006-11-12 16:56:55'),(4947,NULL,1,23,'FLRIDA PAULISTA',NULL,9142,17830000,'SP','3516002',1,'2006-11-12 16:56:55'),(4948,NULL,1,23,'FLORNIA',NULL,9143,19870000,'SP','3516101',1,'2006-11-12 16:56:55'),(4949,NULL,1,23,'FRANCA',NULL,9144,NULL,'SP','3516200',1,'2006-11-12 16:56:55'),(4950,NULL,1,23,'FRANCISCO MORATO',NULL,9145,NULL,'SP','3516309',1,'2006-11-12 16:56:55'),(4951,NULL,1,23,'FRANCO DA ROCHA',NULL,9146,NULL,'SP','3516408',1,'2006-11-12 16:56:55'),(4952,NULL,1,23,'GABRIEL MONTEIRO',NULL,9148,16220000,'SP','3516507',1,'2006-11-12 16:56:55'),(4953,NULL,1,23,'GLIA',NULL,9149,17450000,'SP','3516606',1,'2006-11-12 16:56:55'),(4954,NULL,1,23,'GARA',NULL,9150,17400000,'SP','3516705',1,'2006-11-12 16:56:55'),(4955,NULL,1,23,'GASTO VIDIGAL',NULL,9152,15330000,'SP','3516804',1,'2006-11-12 16:56:55'),(4956,NULL,1,23,'GAVIO PEIXOTO',NULL,9153,14813000,'SP','3516853',1,'2006-11-12 16:56:55'),(4957,NULL,1,23,'GENERAL SALGADO',NULL,9154,15300000,'SP','3516903',1,'2006-11-12 16:56:55'),(4958,NULL,1,23,'GETULINA',NULL,9155,16450000,'SP','3517000',1,'2006-11-12 16:56:55'),(4959,NULL,1,23,'GLICRIO',NULL,9156,16270000,'SP','3517109',1,'2006-11-12 16:56:55'),(4960,NULL,1,23,'GUAIARA',NULL,9160,16430000,'SP','3517208',1,'2006-11-12 16:56:55'),(4961,NULL,1,23,'GUAIMB',NULL,9161,16480000,'SP','3517307',1,'2006-11-12 16:56:55'),(4962,NULL,1,23,'GUARA',NULL,9162,14790000,'SP','3517406',1,'2006-11-12 16:56:56'),(4963,NULL,1,23,'GUAPIAU',NULL,9164,15110000,'SP','3517505',1,'2006-11-12 16:56:56'),(4964,NULL,1,23,'GUAPIARA',NULL,9165,18310000,'SP','3517604',1,'2006-11-12 16:56:56'),(4965,NULL,1,23,'GUAR',NULL,9167,14580000,'SP','3517703',1,'2006-11-12 16:56:56'),(4966,NULL,1,23,'GUARAA',NULL,9168,16980000,'SP','3517802',1,'2006-11-12 16:56:56'),(4967,NULL,1,23,'GUARACI',NULL,9169,15420000,'SP','3517901',1,'2006-11-12 16:56:56'),(4968,NULL,1,23,'GUARANI D\'OESTE',NULL,9171,15680000,'SP',NULL,1,'2006-11-12 16:56:56'),(4969,NULL,1,23,'GUARANT',NULL,9172,16570000,'SP','3518107',1,'2006-11-12 16:56:56'),(4970,NULL,1,23,'GUARARAPES',NULL,9175,16700000,'SP','3518206',1,'2006-11-12 16:56:56'),(4971,NULL,1,23,'GUARAREMA',NULL,9176,8900000,'SP','3518305',1,'2006-11-12 16:56:56'),(4972,NULL,1,23,'GUARATINGUET',NULL,9177,NULL,'SP','3518404',1,'2006-11-12 16:56:56'),(4973,NULL,1,23,'GUARE',NULL,9178,18250000,'SP','3518503',1,'2006-11-12 16:56:56'),(4974,NULL,1,23,'GUARIBA',NULL,9179,14840000,'SP','3518602',1,'2006-11-12 16:56:56'),(4975,NULL,1,23,'GUARUJ',NULL,9182,NULL,'SP','3518701',1,'2006-11-12 16:56:56'),(4976,NULL,1,23,'GUARULHOS',NULL,9183,NULL,'SP','3518800',1,'2006-11-12 16:56:56'),(4977,NULL,1,23,'GUATAPAR',NULL,9184,14115000,'SP','3518859',1,'2006-11-12 16:56:56'),(4978,NULL,1,23,'GUZOLNDIA',NULL,9185,15355000,'SP','3518909',1,'2006-11-12 16:56:56'),(4979,NULL,1,23,'HERCULNDIA',NULL,9186,17650000,'SP','3519006',1,'2006-11-12 16:56:56'),(4980,NULL,1,23,'HOLAMBRA',NULL,9187,13825000,'SP','3519055',1,'2006-11-12 16:56:56'),(4981,NULL,1,23,'HORTOLNDIA',NULL,9189,NULL,'SP','3519071',1,'2006-11-12 16:56:56'),(4982,NULL,1,23,'IACANGA',NULL,9190,17180000,'SP','3519105',1,'2006-11-12 16:56:56'),(4983,NULL,1,23,'IACRI',NULL,9191,17680000,'SP','3519204',1,'2006-11-12 16:56:56'),(4984,NULL,1,23,'IARAS',NULL,9192,18775000,'SP','3519253',1,'2006-11-12 16:56:57'),(4985,NULL,1,23,'IBAT',NULL,9193,14815000,'SP','3519303',1,'2006-11-12 16:56:57'),(4986,NULL,1,23,'IBIR',NULL,9195,15860000,'SP','3519402',1,'2006-11-12 16:56:57'),(4987,NULL,1,23,'IBIRAREMA',NULL,9196,19940000,'SP','3519501',1,'2006-11-12 16:56:57'),(4988,NULL,1,23,'IBITINGA',NULL,9197,14940000,'SP','3519600',1,'2006-11-12 16:56:57'),(4989,NULL,1,23,'IBINA',NULL,9201,18150000,'SP','3519709',1,'2006-11-12 16:56:57'),(4990,NULL,1,23,'ICM',NULL,9202,15460000,'SP','3519808',1,'2006-11-12 16:56:57'),(4991,NULL,1,23,'IEP',NULL,9204,19640000,'SP','3519907',1,'2006-11-12 16:56:57'),(4992,NULL,1,23,'IGARAU DO TIET',NULL,9206,17350000,'SP','3520004',1,'2006-11-12 16:56:57'),(4993,NULL,1,23,'IGARAPAVA',NULL,9208,14540000,'SP','3520103',1,'2006-11-12 16:56:57'),(4994,NULL,1,23,'IGARAT',NULL,9209,12350000,'SP','3520202',1,'2006-11-12 16:56:57'),(4995,NULL,1,23,'IGUAPE',NULL,9210,11920000,'SP','3520301',1,'2006-11-12 16:56:57'),(4996,NULL,1,23,'ILHA COMPRIDA',NULL,9211,11925000,'SP','3520426',1,'2006-11-12 16:56:57'),(4997,NULL,1,23,'ILHA SOLTEIRA',NULL,9213,15385000,'SP','3520442',1,'2006-11-12 16:56:57'),(4998,NULL,1,23,'ILHABELA',NULL,9214,11630000,'SP','3520400',1,'2006-11-12 16:56:57'),(4999,NULL,1,23,'INDAIATUBA',NULL,9216,NULL,'SP','3520509',1,'2006-11-12 16:56:57'),(5000,NULL,1,23,'INDIANA',NULL,9217,19560000,'SP','3520608',1,'2006-11-12 16:56:57'),(5001,NULL,1,23,'INDIAPOR',NULL,9218,15690000,'SP','3520707',1,'2006-11-12 16:56:58'),(5002,NULL,1,23,'INBIA PAULISTA',NULL,9220,17760000,'SP','3520806',1,'2006-11-12 16:56:58'),(5003,NULL,1,23,'IPAUSSU',NULL,9221,18950000,'SP','3520905',1,'2006-11-12 16:56:58'),(5004,NULL,1,23,'IPER',NULL,9222,18560000,'SP','3521002',1,'2006-11-12 16:56:58'),(5005,NULL,1,23,'IPENA',NULL,9223,13537000,'SP','3521101',1,'2006-11-12 16:56:58'),(5006,NULL,1,23,'IPIGU',NULL,9224,15108000,'SP','3521150',1,'2006-11-12 16:56:58'),(5007,NULL,1,23,'IPORANGA',NULL,9225,18330000,'SP','3521200',1,'2006-11-12 16:56:58'),(5008,NULL,1,23,'IPU',NULL,9226,14610000,'SP','3521309',1,'2006-11-12 16:56:58'),(5009,NULL,1,23,'IRACEMPOLIS',NULL,9227,13495000,'SP','3521408',1,'2006-11-12 16:56:58'),(5010,NULL,1,23,'IRAPU',NULL,9229,14990000,'SP','3521507',1,'2006-11-12 16:56:58'),(5011,NULL,1,23,'IRAPURU',NULL,9230,17880000,'SP','3521606',1,'2006-11-12 16:56:58'),(5012,NULL,1,23,'ITABER',NULL,9231,18440000,'SP','3521705',1,'2006-11-12 16:56:58'),(5013,NULL,1,23,'ITA',NULL,9233,18730000,'SP','3521804',1,'2006-11-12 16:56:58'),(5014,NULL,1,23,'ITAJOBI',NULL,9235,15840000,'SP','3521903',1,'2006-11-12 16:56:58'),(5015,NULL,1,23,'ITAJU',NULL,9236,17260000,'SP','3522000',1,'2006-11-12 16:56:58'),(5016,NULL,1,23,'ITANHAM',NULL,9237,11740000,'SP','3522109',1,'2006-11-12 16:56:58'),(5017,NULL,1,23,'ITACA',NULL,9238,18360000,'SP','3522158',1,'2006-11-12 16:56:58'),(5018,NULL,1,23,'ITAPECERICA DA SERRA',NULL,9239,NULL,'SP','3522208',1,'2006-11-12 16:56:58'),(5019,NULL,1,23,'ITAPETININGA',NULL,9240,NULL,'SP','3522307',1,'2006-11-12 16:56:58'),(5020,NULL,1,23,'ITAPEVA',NULL,9242,NULL,'SP','3522406',1,'2006-11-12 16:56:58'),(5021,NULL,1,23,'ITAPEVI',NULL,9243,NULL,'SP','3522505',1,'2006-11-12 16:56:58'),(5022,NULL,1,23,'ITAPIRA',NULL,9244,NULL,'SP','3522604',1,'2006-11-12 16:56:59'),(5023,NULL,1,23,'ITAPIRAPU PAULISTA',NULL,9245,18385000,'SP','3522653',1,'2006-11-12 16:56:59'),(5024,NULL,1,23,'ITPOLIS',NULL,9246,14900000,'SP','3522703',1,'2006-11-12 16:56:59'),(5025,NULL,1,23,'ITAPORANGA',NULL,9247,18480000,'SP','3522802',1,'2006-11-12 16:56:59'),(5026,NULL,1,23,'ITAPU',NULL,9248,17230000,'SP','3522901',1,'2006-11-12 16:56:59'),(5027,NULL,1,23,'ITAPURA',NULL,9249,15390000,'SP','3523008',1,'2006-11-12 16:56:59'),(5028,NULL,1,23,'ITAQUAQUECETUBA',NULL,9250,NULL,'SP','3523107',1,'2006-11-12 16:56:59'),(5029,NULL,1,23,'ITARAR',NULL,9252,18460000,'SP','3523206',1,'2006-11-12 16:56:59'),(5030,NULL,1,23,'ITARIRI',NULL,9253,11760000,'SP','3523305',1,'2006-11-12 16:56:59'),(5031,NULL,1,23,'ITATIBA',NULL,9254,NULL,'SP','3523404',1,'2006-11-12 16:56:59'),(5032,NULL,1,23,'ITATINGA',NULL,9255,18690000,'SP','3523503',1,'2006-11-12 16:56:59'),(5033,NULL,1,23,'ITIRAPINA',NULL,9256,13530000,'SP','3523602',1,'2006-11-12 16:56:59'),(5034,NULL,1,23,'ITIRAPU',NULL,9257,14420000,'SP','3523701',1,'2006-11-12 16:56:59'),(5035,NULL,1,23,'ITOBI',NULL,9258,13715000,'SP','3523800',1,'2006-11-12 16:56:59'),(5036,NULL,1,23,'ITU',NULL,9260,NULL,'SP','3523909',1,'2006-11-12 16:56:59'),(5037,NULL,1,23,'ITUPEVA',NULL,9261,13295000,'SP','3524006',1,'2006-11-12 16:56:59'),(5038,NULL,1,23,'ITUVERAVA',NULL,9262,14500000,'SP','3524105',1,'2006-11-12 16:56:59'),(5039,NULL,1,23,'JABORANDI',NULL,9264,14775000,'SP','3524204',1,'2006-11-12 16:56:59'),(5040,NULL,1,23,'JABOTICABAL',NULL,9265,NULL,'SP','3524303',1,'2006-11-12 16:56:59'),(5041,NULL,1,23,'JACARE',NULL,9267,NULL,'SP','3524402',1,'2006-11-12 16:56:59'),(5042,NULL,1,23,'JACI',NULL,9268,15155000,'SP','3524501',1,'2006-11-12 16:56:59'),(5043,NULL,1,23,'JACUPIRANGA',NULL,9271,11940000,'SP','3524600',1,'2006-11-12 16:56:59'),(5044,NULL,1,23,'JAGUARINA',NULL,9273,13820000,'SP','3524709',1,'2006-11-12 16:56:59'),(5045,NULL,1,23,'JALES',NULL,9274,15700000,'SP','3524808',1,'2006-11-12 16:57:00'),(5046,NULL,1,23,'JAMBEIRO',NULL,9276,12270000,'SP','3524907',1,'2006-11-12 16:57:00'),(5047,NULL,1,23,'JANDIRA',NULL,9277,NULL,'SP','3525003',1,'2006-11-12 16:57:00'),(5048,NULL,1,23,'JARDINPOLIS',NULL,9282,14680000,'SP','3525102',1,'2006-11-12 16:57:00'),(5049,NULL,1,23,'JARINU',NULL,9283,13240000,'SP','3525201',1,'2006-11-12 16:57:00'),(5050,NULL,1,23,'JA',NULL,9285,NULL,'SP','3525300',1,'2006-11-12 16:57:00'),(5051,NULL,1,23,'JERIQUARA',NULL,9286,14450000,'SP','3525409',1,'2006-11-12 16:57:00'),(5052,NULL,1,23,'JOANPOLIS',NULL,9287,12980000,'SP','3525508',1,'2006-11-12 16:57:00'),(5053,NULL,1,23,'JOO RAMALHO',NULL,9288,19680000,'SP','3525607',1,'2006-11-12 16:57:00'),(5054,NULL,1,23,'JOS BONIFCIO',NULL,9291,15200000,'SP','3525706',1,'2006-11-12 16:57:00'),(5055,NULL,1,23,'JLIO MESQUITA',NULL,9293,17550000,'SP','3525805',1,'2006-11-12 16:57:00'),(5056,NULL,1,23,'JUMIRIM',NULL,9294,18535000,'SP','3525854',1,'2006-11-12 16:57:00'),(5057,NULL,1,23,'JUNDIA',NULL,9295,NULL,'SP','3525904',1,'2006-11-12 16:57:00'),(5058,NULL,1,23,'JUNQUEIRPOLIS',NULL,9298,17890000,'SP','3526001',1,'2006-11-12 16:57:00'),(5059,NULL,1,23,'JUQUI',NULL,9299,11800000,'SP','3526100',1,'2006-11-12 16:57:00'),(5060,NULL,1,23,'JUQUITIBA',NULL,9301,6950000,'SP','3526209',1,'2006-11-12 16:57:00'),(5061,NULL,1,23,'LAGOINHA',NULL,9309,12130000,'SP','3526308',1,'2006-11-12 16:57:00'),(5062,NULL,1,23,'LARANJAL PAULISTA',NULL,9310,18500000,'SP','3526407',1,'2006-11-12 16:57:00'),(5063,NULL,1,23,'LAVNIA',NULL,9313,16850000,'SP','3526506',1,'2006-11-12 16:57:00'),(5064,NULL,1,23,'LAVRINHAS',NULL,9314,12760000,'SP','3526605',1,'2006-11-12 16:57:00'),(5065,NULL,1,23,'LEME',NULL,9315,NULL,'SP','3526704',1,'2006-11-12 16:57:00'),(5066,NULL,1,23,'LENIS PAULISTA',NULL,9316,NULL,'SP','3526803',1,'2006-11-12 16:57:01'),(5067,NULL,1,23,'LIMEIRA',NULL,9317,NULL,'SP','3526902',1,'2006-11-12 16:57:01'),(5068,NULL,1,23,'LINDIA',NULL,9318,13950000,'SP','3527009',1,'2006-11-12 16:57:01'),(5069,NULL,1,23,'LINS',NULL,9319,NULL,'SP','3527108',1,'2006-11-12 16:57:01'),(5070,NULL,1,23,'LORENA',NULL,9321,NULL,'SP','3527207',1,'2006-11-12 16:57:01'),(5071,NULL,1,23,'LOURDES',NULL,9322,15285000,'SP','3527256',1,'2006-11-12 16:57:01'),(5072,NULL,1,23,'LOUVEIRA',NULL,9323,13290000,'SP','3527306',1,'2006-11-12 16:57:01'),(5073,NULL,1,23,'LUCLIA',NULL,9324,17780000,'SP','3527405',1,'2006-11-12 16:57:01'),(5074,NULL,1,23,'LUCIANPOLIS',NULL,9325,17475000,'SP','3527504',1,'2006-11-12 16:57:01'),(5075,NULL,1,23,'LUS ANTNIO',NULL,9326,14210000,'SP','3527603',1,'2006-11-12 16:57:01'),(5076,NULL,1,23,'LUIZINIA',NULL,9327,16340000,'SP','3527702',1,'2006-11-12 16:57:01'),(5077,NULL,1,23,'LUPRCIO',NULL,9328,17420000,'SP','3527801',1,'2006-11-12 16:57:01'),(5078,NULL,1,23,'LUTCIA',NULL,9330,19750000,'SP','3527900',1,'2006-11-12 16:57:01'),(5079,NULL,1,23,'MACATUBA',NULL,9331,17290000,'SP','3528007',1,'2006-11-12 16:57:01'),(5080,NULL,1,23,'MACAUBAL',NULL,9332,15270000,'SP','3528106',1,'2006-11-12 16:57:01'),(5081,NULL,1,23,'MACEDNIA',NULL,9333,15620000,'SP','3528205',1,'2006-11-12 16:57:01'),(5082,NULL,1,23,'MAGDA',NULL,9335,15310000,'SP','3528304',1,'2006-11-12 16:57:01'),(5083,NULL,1,23,'MAIRINQUE',NULL,9337,18120000,'SP','3528403',1,'2006-11-12 16:57:01'),(5084,NULL,1,23,'MAIRIPOR',NULL,9338,7600000,'SP','3528502',1,'2006-11-12 16:57:01'),(5085,NULL,1,23,'MANDURI',NULL,9340,18780000,'SP','3528601',1,'2006-11-12 16:57:01'),(5086,NULL,1,23,'MARAB PAULISTA',NULL,9342,19430000,'SP','3528700',1,'2006-11-12 16:57:01'),(5087,NULL,1,23,'MARAA',NULL,9343,19840000,'SP','3528809',1,'2006-11-12 16:57:01'),(5088,NULL,1,23,'MARAPOAMA',NULL,9344,15845000,'SP','3528858',1,'2006-11-12 16:57:02'),(5089,NULL,1,23,'MARIPOLIS',NULL,9347,17810000,'SP','3528908',1,'2006-11-12 16:57:02'),(5090,NULL,1,23,'MARLIA',NULL,9348,NULL,'SP','3529005',1,'2006-11-12 16:57:02'),(5091,NULL,1,23,'MARINPOLIS',NULL,9349,15730000,'SP','3529104',1,'2006-11-12 16:57:02'),(5092,NULL,1,23,'MARTINPOLIS',NULL,9353,19500000,'SP','3529203',1,'2006-11-12 16:57:02'),(5093,NULL,1,23,'MATO',NULL,9354,NULL,'SP','3529302',1,'2006-11-12 16:57:02'),(5094,NULL,1,23,'MAU',NULL,9355,NULL,'SP','3529401',1,'2006-11-12 16:57:02'),(5095,NULL,1,23,'MENDONA',NULL,9356,15220000,'SP','3529500',1,'2006-11-12 16:57:02'),(5096,NULL,1,23,'MERIDIANO',NULL,9357,15625000,'SP','3529609',1,'2006-11-12 16:57:02'),(5097,NULL,1,23,'MESPOLIS',NULL,9358,15748000,'SP','3529658',1,'2006-11-12 16:57:02'),(5098,NULL,1,23,'MIGUELPOLIS',NULL,9359,14530000,'SP','3529708',1,'2006-11-12 16:57:02'),(5099,NULL,1,23,'MINEIROS DO TIET',NULL,9360,17320000,'SP','3529807',1,'2006-11-12 16:57:02'),(5100,NULL,1,23,'MIRA ESTRELA',NULL,9361,15580000,'SP','3530003',1,'2006-11-12 16:57:02'),(5101,NULL,1,23,'MIRACATU',NULL,9362,11850000,'SP','3529906',1,'2006-11-12 16:57:02'),(5102,NULL,1,23,'MIRANDPOLIS',NULL,9364,16800000,'SP','3530102',1,'2006-11-12 16:57:02'),(5103,NULL,1,23,'MIRANTE DO PARANAPANEMA',NULL,9365,19260000,'SP','3530201',1,'2006-11-12 16:57:02'),(5104,NULL,1,23,'MIRASSOL',NULL,9366,15130000,'SP','3530300',1,'2006-11-12 16:57:02'),(5105,NULL,1,23,'MIRASSOLNDIA',NULL,9367,15145000,'SP','3530409',1,'2006-11-12 16:57:02'),(5106,NULL,1,23,'MOCOCA',NULL,9368,NULL,'SP','3530508',1,'2006-11-12 16:57:02'),(5107,NULL,1,23,'MOGI DAS CRUZES',NULL,9369,NULL,'SP','3530607',1,'2006-11-12 16:57:02'),(5108,NULL,1,23,'MOGI-GUAU',NULL,9370,NULL,'SP',NULL,1,'2006-11-12 16:57:02'),(5109,NULL,1,23,'MOGI-MIRIM',NULL,9371,NULL,'SP',NULL,1,'2006-11-12 16:57:03'),(5110,NULL,1,23,'MOMBUCA',NULL,9372,13380000,'SP','3530904',1,'2006-11-12 16:57:03'),(5111,NULL,1,23,'MONES',NULL,9373,15275000,'SP','3531001',1,'2006-11-12 16:57:03'),(5112,NULL,1,23,'MONGAGU',NULL,9374,11730000,'SP','3531100',1,'2006-11-12 16:57:03'),(5113,NULL,1,23,'MONTE ALEGRE DO SUL',NULL,9376,13910000,'SP','3531209',1,'2006-11-12 16:57:03'),(5114,NULL,1,23,'MONTE ALTO',NULL,9377,15910000,'SP','3531308',1,'2006-11-12 16:57:03'),(5115,NULL,1,23,'MONTE APRAZVEL',NULL,9378,15150000,'SP','3531407',1,'2006-11-12 16:57:03'),(5116,NULL,1,23,'MONTE AZUL PAULISTA',NULL,9379,14730000,'SP','3531506',1,'2006-11-12 16:57:03'),(5117,NULL,1,23,'MONTE CASTELO',NULL,9381,17960000,'SP','3531605',1,'2006-11-12 16:57:03'),(5118,NULL,1,23,'MONTE MOR',NULL,9382,13190000,'SP','3531803',1,'2006-11-12 16:57:03'),(5119,NULL,1,23,'MONTEIRO LOBATO',NULL,9384,12250000,'SP','3531704',1,'2006-11-12 16:57:03'),(5120,NULL,1,23,'MORRO AGUDO',NULL,9386,14640000,'SP','3531902',1,'2006-11-12 16:57:03'),(5121,NULL,1,23,'MORUNGABA',NULL,9388,13260000,'SP','3532009',1,'2006-11-12 16:57:03'),(5122,NULL,1,23,'MOTUCA',NULL,9390,14835000,'SP','3532058',1,'2006-11-12 16:57:03'),(5123,NULL,1,23,'MURUTINGA DO SUL',NULL,9392,16950000,'SP','3532108',1,'2006-11-12 16:57:03'),(5124,NULL,1,23,'NANTES',NULL,9393,19645000,'SP','3532157',1,'2006-11-12 16:57:03'),(5125,NULL,1,23,'NARANDIBA',NULL,9394,19220000,'SP','3532207',1,'2006-11-12 16:57:03'),(5126,NULL,1,23,'NATIVIDADE DA SERRA',NULL,9395,12180000,'SP','3532306',1,'2006-11-12 16:57:03'),(5127,NULL,1,23,'NAZAR PAULISTA',NULL,9396,12960000,'SP','3532405',1,'2006-11-12 16:57:03'),(5128,NULL,1,23,'NEVES PAULISTA',NULL,9397,15120000,'SP','3532504',1,'2006-11-12 16:57:03'),(5129,NULL,1,23,'NHANDEARA',NULL,9398,15190000,'SP','3532603',1,'2006-11-12 16:57:03'),(5130,NULL,1,23,'NIPO',NULL,9399,15240000,'SP','3532702',1,'2006-11-12 16:57:03'),(5131,NULL,1,23,'NOVA ALIANA',NULL,9403,15210000,'SP','3532801',1,'2006-11-12 16:57:04'),(5132,NULL,1,23,'NOVA CAMPINA',NULL,9406,18435000,'SP','3532827',1,'2006-11-12 16:57:04'),(5133,NULL,1,23,'NOVA CANA PAULISTA',NULL,9407,15773000,'SP','3532843',1,'2006-11-12 16:57:04'),(5134,NULL,1,23,'NOVA CASTILHO',NULL,9408,15313000,'SP','3532868',1,'2006-11-12 16:57:04'),(5135,NULL,1,23,'NOVA EUROPA',NULL,9409,14920000,'SP','3532900',1,'2006-11-12 16:57:04'),(5136,NULL,1,23,'NOVA GRANADA',NULL,9410,15440000,'SP','3533007',1,'2006-11-12 16:57:04'),(5137,NULL,1,23,'NOVA GUATAPORANGA',NULL,9411,17950000,'SP','3533106',1,'2006-11-12 16:57:04'),(5138,NULL,1,23,'NOVA INDEPENDNCIA',NULL,9412,16940000,'SP','3533205',1,'2006-11-12 16:57:04'),(5139,NULL,1,23,'NOVA LUZITNIA',NULL,9414,15340000,'SP','3533304',1,'2006-11-12 16:57:04'),(5140,NULL,1,23,'NOVA ODESSA',NULL,9415,13460000,'SP','3533403',1,'2006-11-12 16:57:04'),(5141,NULL,1,23,'NOVAIS',NULL,9418,15885000,'SP','3533254',1,'2006-11-12 16:57:04'),(5142,NULL,1,23,'NOVO HORIZONTE',NULL,9420,14960000,'SP','3533502',1,'2006-11-12 16:57:04'),(5143,NULL,1,23,'NUPORANGA',NULL,9421,14670000,'SP','3533601',1,'2006-11-12 16:57:04'),(5144,NULL,1,23,'OCAUU',NULL,9423,17540000,'SP','3533700',1,'2006-11-12 16:57:04'),(5145,NULL,1,23,'LEO',NULL,9424,18790000,'SP','3533809',1,'2006-11-12 16:57:04'),(5146,NULL,1,23,'OLMPIA',NULL,9425,15400000,'SP','3533908',1,'2006-11-12 16:57:04'),(5147,NULL,1,23,'ONDA VERDE',NULL,9428,15450000,'SP','3534005',1,'2006-11-12 16:57:04'),(5148,NULL,1,23,'ORIENTE',NULL,9429,17570000,'SP','3534104',1,'2006-11-12 16:57:04'),(5149,NULL,1,23,'ORINDIVA',NULL,9430,15480000,'SP','3534203',1,'2006-11-12 16:57:04'),(5150,NULL,1,23,'ORLNDIA',NULL,9431,14620000,'SP','3534302',1,'2006-11-12 16:57:04'),(5151,NULL,1,23,'OSASCO',NULL,9432,NULL,'SP','3534401',1,'2006-11-12 16:57:04'),(5152,NULL,1,23,'OSCAR BRESSANE',NULL,9433,19770000,'SP','3534500',1,'2006-11-12 16:57:04'),(5153,NULL,1,23,'OSVALDO CRUZ',NULL,9434,17700000,'SP','3534609',1,'2006-11-12 16:57:04'),(5154,NULL,1,23,'OURINHOS',NULL,9435,NULL,'SP','3534708',1,'2006-11-12 16:57:05'),(5155,NULL,1,23,'OURO VERDE',NULL,9437,17920000,'SP','3534807',1,'2006-11-12 16:57:05'),(5156,NULL,1,23,'OUROESTE',NULL,9438,15685000,'SP','3534757',1,'2006-11-12 16:57:05'),(5157,NULL,1,23,'PACAEMBU',NULL,9439,17860000,'SP','3534906',1,'2006-11-12 16:57:05'),(5158,NULL,1,23,'PALESTINA',NULL,9441,15470000,'SP','3535002',1,'2006-11-12 16:57:05'),(5159,NULL,1,23,'PALMARES PAULISTA',NULL,9442,15828000,'SP','3535101',1,'2006-11-12 16:57:05'),(5160,NULL,1,23,'PALMEIRA D\'OESTE',NULL,9443,15720000,'SP',NULL,1,'2006-11-12 16:57:05'),(5161,NULL,1,23,'PALMITAL',NULL,9445,19970000,'SP','3535309',1,'2006-11-12 16:57:05'),(5162,NULL,1,23,'PANORAMA',NULL,9446,17980000,'SP','3535408',1,'2006-11-12 16:57:05'),(5163,NULL,1,23,'PARAGUAU PAULISTA',NULL,9447,19700000,'SP','3535507',1,'2006-11-12 16:57:05'),(5164,NULL,1,23,'PARAIBUNA',NULL,9448,12260000,'SP','3535606',1,'2006-11-12 16:57:05'),(5165,NULL,1,23,'PARASO',NULL,9449,15825000,'SP','3535705',1,'2006-11-12 16:57:05'),(5166,NULL,1,23,'PARANAPANEMA',NULL,9452,18720000,'SP','3535804',1,'2006-11-12 16:57:05'),(5167,NULL,1,23,'PARANAPU',NULL,9454,15745000,'SP','3535903',1,'2006-11-12 16:57:05'),(5168,NULL,1,23,'PARAPU',NULL,9455,17730000,'SP','3536000',1,'2006-11-12 16:57:05'),(5169,NULL,1,23,'PARDINHO',NULL,9456,18640000,'SP','3536109',1,'2006-11-12 16:57:05'),(5170,NULL,1,23,'PARIQUERA-AU',NULL,9457,11930000,'SP','3536208',1,'2006-11-12 16:57:05'),(5171,NULL,1,23,'PARISI',NULL,9458,15525000,'SP','3536257',1,'2006-11-12 16:57:05'),(5172,NULL,1,23,'PATROCNIO PAULISTA',NULL,9462,14415000,'SP','3536307',1,'2006-11-12 16:57:05'),(5173,NULL,1,23,'PAULICIA',NULL,9463,17990000,'SP','3536406',1,'2006-11-12 16:57:05'),(5174,NULL,1,23,'PAULNIA',NULL,9464,13140000,'SP','3536505',1,'2006-11-12 16:57:05'),(5175,NULL,1,23,'PAULISTNIA',NULL,9465,17150000,'SP','3536570',1,'2006-11-12 16:57:05'),(5176,NULL,1,23,'PAULO DE FARIA',NULL,9466,15490000,'SP','3536604',1,'2006-11-12 16:57:05'),(5177,NULL,1,23,'PEDERNEIRAS',NULL,9468,17280000,'SP','3536703',1,'2006-11-12 16:57:06'),(5178,NULL,1,23,'PEDRA BELA',NULL,9469,12990000,'SP','3536802',1,'2006-11-12 16:57:06'),(5179,NULL,1,23,'PEDRANPOLIS',NULL,9471,15630000,'SP','3536901',1,'2006-11-12 16:57:06'),(5180,NULL,1,23,'PEDREGULHO',NULL,9472,14470000,'SP','3537008',1,'2006-11-12 16:57:06'),(5181,NULL,1,23,'PEDREIRA',NULL,9473,13920000,'SP','3537107',1,'2006-11-12 16:57:06'),(5182,NULL,1,23,'PEDRINHAS PAULISTA',NULL,9474,19865000,'SP','3537156',1,'2006-11-12 16:57:06'),(5183,NULL,1,23,'PEDRO DE TOLEDO',NULL,9476,11790000,'SP','3537206',1,'2006-11-12 16:57:06'),(5184,NULL,1,23,'PENPOLIS',NULL,9477,16300000,'SP','3537305',1,'2006-11-12 16:57:06'),(5185,NULL,1,23,'PEREIRA BARRETO',NULL,9478,15370000,'SP','3537404',1,'2006-11-12 16:57:06'),(5186,NULL,1,23,'PEREIRAS',NULL,9479,18580000,'SP','3537503',1,'2006-11-12 16:57:06'),(5187,NULL,1,23,'PERUBE',NULL,9480,11750000,'SP','3537602',1,'2006-11-12 16:57:06'),(5188,NULL,1,23,'PIACATU',NULL,9481,16230000,'SP','3537701',1,'2006-11-12 16:57:06'),(5189,NULL,1,23,'PIEDADE',NULL,9483,18170000,'SP','3537800',1,'2006-11-12 16:57:06'),(5190,NULL,1,23,'PILAR DO SUL',NULL,9484,18185000,'SP','3537909',1,'2006-11-12 16:57:06'),(5191,NULL,1,23,'PINDAMONHANGABA',NULL,9485,NULL,'SP','3538006',1,'2006-11-12 16:57:06'),(5192,NULL,1,23,'PINDORAMA',NULL,9486,15830000,'SP','3538105',1,'2006-11-12 16:57:06'),(5193,NULL,1,23,'PINHALZINHO',NULL,9487,12995000,'SP','3538204',1,'2006-11-12 16:57:06'),(5194,NULL,1,23,'PIQUEROBI',NULL,9490,19410000,'SP','3538303',1,'2006-11-12 16:57:06'),(5195,NULL,1,23,'PIQUETE',NULL,9491,12620000,'SP','3538501',1,'2006-11-12 16:57:06'),(5196,NULL,1,23,'PIRACAIA',NULL,9492,12970000,'SP','3538600',1,'2006-11-12 16:57:06'),(5197,NULL,1,23,'PIRACICABA',NULL,9493,NULL,'SP','3538709',1,'2006-11-12 16:57:06'),(5198,NULL,1,23,'PIRAJU',NULL,9494,18800000,'SP','3538808',1,'2006-11-12 16:57:06'),(5199,NULL,1,23,'PIRAJU',NULL,9495,16600000,'SP','3538907',1,'2006-11-12 16:57:06'),(5200,NULL,1,23,'PIRANGI',NULL,9497,15820000,'SP','3539004',1,'2006-11-12 16:57:07'),(5201,NULL,1,23,'PIRAPORA DO BOM JESUS',NULL,9499,6550000,'SP','3539103',1,'2006-11-12 16:57:07'),(5202,NULL,1,23,'PIRAPOZINHO',NULL,9500,19200000,'SP','3539202',1,'2006-11-12 16:57:07'),(5203,NULL,1,23,'PIRASSUNUNGA',NULL,9501,NULL,'SP','3539301',1,'2006-11-12 16:57:07'),(5204,NULL,1,23,'PIRATININGA',NULL,9502,17490000,'SP','3539400',1,'2006-11-12 16:57:07'),(5205,NULL,1,23,'PITANGUEIRAS',NULL,9503,14750000,'SP','3539509',1,'2006-11-12 16:57:07'),(5206,NULL,1,23,'PLANALTO',NULL,9504,15260000,'SP','3539608',1,'2006-11-12 16:57:07'),(5207,NULL,1,23,'PLATINA',NULL,9507,19990000,'SP','3539707',1,'2006-11-12 16:57:07'),(5208,NULL,1,23,'PO',NULL,9508,NULL,'SP','3539806',1,'2006-11-12 16:57:07'),(5209,NULL,1,23,'POLONI',NULL,9509,15160000,'SP','3539905',1,'2006-11-12 16:57:07'),(5210,NULL,1,23,'POMPIA',NULL,9511,17580000,'SP','3540002',1,'2006-11-12 16:57:07'),(5211,NULL,1,23,'PONGA',NULL,9512,16660000,'SP','3540101',1,'2006-11-12 16:57:07'),(5212,NULL,1,23,'PONTAL',NULL,9513,14180000,'SP','3540200',1,'2006-11-12 16:57:07'),(5213,NULL,1,23,'PONTALINDA',NULL,9514,15718000,'SP','3540259',1,'2006-11-12 16:57:07'),(5214,NULL,1,23,'PONTES GESTAL',NULL,9515,15560000,'SP','3540309',1,'2006-11-12 16:57:07'),(5215,NULL,1,23,'POPULINA',NULL,9516,15670000,'SP','3540408',1,'2006-11-12 16:57:07'),(5216,NULL,1,23,'PORANGABA',NULL,9517,18260000,'SP','3540507',1,'2006-11-12 16:57:07'),(5217,NULL,1,23,'PORTO FELIZ',NULL,9518,18540000,'SP','3540606',1,'2006-11-12 16:57:07'),(5218,NULL,1,23,'PORTO FERREIRA',NULL,9519,13660000,'SP','3540705',1,'2006-11-12 16:57:07'),(5219,NULL,1,23,'POTIM',NULL,9521,12525000,'SP','3540754',1,'2006-11-12 16:57:08'),(5220,NULL,1,23,'POTIRENDABA',NULL,9522,15105000,'SP','3540804',1,'2006-11-12 16:57:08'),(5221,NULL,1,23,'PRACINHA',NULL,9524,17790000,'SP','3540853',1,'2006-11-12 16:57:08'),(5222,NULL,1,23,'PRADPOLIS',NULL,9526,14850000,'SP','3540903',1,'2006-11-12 16:57:08'),(5223,NULL,1,23,'PRAIA GRANDE',NULL,9527,NULL,'SP','3541000',1,'2006-11-12 16:57:08'),(5224,NULL,1,23,'PRATNIA',NULL,9528,18660000,'SP','3541059',1,'2006-11-12 16:57:08'),(5225,NULL,1,23,'PRESIDENTE ALVES',NULL,9529,16670000,'SP','3541109',1,'2006-11-12 16:57:08'),(5226,NULL,1,23,'PRESIDENTE BERNARDES',NULL,9530,19300000,'SP','3541208',1,'2006-11-12 16:57:08'),(5227,NULL,1,23,'PRESIDENTE EPITCIO',NULL,9531,19470000,'SP','3541307',1,'2006-11-12 16:57:08'),(5228,NULL,1,23,'PRESIDENTE PRUDENTE',NULL,9532,NULL,'SP','3541406',1,'2006-11-12 16:57:08'),(5229,NULL,1,23,'PRESIDENTE VENCESLAU',NULL,9533,19400000,'SP','3541505',1,'2006-11-12 16:57:08'),(5230,NULL,1,23,'PROMISSO',NULL,9535,16370000,'SP','3541604',1,'2006-11-12 16:57:08'),(5231,NULL,1,23,'QUADRA',NULL,9537,18255000,'SP','3541653',1,'2006-11-12 16:57:08'),(5232,NULL,1,23,'QUAT',NULL,9538,19780000,'SP','3541703',1,'2006-11-12 16:57:08'),(5233,NULL,1,23,'QUEIROZ',NULL,9539,17590000,'SP','3541802',1,'2006-11-12 16:57:08'),(5234,NULL,1,23,'QUELUZ',NULL,9540,12800000,'SP','3541901',1,'2006-11-12 16:57:08'),(5235,NULL,1,23,'QUINTANA',NULL,9541,17670000,'SP','3542008',1,'2006-11-12 16:57:08'),(5236,NULL,1,23,'RAFARD',NULL,9543,13370000,'SP','3542107',1,'2006-11-12 16:57:08'),(5237,NULL,1,23,'RANCHARIA',NULL,9544,19600000,'SP','3542206',1,'2006-11-12 16:57:08'),(5238,NULL,1,23,'REDENO DA SERRA',NULL,9546,12170000,'SP','3542305',1,'2006-11-12 16:57:08'),(5239,NULL,1,23,'REGENTE FEIJ',NULL,9547,19570000,'SP','3542404',1,'2006-11-12 16:57:08'),(5240,NULL,1,23,'REGINPOLIS',NULL,9548,17190000,'SP','3542503',1,'2006-11-12 16:57:08'),(5241,NULL,1,23,'REGISTRO',NULL,9549,11900000,'SP','3542602',1,'2006-11-12 16:57:09'),(5242,NULL,1,23,'RESTINGA',NULL,9550,14430000,'SP','3542701',1,'2006-11-12 16:57:09'),(5243,NULL,1,23,'RIBEIRA',NULL,9552,18380000,'SP','3542800',1,'2006-11-12 16:57:09'),(5244,NULL,1,23,'RIBEIRO BONITO',NULL,9553,13580000,'SP','3542909',1,'2006-11-12 16:57:09'),(5245,NULL,1,23,'RIBEIRO BRANCO',NULL,9554,18430000,'SP','3543006',1,'2006-11-12 16:57:09'),(5246,NULL,1,23,'RIBEIRO CORRENTE',NULL,9555,14445000,'SP','3543105',1,'2006-11-12 16:57:09'),(5247,NULL,1,23,'RIBEIRO DO SUL',NULL,9556,19930000,'SP','3543204',1,'2006-11-12 16:57:09'),(5248,NULL,1,23,'RIBEIRO DOS NDIOS',NULL,9557,19380000,'SP','3543238',1,'2006-11-12 16:57:09'),(5249,NULL,1,23,'RIBEIRO GRANDE',NULL,9558,18315000,'SP','3543253',1,'2006-11-12 16:57:09'),(5250,NULL,1,23,'RIBEIRO PIRES',NULL,9559,NULL,'SP','3543303',1,'2006-11-12 16:57:09'),(5251,NULL,1,23,'RIBEIRO PRETO',NULL,9560,NULL,'SP','3543402',1,'2006-11-12 16:57:09'),(5252,NULL,1,23,'RIFAINA',NULL,9563,14490000,'SP','3543600',1,'2006-11-12 16:57:09'),(5253,NULL,1,23,'RINCO',NULL,9564,14830000,'SP','3543709',1,'2006-11-12 16:57:09'),(5254,NULL,1,23,'RINPOLIS',NULL,9565,17740000,'SP','3543808',1,'2006-11-12 16:57:09'),(5255,NULL,1,23,'RIO CLARO',NULL,9566,NULL,'SP','3543907',1,'2006-11-12 16:57:09'),(5256,NULL,1,23,'RIO DAS PEDRAS',NULL,9567,13390000,'SP','3544004',1,'2006-11-12 16:57:09'),(5257,NULL,1,23,'RIO GRANDE DA SERRA',NULL,9568,9450000,'SP','3544103',1,'2006-11-12 16:57:09'),(5258,NULL,1,23,'RIOLNDIA',NULL,9569,15495000,'SP','3544202',1,'2006-11-12 16:57:09'),(5259,NULL,1,23,'RIVERSUL',NULL,9570,18470000,'SP','3543501',1,'2006-11-12 16:57:09'),(5260,NULL,1,23,'ROSANA',NULL,9573,19273000,'SP','3544251',1,'2006-11-12 16:57:09'),(5261,NULL,1,23,'ROSEIRA',NULL,9574,12580000,'SP','3544301',1,'2006-11-12 16:57:09'),(5262,NULL,1,23,'RUBICEA',NULL,9575,16750000,'SP','3544400',1,'2006-11-12 16:57:09'),(5263,NULL,1,23,'RUBINIA',NULL,9577,15790000,'SP','3544509',1,'2006-11-12 16:57:10'),(5264,NULL,1,23,'SABINO',NULL,9580,16440000,'SP','3544608',1,'2006-11-12 16:57:10'),(5265,NULL,1,23,'SAGRES',NULL,9581,17710000,'SP','3544707',1,'2006-11-12 16:57:10'),(5266,NULL,1,23,'SALES',NULL,9582,14980000,'SP','3544806',1,'2006-11-12 16:57:10'),(5267,NULL,1,23,'SALES OLIVEIRA',NULL,9583,14660000,'SP','3544905',1,'2006-11-12 16:57:10'),(5268,NULL,1,23,'SALESPOLIS',NULL,9584,8970000,'SP','3545001',1,'2006-11-12 16:57:10'),(5269,NULL,1,23,'SALMOURO',NULL,9585,17720000,'SP','3545100',1,'2006-11-12 16:57:10'),(5270,NULL,1,23,'SALTINHO',NULL,9586,13440000,'SP','3545159',1,'2006-11-12 16:57:10'),(5271,NULL,1,23,'SALTO',NULL,9587,NULL,'SP','3545209',1,'2006-11-12 16:57:10'),(5272,NULL,1,23,'SALTO DE PIRAPORA',NULL,9588,18160000,'SP','3545308',1,'2006-11-12 16:57:10'),(5273,NULL,1,23,'SALTO GRANDE',NULL,9590,19920000,'SP','3545407',1,'2006-11-12 16:57:10'),(5274,NULL,1,23,'SANDOVALINA',NULL,9591,19250000,'SP','3545506',1,'2006-11-12 16:57:10'),(5275,NULL,1,23,'SANTA ADLIA',NULL,9592,15950000,'SP','3545605',1,'2006-11-12 16:57:10'),(5276,NULL,1,23,'SANTA ALBERTINA',NULL,9593,15750000,'SP','3545704',1,'2006-11-12 16:57:10'),(5277,NULL,1,23,'SANTA BRBARA D\'OESTE',NULL,9595,NULL,'SP',NULL,1,'2006-11-12 16:57:10'),(5278,NULL,1,23,'SANTA BRANCA',NULL,9596,12380000,'SP','3546009',1,'2006-11-12 16:57:10'),(5279,NULL,1,23,'SANTA CLARA D\'OESTE',NULL,9597,15785000,'SP',NULL,1,'2006-11-12 16:57:10'),(5280,NULL,1,23,'SANTA CRUZ DA CONCEIO',NULL,9598,13625000,'SP','3546207',1,'2006-11-12 16:57:10'),(5281,NULL,1,23,'SANTA CRUZ DA ESPERANA',NULL,9599,14250000,'SP','3546256',1,'2006-11-12 16:57:10'),(5282,NULL,1,23,'SANTA CRUZ DAS PALMEIRAS',NULL,9601,13650000,'SP','3546306',1,'2006-11-12 16:57:10'),(5283,NULL,1,23,'SANTA CRUZ DO RIO PARDO',NULL,9602,18900000,'SP','3546405',1,'2006-11-12 16:57:10'),(5284,NULL,1,23,'SANTA ERNESTINA',NULL,9604,15970000,'SP','3546504',1,'2006-11-12 16:57:10'),(5285,NULL,1,23,'SANTA F DO SUL',NULL,9606,15775000,'SP','3546603',1,'2006-11-12 16:57:10'),(5286,NULL,1,23,'SANTA GERTRUDES',NULL,9607,13510000,'SP','3546702',1,'2006-11-12 16:57:11'),(5287,NULL,1,23,'SANTA ISABEL',NULL,9608,7500000,'SP','3546801',1,'2006-11-12 16:57:11'),(5288,NULL,1,23,'SANTA LCIA',NULL,9610,14825000,'SP','3546900',1,'2006-11-12 16:57:11'),(5289,NULL,1,23,'SANTA MARIA DA SERRA',NULL,9612,17370000,'SP','3547007',1,'2006-11-12 16:57:11'),(5290,NULL,1,23,'SANTA MERCEDES',NULL,9614,17940000,'SP','3547106',1,'2006-11-12 16:57:11'),(5291,NULL,1,23,'SANTA RITA D\'OESTE',NULL,9615,15780000,'SP',NULL,1,'2006-11-12 16:57:11'),(5292,NULL,1,23,'SANTA RITA DO PASSA QUATRO',NULL,9616,13670000,'SP','3547502',1,'2006-11-12 16:57:11'),(5293,NULL,1,23,'SANTA ROSA DE VITERBO',NULL,9618,14270000,'SP','3547601',1,'2006-11-12 16:57:11'),(5294,NULL,1,23,'SANTA SALETE',NULL,9619,15768000,'SP','3547650',1,'2006-11-12 16:57:11'),(5295,NULL,1,23,'SANTANA DA PONTE PENSA',NULL,9621,15765000,'SP','3547205',1,'2006-11-12 16:57:11'),(5296,NULL,1,23,'SANTANA DE PARNABA',NULL,9622,NULL,'SP','3547304',1,'2006-11-12 16:57:11'),(5297,NULL,1,23,'SANTO ANASTCIO',NULL,9624,19360000,'SP','3547700',1,'2006-11-12 16:57:11'),(5298,NULL,1,23,'SANTO ANDR',NULL,9625,NULL,'SP','3547809',1,'2006-11-12 16:57:11'),(5299,NULL,1,23,'SANTO ANTNIO DA ALEGRIA',NULL,9626,14390000,'SP','3547908',1,'2006-11-12 16:57:11'),(5300,NULL,1,23,'SANTO ANTNIO DE POSSE',NULL,9628,13830000,'SP','3548005',1,'2006-11-12 16:57:11'),(5301,NULL,1,23,'SANTO ANTNIO DO ARACANGU',NULL,9629,16130000,'SP','3548054',1,'2006-11-12 16:57:11'),(5302,NULL,1,23,'SANTO ANTNIO DO JARDIM',NULL,9630,13995000,'SP','3548104',1,'2006-11-12 16:57:11'),(5303,NULL,1,23,'SANTO ANTNIO DO PINHAL',NULL,9632,12450000,'SP','3548203',1,'2006-11-12 16:57:11'),(5304,NULL,1,23,'SANTO EXPEDITO',NULL,9634,19190000,'SP','3548302',1,'2006-11-12 16:57:11'),(5305,NULL,1,23,'SANTPOLIS DO AGUAPE',NULL,9635,16240000,'SP','3548401',1,'2006-11-12 16:57:11'),(5306,NULL,1,23,'SANTOS',NULL,9636,NULL,'SP','3548500',1,'2006-11-12 16:57:11'),(5307,NULL,1,23,'SO BENTO DO SAPUCA',NULL,9639,12490000,'SP','3548609',1,'2006-11-12 16:57:11'),(5308,NULL,1,23,'SO BERNARDO DO CAMPO',NULL,9640,NULL,'SP','3548708',1,'2006-11-12 16:57:11'),(5309,NULL,1,23,'SO CAETANO DO SUL',NULL,9642,NULL,'SP','3548807',1,'2006-11-12 16:57:12'),(5310,NULL,1,23,'SO CARLOS',NULL,9643,NULL,'SP','3548906',1,'2006-11-12 16:57:12'),(5311,NULL,1,23,'SO FRANCISCO',NULL,9644,15710000,'SP','3549003',1,'2006-11-12 16:57:12'),(5312,NULL,1,23,'SO JOO DA BOA VISTA',NULL,9647,NULL,'SP','3549102',1,'2006-11-12 16:57:12'),(5313,NULL,1,23,'SO JOO DAS DUAS PONTES',NULL,9648,15640000,'SP','3549201',1,'2006-11-12 16:57:12'),(5314,NULL,1,23,'SO JOO DE IRACEMA',NULL,9649,15315000,'SP','3549250',1,'2006-11-12 16:57:12'),(5315,NULL,1,23,'SO JOO DO PAU D\'ALHO',NULL,9652,17970000,'SP',NULL,1,'2006-11-12 16:57:12'),(5316,NULL,1,23,'SO JOAQUIM DA BARRA',NULL,9654,14600000,'SP','3549409',1,'2006-11-12 16:57:12'),(5317,NULL,1,23,'SO JOS DA BELA VISTA',NULL,9655,14440000,'SP','3549508',1,'2006-11-12 16:57:12'),(5318,NULL,1,23,'SO JOS DO BARREIRO',NULL,9657,12830000,'SP','3549607',1,'2006-11-12 16:57:12'),(5319,NULL,1,23,'SO JOS DO RIO PARDO',NULL,9658,13720000,'SP','3549706',1,'2006-11-12 16:57:12'),(5320,NULL,1,23,'SO JOS DO RIO PRETO',NULL,9659,NULL,'SP','3549805',1,'2006-11-12 16:57:12'),(5321,NULL,1,23,'SO JOS DOS CAMPOS',NULL,9660,NULL,'SP','3549904',1,'2006-11-12 16:57:12'),(5322,NULL,1,23,'SO LOURENO DA SERRA',NULL,9661,6890000,'SP','3549953',1,'2006-11-12 16:57:12'),(5323,NULL,1,23,'SO LUIZ DO PARAITINGA',NULL,9663,12140000,'SP',NULL,1,'2006-11-12 16:57:12'),(5324,NULL,1,23,'SO MANUEL',NULL,9665,18650000,'SP','3550100',1,'2006-11-12 16:57:12'),(5325,NULL,1,23,'SO MIGUEL ARCANJO',NULL,9667,18230000,'SP','3550209',1,'2006-11-12 16:57:12'),(5326,NULL,1,23,'SO PAULO',NULL,9668,NULL,'SP','3550308',1,'2006-11-12 16:57:12'),(5327,NULL,1,23,'SO PEDRO',NULL,9669,13520000,'SP','3550407',1,'2006-11-12 16:57:12'),(5328,NULL,1,23,'SO PEDRO DO TURVO',NULL,9670,18940000,'SP','3550506',1,'2006-11-12 16:57:12'),(5329,NULL,1,23,'SO ROQUE',NULL,9671,NULL,'SP','3550605',1,'2006-11-12 16:57:12'),(5330,NULL,1,23,'SO SEBASTIO',NULL,9673,11600000,'SP','3550704',1,'2006-11-12 16:57:12'),(5331,NULL,1,23,'SO SEBASTIO DA GRAMA',NULL,9674,13790000,'SP','3550803',1,'2006-11-12 16:57:13'),(5332,NULL,1,23,'SO SIMO',NULL,9677,14200000,'SP','3550902',1,'2006-11-12 16:57:13'),(5333,NULL,1,23,'SO VICENTE',NULL,9678,NULL,'SP','3551009',1,'2006-11-12 16:57:13'),(5334,NULL,1,23,'SARAPU',NULL,9680,18225000,'SP','3551108',1,'2006-11-12 16:57:13'),(5335,NULL,1,23,'SARUTAI',NULL,9681,18840000,'SP','3551207',1,'2006-11-12 16:57:13'),(5336,NULL,1,23,'SEBASTIANPOLIS DO SUL',NULL,9682,15180000,'SP','3551306',1,'2006-11-12 16:57:13'),(5337,NULL,1,23,'SERRA AZUL',NULL,9683,14230000,'SP','3551405',1,'2006-11-12 16:57:13'),(5338,NULL,1,23,'SERRA NEGRA',NULL,9684,13930000,'SP','3551603',1,'2006-11-12 16:57:13'),(5339,NULL,1,23,'SERRANA',NULL,9685,14150000,'SP','3551504',1,'2006-11-12 16:57:13'),(5340,NULL,1,23,'SERTOZINHO',NULL,9686,NULL,'SP','3551702',1,'2006-11-12 16:57:13'),(5341,NULL,1,23,'SETE BARRAS',NULL,9687,11910000,'SP','3551801',1,'2006-11-12 16:57:13'),(5342,NULL,1,23,'SEVERNIA',NULL,9688,14735000,'SP','3551900',1,'2006-11-12 16:57:13'),(5343,NULL,1,23,'SILVEIRAS',NULL,9690,12690000,'SP','3552007',1,'2006-11-12 16:57:13'),(5344,NULL,1,23,'SOCORRO',NULL,9693,13960000,'SP','3552106',1,'2006-11-12 16:57:13'),(5345,NULL,1,23,'SOROCABA',NULL,9696,NULL,'SP','3552205',1,'2006-11-12 16:57:13'),(5346,NULL,1,23,'SUD MENNUCCI',NULL,9698,15360000,'SP','3552304',1,'2006-11-12 16:57:13'),(5347,NULL,1,23,'SUMAR',NULL,9700,NULL,'SP','3552403',1,'2006-11-12 16:57:13'),(5348,NULL,1,23,'SUZANPOLIS',NULL,9702,15380000,'SP','3552551',1,'2006-11-12 16:57:13'),(5349,NULL,1,23,'SUZANO',NULL,9703,NULL,'SP','3552502',1,'2006-11-12 16:57:13'),(5350,NULL,1,23,'TABAPU',NULL,9705,15880000,'SP','3552601',1,'2006-11-12 16:57:13'),(5351,NULL,1,23,'TABATINGA',NULL,9706,14910000,'SP','3552700',1,'2006-11-12 16:57:13'),(5352,NULL,1,23,'TABOO DA SERRA',NULL,9707,NULL,'SP','3552809',1,'2006-11-12 16:57:13'),(5353,NULL,1,23,'TACIBA',NULL,9708,19590000,'SP','3552908',1,'2006-11-12 16:57:14'),(5354,NULL,1,23,'TAGUA',NULL,9709,18890000,'SP','3553005',1,'2006-11-12 16:57:14'),(5355,NULL,1,23,'TAIAU',NULL,9710,14725000,'SP','3553104',1,'2006-11-12 16:57:14'),(5356,NULL,1,23,'TAIVA',NULL,9712,14720000,'SP','3553203',1,'2006-11-12 16:57:14'),(5357,NULL,1,23,'TAMBA',NULL,9714,13710000,'SP','3553302',1,'2006-11-12 16:57:14'),(5358,NULL,1,23,'TANABI',NULL,9715,15170000,'SP','3553401',1,'2006-11-12 16:57:14'),(5359,NULL,1,23,'TAPIRA',NULL,9717,18180000,'SP','3553500',1,'2006-11-12 16:57:14'),(5360,NULL,1,23,'TAPIRATIBA',NULL,9718,13760000,'SP','3553609',1,'2006-11-12 16:57:14'),(5361,NULL,1,23,'TAQUARAL',NULL,9719,14765000,'SP','3553658',1,'2006-11-12 16:57:14'),(5362,NULL,1,23,'TAQUARITINGA',NULL,9720,15900000,'SP','3553708',1,'2006-11-12 16:57:14'),(5363,NULL,1,23,'TAQUARITUBA',NULL,9721,18740000,'SP','3553807',1,'2006-11-12 16:57:14'),(5364,NULL,1,23,'TAQUARIVA',NULL,9722,18425000,'SP','3553856',1,'2006-11-12 16:57:14'),(5365,NULL,1,23,'TARABAI',NULL,9723,19210000,'SP','3553906',1,'2006-11-12 16:57:14'),(5366,NULL,1,23,'TARUM',NULL,9724,19820000,'SP','3553955',1,'2006-11-12 16:57:14'),(5367,NULL,1,23,'TATU',NULL,9725,NULL,'SP','3554003',1,'2006-11-12 16:57:14'),(5368,NULL,1,23,'TAUBAT',NULL,9726,NULL,'SP','3554102',1,'2006-11-12 16:57:14'),(5369,NULL,1,23,'TEJUP',NULL,9728,18830000,'SP','3554201',1,'2006-11-12 16:57:14'),(5370,NULL,1,23,'TEODORO SAMPAIO',NULL,9729,19280000,'SP','3554300',1,'2006-11-12 16:57:14'),(5371,NULL,1,23,'TERRA ROXA',NULL,9732,14745000,'SP','3554409',1,'2006-11-12 16:57:14'),(5372,NULL,1,23,'TIET',NULL,9735,18530000,'SP','3554508',1,'2006-11-12 16:57:14'),(5373,NULL,1,23,'TIMBURI',NULL,9736,18860000,'SP','3554607',1,'2006-11-12 16:57:14'),(5374,NULL,1,23,'TORRE DE PEDRA',NULL,9738,18265000,'SP','3554656',1,'2006-11-12 16:57:14'),(5375,NULL,1,23,'TORRINHA',NULL,9739,17360000,'SP','3554706',1,'2006-11-12 16:57:14'),(5376,NULL,1,23,'TRABIJU',NULL,9740,14935000,'SP','3554755',1,'2006-11-12 16:57:15'),(5377,NULL,1,23,'TREMEMB',NULL,9741,12120000,'SP','3554805',1,'2006-11-12 16:57:15'),(5378,NULL,1,23,'TRS FRONTEIRAS',NULL,9743,15770000,'SP','3554904',1,'2006-11-12 16:57:15'),(5379,NULL,1,23,'TUIUTI',NULL,9746,12930000,'SP','3554953',1,'2006-11-12 16:57:15'),(5380,NULL,1,23,'TUP',NULL,9748,NULL,'SP','3555000',1,'2006-11-12 16:57:15'),(5381,NULL,1,23,'TUPI PAULISTA',NULL,9750,17930000,'SP','3555109',1,'2006-11-12 16:57:15'),(5382,NULL,1,23,'TURIBA',NULL,9752,15280000,'SP','3555208',1,'2006-11-12 16:57:15'),(5383,NULL,1,23,'TURMALINA',NULL,9753,15755000,'SP','3555307',1,'2006-11-12 16:57:15'),(5384,NULL,1,23,'UBARANA',NULL,9755,15225000,'SP','3555356',1,'2006-11-12 16:57:15'),(5385,NULL,1,23,'UBATUBA',NULL,9756,11680000,'SP','3555406',1,'2006-11-12 16:57:15'),(5386,NULL,1,23,'UBIRAJARA',NULL,9757,17440000,'SP','3555505',1,'2006-11-12 16:57:15'),(5387,NULL,1,23,'UCHOA',NULL,9758,15890000,'SP','3555604',1,'2006-11-12 16:57:15'),(5388,NULL,1,23,'UNIO PAULISTA',NULL,9759,15250000,'SP','3555703',1,'2006-11-12 16:57:15'),(5389,NULL,1,23,'URNIA',NULL,9761,15760000,'SP','3555802',1,'2006-11-12 16:57:15'),(5390,NULL,1,23,'URU',NULL,9762,16650000,'SP','3555901',1,'2006-11-12 16:57:15'),(5391,NULL,1,23,'URUPS',NULL,9763,15850000,'SP','3556008',1,'2006-11-12 16:57:15'),(5392,NULL,1,23,'VALENTIM GENTIL',NULL,9767,15520000,'SP','3556107',1,'2006-11-12 16:57:15'),(5393,NULL,1,23,'VALINHOS',NULL,9768,NULL,'SP','3556206',1,'2006-11-12 16:57:15'),(5394,NULL,1,23,'VALPARASO',NULL,9769,16880000,'SP','3556305',1,'2006-11-12 16:57:15'),(5395,NULL,1,23,'VARGEM',NULL,9771,12935000,'SP','3556354',1,'2006-11-12 16:57:15'),(5396,NULL,1,23,'VARGEM GRANDE DO SUL',NULL,9772,13880000,'SP','3556404',1,'2006-11-12 16:57:15'),(5397,NULL,1,23,'VARGEM GRANDE PAULISTA',NULL,9773,6730000,'SP','3556453',1,'2006-11-12 16:57:15'),(5398,NULL,1,23,'VRZEA PAULISTA',NULL,9775,NULL,'SP','3556503',1,'2006-11-12 16:57:15'),(5399,NULL,1,23,'VERA CRUZ',NULL,9777,17560000,'SP','3556602',1,'2006-11-12 16:57:16'),(5400,NULL,1,23,'VINHEDO',NULL,9783,13280000,'SP','3556701',1,'2006-11-12 16:57:16'),(5401,NULL,1,23,'VIRADOURO',NULL,9784,14740000,'SP','3556800',1,'2006-11-12 16:57:16'),(5402,NULL,1,23,'VISTA ALEGRE DO ALTO',NULL,9785,15920000,'SP','3556909',1,'2006-11-12 16:57:16'),(5403,NULL,1,23,'VITRIA BRASIL',NULL,9786,15705000,'SP','3556958',1,'2006-11-12 16:57:16'),(5404,NULL,1,23,'VOTORANTIM',NULL,9788,NULL,'SP','3557006',1,'2006-11-12 16:57:16'),(5405,NULL,1,23,'VOTUPORANGA',NULL,9789,NULL,'SP','3557105',1,'2006-11-12 16:57:16'),(5406,NULL,1,23,'ZACARIAS',NULL,9790,15265000,'SP','3557154',1,'2006-11-12 16:57:16'),(5407,NULL,1,11,'ABREULNDIA',NULL,9791,77693000,'TO','1700251',1,'2006-11-12 16:57:16'),(5408,NULL,1,11,'AGUIARNPOLIS',NULL,9792,77908000,'TO','1700301',1,'2006-11-12 16:57:16'),(5409,NULL,1,11,'ALIANA DO TOCANTINS',NULL,9793,77455000,'TO','1700350',1,'2006-11-12 16:57:16'),(5410,NULL,1,11,'ALMAS',NULL,9794,77310000,'TO','1700400',1,'2006-11-12 16:57:16'),(5411,NULL,1,11,'ALVORADA',NULL,9795,77480000,'TO','1700707',1,'2006-11-12 16:57:16'),(5412,NULL,1,11,'ANANS',NULL,9797,77890000,'TO','1701002',1,'2006-11-12 16:57:16'),(5413,NULL,1,11,'ANGICO',NULL,9798,77905000,'TO','1701051',1,'2006-11-12 16:57:16'),(5414,NULL,1,11,'APARECIDA DO RIO NEGRO',NULL,9799,77620000,'TO','1701101',1,'2006-11-12 16:57:16'),(5415,NULL,1,11,'ARAGOMINAS',NULL,9802,77845000,'TO','1701309',1,'2006-11-12 16:57:16'),(5416,NULL,1,11,'ARAGUACEMA',NULL,9803,77690000,'TO','1701903',1,'2006-11-12 16:57:16'),(5417,NULL,1,11,'ARAGUAU',NULL,9804,77475000,'TO','1702000',1,'2006-11-12 16:57:16'),(5418,NULL,1,11,'ARAGUANA',NULL,9805,NULL,'TO','1702109',1,'2006-11-12 16:57:16'),(5419,NULL,1,11,'ARAGUAN',NULL,9806,77855000,'TO','1702158',1,'2006-11-12 16:57:16'),(5420,NULL,1,11,'ARAGUATINS',NULL,9807,77950000,'TO','1702208',1,'2006-11-12 16:57:17'),(5421,NULL,1,11,'ARAPOEMA',NULL,9808,77780000,'TO','1702307',1,'2006-11-12 16:57:17'),(5422,NULL,1,11,'ARRAIAS',NULL,9809,77330000,'TO','1702406',1,'2006-11-12 16:57:17'),(5423,NULL,1,11,'AUGUSTINPOLIS',NULL,9810,77960000,'TO','1702554',1,'2006-11-12 16:57:17'),(5424,NULL,1,11,'AURORA DO TOCANTINS',NULL,9811,77325000,'TO','1702703',1,'2006-11-12 16:57:17'),(5425,NULL,1,11,'AXIX DO TOCANTINS',NULL,9812,77930000,'TO','1702901',1,'2006-11-12 16:57:17'),(5426,NULL,1,11,'BABAULNDIA',NULL,9813,77870000,'TO','1703008',1,'2006-11-12 16:57:17'),(5427,NULL,1,11,'BANDEIRANTES DO TOCANTINS',NULL,9814,77783000,'TO','1703057',1,'2006-11-12 16:57:17'),(5428,NULL,1,11,'BARRA DO OURO',NULL,9816,77765000,'TO','1703073',1,'2006-11-12 16:57:17'),(5429,NULL,1,11,'BARROLNDIA',NULL,9817,77665000,'TO','1703107',1,'2006-11-12 16:57:17'),(5430,NULL,1,11,'BERNARDO SAYO',NULL,9818,77755000,'TO','1703206',1,'2006-11-12 16:57:17'),(5431,NULL,1,11,'BOM JESUS DO TOCANTINS',NULL,9819,77714000,'TO','1703305',1,'2006-11-12 16:57:17'),(5432,NULL,1,11,'BRASILNDIA DO TOCANTINS',NULL,9821,77735000,'TO','1703602',1,'2006-11-12 16:57:17'),(5433,NULL,1,11,'BREJINHO DE NAZAR',NULL,9822,77560000,'TO','1703701',1,'2006-11-12 16:57:17'),(5434,NULL,1,11,'BURITI DO TOCANTINS',NULL,9823,77995000,'TO','1703800',1,'2006-11-12 16:57:17'),(5435,NULL,1,11,'CACHOEIRINHA',NULL,9824,77915000,'TO','1703826',1,'2006-11-12 16:57:17'),(5436,NULL,1,11,'CAMPOS LINDOS',NULL,9825,77777000,'TO','1703842',1,'2006-11-12 16:57:17'),(5437,NULL,1,11,'CARIRI DO TOCANTINS',NULL,9827,77453000,'TO','1703867',1,'2006-11-12 16:57:17'),(5438,NULL,1,11,'CARMOLNDIA',NULL,9828,77840000,'TO','1703883',1,'2006-11-12 16:57:17'),(5439,NULL,1,11,'CARRASCO BONITO',NULL,9829,77985000,'TO','1703891',1,'2006-11-12 16:57:17'),(5440,NULL,1,11,'CASEARA',NULL,9831,77680000,'TO','1703909',1,'2006-11-12 16:57:17'),(5441,NULL,1,11,'CENTENRIO',NULL,9832,77723000,'TO','1704105',1,'2006-11-12 16:57:17'),(5442,NULL,1,11,'CHAPADA DA AREIA',NULL,9833,77575000,'TO',NULL,1,'2006-11-12 16:57:17'),(5443,NULL,1,11,'CHAPADA DA NATIVIDADE',NULL,9834,77378000,'TO','1705102',1,'2006-11-12 16:57:18'),(5444,NULL,1,11,'COLINAS DO TOCANTINS',NULL,9837,77760000,'TO','1705508',1,'2006-11-12 16:57:18'),(5445,NULL,1,11,'COLMIA',NULL,9838,77725000,'TO','1716703',1,'2006-11-12 16:57:18'),(5446,NULL,1,11,'COMBINADO',NULL,9839,77350000,'TO','1705557',1,'2006-11-12 16:57:18'),(5447,NULL,1,11,'CONCEIO DO TOCANTINS',NULL,9840,77305000,'TO','1705607',1,'2006-11-12 16:57:18'),(5448,NULL,1,11,'COUTO DE MAGALHES',NULL,9842,77750000,'TO','1706001',1,'2006-11-12 16:57:18'),(5449,NULL,1,11,'CRISTALNDIA',NULL,9844,77490000,'TO','1706100',1,'2006-11-12 16:57:18'),(5450,NULL,1,11,'CRIXS DO TOCANTINS',NULL,9846,77463000,'TO','1706258',1,'2006-11-12 16:57:18'),(5451,NULL,1,11,'DARCINPOLIS',NULL,9847,77910000,'TO','1706506',1,'2006-11-12 16:57:18'),(5452,NULL,1,11,'DIANPOLIS',NULL,9848,77300000,'TO','1707009',1,'2006-11-12 16:57:18'),(5453,NULL,1,11,'DIVINPOLIS DO TOCANTINS',NULL,9849,77670000,'TO','1707108',1,'2006-11-12 16:57:18'),(5454,NULL,1,11,'DOIS IRMOS DO TOCANTINS',NULL,9850,77685000,'TO','1707207',1,'2006-11-12 16:57:18'),(5455,NULL,1,11,'DUER',NULL,9851,77485000,'TO','1707306',1,'2006-11-12 16:57:18'),(5456,NULL,1,11,'ESPERANTINA',NULL,9853,77993000,'TO','1707405',1,'2006-11-12 16:57:18'),(5457,NULL,1,11,'FTIMA',NULL,9854,77555000,'TO','1707553',1,'2006-11-12 16:57:18'),(5458,NULL,1,11,'FIGUEIRPOLIS',NULL,9855,77465000,'TO','1707652',1,'2006-11-12 16:57:18'),(5459,NULL,1,11,'FILADLFIA',NULL,9856,77795000,'TO','1707702',1,'2006-11-12 16:57:18'),(5460,NULL,1,11,'FORMOSO DO ARAGUAIA',NULL,9857,77470000,'TO','1708205',1,'2006-11-12 16:57:18'),(5461,NULL,1,11,'FORTALEZA DO TABOCO',NULL,9858,77708000,'TO','1708254',1,'2006-11-12 16:57:19'),(5462,NULL,1,11,'GOIANORTE',NULL,9859,77695000,'TO','1708304',1,'2006-11-12 16:57:19'),(5463,NULL,1,11,'GOIATINS',NULL,9860,77770000,'TO','1709005',1,'2006-11-12 16:57:19'),(5464,NULL,1,11,'GUARA',NULL,9861,77700000,'TO','1709302',1,'2006-11-12 16:57:19'),(5465,NULL,1,11,'GURUPI',NULL,9862,NULL,'TO','1709500',1,'2006-11-12 16:57:19'),(5466,NULL,1,11,'IPUEIRAS',NULL,9864,77553000,'TO','1709807',1,'2006-11-12 16:57:19'),(5467,NULL,1,11,'ITACAJ',NULL,9865,77720000,'TO','1710508',1,'2006-11-12 16:57:19'),(5468,NULL,1,11,'ITAGUATINS',NULL,9866,77920000,'TO','1710706',1,'2006-11-12 16:57:19'),(5469,NULL,1,11,'ITAPIRATINS',NULL,9867,77718000,'TO','1710904',1,'2006-11-12 16:57:19'),(5470,NULL,1,11,'ITAPOR DO TOCANTINS',NULL,9868,77740000,'TO','1711100',1,'2006-11-12 16:57:19'),(5471,NULL,1,11,'JA DO TOCANTINS',NULL,9869,77450000,'TO','1711506',1,'2006-11-12 16:57:19'),(5472,NULL,1,11,'JUARINA',NULL,9870,77753000,'TO','1711803',1,'2006-11-12 16:57:19'),(5473,NULL,1,11,'LAGOA DA CONFUSO',NULL,9872,77493000,'TO','1711902',1,'2006-11-12 16:57:19'),(5474,NULL,1,11,'LAGOA DO TOCANTINS',NULL,9873,77613000,'TO','1711951',1,'2006-11-12 16:57:19'),(5475,NULL,1,11,'LAJEADO',NULL,9874,77645000,'TO','1712009',1,'2006-11-12 16:57:19'),(5476,NULL,1,11,'LAVANDEIRA',NULL,9875,77328000,'TO','1712157',1,'2006-11-12 16:57:19'),(5477,NULL,1,11,'LIZARDA',NULL,9876,77630000,'TO','1712405',1,'2006-11-12 16:57:19'),(5478,NULL,1,11,'LUZINPOLIS',NULL,9877,77903000,'TO','1712454',1,'2006-11-12 16:57:19'),(5479,NULL,1,11,'MARIANPOLIS DO TOCANTINS',NULL,9878,77675000,'TO','1712504',1,'2006-11-12 16:57:19'),(5480,NULL,1,11,'MATEIROS',NULL,9879,77593000,'TO','1712702',1,'2006-11-12 16:57:19'),(5481,NULL,1,11,'MAURILNDIA DO TOCANTINS',NULL,9880,77918000,'TO','1712801',1,'2006-11-12 16:57:19'),(5482,NULL,1,11,'MIRACEMA DO TOCANTINS',NULL,9881,77650000,'TO','1713205',1,'2006-11-12 16:57:20'),(5483,NULL,1,11,'MIRANORTE',NULL,9883,77660000,'TO','1713304',1,'2006-11-12 16:57:20'),(5484,NULL,1,11,'MONTE DO CARMO',NULL,9884,77585000,'TO','1713601',1,'2006-11-12 16:57:20'),(5485,NULL,1,11,'MONTE SANTO DO TOCANTINS',NULL,9886,77673000,'TO','1713700',1,'2006-11-12 16:57:20'),(5486,NULL,1,11,'MOSQUITO',NULL,9887,77913000,'TO',NULL,1,'2006-11-12 16:57:20'),(5487,NULL,1,11,'MURICILNDIA',NULL,9888,77850000,'TO','1713957',1,'2006-11-12 16:57:20'),(5488,NULL,1,11,'NATIVIDADE',NULL,9890,77370000,'TO','1714203',1,'2006-11-12 16:57:20'),(5489,NULL,1,11,'NAZAR',NULL,9891,77895000,'TO','1714302',1,'2006-11-12 16:57:20'),(5490,NULL,1,11,'NOVA OLINDA',NULL,9892,77790000,'TO','1714880',1,'2006-11-12 16:57:20'),(5491,NULL,1,11,'NOVA ROSALNDIA',NULL,9893,77495000,'TO','1715002',1,'2006-11-12 16:57:20'),(5492,NULL,1,11,'NOVO ACORDO',NULL,9894,77610000,'TO','1715101',1,'2006-11-12 16:57:20'),(5493,NULL,1,11,'NOVO ALEGRE',NULL,9895,77353000,'TO','1715150',1,'2006-11-12 16:57:20'),(5494,NULL,1,11,'NOVO JARDIM',NULL,9897,77318000,'TO','1715259',1,'2006-11-12 16:57:20'),(5495,NULL,1,11,'OLIVEIRA DE FTIMA',NULL,9898,77558000,'TO','1715507',1,'2006-11-12 16:57:20'),(5496,NULL,1,11,'PALMAS',NULL,9899,NULL,'TO','1721000',1,'2006-11-12 16:57:20'),(5497,NULL,1,11,'PALMEIRANTE',NULL,9900,77798000,'TO','1715705',1,'2006-11-12 16:57:20'),(5498,NULL,1,11,'PALMEIRPOLIS',NULL,9901,77365000,'TO','1715754',1,'2006-11-12 16:57:20'),(5499,NULL,1,11,'PARASO DO TOCANTINS',NULL,9902,77600000,'TO','1716109',1,'2006-11-12 16:57:20'),(5500,NULL,1,11,'PARAN',NULL,9903,77360000,'TO','1716208',1,'2006-11-12 16:57:20'),(5501,NULL,1,11,'PAU D\' ARCO',NULL,9904,77785000,'TO',NULL,1,'2006-11-12 16:57:20'),(5502,NULL,1,11,'PEDRO AFONSO',NULL,9906,77710000,'TO','1716505',1,'2006-11-12 16:57:20'),(5503,NULL,1,11,'PEIXE',NULL,9908,77460000,'TO','1716604',1,'2006-11-12 16:57:20'),(5504,NULL,1,11,'PEQUIZEIRO',NULL,9910,77730000,'TO','1716653',1,'2006-11-12 16:57:21'),(5505,NULL,1,11,'PINDORAMA DO TOCANTINS',NULL,9912,77380000,'TO','1717008',1,'2006-11-12 16:57:21'),(5506,NULL,1,11,'PIRAQU',NULL,9913,77888000,'TO','1717206',1,'2006-11-12 16:57:21'),(5507,NULL,1,11,'PIUM',NULL,9914,77570000,'TO','1717503',1,'2006-11-12 16:57:21'),(5508,NULL,1,11,'PONTE ALTA DO BOM JESUS',NULL,9915,77315000,'TO','1717800',1,'2006-11-12 16:57:21'),(5509,NULL,1,11,'PONTE ALTA DO TOCANTINS',NULL,9916,77590000,'TO','1717909',1,'2006-11-12 16:57:21'),(5510,NULL,1,11,'PORTO ALEGRE DO TOCANTINS',NULL,9919,77395000,'TO','1718006',1,'2006-11-12 16:57:21'),(5511,NULL,1,11,'PORTO NACIONAL',NULL,9921,77500000,'TO','1718204',1,'2006-11-12 16:57:21'),(5512,NULL,1,11,'PRAIA NORTE',NULL,9922,77970000,'TO','1718303',1,'2006-11-12 16:57:21'),(5513,NULL,1,11,'PRESIDENTE KENNEDY',NULL,9923,77745000,'TO','1718402',1,'2006-11-12 16:57:21'),(5514,NULL,1,11,'PUGMIL',NULL,9925,77603000,'TO','1718451',1,'2006-11-12 16:57:21'),(5515,NULL,1,11,'RECURSOLNDIA',NULL,9926,77733000,'TO','1718501',1,'2006-11-12 16:57:21'),(5516,NULL,1,11,'RIACHINHO',NULL,9927,77893000,'TO','1718550',1,'2006-11-12 16:57:21'),(5517,NULL,1,11,'RIO DA CONCEIO',NULL,9928,77303000,'TO','1718659',1,'2006-11-12 16:57:21'),(5518,NULL,1,11,'RIO DOS BOIS',NULL,9929,77655000,'TO','1718709',1,'2006-11-12 16:57:21'),(5519,NULL,1,11,'RIO SONO',NULL,9930,77635000,'TO','1718758',1,'2006-11-12 16:57:21'),(5520,NULL,1,11,'SAMPAIO',NULL,9931,77980000,'TO','1718808',1,'2006-11-12 16:57:21'),(5521,NULL,1,11,'SANDOLNDIA',NULL,9932,77478000,'TO','1718840',1,'2006-11-12 16:57:21'),(5522,NULL,1,11,'SANTA F DO ARAGUAIA',NULL,9933,77848000,'TO','1718865',1,'2006-11-12 16:57:21'),(5523,NULL,1,11,'SANTA MARIA DO TOCANTINS',NULL,9934,77716000,'TO','1718881',1,'2006-11-12 16:57:21'),(5524,NULL,1,11,'SANTA RITA DO TOCANTINS',NULL,9935,77565000,'TO','1718899',1,'2006-11-12 16:57:21'),(5525,NULL,1,11,'SANTA ROSA DO TOCANTINS',NULL,9936,77375000,'TO','1718907',1,'2006-11-12 16:57:22'),(5526,NULL,1,11,'SANTA TEREZA DO TOCANTINS',NULL,9937,77615000,'TO','1719004',1,'2006-11-12 16:57:22'),(5527,NULL,1,11,'SANTA TEREZINHA DO TOCANTINS',NULL,9938,77885000,'TO','1720002',1,'2006-11-12 16:57:22'),(5528,NULL,1,11,'SO BENTO DO TOCANTINS',NULL,9939,77958000,'TO','1720101',1,'2006-11-12 16:57:22'),(5529,NULL,1,11,'SO FLIX DO TOCANTINS',NULL,9940,77605000,'TO','1720150',1,'2006-11-12 16:57:22'),(5530,NULL,1,11,'SO MIGUEL DO TOCANTINS',NULL,9941,77925000,'TO','1720200',1,'2006-11-12 16:57:22'),(5531,NULL,1,11,'SO SALVADOR DO TOCANTINS',NULL,9942,77368000,'TO','1720259',1,'2006-11-12 16:57:22'),(5532,NULL,1,11,'SO SEBASTIO DO TOCANTINS',NULL,9943,77990000,'TO','1720309',1,'2006-11-12 16:57:22'),(5533,NULL,1,11,'SO VALRIO DA NATIVIDADE',NULL,9944,77390000,'TO','1720499',1,'2006-11-12 16:57:22'),(5534,NULL,1,11,'SILVANPOLIS',NULL,9945,77580000,'TO','1720655',1,'2006-11-12 16:57:22'),(5535,NULL,1,11,'STIO NOVO DO TOCANTINS',NULL,9946,77940000,'TO','1720804',1,'2006-11-12 16:57:22'),(5536,NULL,1,11,'SUCUPIRA',NULL,9947,77458000,'TO','1720853',1,'2006-11-12 16:57:22'),(5537,NULL,1,11,'TAGUATINGA',NULL,9948,77320000,'TO','1720903',1,'2006-11-12 16:57:22'),(5538,NULL,1,11,'TAIPAS DO TOCANTINS',NULL,9949,77308000,'TO','1720937',1,'2006-11-12 16:57:22'),(5539,NULL,1,11,'TALISM',NULL,9950,77483000,'TO','1720978',1,'2006-11-12 16:57:22'),(5540,NULL,1,11,'TOCANTNIA',NULL,9954,77640000,'TO','1721109',1,'2006-11-12 16:57:22'),(5541,NULL,1,11,'TOCANTINPOLIS',NULL,9955,77900000,'TO','1721208',1,'2006-11-12 16:57:22'),(5542,NULL,1,11,'TUPIRAMA',NULL,9956,77704000,'TO','1721257',1,'2006-11-12 16:57:22'),(5543,NULL,1,11,'TUPIRATINS',NULL,9958,77743000,'TO','1721307',1,'2006-11-12 16:57:22'),(5544,NULL,1,11,'WANDERLNDIA',NULL,9960,77860000,'TO','1722081',1,'2006-11-12 16:57:22'),(5545,NULL,1,11,'XAMBIO',NULL,9961,77880000,'TO','1722107',1,'2006-11-12 16:57:22'),(5546,NULL,1,16,'JEQUI DA PRAIA',NULL,10089,57244000,'AL','2703759',1,'2006-11-12 16:57:22'),(5547,NULL,1,9,'IPIRANGA DE GOIS',NULL,10090,76304000,'GO','5210158',1,'2006-11-12 16:57:23'),(5548,NULL,1,7,'CONQUISTA D\'OESTE',NULL,10091,78254000,'MT',NULL,1,'2006-11-12 16:57:23'),(5549,NULL,1,7,'COLNIZA',NULL,10092,78335000,'MT','5103254',1,'2006-11-12 16:57:23'),(5550,NULL,1,7,'RONDOLNDIA',NULL,10093,78338000,'MT','5107578',1,'2006-11-12 16:57:23'),(5551,NULL,1,7,'SANTA RITA DO TRIVELATO',NULL,10094,78453000,'MT','5107768',1,'2006-11-12 16:57:23'),(5552,NULL,1,7,'NOVA SANTA HELENA',NULL,10095,78548000,'MT','5106190',1,'2006-11-12 16:57:23'),(5553,NULL,1,7,'SANTO ANTNIO DO LESTE',NULL,10096,78628000,'MT','5107792',1,'2006-11-12 16:57:23'),(5554,NULL,1,7,'NOVA NAZAR',NULL,10097,78638000,'MT','5106174',1,'2006-11-12 16:57:23'),(5555,NULL,1,7,'SANTA CRUZ DO XINGU',NULL,10098,78664000,'MT','5107743',1,'2006-11-12 16:57:23'),(5556,NULL,1,7,'BOM JESUS DO ARAGUAIA',NULL,10099,78678000,'MT','5101852',1,'2006-11-12 16:57:23'),(5557,NULL,1,12,'PAU D\'ARCO DO PIAU',NULL,10100,64295000,'PI',NULL,1,'2006-11-12 16:57:23'),(5558,NULL,1,26,'WESTFALIA',NULL,10101,95893000,'RS','4323770',1,'2006-11-12 16:57:23'),(5559,NULL,1,26,'SANTA MARGARIDA DO SUL',NULL,10102,97335000,'RS','4316972',1,'2006-11-12 16:57:23'),(5560,NULL,1,26,'TIO HUGO',NULL,10103,99345000,'RS','4321469',1,'2006-11-12 16:57:23'),(5561,NULL,1,9,'RIALMA',NULL,10144,76310000,'GO','5218607',1,'2006-11-12 16:57:23');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cidade` ENABLE KEYS */;

--
-- Table structure for table `clientesvendedor`
--

DROP TABLE IF EXISTS `clientesvendedor`;
CREATE TABLE `clientesvendedor` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaCliente_Id` int(11) NOT NULL,
  `PessoaVendedor_Id` int(11) NOT NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `ClientesVendedor_VendedorCliente` (`PessoaCliente_Id`,`PessoaVendedor_Id`),
  KEY `ClientesVendedor_FK_PessoaVendedor` (`PessoaVendedor_Id`),
  KEY `ClientesVendedor_FK_PessoaCliente` (`PessoaCliente_Id`),
  CONSTRAINT `FK_PessoaCliente_ClientesVendedor` FOREIGN KEY (`PessoaCliente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaVendedor_ClientesVendedor` FOREIGN KEY (`PessoaVendedor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `clientesvendedor`
--


/*!40000 ALTER TABLE `clientesvendedor` DISABLE KEYS */;
LOCK TABLES `clientesvendedor` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `clientesvendedor` ENABLE KEYS */;

--
-- Table structure for table `cobranca`
--

DROP TABLE IF EXISTS `cobranca`;
CREATE TABLE `cobranca` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaCobrador_Id` int(11) NOT NULL,
  `ContasReceber_Id` int(11) NOT NULL,
  `DataCobranca` date NOT NULL,
  `BaixaCobranca` date default NULL,
  `ImpressaoOk` tinyint(1) unsigned default NULL COMMENT 'Este campo estar habilitado quando a cobranca for impressa para o cobrador.',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Retirado` datetime default NULL,
  `UsuarioRetirou_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Cobranca_FK_ContasReceber` (`ContasReceber_Id`),
  KEY `Cobranca_FK_Cobrador` (`PessoaCobrador_Id`),
  CONSTRAINT `FK_ContasReceber_Cobranca` FOREIGN KEY (`ContasReceber_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_Cobranca` FOREIGN KEY (`PessoaCobrador_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Esta Tabela visa informar a confirmao da Cobrana de uma d';

--
-- Dumping data for table `cobranca`
--


/*!40000 ALTER TABLE `cobranca` DISABLE KEYS */;
LOCK TABLES `cobranca` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cobranca` ENABLE KEYS */;

--
-- Table structure for table `codigoajustefiscal`
--

DROP TABLE IF EXISTS `codigoajustefiscal`;
CREATE TABLE `codigoajustefiscal` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` varchar(10) NOT NULL,
  `Descrio` varchar(100) NOT NULL,
  `DataInicio` date default NULL,
  `DataFinal` date default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `codigoajustefiscal`
--


/*!40000 ALTER TABLE `codigoajustefiscal` DISABLE KEYS */;
LOCK TABLES `codigoajustefiscal` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `codigoajustefiscal` ENABLE KEYS */;

--
-- Table structure for table `codigolancfiscal`
--

DROP TABLE IF EXISTS `codigolancfiscal`;
CREATE TABLE `codigolancfiscal` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` varchar(6) NOT NULL,
  `Descricao` varchar(100) NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `codigolancfiscal`
--


/*!40000 ALTER TABLE `codigolancfiscal` DISABLE KEYS */;
LOCK TABLES `codigolancfiscal` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `codigolancfiscal` ENABLE KEYS */;

--
-- Table structure for table `comissao`
--

DROP TABLE IF EXISTS `comissao`;
CREATE TABLE `comissao` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `PessoaVendedor_Id` int(11) NOT NULL,
  `Venda_Id` int(11) NOT NULL,
  `Percentual` float default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Comissao_Unico` (`Venda_Id`,`PessoaVendedor_Id`),
  KEY `Comissao_FKIndex1` (`Venda_Id`),
  KEY `Comissao_FKIndex2` (`PessoaVendedor_Id`),
  KEY `Comissao_FKIndex3` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Comissao` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ComissaoVendedor` FOREIGN KEY (`PessoaVendedor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_VendaComissao` FOREIGN KEY (`Venda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `comissao`
--


/*!40000 ALTER TABLE `comissao` DISABLE KEYS */;
LOCK TABLES `comissao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `comissao` ENABLE KEYS */;

--
-- Table structure for table `comissionados`
--

DROP TABLE IF EXISTS `comissionados`;
CREATE TABLE `comissionados` (
  `Pessoa_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `ComissaoAVista` float(10,2) default NULL,
  `ComissaoAPrazo` float(10,2) default NULL,
  `DescontoAutorizado` float(8,2) default NULL,
  `ComissionadoUsuario_Id` int(10) unsigned default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Pessoa_Id`),
  UNIQUE KEY `Comissionados_Unico` (`Pessoa_Id`),
  KEY `VendedorComissao_FKIndex1` (`Pessoa_Id`),
  KEY `Comissionados_FKIndex2` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Comissionados` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_Comissionados` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `comissionados`
--


/*!40000 ALTER TABLE `comissionados` DISABLE KEYS */;
LOCK TABLES `comissionados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `comissionados` ENABLE KEYS */;

--
-- Table structure for table `compra`
--

DROP TABLE IF EXISTS `compra`;
CREATE TABLE `compra` (
  `Id` int(11) NOT NULL auto_increment,
  `UFPlacaVeiculo_Id` int(11) default NULL,
  `PedidoCompra_Id` int(11) default NULL,
  `CST_Id` int(10) unsigned default NULL,
  `Loja_Id` int(11) NOT NULL,
  `FormaPagamento_Id` int(11) default NULL,
  `PessoaTransportador_Id` int(11) NOT NULL,
  `PlanoPagamento_Id` int(11) NOT NULL,
  `PessoaFornecedor_Id` int(11) NOT NULL,
  `NumeroNotaFiscal` int(6) NOT NULL,
  `ModeloNotaFiscal` enum('01 - Modelo 1 ou 1 - A, Quanto ao ICMS','03 - Nota Fiscal de Entrada','06 - Conta de Energia Eltrica','22 - Servio de Telecomunicaes') default NULL COMMENT 'Relacionado ao sintegra',
  `SerieNotaFiscal` varchar(3) default NULL COMMENT 'Relacionado ao sintegra',
  `Classificacao` enum('Compra','Devolucao','Deposito','DevolucaoVenda','Bonificacao','CIAP') default NULL,
  `Emitente` enum('Prprio','Terceiros') default NULL COMMENT 'Emitente da nota fiscal',
  `SituacaoNotaFiscal` enum('N - Documento Fiscal Normal','S - Documento Fiscal Cancelado','E - Lanamento Extemporneo de Documento Fiscal Normal','X - Lanamento Extemporneo de Documento Fiscal Cancelado') default NULL COMMENT '(N - Normal) (S - Cancelado) (E - Extemporaneo Normal)(X - Extemporaneo Cancelado)',
  `Emissao` date NOT NULL,
  `ValorTotalFrete` float(12,2) default NULL,
  `ValorICMSFrete` float(12,2) default NULL,
  `TipoFrete` enum('1 - CIF','2 - FOB','3 - Terceiros','9 - Sem Frete') default NULL,
  `ValorFreteEmbutido` float(12,2) default NULL,
  `ValorTotalImposto` float(12,2) default NULL,
  `PlacaVeiculoTransportador` varchar(7) default NULL,
  `Obs` text,
  `Situacao` enum('Pendente','Concluda','Aprovada','Devolvida','VendaDevolvida') default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `Chegada` date default NULL,
  `CFOP_Codigo` int(10) unsigned default NULL COMMENT 'Relacionado ao Sintegra',
  `ValorTotalNotaFiscal` float(13,2) default NULL,
  `ValorBaseCalculoICMS` float(13,2) default NULL,
  `ValorICMS` float(13,2) default NULL,
  `ValorIsento` float(13,2) default NULL,
  `ValorOutros` float(13,2) default NULL,
  `ValorBaseCalculoIPI` float(13,2) default NULL,
  `ValorIsentoIPI` float(13,2) default NULL,
  `ValorOutrosIPI` float(13,2) default NULL,
  `ValorBaseCalculoICMSST` float(13,2) default NULL,
  `ValorICMSRetido` float(13,2) default NULL,
  `ValorDespesasAcessorias` float(13,2) default NULL,
  `ValorFunrural` float(12,2) default NULL,
  `CodigoAntecipacao` int(10) unsigned default NULL,
  `LoteNumero` int(10) unsigned default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `Compra_FKIndex1` (`PessoaFornecedor_Id`),
  KEY `Compra_FKIndex2` (`PlanoPagamento_Id`),
  KEY `Compra_FKIndex3` (`PessoaTransportador_Id`),
  KEY `Compra_FKIndex5` (`FormaPagamento_Id`),
  KEY `Compra_FKIndex6` (`Loja_Id`),
  KEY `Compra_FK_Emissao` (`Emissao`),
  KEY `Compra_FK_CST` (`CST_Id`),
  KEY `Compra_FK_PedidoCompra` (`PedidoCompra_Id`),
  KEY `Compra_FK_UFPlacaVeiculo` (`UFPlacaVeiculo_Id`),
  CONSTRAINT `FK_CST_Compra` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_Compra` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Compra` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PedidoCompra_Compra` FOREIGN KEY (`PedidoCompra_Id`) REFERENCES `pedidocompra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_CompraFornecedor` FOREIGN KEY (`PessoaFornecedor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_CompraTransportador` FOREIGN KEY (`PessoaTransportador_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PlanoPagamento_Compra` FOREIGN KEY (`PlanoPagamento_Id`) REFERENCES `planopagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_UFPlaca_Transportador_Compra` FOREIGN KEY (`UFPlacaVeiculo_Id`) REFERENCES `uf` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `compra`
--


/*!40000 ALTER TABLE `compra` DISABLE KEYS */;
LOCK TABLES `compra` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `compra` ENABLE KEYS */;

--
-- Table structure for table `compraitens`
--

DROP TABLE IF EXISTS `compraitens`;
CREATE TABLE `compraitens` (
  `Id` int(11) NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `LojaEntradaEstoque_Id` int(11) NOT NULL,
  `Compra_Id` int(11) NOT NULL,
  `Sequencia` int(10) unsigned default NULL COMMENT 'Sequencia do Item da Nota Fiscal',
  `QtdEntrada` double(12,4) default NULL COMMENT 'Quantidade na nota',
  `Quantidade` double(12,4) NOT NULL COMMENT 'Quantidade convertida',
  `ValorCustoInicial` float(12,5) NOT NULL,
  `ValorIPI` float(12,4) default NULL,
  `ValorFrete` float(12,3) default NULL,
  `ValorDesconto` float(12,5) default NULL,
  `ValorTotalDesconto` float(12,4) default NULL,
  `ValorICMSDesonerado` float(12,2) default NULL,
  `ValorOutros` float(12,3) default NULL,
  `AliquotaICMS` float(4,2) default NULL,
  `Complemento` varchar(30) default NULL,
  `PercMedia` float default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `CFOP` varchar(4) default NULL,
  `CST` varchar(3) default NULL,
  `CSOSN` varchar(4) default NULL,
  `NCM` varchar(8) default NULL,
  `VL_BC_ICMS` float(12,2) default NULL,
  `ALIQ_ICMS` float(12,2) default NULL,
  `VL_ICMS` float(12,2) default NULL,
  `VL_RED_BC` float(12,2) default NULL,
  `VL_BC_ICMS_ST` float(12,2) default NULL,
  `ALIQ_ST` float(12,2) default NULL,
  `VL_ICMS_ST` float(12,4) default NULL,
  `VL_BC_IPI` float(12,2) default NULL,
  `ALIQ_IPI` float(12,2) default NULL,
  `VL_IPI` float(12,2) default NULL,
  `CST_PIS` varchar(3) default NULL,
  `VL_BC_PIS` float(12,2) default NULL,
  `ALIQ_PIS` float(12,2) default NULL,
  `VL_PIS` float(12,2) default NULL,
  `CST_COFINS` varchar(3) default NULL,
  `VL_BC_COFINS` float(12,2) default NULL,
  `ALIQ_COFINS` float(12,2) default NULL,
  `VL_COFINS` float(12,2) default NULL,
  `RateioValor` float(12,4) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CompraItens_FKIndex1` (`Compra_Id`),
  KEY `CompraItens_FKIndex5` (`LojaEntradaEstoque_Id`),
  KEY `CompraItens_FKIndex4` (`ProdutoGrade_Id`),
  KEY `CompraItens_SequenciaUnica` (`Compra_Id`,`Sequencia`),
  CONSTRAINT `FK_Compra_CompraItens` FOREIGN KEY (`Compra_Id`) REFERENCES `compra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_CompraItens` FOREIGN KEY (`LojaEntradaEstoque_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_CompraItens` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `compraitens`
--


/*!40000 ALTER TABLE `compraitens` DISABLE KEYS */;
LOCK TABLES `compraitens` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `compraitens` ENABLE KEYS */;

--
-- Table structure for table `compraprevisao`
--

DROP TABLE IF EXISTS `compraprevisao`;
CREATE TABLE `compraprevisao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Emissao` date NOT NULL,
  `Fornecedor` varchar(80) NOT NULL,
  `Obs` text,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `CompraPrevisao_FK_Loja_Id` (`Loja_Id`),
  CONSTRAINT `FK_CompraPrevisao_Loja` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `compraprevisao`
--


/*!40000 ALTER TABLE `compraprevisao` DISABLE KEYS */;
LOCK TABLES `compraprevisao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `compraprevisao` ENABLE KEYS */;

--
-- Table structure for table `compraprevisaoitem`
--

DROP TABLE IF EXISTS `compraprevisaoitem`;
CREATE TABLE `compraprevisaoitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `CompraPrevisao_Id` int(10) unsigned NOT NULL,
  `Quantidade` float(10,3) default NULL,
  `ValorCusto` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CompraPrevisaoItem_FK_CompraPrevisao_Id` (`CompraPrevisao_Id`),
  KEY `CompraPrevisaoItem_FK_ProdutoGrade_Id` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_CompraPrevisao_Item` FOREIGN KEY (`CompraPrevisao_Id`) REFERENCES `compraprevisao` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_CompraPrevisaoItem` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `compraprevisaoitem`
--


/*!40000 ALTER TABLE `compraprevisaoitem` DISABLE KEYS */;
LOCK TABLES `compraprevisaoitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `compraprevisaoitem` ENABLE KEYS */;

--
-- Table structure for table `comprovantecartao`
--

DROP TABLE IF EXISTS `comprovantecartao`;
CREATE TABLE `comprovantecartao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Faturamento` varchar(45) default NULL,
  `Faturamento_Id` int(10) unsigned default NULL,
  `Emissao` date default NULL,
  `NumeroAutorizacao` varchar(20) default NULL,
  `Valor` float(12,2) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `comprovantecartao`
--


/*!40000 ALTER TABLE `comprovantecartao` DISABLE KEYS */;
LOCK TABLES `comprovantecartao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `comprovantecartao` ENABLE KEYS */;

--
-- Table structure for table `conta`
--

DROP TABLE IF EXISTS `conta`;
CREATE TABLE `conta` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `CodigoContabil` varchar(15) default NULL,
  `Nome` varchar(35) NOT NULL,
  `Tipo` enum('Conta Caixa','Conta Investimento','Conta Ativo','Conta Emprestimo','Conta Bancaria') NOT NULL,
  `ContaInativa` tinyint(1) default '0',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Conta_Unico` (`Nome`),
  KEY `Conta_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Conta` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `conta`
--


/*!40000 ALTER TABLE `conta` DISABLE KEYS */;
LOCK TABLES `conta` WRITE;
INSERT INTO `conta` (`Id`, `Loja_Id`, `CodigoContabil`, `Nome`, `Tipo`, `ContaInativa`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,NULL,'FRENTE LOJA','Conta Caixa',0,1,'2009-08-19 01:02:57'),(2,1,'321','BANCO FICTCIO 9999-9 TESTE','Conta Bancaria',0,1,'2016-05-11 14:31:48');
UNLOCK TABLES;
/*!40000 ALTER TABLE `conta` ENABLE KEYS */;

--
-- Table structure for table `contaativo`
--

DROP TABLE IF EXISTS `contaativo`;
CREATE TABLE `contaativo` (
  `Conta_Id` int(11) NOT NULL,
  `TipoAtivo_Id` int(10) unsigned NOT NULL,
  `ValorInicial` float(12,2) default NULL,
  PRIMARY KEY  (`Conta_Id`),
  KEY `ContaAtivo_FK_TipoAtivo` (`TipoAtivo_Id`),
  KEY `ContaAtivo_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_Conta_ContaAtivo` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoAtivo_ContaAtivo` FOREIGN KEY (`TipoAtivo_Id`) REFERENCES `tipoativo` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contaativo`
--


/*!40000 ALTER TABLE `contaativo` DISABLE KEYS */;
LOCK TABLES `contaativo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contaativo` ENABLE KEYS */;

--
-- Table structure for table `contabancaria`
--

DROP TABLE IF EXISTS `contabancaria`;
CREATE TABLE `contabancaria` (
  `Conta_Id` int(11) NOT NULL,
  `Titular_Id` int(11) NOT NULL,
  `Banco_Id` int(11) NOT NULL,
  `Agencia` varchar(10) NOT NULL,
  `NumeroConta` varchar(10) NOT NULL,
  `CodigoCedente` varchar(10) default NULL,
  `SaldoInicial` float(12,2) default NULL,
  `LimiteConta` float(12,2) default NULL,
  `Carteira` varchar(5) default NULL,
  `Modalidade` varchar(3) default NULL,
  `Convenio` varchar(10) default NULL,
  `TipoConta` enum('Corrente','Poupana') NOT NULL,
  `CaminhoRemessaBoleto` varchar(60) default NULL,
  `Token` varchar(128) default NULL,
  PRIMARY KEY  (`Conta_Id`),
  UNIQUE KEY `ContaBancaria_Unico` (`Banco_Id`,`Agencia`,`NumeroConta`),
  KEY `ContaCorrente_FK_Banco` (`Banco_Id`),
  KEY `ContaCorrente_FK_Titular` (`Titular_Id`),
  KEY `ContaCorrente_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_Banco_ContaBancaria` FOREIGN KEY (`Banco_Id`) REFERENCES `banco` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta_ContaBancaria` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContaBancariaTitular` FOREIGN KEY (`Titular_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contabancaria`
--


/*!40000 ALTER TABLE `contabancaria` DISABLE KEYS */;
LOCK TABLES `contabancaria` WRITE;
INSERT INTO `contabancaria` (`Conta_Id`, `Titular_Id`, `Banco_Id`, `Agencia`, `NumeroConta`, `CodigoCedente`, `SaldoInicial`, `LimiteConta`, `Carteira`, `Modalidade`, `Convenio`, `TipoConta`, `CaminhoRemessaBoleto`, `Token`) VALUES (2,1,34,'999-9','99999-9','31321',0.00,1.00,'02','02','321321','Corrente','C:\\','');
UNLOCK TABLES;
/*!40000 ALTER TABLE `contabancaria` ENABLE KEYS */;

--
-- Table structure for table `contacaixa`
--

DROP TABLE IF EXISTS `contacaixa`;
CREATE TABLE `contacaixa` (
  `Conta_Id` int(11) NOT NULL,
  `SaldoInicial` float(12,2) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `IP` varchar(16) default NULL,
  PRIMARY KEY  (`Conta_Id`),
  KEY `ContaCaixa_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_Conta_ContaCaixa` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contacaixa`
--


/*!40000 ALTER TABLE `contacaixa` DISABLE KEYS */;
LOCK TABLES `contacaixa` WRITE;
INSERT INTO `contacaixa` (`Conta_Id`, `SaldoInicial`, `Usuario_Id`, `IP`) VALUES (1,0.00,1,'192.168.?.?');
UNLOCK TABLES;
/*!40000 ALTER TABLE `contacaixa` ENABLE KEYS */;

--
-- Table structure for table `contaemprestimo`
--

DROP TABLE IF EXISTS `contaemprestimo`;
CREATE TABLE `contaemprestimo` (
  `Conta_Id` int(11) NOT NULL,
  `Favorecido_Id` int(11) NOT NULL,
  `Periodicidade_Id` int(10) unsigned NOT NULL,
  `TipoEmprestimo_Id` int(10) unsigned NOT NULL,
  `ValorPrincipal` float(12,2) default NULL,
  `ValorJuros` float(12,2) default NULL,
  `QtdParcelas` int(10) unsigned default NULL,
  `VencimentoInicial` date default NULL,
  `Taxas` float(12,2) default NULL,
  PRIMARY KEY  (`Conta_Id`),
  KEY `ContaEmprestimo_FK_TipoEmprestimo` (`TipoEmprestimo_Id`),
  KEY `ContaEmprestimo_FK_Periodicidade` (`Periodicidade_Id`),
  KEY `ContaEmprestimo_FK_Favorecido` (`Favorecido_Id`),
  KEY `ContaEmprestimo_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_Conta_ContaEmprestimo` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Periodicidade_ContaEmprestimo` FOREIGN KEY (`Periodicidade_Id`) REFERENCES `periodicidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContaEmprestimoFavorecido` FOREIGN KEY (`Favorecido_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoEmprestimo_ContaEmprestimo` FOREIGN KEY (`TipoEmprestimo_Id`) REFERENCES `tipoemprestimo` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contaemprestimo`
--


/*!40000 ALTER TABLE `contaemprestimo` DISABLE KEYS */;
LOCK TABLES `contaemprestimo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contaemprestimo` ENABLE KEYS */;

--
-- Table structure for table `containvestimento`
--

DROP TABLE IF EXISTS `containvestimento`;
CREATE TABLE `containvestimento` (
  `Conta_Id` int(11) NOT NULL,
  `TipoInvestimento_Id` int(10) unsigned NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `AnosUtil` float(12,2) default NULL,
  `RateioMensal` float(12,2) default NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Conta_Id`),
  KEY `Investimento_FK_Loja` (`Loja_Id`),
  KEY `ContaInvestimento_FK_TipoInvestimento` (`TipoInvestimento_Id`),
  KEY `ContaInvestimento_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_Conta_ContaInvestimento` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ContaInvestimento` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoInvestimento_ContaInvestimento` FOREIGN KEY (`TipoInvestimento_Id`) REFERENCES `tipoinvestimento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `containvestimento`
--


/*!40000 ALTER TABLE `containvestimento` DISABLE KEYS */;
LOCK TABLES `containvestimento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `containvestimento` ENABLE KEYS */;

--
-- Table structure for table `contapaga`
--

DROP TABLE IF EXISTS `contapaga`;
CREATE TABLE `contapaga` (
  `Id` int(11) NOT NULL auto_increment,
  `TipoGasto_Id` int(10) unsigned default NULL,
  `Caixa_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `CentroCusto_Id` int(11) default NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `ContasPagar_Id` int(11) NOT NULL,
  `Pagamento` date NOT NULL,
  `ValorPago` decimal(12,2) NOT NULL,
  `Desconto` float(10,2) default NULL,
  `Historico` varchar(40) default NULL,
  `TipoPagamento` enum('Parcial','Completo','Juros') NOT NULL,
  `Conciliado` tinyint(1) default '0',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContaPaga_FK_ContasPagar` (`ContasPagar_Id`),
  KEY `ContaPaga_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `ContaPaga_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `ContaPaga_FK_Loja` (`Loja_Id`),
  KEY `ContaPaga_FK_Caixa` (`Caixa_Id`),
  KEY `ContaPaga_FK_Pagamento` (`Pagamento`),
  KEY `ContaPaga_FK_TipoGasto` (`TipoGasto_Id`),
  CONSTRAINT `FK_Caixa_ContaPaga` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CentroCusto_ContaPaga` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaPagar_ContaPaga` FOREIGN KEY (`ContasPagar_Id`) REFERENCES `contaspagar` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_ContaPaga` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ContaPaga` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_ContaPaga` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contapaga`
--


/*!40000 ALTER TABLE `contapaga` DISABLE KEYS */;
LOCK TABLES `contapaga` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contapaga` ENABLE KEYS */;

--
-- Table structure for table `contarecebida`
--

DROP TABLE IF EXISTS `contarecebida`;
CREATE TABLE `contarecebida` (
  `Id` int(11) NOT NULL auto_increment,
  `FormaRecebimento_Id` int(11) NOT NULL,
  `Caixa_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaCobrador_Id` int(11) default NULL,
  `ContasReceber_Id` int(11) NOT NULL,
  `Recebimento` date NOT NULL,
  `Confirmado` date default NULL,
  `Conferido` datetime default NULL,
  `ValorRecebido` float(12,2) NOT NULL default '0.00',
  `TipoRecebimento` enum('Parcial','Completo','Juros') NOT NULL,
  `Desconto` float(10,2) default '0.00',
  `DescontoCartao` float(10,2) default NULL,
  `Conciliado` tinyint(1) default '0',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Obs` varchar(100) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasRecebidas_FK_ContasReceber` (`ContasReceber_Id`),
  KEY `ContasRecebidas_FK_FormaRecebimento` (`FormaRecebimento_Id`),
  KEY `ContaRecebida_FK_Cobrador` (`PessoaCobrador_Id`),
  KEY `ContaRecebida_FK_Loja` (`Loja_Id`),
  KEY `ContaRecebida_TipoRecebimento` (`TipoRecebimento`),
  KEY `ContaRecebida_Recebimento` (`TipoRecebimento`,`Recebimento`),
  KEY `ContaRecebida_FKIndex5` (`Caixa_Id`),
  KEY `ContaRecebida_FK_Recebimento` (`Recebimento`),
  CONSTRAINT `FK_Caixa_ContaRecebida` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContasReceber_ContaRecebida` FOREIGN KEY (`ContasReceber_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_ContaRecebida` FOREIGN KEY (`FormaRecebimento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ContaRecebida` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContaRecebidaCobrador` FOREIGN KEY (`PessoaCobrador_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contarecebida`
--


/*!40000 ALTER TABLE `contarecebida` DISABLE KEYS */;
LOCK TABLES `contarecebida` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contarecebida` ENABLE KEYS */;

--
-- Table structure for table `contaspagar`
--

DROP TABLE IF EXISTS `contaspagar`;
CREATE TABLE `contaspagar` (
  `Id` int(11) NOT NULL auto_increment,
  `SpedD500_Id` int(10) unsigned default NULL,
  `Conta_Id` int(11) default NULL,
  `CentroCusto_Id` int(11) default NULL,
  `TipoGasto_Id` int(10) unsigned default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaFornecedor_Id` int(11) NOT NULL,
  `Compra_Id` int(11) default NULL,
  `TipoDocumento` enum('Duplicata','Boleto','Cheque','Promissoria','Outros','Nota Fiscal','Requisio','Transf. Banc.','Carto') default NULL,
  `NumeroDocumento` varchar(20) default NULL,
  `Emissao` date NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Vencimento` date NOT NULL,
  `Parcela` varchar(10) NOT NULL,
  `PrevisaoPagamento` date default NULL,
  `ObsPrevisaoPagamento` blob,
  `DocRecebido` date default NULL,
  `Obs` varchar(80) default NULL,
  `Situacao` int(10) unsigned default NULL,
  `Alinea` varchar(20) default NULL COMMENT 'Devolvido, Sustado, Protestado',
  `DadosAdicionais` blob,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasPagar_FK_Compra` (`Compra_Id`),
  KEY `ContaPagar_FK_Fornecedor` (`PessoaFornecedor_Id`),
  KEY `ContaPagar_FK_Loja` (`Loja_Id`),
  KEY `ContasPagar_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `ContasPagar_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `ContasPagar_FK_Conta` (`Conta_Id`),
  KEY `ContasPagar_FKIndex7` (`SpedD500_Id`),
  CONSTRAINT `FK_CentroCusto_ContasPagar` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Compra_ContaPagar` FOREIGN KEY (`Compra_Id`) REFERENCES `compra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta_ContasPagar` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_D500_ContasPagar` FOREIGN KEY (`SpedD500_Id`) REFERENCES `spedd500` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ContaPagar` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContaPagarFornecedor` FOREIGN KEY (`PessoaFornecedor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_ContasPagar` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contaspagar`
--


/*!40000 ALTER TABLE `contaspagar` DISABLE KEYS */;
LOCK TABLES `contaspagar` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contaspagar` ENABLE KEYS */;

--
-- Table structure for table `contaspagaravulsa`
--

DROP TABLE IF EXISTS `contaspagaravulsa`;
CREATE TABLE `contaspagaravulsa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `CentroCusto_Id` int(11) NOT NULL,
  `TipoGasto_Id` int(10) unsigned NOT NULL,
  `Historico` varchar(50) default NULL,
  `Emissao` date default NULL,
  `Vencimento` date default NULL,
  `NumeroDocumento` varchar(10) default NULL,
  `Valor` float(12,2) default NULL,
  `Pagamento` date default NULL,
  `ValorPago` float(12,2) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasPagarAvulsa_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `ContasPagarAvulsa_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `ContasPagarAvulsa_FK_Loja` (`Loja_Id`),
  KEY `ContasPagarAvulsa_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_ContasPagarAvulsa` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContasPagarAvulsa_CentroCusto` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContasPagarAvulsa_Loja` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContasPagarAvulsa_TipoGasto` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contaspagaravulsa`
--


/*!40000 ALTER TABLE `contaspagaravulsa` DISABLE KEYS */;
LOCK TABLES `contaspagaravulsa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contaspagaravulsa` ENABLE KEYS */;

--
-- Table structure for table `contasreceber`
--

DROP TABLE IF EXISTS `contasreceber`;
CREATE TABLE `contasreceber` (
  `Id` int(11) NOT NULL auto_increment,
  `Fatura_Id` int(10) unsigned default NULL,
  `ContratoFretamento_Id` int(10) unsigned default NULL,
  `OSSimples_Id` int(10) unsigned default NULL,
  `FormaPagamento_Id` int(11) default NULL COMMENT ' usada para imprimir o cupom',
  `SubstituiMercadoria_Id` int(10) unsigned default NULL,
  `OSDetalhadaEntrega_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaCliente_Id` int(11) default NULL,
  `Venda_Id` int(11) default NULL,
  `Codigo` varchar(12) default NULL,
  `CodLojaOld` varchar(5) default NULL,
  `Valor` float(12,2) NOT NULL,
  `Vencimento` date NOT NULL,
  `Parcela` varchar(10) default NULL,
  `Emissao` date NOT NULL,
  `PrevisaoPagamento` date default NULL,
  `ObsPrevisaoPagamento` blob,
  `Cobrar` tinyint(1) default NULL,
  `SPC` tinyint(1) default NULL,
  `Situacao` int(1) default NULL COMMENT '(1 Devolvida)',
  `Juros` float default NULL,
  `ComJuros` float default NULL,
  `CreditoAntecipado` tinyint(1) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `CodCliOld` varchar(5) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasReceber_FK_Venda` (`Venda_Id`),
  KEY `ContaReceber_FK_Cliente` (`PessoaCliente_Id`),
  KEY `ContaReceber_FK_Loja` (`Loja_Id`),
  KEY `ContasReceber_FK_OSDetalhadaEntrega` (`OSDetalhadaEntrega_Id`),
  KEY `ContasReceber_Vencimento` (`Vencimento`),
  KEY `ContasReceber_FK_SubstituiMercadoria` (`SubstituiMercadoria_Id`),
  KEY `ContasReceber_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `ContasReceber_FK_OSSimples` (`OSSimples_Id`),
  KEY `ContasReceber_FK_ContratoFretamento` (`ContratoFretamento_Id`),
  KEY `ContasReceber_Parcela` (`Parcela`),
  KEY `ContasReceber_FK_Fatura` (`Fatura_Id`),
  CONSTRAINT `FK_ContratoFretamento_ContasReceber` FOREIGN KEY (`ContratoFretamento_Id`) REFERENCES `contratofretamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Fatura_ContasReceber` FOREIGN KEY (`Fatura_Id`) REFERENCES `fatura` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ContasReceber` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_OSEntrega_ContasReceber` FOREIGN KEY (`OSDetalhadaEntrega_Id`) REFERENCES `osentrega` (`OSDetalhada_Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_OSSimples_ContasReceber` FOREIGN KEY (`OSSimples_Id`) REFERENCES `ossimples` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContasReceberCliente` FOREIGN KEY (`PessoaCliente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_SubstituiMercadoria_ContasReceber` FOREIGN KEY (`SubstituiMercadoria_Id`) REFERENCES `substituimercadoria` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Venda_ContasReceber` FOREIGN KEY (`Venda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FormaPagamento_ContasReceber` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contasreceber`
--


/*!40000 ALTER TABLE `contasreceber` DISABLE KEYS */;
LOCK TABLES `contasreceber` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contasreceber` ENABLE KEYS */;

--
-- Table structure for table `contasreceberosexterna`
--

DROP TABLE IF EXISTS `contasreceberosexterna`;
CREATE TABLE `contasreceberosexterna` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FormaPagamento_Id` int(11) default NULL,
  `OSExAtendimento_Id` int(10) unsigned NOT NULL,
  `ContasReceber_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasReceberOSExterna_FK_ContasReceber` (`ContasReceber_Id`),
  KEY `ContasReceberOSExterna_FK_OSExAtendimento` (`OSExAtendimento_Id`),
  KEY `ContasReceberOSExterna_FK_FormaPagamento` (`FormaPagamento_Id`),
  CONSTRAINT `FK_ContasReceber_ContasReceberOSExterna` FOREIGN KEY (`ContasReceber_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ExAtendimento_ContasReceberOSExterna` FOREIGN KEY (`OSExAtendimento_Id`) REFERENCES `osexatendimento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_ContasReceberOSExterna` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contasreceberosexterna`
--


/*!40000 ALTER TABLE `contasreceberosexterna` DISABLE KEYS */;
LOCK TABLES `contasreceberosexterna` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contasreceberosexterna` ENABLE KEYS */;

--
-- Table structure for table `contasreceberspc`
--

DROP TABLE IF EXISTS `contasreceberspc`;
CREATE TABLE `contasreceberspc` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContasReceber_Id` int(11) NOT NULL,
  `Classificacao` enum('SPC','SERASA','ADVOGADO') NOT NULL,
  `Envio` date NOT NULL,
  `Baixa` date default NULL,
  `Obs` varchar(200) default NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContasReceberSPC_FKIndex1` (`ContasReceber_Id`),
  CONSTRAINT `FK_ContasReceber_SPC` FOREIGN KEY (`ContasReceber_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contasreceberspc`
--


/*!40000 ALTER TABLE `contasreceberspc` DISABLE KEYS */;
LOCK TABLES `contasreceberspc` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contasreceberspc` ENABLE KEYS */;

--
-- Table structure for table `contigencialog`
--

DROP TABLE IF EXISTS `contigencialog`;
CREATE TABLE `contigencialog` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Tabela` varchar(50) NOT NULL,
  `Tabela_Id` int(10) unsigned NOT NULL,
  `Comando` varchar(50) NOT NULL,
  `Loja_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contigencialog`
--


/*!40000 ALTER TABLE `contigencialog` DISABLE KEYS */;
LOCK TABLES `contigencialog` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contigencialog` ENABLE KEYS */;

--
-- Table structure for table `contigencialogerro`
--

DROP TABLE IF EXISTS `contigencialogerro`;
CREATE TABLE `contigencialogerro` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Tabela` varchar(50) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  `Comando` varchar(50) default NULL,
  `De` varchar(10) default NULL,
  `Para` varchar(10) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Erro` text,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contigencialogerro`
--


/*!40000 ALTER TABLE `contigencialogerro` DISABLE KEYS */;
LOCK TABLES `contigencialogerro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contigencialogerro` ENABLE KEYS */;

--
-- Table structure for table `contrato`
--

DROP TABLE IF EXISTS `contrato`;
CREATE TABLE `contrato` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaContratante_Id` int(11) NOT NULL,
  `ContratoModelo_Id` int(10) unsigned NOT NULL,
  `Venda_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Obs` blob,
  `DadosContrato` longblob,
  `Confirmado` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Contrato_FK_Venda` (`Venda_Id`),
  KEY `Contrato_FK_ContratoModelo` (`ContratoModelo_Id`),
  KEY `Contrato_FK_PessoaContratante` (`PessoaContratante_Id`),
  CONSTRAINT `FK_ContratoModelo_Contrato` FOREIGN KEY (`ContratoModelo_Id`) REFERENCES `contratomodelo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_Contrato` FOREIGN KEY (`PessoaContratante_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Venda_Contrato` FOREIGN KEY (`Venda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contrato`
--


/*!40000 ALTER TABLE `contrato` DISABLE KEYS */;
LOCK TABLES `contrato` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contrato` ENABLE KEYS */;

--
-- Table structure for table `contratofretamento`
--

DROP TABLE IF EXISTS `contratofretamento`;
CREATE TABLE `contratofretamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PlanoPagamento_Id` int(11) default NULL,
  `ContratoModelo_Id` int(10) unsigned default NULL,
  `PessoaCliente_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Obs` blob,
  `Cortesia` tinyint(1) default NULL,
  `Confirmado` tinyint(1) default NULL,
  `Terceiro` tinyint(1) default NULL COMMENT 'Quando no  a propria empresa',
  `DadosContrato` blob,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `UsuarioConfirmacao_Id` int(10) unsigned default NULL,
  `DataHoraConfirmacao` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoFretamento_FK_PessoaCliente` (`PessoaCliente_Id`),
  KEY `ContratoFretamento_FK_ContratoModelo` (`ContratoModelo_Id`),
  KEY `ContratoFretamento_FK_PlanoPagamento` (`PlanoPagamento_Id`),
  CONSTRAINT `FK_ContratoModelo_ContratoFretamento` FOREIGN KEY (`ContratoModelo_Id`) REFERENCES `contratomodelo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_ContratoFrota` FOREIGN KEY (`PessoaCliente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PlanoPagamento_ContratoFretamento` FOREIGN KEY (`PlanoPagamento_Id`) REFERENCES `planopagamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratofretamento`
--


/*!40000 ALTER TABLE `contratofretamento` DISABLE KEYS */;
LOCK TABLES `contratofretamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratofretamento` ENABLE KEYS */;

--
-- Table structure for table `contratofretamentocancel`
--

DROP TABLE IF EXISTS `contratofretamentocancel`;
CREATE TABLE `contratofretamentocancel` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContratoFretamento_Id` int(10) unsigned NOT NULL,
  `DataCancel` date default NULL,
  `HoraCancel` time default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Motivo` varchar(250) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoFretamentoCancel_FK_ContratoFrota` (`ContratoFretamento_Id`),
  CONSTRAINT `FK_ContratoFrota_ContratoFrotaCancel` FOREIGN KEY (`ContratoFretamento_Id`) REFERENCES `contratofretamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratofretamentocancel`
--


/*!40000 ALTER TABLE `contratofretamentocancel` DISABLE KEYS */;
LOCK TABLES `contratofretamentocancel` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratofretamentocancel` ENABLE KEYS */;

--
-- Table structure for table `contratofretamentoitens`
--

DROP TABLE IF EXISTS `contratofretamentoitens`;
CREATE TABLE `contratofretamentoitens` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `ObjetoVeiculo_Id` int(10) unsigned default NULL,
  `ContratoFretamento_Id` int(10) unsigned NOT NULL,
  `CidadeDestino_Id` int(11) NOT NULL,
  `CidadeOrigem_Id` int(11) NOT NULL,
  `DescricaoEmbarque` varchar(30) default NULL,
  `DescricaoDesembarque` varchar(30) default NULL,
  `DataSaida` date default NULL,
  `HoraSaida` time default NULL,
  `VeiculoDisposicao` tinyint(1) default NULL,
  `DataRetorno` date default NULL,
  `HoraRetorno` time default NULL,
  `KilometragemTotal` float(12,3) default NULL,
  `KilometragemValor` float(12,2) default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `TotalPoltronas` int(10) unsigned default NULL,
  `ValorValeMotorista` float(12,2) default NULL,
  `Ocorrencias` blob,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoFretamentoItens_FK_CidadeOrigem` (`CidadeOrigem_Id`),
  KEY `ContratoFretamentoItens_FK_CidadeDestino` (`CidadeDestino_Id`),
  KEY `ContratoFretamentoItens_FK_ContratoFrota` (`ContratoFretamento_Id`),
  KEY `ContratoFretamentoItens_FK_ObjetoVeiculo` (`ObjetoVeiculo_Id`),
  KEY `ContratoFretamentoItens_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_ContratoFretamentoItens` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeDestino_ContratoFrotaItens` FOREIGN KEY (`CidadeDestino_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeOrigem_ContratoFrotaItens` FOREIGN KEY (`CidadeOrigem_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContratoFrota_ContratoFrotaItens` FOREIGN KEY (`ContratoFretamento_Id`) REFERENCES `contratofretamento` (`Id`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `FK_ObjetoVeiculo_ContratoFrotaItens` FOREIGN KEY (`ObjetoVeiculo_Id`) REFERENCES `objetoveiculo` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratofretamentoitens`
--


/*!40000 ALTER TABLE `contratofretamentoitens` DISABLE KEYS */;
LOCK TABLES `contratofretamentoitens` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratofretamentoitens` ENABLE KEYS */;

--
-- Table structure for table `contratofretamentoitensdespesa`
--

DROP TABLE IF EXISTS `contratofretamentoitensdespesa`;
CREATE TABLE `contratofretamentoitensdespesa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `TipoGasto_Id` int(10) unsigned NOT NULL,
  `CentroCusto_Id` int(11) NOT NULL,
  `ContratoFretamentoItens_Id` int(10) unsigned NOT NULL,
  `Descricao` varchar(35) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoFretamentoItensDespesa_FK_ContratoFretamentoItens` (`ContratoFretamentoItens_Id`),
  KEY `ContratoFretamentoItensDespesa_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `ContratoFretamentoItensDespesa_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `ContratoFretamentoItensDespesa_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_ContratoFretamentoItensDespesa` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CentroCusto_ContratoFretamentoItensDespesa` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContratoFretamentoItens_Despesa` FOREIGN KEY (`ContratoFretamentoItens_Id`) REFERENCES `contratofretamentoitens` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_ContratoFretamentoItensDespesa` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratofretamentoitensdespesa`
--


/*!40000 ALTER TABLE `contratofretamentoitensdespesa` DISABLE KEYS */;
LOCK TABLES `contratofretamentoitensdespesa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratofretamentoitensdespesa` ENABLE KEYS */;

--
-- Table structure for table `contratofretamentoitensreceita`
--

DROP TABLE IF EXISTS `contratofretamentoitensreceita`;
CREATE TABLE `contratofretamentoitensreceita` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `Cidade_Id` int(11) NOT NULL,
  `ContratoFretamentoItens_Id` int(10) unsigned NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Obs` varchar(30) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoFretamentoItensReceita_FK_ContratoFretamentoItens` (`ContratoFretamentoItens_Id`),
  KEY `ContratoFretamentoItensReceita_FK_Cidade` (`Cidade_Id`),
  KEY `ContratoFretamentoItensReceita_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_ContratoFretamentoItensReceita` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Cidade_ContratoFretamentoItensReceita` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_ContratoFretamentoItens_Receita` FOREIGN KEY (`ContratoFretamentoItens_Id`) REFERENCES `contratofretamentoitens` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratofretamentoitensreceita`
--


/*!40000 ALTER TABLE `contratofretamentoitensreceita` DISABLE KEYS */;
LOCK TABLES `contratofretamentoitensreceita` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratofretamentoitensreceita` ENABLE KEYS */;

--
-- Table structure for table `contratomodelo`
--

DROP TABLE IF EXISTS `contratomodelo`;
CREATE TABLE `contratomodelo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Descricao` varchar(35) default NULL,
  `Contrato` longtext,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratomodelo`
--


/*!40000 ALTER TABLE `contratomodelo` DISABLE KEYS */;
LOCK TABLES `contratomodelo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratomodelo` ENABLE KEYS */;

--
-- Table structure for table `contratomonitoramento`
--

DROP TABLE IF EXISTS `contratomonitoramento`;
CREATE TABLE `contratomonitoramento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContratoModelo_Id` int(10) unsigned default NULL,
  `Cidade_Id` int(11) NOT NULL,
  `Bairro_Id` int(11) NOT NULL,
  `Logradouro_Id` int(11) NOT NULL,
  `PessoaContratante_Id` int(11) NOT NULL,
  `PessoaContratada_Id` int(11) NOT NULL,
  `NumeroEndereco` varchar(10) default NULL,
  `ComplementoEndereco` varchar(50) default NULL,
  `Emissao` date default NULL,
  `TaxaInstalacao` float(12,2) default NULL,
  `TaxaMensal` float(12,2) default NULL,
  `TaxaEmergencia` float(12,2) default NULL,
  `DiaFaturamento` int(10) unsigned default NULL,
  `TempoDuracao` int(10) unsigned default NULL,
  `Obs` varchar(100) default NULL,
  `DadosContrato` blob,
  `Confirmado` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ContratoMonitoramento_FK_PessoaContratada` (`PessoaContratada_Id`),
  KEY `ContratoMonitoramento_FK_PessoaContratante` (`PessoaContratante_Id`),
  KEY `ContratoMonitoramento_FK_Logradouro` (`Logradouro_Id`),
  KEY `ContratoMonitoramento_FK_Bairro` (`Bairro_Id`),
  KEY `ContratoMonitoramento_FK_Cidade` (`Cidade_Id`),
  KEY `ContratoMonitoramento_FK_Modelo` (`ContratoModelo_Id`),
  CONSTRAINT `FK_Bairro_ContratoMonitoramento` FOREIGN KEY (`Bairro_Id`) REFERENCES `bairro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Cidade_ContratoMonitoramento` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Logradouro_ContratoMonitoramento` FOREIGN KEY (`Logradouro_Id`) REFERENCES `logradouro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Modelo_ContratoMonitoramento` FOREIGN KEY (`ContratoModelo_Id`) REFERENCES `contratomodelo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaContratada_ContratoMonitoramento` FOREIGN KEY (`PessoaContratada_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaContratante_ContratoMonitoramento` FOREIGN KEY (`PessoaContratante_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `contratomonitoramento`
--


/*!40000 ALTER TABLE `contratomonitoramento` DISABLE KEYS */;
LOCK TABLES `contratomonitoramento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `contratomonitoramento` ENABLE KEYS */;

--
-- Table structure for table `cor`
--

DROP TABLE IF EXISTS `cor`;
CREATE TABLE `cor` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(15) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Cor_Unico` (`Nome`),
  KEY `Cor_FKIndex1` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Cor` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cor`
--


/*!40000 ALTER TABLE `cor` DISABLE KEYS */;
LOCK TABLES `cor` WRITE;
INSERT INTO `cor` (`Id`, `Loja_Id`, `Nome`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,'UNICA',1,'2006-11-11 02:34:49'),(2,1,'PRETA',1,'2006-11-11 02:34:49'),(3,1,'BRANCA',1,'2006-11-11 02:34:49'),(4,1,'VERMELHA',1,'2006-11-11 02:34:49'),(5,1,'AMARELA',1,'2006-11-11 02:34:49'),(6,1,'LARANJA',1,'2006-11-11 02:34:49'),(7,1,'VERDE',1,'2006-11-11 02:34:49'),(8,1,'AZUL',1,'2006-11-11 02:34:49'),(9,1,'MARROM',1,'2006-11-11 02:34:49'),(10,1,'ROSA',1,'2006-11-11 02:34:49'),(11,1,'BEGE',1,'2006-11-11 21:29:42'),(12,1,'GALVONIZADO',1,'2006-11-24 09:56:03'),(13,1,'CARAMELO',1,'2006-11-27 17:27:38'),(14,1,'CINZA',1,'2006-11-27 17:27:38'),(15,1,'CROMADO',1,'2006-11-27 17:27:38'),(16,1,'CINZA CLARO',1,'2006-11-27 17:27:38'),(17,1,'GRAFITE',1,'2006-12-02 16:21:41'),(18,1,'COURO',1,'2006-12-12 16:30:31'),(19,1,'COLORIDA',1,'2006-12-20 10:32:22'),(20,1,'CARAMELO CLARO',1,'2007-01-06 11:12:07'),(22,1,'VIOLETA',1,'2007-01-17 17:48:01'),(23,1,'DOURADO',1,'2007-01-18 10:54:38'),(25,1,'INOX',1,'2007-01-22 09:06:18'),(26,1,'ALUMINIO',1,'2007-01-25 14:56:03'),(27,1,'CERMICA',1,'2007-02-12 11:08:32'),(29,1,'AREIA',1,'2007-02-12 11:27:54'),(33,1,'CELESTE',1,'2007-02-12 11:30:44'),(34,1,'COLORADO',1,'2007-02-12 11:31:38'),(35,1,'CONHAQUE',1,'2007-02-12 11:32:14'),(37,1,'GELO',1,'2007-02-12 11:44:07'),(38,1,'MARFIM',1,'2007-02-12 11:45:08'),(40,1,'TABACO',1,'2007-02-12 11:47:20'),(41,1,'VERDE FOLHA',1,'2007-02-12 11:47:59'),(42,1,'VERDE NILO',1,'2007-02-12 11:48:22'),(43,1,'CREME',1,'2007-02-12 13:52:37'),(44,1,'PLATINA',1,'2007-02-12 13:56:35'),(47,1,'BRANCO NEVE',1,'2007-02-12 17:19:22'),(48,1,'MEL',1,'2007-02-12 17:20:35'),(49,1,'VANILA',1,'2007-02-12 17:22:47'),(50,1,'VERDE PISCINA',1,'2007-02-12 17:23:30'),(51,1,'FLAMINGO',1,'2007-02-12 17:31:15'),(52,1,'MARROCOS',1,'2007-02-12 17:31:58'),(53,1,'PALHA',1,'2007-02-12 17:41:29'),(55,1,'CINZA VIP',1,'2007-02-14 20:20:05'),(56,1,'CINZA REAL',1,'2007-02-14 20:20:05'),(57,1,'VERDE MALVA',1,'2007-02-14 20:25:46'),(58,1,'VERDE ACQUA',1,'2007-02-16 16:38:02'),(60,1,'LAGUNA',1,'2007-04-20 16:39:16'),(61,1,'TANGERINA',1,'2007-05-05 11:59:35'),(62,1,'BIANCO SERENO',1,'2007-05-05 14:22:23'),(63,1,'ERVA DOCE',1,'2007-05-05 14:23:08');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cor` ENABLE KEYS */;

--
-- Table structure for table `cotacao`
--

DROP TABLE IF EXISTS `cotacao`;
CREATE TABLE `cotacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Indexador` enum('Dollar','Ouro','Leite','ArrobaBoi','MaoDeObra') default NULL,
  `Vigencia` date default NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cotacao`
--


/*!40000 ALTER TABLE `cotacao` DISABLE KEYS */;
LOCK TABLES `cotacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cotacao` ENABLE KEYS */;

--
-- Table structure for table `csosn`
--

DROP TABLE IF EXISTS `csosn`;
CREATE TABLE `csosn` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` varchar(3) NOT NULL,
  `Descricao` varchar(60) default NULL,
  `Texto` text,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `csosn`
--


/*!40000 ALTER TABLE `csosn` DISABLE KEYS */;
LOCK TABLES `csosn` WRITE;
INSERT INTO `csosn` (`Id`, `Codigo`, `Descricao`, `Texto`) VALUES (1,'101','Tributada pelo Simples Nacional com permisso de crdito','Tributada pelo Simples Nacional com permisso de crdito - Classificam-se neste cdigo as operaes que permitem a indicao da alquota do ICMS devido no Simples Nacional e o valor do crdito correspondente.'),(2,'102','Tributada pelo Simples Nacional sem permisso de crdito','Tributada pelo Simples Nacional sem permisso de crdito - Classificam-se neste cdigo as operaes que no permitem a indicao da alquota do ICMS devido pelo Simples Nacional e do valor do crdito, e no estejam abrangidas nas hipteses dos cdigos 103, 203, 300, 400, 500 e 900.'),(3,'103','Iseno do ICMS no Simples Nacional para faixa de receita br','Iseno do ICMS no Simples Nacional para faixa de receita bruta - Classificam-se neste cdigo as operaes praticadas por optantes pelo Simples Nacional contemplados com iseno concedida para faixa de receita bruta nos termos da Lei Complementar n 123, de 2006.'),(4,'201','Tributada SNacional com permisso crdito e cob do ICMS ST','Tributada pelo Simples Nacional com permisso de crdito e com cobrana do ICMS por substituio tributria - Classificam-se neste cdigo as operaes que permitem a indicao da alquota do ICMS devido pelo Simples Nacional e do valor do crdito, e com cobrana do ICMS por substituio tributria.'),(5,'202','Tributada SNacional sem permisso crdito e cob do ICMS ST','Tributada pelo Simples Nacional sem permisso de crdito e com cobrana do ICMS por substituio tributria - Classificam-se neste cdigo as operaes que no permitem a indicao da alquota do ICMS devido pelo Simples Nacional e do valor do crdito, e no estejam abrangidas nas hipteses dos cdigos 103, 203, 300, 400, 500 e 900, e com cobrana do ICMS por substituio tributria.'),(6,'203','Isen. ICMS SNacional faixa de receita bruta com cob ICMS ST','Iseno do ICMS no Simples Nacional para faixa de receita bruta e com cobrana do ICMS por substituio tributria - Classificam-se neste cdigo as operaes praticadas por optantes pelo Simples Nacional contemplados com iseno para faixa de receita bruta nos termos da Lei Complementar n 123, de 2006, e com cobrana do ICMS por substituio tributria.'),(7,'300','Imune','Imune - Classificam-se neste cdigo as operaes praticadas por optantes pelo Simples Nacional contempladas com imunidade do ICMS.'),(8,'400','No tributada pelo Simples Nacional','No tributada pelo Simples Nacional - Classificam-se neste cdigo as operaes praticadas por optantes pelo Simples Nacional no sujeitas  tributao pelo ICMS dentro do Simples Nacional.'),(9,'500','ICMS cobrado ant por substituio tributria (substirudo)','ICMS cobrado anteriormente por substituio tributria (substitudo) ou por antecipao  Classificam-se neste cdigo as operaes sujeitas exclusivamente ao regime de substituio tributria na condio de substitudo tributrio ou no caso de antecipaes.'),(10,'900','Outros','Outros - Classificam-se neste cdigo as demais operaes que no se enquadrem nos cdigos 101, 102, 103, 201, 202, 203, 300, 400 e 500.');
UNLOCK TABLES;
/*!40000 ALTER TABLE `csosn` ENABLE KEYS */;

--
-- Table structure for table `cst`
--

DROP TABLE IF EXISTS `cst`;
CREATE TABLE `cst` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` varchar(3) NOT NULL COMMENT 'Codigo da Situacao Tributaria',
  `Descricao` varchar(100) NOT NULL,
  `Imposto` enum('ICMS','IPI','PIS','COFINS','SimplesNacional') NOT NULL,
  `OrigemMercadoria` enum('Nacional','Estrangeira - Importao direta','Estrangeira - Adquirida no mercado interno') NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cst`
--


/*!40000 ALTER TABLE `cst` DISABLE KEYS */;
LOCK TABLES `cst` WRITE;
INSERT INTO `cst` (`Id`, `Codigo`, `Descricao`, `Imposto`, `OrigemMercadoria`) VALUES (1,'000','Nacional tributada integralmente','ICMS','Nacional'),(2,'010','Nacional tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(3,'020','Nacional com reducao de base de calculo.','ICMS','Nacional'),(4,'030','Nacional isenta ou nao tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(5,'040','Nacional isenta.','ICMS','Nacional'),(6,'041','Nacional no tributada.','ICMS','Nacional'),(7,'050','Nacional com suspensao.','ICMS','Nacional'),(8,'051','Nacional com diferimento.','ICMS','Nacional'),(9,'060','Nacional ICMS cobrado anteriormente por ST.','ICMS','Nacional'),(10,'070','Nacional com reducao de base de calculo e cobranca do ICMS por ST.','ICMS','Nacional'),(11,'090','Nacional outras.','ICMS','Nacional'),(12,'100','Estrangeira - Importao direta - tributada integralmente.','ICMS','Nacional'),(13,'110','Estrangeira - Importao direta - tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(14,'120','Estrangeira - Importao direta - com reducao de base de calculo.','ICMS','Nacional'),(15,'130','Estrangeira - Importao direta - isenta ou nao tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(16,'140','Estrangeira - Importao direta - isenta.','ICMS','Nacional'),(17,'141','Estrangeira - Importao direta - no tributada.','ICMS','Nacional'),(18,'150','Estrangeira - Importao direta - com suspensao.','ICMS','Nacional'),(19,'151','Estrangeira - Importao direta - com diferimento.','ICMS','Nacional'),(20,'160','Estrangeira - Importao direta - ICMS cobrado anteriormente por ST.','ICMS','Nacional'),(21,'170','Estrangeira - Importao direta - com reducao de base de calculo e cobranca do ICMS por ST.','ICMS','Nacional'),(22,'190','Estrangeira - Importao direta - outras.','ICMS','Nacional'),(23,'200','Estrangeira - Adquirida Merc. Interno - tributada integralmente.','ICMS','Nacional'),(24,'210','Estrangeira - Adquirida Merc. Interno - tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(25,'220','Estrangeira - Adquirida Merc. Interno - com reducao de base de calculo.','ICMS','Nacional'),(26,'230','Estrangeira - Adquirida Merc. Interno - isenta ou nao tributada e com cobranca do ICMS por ST.','ICMS','Nacional'),(27,'240','Estrangeira - Adquirida Merc. Interno - isenta.','ICMS','Nacional'),(28,'241','Estrangeira - Adquirida Merc. Interno - no tributada.','ICMS','Nacional'),(29,'250','Estrangeira - Adquirida Merc. Interno - com suspensao.','ICMS','Nacional'),(30,'251','Estrangeira - Adquirida Merc. Interno - com diferimento.','ICMS','Nacional'),(31,'260','Estrangeira - Adquirida Merc. Interno - ICMS cobrado anteriormente por ST.','ICMS','Nacional'),(32,'270','Estrangeira - Adquirida Merc. Interno - com reducao de base de calculo e cobranca do ICMS por ST.','ICMS','Nacional'),(33,'290','Estrangeira - Adquirida Merc. Interno - outras.','ICMS','Nacional');
UNLOCK TABLES;
/*!40000 ALTER TABLE `cst` ENABLE KEYS */;

--
-- Table structure for table `cte`
--

DROP TABLE IF EXISTS `cte`;
CREATE TABLE `cte` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaTransportador_Id` int(11) NOT NULL,
  `COD_MOD` varchar(2) default NULL,
  `COD_SIT` varchar(2) default NULL,
  `SERIE` varchar(4) default NULL,
  `SUBSERIE` varchar(3) default NULL,
  `NUM_DOC` varchar(9) default NULL,
  `CHV_CTE` varchar(44) default NULL,
  `DT_DOC` date default NULL,
  `DT_A_P` date default NULL,
  `TP_CTe` int(10) unsigned default NULL,
  `CHV_CTE_REF` varchar(44) default NULL,
  `VL_DOC` float(12,2) default NULL,
  `VL_DESC` float(12,2) default NULL,
  `IND_FRT` char(1) default NULL,
  `VL_SERV` float(12,2) default NULL,
  `VL_BC_ICMS` float(12,2) default NULL,
  `ALIQ_ICMS` float(12,2) default NULL,
  `VL_ICMS` float(12,2) default NULL,
  `VL_NT` float(12,2) default NULL,
  `COD_INF` varchar(6) default NULL,
  `COD_CTA` varchar(10) default NULL,
  `CST_ICMS` varchar(3) default NULL,
  `CFOP` varchar(4) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  `COD_MUN_ORIG` varchar(7) default NULL,
  `COD_MUN_DEST` varchar(7) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `CTe_TranspNumero_unico` (`PessoaTransportador_Id`,`NUM_DOC`),
  KEY `CTe_FK_Transportador` (`PessoaTransportador_Id`),
  CONSTRAINT `FK_PessoaTransportador_CTe` FOREIGN KEY (`PessoaTransportador_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `cte`
--


/*!40000 ALTER TABLE `cte` DISABLE KEYS */;
LOCK TABLES `cte` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `cte` ENABLE KEYS */;

--
-- Table structure for table `dadosform`
--

DROP TABLE IF EXISTS `dadosform`;
CREATE TABLE `dadosform` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(10) unsigned default NULL,
  `NomeForm` varchar(50) NOT NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Atributo` varchar(50) NOT NULL,
  `Valor` varchar(100) NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dadosform`
--


/*!40000 ALTER TABLE `dadosform` DISABLE KEYS */;
LOCK TABLES `dadosform` WRITE;
INSERT INTO `dadosform` (`Id`, `Loja_Id`, `NomeForm`, `Usuario_Id`, `Atributo`, `Valor`) VALUES (1,NULL,'ParametroLoja1',NULL,'CodigoPessoa','1'),(2,NULL,'ParametroLoja1',NULL,'CodigoProduto','5'),(3,NULL,'ParametroLoja1',NULL,'CodigoCaixa','2'),(4,NULL,'FCadProdutosDlg',NULL,'mniVisualizarSomentUltimos100','N'),(5,NULL,'FPrincipal',NULL,'mniAcessarCarlosClay','N'),(6,NULL,'FNFeConfig',NULL,'chkDeterminarConfigPorMaquina','N'),(7,NULL,'FNFeVisual',NULL,'mniSincCNPJReferencia','Y'),(8,1,'System',NULL,'CNPJ_PAFECF','09541903000154'),(9,NULL,'FCadProdutos',NULL,'mniUsarConversaoUnidades','N'),(10,NULL,'FCadProdutos',NULL,'mniForcarCadastroColecao','N'),(11,NULL,'FCadProdutos',NULL,'mniSolicitarSenha','N'),(12,NULL,'FCadProdutos',NULL,'mniExportarProdutoCARLOSCLAYNOTE','N'),(13,NULL,'FCadProdutos',NULL,'mniValidarCodigoBarras','Y'),(14,NULL,'FNFCeConfig',NULL,'chkDeterminarConfigPorMaquina','N'),(15,NULL,'Semaforo',NULL,'CodigoEmAcao','DISPONIVEL'),(16,1,'FFinancCaixaMovimentacao',1,'mniOcultarVendasAprovadas','N'),(17,NULL,'FBuscaProdutos',NULL,'mniZerarValoresQuandoEstoqueZero','N'),(18,1,'FBuscaProdutos',1,'mniSempreAbrirEstilo2','N'),(19,NULL,'FCadProdutos',NULL,'mniConservarCampos','N'),(20,NULL,'FCadProdutos',NULL,'mniBuscarCusto','N'),(21,NULL,'FEstEntCompraMercadoria',NULL,'mniUsarConversaoUnidades','N'),(22,NULL,'FEstEntCompraMercadoria',NULL,'mniDeixarEmitirNotaDevolucaoQualquerData','N'),(23,NULL,'FEstEntCompraMercadoria',1,'mniBuscaItemTelaF9','N'),(24,NULL,'FEstEntCompraMercadoria',NULL,'mniForcarRegistroUnicoItem','Y'),(25,NULL,'FEstEntCompraMercadoria',NULL,'mniBuscarValorCusto','N'),(26,NULL,'FEstEntCompraMercadoria',NULL,'mniVerificarCNPJFornecedor','Y'),(27,NULL,'FEstEntCompraMercadoria',NULL,'mniVerificarCFOPCst','N'),(28,NULL,'FCadPessoaFisica',NULL,'mniDeixarRepetirCPF','N'),(29,NULL,'FCadPessoaFisica',NULL,'mniEditarCodigo','N'),(30,NULL,'FCadPessoaFisica',NULL,'mniCamuflarCodigo','N'),(31,NULL,'FCadPessoaFisica',NULL,'mniCadastrarEnderAutomatico','N'),(32,NULL,'FCadProdutos',NULL,'mniExportarProdutoGRANDALACERCLY','N'),(33,NULL,'FCadProdutos',NULL,'mniIncluirGradeAutomaticamente','N'),(34,NULL,'FCadProdutos',NULL,'mniPreencherGradeAutomaticamente','Y');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dadosform` ENABLE KEYS */;

--
-- Table structure for table `departamento`
--

DROP TABLE IF EXISTS `departamento`;
CREATE TABLE `departamento` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(35) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Departamento_Unico` (`Nome`),
  KEY `Departamento_FKIndex1` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Departamento` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `departamento`
--


/*!40000 ALTER TABLE `departamento` DISABLE KEYS */;
LOCK TABLES `departamento` WRITE;
INSERT INTO `departamento` (`Id`, `Loja_Id`, `Nome`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,'Vendas',1,'2006-08-30 21:42:57'),(2,1,'Compras',1,'2006-08-30 21:42:57'),(3,1,'Marketing',1,'2006-08-30 21:42:57'),(4,1,'Portaria',1,'2006-11-14 23:58:31'),(5,1,'Recursos Humanos',1,'2006-11-14 23:58:31'),(6,1,'Departamento Pessoal',1,'2006-11-14 23:58:31'),(7,1,'Caixa',1,'2006-11-14 23:58:31'),(8,1,'Recepo',1,'2006-11-14 23:58:31'),(9,1,'Telefonista',1,'2006-11-14 23:58:31'),(10,1,'Telemarketing',1,'2006-11-14 23:58:31'),(11,1,'Manuteno',1,'2006-11-14 23:58:31'),(12,1,'Diretoria',1,'2006-11-14 23:58:31'),(13,1,'Cobrana',1,'2006-11-14 23:58:31'),(14,1,'Faturamento',1,'2006-11-14 23:58:31'),(15,1,'Conferncia',1,'2006-11-14 23:58:31'),(16,1,'Tesouraria',1,'2006-11-14 23:58:31'),(17,1,'Refeitrio',1,'2006-11-14 23:58:31'),(18,1,'Alojamento',1,'2006-11-14 23:58:31');
UNLOCK TABLES;
/*!40000 ALTER TABLE `departamento` ENABLE KEYS */;

--
-- Table structure for table `dependente`
--

DROP TABLE IF EXISTS `dependente`;
CREATE TABLE `dependente` (
  `Id` int(11) NOT NULL auto_increment,
  `PessoaDependente_Id` int(11) NOT NULL,
  `Pessoa_Id` int(11) NOT NULL,
  `GrauParentesco` enum('Filho','Filha','Pai','Me','Av','Av','Neto','Neta','Primo','Prima','Conjuge','Outros') NOT NULL,
  `AutorizadoComprar` tinyint(1) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Dependente_Pessoa` (`PessoaDependente_Id`),
  KEY `Dependente_FKIndex1` (`Pessoa_Id`),
  KEY `Dependente_FKIndex2` (`PessoaDependente_Id`),
  CONSTRAINT `FK_Pessoa_Dependente` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_PessoaDependente` FOREIGN KEY (`PessoaDependente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `dependente`
--


/*!40000 ALTER TABLE `dependente` DISABLE KEYS */;
LOCK TABLES `dependente` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dependente` ENABLE KEYS */;

--
-- Table structure for table `despesaordinaria`
--

DROP TABLE IF EXISTS `despesaordinaria`;
CREATE TABLE `despesaordinaria` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `TipoGasto_Id` int(10) unsigned NOT NULL,
  `CentroCusto_Id` int(11) NOT NULL,
  `PessoaFavorecido_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `DiaVencimento` tinyint(2) unsigned NOT NULL,
  `Obs` varchar(35) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `DespesaOrdinaria_FK_Favorecido` (`PessoaFavorecido_Id`),
  KEY `DespesaOrdinaria_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `DespesaOrdinaria_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `DespesaOrdinaria_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `DespesaOrdinaria_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_CentroCusto_DespesaOrdinaria` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_DespesaOrdinaria` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_DespesaOrdinaria` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_DespesaOrdinaria` FOREIGN KEY (`PessoaFavorecido_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_DespesaOrdinaria` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `despesaordinaria`
--


/*!40000 ALTER TABLE `despesaordinaria` DISABLE KEYS */;
LOCK TABLES `despesaordinaria` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `despesaordinaria` ENABLE KEYS */;

--
-- Table structure for table `despesaordinariaanual`
--

DROP TABLE IF EXISTS `despesaordinariaanual`;
CREATE TABLE `despesaordinariaanual` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaFavorecido_Id` int(11) NOT NULL,
  `CentroCusto_Id` int(11) NOT NULL,
  `TipoGasto_Id` int(10) unsigned NOT NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `DiaVencimento` tinyint(2) unsigned NOT NULL,
  `MesVencimento` varchar(15) NOT NULL,
  `Obs` varchar(35) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `DespesaOrdinariaAnual_FK_Loja` (`Loja_Id`),
  KEY `DespesaOrdinariaAnual_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `DespesaOrdinariaAnual_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `DespesaOrdinariaAnual_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `DespesaOrdinariaAnual_FK_Pessoa` (`PessoaFavorecido_Id`),
  CONSTRAINT `FK_CentroCusto_DespesaOrdinariaanual` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_DespesaOrdinariaAnual` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_DespesaOrdinariaAnual` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_DespesaOrdinariaAnual` FOREIGN KEY (`PessoaFavorecido_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_DespesaOrdinariaAnual` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `despesaordinariaanual`
--


/*!40000 ALTER TABLE `despesaordinariaanual` DISABLE KEYS */;
LOCK TABLES `despesaordinariaanual` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `despesaordinariaanual` ENABLE KEYS */;

--
-- Table structure for table `emailconfig`
--

DROP TABLE IF EXISTS `emailconfig`;
CREATE TABLE `emailconfig` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LojaEmail_Id` int(11) NOT NULL,
  `ServidorSMTP` varchar(50) NOT NULL,
  `PortaSMTP` int(10) unsigned NOT NULL,
  `RequerAutenticacao` tinyint(1) default NULL,
  `UtilizaConexaoSegura` tinyint(1) default NULL,
  `Usuario` varchar(35) NOT NULL,
  `Senha` varchar(20) NOT NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  `Obs` text,
  PRIMARY KEY  (`Id`),
  KEY `EmailConfig_FK_Loja` (`LojaEmail_Id`),
  CONSTRAINT `FK_Loja_EmailConfig` FOREIGN KEY (`LojaEmail_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emailconfig`
--


/*!40000 ALTER TABLE `emailconfig` DISABLE KEYS */;
LOCK TABLES `emailconfig` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `emailconfig` ENABLE KEYS */;

--
-- Table structure for table `emailenviado`
--

DROP TABLE IF EXISTS `emailenviado`;
CREATE TABLE `emailenviado` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `EmailModelo_Id` int(10) unsigned NOT NULL,
  `Tabela` varchar(50) default NULL,
  `Tabela_Id` varchar(50) default NULL,
  `EmailOrigem` varchar(50) default NULL,
  `Cliente_Nome` varchar(50) default NULL,
  `Cliente_Email` varchar(50) default NULL,
  `Conteudo` text,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EmailEnviado_FK_Modelo` (`EmailModelo_Id`),
  KEY `EmailEnviado_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_EmailModelo_EmailEnviado` FOREIGN KEY (`EmailModelo_Id`) REFERENCES `emailmodelo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Lojax_EmailEnviado` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emailenviado`
--


/*!40000 ALTER TABLE `emailenviado` DISABLE KEYS */;
LOCK TABLES `emailenviado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `emailenviado` ENABLE KEYS */;

--
-- Table structure for table `emailmodelo`
--

DROP TABLE IF EXISTS `emailmodelo`;
CREATE TABLE `emailmodelo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Descricao` varchar(250) default NULL,
  `Tipo` varchar(25) default NULL,
  `HtmlScript` text,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EmailModelo_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_EmailModelo` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `emailmodelo`
--


/*!40000 ALTER TABLE `emailmodelo` DISABLE KEYS */;
LOCK TABLES `emailmodelo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `emailmodelo` ENABLE KEYS */;

--
-- Table structure for table `empregoatual`
--

DROP TABLE IF EXISTS `empregoatual`;
CREATE TABLE `empregoatual` (
  `Pessoa_Id` int(11) NOT NULL,
  `Cidade_Id` int(11) default NULL,
  `Bairro_Id` int(11) default NULL,
  `Logradouro_Id` int(11) default NULL,
  `Departamento_Id` int(11) default NULL,
  `Empregador` varchar(40) NOT NULL,
  `Numero` varchar(10) default NULL,
  `Telefone` varchar(15) default NULL,
  `Admissao` date default NULL,
  `Cargo` varchar(30) default NULL,
  `RendaMensal` float default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Pessoa_Id`),
  KEY `EmpregoAtual_FKIndex2` (`Departamento_Id`),
  KEY `EmpregoAtual_FKIndex3` (`Logradouro_Id`),
  KEY `EmpregoAtual_FKIndex4` (`Bairro_Id`),
  KEY `EmpregoAtual_FKIndex5` (`Cidade_Id`),
  KEY `EmpregoAtual_FKIndex6` (`Pessoa_Id`),
  CONSTRAINT `FK_Bairro_EmpregoAtual` FOREIGN KEY (`Bairro_Id`) REFERENCES `bairro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Cidade_EmpregoAtual` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Departamento_EmpregoAtual` FOREIGN KEY (`Departamento_Id`) REFERENCES `departamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Logradouro_EmpregoAtual` FOREIGN KEY (`Logradouro_Id`) REFERENCES `logradouro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_EmpregoAtual` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `empregoatual`
--


/*!40000 ALTER TABLE `empregoatual` DISABLE KEYS */;
LOCK TABLES `empregoatual` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `empregoatual` ENABLE KEYS */;

--
-- Table structure for table `encomenda`
--

DROP TABLE IF EXISTS `encomenda`;
CREATE TABLE `encomenda` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `LojaDestino_Id` int(11) NOT NULL,
  `EncomendaFormulario_Id` int(10) unsigned default NULL,
  `Loja_Id` int(11) NOT NULL,
  `ObjetoVeiculo_Id` int(10) unsigned default NULL,
  `PessoaRedespacho_Id` int(11) default NULL,
  `CidadeCalculadoAte_Id` int(11) default NULL,
  `CidadeLocalEntrega_Id` int(11) default NULL,
  `CidadeLocalColeta_Id` int(11) default NULL,
  `PessoaDestinatario_Id` int(11) NOT NULL,
  `PessoaRemetente_Id` int(11) NOT NULL,
  `CidadeLocal_Id` int(11) NOT NULL,
  `CFOP_Id` int(10) unsigned NOT NULL,
  `Modalidade` varchar(30) NOT NULL,
  `TipoDocumento` varchar(20) NOT NULL default '0' COMMENT '1 Minuta de despacho / 0 Conecimento',
  `NumeroDocumento` varchar(10) default NULL,
  `Classificacao` varchar(20) NOT NULL default '0' COMMENT '0 CIF / 1 FOB',
  `Emissao` date NOT NULL,
  `Hora` time NOT NULL,
  `ValorDizConter` varchar(15) default NULL,
  `ValorMercadoria` float(12,2) default NULL,
  `Quantidade` float(10,3) default NULL,
  `Especie` varchar(15) default NULL,
  `PesoReal` float(10,3) default NULL,
  `PesoCubado` float(10,3) default NULL,
  `MC` varchar(10) default NULL,
  `ValorTarifa` float(12,2) default NULL,
  `ValorEmit` float(12,2) default NULL,
  `ValorDespacho` float(12,2) default NULL,
  `ValorFretePeso` float(12,2) default NULL,
  `ValorFrete` float(12,2) default NULL,
  `ValorSecCat` float(12,2) default NULL,
  `ValorDespItr` float(12,2) default NULL,
  `ValorAdeme` float(12,2) default NULL,
  `ValorOutros` float(12,2) default NULL,
  `ValorTotPrestacao` float(12,2) default NULL,
  `ValorBaseCalculo` float(12,2) default NULL,
  `PercAliquota` float(10,2) default NULL,
  `ValorICMS` float(12,2) default NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Concluida` tinyint(1) default '0',
  `Cancelada` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Encomenda_FK_CFOP` (`CFOP_Id`),
  KEY `Encomenda_FK_CidadeLocal` (`CidadeLocal_Id`),
  KEY `Encomenda_FK_Remetente` (`PessoaRemetente_Id`),
  KEY `Encomenda_FK_Destinatario` (`PessoaDestinatario_Id`),
  KEY `Encomenda_FK_CidadeLocalColeta` (`CidadeLocalColeta_Id`),
  KEY `Encomenda_FK_CidadeLocalEntrega` (`CidadeLocalEntrega_Id`),
  KEY `Encomenda_FK_CidadeCalculadoAte` (`CidadeCalculadoAte_Id`),
  KEY `Encomenda_FK_PessoaRedespacho` (`PessoaRedespacho_Id`),
  KEY `Encomenda_FK_Veiculo` (`ObjetoVeiculo_Id`),
  KEY `Encomenda_FK_Loja` (`Loja_Id`),
  KEY `Encomenda_FK_EncomendaFormulario` (`EncomendaFormulario_Id`),
  KEY `Encomenda_FK_LojaDestino` (`LojaDestino_Id`),
  KEY `Encomenda_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_Encomenda` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CFOP_Encomenda` FOREIGN KEY (`CFOP_Id`) REFERENCES `cfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeCalculadoAte_Encomendas` FOREIGN KEY (`CidadeCalculadoAte_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeLocalColeta_Encomendas` FOREIGN KEY (`CidadeLocalColeta_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeLocalEntrega_Encomendas` FOREIGN KEY (`CidadeLocalEntrega_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CidadeLocal_Encomenda` FOREIGN KEY (`CidadeLocal_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_LojaDestino_Encomenda` FOREIGN KEY (`LojaDestino_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Encomenda` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaDestinatario_Encomendas` FOREIGN KEY (`PessoaDestinatario_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaRedespacho_Encomendas` FOREIGN KEY (`PessoaRedespacho_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PessoaRemetente_Encomenda` FOREIGN KEY (`PessoaRemetente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Veiculo_Encomendas` FOREIGN KEY (`ObjetoVeiculo_Id`) REFERENCES `objetoveiculo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Rel_522` FOREIGN KEY (`EncomendaFormulario_Id`) REFERENCES `encomendaformulario` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `encomenda`
--


/*!40000 ALTER TABLE `encomenda` DISABLE KEYS */;
LOCK TABLES `encomenda` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `encomenda` ENABLE KEYS */;

--
-- Table structure for table `encomendaentrega`
--

DROP TABLE IF EXISTS `encomendaentrega`;
CREATE TABLE `encomendaentrega` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Encomenda_Id` int(10) unsigned NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Entrega` date NOT NULL,
  `RecebidoPor` varchar(50) default NULL,
  `Ocorrencias` varchar(100) default NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Confirmado` tinyint(1) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `EncomendaEntrega_FK_Loja` (`Loja_Id`),
  KEY `EncomendaEntrega_FK_Encomenda` (`Encomenda_Id`),
  CONSTRAINT `FK_Encomenda_Entrega` FOREIGN KEY (`Encomenda_Id`) REFERENCES `encomenda` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_EncomendaEntrega` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `encomendaentrega`
--


/*!40000 ALTER TABLE `encomendaentrega` DISABLE KEYS */;
LOCK TABLES `encomendaentrega` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `encomendaentrega` ENABLE KEYS */;

--
-- Table structure for table `encomendaformulario`
--

DROP TABLE IF EXISTS `encomendaformulario`;
CREATE TABLE `encomendaformulario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Numero` int(10) unsigned default NULL,
  `Tipo` enum('Conhecimento','Minuta') default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EncomendaFormulario_FKIndex1` (`Loja_Id`),
  CONSTRAINT `FK_Loja_EncomendaFormulario` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `encomendaformulario`
--


/*!40000 ALTER TABLE `encomendaformulario` DISABLE KEYS */;
LOCK TABLES `encomendaformulario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `encomendaformulario` ENABLE KEYS */;

--
-- Table structure for table `encomendanotafiscal`
--

DROP TABLE IF EXISTS `encomendanotafiscal`;
CREATE TABLE `encomendanotafiscal` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Encomenda_Id` int(10) unsigned NOT NULL,
  `NumeroNF` varchar(10) default NULL,
  `EmissaoNF` date default NULL,
  `Peso` float(12,3) default NULL,
  `Volume` int(10) unsigned default NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EncomendaNotasFiscais_FKIndex1` (`Encomenda_Id`),
  CONSTRAINT `Rel_519` FOREIGN KEY (`Encomenda_Id`) REFERENCES `encomenda` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `encomendanotafiscal`
--


/*!40000 ALTER TABLE `encomendanotafiscal` DISABLE KEYS */;
LOCK TABLES `encomendanotafiscal` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `encomendanotafiscal` ENABLE KEYS */;

--
-- Table structure for table `entregadomicilio`
--

DROP TABLE IF EXISTS `entregadomicilio`;
CREATE TABLE `entregadomicilio` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ObjetoVeiculo_Id` int(10) unsigned default NULL,
  `VendaRetirada_Id` int(10) unsigned default NULL,
  `Venda_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PessoaTransportador_Id` int(11) default NULL,
  `Cidade_Id` int(11) NOT NULL,
  `Bairro_Id` int(11) NOT NULL,
  `Logradouro_Id` int(11) NOT NULL,
  `NomeRecebedor` varchar(35) NOT NULL,
  `DataEntrega` date default NULL,
  `HoraEntrega` time default NULL,
  `Numero` varchar(10) default NULL,
  `Complemento` varchar(80) default NULL,
  `Telefone` varchar(15) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `Obs` text,
  `DataHoraGrav` datetime NOT NULL,
  `ImpGuiaEntrega` datetime default NULL,
  `FretePorConta` varchar(20) default NULL,
  `ValorFrete` float(12,2) default NULL,
  `ValorBCFrete` float(12,2) default NULL,
  `PercAliquotaFrete` float(9,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EntregaDomicilio_FK_Logradouro` (`Logradouro_Id`),
  KEY `EntregaDomicilio_FK_Bairro` (`Bairro_Id`),
  KEY `EntregaDomicilio_FK_Cidade` (`Cidade_Id`),
  KEY `EntregaDomicilio_FK_Transportador` (`PessoaTransportador_Id`),
  KEY `EntregaDomicilio_FK_Loja` (`Loja_Id`),
  KEY `EntregaDomicilio_FK_Venda` (`Venda_Id`),
  KEY `EntregaDomicilio_FK_VendaRetirada` (`VendaRetirada_Id`),
  KEY `EntregaDomicilio_FKIndex8` (`ObjetoVeiculo_Id`),
  CONSTRAINT `FK_Bairro_EntregaDomicilio` FOREIGN KEY (`Bairro_Id`) REFERENCES `bairro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Cidade_EntragaDomicilio` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Logradouro_EntregaDomicilio` FOREIGN KEY (`Logradouro_Id`) REFERENCES `logradouro` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_EntregaDomicilio` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ObjetoVeiculo_EntregaDomicilio` FOREIGN KEY (`ObjetoVeiculo_Id`) REFERENCES `objetoveiculo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_EntregaDomicilioTransportador` FOREIGN KEY (`PessoaTransportador_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_VendaRetirada_EntregaDomicilio` FOREIGN KEY (`VendaRetirada_Id`) REFERENCES `vendaretirada` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Venda_EntregaDomicilio` FOREIGN KEY (`Venda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `entregadomicilio`
--


/*!40000 ALTER TABLE `entregadomicilio` DISABLE KEYS */;
LOCK TABLES `entregadomicilio` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `entregadomicilio` ENABLE KEYS */;

--
-- Table structure for table `entregavolume`
--

DROP TABLE IF EXISTS `entregavolume`;
CREATE TABLE `entregavolume` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Compra_Id` int(11) default NULL,
  `EntregaDomicilio_Id` int(10) unsigned default NULL,
  `Especie` varchar(20) default NULL,
  `Quantidade` int(10) unsigned default NULL,
  `Numeracao` varchar(20) default NULL,
  `Marca` varchar(20) default NULL,
  `PesoBruto` float(10,3) default NULL,
  `PesoLiquido` float(10,3) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EntregaVolume_FK_EntregaDomicilio` (`EntregaDomicilio_Id`),
  KEY `EntregaVolume_FK_Compra` (`Compra_Id`),
  CONSTRAINT `FK_Compra_Volumes` FOREIGN KEY (`Compra_Id`) REFERENCES `compra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Entrega_Volume` FOREIGN KEY (`EntregaDomicilio_Id`) REFERENCES `entregadomicilio` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `entregavolume`
--


/*!40000 ALTER TABLE `entregavolume` DISABLE KEYS */;
LOCK TABLES `entregavolume` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `entregavolume` ENABLE KEYS */;

--
-- Table structure for table `etiquetaacbr`
--

DROP TABLE IF EXISTS `etiquetaacbr`;
CREATE TABLE `etiquetaacbr` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Descricao` varchar(50) default NULL,
  `Avanco` int(10) unsigned default NULL,
  `Modelo` enum('PPLA') default NULL,
  `Dpi` enum('203','300','600') default NULL,
  `Temperatura` int(10) unsigned default NULL,
  `Porta` varchar(35) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `etiquetaacbr`
--


/*!40000 ALTER TABLE `etiquetaacbr` DISABLE KEYS */;
LOCK TABLES `etiquetaacbr` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `etiquetaacbr` ENABLE KEYS */;

--
-- Table structure for table `etiquetaacbritem`
--

DROP TABLE IF EXISTS `etiquetaacbritem`;
CREATE TABLE `etiquetaacbritem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `EtiquetaACBr_Id` int(10) unsigned NOT NULL,
  `Sequencia` int(10) unsigned default NULL,
  `NomeCampo` varchar(30) default NULL,
  `Orientacao` enum('Normal','270','180','90') default NULL,
  `Fonte` int(10) unsigned default NULL,
  `MultiplicadorH` int(10) unsigned default NULL,
  `MultiplicadorV` int(10) unsigned default NULL,
  `Vertical` int(10) unsigned default NULL,
  `Horizontal` int(10) unsigned default NULL,
  `Texto` varchar(35) default NULL,
  `TipoBarras` char(1) default NULL,
  `LarguraBarraLarga` varchar(3) default NULL,
  `LarguraBarraFina` varchar(3) default NULL,
  `AlturaCodigoBarra` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `EtiquetaACBrItem_FK_EtiquetaACBr` (`EtiquetaACBr_Id`),
  CONSTRAINT `FK_EtiquetaACBr_Item` FOREIGN KEY (`EtiquetaACBr_Id`) REFERENCES `etiquetaacbr` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `etiquetaacbritem`
--


/*!40000 ALTER TABLE `etiquetaacbritem` DISABLE KEYS */;
LOCK TABLES `etiquetaacbritem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `etiquetaacbritem` ENABLE KEYS */;

--
-- Table structure for table `exportalog`
--

DROP TABLE IF EXISTS `exportalog`;
CREATE TABLE `exportalog` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Tabela` varchar(50) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  `Comando` varchar(15) default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `exportalog`
--


/*!40000 ALTER TABLE `exportalog` DISABLE KEYS */;
LOCK TABLES `exportalog` WRITE;
INSERT INTO `exportalog` (`Id`, `Tabela`, `Tabela_Id`, `Comando`, `Loja_Id`, `DataHoraGrav`) VALUES (1,'ProdutoGrade',1,'INSERT',1,'2019-12-18 11:56:47'),(2,'ProdutoGrade',1,'UPDATE',1,'2019-12-18 11:56:54'),(3,'ProdutoGrade',1,'UPDATE',1,'2019-12-18 11:57:10'),(4,'ProdutoGrade',1,'UPDATE',1,'2019-12-18 11:57:49'),(5,'ProdutoGrade',1,'UPDATE',1,'2019-12-18 11:58:23'),(6,'ProdutoGrade',1,'UPDATE',1,'2019-12-18 11:58:38');
UNLOCK TABLES;
/*!40000 ALTER TABLE `exportalog` ENABLE KEYS */;

--
-- Table structure for table `fatura`
--

DROP TABLE IF EXISTS `fatura`;
CREATE TABLE `fatura` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Caixa_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `PlanoPagamento_Id` int(11) default NULL,
  `FormaPagamento_Id` int(11) default NULL,
  `Emissao` date default NULL,
  `Confirmada` tinyint(3) unsigned default '0',
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Obs` text,
  PRIMARY KEY  (`Id`),
  KEY `Fatura_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `Fatura_FK_PlanoPagamento` (`PlanoPagamento_Id`),
  KEY `Fatura_FK_Loja` (`Loja_Id`),
  KEY `Fatura_FK_Caixa` (`Caixa_Id`),
  CONSTRAINT `FK_Caixa_Fatura` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_Fatura` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Fatura` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PlanoPagamento_Fatura` FOREIGN KEY (`PlanoPagamento_Id`) REFERENCES `planopagamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fatura`
--


/*!40000 ALTER TABLE `fatura` DISABLE KEYS */;
LOCK TABLES `fatura` WRITE;
INSERT INTO `fatura` (`Id`, `Caixa_Id`, `Loja_Id`, `PlanoPagamento_Id`, `FormaPagamento_Id`, `Emissao`, `Confirmada`, `DataHoraGrav`, `Usuario_Id`, `Obs`) VALUES (1,NULL,1,NULL,NULL,'2009-08-19',0,'2009-08-19 22:47:27',1,NULL),(2,NULL,1,NULL,NULL,'2009-08-19',0,'2009-08-19 22:47:32',1,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `fatura` ENABLE KEYS */;

--
-- Table structure for table `faturaitem`
--

DROP TABLE IF EXISTS `faturaitem`;
CREATE TABLE `faturaitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Fatura_Id` int(10) unsigned NOT NULL,
  `Tabela` varchar(50) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FaturaItem_FK_Fatura` (`Fatura_Id`),
  KEY `FaturaItem_Tabela_Id` (`Tabela`,`Tabela_Id`),
  CONSTRAINT `FK_Fatura_FaturaItem` FOREIGN KEY (`Fatura_Id`) REFERENCES `fatura` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `faturaitem`
--


/*!40000 ALTER TABLE `faturaitem` DISABLE KEYS */;
LOCK TABLES `faturaitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `faturaitem` ENABLE KEYS */;

--
-- Table structure for table `feriados`
--

DROP TABLE IF EXISTS `feriados`;
CREATE TABLE `feriados` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Cidade_Id` int(11) default NULL,
  `Descricao` varchar(30) NOT NULL,
  `Tipo` enum('Internacional','Nacional','Estadual','Municipal','Outros') NOT NULL,
  `Dia` date NOT NULL,
  `Fixo` tinyint(1) default '0',
  PRIMARY KEY  (`Id`),
  KEY `Feriados_FK_Cidade` (`Cidade_Id`),
  CONSTRAINT `FK_Cidade_Feriados` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `feriados`
--


/*!40000 ALTER TABLE `feriados` DISABLE KEYS */;
LOCK TABLES `feriados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `feriados` ENABLE KEYS */;

--
-- Table structure for table `financboleto`
--

DROP TABLE IF EXISTS `financboleto`;
CREATE TABLE `financboleto` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Conta_Id` int(11) NOT NULL,
  `ContasReceber_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `MensagemLocalPagamento` varchar(85) default NULL,
  `EspecieDocto` varchar(3) default NULL,
  `EspecieMoeda` varchar(3) default NULL,
  `Aceite` tinyint(1) default NULL,
  `Carteira` varchar(3) default NULL,
  `NossoNumero` varchar(20) default NULL,
  `ValorMoraJuros` float(12,2) default NULL,
  `DataMoraJuros` date default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `DataDesconto` date default NULL,
  `ValorAbatimento` float(12,2) default NULL,
  `DataAbatimento` date default NULL,
  `PercentualMulta` float(12,2) default NULL,
  `DataProtesto` date default NULL,
  `MensagemInstrucao` text,
  `Instrucao1` varchar(50) default NULL,
  `Instrucao2` varchar(50) default NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `SituacaoRemessa` enum('Pendente','Enviada','Ignorado') default NULL,
  `NomeArquivoRemessa` varchar(15) default NULL,
  `IdWeb` varchar(128) default NULL,
  `BoletoIdUnico` varchar(32) default NULL,
  `Boleto_CodigoUnico` varchar(32) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FinancBoleto_FK_Loja` (`Loja_Id`),
  KEY `FinancBoleto_FK_ContasReceber` (`ContasReceber_Id`),
  KEY `FinancBoleto_FK_Conta` (`Conta_Id`),
  CONSTRAINT `FK_ContasReceber_Boleto` FOREIGN KEY (`ContasReceber_Id`) REFERENCES `contasreceber` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Conta_FinancBoleto` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Boleto` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financboleto`
--


/*!40000 ALTER TABLE `financboleto` DISABLE KEYS */;
LOCK TABLES `financboleto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financboleto` ENABLE KEYS */;

--
-- Table structure for table `financcompensacao`
--

DROP TABLE IF EXISTS `financcompensacao`;
CREATE TABLE `financcompensacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancMovimentoBancario_Id` int(10) unsigned NOT NULL,
  `Cheque_Id` int(11) NOT NULL,
  `Alinea` enum('Compensado','Sustado','Roubado','SaldoIndisponivel') default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Compensacao_FK_Cheque` (`Cheque_Id`),
  KEY `Compensacao_FK_MovimentoBancario` (`FinancMovimentoBancario_Id`),
  CONSTRAINT `FK_Cheque_Compensacao` FOREIGN KEY (`Cheque_Id`) REFERENCES `cheque` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_MovimentoBancario_Compensacao` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financcompensacao`
--


/*!40000 ALTER TABLE `financcompensacao` DISABLE KEYS */;
LOCK TABLES `financcompensacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financcompensacao` ENABLE KEYS */;

--
-- Table structure for table `financdebitos`
--

DROP TABLE IF EXISTS `financdebitos`;
CREATE TABLE `financdebitos` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CentroCusto_Id` int(11) NOT NULL,
  `TipoGasto_Id` int(10) unsigned NOT NULL,
  `FinancMovimentoBancario_Id` int(10) unsigned NOT NULL,
  `Valor` float(12,2) default NULL,
  `Obs` varchar(50) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FinancDebitos_FK_MovimentoBancario` (`FinancMovimentoBancario_Id`),
  KEY `FinancDebitos_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `FinancDebitos_FK_CentroCusto` (`CentroCusto_Id`),
  CONSTRAINT `FK_CentroCusto_DebitoBancario` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_MovimentoBancario_Debitos` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_DebitoBancario` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financdebitos`
--


/*!40000 ALTER TABLE `financdebitos` DISABLE KEYS */;
LOCK TABLES `financdebitos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financdebitos` ENABLE KEYS */;

--
-- Table structure for table `financdeposito`
--

DROP TABLE IF EXISTS `financdeposito`;
CREATE TABLE `financdeposito` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancMovimentoBancario_Id` int(10) unsigned NOT NULL,
  `CaixaGeral_Id` int(10) unsigned default NULL COMMENT 'O Caixa geral podera fazer um deposito.',
  `Caixa_Id` int(11) default NULL COMMENT 'O Caixa comum podera fazer um deposito.',
  `ValorDinheiro` float(12,2) default NULL,
  `ValorCheque` float(12,2) default NULL,
  `Situacao` enum('Normal','Cancelado') default NULL,
  `Obs` varchar(50) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Deposito_FK_Caixa` (`Caixa_Id`),
  KEY `Deposito_FK_CaixaGeral` (`CaixaGeral_Id`),
  KEY `Deposito_FK_MovimentoBancario` (`FinancMovimentoBancario_Id`),
  CONSTRAINT `FK_CaixaGeral_Deposito` FOREIGN KEY (`CaixaGeral_Id`) REFERENCES `caixageral` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Caixa_Deposito` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_MovimentoBancario_Deposito` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financdeposito`
--


/*!40000 ALTER TABLE `financdeposito` DISABLE KEYS */;
LOCK TABLES `financdeposito` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financdeposito` ENABLE KEYS */;

--
-- Table structure for table `financdepositoitens`
--

DROP TABLE IF EXISTS `financdepositoitens`;
CREATE TABLE `financdepositoitens` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancDeposito_Id` int(10) unsigned NOT NULL,
  `Cheque_Id` int(11) NOT NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `DepositoItens_FK_Cheque` (`Cheque_Id`),
  KEY `DepositoItens_FK_Deposito` (`FinancDeposito_Id`),
  CONSTRAINT `FK_Cheque_DepositoItens` FOREIGN KEY (`Cheque_Id`) REFERENCES `cheque` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Deposito_DepositoItens` FOREIGN KEY (`FinancDeposito_Id`) REFERENCES `financdeposito` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financdepositoitens`
--


/*!40000 ALTER TABLE `financdepositoitens` DISABLE KEYS */;
LOCK TABLES `financdepositoitens` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financdepositoitens` ENABLE KEYS */;

--
-- Table structure for table `financemprestimo`
--

DROP TABLE IF EXISTS `financemprestimo`;
CREATE TABLE `financemprestimo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancMovimentoBancario_Id` int(10) unsigned NOT NULL,
  `ContaEmprestimo_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FinancEmprestimo_FK_ContaEmprestimo` (`ContaEmprestimo_Id`),
  KEY `FinancEmprestimo_FK_MovimentoBancario` (`FinancMovimentoBancario_Id`),
  CONSTRAINT `FK_ContaEmprestimo_FinancEmprestimo` FOREIGN KEY (`ContaEmprestimo_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_MovimentoBancario_Emprestimo` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financemprestimo`
--


/*!40000 ALTER TABLE `financemprestimo` DISABLE KEYS */;
LOCK TABLES `financemprestimo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financemprestimo` ENABLE KEYS */;

--
-- Table structure for table `financemprestimoparcela`
--

DROP TABLE IF EXISTS `financemprestimoparcela`;
CREATE TABLE `financemprestimoparcela` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FinancEmprestimo_Id` int(10) unsigned NOT NULL,
  `Vencimento` date default NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FinancEmprestimoParcela_FK_Emprestimo` (`FinancEmprestimo_Id`),
  CONSTRAINT `FK_FinancEmprestimo_Parcelas` FOREIGN KEY (`FinancEmprestimo_Id`) REFERENCES `financemprestimo` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financemprestimoparcela`
--


/*!40000 ALTER TABLE `financemprestimoparcela` DISABLE KEYS */;
LOCK TABLES `financemprestimoparcela` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financemprestimoparcela` ENABLE KEYS */;

--
-- Table structure for table `financmovimentobancario`
--

DROP TABLE IF EXISTS `financmovimentobancario`;
CREATE TABLE `financmovimentobancario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContaBancaria_Id` int(11) NOT NULL,
  `DataMovimento` date default NULL,
  `Saldo` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Bancario_FK_ContaBancaria` (`ContaBancaria_Id`),
  CONSTRAINT `FK_ContaBancaria_Bancario` FOREIGN KEY (`ContaBancaria_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financmovimentobancario`
--


/*!40000 ALTER TABLE `financmovimentobancario` DISABLE KEYS */;
LOCK TABLES `financmovimentobancario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financmovimentobancario` ENABLE KEYS */;

--
-- Table structure for table `financmovimentobancariotransfer`
--

DROP TABLE IF EXISTS `financmovimentobancariotransfer`;
CREATE TABLE `financmovimentobancariotransfer` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContaBancaria_Id` int(11) NOT NULL COMMENT 'Conta que recebeu o dinheiro transferido',
  `FinancMovimentoBancario_Id` int(10) unsigned NOT NULL COMMENT 'Conta que est enviando o dinheiro',
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FinancMovimentoBancarior_FK_Transfer` (`FinancMovimentoBancario_Id`),
  KEY `MovimentoBancarioTransfer_FK_ContaBancaria` (`ContaBancaria_Id`),
  CONSTRAINT `FinancMovimentoBancario_Transfer` FOREIGN KEY (`FinancMovimentoBancario_Id`) REFERENCES `financmovimentobancario` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaBancaria_Transfer` FOREIGN KEY (`ContaBancaria_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `financmovimentobancariotransfer`
--


/*!40000 ALTER TABLE `financmovimentobancariotransfer` DISABLE KEYS */;
LOCK TABLES `financmovimentobancariotransfer` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `financmovimentobancariotransfer` ENABLE KEYS */;

--
-- Table structure for table `fisccfop`
--

DROP TABLE IF EXISTS `fisccfop`;
CREATE TABLE `fisccfop` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CSTCofins_Id` int(10) unsigned default NULL,
  `CSTPis_Id` int(10) unsigned default NULL,
  `Ordem` int(10) unsigned default NULL,
  `Descricao` varchar(75) NOT NULL,
  `Fluxo` enum('Entrada','Saida') NOT NULL,
  `Codigo_MesmaUF` varchar(4) default NULL,
  `Codigo_OutraUF` varchar(4) default NULL,
  `Codigo_Exterior` varchar(4) default NULL,
  `TextoInformativo` text,
  `AnaliticoSintetico` char(1) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FiscCFOP_DescricaoUnica` (`Descricao`),
  KEY `FiscCFOP_FK_CSTPis` (`CSTPis_Id`),
  KEY `FiscCFOP_FK_Cofins` (`CSTCofins_Id`),
  CONSTRAINT `FK_CSTCofins_CFOP` FOREIGN KEY (`CSTCofins_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CSTPis_CFOP` FOREIGN KEY (`CSTPis_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fisccfop`
--


/*!40000 ALTER TABLE `fisccfop` DISABLE KEYS */;
LOCK TABLES `fisccfop` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fisccfop` ENABLE KEYS */;

--
-- Table structure for table `fisccst_icms`
--

DROP TABLE IF EXISTS `fisccst_icms`;
CREATE TABLE `fisccst_icms` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CST_Id` int(10) unsigned NOT NULL,
  `TemModBC` tinyint(1) default NULL,
  `TemPercMVAST` tinyint(1) default NULL,
  `TemPercRedBC` tinyint(1) default NULL,
  `TemValorBC` tinyint(1) default NULL,
  `TemPercICMS` tinyint(1) default NULL,
  `TemValorICMS` tinyint(1) default NULL,
  `TemModBCST` tinyint(1) default NULL,
  `TemPercRedBCST` tinyint(1) default NULL,
  `TemValorBCST` tinyint(1) default NULL,
  `TemPercICMSST` tinyint(1) default NULL,
  `TemValorICMSST` tinyint(1) default NULL,
  `TemValorBCSTRet` tinyint(1) default NULL,
  `TemValorICMSSTRet` tinyint(1) default NULL,
  `TemValorBCSTDest` tinyint(1) default NULL,
  `TemValorICMSSTDest` tinyint(1) default NULL,
  `TemMotDesICMS` tinyint(1) default NULL,
  `TemPercBCOp` tinyint(1) default NULL,
  `TemUFST` tinyint(1) default NULL,
  `TemPercCredSN` tinyint(1) default NULL,
  `TemValorCredSN` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FiscCST_ICMS_FK_CST` (`CST_Id`),
  CONSTRAINT `CST_CSTICMS` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fisccst_icms`
--


/*!40000 ALTER TABLE `fisccst_icms` DISABLE KEYS */;
LOCK TABLES `fisccst_icms` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fisccst_icms` ENABLE KEYS */;

--
-- Table structure for table `fisccstcrt`
--

DROP TABLE IF EXISTS `fisccstcrt`;
CREATE TABLE `fisccstcrt` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CST_ICMS_Id` int(10) unsigned NOT NULL,
  `CRT` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `CSTCRT_FK_CST_ICMS` (`CST_ICMS_Id`),
  CONSTRAINT `CRT_CST` FOREIGN KEY (`CST_ICMS_Id`) REFERENCES `fisccst_icms` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fisccstcrt`
--


/*!40000 ALTER TABLE `fisccstcrt` DISABLE KEYS */;
LOCK TABLES `fisccstcrt` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fisccstcrt` ENABLE KEYS */;

--
-- Table structure for table `fiscicmscidade`
--

DROP TABLE IF EXISTS `fiscicmscidade`;
CREATE TABLE `fiscicmscidade` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSRegra_Id` int(10) unsigned NOT NULL,
  `ModBCST_Id` int(10) unsigned default NULL,
  `ModBC_Id` int(10) unsigned default NULL,
  `MotDesoner_Id` int(10) unsigned default NULL,
  `CST_Id` int(10) unsigned NOT NULL,
  `Cidade_Id` int(11) NOT NULL,
  `PercRedBC` float(4,2) default NULL,
  `PercICMS` float(4,2) default NULL,
  `PercMVAST` float(4,2) default NULL,
  `PercRedBCST` float(4,2) default NULL,
  `PercICMSST` float(4,2) default NULL,
  `PercBCOper` float(4,2) default NULL,
  `PercCredSN` float(4,2) default NULL,
  `PercDesconto` float(4,2) default NULL,
  `InfoCompl` varchar(80) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscICMSCidade_FK_Cidade` (`Cidade_Id`),
  KEY `FiscICMSCidade_FK_CST` (`CST_Id`),
  KEY `FiscICMSCidade_FK_ICMSRegra` (`ICMSRegra_Id`),
  KEY `FiscICMSCidade_FK_MotDesoner` (`MotDesoner_Id`),
  KEY `FiscICMSCidade_FK_ModBC` (`ModBC_Id`),
  KEY `FiscICMSCidade_FK_ModBCST` (`ModBCST_Id`),
  CONSTRAINT `Cidade_ICMS` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `CST_ICMSCidade` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMSRegraDetalhe_ICMSCidade` FOREIGN KEY (`ICMSRegra_Id`) REFERENCES `fiscicmsregra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBCST_ICMSCidade` FOREIGN KEY (`ModBCST_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBC_ICMSCidade` FOREIGN KEY (`ModBC_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `MotDesoner_ICMSCidade` FOREIGN KEY (`MotDesoner_Id`) REFERENCES `fiscicmsmotdesoner` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmscidade`
--


/*!40000 ALTER TABLE `fiscicmscidade` DISABLE KEYS */;
LOCK TABLES `fiscicmscidade` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmscidade` ENABLE KEYS */;

--
-- Table structure for table `fiscicmsgrupo`
--

DROP TABLE IF EXISTS `fiscicmsgrupo`;
CREATE TABLE `fiscicmsgrupo` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Descricao` varchar(40) default NULL,
  `Origem` enum('Nacional','Estrangeira - Importao direta','Estrangeira - Adquirida no mercado interno') default NULL,
  `Obs` text,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FiscICMSGrupo_Descricao` (`Descricao`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmsgrupo`
--


/*!40000 ALTER TABLE `fiscicmsgrupo` DISABLE KEYS */;
LOCK TABLES `fiscicmsgrupo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmsgrupo` ENABLE KEYS */;

--
-- Table structure for table `fiscicmsmotdesoner`
--

DROP TABLE IF EXISTS `fiscicmsmotdesoner`;
CREATE TABLE `fiscicmsmotdesoner` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` tinyint(3) unsigned default NULL,
  `Descricao` varchar(35) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FiscICMSMotDesoner_Codigo` (`Codigo`),
  UNIQUE KEY `FiscICMSMotDesoner_Descricao` (`Descricao`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmsmotdesoner`
--


/*!40000 ALTER TABLE `fiscicmsmotdesoner` DISABLE KEYS */;
LOCK TABLES `fiscicmsmotdesoner` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmsmotdesoner` ENABLE KEYS */;

--
-- Table structure for table `fiscicmspais`
--

DROP TABLE IF EXISTS `fiscicmspais`;
CREATE TABLE `fiscicmspais` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSRegra_Id` int(10) unsigned NOT NULL,
  `ModBCST_Id` int(10) unsigned default NULL,
  `ModBC_Id` int(10) unsigned default NULL,
  `MotDesoner_Id` int(10) unsigned default NULL,
  `CST_Id` int(10) unsigned NOT NULL,
  `Pais_Id` int(11) NOT NULL,
  `PercRedBC` float(4,2) default NULL,
  `PercICMS` float(4,2) default NULL,
  `PercMVAST` float(4,2) default NULL,
  `PercRedBCST` float(4,2) default NULL,
  `PercICMSST` float(4,2) default NULL,
  `PercBCOper` float(4,2) default NULL,
  `PercCredSN` float(4,2) default NULL,
  `PercDesconto` float(4,2) default NULL,
  `InfoCompl` varchar(80) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscICMSPais_FK_Pais` (`Pais_Id`),
  KEY `FiscICMSPais_FK_CST` (`CST_Id`),
  KEY `FiscICMSPais_FK_ICMSRegra` (`ICMSRegra_Id`),
  KEY `FiscICMSPais_FK_MotDesoner` (`MotDesoner_Id`),
  KEY `FiscICMSPais_FK_ModBC` (`ModBC_Id`),
  KEY `FiscICMSPais_FK_ModBCST` (`ModBCST_Id`),
  CONSTRAINT `CST_ICMSPais` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMSRegraDetalhe_ICMSPais` FOREIGN KEY (`ICMSRegra_Id`) REFERENCES `fiscicmsregra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBCST_ICMSPais` FOREIGN KEY (`ModBCST_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBC_ICMSPais` FOREIGN KEY (`ModBC_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `MotDes_ICMSPais` FOREIGN KEY (`MotDesoner_Id`) REFERENCES `fiscicmsmotdesoner` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Pais_ICMS` FOREIGN KEY (`Pais_Id`) REFERENCES `pais` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Esta tabela  uma excesso a regra do icms para um determina';

--
-- Dumping data for table `fiscicmspais`
--


/*!40000 ALTER TABLE `fiscicmspais` DISABLE KEYS */;
LOCK TABLES `fiscicmspais` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmspais` ENABLE KEYS */;

--
-- Table structure for table `fiscicmspessoa`
--

DROP TABLE IF EXISTS `fiscicmspessoa`;
CREATE TABLE `fiscicmspessoa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSRegra_Id` int(10) unsigned NOT NULL,
  `ModBCST_Id` int(10) unsigned default NULL,
  `ModBC_Id` int(10) unsigned default NULL,
  `MotDesoner_Id` int(10) unsigned default NULL,
  `CST_Id` int(10) unsigned NOT NULL,
  `Pessoa_Id` int(11) NOT NULL,
  `PercRedBC` float(4,2) default NULL,
  `PercICMS` float(4,2) default NULL,
  `PercMVAST` float(4,2) default NULL,
  `PercRedBCST` float(4,2) default NULL,
  `PercICMSST` float(4,2) default NULL,
  `PercBCOper` float(4,2) default NULL,
  `PercCredSN` float(4,2) default NULL,
  `PercDesconto` float(4,2) default NULL,
  `InfoCompl` varchar(80) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscICMSPessoa_FK_Pessoa` (`Pessoa_Id`),
  KEY `FiscICMSPessoa_FK_CST` (`CST_Id`),
  KEY `FiscICMSPessoa_FK_ICMSRegra` (`ICMSRegra_Id`),
  KEY `FiscICMSPessoa_FK_MotDesoner` (`MotDesoner_Id`),
  KEY `FiscICMSPessoa_FK_ModBC` (`ModBC_Id`),
  KEY `FiscICMSPessoa_FK_ModBCST` (`ModBCST_Id`),
  CONSTRAINT `CST_ICMSPessoa` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMSRegraDetalhe_ICMSPessoa` FOREIGN KEY (`ICMSRegra_Id`) REFERENCES `fiscicmsregra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBCST_ICMSPessoa` FOREIGN KEY (`ModBCST_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBC_ICMSPessoa` FOREIGN KEY (`ModBC_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `MotDesoner_ICMSPessoa` FOREIGN KEY (`MotDesoner_Id`) REFERENCES `fiscicmsmotdesoner` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Pessoa_ICMS` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmspessoa`
--


/*!40000 ALTER TABLE `fiscicmspessoa` DISABLE KEYS */;
LOCK TABLES `fiscicmspessoa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmspessoa` ENABLE KEYS */;

--
-- Table structure for table `fiscicmsregra`
--

DROP TABLE IF EXISTS `fiscicmsregra`;
CREATE TABLE `fiscicmsregra` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSGrupo_Id` int(10) unsigned NOT NULL,
  `ModBCST_Id` int(10) unsigned default NULL,
  `ModBC_Id` int(10) unsigned default NULL,
  `MotDesoner_Id` int(10) unsigned default NULL,
  `CST_Id` int(10) unsigned NOT NULL,
  `PercRedBC` float(4,2) default NULL,
  `PercICMS` float(4,2) default NULL,
  `PercMVAST` float(4,2) default NULL,
  `PercRedBCST` float(4,2) default NULL,
  `PercICMSST` float(4,2) default NULL,
  `PercBCOper` float(4,2) default NULL,
  `PercCredSN` float(4,2) default NULL,
  `PercDesconto` float(4,2) default NULL,
  `InfoCompl` varchar(80) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscICMSRegra_FK_ICMS` (`ICMSGrupo_Id`),
  KEY `FiscICMSRegra_FK_CST` (`CST_Id`),
  KEY `FiscICMSRegra_FK_MotDesoner` (`MotDesoner_Id`),
  KEY `FiscICMSRegra_FK_ModBC` (`ModBC_Id`),
  KEY `FiscICMSRegra_FK_ModBCST` (`ModBCST_Id`),
  CONSTRAINT `CST_ICMSRegra` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMS_RegraDetalhe` FOREIGN KEY (`ICMSGrupo_Id`) REFERENCES `fiscicmsgrupo` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBCST_ICMSRegra` FOREIGN KEY (`ModBCST_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBC_ICMSRegra` FOREIGN KEY (`ModBC_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `MotDesoner_ICMSRegra` FOREIGN KEY (`MotDesoner_Id`) REFERENCES `fiscicmsmotdesoner` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmsregra`
--


/*!40000 ALTER TABLE `fiscicmsregra` DISABLE KEYS */;
LOCK TABLES `fiscicmsregra` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmsregra` ENABLE KEYS */;

--
-- Table structure for table `fiscicmsregraloja`
--

DROP TABLE IF EXISTS `fiscicmsregraloja`;
CREATE TABLE `fiscicmsregraloja` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSRegra_Id` int(10) unsigned NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FiscICMSRegraLoja_LojaUnicaCadaRegra` (`Loja_Id`,`ICMSRegra_Id`),
  KEY `FiscICMSRegraLoja_FK_Regra` (`ICMSRegra_Id`),
  KEY `FiscICMSRegraLoja_FK_Loja` (`Loja_Id`),
  CONSTRAINT `ICMSRegra_Loja` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMSRegra_RegraLoja` FOREIGN KEY (`ICMSRegra_Id`) REFERENCES `fiscicmsregra` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmsregraloja`
--


/*!40000 ALTER TABLE `fiscicmsregraloja` DISABLE KEYS */;
LOCK TABLES `fiscicmsregraloja` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmsregraloja` ENABLE KEYS */;

--
-- Table structure for table `fiscicmsuf`
--

DROP TABLE IF EXISTS `fiscicmsuf`;
CREATE TABLE `fiscicmsuf` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ICMSRegra_Id` int(10) unsigned NOT NULL,
  `ModBCST_Id` int(10) unsigned default NULL,
  `ModBC_Id` int(10) unsigned default NULL,
  `MotDesoner_Id` int(10) unsigned default NULL,
  `CST_Id` int(10) unsigned NOT NULL,
  `UF_Id` int(11) NOT NULL,
  `PercRedBC` float(4,2) default NULL,
  `PercICMS` float(4,2) default NULL,
  `PercMVAST` float(4,2) default NULL,
  `PercRedBCST` float(4,2) default NULL,
  `PercICMSST` float(4,2) default NULL,
  `PercBCOper` float(4,2) default NULL,
  `PercCredSN` float(4,2) default NULL,
  `PercDesconto` float(4,2) default NULL,
  `InfoCompl` varchar(80) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscICMSUF_FK_UF` (`UF_Id`),
  KEY `FiscICMSUF_FK_CST` (`CST_Id`),
  KEY `FiscICMSUF_FK_ICMSRegra` (`ICMSRegra_Id`),
  KEY `FiscICMSUF_FK_MotDesoner` (`MotDesoner_Id`),
  KEY `FiscICMSUF_FK_ModBC` (`ModBC_Id`),
  KEY `FiscICMSUF_FK_ModBCST` (`ModBCST_Id`),
  CONSTRAINT `CS_ICMSUF` FOREIGN KEY (`CST_Id`) REFERENCES `cst` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ICMSRegraDetalhe_ICMSUF` FOREIGN KEY (`ICMSRegra_Id`) REFERENCES `fiscicmsregra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBCST_ICMSUF` FOREIGN KEY (`ModBCST_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `ModBC_ICMSUF` FOREIGN KEY (`ModBC_Id`) REFERENCES `fiscmodalidadebc` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `MotDesoner_ICMSUF` FOREIGN KEY (`MotDesoner_Id`) REFERENCES `fiscicmsmotdesoner` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `UF_ICMS` FOREIGN KEY (`UF_Id`) REFERENCES `uf` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fiscicmsuf`
--


/*!40000 ALTER TABLE `fiscicmsuf` DISABLE KEYS */;
LOCK TABLES `fiscicmsuf` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscicmsuf` ENABLE KEYS */;

--
-- Table structure for table `fiscmodalidadebc`
--

DROP TABLE IF EXISTS `fiscmodalidadebc`;
CREATE TABLE `fiscmodalidadebc` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` tinyint(3) unsigned default NULL,
  `Descricao` varchar(35) default NULL,
  `BCICMSNormal` tinyint(1) default NULL,
  `BCICMSST` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Modalidade de determinacao da BC do ICMS';

--
-- Dumping data for table `fiscmodalidadebc`
--


/*!40000 ALTER TABLE `fiscmodalidadebc` DISABLE KEYS */;
LOCK TABLES `fiscmodalidadebc` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fiscmodalidadebc` ENABLE KEYS */;

--
-- Table structure for table `fisctes`
--

DROP TABLE IF EXISTS `fisctes`;
CREATE TABLE `fisctes` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CFOPPadrao_Id` int(10) unsigned NOT NULL,
  `Descricao` varchar(40) NOT NULL,
  `Fluxo` enum('ENTRADA','SAIDA') NOT NULL,
  `Contexto` enum('Estadual','Nacional') NOT NULL,
  `NaturezaOperacao` varchar(50) NOT NULL,
  `ControlaEstoque` tinyint(1) NOT NULL default '0',
  `GeraFinanceiro` tinyint(1) NOT NULL default '0',
  `GeraComissao` tinyint(1) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscTES_FK_CFOP` (`CFOPPadrao_Id`),
  CONSTRAINT `FK_CFOP_TES` FOREIGN KEY (`CFOPPadrao_Id`) REFERENCES `fisccfop` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fisctes`
--


/*!40000 ALTER TABLE `fisctes` DISABLE KEYS */;
LOCK TABLES `fisctes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fisctes` ENABLE KEYS */;

--
-- Table structure for table `fisctescfop`
--

DROP TABLE IF EXISTS `fisctescfop`;
CREATE TABLE `fisctescfop` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CFOP_Id` int(10) unsigned NOT NULL,
  `TES_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FiscTESCFOP_FK_CFOP` (`CFOP_Id`),
  KEY `FiscTESCFOP_FK_TES` (`TES_Id`),
  CONSTRAINT `FK_CFOP_TESCFOP` FOREIGN KEY (`CFOP_Id`) REFERENCES `fisccfop` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TES_TESCFOP` FOREIGN KEY (`TES_Id`) REFERENCES `fisctes` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fisctescfop`
--


/*!40000 ALTER TABLE `fisctescfop` DISABLE KEYS */;
LOCK TABLES `fisctescfop` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fisctescfop` ENABLE KEYS */;

--
-- Table structure for table `fluxomercadoria`
--

DROP TABLE IF EXISTS `fluxomercadoria`;
CREATE TABLE `fluxomercadoria` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DataEmissao` date NOT NULL,
  `Fluxo` enum('ENTRADA','SAIDA') NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fluxomercadoria`
--


/*!40000 ALTER TABLE `fluxomercadoria` DISABLE KEYS */;
LOCK TABLES `fluxomercadoria` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fluxomercadoria` ENABLE KEYS */;

--
-- Table structure for table `fluxomercadoriaitem`
--

DROP TABLE IF EXISTS `fluxomercadoriaitem`;
CREATE TABLE `fluxomercadoriaitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `FluxoMercadoria_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FluxoMercadoriaItem_FK_FluxoMercadoria` (`FluxoMercadoria_Id`),
  KEY `FluxoMercadoriaItem_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_ProdutoGrade_FluxoMercadoriaItem` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FluxoMercadoria_FluxoMercadoriaItem` FOREIGN KEY (`FluxoMercadoria_Id`) REFERENCES `fluxomercadoria` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fluxomercadoriaitem`
--


/*!40000 ALTER TABLE `fluxomercadoriaitem` DISABLE KEYS */;
LOCK TABLES `fluxomercadoriaitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `fluxomercadoriaitem` ENABLE KEYS */;

--
-- Table structure for table `folhaadiantamentosalarial`
--

DROP TABLE IF EXISTS `folhaadiantamentosalarial`;
CREATE TABLE `folhaadiantamentosalarial` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FormaPagamento_Id` int(11) default NULL,
  `CentroCusto_Id` int(11) default NULL,
  `TipoGasto_Id` int(10) unsigned default NULL,
  `Caixa_Id` int(11) default NULL,
  `Pessoa_Id` int(11) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `MesBase` int(10) unsigned NOT NULL,
  `AnoBase` year(4) NOT NULL,
  `Semana` int(11) NOT NULL,
  `Obs` varchar(50) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaAdiantamentoSalarial_FK_Pessoa` (`Pessoa_Id`),
  KEY `FolhaAdiantamentoSalarial_FK_Caixa` (`Caixa_Id`),
  KEY `FolhaAdiantamentoSalarial_FK_TipoGasto` (`TipoGasto_Id`),
  KEY `FolhaAdiantamentoSalarial_FK_CentroCusto` (`CentroCusto_Id`),
  KEY `FolhaAdiantamentoSalarial_FKIndex5` (`FormaPagamento_Id`),
  CONSTRAINT `FK_Caixa_AdiantamentoSalarial` FOREIGN KEY (`Caixa_Id`) REFERENCES `caixa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CentroCusto_FolhaAdiantamento` FOREIGN KEY (`CentroCusto_Id`) REFERENCES `centrocusto` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_AdiantamentoSalarial` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_AdiantamentoSalarial` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoGasto_FolhaAdiantamento` FOREIGN KEY (`TipoGasto_Id`) REFERENCES `tipogasto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhaadiantamentosalarial`
--


/*!40000 ALTER TABLE `folhaadiantamentosalarial` DISABLE KEYS */;
LOCK TABLES `folhaadiantamentosalarial` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhaadiantamentosalarial` ENABLE KEYS */;

--
-- Table structure for table `folhadesconto`
--

DROP TABLE IF EXISTS `folhadesconto`;
CREATE TABLE `folhadesconto` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `TipoDesconto_Id` int(10) unsigned NOT NULL,
  `Pagamento_Id` int(10) unsigned NOT NULL,
  `Emissao` date NOT NULL,
  `Historico` varchar(40) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaDesconto_FK_Pagamento` (`Pagamento_Id`),
  KEY `FolhaDesconto_FK_TipoDesconto` (`TipoDesconto_Id`),
  CONSTRAINT `FK_Pagamento_Desconto` FOREIGN KEY (`Pagamento_Id`) REFERENCES `folhapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_TipoDesconto_FolhaDesconto` FOREIGN KEY (`TipoDesconto_Id`) REFERENCES `folhatipodesconto` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhadesconto`
--


/*!40000 ALTER TABLE `folhadesconto` DISABLE KEYS */;
LOCK TABLES `folhadesconto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhadesconto` ENABLE KEYS */;

--
-- Table structure for table `folhafaltas`
--

DROP TABLE IF EXISTS `folhafaltas`;
CREATE TABLE `folhafaltas` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Pessoa_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Valor` float(12,2) default NULL,
  `Obs` varchar(50) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaFaltas_FKIndex1` (`Pessoa_Id`),
  CONSTRAINT `FK_Pessoa_FolhaFalta` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhafaltas`
--


/*!40000 ALTER TABLE `folhafaltas` DISABLE KEYS */;
LOCK TABLES `folhafaltas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhafaltas` ENABLE KEYS */;

--
-- Table structure for table `folhamatricula`
--

DROP TABLE IF EXISTS `folhamatricula`;
CREATE TABLE `folhamatricula` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaFuncionario_Id` int(11) NOT NULL,
  `Admissao` date NOT NULL,
  `Diarista` tinyint(1) default '0',
  `Demissao` date default NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaMatricula_FK_Funcionario` (`PessoaFuncionario_Id`),
  CONSTRAINT `FK_PessoaFuncionario_Matricula` FOREIGN KEY (`PessoaFuncionario_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhamatricula`
--


/*!40000 ALTER TABLE `folhamatricula` DISABLE KEYS */;
LOCK TABLES `folhamatricula` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhamatricula` ENABLE KEYS */;

--
-- Table structure for table `folhapagamento`
--

DROP TABLE IF EXISTS `folhapagamento`;
CREATE TABLE `folhapagamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Salario_Id` int(10) unsigned NOT NULL,
  `ValorHoraExtra` float(12,2) default NULL,
  `Emissao` date default NULL,
  `MesBase` int(10) unsigned NOT NULL,
  `AnoBase` year(4) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaPagamento_FK_Salario` (`Salario_Id`),
  CONSTRAINT `FK_Salario_Pagamento` FOREIGN KEY (`Salario_Id`) REFERENCES `folhasalario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhapagamento`
--


/*!40000 ALTER TABLE `folhapagamento` DISABLE KEYS */;
LOCK TABLES `folhapagamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhapagamento` ENABLE KEYS */;

--
-- Table structure for table `folhasalario`
--

DROP TABLE IF EXISTS `folhasalario`;
CREATE TABLE `folhasalario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Matricula_Id` int(10) unsigned NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Vigencia` date NOT NULL,
  `Obs` varchar(50) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaSalario_FK_Matricula` (`Matricula_Id`),
  CONSTRAINT `FK_Matricula` FOREIGN KEY (`Matricula_Id`) REFERENCES `folhamatricula` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhasalario`
--


/*!40000 ALTER TABLE `folhasalario` DISABLE KEYS */;
LOCK TABLES `folhasalario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhasalario` ENABLE KEYS */;

--
-- Table structure for table `folhatipodesconto`
--

DROP TABLE IF EXISTS `folhatipodesconto`;
CREATE TABLE `folhatipodesconto` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Descricao` varchar(30) NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhatipodesconto`
--


/*!40000 ALTER TABLE `folhatipodesconto` DISABLE KEYS */;
LOCK TABLES `folhatipodesconto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhatipodesconto` ENABLE KEYS */;

--
-- Table structure for table `folhavencimentos`
--

DROP TABLE IF EXISTS `folhavencimentos`;
CREATE TABLE `folhavencimentos` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Pessoa_Id` int(11) NOT NULL,
  `MesBase` int(10) unsigned default NULL,
  `AnoBase` int(10) unsigned default NULL,
  `Emissao` date default NULL,
  `Valor` float(12,2) default NULL,
  `Obs` varchar(50) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FolhaVencimentos_FK_Pessoa` (`Pessoa_Id`),
  CONSTRAINT `FK_Pessoa_FolhaVencimentos` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `folhavencimentos`
--


/*!40000 ALTER TABLE `folhavencimentos` DISABLE KEYS */;
LOCK TABLES `folhavencimentos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `folhavencimentos` ENABLE KEYS */;

--
-- Table structure for table `formacaopreco`
--

DROP TABLE IF EXISTS `formacaopreco`;
CREATE TABLE `formacaopreco` (
  `CompraItens_Id` int(11) NOT NULL,
  `PercICMSEntrada` float(10,2) default NULL,
  `PercPISEntrada` float(10,2) default NULL,
  `PercCOFINSEntrada` float(10,2) default NULL,
  `CPPercentualIPI` float(10,2) default NULL,
  `CalcularIPI` tinyint(1) default NULL,
  `CPPercentualFreteEntrada` float(10,2) default NULL,
  `CalcularFreteEntrada` tinyint(1) default NULL,
  `CPPercentualSuframa` float(10,2) default NULL,
  `CalcularSuframa` tinyint(1) default NULL,
  `CPPercentualOutros` float(10,2) default NULL,
  `CalcularOutros` tinyint(1) default NULL,
  `CPPercentualCustoFixo` float(10,2) default NULL,
  `CalcularCustoFixo` tinyint(1) default NULL,
  `CPCustoParcial` float(12,2) default NULL,
  `CSPercentualICMS` float(10,2) default NULL,
  `CSPercentualIRPJ` float(10,2) default NULL,
  `CSPercentualPIS` float(10,2) default NULL,
  `CSPercentualCOFINS` float(10,2) default NULL,
  `CSPercentualContribSocial` float(10,2) default NULL,
  `CSPercentualFreteSaida` float(10,2) default NULL,
  `CSPercentualFreteSaidaAtacado` float(10,2) default NULL,
  `CalcularFreteSaida` tinyint(1) default NULL,
  `CalcularFreteSaidaAtacado` float(10,2) default NULL,
  `CSPercentualComissao` float(10,2) default NULL,
  `CSPercentualComissaoAtacado` float(10,2) default NULL,
  `CalcularComissao` tinyint(1) default NULL,
  `CalcularComissaoAtacado` tinyint(1) default NULL,
  `CSCustoTotal` float(10,2) default NULL,
  `CSCustoTotalAtacado` float(10,2) default NULL,
  `MargemLucro` float(10,2) default NULL,
  `ValorVenda` float(12,2) default NULL,
  `MargemContribuicao` float(10,2) default NULL,
  `ValorFrete` float(12,2) default NULL,
  `ValorST` float(12,2) default NULL,
  `AtacadoMargemContribuicao` float(10,2) default NULL,
  `ValorVendaAtacado` float(12,2) default NULL,
  `MargemLucroAtacado` float(12,3) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`CompraItens_Id`),
  KEY `FormacaoPreco_FKIndex1` (`CompraItens_Id`),
  CONSTRAINT `FK_CompraItens_FormacaoPreco` FOREIGN KEY (`CompraItens_Id`) REFERENCES `compraitens` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `formacaopreco`
--


/*!40000 ALTER TABLE `formacaopreco` DISABLE KEYS */;
LOCK TABLES `formacaopreco` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `formacaopreco` ENABLE KEYS */;

--
-- Table structure for table `formapagamento`
--

DROP TABLE IF EXISTS `formapagamento`;
CREATE TABLE `formapagamento` (
  `Id` int(11) NOT NULL auto_increment,
  `TemaDRE_Id` int(10) unsigned default NULL,
  `Loja_Id` int(11) default NULL,
  `Ordem` char(1) default NULL,
  `TipoFormas` enum('Dinheiro','Cheque a vista','Cheque pr-datado','Carto de crdito','Carto de dbito','Credirio','Outros','Pagamento Antecipado','Boleto') NOT NULL,
  `Descricao` varchar(30) NOT NULL,
  `DescricaoECF` varchar(16) default NULL,
  `CodigoContabil` varchar(10) default NULL,
  `PercentualComissao` float(10,2) default NULL,
  `Aviso` blob,
  `EntraNoFluxoCaixa` tinyint(1) default '0',
  `DescontoAutomatico` float(12,2) default NULL,
  `VerificarCredito` tinyint(1) default '0',
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `UsadoApenasFaturamento` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FormaPagamento_Descricao_Unica` (`Descricao`),
  KEY `FormaPagamento_FK_Loja` (`Loja_Id`),
  KEY `FormaPagamento_FK_TemaDRE` (`TemaDRE_Id`),
  CONSTRAINT `FK_TemaDRE_FormaPagamento` FOREIGN KEY (`TemaDRE_Id`) REFERENCES `temadre` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_FormaPagamento` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `formapagamento`
--


/*!40000 ALTER TABLE `formapagamento` DISABLE KEYS */;
LOCK TABLES `formapagamento` WRITE;
INSERT INTO `formapagamento` (`Id`, `TemaDRE_Id`, `Loja_Id`, `Ordem`, `TipoFormas`, `Descricao`, `DescricaoECF`, `CodigoContabil`, `PercentualComissao`, `Aviso`, `EntraNoFluxoCaixa`, `DescontoAutomatico`, `VerificarCredito`, `Usuario_Id`, `DataHoraGrav`, `UsadoApenasFaturamento`) VALUES (1,NULL,1,'A','Dinheiro','DINHEIRO','Dinheiro',NULL,NULL,'',0,NULL,0,1,'2009-08-19 00:44:42',NULL),(2,NULL,1,'B','Cheque a vista','CHEQUE A VISTA','Cheque',NULL,NULL,'',0,NULL,0,1,'2009-08-19 00:44:42',NULL),(3,NULL,1,'C','Cheque pr-datado','CHEQUE PR-DATADO','Cheque',NULL,NULL,'',1,NULL,1,1,'2009-08-19 00:44:42',NULL),(4,NULL,1,'Z','Carto de crdito','CARTO DE CRDITO','CARTAO',NULL,0.00,'',0,NULL,0,1,'2009-08-19 00:44:42',NULL),(6,NULL,1,'V','Carto de dbito','CARTO DE DBITO','CARTAO',NULL,NULL,'',0,NULL,0,1,'2009-08-19 00:44:42',NULL),(8,NULL,1,'Z','Credirio','DUPLICATA','A prazo',NULL,NULL,'',1,NULL,1,1,'2009-08-19 00:44:42',NULL),(10,NULL,1,'Z','Boleto','BOLETO BANCRIO','BOLETO',NULL,0.00,'',0,NULL,0,1,'2019-12-18 11:40:57',0),(11,NULL,1,'Z','Pagamento Antecipado','VALE PRESENTE','DINHEIRO',NULL,NULL,'',0,NULL,0,1,'2019-12-18 11:40:57',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `formapagamento` ENABLE KEYS */;

--
-- Table structure for table `formapagamentoconta`
--

DROP TABLE IF EXISTS `formapagamentoconta`;
CREATE TABLE `formapagamentoconta` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FormaPagamento_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Conta_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FormaPagamentoConta_FK_Conta` (`Conta_Id`),
  KEY `FormaPagamentoConta_FK_Loja` (`Loja_Id`),
  KEY `FormaPagamentoConta_FK_FormaPagamento` (`FormaPagamento_Id`),
  CONSTRAINT `FK_Conta_FormaPagamentoConta` FOREIGN KEY (`Conta_Id`) REFERENCES `conta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_FormaPagamentoConta` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_FormaPagamentoConta` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `formapagamentoconta`
--


/*!40000 ALTER TABLE `formapagamentoconta` DISABLE KEYS */;
LOCK TABLES `formapagamentoconta` WRITE;
INSERT INTO `formapagamentoconta` (`Id`, `FormaPagamento_Id`, `Loja_Id`, `Conta_Id`) VALUES (2,4,1,2),(4,6,1,2);
UNLOCK TABLES;
/*!40000 ALTER TABLE `formapagamentoconta` ENABLE KEYS */;

--
-- Table structure for table `formapagamentoplano`
--

DROP TABLE IF EXISTS `formapagamentoplano`;
CREATE TABLE `formapagamentoplano` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `PlanoPagamento_Id` int(11) NOT NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `PercentualDespesa` float(12,2) NOT NULL default '0.00',
  PRIMARY KEY  (`Id`),
  KEY `FormaPagamentoPlano_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `FormaPagamentoPlano_FK_PlanoPagamento` (`PlanoPagamento_Id`),
  KEY `FormaPagamentoPlano_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_FormaPagamento_Loja` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_Plano` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FormaPagamento_PlanoPagamento` FOREIGN KEY (`PlanoPagamento_Id`) REFERENCES `planopagamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `formapagamentoplano`
--


/*!40000 ALTER TABLE `formapagamentoplano` DISABLE KEYS */;
LOCK TABLES `formapagamentoplano` WRITE;
INSERT INTO `formapagamentoplano` (`Id`, `Loja_Id`, `PlanoPagamento_Id`, `FormaPagamento_Id`, `PercentualDespesa`) VALUES (11,1,2,4,0.00),(12,1,3,4,0.00),(13,1,4,4,0.00),(14,1,5,4,0.00),(15,1,6,4,0.00),(16,1,7,4,0.00),(17,1,8,4,0.00),(18,1,9,4,0.00),(20,1,11,4,0.00),(22,1,1,6,0.00),(23,1,1,2,0.00),(24,1,2,3,0.00),(25,1,3,3,0.00),(26,1,4,3,0.00),(27,1,5,3,0.00),(28,1,6,3,0.00),(29,1,7,3,0.00),(30,1,8,3,0.00),(31,1,9,3,0.00),(32,1,10,3,0.00),(33,1,11,3,0.00),(34,1,1,1,0.00),(35,1,2,8,0.00),(36,1,3,8,0.00),(37,1,4,8,0.00),(38,1,5,8,0.00),(39,1,6,8,0.00),(40,1,7,8,0.00),(41,1,8,8,0.00),(42,1,9,8,0.00),(43,1,10,8,0.00),(44,1,11,8,0.00),(45,1,2,10,0.00),(46,1,3,10,0.00),(47,1,4,10,0.00),(48,1,1,11,0.00);
UNLOCK TABLES;
/*!40000 ALTER TABLE `formapagamentoplano` ENABLE KEYS */;

--
-- Table structure for table `formulario`
--

DROP TABLE IF EXISTS `formulario`;
CREATE TABLE `formulario` (
  `Id` int(11) NOT NULL auto_increment,
  `ModeloFormulario_Id` int(11) NOT NULL,
  `Sequencia` int(11) default NULL,
  `Atributo` varchar(35) default NULL,
  `TipoAtributo` enum('Texto','Inteiro','Lgico','Data','Flutuante','Valor','Valor Extenso','Mes Extenso','Data Extenso','Percentual') default NULL,
  `Linha` int(11) default NULL,
  `Coluna` int(11) default NULL,
  `Fonte` varchar(40) default NULL,
  `Letra` varchar(40) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Formulario_FKIndex1` (`ModeloFormulario_Id`),
  CONSTRAINT `FK_ModeloFormulario_Formulario` FOREIGN KEY (`ModeloFormulario_Id`) REFERENCES `modeloformulario` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `formulario`
--


/*!40000 ALTER TABLE `formulario` DISABLE KEYS */;
LOCK TABLES `formulario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `formulario` ENABLE KEYS */;

--
-- Table structure for table `frigorabate`
--

DROP TABLE IF EXISTS `frigorabate`;
CREATE TABLE `frigorabate` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DataInicialAbate` date NOT NULL,
  `HoraInicialAbate` time NOT NULL,
  `DataFinalAbate` date default NULL,
  `HoraFinalAbate` time default NULL,
  `Estagio` enum('Pendente','Em andamento','Concludo') default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FrigorAbate_DataInicialAbate` (`DataInicialAbate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorabate`
--


/*!40000 ALTER TABLE `frigorabate` DISABLE KEYS */;
LOCK TABLES `frigorabate` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorabate` ENABLE KEYS */;

--
-- Table structure for table `frigorabatelote`
--

DROP TABLE IF EXISTS `frigorabatelote`;
CREATE TABLE `frigorabatelote` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FrigorAbate_Id` int(10) unsigned NOT NULL,
  `FrigorPedidoCompra_Id` int(10) unsigned NOT NULL,
  `NumeroLote` char(2) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FrigorAbateLote_FK_PedidoCompra` (`FrigorPedidoCompra_Id`),
  KEY `FrigorAbateLote_FK_Abate` (`FrigorAbate_Id`),
  CONSTRAINT `FK_FrigorAbate_AbateLote` FOREIGN KEY (`FrigorAbate_Id`) REFERENCES `frigorabate` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_FrigorPedidoCompra_AbateLote` FOREIGN KEY (`FrigorPedidoCompra_Id`) REFERENCES `frigorpedidocompra` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorabatelote`
--


/*!40000 ALTER TABLE `frigorabatelote` DISABLE KEYS */;
LOCK TABLES `frigorabatelote` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorabatelote` ENABLE KEYS */;

--
-- Table structure for table `frigorabatepesagem`
--

DROP TABLE IF EXISTS `frigorabatepesagem`;
CREATE TABLE `frigorabatepesagem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FrigorAnimalClassificacao_Id` int(10) unsigned NOT NULL,
  `FrigorAnimalClassificacaoPeso_Id` int(10) unsigned default NULL,
  `FrigorPedidoCompraItem_Id` int(10) unsigned NOT NULL,
  `Sequencia` int(10) unsigned NOT NULL,
  `BandaA` float(7,3) NOT NULL,
  `BandaB` float(7,3) NOT NULL,
  `Contusao` tinyint(1) NOT NULL default '0',
  `Mutilacao` tinyint(1) default '0',
  `Qualidade` enum('COM COBERTURA','SEM COBERTURA') default NULL,
  `Destino` enum('NORMAL','CONSERVA','GRAXARIA') default NULL,
  `ValorArroba` float(12,2) default NULL,
  `ValorTotal` float(12,2) default NULL,
  `DataHoraGrav` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Situacao` enum('NORMAL','CANCELADO') default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FrigorAbatePesagem_SequenciaUnica` (`FrigorPedidoCompraItem_Id`,`Sequencia`),
  KEY `FrigorAbatePesagem_FK_CompraItem` (`FrigorPedidoCompraItem_Id`),
  KEY `FrigorAbatePesagem_FK_ClassificacaoPeso` (`FrigorAnimalClassificacaoPeso_Id`),
  KEY `FrigorAbatePesagem_FK_Classificacao` (`FrigorAnimalClassificacao_Id`),
  CONSTRAINT `FK_ClassificacaoPeso_Pesagem` FOREIGN KEY (`FrigorAnimalClassificacaoPeso_Id`) REFERENCES `frigoranimalclassificacaopeso` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Classificacao_Pesagem` FOREIGN KEY (`FrigorAnimalClassificacao_Id`) REFERENCES `frigoranimalclassificacao` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Rel_656` FOREIGN KEY (`FrigorPedidoCompraItem_Id`) REFERENCES `frigorpedidocompraitem` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorabatepesagem`
--


/*!40000 ALTER TABLE `frigorabatepesagem` DISABLE KEYS */;
LOCK TABLES `frigorabatepesagem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorabatepesagem` ENABLE KEYS */;

--
-- Table structure for table `frigoranimal`
--

DROP TABLE IF EXISTS `frigoranimal`;
CREATE TABLE `frigoranimal` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Nome` varchar(25) default NULL,
  `Sexo` enum('Macho','Fmea') default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FrigorAnimal_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_ProdutoGrade_Animal` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Este cadastro foi feito somente para diferenciar o sexo do a';

--
-- Dumping data for table `frigoranimal`
--


/*!40000 ALTER TABLE `frigoranimal` DISABLE KEYS */;
LOCK TABLES `frigoranimal` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigoranimal` ENABLE KEYS */;

--
-- Table structure for table `frigoranimalclassificacao`
--

DROP TABLE IF EXISTS `frigoranimalclassificacao`;
CREATE TABLE `frigoranimalclassificacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Classificacao` char(1) default NULL,
  `Descricao` varchar(25) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigoranimalclassificacao`
--


/*!40000 ALTER TABLE `frigoranimalclassificacao` DISABLE KEYS */;
LOCK TABLES `frigoranimalclassificacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigoranimalclassificacao` ENABLE KEYS */;

--
-- Table structure for table `frigoranimalclassificacaopeso`
--

DROP TABLE IF EXISTS `frigoranimalclassificacaopeso`;
CREATE TABLE `frigoranimalclassificacaopeso` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `FrigorAnimalClassificacao_Id` int(10) unsigned NOT NULL,
  `KgMinimo` float(7,3) default NULL,
  `KgMaximo` float(7,3) default NULL,
  `PercentualValor` float(7,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FrigorAnimalClassificacaoPeso_FK_Classificacao` (`FrigorAnimalClassificacao_Id`),
  KEY `FrigorAnimalClassificacaoPeso_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_FrigorAnimalClassificacao_Peso` FOREIGN KEY (`FrigorAnimalClassificacao_Id`) REFERENCES `frigoranimalclassificacao` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_ClassificacaoPeso` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigoranimalclassificacaopeso`
--


/*!40000 ALTER TABLE `frigoranimalclassificacaopeso` DISABLE KEYS */;
LOCK TABLES `frigoranimalclassificacaopeso` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigoranimalclassificacaopeso` ENABLE KEYS */;

--
-- Table structure for table `frigorpedidocompra`
--

DROP TABLE IF EXISTS `frigorpedidocompra`;
CREATE TABLE `frigorpedidocompra` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `FormaPagamento_Id` int(11) NOT NULL,
  `PlanoPagamento_Id` int(11) NOT NULL,
  `PessoaPecuarista_Id` int(11) NOT NULL,
  `FrigorPropriedadeRural_Id` int(10) unsigned NOT NULL,
  `Compra_Id` int(10) unsigned default NULL,
  `DataEmissao` date default NULL,
  `DataEmbarque` date default NULL,
  `DataAbate` date default NULL,
  `DataDeposito` date default NULL,
  `ValorFrete` float(12,2) default NULL,
  `QtdCaminhao` tinyint(3) unsigned default NULL,
  `QtdCabecas` int(10) unsigned default NULL,
  `Obs` text,
  `Estagio` enum('Pendente','Confirmado','Cancelado') default NULL,
  `NumeroGTA` varchar(10) default NULL,
  `NFProdutor` varchar(10) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `FrigorPedidoCompra_FK_PropriedadeRural` (`FrigorPropriedadeRural_Id`),
  KEY `FrigorPedidoCompra_FK_Pecuarista` (`PessoaPecuarista_Id`),
  KEY `FrigorPedidoCompra_FK_PlanoPamento` (`PlanoPagamento_Id`),
  KEY `FrigorPedidoCompra_FK_FormaPagamento` (`FormaPagamento_Id`),
  CONSTRAINT `FK_FormaPagamento_FrigorPedidoCompra` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_FrigorPedidoCompra` FOREIGN KEY (`PessoaPecuarista_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PlanoPagamento_FrigorPedidoCompra` FOREIGN KEY (`PlanoPagamento_Id`) REFERENCES `planopagamento` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_PropriedadeRural_PedidoCompra` FOREIGN KEY (`FrigorPropriedadeRural_Id`) REFERENCES `frigorpropriedaderural` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorpedidocompra`
--


/*!40000 ALTER TABLE `frigorpedidocompra` DISABLE KEYS */;
LOCK TABLES `frigorpedidocompra` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorpedidocompra` ENABLE KEYS */;

--
-- Table structure for table `frigorpedidocompraitem`
--

DROP TABLE IF EXISTS `frigorpedidocompraitem`;
CREATE TABLE `frigorpedidocompraitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `FrigorPedidoCompra_Id` int(10) unsigned NOT NULL,
  `Quantidade` float(7,3) NOT NULL,
  `ValorArroba` float(12,2) default NULL,
  `Pesagem` enum('Pendente','Iniciada','Finalizada','Cancelada') NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `FrigorPedidoCompraItem_ProdutoUnico` (`FrigorPedidoCompra_Id`,`ProdutoGrade_Id`),
  KEY `FrigorPedidoCompraItem_FK_PedidoCompra` (`FrigorPedidoCompra_Id`),
  KEY `FrigorPedidoCompraItem_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_FrigorPedidoCompra_PedidoCompraItem` FOREIGN KEY (`FrigorPedidoCompra_Id`) REFERENCES `frigorpedidocompra` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_FrigorCompraItem` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorpedidocompraitem`
--


/*!40000 ALTER TABLE `frigorpedidocompraitem` DISABLE KEYS */;
LOCK TABLES `frigorpedidocompraitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorpedidocompraitem` ENABLE KEYS */;

--
-- Table structure for table `frigorprecoprodutor`
--

DROP TABLE IF EXISTS `frigorprecoprodutor`;
CREATE TABLE `frigorprecoprodutor` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaProdutor_Id` int(11) NOT NULL,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `DataVigencia` date NOT NULL,
  `ValorArroba` float(12,2) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `FrigorPrecoProdutor_FK_PessoaProdutor` (`PessoaProdutor_Id`),
  KEY `FrigorPrecoProdutor_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_Pessoa_FrigorPrecoProdutor` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_FrigorPrecoProdutor` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorprecoprodutor`
--


/*!40000 ALTER TABLE `frigorprecoprodutor` DISABLE KEYS */;
LOCK TABLES `frigorprecoprodutor` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorprecoprodutor` ENABLE KEYS */;

--
-- Table structure for table `frigorpropriedaderural`
--

DROP TABLE IF EXISTS `frigorpropriedaderural`;
CREATE TABLE `frigorpropriedaderural` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Cidade_Id` int(11) NOT NULL,
  `PessoaProprietario_Id` int(11) NOT NULL,
  `Nome` varchar(35) default NULL,
  `Endereco` varchar(50) default NULL,
  `ComplementoEndereco` varchar(50) default NULL,
  `KmAsfalto` int(10) unsigned default NULL,
  `KmNaoPavimentado` int(10) unsigned default NULL,
  `Obs` text,
  PRIMARY KEY  (`Id`),
  KEY `FrigorPropriedadeRural_FK_Proprietario` (`PessoaProprietario_Id`),
  KEY `FrigorPropriedadeRural_FK_Cidade` (`Cidade_Id`),
  CONSTRAINT `FK_Cidade_PropriedadeRural` FOREIGN KEY (`Cidade_Id`) REFERENCES `cidade` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_PropriedadeRural` FOREIGN KEY (`PessoaProprietario_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `frigorpropriedaderural`
--


/*!40000 ALTER TABLE `frigorpropriedaderural` DISABLE KEYS */;
LOCK TABLES `frigorpropriedaderural` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `frigorpropriedaderural` ENABLE KEYS */;

--
-- Table structure for table `historico`
--

DROP TABLE IF EXISTS `historico`;
CREATE TABLE `historico` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Tabela` varchar(30) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  `Operacao` varchar(30) default NULL,
  `Motivo` varchar(250) default NULL,
  `Loja_Id` int(10) unsigned default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataGrav` date default NULL,
  `HoraGrav` time default NULL,
  `Registro` text,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `historico`
--


/*!40000 ALTER TABLE `historico` DISABLE KEYS */;
LOCK TABLES `historico` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `historico` ENABLE KEYS */;

--
-- Table structure for table `ibptax`
--

DROP TABLE IF EXISTS `ibptax`;
CREATE TABLE `ibptax` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `CodigoNCM` varchar(8) NOT NULL,
  `Ex` char(2) default NULL,
  `Tabela` char(1) default NULL,
  `Descricao` varchar(255) default NULL,
  `AliquotaNacional` float(12,2) default NULL,
  `AliquotaImportado` float(12,2) default NULL,
  `Versao` varchar(8) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ibptax`
--


/*!40000 ALTER TABLE `ibptax` DISABLE KEYS */;
LOCK TABLES `ibptax` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `ibptax` ENABLE KEYS */;

--
-- Table structure for table `icmsaliquota`
--

DROP TABLE IF EXISTS `icmsaliquota`;
CREATE TABLE `icmsaliquota` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `UF_Origem` varchar(2) default NULL,
  `UF_Destino` varchar(2) default NULL,
  `Aliquota` float(12,2) default NULL,
  `Processo_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `icmsaliquota`
--


/*!40000 ALTER TABLE `icmsaliquota` DISABLE KEYS */;
LOCK TABLES `icmsaliquota` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `icmsaliquota` ENABLE KEYS */;

--
-- Table structure for table `indicados`
--

DROP TABLE IF EXISTS `indicados`;
CREATE TABLE `indicados` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaIndicado_Id` int(11) NOT NULL,
  `PessoaCliente_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `ImprimiuDeclaracao` tinyint(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Indicados_FK_Cliente` (`PessoaCliente_Id`),
  KEY `Indicados_FK_Indicado` (`PessoaIndicado_Id`),
  CONSTRAINT `FK_PessoaCliente_Indicado` FOREIGN KEY (`PessoaCliente_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_Indicados` FOREIGN KEY (`PessoaIndicado_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `indicados`
--


/*!40000 ALTER TABLE `indicados` DISABLE KEYS */;
LOCK TABLES `indicados` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `indicados` ENABLE KEYS */;

--
-- Table structure for table `inventario`
--

DROP TABLE IF EXISTS `inventario`;
CREATE TABLE `inventario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LojaEstoque_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Situacao` enum('Pendente','Concluido') default NULL,
  `Descricao` varchar(30) default NULL,
  `Emissao` date default NULL,
  `Obs` text,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Inventario_FK_Loja` (`Loja_Id`),
  KEY `Inventario_FK_LojaEstoque` (`LojaEstoque_Id`),
  CONSTRAINT `LojaEstoque_Inventario` FOREIGN KEY (`LojaEstoque_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Loja_Inventario` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `inventario`
--


/*!40000 ALTER TABLE `inventario` DISABLE KEYS */;
LOCK TABLES `inventario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `inventario` ENABLE KEYS */;

--
-- Table structure for table `itemdevolvido`
--

DROP TABLE IF EXISTS `itemdevolvido`;
CREATE TABLE `itemdevolvido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ReferenteVenda_Id` int(11) default NULL,
  `Loja_Id` int(11) NOT NULL,
  `LojaEntradaEstoque_Id` int(11) NOT NULL,
  `SubstituiMercadoria_Id` int(10) unsigned NOT NULL,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `ValorVenda` float(12,2) default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `Quantidade` float(7,3) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ItemDevolvido_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  KEY `ItemDevolvido_FK_SubstituiMercadoria` (`SubstituiMercadoria_Id`),
  KEY `ItemDevolvido_FK_LojaEntradaEstoque` (`LojaEntradaEstoque_Id`),
  KEY `ItemDevolvido_FK_Loja` (`Loja_Id`),
  KEY `ItemDevolvido_FK_Venda` (`ReferenteVenda_Id`),
  CONSTRAINT `FK_LojaEntradaEstoque_ItemDevolvido` FOREIGN KEY (`LojaEntradaEstoque_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ItemDevolvido` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_ItemDevolvido` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_SubstituiMercadoria_ItemDevolvido` FOREIGN KEY (`SubstituiMercadoria_Id`) REFERENCES `substituimercadoria` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Venda_ItemDevolvido` FOREIGN KEY (`ReferenteVenda_Id`) REFERENCES `venda` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemdevolvido`
--


/*!40000 ALTER TABLE `itemdevolvido` DISABLE KEYS */;
LOCK TABLES `itemdevolvido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `itemdevolvido` ENABLE KEYS */;

--
-- Table structure for table `itemsubstituido`
--

DROP TABLE IF EXISTS `itemsubstituido`;
CREATE TABLE `itemsubstituido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `LojaSaidaEstoque_Id` int(11) NOT NULL,
  `SubstituiMercadoria_Id` int(10) unsigned NOT NULL,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `NumeroOrdem` int(10) unsigned default NULL,
  `Quantidade` float(7,3) default NULL,
  `ValorVenda` float(12,2) default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `ItemSubstituido_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  KEY `ItemSubstituido_FK_SubstituiMercadoria` (`SubstituiMercadoria_Id`),
  KEY `ItemSubstituido_FK_LojaSaidaEstoque` (`LojaSaidaEstoque_Id`),
  KEY `ItemSubstituido_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_LojaSaidaEstoque_ItemSubstituido` FOREIGN KEY (`LojaSaidaEstoque_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_ItemSubstituido` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_ItemSubstituido` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_SubstituiMercadoria_ItemSubstituido` FOREIGN KEY (`SubstituiMercadoria_Id`) REFERENCES `substituimercadoria` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `itemsubstituido`
--


/*!40000 ALTER TABLE `itemsubstituido` DISABLE KEYS */;
LOCK TABLES `itemsubstituido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `itemsubstituido` ENABLE KEYS */;

--
-- Table structure for table `lanabertura`
--

DROP TABLE IF EXISTS `lanabertura`;
CREATE TABLE `lanabertura` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaVendedor_Id` int(11) NOT NULL,
  `ControleMesa_Id` int(10) unsigned NOT NULL,
  `Mesa_Id` int(10) unsigned NOT NULL,
  `NumeroPessoas` int(10) unsigned default NULL,
  `DataOperacao` date default NULL,
  `HoraOperacao` time default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LanAbertura_FK_Mesa` (`Mesa_Id`),
  KEY `LanAbertura_FK_ControleMesa` (`ControleMesa_Id`),
  KEY `LanAbertura_FK_Vendedor` (`PessoaVendedor_Id`),
  CONSTRAINT `FK_Abertura_PessoaVendedor` FOREIGN KEY (`PessoaVendedor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_CadMesa` FOREIGN KEY (`Mesa_Id`) REFERENCES `lancadmesa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ControleMesa_Abertura` FOREIGN KEY (`ControleMesa_Id`) REFERENCES `lancontrolemesa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lanabertura`
--


/*!40000 ALTER TABLE `lanabertura` DISABLE KEYS */;
LOCK TABLES `lanabertura` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lanabertura` ENABLE KEYS */;

--
-- Table structure for table `lancadmesa`
--

DROP TABLE IF EXISTS `lancadmesa`;
CREATE TABLE `lancadmesa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Codigo` varchar(3) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `LanCadMesa_Unico` (`Codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lancadmesa`
--


/*!40000 ALTER TABLE `lancadmesa` DISABLE KEYS */;
LOCK TABLES `lancadmesa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lancadmesa` ENABLE KEYS */;

--
-- Table structure for table `lancadturno`
--

DROP TABLE IF EXISTS `lancadturno`;
CREATE TABLE `lancadturno` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Descricao` varchar(30) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lancadturno`
--


/*!40000 ALTER TABLE `lancadturno` DISABLE KEYS */;
LOCK TABLES `lancadturno` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lancadturno` ENABLE KEYS */;

--
-- Table structure for table `lancontrolemesa`
--

DROP TABLE IF EXISTS `lancontrolemesa`;
CREATE TABLE `lancontrolemesa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Turno_Id` int(10) unsigned NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Fechamento` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LanControleMesa_FK_Loja` (`Loja_Id`),
  KEY `LanControleMesa_FK_Turno` (`Turno_Id`),
  CONSTRAINT `FK_ControleMesa_Loja` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Turno_ControleMesa` FOREIGN KEY (`Turno_Id`) REFERENCES `lancadturno` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lancontrolemesa`
--


/*!40000 ALTER TABLE `lancontrolemesa` DISABLE KEYS */;
LOCK TABLES `lancontrolemesa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lancontrolemesa` ENABLE KEYS */;

--
-- Table structure for table `lanfechamento`
--

DROP TABLE IF EXISTS `lanfechamento`;
CREATE TABLE `lanfechamento` (
  `Id` int(10) unsigned NOT NULL,
  `Abertura_Id` int(10) unsigned NOT NULL,
  `FormaPagamento_Id` int(11) NOT NULL,
  `ValorComissaoVendedor` float(12,2) default NULL,
  `ValorAcrescimo` float(12,2) default NULL,
  `ValorDesconto` float(12,2) default NULL,
  `ValorRecebido` float(12,2) default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LanFechamento_FK_FormaPagamento` (`FormaPagamento_Id`),
  KEY `LanFechamento_FK_Abertura` (`Abertura_Id`),
  CONSTRAINT `FK_Abertura_Fechamento` FOREIGN KEY (`Abertura_Id`) REFERENCES `lanabertura` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Rel_206` FOREIGN KEY (`FormaPagamento_Id`) REFERENCES `formapagamento` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lanfechamento`
--


/*!40000 ALTER TABLE `lanfechamento` DISABLE KEYS */;
LOCK TABLES `lanfechamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lanfechamento` ENABLE KEYS */;

--
-- Table structure for table `lanhistoricotransfpedido`
--

DROP TABLE IF EXISTS `lanhistoricotransfpedido`;
CREATE TABLE `lanhistoricotransfpedido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LanAbertura_Id` int(10) unsigned NOT NULL,
  `LanPedido_Id` int(10) unsigned NOT NULL,
  `DataOperacao` date default NULL,
  `HoraOperacao` time default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LanHistoricoTransfPedido_FK_Pedido` (`LanPedido_Id`),
  KEY `LanHistoricoTransfPedido_FK_Abertura` (`LanAbertura_Id`),
  CONSTRAINT `FK_Abertura_Transferencia` FOREIGN KEY (`LanAbertura_Id`) REFERENCES `lanabertura` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pedido_Transferencia` FOREIGN KEY (`LanPedido_Id`) REFERENCES `lanpedido` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lanhistoricotransfpedido`
--


/*!40000 ALTER TABLE `lanhistoricotransfpedido` DISABLE KEYS */;
LOCK TABLES `lanhistoricotransfpedido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lanhistoricotransfpedido` ENABLE KEYS */;

--
-- Table structure for table `lanpedido`
--

DROP TABLE IF EXISTS `lanpedido`;
CREATE TABLE `lanpedido` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Abertura_Id` int(10) unsigned NOT NULL,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Quantidade` float(7,3) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `Complemento` varchar(20) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LanPedido_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  KEY `LanPedido_FK_Abertura` (`Abertura_Id`),
  CONSTRAINT `FK_Abertura_Pedido` FOREIGN KEY (`Abertura_Id`) REFERENCES `lanabertura` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Rel_204` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lanpedido`
--


/*!40000 ALTER TABLE `lanpedido` DISABLE KEYS */;
LOCK TABLES `lanpedido` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lanpedido` ENABLE KEYS */;

--
-- Table structure for table `leiteassociacao`
--

DROP TABLE IF EXISTS `leiteassociacao`;
CREATE TABLE `leiteassociacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Pessoa_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteAssociacao_FK_Pessoa` (`Pessoa_Id`),
  KEY `LeiteAssociacao_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_ProdutoGrade_Associacao` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Rel_668` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leiteassociacao`
--


/*!40000 ALTER TABLE `leiteassociacao` DISABLE KEYS */;
LOCK TABLES `leiteassociacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leiteassociacao` ENABLE KEYS */;

--
-- Table structure for table `leiteassociacaobonificacao`
--

DROP TABLE IF EXISTS `leiteassociacaobonificacao`;
CREATE TABLE `leiteassociacaobonificacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `Pessoa_Id` int(11) NOT NULL,
  `TotalLitros` float(12,3) NOT NULL,
  `ValorUnitario` float(12,2) NOT NULL,
  `ValorTotal` float(12,2) NOT NULL,
  `DataInicial` date NOT NULL,
  `DataFinal` date NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteAssociacaoBonificacao_FK_Pessoa` (`Pessoa_Id`),
  KEY `LeiteAssociacaoBonificacao_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_Pessoa_Bonificacao` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ProdutoGrade_AssociacaoBonificacao` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leiteassociacaobonificacao`
--


/*!40000 ALTER TABLE `leiteassociacaobonificacao` DISABLE KEYS */;
LOCK TABLES `leiteassociacaobonificacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leiteassociacaobonificacao` ENABLE KEYS */;

--
-- Table structure for table `leiteassociacaoitem`
--

DROP TABLE IF EXISTS `leiteassociacaoitem`;
CREATE TABLE `leiteassociacaoitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Pessoa_Id` int(11) NOT NULL,
  `LeiteAssociacao_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteAssociacaoItem_FK_Associacao` (`LeiteAssociacao_Id`),
  KEY `LeiteAssociacaoItem_FK_Pessoa` (`Pessoa_Id`),
  CONSTRAINT `FK_Associacao_Item` FOREIGN KEY (`LeiteAssociacao_Id`) REFERENCES `leiteassociacao` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_AssociacaoItem` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leiteassociacaoitem`
--


/*!40000 ALTER TABLE `leiteassociacaoitem` DISABLE KEYS */;
LOCK TABLES `leiteassociacaoitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leiteassociacaoitem` ENABLE KEYS */;

--
-- Table structure for table `leitecoleta`
--

DROP TABLE IF EXISTS `leitecoleta`;
CREATE TABLE `leitecoleta` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `ProdutoLinha_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `TotalLitros` float(10,2) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  `Confirmado` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteColeta_FK_Linha` (`ProdutoLinha_Id`),
  KEY `LeiteColeta_FK_Loja` (`Loja_Id`),
  KEY `LeiteColeta_DataEmissao` (`Emissao`),
  CONSTRAINT `FK_Linha_Coleta` FOREIGN KEY (`ProdutoLinha_Id`) REFERENCES `produtolinha` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_Coleta` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitecoleta`
--


/*!40000 ALTER TABLE `leitecoleta` DISABLE KEYS */;
LOCK TABLES `leitecoleta` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitecoleta` ENABLE KEYS */;

--
-- Table structure for table `leitecoletaitem`
--

DROP TABLE IF EXISTS `leitecoletaitem`;
CREATE TABLE `leitecoletaitem` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaProdutor_Id` int(11) NOT NULL,
  `LeiteColeta_Id` int(10) unsigned NOT NULL,
  `QuantidadeLitros` float(10,2) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteColetaItem_FK_LeiteColeta` (`LeiteColeta_Id`),
  KEY `LeiteColetaItem_FK_Produtor` (`PessoaProdutor_Id`),
  CONSTRAINT `FK_LeiteColeta_Item` FOREIGN KEY (`LeiteColeta_Id`) REFERENCES `leitecoleta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_Produtor` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitecoletaitem`
--


/*!40000 ALTER TABLE `leitecoletaitem` DISABLE KEYS */;
LOCK TABLES `leitecoletaitem` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitecoletaitem` ENABLE KEYS */;

--
-- Table structure for table `leitefretedesconto`
--

DROP TABLE IF EXISTS `leitefretedesconto`;
CREATE TABLE `leitefretedesconto` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaProdutor_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteFreteDesconto_FKIndex1` (`PessoaProdutor_Id`),
  CONSTRAINT `FK_Pessoa_LeiteFreteDesconto` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitefretedesconto`
--


/*!40000 ALTER TABLE `leitefretedesconto` DISABLE KEYS */;
LOCK TABLES `leitefretedesconto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitefretedesconto` ENABLE KEYS */;

--
-- Table structure for table `leitelinhadesc`
--

DROP TABLE IF EXISTS `leitelinhadesc`;
CREATE TABLE `leitelinhadesc` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoLinha_Id` int(11) NOT NULL,
  `Valor` float(10,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteLinhaDesc_FK_Linha` (`ProdutoLinha_Id`),
  CONSTRAINT `FK_Linha_Desc` FOREIGN KEY (`ProdutoLinha_Id`) REFERENCES `produtolinha` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitelinhadesc`
--


/*!40000 ALTER TABLE `leitelinhadesc` DISABLE KEYS */;
LOCK TABLES `leitelinhadesc` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitelinhadesc` ENABLE KEYS */;

--
-- Table structure for table `leiteprodutorbanco`
--

DROP TABLE IF EXISTS `leiteprodutorbanco`;
CREATE TABLE `leiteprodutorbanco` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Banco_Id` int(11) NOT NULL,
  `PessoaProdutor_Id` int(11) NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `LeiteProdutorBanco_Unico` (`PessoaProdutor_Id`),
  KEY `LeiteProdutorBanco_FK_Pessoa` (`PessoaProdutor_Id`),
  KEY `LeiteProdutorBanco_FK_Banco` (`Banco_Id`),
  CONSTRAINT `Banco_LeiteProdutorBanco` FOREIGN KEY (`Banco_Id`) REFERENCES `banco` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `Pessoa_LeiteProdutorBanco` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leiteprodutorbanco`
--


/*!40000 ALTER TABLE `leiteprodutorbanco` DISABLE KEYS */;
LOCK TABLES `leiteprodutorbanco` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leiteprodutorbanco` ENABLE KEYS */;

--
-- Table structure for table `leitetanquedesconto`
--

DROP TABLE IF EXISTS `leitetanquedesconto`;
CREATE TABLE `leitetanquedesconto` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaProdutor_Id` int(11) NOT NULL,
  `Emissao` date NOT NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LeiteColetaTanqueDesconto_FK_PessoaProdutor` (`PessoaProdutor_Id`),
  CONSTRAINT `FK_Pessoa_TanqueDesconto` FOREIGN KEY (`PessoaProdutor_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitetanquedesconto`
--


/*!40000 ALTER TABLE `leitetanquedesconto` DISABLE KEYS */;
LOCK TABLES `leitetanquedesconto` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitetanquedesconto` ENABLE KEYS */;

--
-- Table structure for table `leitevalorprodutividade`
--

DROP TABLE IF EXISTS `leitevalorprodutividade`;
CREATE TABLE `leitevalorprodutividade` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `DataVigencia` date default NULL,
  `LitrosDe` float(12,2) default NULL,
  `LitrosAte` float(12,2) default NULL,
  `Valor` float(12,2) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `leitevalorprodutividade`
--


/*!40000 ALTER TABLE `leitevalorprodutividade` DISABLE KEYS */;
LOCK TABLES `leitevalorprodutividade` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `leitevalorprodutividade` ENABLE KEYS */;

--
-- Table structure for table `liberacao`
--

DROP TABLE IF EXISTS `liberacao`;
CREATE TABLE `liberacao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Tipo` enum('Desconto','Atrazo') NOT NULL,
  `Modulo` varchar(30) NOT NULL,
  `UsuarioSolicitante` varchar(25) NOT NULL,
  `ObservacaoSolicitante` text,
  `Tabela` varchar(25) default NULL,
  `Tabela_Id` int(10) unsigned default NULL,
  `DataHoraGrav` datetime default NULL,
  `UsuarioLiberador` varchar(25) default NULL,
  `RespostaLiberador` text,
  `DataHoraLiberador` datetime default NULL,
  `TipoResposta` enum('Autorizado','Negado') default NULL,
  PRIMARY KEY  (`Id`),
  KEY `Liberacao_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Liberacao` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `liberacao`
--


/*!40000 ALTER TABLE `liberacao` DISABLE KEYS */;
LOCK TABLES `liberacao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `liberacao` ENABLE KEYS */;

--
-- Table structure for table `licenciamento`
--

DROP TABLE IF EXISTS `licenciamento`;
CREATE TABLE `licenciamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Serie` varchar(35) default NULL,
  `Processador` varchar(15) default NULL,
  `Confirmado` varchar(35) default NULL,
  `Bloqueado` varchar(35) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `licenciamento`
--


/*!40000 ALTER TABLE `licenciamento` DISABLE KEYS */;
LOCK TABLES `licenciamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `licenciamento` ENABLE KEYS */;

--
-- Table structure for table `livrodiario`
--

DROP TABLE IF EXISTS `livrodiario`;
CREATE TABLE `livrodiario` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ContaCredito_Id` int(10) unsigned NOT NULL,
  `ContaDebito_Id` int(10) unsigned NOT NULL,
  `DataMovimento` date NOT NULL,
  `Historico` varchar(100) NOT NULL,
  `NumeroDocumento` varchar(10) default NULL,
  `Valor` decimal(12,2) NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `Loja_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LivroDiario_FK_ContaDebito` (`ContaDebito_Id`),
  KEY `LivroDiario_FK_ContaCredito` (`ContaCredito_Id`),
  CONSTRAINT `FK_ContaCredito_LivroDiario` FOREIGN KEY (`ContaCredito_Id`) REFERENCES `planoconta` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_ContaDebito_LivroDiario` FOREIGN KEY (`ContaDebito_Id`) REFERENCES `planoconta` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `livrodiario`
--


/*!40000 ALTER TABLE `livrodiario` DISABLE KEYS */;
LOCK TABLES `livrodiario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `livrodiario` ENABLE KEYS */;

--
-- Table structure for table `loccontrato`
--

DROP TABLE IF EXISTS `loccontrato`;
CREATE TABLE `loccontrato` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Pessoa_Id` int(11) NOT NULL,
  `LocEquipamento_Id` int(10) unsigned NOT NULL,
  `DataInicial` date default NULL,
  `TipoValorContratado` enum('Valor por Pgina','Valor Fixo') NOT NULL,
  `QuantidadeFranqueada` int(10) unsigned NOT NULL,
  `Estagio` enum('Locado','Encerrado') NOT NULL,
  `DataFinal` date default NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LocContratoItem_FKIndex2` (`LocEquipamento_Id`),
  KEY `LocContrato_FKIndex2` (`Pessoa_Id`),
  CONSTRAINT `FK_Pessoa_LocContrato` FOREIGN KEY (`Pessoa_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Equipamento_ContratoItem` FOREIGN KEY (`LocEquipamento_Id`) REFERENCES `locequipamento` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `loccontrato`
--


/*!40000 ALTER TABLE `loccontrato` DISABLE KEYS */;
LOCK TABLES `loccontrato` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `loccontrato` ENABLE KEYS */;

--
-- Table structure for table `locdespesa`
--

DROP TABLE IF EXISTS `locdespesa`;
CREATE TABLE `locdespesa` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LocContrato_Id` int(10) unsigned NOT NULL,
  `Venda_Id` int(10) unsigned NOT NULL,
  `ValorTotal` float(12,2) NOT NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LocDespesa_FKIndex1` (`LocContrato_Id`),
  CONSTRAINT `FK_Item_Despesa` FOREIGN KEY (`LocContrato_Id`) REFERENCES `loccontrato` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locdespesa`
--


/*!40000 ALTER TABLE `locdespesa` DISABLE KEYS */;
LOCK TABLES `locdespesa` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `locdespesa` ENABLE KEYS */;

--
-- Table structure for table `locequipamento`
--

DROP TABLE IF EXISTS `locequipamento`;
CREATE TABLE `locequipamento` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `NumeroSerie` varchar(20) NOT NULL,
  `ValorFixo` float(12,2) NOT NULL,
  `ValorPorPagina` float(12,2) NOT NULL,
  `ValorPorPaginaExtra` float(12,2) NOT NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LocEquipamento_FKIndex1` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_ProdutoGrade_Equipamento` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locequipamento`
--


/*!40000 ALTER TABLE `locequipamento` DISABLE KEYS */;
LOCK TABLES `locequipamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `locequipamento` ENABLE KEYS */;

--
-- Table structure for table `locleitura`
--

DROP TABLE IF EXISTS `locleitura`;
CREATE TABLE `locleitura` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LocContrato_Id` int(10) unsigned NOT NULL,
  `DataLeitura` date NOT NULL,
  `NumeroCopias` int(10) unsigned NOT NULL,
  `ValorTotal` float(12,2) NOT NULL,
  `Obs` text,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `LocVistoria_FKIndex1` (`LocContrato_Id`),
  CONSTRAINT `Rel_739` FOREIGN KEY (`LocContrato_Id`) REFERENCES `loccontrato` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locleitura`
--


/*!40000 ALTER TABLE `locleitura` DISABLE KEYS */;
LOCK TABLES `locleitura` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `locleitura` ENABLE KEYS */;

--
-- Table structure for table `locosdetalhada`
--

DROP TABLE IF EXISTS `locosdetalhada`;
CREATE TABLE `locosdetalhada` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `LocEquipamento_Id` int(10) unsigned NOT NULL,
  `OSDetalhada_Id` int(11) NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `ValorTotal` float(12,2) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LocOSInterna_FKIndex1` (`OSDetalhada_Id`),
  KEY `LocOSInterna_FKIndex2` (`LocEquipamento_Id`),
  CONSTRAINT `Rel_741` FOREIGN KEY (`LocEquipamento_Id`) REFERENCES `locequipamento` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Rel_740` FOREIGN KEY (`OSDetalhada_Id`) REFERENCES `osdetalhada` (`Id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `locosdetalhada`
--


/*!40000 ALTER TABLE `locosdetalhada` DISABLE KEYS */;
LOCK TABLES `locosdetalhada` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `locosdetalhada` ENABLE KEYS */;

--
-- Table structure for table `logradouro`
--

DROP TABLE IF EXISTS `logradouro`;
CREATE TABLE `logradouro` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `Nome` varchar(60) NOT NULL,
  `Pontos` int(11) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  `loc_nu_sequencial` int(10) unsigned default NULL,
  `bai_nu_sequencial` int(10) unsigned default NULL,
  `cep` varchar(10) default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Logradouro_Nome` (`Nome`,`cep`),
  KEY `Logradouro_FKIndex1` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Logradouro` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `logradouro`
--


/*!40000 ALTER TABLE `logradouro` DISABLE KEYS */;
LOCK TABLES `logradouro` WRITE;
INSERT INTO `logradouro` (`Id`, `Loja_Id`, `Nome`, `Pontos`, `Usuario_Id`, `DataHoraGrav`, `loc_nu_sequencial`, `bai_nu_sequencial`, `cep`) VALUES (1,1,'DESCONHECIDO',NULL,1,'2009-08-19 00:59:44',NULL,NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `logradouro` ENABLE KEYS */;

--
-- Table structure for table `loja`
--

DROP TABLE IF EXISTS `loja`;
CREATE TABLE `loja` (
  `Id` int(11) NOT NULL auto_increment,
  `Codigo` varchar(3) default NULL,
  `Descricao` varchar(26) default NULL,
  `PessoaContabilista_Id` int(10) unsigned default NULL,
  `PessoaContabilista_CRC` varchar(10) default NULL,
  `PessoaEntidade_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Loja_indexDescricao` (`Descricao`),
  UNIQUE KEY `Loja_indexCodigo` (`Codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `loja`
--


/*!40000 ALTER TABLE `loja` DISABLE KEYS */;
LOCK TABLES `loja` WRITE;
INSERT INTO `loja` (`Id`, `Codigo`, `Descricao`, `PessoaContabilista_Id`, `PessoaContabilista_CRC`, `PessoaEntidade_Id`) VALUES (1,'001','Loja 1',0,'',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `loja` ENABLE KEYS */;

--
-- Table structure for table `lojarestricao`
--

DROP TABLE IF EXISTS `lojarestricao`;
CREATE TABLE `lojarestricao` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `LojaRestricao_Id` int(11) NOT NULL,
  `QuitarContaCliente` tinyint(1) default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `LojaRestricao_FK_Restricao` (`LojaRestricao_Id`),
  KEY `LojaRestricao_FK_Loja` (`Loja_Id`),
  CONSTRAINT `FK_LojaRestricao_Loja` FOREIGN KEY (`LojaRestricao_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Loja_LojaResticao` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `lojarestricao`
--


/*!40000 ALTER TABLE `lojarestricao` DISABLE KEYS */;
LOCK TABLES `lojarestricao` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `lojarestricao` ENABLE KEYS */;

--
-- Table structure for table `marca`
--

DROP TABLE IF EXISTS `marca`;
CREATE TABLE `marca` (
  `Id` int(11) NOT NULL auto_increment,
  `Loja_Id` int(11) NOT NULL,
  `PessoaFabricante_Id` int(11) default NULL,
  `Nome` varchar(25) NOT NULL,
  `ServicoAutorizado` tinyint(1) default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Marca_Unico` (`Nome`),
  KEY `Marca_FKIndex1` (`PessoaFabricante_Id`),
  KEY `Marca_FKIndex2` (`Loja_Id`),
  CONSTRAINT `FK_Loja_Marca` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_MarcaFabricante` FOREIGN KEY (`PessoaFabricante_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COMMENT='testando comentario da tabela';

--
-- Dumping data for table `marca`
--


/*!40000 ALTER TABLE `marca` DISABLE KEYS */;
LOCK TABLES `marca` WRITE;
INSERT INTO `marca` (`Id`, `Loja_Id`, `PessoaFabricante_Id`, `Nome`, `ServicoAutorizado`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,NULL,'DESCONHECIDA',0,1,'2009-08-19 01:00:50'),(2,1,NULL,'GERDAU',0,1,'2010-08-16 18:47:42');
UNLOCK TABLES;
/*!40000 ALTER TABLE `marca` ENABLE KEYS */;

--
-- Table structure for table `materialtecnico`
--

DROP TABLE IF EXISTS `materialtecnico`;
CREATE TABLE `materialtecnico` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `PessoaTecnico_Id` int(11) NOT NULL,
  `Loja_Id` int(11) NOT NULL,
  `Emissao` date default NULL,
  `DataHoraGrav` datetime default NULL,
  `Usuario_Id` int(10) unsigned default NULL,
  PRIMARY KEY  (`Id`),
  KEY `MaterialTecnico_FK_Loja` (`Loja_Id`),
  KEY `MaterialTecnico_FK_Tecnico` (`PessoaTecnico_Id`),
  CONSTRAINT `FK_Loja_MaterialTecnico` FOREIGN KEY (`Loja_Id`) REFERENCES `loja` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Pessoa_MaterialTecnico` FOREIGN KEY (`PessoaTecnico_Id`) REFERENCES `pessoa` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `materialtecnico`
--


/*!40000 ALTER TABLE `materialtecnico` DISABLE KEYS */;
LOCK TABLES `materialtecnico` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `materialtecnico` ENABLE KEYS */;

--
-- Table structure for table `materialtecnicoitens`
--

DROP TABLE IF EXISTS `materialtecnicoitens`;
CREATE TABLE `materialtecnicoitens` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `ProdutoGrade_Id` int(11) NOT NULL,
  `MaterialTecnico_Id` int(10) unsigned NOT NULL,
  `Quantidade` float(7,2) NOT NULL,
  `Valor` float(12,2) NOT NULL,
  `RetirarEstoque` tinyint(1) default NULL,
  `DataHoraGrav` datetime NOT NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `MaterialTecnicoItens_FK_MaterialTecnico` (`MaterialTecnico_Id`),
  KEY `MaterialTecnicoItens_FK_ProdutoGrade` (`ProdutoGrade_Id`),
  CONSTRAINT `FK_MaterialTecnico_Itens` FOREIGN KEY (`MaterialTecnico_Id`) REFERENCES `materialtecnico` (`Id`) ON UPDATE CASCADE,
  CONSTRAINT `FK_Produto_MaterialTecnicoItem` FOREIGN KEY (`ProdutoGrade_Id`) REFERENCES `produtograde` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `materialtecnicoitens`
--


/*!40000 ALTER TABLE `materialtecnicoitens` DISABLE KEYS */;
LOCK TABLES `materialtecnicoitens` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `materialtecnicoitens` ENABLE KEYS */;

--
-- Table structure for table `modelocarnet`
--

DROP TABLE IF EXISTS `modelocarnet`;
CREATE TABLE `modelocarnet` (
  `Id` int(11) NOT NULL auto_increment,
  `Modelo` varchar(35) default NULL,
  `LinhaVia1Cliente` int(11) default NULL,
  `ColunaVia1Cliente` int(11) default NULL,
  `LinhaVia1NumeroParcela` int(11) default NULL,
  `ColunaVia1NumeroParcela` int(11) default NULL,
  `LinhaVia1Vencimento` int(11) default NULL,
  `ColunaVia1Vencimento` int(11) default NULL,
  `LinhaVia1Emissao` int(11) default NULL,
  `ColunaVia1Emissao` int(11) default NULL,
  `LinhaVia1ValorFatura` int(11) default NULL,
  `ColunaVia1ValorFatura` int(11) default NULL,
  `LinhaVia1Documento` int(11) default NULL,
  `ColunaVia1Documento` int(11) default NULL,
  `LinhaVia1JuroDiario` int(11) default NULL,
  `ColunaVia1JuroDiario` int(11) default NULL,
  `LinhaVia1ValorParcela` int(11) default NULL,
  `ColunaVia1ValorParcela` int(11) default NULL,
  `LinhaVia1Juros` int(11) default NULL,
  `ColunaVia1Juros` int(11) default NULL,
  `LinhaVia1Desconto` int(11) default NULL,
  `ColunaVia1Desconto` int(11) default NULL,
  `LinhaVia1Total` int(11) default NULL,
  `ColunaVia1Total` int(11) default NULL,
  `LinhaVia2Cliente` int(11) default NULL,
  `ColunaVia2Cliente` int(11) default NULL,
  `LinhaVia2NumeroParcela` int(11) default NULL,
  `ColunaVia2NumeroParcela` int(11) default NULL,
  `LinhaVia2Vencimento` int(11) default NULL,
  `ColunaVia2Vencimento` int(11) default NULL,
  `LinhaVia2Emissao` int(11) default NULL,
  `ColunaVia2Emissao` int(11) default NULL,
  `LinhaVia2ValorFatura` int(11) default NULL,
  `ColunaVia2ValorFatura` int(11) default NULL,
  `LinhaVia2Documento` int(11) default NULL,
  `ColunaVia2Documento` int(11) default NULL,
  `LinhaVia2JuroDiario` int(11) default NULL,
  `ColunaVia2JuroDiario` int(11) default NULL,
  `LinhaVia2ValorParcela` int(11) default NULL,
  `ColunaVia2ValorParcela` int(11) default NULL,
  `LinhaVia2Juros` int(11) default NULL,
  `ColunaVia2Juros` int(11) default NULL,
  `LinhaVia2Desconto` int(11) default NULL,
  `ColunaVia2Desconto` int(11) default NULL,
  `LinhaVia2Total` int(11) default NULL,
  `ColunaVia2Total` int(11) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modelocarnet`
--


/*!40000 ALTER TABLE `modelocarnet` DISABLE KEYS */;
LOCK TABLES `modelocarnet` WRITE;
INSERT INTO `modelocarnet` (`Id`, `Modelo`, `LinhaVia1Cliente`, `ColunaVia1Cliente`, `LinhaVia1NumeroParcela`, `ColunaVia1NumeroParcela`, `LinhaVia1Vencimento`, `ColunaVia1Vencimento`, `LinhaVia1Emissao`, `ColunaVia1Emissao`, `LinhaVia1ValorFatura`, `ColunaVia1ValorFatura`, `LinhaVia1Documento`, `ColunaVia1Documento`, `LinhaVia1JuroDiario`, `ColunaVia1JuroDiario`, `LinhaVia1ValorParcela`, `ColunaVia1ValorParcela`, `LinhaVia1Juros`, `ColunaVia1Juros`, `LinhaVia1Desconto`, `ColunaVia1Desconto`, `LinhaVia1Total`, `ColunaVia1Total`, `LinhaVia2Cliente`, `ColunaVia2Cliente`, `LinhaVia2NumeroParcela`, `ColunaVia2NumeroParcela`, `LinhaVia2Vencimento`, `ColunaVia2Vencimento`, `LinhaVia2Emissao`, `ColunaVia2Emissao`, `LinhaVia2ValorFatura`, `ColunaVia2ValorFatura`, `LinhaVia2Documento`, `ColunaVia2Documento`, `LinhaVia2JuroDiario`, `ColunaVia2JuroDiario`, `LinhaVia2ValorParcela`, `ColunaVia2ValorParcela`, `LinhaVia2Juros`, `ColunaVia2Juros`, `LinhaVia2Desconto`, `ColunaVia2Desconto`, `LinhaVia2Total`, `ColunaVia2Total`) VALUES (1,'Carnet Avulso',7,10,8,15,8,28,9,10,9,28,10,14,11,13,12,29,13,29,14,29,15,29,7,45,8,50,8,64,9,45,9,64,10,49,11,48,12,65,13,65,14,65,15,65);
UNLOCK TABLES;
/*!40000 ALTER TABLE `modelocarnet` ENABLE KEYS */;

--
-- Table structure for table `modelocheque`
--

DROP TABLE IF EXISTS `modelocheque`;
CREATE TABLE `modelocheque` (
  `Id` int(11) NOT NULL auto_increment,
  `Banco_Id` int(11) NOT NULL,
  `ColunaValor` int(10) unsigned default NULL,
  `LinhaValor` int(10) unsigned default NULL,
  `ColunaExtenso` int(10) unsigned default NULL,
  `LinhaExtenso` int(10) unsigned default NULL,
  `ColunaExtenso2` int(10) unsigned default NULL,
  `LinhaExtenso2` int(10) unsigned default NULL,
  `ColunaNominal` int(10) unsigned default NULL,
  `LinhaNominal` int(10) unsigned default NULL,
  `ColunaCidade` int(10) unsigned default NULL,
  `LinhaCidade` int(10) unsigned default NULL,
  `ColunaDiaMes` int(10) unsigned default NULL,
  `LinhaDiaMes` int(10) unsigned default NULL,
  `ColunaAno` int(10) unsigned default NULL,
  `LinhaAno` int(10) unsigned default NULL,
  `Usuario_Id` int(10) unsigned NOT NULL,
  `DataHoraGrav` datetime NOT NULL,
  PRIMARY KEY  (`Id`),
  KEY `ModeloCheque_FK_Banco` (`Banco_Id`),
  CONSTRAINT `FK_Banco_ModeloCheque` FOREIGN KEY (`Banco_Id`) REFERENCES `banco` (`Id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modelocheque`
--


/*!40000 ALTER TABLE `modelocheque` DISABLE KEYS */;
LOCK TABLES `modelocheque` WRITE;
INSERT INTO `modelocheque` (`Id`, `Banco_Id`, `ColunaValor`, `LinhaValor`, `ColunaExtenso`, `LinhaExtenso`, `ColunaExtenso2`, `LinhaExtenso2`, `ColunaNominal`, `LinhaNominal`, `ColunaCidade`, `LinhaCidade`, `ColunaDiaMes`, `LinhaDiaMes`, `ColunaAno`, `LinhaAno`, `Usuario_Id`, `DataHoraGrav`) VALUES (1,1,50,1,10,2,5,4,5,5,35,7,47,7,63,7,1,'2006-10-12 01:14:13'),(2,2,50,1,10,2,5,4,5,5,35,7,47,7,63,7,1,'2006-10-12 01:56:40');
UNLOCK TABLES;
/*!40000 ALTER TABLE `modelocheque` ENABLE KEYS */;

--
-- Table structure for table `modeloduplicatacomum`
--

DROP TABLE IF EXISTS `modeloduplicatacomum`;
CREATE TABLE `modeloduplicatacomum` (
  `Id` int(11) NOT NULL auto_increment,
  `Modelo` varchar(35) default NULL,
  `LinhaDataEmissao` int(11) default NULL,
  `ColunaDataEmissao` int(11) default NULL,
  `LinhaValorFatura` int(11) default NULL,
  `ColunaValorFatura` int(11) default NULL,
  `LinhaNumeroFatura` int(11) default NULL,
  `ColunaNumeroFatura` int(11) default NULL,
  `LinhaValorDuplicata` int(11) default NULL,
  `ColunaValorDuplicata` int(11) default NULL,
  `LinhaNumeroOrdem` int(11) default NULL,
  `ColunaNumeroOrdem` int(11) default NULL,
  `LinhaVencimento` int(11) default NULL,
  `ColunaVencimento` int(11) default NULL,
  `LinhaNomeSacado` int(11) default NULL,
  `ColunaNomeSacado` int(11) default NULL,
  `LinhaEndereco` int(11) default NULL,
  `ColunaEndereco` int(11) default NULL,
  `LinhaBairro` int(11) default NULL,
  `ColunaBairro` int(11) default NULL,
  `LinhaMunicipio` int(11) default NULL,
  `ColunaMunicipio` int(11) default NULL,
  `LinhaEstado` int(11) default NULL,
  `ColunaEstado` int(11) default NULL,
  `LinhaFone` int(11) default NULL,
  `ColunaFone` int(11) default NULL,
  `LinhaPracaPagto` int(11) default NULL,
  `ColunaPracaPagto` int(11) default NULL,
  `LinhaCep` int(11) default NULL,
  `ColunaCep` int(11) default NULL,
  `LinhaCPF` int(11) default NULL,
  `ColunaCPF` int(11) default NULL,
  `LinhaRG` int(11) default NULL,
  `ColunaRG` int(11) default NULL,
  `LinhaValorExtenso1` int(11) default NULL,
  `ColunaValorExtenso1` int(11) default NULL,
  `LinhaValorExtenso2` int(11) default NULL,
  `ColunaValorExtenso2` int(11) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modeloduplicatacomum`
--


/*!40000 ALTER TABLE `modeloduplicatacomum` DISABLE KEYS */;
LOCK TABLES `modeloduplicatacomum` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `modeloduplicatacomum` ENABLE KEYS */;

--
-- Table structure for table `modeloduplicatapersonalizada`
--

DROP TABLE IF EXISTS `modeloduplicatapersonalizada`;
CREATE TABLE `modeloduplicatapersonalizada` (
  `Id` int(11) NOT NULL auto_increment,
  `Modelo` varchar(35) default NULL,
  `LinhaDataEmissao` int(11) default NULL,
  `ColunaDataEmissao` int(11) default NULL,
  `LinhaTotalFatura` int(11) default NULL,
  `ColunaTotalFatura` int(11) default NULL,
  `LinhaNumeroFatura` int(11) default NULL,
  `ColunaNumeroFatura` int(11) default NULL,
  `LinhaCol1NumeroOrdem` int(11) default NULL,
  `ColunaCol1NumeroOrdem` int(11) default NULL,
  `LinhaCol2NumeroOrdem` int(11) default NULL,
  `ColunaCol2NumeroOrdem` int(11) default NULL,
  `LinhaCol3NumeroOrdem` int(11) default NULL,
  `ColunaCol3NumeroOrdem` int(11) default NULL,
  `LinhaCol1Vencimento` int(11) default NULL,
  `ColunaCol1Vencimento` int(11) default NULL,
  `LinhaCol2Vencimento` int(11) default NULL,
  `ColunaCol2Vencimento` int(11) default NULL,
  `LinhaCol3Vencimento` int(11) default NULL,
  `ColunaCol3Vencimento` int(11) default NULL,
  `LinhaCol1ValorParcela` int(11) default NULL,
  `ColunaCol1ValorParcela` int(11) default NULL,
  `LinhaCol2ValorParcela` int(11) default NULL,
  `ColunaCol2ValorParcela` int(11) default NULL,
  `LinhaCol3ValorParcela` int(11) default NULL,
  `ColunaCol3ValorParcela` int(11) default NULL,
  `LimiteLinhasParcelas` int(11) default NULL,
  `LinhaSacado` int(11) default NULL,
  `ColunaSacado` int(11) default NULL,
  `LinhaEndereco` int(11) default NULL,
  `ColunaEndereco` int(11) default NULL,
  `LinhaMunicipio` int(11) default NULL,
  `ColunaMunicipio` int(11) default NULL,
  `LinhaEstado` int(11) default NULL,
  `ColunaEstado` int(11) default NULL,
  `LinhaPracaPagto` int(11) default NULL,
  `ColunaPracaPagto` int(11) default NULL,
  `LinhaCpf` int(11) default NULL,
  `ColunaCpf` int(11) default NULL,
  `LinhaRG` int(11) default NULL,
  `ColunaRG` int(11) default NULL,
  `LinhaValorExtenso1` int(11) default NULL,
  `ColunaValorExtenso1` int(11) default NULL,
  `LinhaValorExtenso2` int(11) default NULL,
  `ColunaValorExtenso2` int(11) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modeloduplicatapersonalizada`
--


/*!40000 ALTER TABLE `modeloduplicatapersonalizada` DISABLE KEYS */;
LOCK TABLES `modeloduplicatapersonalizada` WRITE;
INSERT INTO `modeloduplicatapersonalizada` (`Id`, `Modelo`, `LinhaDataEmissao`, `ColunaDataEmissao`, `LinhaTotalFatura`, `ColunaTotalFatura`, `LinhaNumeroFatura`, `ColunaNumeroFatura`, `LinhaCol1NumeroOrdem`, `ColunaCol1NumeroOrdem`, `LinhaCol2NumeroOrdem`, `ColunaCol2NumeroOrdem`, `LinhaCol3NumeroOrdem`, `ColunaCol3NumeroOrdem`, `LinhaCol1Vencimento`, `ColunaCol1Vencimento`, `LinhaCol2Vencimento`, `ColunaCol2Vencimento`, `LinhaCol3Vencimento`, `ColunaCol3Vencimento`, `LinhaCol1ValorParcela`, `ColunaCol1ValorParcela`, `LinhaCol2ValorParcela`, `ColunaCol2ValorParcela`, `LinhaCol3ValorParcela`, `ColunaCol3ValorParcela`, `LimiteLinhasParcelas`, `LinhaSacado`, `ColunaSacado`, `LinhaEndereco`, `ColunaEndereco`, `LinhaMunicipio`, `ColunaMunicipio`, `LinhaEstado`, `ColunaEstado`, `LinhaPracaPagto`, `ColunaPracaPagto`, `LinhaCpf`, `ColunaCpf`, `LinhaRG`, `ColunaRG`, `LinhaValorExtenso1`, `ColunaValorExtenso1`, `LinhaValorExtenso2`, `ColunaValorExtenso2`) VALUES (1,'Personalizado',6,58,10,8,12,8,9,22,9,39,9,56,9,26,9,43,9,60,9,33,9,50,9,67,6,17,28,18,28,19,29,19,70,20,32,21,32,21,62,23,30,24,30);
UNLOCK TABLES;
/*!40000 ALTER TABLE `modeloduplicatapersonalizada` ENABLE KEYS */;

--
-- Table structure for table `modeloformulario`
--

DROP TABLE IF EXISTS `modeloformulario`;
CREATE TABLE `modeloformulario` (
  `Id` int(11) NOT NULL auto_increment,
  `Descricao` varchar(35) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modeloformulario`
--


/*!40000 ALTER TABLE `modeloformulario` DISABLE KEYS */;
LOCK TABLES `modeloformulario` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `modeloformulario` ENABLE KEYS */;

--
-- Table structure for table `modelopromissoria`
--

DROP TABLE IF EXISTS `modelopromissoria`;
CREATE TABLE `modelopromissoria` (
  `Id` int(11) NOT NULL auto_increment,
  `Modelo` varchar(30) default NULL,
  `ColunaVencimento` int(11) default NULL,
  `LinhaVencimento` int(11) default NULL,
  `ColunaNumero` int(11) default NULL,
  `LinhaNumero` int(11) default NULL,
  `ColunaValor` int(11) default NULL,
  `LinhaValor` int(11) default NULL,
  `ColunaExtensoData` int(11) default NULL,
  `LinhaExtensoData` int(11) default NULL,
  `ColunaPagarA` int(11) default NULL,
  `LinhaPagarA` int(11) default NULL,
  `ColunaExtensoValor1` int(11) default NULL,
  `LinhaExtensoValor1` int(11) default NULL,
  `ColunaExtensoValor2` int(11) default NULL,
  `LinhaExtensoValor2` int(11) default NULL,
  `ColunaPagavelEm` int(11) default NULL,
  `LinhaPagavelEm` int(11) default NULL,
  `ColunaEmitente` int(11) default NULL,
  `LinhaEmitente` int(11) default NULL,
  `ColunaCpf` int(11) default NULL,
  `LinhaCpf` int(11) default NULL,
  `ColunaEndereco` int(11) default NULL,
  `LinhaEndereco` int(11) default NULL,
  `ColunaDataEmissao` int(11) default NULL,
  `LinhaDataEmissao` int(11) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `modelopromissoria`
--


/*!40000 ALTER TABLE `modelopromissoria` DISABLE KEYS */;
LOCK TABLES `modelopromissoria` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `modelopromissoria` ENABLE KEYS */;

--
-- Table structure for table `ncm`
--

DROP TABLE IF EXISTS `ncm`;
CREATE TABLE `ncm` (
  `Id` int(10) unsigned NOT NULL auto_increment,
  `Cod_NBM` varchar(20) default NULL,
  `Nome_NBM` varchar(100) default NULL,
  `TemBeneficio` tinyint(1) default NULL,
  `AliquotaPis` float(12,2) default NULL,
  `AliquotaCofins` float(12,2) default NULL,
  `CEST` varchar(7) default NULL,
  `Cod_NCM` varchar(20) NOT NULL,
  `Ex` char(2) default NULL,
  `Nome_NCM` varchar(100) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=19010 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `ncm`
--


/*!40000 ALTER TABLE `ncm` DISABLE KEYS */;
LOCK TABLES `ncm` WRITE;
INSERT INTO `ncm` (`Id`, `Cod_NBM`, `Nome_NBM`, `TemBeneficio`, `AliquotaPis`, `AliquotaCofins`, `CEST`, `Cod_NCM`, `Ex`, `Nome_NCM`) VALUES (1,'0000.10.0000','ENCOMENDAS',NULL,NULL,NULL,NULL,'99910000',NULL,'ENCOMENDAS POSTAIS'),(2,'0000.20.0000','MERCADORIAS PARA FINS DE DIVULGACAO E TESTES EXTERIOR',NULL,NULL,NULL,NULL,'99920000',NULL,'AMOSTRAS'),(3,'0000.70.0000','DOACOES',NULL,NULL,NULL,NULL,'99970000',NULL,'MERCADORIAS DOADAS'),(4,'0000.71.0010','PEDRAS EM BRUTO,DO CAPITULO 71 DA NBM-SH',NULL,NULL,NULL,NULL,'99997101',NULL,'PEDRAS EM BRUTO DO CAPITULO 71 DA NCM'),(5,'0000.71.0020','PEDRAS LAPIDADAS/TRABALHADAS DO CAPITULO 71 DA NBM-SH',NULL,NULL,NULL,NULL,'99997102',NULL,'PEDRAS LAPIDADAS/TRABALHADAS DO CAPITULO 71 DA NCM'),(6,'0000.71.0030','JOALHERIA DE OURO DO CAPITULO 71 DA NBM-SH',NULL,NULL,NULL,NULL,'99997103',NULL,'JOALHERIA DE OURO DO CAPITULO 71 DA NCM'),(7,'0000.71.0040','DEMAIS ARTIGOS DO CAPITULO 71 DA NBM-SH',NULL,NULL,NULL,NULL,'99997104',NULL,'OUTROS ARTIGOS DO CAPITULO 71 DA NCM'),(8,'0000.80.0100','CONSUMO DE BORDO - COMBUSTIVEIS E LUBRIF.P/EMBARCACOES',NULL,NULL,NULL,NULL,'99980101',NULL,'CONSUMO DE BORDO - COMBUSTIVEIS E LUBRIF.P/EMBARCACOES'),(9,'0000.80.0200','CONSUMO DE BORDO - COMBUSTIVEIS E LUBRIF.P/AERONAVES',NULL,NULL,NULL,NULL,'99980102',NULL,'CONSUMO DE BORDO - COMBUSTIVEIS E LUBRIF.P/AERONAVES'),(10,'0000.80.9800','CONSUMO DE BORDO - QQ.OUTRA MERCADORIA PARA EMBARCACOES',NULL,NULL,NULL,NULL,'99980201',NULL,'CONSUMO DE BORDO - QQ.OUTRA MERCADORIA P/EMBARCACOES'),(11,'0000.80.9900','CONSUMO DE BORDO - QQ.OUTRA MERCADORIA PARA AERONAVES',NULL,NULL,NULL,NULL,'99980202',NULL,'CONSUMO DE BORDO - QQ.OUTRA MERCADORIA P/AERONAVES'),(12,'0000.90.0000','OUTRAS EXPORTACOES SEM COBERTURA CAMBIAL,SEM RETORNO',NULL,NULL,NULL,NULL,'99999900',NULL,'QQ.OUTRA MERCADORIA SEM COBERTURA CAMBIAL'),(13,'0101.11.0000','CAVALOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01011100',NULL,'CAVALOS REPRODUTORES,DE RACA PURA'),(14,'0101.19.0100','CAVALOS,MATRIZ PRENHE OU COM CRIA AO PE',NULL,NULL,NULL,NULL,'01011900',NULL,'OUTROS CAVALOS,VIVOS'),(15,'0101.19.0200','CAVALOS DE CORRIDA',NULL,NULL,NULL,NULL,'01011900',NULL,'OUTROS CAVALOS,VIVOS'),(16,'0101.19.9900','OUTROS CAVALOS VIVOS',NULL,NULL,NULL,NULL,'01011900',NULL,'OUTROS CAVALOS,VIVOS'),(17,'0101.20.0100','ASININOS E MUARES,REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01012000',NULL,'ASININOS E MUARES VIVOS'),(18,'0101.20.9900','OUTROS ASININOS E MUARES,VIVOS',NULL,NULL,NULL,NULL,'01012000',NULL,'ASININOS E MUARES VIVOS'),(19,'0102.10.0100','BOVINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01021010',NULL,'BOVINOS REPRODUTORES DE RACA PURA,PRENHE OU CRIA AO PE'),(20,'0102.10.0100','BOVINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01021090',NULL,'OUTROS BOVINOS REPRODUTORES DE RACA PURA'),(21,'0102.10.0200','BUFALOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01021010',NULL,'BOVINOS REPRODUTORES DE RACA PURA,PRENHE OU CRIA AO PE'),(22,'0102.10.0200','BUFALOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01021090',NULL,'OUTROS BOVINOS REPRODUTORES DE RACA PURA'),(23,'0102.90.0101','BOVINOS,MATRIZ PRENHE OU COM CRIA AO PE',NULL,NULL,NULL,NULL,'01029011',NULL,'OUTROS BOVINOS PARA REPRODUCAO,PRENHE OU COM CRIA AO PE'),(24,'0102.90.0102','BOVINOS PARA CORTE (CONSUMO)',NULL,NULL,NULL,NULL,'01029090',NULL,'OUTROS BOVINOS VIVOS'),(25,'0102.90.0199','QUALQUER OUTRO BOVINO VIVO',NULL,NULL,NULL,NULL,'01029019',NULL,'OUTROS BOVINOS PARA REPRODUCAO'),(26,'0102.90.0199','QUALQUER OUTRO BOVINO VIVO',NULL,NULL,NULL,NULL,'01029090',NULL,'OUTROS BOVINOS VIVOS'),(27,'0102.90.0200','OUTROS BUFALOS VIVOS',NULL,NULL,NULL,NULL,'01029011',NULL,'OUTROS BOVINOS PARA REPRODUCAO,PRENHE OU COM CRIA AO PE'),(28,'0102.90.0200','OUTROS BUFALOS VIVOS',NULL,NULL,NULL,NULL,'01029019',NULL,'OUTROS BOVINOS PARA REPRODUCAO'),(29,'0102.90.0200','OUTROS BUFALOS VIVOS',NULL,NULL,NULL,NULL,'01029090',NULL,'OUTROS BOVINOS VIVOS'),(30,'0103.10.0000','SUINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01031000',NULL,'SUINOS REPRODUTORES DE RACA PURA'),(31,'0103.91.0000','OUTROS SUINOS VIVOS,DE PESO<50KG',NULL,NULL,NULL,NULL,'01039100',NULL,'OUTROS SUINOS VIVOS,DE PESO INFERIOR A 50KG'),(32,'0103.92.0000','OUTROS SUINOS VIVOS,DE PESO>=50KG',NULL,NULL,NULL,NULL,'01039200',NULL,'OUTROS SUINOS VIVOS,DE PESO IGUAL OU SUPERIOR A 50KG'),(33,'0104.10.0100','OVINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01041011',NULL,'OVINOS REPRODUTORES DE RACA PURA,PRENHE/COM CRIA AO PE'),(34,'0104.10.0100','OVINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01041019',NULL,'OUTROS OVINOS REPRODUTORES DE RACA PURA'),(35,'0104.10.0200','OVINOS,MATRIZ PRENHE OU COM CRIA AO PE',NULL,NULL,NULL,NULL,'01041090',NULL,'OUTROS OVINOS VIVOS'),(36,'0104.10.9900','OUTROS OVINOS VIVOS',NULL,NULL,NULL,NULL,'01041090',NULL,'OUTROS OVINOS VIVOS'),(37,'0104.20.0100','CAPRINOS REPRODUTORES DE RACA PURA',NULL,NULL,NULL,NULL,'01042010',NULL,'CAPRINOS REPRODUTORES DE RACA PURA'),(38,'0104.20.9900','OUTROS CAPRINOS VIVOS',NULL,NULL,NULL,NULL,'01042090',NULL,'OUTROS CAPRINOS VIVOS'),(39,'0105.11.0000','GALOS E GALINHAS,VIVOS,DE PESO<=185G',NULL,NULL,NULL,NULL,'01051110',NULL,'GALOS E GALINHAS,P<=185G,DE LINHA PURA/HIBRIDA,P/REPROD'),(40,'0105.11.0000','GALOS E GALINHAS,VIVOS,DE PESO<=185G',NULL,NULL,NULL,NULL,'01051190',NULL,'OUTROS GALOS E GALINHAS,VIVOS,PESO NAO SUPERIOR A 185G'),(41,'0105.19.0100','PERUS E PERUAS,VIVOS,DE PESO<=185G',NULL,NULL,NULL,NULL,'01051200',NULL,'PERUAS E PERUS,VIVOS,DE PESO NAO SUPERIOR A 185G'),(42,'0105.19.0200','PATOS E GANSOS,VIVOS,DE PESO<=185G',NULL,NULL,NULL,NULL,'01051900',NULL,'PATOS,GANSOS E GALINHAS D\'ANGOLA,VIVOS,DE PESO<=185G'),(43,'0105.19.9900','GALINHAS D\'ANGOLA (PINTADAS),VIVAS,DE PESO<=185G',NULL,NULL,NULL,NULL,'01051900',NULL,'PATOS,GANSOS E GALINHAS D\'ANGOLA,VIVOS,DE PESO<=185G'),(44,'0105.91.0000','GALOS E GALINHAS,VIVOS,DE PESO>185G',NULL,NULL,NULL,NULL,'01059200',NULL,'OUTROS GALOS E GALINHAS,VIVOS,DE PESO<=2.000G'),(45,'0105.91.0000','GALOS E GALINHAS,VIVOS,DE PESO>185G',NULL,NULL,NULL,NULL,'01059300',NULL,'GALOS E GALINHAS,VIVOS,DE PESO SUPERIOR A 2.000G'),(46,'0105.99.0000','PATOS,GANSOS,PERUS,PERUAS E PINTADAS,VIVOS,DE PESO>185G',NULL,NULL,NULL,NULL,'01059900',NULL,'PATOS,GANSOS,PERUS,PERUAS E PINTADAS,VIVOS,DE PESO>185G'),(47,'0106.00.0100','COELHO REPRODUTOR DE RACA PURA',NULL,NULL,NULL,NULL,'01060090',NULL,'OUTROS ANIMAIS VIVOS'),(48,'0106.00.0200','ABELHA RAINHA,VIVA',NULL,NULL,NULL,NULL,'01060090',NULL,'OUTROS ANIMAIS VIVOS'),(49,'0106.00.0300','ANIMAIS VIVOS,PARA LABORATORIO OU PESQUISA CIENTIFICA',NULL,NULL,NULL,NULL,'01060090',NULL,'OUTROS ANIMAIS VIVOS'),(50,'0106.00.0400','CHINCHILA REPRODUTOR DE RACA PURA',NULL,NULL,NULL,NULL,'01060090',NULL,'OUTROS ANIMAIS VIVOS'),(51,'0106.00.9900','OUTROS ANIMAIS VIVOS',NULL,NULL,NULL,NULL,'01060010',NULL,'AVESTRUZES \"STRUTHIO CAMELUS\" PARA REPRODUCAO'),(52,'0106.00.9900','OUTROS ANIMAIS VIVOS',NULL,NULL,NULL,NULL,'01060090',NULL,'OUTROS ANIMAIS VIVOS'),(53,'0201.10.0000','CARCACA E MEIA-CARCACA,DE BOVINO,N/DESOSS.FRESCA/REFRIG',NULL,NULL,NULL,NULL,'02011000',NULL,'CARCACAS E MEIAS CARCACAS DE BOVINO,FRESCAS OU REFRIGER'),(54,'0201.20.0100','QUARTO DE DIANTEIRO,DE BOVINO,N/DESOSSADO,FRESCO/REFRIG',NULL,NULL,NULL,NULL,'02012010',NULL,'QUARTOS DIANTEIROS N/DESOSSAD.DE BOVINO,FRESCOS/REFRIG.'),(55,'0201.20.0200','QUARTO DE TRASEIRO,DE BOVINO,N/DESOSSADO,FRESCO/REFRIG.',NULL,NULL,NULL,NULL,'02012020',NULL,'QUARTOS TRASEIROS NAO DESOSSAD.DE BOVINO,FRESCOS/REFRIG'),(56,'0201.20.0300','COSTELA DE BOVINO,NAO DESOSSADA,FRESCA OU REFRIGERADA',NULL,NULL,NULL,NULL,'02012090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,FRESCAS OU REFRIG'),(57,'0201.20.0400','BISTECA DE BOVINO,NAO DESOSSADA,FRESCA OU REFRIGERADA',NULL,NULL,NULL,NULL,'02012090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,FRESCAS OU REFRIG'),(58,'0201.20.0500','TIBONE DE BOVINO,NAO DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02012090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,FRESCAS OU REFRIG'),(59,'0201.20.9900','OUTRAS PECAS DE BOVINO,NAO DESOSSADAS,FRESCAS OU REFRIG',NULL,NULL,NULL,NULL,'02012090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,FRESCAS OU REFRIG'),(60,'0201.30.0100','CARCACA/MEIA-CARCACA,DE BOVINO,DESOSSADA,FRESCA/REFRIG.',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(61,'0201.30.0200','QUARTO DE DIANTEIRO,DE BOVINO,DESOSSADO,FRESCO/REFRIGER',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(62,'0201.30.0300','QUARTO DE TRASEIRO,DE BOVINO,DESOSSADO,FRESCO OU REFRIG',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(63,'0201.30.0401','CORACAO DE ALCATRA,DE BOVINO,DESOSSADO,FRESCO OU REFRIG',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(64,'0201.30.0402','PICANHA DE ALCATRA,DE BOVINO,DESOSSADA,FRESCA OU REFRIG',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(65,'0201.30.0403','MAMINHA DE ALCATRA,DE BOVINO,DESOSSADA,FRESCA OU REFRIG',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(66,'0201.30.0499','QQ.OUTRA ALCATRA,DE BOVINO,DESOSSADA,FRESCA OU REFRIGER',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(67,'0201.30.0500','CONTRAFILE DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(68,'0201.30.0600','COXAO DURO,DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(69,'0201.30.0700','COXAO MOLE,DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(70,'0201.30.0800','FILE MIGNON,DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(71,'0201.30.0900','LAGARTO DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(72,'0201.30.1000','PATINHO DE BOVINO,DESOSSADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(73,'0201.30.9900','OUTS.CARNES DE BOVINO,DESOSSADAS,FRESCAS OU REFRIGERAD.',NULL,NULL,NULL,NULL,'02013000',NULL,'CARNES DESOSSADAS DE BOVINO,FRESCAS OU REFRIGERADAS'),(74,'0202.10.0000','CARCACA/MEIA-CARCACA,DE BOVINO,NAO DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02021000',NULL,'CARCACAS E MEIAS-CARCACAS DE BOVINO,CONGELADAS'),(75,'0202.20.0100','QUARTO DE DIANTEIRO,DE BOVINO,NAO DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02022010',NULL,'QUARTOS DIANTEIROS NAO DESOSSADOS DE BOVINO,CONGELADOS'),(76,'0202.20.0200','QUARTO DE TRASEIRO,DE BOVINO,NAO DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02022020',NULL,'QUARTOS TRASEIROS NAO DESOSSADOS DE BOVINO,CONGELADOS'),(77,'0202.20.0300','COSTELA DE BOVINO,NAO DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02022090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,CONGELADAS'),(78,'0202.20.0400','BISTECA DE BOVINO,NAO DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02022090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,CONGELADAS'),(79,'0202.20.0500','TIBONE DE BOVINO,NAO DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02022090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,CONGELADAS'),(80,'0202.20.9900','OUTRAS CARNES DE BOVINO,NAO DESOSSADAS,CONGELADAS',NULL,NULL,NULL,NULL,'02022090',NULL,'OUTRAS PECAS NAO DESOSSADAS DE BOVINO,CONGELADAS'),(81,'0202.30.0100','CARCACA E MEIA-CARCACA,DE BOVINO,DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(82,'0202.30.0200','QUARTO DE DIANTEIRO,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(83,'0202.30.0300','QUARTO DE TRASEIRO,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(84,'0202.30.0401','CORACAO DE ALCATRA,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(85,'0202.30.0402','PICANHA DE ALCATRA,DE BOVINO,DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(86,'0202.30.0403','MAMINHA DE ALCATRA,DE BOVINO,DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(87,'0202.30.0499','QUALQUER OUTRA ALCATRA,DE BOVINO,DESOSSADA,CONGELADA',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(88,'0202.30.0500','CONTRAFILE DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(89,'0202.30.0600','COXAO DURO,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(90,'0202.30.0700','COXAO MOLE,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(91,'0202.30.0800','FILE MIGNON,DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(92,'0202.30.0900','LAGARTO DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(93,'0202.30.1000','PATINHO DE BOVINO,DESOSSADO,CONGELADO',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(94,'0202.30.9900','OUTS.CARNES DE BOVINO,DESOSSADAS,CONGELADAS',NULL,NULL,NULL,NULL,'02023000',NULL,'CARNES DESOSSADAS DE BOVINO,CONGELADAS'),(95,'0203.11.0000','CARCACA E MEIA-CARCACA,DE SUINO,FRESCA OU REFRIGERADA',NULL,NULL,NULL,NULL,'02031100',NULL,'CARCACAS E MEIAS-CARCACAS DE SUINO,FRESCAS OU REFRIGER.'),(96,'0203.12.0000','PERNAS E PAS,DE SUINO,NAO DESOSSADAS,FRESCAS OU REFRIG.',NULL,NULL,NULL,NULL,'02031200',NULL,'PERNAS,PAS,ETC.NAO DESOSSAD.DE SUINO,FRESCOS OU REFRIG.'),(97,'0203.19.0100','TOUCINHO ENTREMEADO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02031900',NULL,'OUTRAS CARNES DE SUINO,FRESCAS OU REFRIGERADAS'),(98,'0203.19.9900','OUTRAS CARNES DE SUINO,FRESCAS OU REFRIGERADAS',NULL,NULL,NULL,NULL,'02031900',NULL,'OUTRAS CARNES DE SUINO,FRESCAS OU REFRIGERADAS'),(99,'0203.21.0000','CARCACA E MEIA-CARCACA,DE SUINO,CONGELADA',NULL,NULL,NULL,NULL,'02032100',NULL,'CARCACAS E MEIAS-CARCACAS DE SUINO,CONGELADAS'),(100,'0203.22.0000','PERNAS E PAS,DE SUINO,NAO DESOSSADAS,CONGELADAS',NULL,NULL,NULL,NULL,'02032200',NULL,'PERNAS,PAS E PEDACOS NAO DESOSSADOS DE SUINO,CONGELADOS'),(101,'0203.29.0000','OUTRAS CARNES DE SUINO,CONGELADAS',NULL,NULL,NULL,NULL,'02032900',NULL,'OUTRAS CARNES DE SUINO,CONGELADAS'),(102,'0204.10.0000','CARCACA E MEIA-CARCACA,DE CORDEIRO,FRESCA,REFRIGERADA',NULL,NULL,NULL,NULL,'02041000',NULL,'CARCACAS E MEIAS-CARCACAS DE CORDEIRO,FRESCAS OU REFRIG'),(103,'0204.21.0000','CARCACA E MEIA-CARCACA,DE OVINO,FRESCA OU REFRIGERADA',NULL,NULL,NULL,NULL,'02042100',NULL,'CARCACAS E MEIAS-CARCACAS DE OVINO,FRESCAS OU REFRIG.'),(104,'0204.22.0000','OUTS.CARNES DE OVINO,NAO DESOSSADAS,FRESCAS OU REFRIGER',NULL,NULL,NULL,NULL,'02042200',NULL,'OUTRAS PECAS NAO DESOSSADAS DE OVINO,FRESCAS OU REFRIG'),(105,'0204.23.0000','CARNES DE OVINO,DESOSSADAS,FRESCAS OU REFRIGERADAS',NULL,NULL,NULL,NULL,'02042300',NULL,'CARNES DESOSSADAS DE OVINO,FRESCAS OU REFRIGERADAS'),(106,'0204.30.0000','CARCACA E MEIA-CARCACA,DE CORDEIRO,CONGELADA',NULL,NULL,NULL,NULL,'02043000',NULL,'CARCACAS E MEIAS-CARCACAS DE CORDEIRO,CONGELADAS'),(107,'0204.41.0000','CARCACA E MEIA-CARCACA,DE OVINO,CONGELADA',NULL,NULL,NULL,NULL,'02044100',NULL,'CARCACAS E MEIAS-CARCACAS DE OVINO,CONGELADAS'),(108,'0204.42.0000','OUTS.CARNES DE OVINO,NAO DESOSSADAS,CONGELADAS',NULL,NULL,NULL,NULL,'02044200',NULL,'OUTRAS PECAS NAO DESOSSADAS DE OVINO,CONGELADAS'),(109,'0204.43.0000','CARNES DE OVINO,DESOSSADAS,CONGELADAS',NULL,NULL,NULL,NULL,'02044300',NULL,'CARNES DESOSSADAS DE OVINO,CONGELADAS'),(110,'0204.50.0100','CARNES DE CAPRINO,FRESCAS OU REFRIGERADAS',NULL,NULL,NULL,NULL,'02045000',NULL,'CARNES DE CAPRINO,FRESCAS,REFRIGERADAS OU CONGELADAS'),(111,'0204.50.0200','CARNES DE CAPRINO,CONGELADAS',NULL,NULL,NULL,NULL,'02045000',NULL,'CARNES DE CAPRINO,FRESCAS,REFRIGERADAS OU CONGELADAS'),(112,'0205.00.0101','CARNES DE CAVALO,FRESCAS OU REFRIGERADAS',NULL,NULL,NULL,NULL,'02050000',NULL,'CARNES DE CAVALO,ASININO E MUAR,FRESCAS,REFRIG.OU CONG.'),(113,'0205.00.0102','CARNES DE CAVALO,CONGELADAS',NULL,NULL,NULL,NULL,'02050000',NULL,'CARNES DE CAVALO,ASININO E MUAR,FRESCAS,REFRIG.OU CONG.'),(114,'0205.00.0200','CARNES DE ASININO,FRESCAS,REFRIGERADAS OU CONGELADAS',NULL,NULL,NULL,NULL,'02050000',NULL,'CARNES DE CAVALO,ASININO E MUAR,FRESCAS,REFRIG.OU CONG.'),(115,'0205.00.0300','CARNES DE MUAR,FRESCAS,REFRIGERADAS OU CONGELADAS',NULL,NULL,NULL,NULL,'02050000',NULL,'CARNES DE CAVALO,ASININO E MUAR,FRESCAS,REFRIG.OU CONG.'),(116,'0206.10.0100','CARNES DE CABECA DE BOVINO,FRESCAS OU REFRIGERADAS',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(117,'0206.10.0200','CORACAO DE BOVINO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(118,'0206.10.0300','FIGADO DE BOVINO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(119,'0206.10.0400','LINGUA DE BOVINO,FRESCA OU REFRIGERADA',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(120,'0206.10.0500','RABO DE BOVINO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(121,'0206.10.0600','RIM DE BOVINO,FRESCO OU REFRIGERADO',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(122,'0206.10.9900','OUTS.MIUDOS COMESTIVEIS,DE BOVINO,FRESCOS,REFRIGERADOS',NULL,NULL,NULL,NULL,'02061000',NULL,'MIUDEZAS COMESTIVEIS DE BOVINO,FRESCAS OU REFRIGERADAS'),(123,'0206.21.0000','LINGUAS DE BOVINO,CONGELADAS',NULL,NULL,NULL,NULL,'02062100',NULL,'LINGUAS DE BOVINO,CONGELADAS'),(124,'0206.22.0000','FIGADOS DE BOVINO,CONGELADOS',NULL,NULL,NULL,NULL,'02062200',NULL,'FIGADOS DE BOVINO,CONGELADOS'),(125,'0206.29.0100','CARNES DE CABECA DE BOVINO,CONGELADAS',NULL,NULL,NULL,NULL,'02062990',NULL,'OUTRAS MIUDEZAS COMESTIVEIS DE BOVINO,CONGELADAS'),(126,'0206.29.0200','CORACAO DE BOVINO,CONGELADO',NULL,NULL,NULL,NULL,'02062990',NULL,'OUTRAS MIUDEZAS COMESTIVEIS DE BOVINO,CONGELADAS'),(127,'0206.29.0300','RABO DE BOVINO,CONGELADO',NULL,NULL,NULL,NULL,'02062910',NULL,'RABOS DE BOVINO,CONGELADOS'),(128,'0206.29.0400','RIM DE BOVINO,CONGELADO',NULL,NULL,NULL,NULL,'02062990',NULL,'OUTRAS MIUDEZAS COMESTIVEIS DE BOVINO,CONGELADAS'),(129,'0206.29.9900','OUTS.MIUDOS COMESTIVEIS DE BOVINO,CONGELADOS',NULL,NULL,NULL,NULL,'02062990',NULL,'OUTRAS MIUDEZAS COMESTIVEIS DE BOVINO,CONGELADAS'),(130,'0206.30.0000','MIUDOS COMESTIVEIS DE SUINO,FRESCOS OU REFRIGERADOS',NULL,NULL,NULL,NULL,'02063000',NULL,'MIUDEZAS COMESTIVEIS DE SUINO,FRESCAS OU REFRIGERADAS'),(131,'0206.41.0000','FIGADOS DE SUINO,CONGELADOS',NULL,NULL,NULL,NULL,'02064100',NULL,'FIGADOS DE SUINO,CONGELADOS'),(132,'0206.49.0000','OUTS.MIUDOS COMESTIVEIS,DE SUINO,CONGELADOS',NULL,NULL,NULL,NULL,'02064900',NULL,'OUTRAS MIUDEZAS COMESTIVEIS DE SUINO,CONGELADAS'),(133,'0206.80.0000','MIUDOS COMESTIVEIS,DE OVINO,CAPRINO,ETC.FRESCOS,REFRIG.',NULL,NULL,NULL,NULL,'02068000',NULL,'MIUDEZAS COMESTIVEIS,DE OVINO,ETC.FRESCAS/REFRIGERADAS'),(134,'0206.90.0000','MIUDOS COMESTIVEIS,DE OVINO,CAPRINO,ETC.CONGELADOS',NULL,NULL,NULL,NULL,'02069000',NULL,'MIUDEZAS COMESTIVEIS,DE OVINO,CAPRINO,ETC.CONGELADAS'),(135,'0207.10.0100','CARNES DE GALOS,FRANGOS,GALINHAS,INTEIRAS,FRESCA,REFRIG',NULL,NULL,NULL,NULL,'02071100',NULL,'CARNES DE GALOS/GALINHAS,N/CORT.PEDACOS,FRESCAS/REFRIG.'),(136,'0207.10.9900','CARNES DE OUTS.AVES DOMESTICAS,INTEIRAS,FRESCAS,REFRIG.',NULL,NULL,NULL,NULL,'02072400',NULL,'CARNES DE PERUAS/PERUS,N/CORT.PEDACOS,FRESCAS/REFRIGER.'),(137,'0207.10.9900','CARNES DE OUTS.AVES DOMESTICAS,INTEIRAS,FRESCAS,REFRIG.',NULL,NULL,NULL,NULL,'02073200',NULL,'CARNES DE PATOS,ETC.N/CORT.EM PEDACOS,FRESCAS/REFRIGER.'),(138,'0207.21.0000','CARNES DE GALOS,FRANGOS OU GALINHAS,INTEIRAS,CONGELADAS',NULL,NULL,NULL,NULL,'02071200',NULL,'CARNES DE GALOS/GALINHAS,N/CORTADAS EM PEDACOS,CONGEL.'),(139,'0207.22.0000','CARNES DE PERUS OU PERUAS,INTEIRAS,CONGELADAS',NULL,NULL,NULL,NULL,'02072500',NULL,'CARNES DE PERUAS/PERUS,N/CORTADAS EM PEDACOS,CONGELADAS'),(140,'0207.23.0000','CARNES DE PATOS,GANSOS OU PINTADAS,INTEIRAS,CONGELADAS',NULL,NULL,NULL,NULL,'02073300',NULL,'CARNES DE PATOS,GANSOS,ETC.N/CORT.EM PEDACOS,CONGELADAS'),(141,'0207.31.0000','FIGADOS DE GANSOS OU PATOS,FRESCOS OU REFRIGERADOS',NULL,NULL,NULL,NULL,'02073400',NULL,'FIGADOS GORDOS,DE PATOS/GANSOS/PINTADAS,FRESCOS/REFRIG.'),(142,'0207.39.0100','CARNES DE GALOS,FRANGOS,ETC.EM PEDACOS,FRESCAS,REFRIGER',NULL,NULL,NULL,NULL,'02071300',NULL,'PEDACOS E MIUDEZAS,DE GALOS/GALINHAS,FRESCOS/REFRIGER.'),(143,'0207.39.0200','FIGADOS DE GALOS,FRANGOS,GALINHAS,FRESCOS,REFRIGERADOS',NULL,NULL,NULL,NULL,'02071300',NULL,'PEDACOS E MIUDEZAS,DE GALOS/GALINHAS,FRESCOS/REFRIGER.'),(144,'0207.39.9900','CARNES DE OUTS.AVES DOMEST.EM PEDACOS,FRESCAS,REFRIGER.',NULL,NULL,NULL,NULL,'02071300',NULL,'PEDACOS E MIUDEZAS,DE GALOS/GALINHAS,FRESCOS/REFRIGER.'),(145,'0207.39.9900','CARNES DE OUTS.AVES DOMEST.EM PEDACOS,FRESCAS,REFRIGER.',NULL,NULL,NULL,NULL,'02072600',NULL,'CARNES DE PERUAS/PERUS,EM PEDACOS,MIUDEZ.FRESCOS/REFRIG'),(146,'0207.39.9900','CARNES DE OUTS.AVES DOMEST.EM PEDACOS,FRESCAS,REFRIGER.',NULL,NULL,NULL,NULL,'02073400',NULL,'FIGADOS GORDOS,DE PATOS/GANSOS/PINTADAS,FRESCOS/REFRIG.'),(147,'0207.39.9900','CARNES DE OUTS.AVES DOMEST.EM PEDACOS,FRESCAS,REFRIGER.',NULL,NULL,NULL,NULL,'02073500',NULL,'OUTS.CARNES/MIUDEZAS,DE PATOS,GANSOS,ETC.FRESCAS,REFRIG'),(148,'0207.41.0100','CARNES DE GALOS,FRANGOS,GALINHAS,EM PEDACOS,CONGELADAS',NULL,NULL,NULL,NULL,'02071400',NULL,'PEDACOS E MIUDEZAS,COMEST.DE GALOS/GALINHAS,CONGELADOS'),(149,'0207.41.0200','MIUDOS COMESTIVEIS,DE GALOS,FRANGOS,GALINHAS,CONGELADOS',NULL,NULL,NULL,NULL,'02071400',NULL,'PEDACOS E MIUDEZAS,COMEST.DE GALOS/GALINHAS,CONGELADOS'),(150,'0207.42.0000','CARNES DE PERUS,PERUAS,EM PEDACOS,E MIUDOS,CONGELADOS',NULL,NULL,NULL,NULL,'02072700',NULL,'CARNES DE PERUAS/PERUS,EM PEDACOS E MIUDEZAS,CONGELADAS'),(151,'0207.43.0000','CARNES DE PATOS,GANSOS,EM PEDACOS,E MIUDOS,CONGELADOS',NULL,NULL,NULL,NULL,'02073600',NULL,'OUTRAS CARNES,MIUDEZAS,DE PATOS,GANSOS,ETC.CONGELADAS'),(152,'0207.50.0100','FIGADOS DE GALOS,FRANGOS OU GALINHAS,CONGELADOS',NULL,NULL,NULL,NULL,'02071400',NULL,'PEDACOS E MIUDEZAS,COMEST.DE GALOS/GALINHAS,CONGELADOS'),(153,'0207.50.9900','FIGADOS DE OUTS.AVES DOMESTICAS,CONGELADOS',NULL,NULL,NULL,NULL,'02073600',NULL,'OUTRAS CARNES,MIUDEZAS,DE PATOS,GANSOS,ETC.CONGELADAS'),(154,'0208.10.0000','CARNES DE COELHOS OU LEBRES,FRESCAS,REFRIGERADAS,CONGEL',NULL,NULL,NULL,NULL,'02081000',NULL,'CARNES/MIUDEZAS,DE COELHOS/LEBRES,FRESCAS/REFRIG/CONGEL'),(155,'0208.20.0000','COXAS DE RA,FRESCAS,REFRIGERADAS OU CONGELADAS',NULL,NULL,NULL,NULL,'02082000',NULL,'COXAS DE RA,FRESCAS,REFRIGERADAS OU CONGELADAS'),(156,'0208.90.0000','OUTS.CARNES,MIUDOS COMESTIVEIS,FRESCOS,REFRIGERADOS,ETC',NULL,NULL,NULL,NULL,'02089000',NULL,'CARNES E MIUDEZAS,DE OUTS.ANIMAIS,FRESCOS/REFRIG/CONG.'),(157,'0209.00.0101','TOUCINHO SEM PARTES MAGRAS,FRESCO,REFRIGERADO,CONGELADO',NULL,NULL,NULL,NULL,'02090011',NULL,'TOUCINHO SEM PARTES MAGRAS,FRESCO/REFRIGERADO/CONGELADO'),(158,'0209.00.0102','TOUCINHO SEM PARTES MAGRAS,SALGADO OU EM SALMOURA',NULL,NULL,NULL,NULL,'02090019',NULL,'TOUCINHO SEM PARTES MAGRAS,SALGADO/SALMOURA/SECO/DEFUM.'),(159,'0209.00.0199','QQ.OUT.TOUCINHO,SEM PARTES MAGRAS',NULL,NULL,NULL,NULL,'02090019',NULL,'TOUCINHO SEM PARTES MAGRAS,SALGADO/SALMOURA/SECO/DEFUM.'),(160,'0209.00.0201','GORDURA DE PORCO,N/FUNDIDA,FRESCA,REFRIGERADA,CONGELADA',NULL,NULL,NULL,NULL,'02090021',NULL,'GORDURA DE PORCO,FRESCA,REFRIGERADA OU CONGELADA'),(161,'0209.00.0202','GORDURA DE PORCO,NAO FUNDIDA,SALGADA OU EM SALMOURA',NULL,NULL,NULL,NULL,'02090029',NULL,'GORDURA DE PORCO,N/FUNDIDA,SALGADA,EM SALMOURA,SECA,ETC'),(162,'0209.00.0299','QQ.OUT.GORDURA DE PORCO,NAO FUNDIDA',NULL,NULL,NULL,NULL,'02090029',NULL,'GORDURA DE PORCO,N/FUNDIDA,SALGADA,EM SALMOURA,SECA,ETC'),(163,'0209.00.0301','GORDURA DE AVES,N/FUNDIDA,FRESCA,REFRIGERADA,CONGELADA',NULL,NULL,NULL,NULL,'02090090',NULL,'GORDURA DE AVES,N/FUNDIDA,FRESCA,REFRIGERADA,CONGEL.ETC'),(164,'0209.00.0399','QQ.OUT.GORDURA DE AVES,NAO FUNDIDA',NULL,NULL,NULL,NULL,'02090090',NULL,'GORDURA DE AVES,N/FUNDIDA,FRESCA,REFRIGERADA,CONGEL.ETC'),(165,'0210.11.0100','PRESUNTOS DE SUINO,COM OSSOS,SALGADOS,EM SALMOURA,ETC.',NULL,NULL,NULL,NULL,'02101100',NULL,'PERNAS/PAS/PEDACOS,DE SUINO,N/DESOSSADOS,SALGADOS,ETC.'),(166,'0210.11.9900','OUTS.PERNAS,PAS,PEDACOS,DE SUINO,COM OSSOS,SALGADOS,ETC',NULL,NULL,NULL,NULL,'02101100',NULL,'PERNAS/PAS/PEDACOS,DE SUINO,N/DESOSSADOS,SALGADOS,ETC.'),(167,'0210.12.0101','TOUCINHO COM PARTES MAGRAS,DEFUMADO',NULL,NULL,NULL,NULL,'02101200',NULL,'BARRIGAS E PEITOS,ENTREMEADOS,DE SUINO,SALGADOS,ETC.'),(168,'0210.12.0199','QQ.OUT.TOUCINHO,COM PARTES MAGRAS',NULL,NULL,NULL,NULL,'02101200',NULL,'BARRIGAS E PEITOS,ENTREMEADOS,DE SUINO,SALGADOS,ETC.'),(169,'0210.12.9900','OUTS.BARRIGAS,PEITOS,DE SUINO,SEM OSSOS,SALGADOS,ETC.',NULL,NULL,NULL,NULL,'02101200',NULL,'BARRIGAS E PEITOS,ENTREMEADOS,DE SUINO,SALGADOS,ETC.'),(170,'0210.19.0000','OUTS.CARNES DE SUINO,E MIUDOS COMESTIVEIS,SALGADOS,ETC.',NULL,NULL,NULL,NULL,'02101900',NULL,'OUTS.CARNES DE SUINO,SALGADAS OU EM SALMOURA,SECAS,ETC.'),(171,'0210.20.0100','CHARQUE (CARNE SECA) E CARNE DE SOL,DE BOVINO',NULL,NULL,NULL,NULL,'02102000',NULL,'CARNES DE BOVINOS,SALGADAS/EM SALMOURA/SECAS/DEFUMADAS'),(172,'0210.20.9900','OUTS.CARNES DE BOVINO,E MIUDOS COMESTIVEIS,SALGADOS,ETC',NULL,NULL,NULL,NULL,'02102000',NULL,'CARNES DE BOVINOS,SALGADAS/EM SALMOURA/SECAS/DEFUMADAS'),(173,'0210.90.0100','FIGADOS DE AVES DOMESTICAS,SALGADOS OU EM SALMOURA',NULL,NULL,NULL,NULL,'02109000',NULL,'CARNES E MIUDEZAS,DE OUTROS ANIMAIS,SALGADOS,ETC.'),(174,'0210.90.0201','LINGUAS DE ANIMAIS,SALGADAS,EM SALMOURA,ETC.',NULL,NULL,NULL,NULL,'02109000',NULL,'CARNES E MIUDEZAS,DE OUTROS ANIMAIS,SALGADOS,ETC.'),(175,'0210.90.0299','QQ.OUT.MIUDO COMESTIVEL,DE ANIMAL,SALGADO,EM SALMOURA,',NULL,NULL,NULL,NULL,'02109000',NULL,'CARNES E MIUDEZAS,DE OUTROS ANIMAIS,SALGADOS,ETC.'),(176,'0210.90.0300','PRESUNTOS DE GALOS,GALINHAS,PATOS,ETC.SALGADOS,SALMOURA',NULL,NULL,NULL,NULL,'02109000',NULL,'CARNES E MIUDEZAS,DE OUTROS ANIMAIS,SALGADOS,ETC.'),(177,'0210.90.9900','OUTS.CARNES DE ANIMAIS,SALGADAS,EM SALMOURA,SECAS,ETC.',NULL,NULL,NULL,NULL,'02109000',NULL,'CARNES E MIUDEZAS,DE OUTROS ANIMAIS,SALGADOS,ETC.'),(178,'0301.10.0000','PEIXES VIVOS ORNAMENTAIS',NULL,NULL,NULL,NULL,'03011000',NULL,'PEIXES ORNAMENTAIS,VIVOS'),(179,'0301.91.0100','TRUTAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019110',NULL,'TRUTAS (SALMO TRUTTA E ONCORHYNCHUS),PARA REPRODUCAO'),(180,'0301.91.0100','TRUTAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019190',NULL,'OUTRAS TRUTAS (SALMO TRUTTA E ONCORHYNCHUS),VIVAS'),(181,'0301.91.9900','OUTS.TRUTAS VIVAS',NULL,NULL,NULL,NULL,'03019190',NULL,'OUTRAS TRUTAS (SALMO TRUTTA E ONCORHYNCHUS),VIVAS'),(182,'0301.92.0100','ENGUIAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019210',NULL,'ENGUIAS (ANGUILLA SPP.) PARA REPRODUCAO'),(183,'0301.92.0100','ENGUIAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019290',NULL,'OUTRAS ENGUIAS (ANGUILLA SPP.) VIVAS'),(184,'0301.92.9900','OUTS.ENGUIAS VIVAS',NULL,NULL,NULL,NULL,'03019290',NULL,'OUTRAS ENGUIAS (ANGUILLA SPP.) VIVAS'),(185,'0301.93.0100','CARPAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019310',NULL,'CARPAS PARA REPRODUCAO'),(186,'0301.93.0100','CARPAS PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019390',NULL,'OUTRAS CARPAS VIVAS'),(187,'0301.93.9900','OUTS.CARPAS VIVAS',NULL,NULL,NULL,NULL,'03019390',NULL,'OUTRAS CARPAS VIVAS'),(188,'0301.99.0100','OUTS.PEIXES PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019910',NULL,'OUTROS PEIXES PARA REPRODUCAO'),(189,'0301.99.0100','OUTS.PEIXES PARA REPRODUCAO OU CRIACAO',NULL,NULL,NULL,NULL,'03019990',NULL,'OUTROS PEIXES VIVOS'),(190,'0301.99.9900','OUTS.PEIXES VIVOS',NULL,NULL,NULL,NULL,'03019990',NULL,'OUTROS PEIXES VIVOS'),(191,'0302.11.0000','TRUTAS FRESCAS OU REFRIGER.EXC.FILES,OUTS.CARNES,ETC.',NULL,NULL,NULL,NULL,'03021100',NULL,'TRUTAS FRESCAS,REFRIG.EXC.FILES,OUTS.CARNES,FIGADOS,ETC'),(192,'0302.12.0000','SALMOES-DO-PACIFICO,ETC.FRESCOS,REFRIGER.EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03021200',NULL,'SALMOES-DO-PACIFICO,ETC.FRESCOS,REFRIG.EXC.FILES,ETC.'),(193,'0302.19.0000','OUTS.SALMONIDEOS FRESCOS OU REFRIGERADOS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03021900',NULL,'OUTROS SALMONIDEOS FRESCOS,REFRIG.EXC.FILES,ETC.'),(194,'0302.21.0000','LINGUADOS-GIGANTES FRESCOS,REFRIGERADOS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03022100',NULL,'LINGUADOS-GIGANTES,FRESCOS,REFRIG.EXC.FILES,ETC.'),(195,'0302.22.0000','SOLHAS OU PATRUCAS,FRESCAS,REFRIGERADAS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03022200',NULL,'SOLHAS OU PATRUCAS,FRESCAS,REFRIG.EXC.FILES,ETC.'),(196,'0302.23.0000','LINGUADOS FRESCOS OU REFRIGER.EXC.FILES,OUTS.CARNES,ETC',NULL,NULL,NULL,NULL,'03022300',NULL,'LINGUADOS FRESCOS,REFRIG.EXC.FILES,OUTRAS CARNES,ETC.'),(197,'0302.29.0000','OUTS.PEIXES CHATOS,FRESCOS OU REFRIGER.EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03022900',NULL,'OUTROS PEIXES CHATOS,FRESCOS,REFRIG.EXC.FILES,ETC.'),(198,'0302.31.0000','ATUNS-BRANCOS FRESCOS OU REFRIGERADOS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03023100',NULL,'ATUNS-BRANCOS OU GERMOES,FRESCOS/REFRIGER.EXC.FILES,ETC'),(199,'0302.32.0000','ALBACORAS FRESCAS OU REFRIGERADAS,EXC.FILES,OUTS.CARNES',NULL,NULL,NULL,NULL,'03023200',NULL,'ALBACORAS/ATUNS BARBAT.AMARELA,FRESCAS/REFRIG.EXC.FILES'),(200,'0302.33.0000','BONITOS-LISTRADOS FRESCOS OU REFRIGERADOS,EXC.FILES,ETC',NULL,NULL,NULL,NULL,'03023300',NULL,'BONITOS-LISTRADOS,ETC.FRESCOS,REFRIG.EXC.FILES,ETC.'),(201,'0302.39.0000','OUTS.ATUNS,BONITOS,FRESCOS,REFRIGERADOS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03023900',NULL,'OUTROS ATUNS FRESCOS,REFRIG.EXC.FILES,OUTS.CARNES,ETC.'),(202,'0302.40.0000','ARENQUES FRESCOS OU REFRIGERADOS,EXC.FILES,OUTS.CARNES',NULL,NULL,NULL,NULL,'03024000',NULL,'ARENQUES FRESCOS/REFRIGERADOS,EXC.FILES,OUTS.CARNES,ETC'),(203,'0302.50.0000','BACALHAUS FRESCOS OU REFRIGERADOS,EXC.FILES,OUTS.CARNES',NULL,NULL,NULL,NULL,'03025000',NULL,'BACALHAUS (GADUS) FRESCOS/REFRIGERADOS,EXC.FILES,ETC.'),(204,'0302.61.0000','SARDINHA FRESCA OU REFRIGER.EXC.FILES,OUTS.CARNES,ETC.',NULL,NULL,NULL,NULL,'03026100',NULL,'SARDINHAS,SARDINELAS,ETC.FRESCAS,REFRIG.EXC.FILES,ETC.'),(205,'0302.62.0000','\"HADDOCKS\" FRESCOS,REFRIGERADOS,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026200',NULL,'HADDOCKS FRESCOS OU REFRIG.EXC.FILES,OUTRAS CARNES,ETC.'),(206,'0302.63.0000','PEIXES-CARVAO FRESCOS,REFRIGER.EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026300',NULL,'PEIXES-CARVAO FRESCOS,REFRIG.EXC.FILES,OUTS.CARNES,ETC.'),(207,'0302.64.0000','CAVALAS,ETC.FRESCAS,REFRIG.EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026400',NULL,'CAVALAS,CAVALINHAS,ETC.FRESCAS,REFRIG.EXC.FILES,ETC.'),(208,'0302.65.0000','ESQUALOS FRESCOS,REFRIGERADOS,EXC.FILES,OUTS.CARNES',NULL,NULL,NULL,NULL,'03026500',NULL,'ESQUALOS FRESCOS,REFRIG.EXC.FILES,OUTRAS CARNES,ETC.'),(209,'0302.66.0000','ENGUIAS FRESCAS,REFRIGERADAS,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026600',NULL,'ENGUIAS FRESCAS,REFRIG.EXC.FILES,OUTRAS CARNES,ETC.'),(210,'0302.69.0100','CORVINA FRESCA,REFRIGERADA,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026990',NULL,'OUTROS PEIXES FRESCOS,REFRIG.EXC.FILES,OUTS.CARNES,ETC.'),(211,'0302.69.0200','MERLUZA FRESCA,REFRIGERADA,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026910',NULL,'MERLUZAS FRESCAS,REFRIG.EXC.FILES,OUTRAS CARNES,ETC.'),(212,'0302.69.0300','PESCADA FRESCA OU REFRIGERADA,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026990',NULL,'OUTROS PEIXES FRESCOS,REFRIG.EXC.FILES,OUTS.CARNES,ETC.'),(213,'0302.69.9900','OUTS.PEIXES FRESCOS,REFRIG.EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03026990',NULL,'OUTROS PEIXES FRESCOS,REFRIG.EXC.FILES,OUTS.CARNES,ETC.'),(214,'0302.70.0000','FIGADOS,SEMEN E OVAS,DE PEIXES,FRESCOS OU REFRIGERADOS',NULL,NULL,NULL,NULL,'03027000',NULL,'FIGADOS,OVAS E SEMEN,DE PEIXES,FRESCOS OU REFRIGERADOS'),(215,'0303.10.0000','SALMOES-DO-PACIFICO CONGELADOS,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03031000',NULL,'SALMOES-DO-PACIFICO,CONGELADOS,EXC.FILES,ETC.'),(216,'0303.21.0000','TRUTAS CONGELADAS,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03032100',NULL,'TRUTAS (SALMO TRUTTA,ETC.) CONGELADAS,EXC.FILES,ETC.'),(217,'0303.22.0000','SALMOES-DO-ATLANTICO,ETC.CONGELADOS,EXC.FILES,ETC.',NULL,NULL,NULL,NULL,'03032200',NULL,'SALMOES-DO-ATLANTICO E DANUBIO,CONGELADOS,EXC.FILES,ETC'),(218,'0303.29.0000','OUTS.SALMONIDEOS CONGELADOS,EXC.FILES E OUTS.CARNES',NULL,NULL,NULL,NULL,'03032900',NULL,'OUTROS SALMONIDEOS CONGELADOS,EXC.FILES,OUTS.CARNES,ETC'),(219,'0303.31.0000','LINGUADOS-GIGANTES CONGELADOS,EXC.FILE/FIGADO/OVAS/ETC.',NULL,NULL,NULL,NULL,'03033100',NULL,'LINGUADOS-GIGANTES CONGELADOS,EXC.FILES.OUTS.CARNES,ETC'),(220,'0303.32.0000','SOLHAS/PATRUCAS,CONGELADAS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03033200',NULL,'SOLHAS OU PATRUCAS,CONGELADAS,EXC.FILES,OUTS.CARNES,ETC'),(221,'0303.33.0000','LINGUADOS CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03033300',NULL,'LINGUADOS CONGELADOS,EXC.FILES,OUTS.CARNES,FIGADOS,ETC.'),(222,'0303.39.0000','OUTS.PEIXES CHATOS,CONGELADOS,EXC.FILE/FIGADO/OVAS/ETC.',NULL,NULL,NULL,NULL,'03033900',NULL,'OUTS.PEIXES CHATOS,CONGELADOS,EXC.FILES,OUTS.CARNES,ETC'),(223,'0303.41.0000','ATUNS-BRANCOS/ETC.CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03034100',NULL,'ATUNS-BRANCOS OU GERMOES,CONGELADOS,EXC.FILES,ETC.'),(224,'0303.42.0000','ALBACORAS/ETC.CONGELADAS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03034200',NULL,'ALBACORAS/ATUNS BARBAT.AMARELA,CONGELADAS,EXC.FILES,ETC'),(225,'0303.43.0000','BONITOS-LISTRADOS/ETC.CONGELADOS,EXC.FILE/FIGADO/OVAS/',NULL,NULL,NULL,NULL,'03034300',NULL,'BONITOS-LISTRADOS,ETC.CONGELADOS,EXC.FILES,ETC.'),(226,'0303.49.0000','OUTS.ATUNS/BONITOS,CONGELADOS,EXC.FILE/FIGADO/OVAS/ETC.',NULL,NULL,NULL,NULL,'03034900',NULL,'OUTS.ATUNS CONGELADOS,EXC.FILES,OUTS.CARNES,FIGADOS,ETC'),(227,'0303.50.0000','ARENQUES CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03035000',NULL,'ARENQUES CONGELADOS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC'),(228,'0303.60.0000','BACALHAUS CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03036000',NULL,'BACALHAUS (GADUS) CONGELADOS,EXC.FILES,OUTS.CARNES,ETC.'),(229,'0303.71.0000','SARDINHA/ETC.CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037100',NULL,'SARDINHAS,SARDINELAS,ETC.CONGELADAS,EXC.FILES,ETC.'),(230,'0303.72.0000','HADDOCKS CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037200',NULL,'HADDOCKS CONGELADOS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC'),(231,'0303.73.0000','PEIXES-CARVAO CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037300',NULL,'PEIXES-CARVAO CONGELADOS,EXC.FILES,OUTRAS CARNES,ETC.'),(232,'0303.74.0000','CAVALAS/ETC.CONGELADAS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037400',NULL,'CAVALAS,CAVALINHAS E SARDAS,CONGELADAS,EXC.FILES,ETC.'),(233,'0303.75.0000','ESQUALOS CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037500',NULL,'ESQUALOS CONGELADOS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC'),(234,'0303.76.0000','ENGUIAS CONGELADAS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037600',NULL,'ENGUIAS CONGELADAS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC.'),(235,'0303.77.0000','PERCAS (ROBALOS/BAILAS) CONGELADAS,EXC.FILE/FIGADO/ETC.',NULL,NULL,NULL,NULL,'03037700',NULL,'PERCAS (ROBALOS E BAILAS) CONGELADAS,EXC.FILES,ETC.'),(236,'0303.78.0000','MERLUZAS/ETC.CONGELADAS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037800',NULL,'MERLUZAS E ABROTEAS,CONGELADAS,EXC.FILES,ETC.'),(237,'0303.79.0100','CASTANHA (PEIXE) CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037990',NULL,'OUTROS PEIXES CONGELADOS,EXC.FILES,OUTROS CARNES,ETC.'),(238,'0303.79.0200','CORVINA CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037910',NULL,'CORVINAS CONGELADAS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC'),(239,'0303.79.0300','PARGO-ROSA CONGELADO,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037990',NULL,'OUTROS PEIXES CONGELADOS,EXC.FILES,OUTROS CARNES,ETC.'),(240,'0303.79.0400','PESCADA CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037920',NULL,'PESCADAS CONGELADAS,EXC.FILES,OUTRAS CARNES,FIGADOS,ETC'),(241,'0303.79.0500','PIRAMUTABA CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037990',NULL,'OUTROS PEIXES CONGELADOS,EXC.FILES,OUTROS CARNES,ETC.'),(242,'0303.79.0600','TAMUATA CONGELADA,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037990',NULL,'OUTROS PEIXES CONGELADOS,EXC.FILES,OUTROS CARNES,ETC.'),(243,'0303.79.9900','OUTS.PEIXES CONGELADOS,EXC.FILE/FIGADO/OVAS/SEMEN',NULL,NULL,NULL,NULL,'03037990',NULL,'OUTROS PEIXES CONGELADOS,EXC.FILES,OUTROS CARNES,ETC.'),(244,'0303.80.0000','FIGADOS/SEMEN/OVAS,DE PEIXES,CONGELADOS',NULL,NULL,NULL,NULL,'03038000',NULL,'FIGADOS,OVAS E SEMEN,DE PEIXES,CONGELADOS'),(245,'0304.10.0000','FILES/OUTS.CARNES DE PEIXES,FRESCOS/REFRIGERADOS',NULL,NULL,NULL,NULL,'03041000',NULL,'FILES E OUTRAS CARNES DE PEIXES,FRESCOS OU REFRIGERAD.'),(246,'0304.20.0100','FILES DE CORVINA,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(247,'0304.20.0200','FILES DE DOURADO,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(248,'0304.20.0300','FILES DE MERLUZA,CONGELADOS',NULL,NULL,NULL,NULL,'03042010',NULL,'FILES DE MERLUZAS,CONGELADOS'),(249,'0304.20.0400','FILES DE PARGO-ROSA,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(250,'0304.20.0500','FILES DE PESCADA,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(251,'0304.20.0600','FILES DE PIRAMUTABA,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(252,'0304.20.9900','OUTS.FILES DE PEIXES,CONGELADOS',NULL,NULL,NULL,NULL,'03042090',NULL,'FILES DE OUTROS PEIXES,CONGELADOS'),(253,'0304.90.0100','OUTS.CARNES DE CORVINA,FRESCAS/REFRIGERADAS/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(254,'0304.90.0200','OUTS.CARNES DE DOURADO,FRESCAS/REFRIGERADAS/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(255,'0304.90.0300','OUTS.CARNES DE MERLUZA,FRESCAS/REFRIGERADAS/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(256,'0304.90.0400','OUTS.CARNES DE PARGO-ROSA,FRESCAS/REFRIG/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(257,'0304.90.0500','OUTS.CARNES DE PESCADA,FRESCAS/REFRIGERADAS/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(258,'0304.90.0600','OUTS.CARNES DE PIRAMUTABA,FRESCAS/REFRIG/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(259,'0304.90.9900','OUTS.CARNES DE PEIXES,FRESCAS/REFRIGERADAS/CONGELADAS',NULL,NULL,NULL,NULL,'03049000',NULL,'OUTRAS CARNES DE PEIXES,CONGELADAS'),(260,'0305.10.0000','FARINHAS/POS/ETC.DE PEIXES,P/ALIMENTACAO HUMANA',NULL,NULL,NULL,NULL,'03051000',NULL,'FARINHAS,POS E \"PELLETS\" DE PEIXES,P/ALIMENTACAO HUMANA'),(261,'0305.20.0100','OVAS DE PEIXES,SECAS/DEFUMADAS/SALGADAS/EM SALMOURA',NULL,NULL,NULL,NULL,'03052000',NULL,'FIGADOS,OVAS E SEMEN,DE PEIXES,SECOS,DEFUMADOS,ETC.'),(262,'0305.20.9900','FIGADOS/SEMEN,DE PEIXES,SECOS/DEFUMADOS/SALGADOS/ETC.',NULL,NULL,NULL,NULL,'03052000',NULL,'FIGADOS,OVAS E SEMEN,DE PEIXES,SECOS,DEFUMADOS,ETC.'),(263,'0305.30.0100','FILES DE BACALHAUS,SECOS/SALGADOS/SALMOURA,N/DEFUMADOS',NULL,NULL,NULL,NULL,'03053000',NULL,'FILES DE PEIXES,SECOS,SALGADOS,EM SALMOURA,N/DEFUMADOS'),(264,'0305.30.9900','OUTS.FILES DE PEIXES,SECOS/SALGADOS/SALMOURA,N/DEFUMADO',NULL,NULL,NULL,NULL,'03053000',NULL,'FILES DE PEIXES,SECOS,SALGADOS,EM SALMOURA,N/DEFUMADOS'),(265,'0305.41.0000','SALMOES-DO-PACIFICO/ETC.DEFUMADOS,MESMO EM FILES',NULL,NULL,NULL,NULL,'03054100',NULL,'SALMOES-DO-PACIFICO,DO ATLANTICO E DO DANUBIO,DEFUMADOS'),(266,'0305.42.0000','ARENQUES DEFUMADOS,MESMO EM FILES',NULL,NULL,NULL,NULL,'03054200',NULL,'ARENQUES DEFUMADOS,MESMO EM FILES'),(267,'0305.49.0100','BACALHAUS DEFUMADOS,MESMO EM FILES',NULL,NULL,NULL,NULL,'03054910',NULL,'BACALHAUS (GADUS) DEFUMADOS,MESMO EM FILES'),(268,'0305.49.9900','OUTS.PEIXES DEFUMADOS,MESMO EM FILES',NULL,NULL,NULL,NULL,'03054990',NULL,'OUTROS PEIXES DEFUMADOS,MESMO EM FILES'),(269,'0305.51.0000','BACALHAUS SECOS,MESMO SALGADOS,NAO DEFUMADOS',NULL,NULL,NULL,NULL,'03055100',NULL,'BACALHAUS (GADUS) SECOS,MESMO SALGADOS MAS N/DEFUMADOS'),(270,'0305.59.0100','ANCHOVA SECA,MESMO SALGADA,NAO DEFUMADA',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(271,'0305.59.0200','MERLUZA SECA,MESMO SALGADA,NAO DEFUMADA',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(272,'0305.59.0300','SARDINHA SECA,MESMO SALGADA,NAO DEFUMADA',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(273,'0305.59.0400','CACAO SECO,MESMO SALGADO,NAO DEFUMADO',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(274,'0305.59.0500','PEIXES EM POSTAS,SECOS,MESMO SALGADOS,NAO DEFUMADOS',NULL,NULL,NULL,NULL,'03055910',NULL,'BACALHAUS POLARES,LINGS,ZARBOS,ETC.SECOS,NAO DEFUMADOS'),(275,'0305.59.0500','PEIXES EM POSTAS,SECOS,MESMO SALGADOS,NAO DEFUMADOS',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(276,'0305.59.9901','BARBATANAS DE TUBARAO,SECAS,MESMO SALGADAS,N/DEFUMADAS',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(277,'0305.59.9999','QQ.OUT.PEIXE SECO,MESMO SALGADO,MAS N/DEFUMADO',NULL,NULL,NULL,NULL,'03055910',NULL,'BACALHAUS POLARES,LINGS,ZARBOS,ETC.SECOS,NAO DEFUMADOS'),(278,'0305.59.9999','QQ.OUT.PEIXE SECO,MESMO SALGADO,MAS N/DEFUMADO',NULL,NULL,NULL,NULL,'03055990',NULL,'OUTROS PEIXES SECOS,MESMO SALGADOS MAS NAO DEFUMADOS'),(279,'0305.61.0000','ARENQUES SALGADOS,N/SECOS,N/DEFUMADOS,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056100',NULL,'ARENQUES SALGADOS,NAO SECOS,NAO DEFUMADOS E EM SALMOURA'),(280,'0305.62.0100','BACALHAUS EM POSTAS,SALGADAS,N/SECOS,N/DEFUM.E SALMOURA',NULL,NULL,NULL,NULL,'03056200',NULL,'BACALHAUS (GADUS) SALGADOS,N/SECOS,N/DEFUMADOS,SALMOURA'),(281,'0305.62.9900','OUTS.BACALHAUS SALGADOS,N/SECOS,N/DEFUMADOS,E SALMOURA',NULL,NULL,NULL,NULL,'03056200',NULL,'BACALHAUS (GADUS) SALGADOS,N/SECOS,N/DEFUMADOS,SALMOURA'),(282,'0305.63.0000','ANCHOVAS SALGADAS,N/SECAS,N/DEFUMADAS,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056300',NULL,'ANCHOVAS SALGADAS,NAO SECAS,NAO DEFUMADAS E EM SALMOURA'),(283,'0305.69.0100','MERLUZA SALGADA,N/SECA,N/DEFUMADA,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(284,'0305.69.0200','SARDINHA SALGADA,N/SECA,N/DEFUMADA,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(285,'0305.69.0301','CAUDAS DE CACAO,SALGADAS,N/SECAS,N/DEFUM.E EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(286,'0305.69.0399','QQ.OUT.CACAO,SALGADO,N/SECO,N/DEFUMADO,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(287,'0305.69.0401','BARBATANAS DE TUBARAO,SALGADAS,N/SECAS,N/DEFUM.SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(288,'0305.69.0499','QQ.OUT.TUBARAO SALGADO,N/SECO,N/DEFUMADO,E EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(289,'0305.69.9900','OUTS.PEIXES SALGADOS,N/SECOS,N/DEFUM.PEIXES EM SALMOURA',NULL,NULL,NULL,NULL,'03056900',NULL,'OUTROS PEIXES SALGADOS,N/SECOS,N/DEFUMAD. E EM SALMOURA'),(290,'0306.11.0000','LAGOSTAS (PALINURUS/PANULIRUS/JASUS SPP),CONGELADAS',NULL,NULL,NULL,NULL,'03061100',NULL,'LAGOSTAS (PALINURUS,PANULIRUS E JASUS) CONGELADAS'),(291,'0306.12.0000','LAVAGANTES (\"HOMARDS\")(HOMARUS SPP),CONGELADOS',NULL,NULL,NULL,NULL,'03061200',NULL,'LAVAGANTES (\"HOMARDS\")(HOMARUS SPP) CONGELADOS'),(292,'0306.13.0000','CAMAROES CONGELADOS',NULL,NULL,NULL,NULL,'03061300',NULL,'CAMAROES CONGELADOS'),(293,'0306.14.0000','CARANGUEJOS CONGELADOS',NULL,NULL,NULL,NULL,'03061400',NULL,'CARANGUEJOS CONGELADOS'),(294,'0306.19.0000','OUTS.CRUSTACEOS CONGELADOS,INCL.FARINHAS,P/ALIM.HUMANA',NULL,NULL,NULL,NULL,'03061900',NULL,'OUTS.CRUSTACEOS CONGEL.INCL.FARINHAS,ETC.P/ALIM.HUMANA'),(295,'0306.21.0000','LAGOSTAS (PALINURUS/PANULIRUS/JASUS SPP),NAO CONGELADAS',NULL,NULL,NULL,NULL,'03062100',NULL,'LAGOSTAS (PALINURUS,PANULIRUS E JASUS) NAO CONGELADAS'),(296,'0306.22.0000','LAVAGANTES (\"HOMARDS\")(HOMARUS SPP),NAO CONGELADOS',NULL,NULL,NULL,NULL,'03062200',NULL,'LAVAGANTES (\"HOMARDS\")(HOMARUS SPP) NAO CONGELADOS'),(297,'0306.23.0000','CAMAROES NAO CONGELADOS',NULL,NULL,NULL,NULL,'03062300',NULL,'CAMAROES NAO CONGELADOS'),(298,'0306.24.0000','CARANGUEJOS NAO CONGELADOS',NULL,NULL,NULL,NULL,'03062400',NULL,'CARANGUEJOS NAO CONGELADOS'),(299,'0306.29.0101','FARINHAS DE CRUSTACEOS,P/ALIMENTACAO HUMANA',NULL,NULL,NULL,NULL,'03062900',NULL,'OUTS.CRUSTACEOS NAO CONGEL.INCL.FARINHAS P/ALIM.HUMANA'),(300,'0306.29.0102','POS E \"PELLETS\" DE CRUSTACEOS,P/ALIMENTACAO HUMANA',NULL,NULL,NULL,NULL,'03062900',NULL,'OUTS.CRUSTACEOS NAO CONGEL.INCL.FARINHAS P/ALIM.HUMANA'),(301,'0306.29.9900','OUTS.CRUSTACEOS NAO CONGELADOS',NULL,NULL,NULL,NULL,'03062900',NULL,'OUTS.CRUSTACEOS NAO CONGEL.INCL.FARINHAS P/ALIM.HUMANA'),(302,'0307.10.0000','OSTRAS',NULL,NULL,NULL,NULL,'03071000',NULL,'OSTRAS VIVAS,FRESCAS,REFRIGERADAS,CONGELADAS,SECAS,ETC.'),(303,'0307.21.0000','VIEIRAS/OUTS.MARISCOS VIVOS,FRESCOS/REFRIGERADOS',NULL,NULL,NULL,NULL,'03072100',NULL,'VIEIRAS,OUTS.MARISCOS (PECTEN,ETC) VIVOS,FRESCOS,REFRIG'),(304,'0307.29.0000','VIEIRAS/OUTS.MARISCOS,CONGELADOS/SECOS/SALGADOS/ETC.',NULL,NULL,NULL,NULL,'03072900',NULL,'VIEIRAS,OUTS.MARISCOS (PECTEN,ETC) CONGELADOS,SECOS,ETC'),(305,'0307.31.0000','MEXILHOES VIVOS,FRESCOS/REFRIGERADOS',NULL,NULL,NULL,NULL,'03073100',NULL,'MEXILHOES (MYTILUS,PERNA) VIVOS,FRESCOS,REFRIGERAOS'),(306,'0307.39.0000','MEXILHOES CONGELADOS/SECOS/SALGADOS/EM SALMOURA',NULL,NULL,NULL,NULL,'03073900',NULL,'MEXILHOES (MYTILUS,PERNA) CONGELADOS,SECOS,SALGADOS,ETC'),(307,'0307.41.0000','SIBAS E SEPIOLAS VIVAS,FRESCAS/REFRIGERADAS',NULL,NULL,NULL,NULL,'03074100',NULL,'SIBAS,SEPIOLAS,POTAS E LULAS,VIVOS,FRESCOS,REFRIGERADOS'),(308,'0307.49.0100','CALAMAR OU LULA,CONGELADOS',NULL,NULL,NULL,NULL,'03074911',NULL,'POTAS E LULAS (OMMASTREPHES,LOLIGO,ETC),CONGELADOS'),(309,'0307.49.0100','CALAMAR OU LULA,CONGELADOS',NULL,NULL,NULL,NULL,'03074919',NULL,'SIBAS (CHOCOS)(ETC) E SEPIOLAS,CONGELADOS'),(310,'0307.49.9900','OUTS.SIBAS,SEPIOLAS E LULAS,CONGELADAS',NULL,NULL,NULL,NULL,'03074911',NULL,'POTAS E LULAS (OMMASTREPHES,LOLIGO,ETC),CONGELADOS'),(311,'0307.49.9900','OUTS.SIBAS,SEPIOLAS E LULAS,CONGELADAS',NULL,NULL,NULL,NULL,'03074919',NULL,'SIBAS (CHOCOS)(ETC) E SEPIOLAS,CONGELADOS'),(312,'0307.49.9900','OUTS.SIBAS,SEPIOLAS E LULAS,CONGELADAS',NULL,NULL,NULL,NULL,'03074920',NULL,'SIBAS,SEPIOLAS,POTAS E LULAS,SECOS,SALGADOS,EM SALMOURA'),(313,'0307.51.0000','POLVOS (OCTOPUS SPP) VIVOS,FRESCOS OU REFRIGERADOS',NULL,NULL,NULL,NULL,'03075100',NULL,'POLVOS (OCTOPUS SPP) VIVOS,FRESCOS OU REFRIGERADOS'),(314,'0307.59.0100','POLVOS (OCTOPUS SPP) CONGELADOS',NULL,NULL,NULL,NULL,'03075910',NULL,'POLVOS (OCTOPUS SPP) CONGELADOS'),(315,'0307.59.9900','POLVOS (OCTOPUS SPP) SECOS/SALGADOS/EM SALMOURA',NULL,NULL,NULL,NULL,'03075920',NULL,'POLVOS (OCTOPUS SPP) SECOS,SALGADOS OU EM SALMOURA'),(316,'0307.60.0000','CARACOIS,EXC.OS DO MAR',NULL,NULL,NULL,NULL,'03076000',NULL,'CARACOIS,EXC.OS DO MAR,VIVOS,FRESCOS,REFRIGERADOS,ETC.'),(317,'0307.91.0000','OUTS.MOLUSCOS/ETC.VIVOS/FRESCOS/REFRIGERADOS',NULL,NULL,NULL,NULL,'03079100',NULL,'OUTROS MOLUSCOS,INVERTEBR.AQUATIC.VIVOS,FRESCOS,REFRIG.'),(318,'0307.99.0101','MIUDOS COMESTIV.DE INVERTEBRADOS AQUATICOS,CONGELADOS',NULL,NULL,NULL,NULL,'03079900',NULL,'OUTROS MOLUSCOS,INVERTEBR.AQUATIC.CONGELADOS,SECOS,ETC.'),(319,'0307.99.0102','MIUDOS COMESTIV.DE INVERTEBRADOS AQUATICOS,SECOS/ETC.',NULL,NULL,NULL,NULL,'03079900',NULL,'OUTROS MOLUSCOS,INVERTEBR.AQUATIC.CONGELADOS,SECOS,ETC.'),(320,'0307.99.9900','OUTS.MOLUSCOS/ETC.INCL.FARINHA,P/ALIMENTACAO HUMANA',NULL,NULL,NULL,NULL,'03079900',NULL,'OUTROS MOLUSCOS,INVERTEBR.AQUATIC.CONGELADOS,SECOS,ETC.'),(321,'0401.10.0000','LEITE/CREME DE LEITE,N/CONCENTRADO,N/ADOCICADO,GORD<=1%',NULL,NULL,NULL,NULL,'04011010',NULL,'LEITE UHT,CONT.MATERIA GORDA<=1%,NAO CONCENTRADO,N/ADOC'),(322,'0401.10.0000','LEITE/CREME DE LEITE,N/CONCENTRADO,N/ADOCICADO,GORD<=1%',NULL,NULL,NULL,NULL,'04011090',NULL,'OUTS.LEITES E CREMES,MATER.GORDA<=1%,N/CONCENTR.N/ADOC.'),(323,'0401.20.0000','LEITE/CREME DE LEITE,N/CONCENTRADO,N/ADOCIC.1%<GORD<=6%',NULL,NULL,NULL,NULL,'04012010',NULL,'LEITE UHT,1%<MATERIA GORDA<=6%,NAO CONCENTRADO,N/ADOC.'),(324,'0401.20.0000','LEITE/CREME DE LEITE,N/CONCENTRADO,N/ADOCIC.1%<GORD<=6%',NULL,NULL,NULL,NULL,'04012090',NULL,'OUTS.LEITES E CREMES,1%<MAT.GORDA<=6%,N/CONCENTR.N/ADOC'),(325,'0401.30.0100','LEITE N/CONCENTRADO,N/ADOCICADO,TEOR DE GORDURA>6%',NULL,NULL,NULL,NULL,'04013010',NULL,'LEITE CONT.MATERIA GORDA>6%,NAO CONCENTRADO,N/ADOCICADO'),(326,'0401.30.0200','CREME DE LEITE,N/CONCENTRADO,N/ADOCICADO,GORDURA>6%',NULL,NULL,NULL,NULL,'04013021',NULL,'CREME DE LEITE,UHT,MATERIA GORDA>6%,NAO CONCENTR.N/ADOC'),(327,'0401.30.0200','CREME DE LEITE,N/CONCENTRADO,N/ADOCICADO,GORDURA>6%',NULL,NULL,NULL,NULL,'04013029',NULL,'OUTROS CREMES DE LEITE,MATER.GORDA>6%,N/CONCENTR.N/ADOC'),(328,'0402.10.0100','LEITE EM PO DESNATADO,GORDURA<=1,5%,EXC.P/ALIM.INFANTIL',NULL,NULL,NULL,NULL,'04021010',NULL,'LEITE EM PO,MAT.GORDA<=1,5%,ARSENIO<5PPM,CONCENTR.ADOC.'),(329,'0402.10.0100','LEITE EM PO DESNATADO,GORDURA<=1,5%,EXC.P/ALIM.INFANTIL',NULL,NULL,NULL,NULL,'04021090',NULL,'OUTS.LEITES,CREMES,EM PO,MAT.GORDA<=1,5%,CONCENTR.ADOC.'),(330,'0402.10.0200','LEITE EM PO DESNATADO,GORDURA<=1,5%,P/USO INDUSTRIAL',NULL,NULL,NULL,NULL,'04021010',NULL,'LEITE EM PO,MAT.GORDA<=1,5%,ARSENIO<5PPM,CONCENTR.ADOC.'),(331,'0402.10.0200','LEITE EM PO DESNATADO,GORDURA<=1,5%,P/USO INDUSTRIAL',NULL,NULL,NULL,NULL,'04021090',NULL,'OUTS.LEITES,CREMES,EM PO,MAT.GORDA<=1,5%,CONCENTR.ADOC.'),(332,'0402.10.9900','OUTS.LEITES/CREMES DE LEITE,EM PO,CONCENTR.GORD<=1,5%',NULL,NULL,NULL,NULL,'04021010',NULL,'LEITE EM PO,MAT.GORDA<=1,5%,ARSENIO<5PPM,CONCENTR.ADOC.'),(333,'0402.10.9900','OUTS.LEITES/CREMES DE LEITE,EM PO,CONCENTR.GORD<=1,5%',NULL,NULL,NULL,NULL,'04021090',NULL,'OUTS.LEITES,CREMES,EM PO,MAT.GORDA<=1,5%,CONCENTR.ADOC.'),(334,'0402.21.0101','LEITE EM PO INTEGRAL,GORDURA>=26%,N/ADOCICADO',NULL,NULL,NULL,NULL,'04022110',NULL,'LEITE INTEGRAL,EM PO,MATERIA GORDA>1.5%,CONCENTR.N/ADOC'),(335,'0402.21.0102','LEITE EM PO DESNATURADO,GORDURA< 26%,N/ADOCICADO',NULL,NULL,NULL,NULL,'04022120',NULL,'LEITE PARC.DESNAT.EM PO,MAT.GORDA>1.5%,CONCENTR.N/ADOC.'),(336,'0402.21.0103','LEITE EM PO DESNATURADO,GORDURA> 1.5%,P/USO INDUSTRIAL',NULL,NULL,NULL,NULL,'04022120',NULL,'LEITE PARC.DESNAT.EM PO,MAT.GORDA>1.5%,CONCENTR.N/ADOC.'),(337,'0402.21.0199','QQ.OUT.LEITE EM PO,GORDURA>1.5%,N/ADOCICADO',NULL,NULL,NULL,NULL,'04022110',NULL,'LEITE INTEGRAL,EM PO,MATERIA GORDA>1.5%,CONCENTR.N/ADOC'),(338,'0402.21.0199','QQ.OUT.LEITE EM PO,GORDURA>1.5%,N/ADOCICADO',NULL,NULL,NULL,NULL,'04022120',NULL,'LEITE PARC.DESNAT.EM PO,MAT.GORDA>1.5%,CONCENTR.N/ADOC.'),(339,'0402.21.0200','CREME DE LEITE,EM PO,CONCENTRADO,N/ADOCICADO,GORD> 1.5%',NULL,NULL,NULL,NULL,'04022130',NULL,'CREME DE LEITE,EM PO,MATERIA GORDA>1.5%,CONCENTR.N/ADOC'),(340,'0402.29.0101','LEITE EM PO INTEGRAL,GORDURA>=26%,ADOCICADO',NULL,NULL,NULL,NULL,'04022910',NULL,'LEITE INTEGRAL,EM PO,ETC.MATERIA GORDA>1.5%,ADOCICADO'),(341,'0402.29.0102','LEITE EM PO DESNATURADO,GORDURA< 26%,ADOCICADO',NULL,NULL,NULL,NULL,'04022920',NULL,'LEITE PARCIALM.DESNATADO,EM PO,MATERIA GORDA>1.5%,ADOC.'),(342,'0402.29.0103','LEITE EM PO DESNAT.GORDURA> 1,5%,ADOCICADO,P/USO INDAL.',NULL,NULL,NULL,NULL,'04022920',NULL,'LEITE PARCIALM.DESNATADO,EM PO,MATERIA GORDA>1.5%,ADOC.'),(343,'0402.29.0199','QQ.OUT.LEITE EM PO,GORDURA> 1.5%,ADOCICADO',NULL,NULL,NULL,NULL,'04022910',NULL,'LEITE INTEGRAL,EM PO,ETC.MATERIA GORDA>1.5%,ADOCICADO'),(344,'0402.29.0199','QQ.OUT.LEITE EM PO,GORDURA> 1.5%,ADOCICADO',NULL,NULL,NULL,NULL,'04022920',NULL,'LEITE PARCIALM.DESNATADO,EM PO,MATERIA GORDA>1.5%,ADOC.'),(345,'0402.29.0200','CREME DE LEITE,EM PO,CONCENTRADO,ADOCICADO,GORDURA>1.5%',NULL,NULL,NULL,NULL,'04022930',NULL,'CREME DE LEITE,EM PO,ETC.MATERIA GORDA>1.5%,ADOCICADO'),(346,'0402.91.0000','LEITE/CREME DE LEITE,N/ADOCICADO,EXC.EM PO/GRANULO/ETC.',NULL,NULL,NULL,NULL,'04029100',NULL,'OUTROS LEITES,CREMES DE LEITE,CONCENTRADOS,N/ADOCICADOS'),(347,'0402.99.0100','LEITE PARCIALMENTE DESIDRATADO (CONDENSADO/EVAPORADO)',NULL,NULL,NULL,NULL,'04029900',NULL,'OUTROS LEITES,CREMES DE LEITE,CONCENTRADOS,ADOCICADOS'),(348,'0402.99.0200','OUTS.CREMES DE LEITE',NULL,NULL,NULL,NULL,'04029900',NULL,'OUTROS LEITES,CREMES DE LEITE,CONCENTRADOS,ADOCICADOS'),(349,'0403.10.0100','IOGURTE NAO CONCENTRADO NEM ADOCICADO',NULL,NULL,NULL,NULL,'04031000',NULL,'IOGURTE'),(350,'0403.10.0200','IOGURTE ADICIONADO DE SUBSTANCIA AROMATICA/FRUTAS',NULL,NULL,NULL,NULL,'04031000',NULL,'IOGURTE'),(351,'0403.10.9900','OUTS.IOGURTES',NULL,NULL,NULL,NULL,'04031000',NULL,'IOGURTE'),(352,'0403.90.0100','CREME DE LEITE,FERMENTADO/ACIDIFICADO',NULL,NULL,NULL,NULL,'04039000',NULL,'LEITELHO,LEITE,CREME DE LEITE,COALHADOS,FERMENTADOS,ETC'),(353,'0403.90.9900','LEITELHO/LEITE/COALHADA/ETC.FERMENTADOS/ACIDIFICADOS',NULL,NULL,NULL,NULL,'04039000',NULL,'LEITELHO,LEITE,CREME DE LEITE,COALHADOS,FERMENTADOS,ETC'),(354,'0404.10.0100','SORO DE LEITE N/CONCENTR.N/ACUCAR.RECIP.METAL.FECHADO',NULL,NULL,NULL,NULL,'04041000',NULL,'SORO DE LEITE,MODIFICADO OU NAO,MESMO CONCENTRADO,ADOC.'),(355,'0404.10.9900','OUTS.SOROS DE LEITE MESMO CONCENTRADOS/ADOCICADOS',NULL,NULL,NULL,NULL,'04041000',NULL,'SORO DE LEITE,MODIFICADO OU NAO,MESMO CONCENTRADO,ADOC.'),(356,'0404.90.0100','PRODS.DO LEITE N/CONCENTR.N/ACUCAR.RECIP.METAL.FECHADO',NULL,NULL,NULL,NULL,'04049000',NULL,'OUTROS PRODS.CONSTITUIDOS DO LEITE,MESMO ADOCICADOS,ETC'),(357,'0404.90.9900','OUTS.PRODS.DO LEITE MESMO CONCENTRADOS/ADOCICADOS',NULL,NULL,NULL,NULL,'04049000',NULL,'OUTROS PRODS.CONSTITUIDOS DO LEITE,MESMO ADOCICADOS,ETC'),(358,'0405.00.0100','MANTEIGA NATURAL,FRESCA OU SALGADA',NULL,NULL,NULL,NULL,'04051000',NULL,'MANTEIGA'),(359,'0405.00.0200','OLEO DE MANTEIGA (\"BUTTER-OIL\")',NULL,NULL,NULL,NULL,'04059010',NULL,'OLEO BUTIRICO DE MANTEIGA (\"BUTTER OIL\")'),(360,'0405.00.9900','OUTS.MATERIAS GORDAS PROVENIENTES DO LEITE',NULL,NULL,NULL,NULL,'04052000',NULL,'PASTAS DE ESPALHAR (BARRAR) DE PRODS.PROVEN.DO LEITE'),(361,'0405.00.9900','OUTS.MATERIAS GORDAS PROVENIENTES DO LEITE',NULL,NULL,NULL,NULL,'04059090',NULL,'OUTRAS MATERIAS GORDAS PROVENIENTES DO LEITE'),(362,'0406.10.0100','REQUEIJAO',NULL,NULL,NULL,NULL,'04061090',NULL,'OUTS.QUEIJOS FRESCOS (NAO CURADOS),INCL.REQUEIJAO,ETC.'),(363,'0406.10.0200','QUEIJOS FRESCOS,TIPO MINAS',NULL,NULL,NULL,NULL,'04061090',NULL,'OUTS.QUEIJOS FRESCOS (NAO CURADOS),INCL.REQUEIJAO,ETC.'),(364,'0406.10.0300','QUEIJOS TIPO MUSSARELA,FRESCOS',NULL,NULL,NULL,NULL,'04061010',NULL,'QUEIJO TIPO MUSSARELA,FRESCO (NAO CURADO)'),(365,'0406.10.9900','QUEIJOS FRESCOS,NAO CURADOS,EXC.TIPO MINAS/REQUEIJAO',NULL,NULL,NULL,NULL,'04061090',NULL,'OUTS.QUEIJOS FRESCOS (NAO CURADOS),INCL.REQUEIJAO,ETC.'),(366,'0406.20.0000','QUEIJOS RALADOS OU EM PO,DE QUALQUER TIPO',NULL,NULL,NULL,NULL,'04062000',NULL,'QUEIJOS RALADOS OU EM PO,DE QUALQUER TIPO'),(367,'0406.30.0000','QUEIJOS FUNDIDOS,EXCETO RALADOS OU EM PO',NULL,NULL,NULL,NULL,'04063000',NULL,'QUEIJOS FUNDIDOS,EXCETO RALADOS OU EM PO'),(368,'0406.40.0100','QUEIJOS DE PASTA MOFADA (AZUL),TIPO GORGONZOLA',NULL,NULL,NULL,NULL,'04064000',NULL,'QUEIJOS DE PASTA MOFADA (AZUL)'),(369,'0406.40.9900','QUEIJOS DE PASTA MOFADA (AZUL),EXC.TIPO GORGONZOLA',NULL,NULL,NULL,NULL,'04064000',NULL,'QUEIJOS DE PASTA MOFADA (AZUL)'),(370,'0406.90.0100','QUEIJOS TIPO BELPAESE',NULL,NULL,NULL,NULL,'04069030',NULL,'QUEIJOS CONT.46%<=TEOR DE UMIDADE<55%,(MASSA MACIA)'),(371,'0406.90.0200','QUEIJOS TIPO COBOCO',NULL,NULL,NULL,NULL,'04069090',NULL,'OUTROS QUEIJOS'),(372,'0406.90.0300','QUEIJOS TIPO DAMBO',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(373,'0406.90.0400','QUEIJOS TIPO EDAN (RENO OU PALMIRA)',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(374,'0406.90.0500','QUEIJOS TIPO ESTEPE',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(375,'0406.90.0600','QUEIJOS TIPO FANTINA',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(376,'0406.90.0700','QUEIJOS TIPO GOUDA',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(377,'0406.90.0800','QUEIJOS TIPO GRUIERE',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(378,'0406.90.0900','QUEIJOS TIPO MONTANHES',NULL,NULL,NULL,NULL,'04069090',NULL,'OUTROS QUEIJOS'),(379,'0406.90.1100','QUEIJOS TIPO PARMESAO',NULL,NULL,NULL,NULL,'04069010',NULL,'QUEIJOS CONT.TEOR DE UMIDADE<36%,EM PESO (MASSA DURA)'),(380,'0406.90.1200','QUEIJOS TIPO PRATO',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(381,'0406.90.1300','QUEIJOS TIPO PROVOLONE',NULL,NULL,NULL,NULL,'04069010',NULL,'QUEIJOS CONT.TEOR DE UMIDADE<36%,EM PESO (MASSA DURA)'),(382,'0406.90.1400','QUEIJOS TIPO SICILIANO',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(383,'0406.90.9900','OUTS.QUEIJOS',NULL,NULL,NULL,NULL,'04069010',NULL,'QUEIJOS CONT.TEOR DE UMIDADE<36%,EM PESO (MASSA DURA)'),(384,'0406.90.9900','OUTS.QUEIJOS',NULL,NULL,NULL,NULL,'04069020',NULL,'QUEIJOS CONT.36%<=TEOR DE UMIDADE<46%,(MASSA SEMIDURA)'),(385,'0406.90.9900','OUTS.QUEIJOS',NULL,NULL,NULL,NULL,'04069030',NULL,'QUEIJOS CONT.46%<=TEOR DE UMIDADE<55%,(MASSA MACIA)'),(386,'0406.90.9900','OUTS.QUEIJOS',NULL,NULL,NULL,NULL,'04069090',NULL,'OUTROS QUEIJOS'),(387,'0407.00.0101','OVOS DE GALINHA,FRESCOS,PARA INCUBACAO',NULL,NULL,NULL,NULL,'04070011',NULL,'OVOS DE GALINHA,PARA INCUBACAO'),(388,'0407.00.0199','QQ.OUT.OVO DE GALINHA,FRESCO,EX.P/INCUBACAO',NULL,NULL,NULL,NULL,'04070090',NULL,'OUTROS OVOS DE AVES,COM CASCA,FRESCOS,CONSERVAD.COZIDOS'),(389,'0407.00.0201','OVOS DE OUTS.AVES,FRESCOS,PARA INCUBACAO',NULL,NULL,NULL,NULL,'04070019',NULL,'OVOS DE OUTRAS AVES,PARA INCUBACAO'),(390,'0407.00.0299','QQ.OUT.OVO DE OUTS.AVES,FRESCO,EX.P/INCUBACAO',NULL,NULL,NULL,NULL,'04070090',NULL,'OUTROS OVOS DE AVES,COM CASCA,FRESCOS,CONSERVAD.COZIDOS'),(391,'0407.00.9900','OVOS DE AVES,C/CASCA,CONSERVADOS/COZIDOS',NULL,NULL,NULL,NULL,'04070090',NULL,'OUTROS OVOS DE AVES,COM CASCA,FRESCOS,CONSERVAD.COZIDOS'),(392,'0408.11.0000','GEMAS DE OVOS,SECAS',NULL,NULL,NULL,NULL,'04081100',NULL,'GEMAS DE OVOS,SECAS'),(393,'0408.19.0100','GEMAS DE OVOS,FRESCAS',NULL,NULL,NULL,NULL,'04081900',NULL,'GEMAS DE OVOS,FRESCAS,COZIDAS EM AGUA OU VAPOR,ETC.'),(394,'0408.19.9900','GEMAS DE OVOS,COZIDAS EM AGUA/VAPOR,CONGELADAS,MOLDADAS',NULL,NULL,NULL,NULL,'04081900',NULL,'GEMAS DE OVOS,FRESCAS,COZIDAS EM AGUA OU VAPOR,ETC.'),(395,'0408.91.0000','OVOS DE AVES,S/CASCA,SECOS',NULL,NULL,NULL,NULL,'04089100',NULL,'OVOS DE AVES,SEM CASCA,SECOS'),(396,'0408.99.0101','OVOS DE AVES,S/CASCA,FRESCOS,P/CONSUMO',NULL,NULL,NULL,NULL,'04089900',NULL,'OUTS.OVOS DE AVES,SEM CASCA,FRESCOS,COZIDOS EM AGUA,ETC'),(397,'0408.99.0199','QQ.OUT.OVO DE AVES,FRESCO,S/CASCA,EXC.P/CONSUMO',NULL,NULL,NULL,NULL,'04089900',NULL,'OUTS.OVOS DE AVES,SEM CASCA,FRESCOS,COZIDOS EM AGUA,ETC'),(398,'0408.99.9900','OVOS DE AVES,S/CASCA,COZIDOS EM AGUA/VAPOR,CONSERVADOS/',NULL,NULL,NULL,NULL,'04089900',NULL,'OUTS.OVOS DE AVES,SEM CASCA,FRESCOS,COZIDOS EM AGUA,ETC'),(399,'0409.00.0000','MEL NATURAL',NULL,NULL,NULL,NULL,'04090000',NULL,'MEL NATURAL'),(400,'0410.00.0000','OUTS.PRODS.COMESTIVEIS DE ORIGEM ANIMAL',NULL,NULL,NULL,NULL,'04100000',NULL,'OUTROS PRODUTOS COMESTIVEIS DE ORIGEM ANIMAL'),(401,'0501.00.0000','CABELOS EM BRUTO,E DESPERDICIOS DE CABELO',NULL,NULL,NULL,NULL,'05010000',NULL,'CABELOS EM BRUTO E DESPERDICIOS DE CABELO'),(402,'0502.10.0101','CERDAS DE PORCO,EM BRUTO',NULL,NULL,NULL,NULL,'05021019',NULL,'OUTRAS CERDAS DE PORCO E SEUS DESPERDICIOS'),(403,'0502.10.0102','CERDAS DE PORCO,LAVADAS,ALVEJADAS OU DESENGORDURADAS',NULL,NULL,NULL,NULL,'05021011',NULL,'CERDAS DE PORCO,LAVADAS,ALVEJADAS OU DESENGORDURADAS'),(404,'0502.10.0199','QQ.OUT.CERDA DE PORCO E SEUS DESPERDICIOS',NULL,NULL,NULL,NULL,'05021019',NULL,'OUTRAS CERDAS DE PORCO E SEUS DESPERDICIOS'),(405,'0502.10.9900','CERDAS DE JAVALI E SEUS DESPERDICIOS',NULL,NULL,NULL,NULL,'05021090',NULL,'CERDAS DE JAVALI E SEUS DESPERDICIOS'),(406,'0502.90.0101','PELOS P/ESCOVAS/PINCEIS/ETC.LAVADOS/ALVEJADOS/DESENGORD',NULL,NULL,NULL,NULL,'05029010',NULL,'PELOS DE TEXUGO E OUTROS PELOS P/ESCOVAS,PINCEIS,ETC.'),(407,'0502.90.0199','QQ.OUT.PELO P/ESCOVAS/PINCEIS/ARTEFS.SEMELHS.',NULL,NULL,NULL,NULL,'05029010',NULL,'PELOS DE TEXUGO E OUTROS PELOS P/ESCOVAS,PINCEIS,ETC.'),(408,'0502.90.9900','DESPERDS.DE PELOS P/ESCOVAS/PINCEIS/ETC.',NULL,NULL,NULL,NULL,'05029020',NULL,'DESPERDICIOS DE PELOS'),(409,'0503.00.0101','CRINAS EM BRUTO',NULL,NULL,NULL,NULL,'05030000',NULL,'CRINAS E SEUS DESPERDICIOS,MESMO EM MANTAS'),(410,'0503.00.0102','CRINAS SIMPLESMENTE LAVADAS/DESENGORDURADAS',NULL,NULL,NULL,NULL,'05030000',NULL,'CRINAS E SEUS DESPERDICIOS,MESMO EM MANTAS'),(411,'0503.00.0103','CRINAS BRANQUEADAS,TINTAS,FRISADAS OU NAO',NULL,NULL,NULL,NULL,'05030000',NULL,'CRINAS E SEUS DESPERDICIOS,MESMO EM MANTAS'),(412,'0503.00.0199','QQ.OUT.CRINA,MESMO EM MANTA,COM/SEM SUPORTE',NULL,NULL,NULL,NULL,'05030000',NULL,'CRINAS E SEUS DESPERDICIOS,MESMO EM MANTAS'),(413,'0503.00.0200','DESPERDS.DE CRINAS',NULL,NULL,NULL,NULL,'05030000',NULL,'CRINAS E SEUS DESPERDICIOS,MESMO EM MANTAS'),(414,'0504.00.0101','TRIPAS DE BOVINO,FRESCAS',NULL,NULL,NULL,NULL,'05040011',NULL,'TRIPAS DE BOVINOS,FRESCAS,REFRIG.CONGEL.SALG.DEFUMADAS'),(415,'0504.00.0102','TRIPAS DE BOVINO,SALGADAS',NULL,NULL,NULL,NULL,'05040011',NULL,'TRIPAS DE BOVINOS,FRESCAS,REFRIG.CONGEL.SALG.DEFUMADAS'),(416,'0504.00.0103','TRIPAS DE BOVINO,SECAS',NULL,NULL,NULL,NULL,'05040011',NULL,'TRIPAS DE BOVINOS,FRESCAS,REFRIG.CONGEL.SALG.DEFUMADAS'),(417,'0504.00.0200','TRIPAS DE OVINO',NULL,NULL,NULL,NULL,'05040012',NULL,'TRIPAS DE OVINOS,FRESCAS,REFRIG.CONGEL.SALGAD.DEFUMADAS'),(418,'0504.00.0300','TRIPAS DE SUINO',NULL,NULL,NULL,NULL,'05040013',NULL,'TRIPAS DE SUINOS,FRESCAS,REFRIG.CONGEL.SALGAD.DEFUMADAS'),(419,'0504.00.0400','BUCHOS DE ANIMAIS,EXCETO DE PEIXES',NULL,NULL,NULL,NULL,'05040090',NULL,'BEXIGAS E ESTOMAGOS,DE ANIMAIS,EXC.PEIXES,FRESCAS,ETC.'),(420,'0504.00.9900','OUTS.TRIPAS,ESTOMAGOS,BEXIGAS DE ANIMAIS,EXC.DE PEIXES',NULL,NULL,NULL,NULL,'05040019',NULL,'TRIPAS DE OUTROS ANIMAIS,EXC.PEIXES,FRESCAS,REFRIG.ETC.'),(421,'0504.